/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.neeve.lang.XShortArrayIterator;
import com.neeve.lang.XShortIterator;
import com.neeve.pkt.PktBuffer;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufVariableLengthField;
import java.util.Arrays;
import java.util.NoSuchElementException;

public final class XbufShortArrayField
extends XbufVariableLengthField<short[]> {
    private final Iterator iterator = new Iterator();

    private XbufShortArrayField(short id, String name) {
        super(XbufField.Type.SHORT_ARRAY, id, name);
    }

    public static XbufShortArrayField create(short id, String name) {
        return new XbufShortArrayField(id, name);
    }

    @Override
    protected final int serializedLength(short[] val) {
        return val == null ? 0 : val.length * 2;
    }

    @Override
    protected final int serialize(PktBuffer buffer, int offset, short[] val) {
        buffer.putFrom(offset, val, 0, val.length);
        return val.length * 2;
    }

    @Override
    protected final short[] deserialize(PktBuffer buffer, int offset, int length) {
        short[] val = new short[length / 2];
        if (length > 0) {
            buffer.getTo(offset, val, 0, val.length);
        }
        return val;
    }

    public final void setValues(short[] values) {
        super.setValue(values);
    }

    public final short[] getValuesAsArray() {
        return (short[])super.getValue();
    }

    public final void setValuesFrom(XShortIterator val) {
        short[] v;
        if (val instanceof Iterator) {
            v = ((Iterator)val).array();
        } else if (val instanceof XShortArrayIterator) {
            XShortArrayIterator a = (XShortArrayIterator)val;
            v = a.array();
            if (v.length != a.length()) {
                v = new short[a.length()];
                System.arraycopy(a.array(), a.offset(), v, 0, a.length());
            }
        } else {
            int size = 0;
            val.toFirst();
            while (val.hasNext()) {
                ++size;
                val.next();
            }
            v = new short[size];
            val.toFirst();
            for (int i = 0; i < v.length; ++i) {
                v[i] = val.next();
            }
        }
        this.setValue(v);
        val.toFirst();
    }

    public final void addValue(short val) {
        short[] vArray;
        short[] existing = (short[])this.getValue();
        if (this.getValue() == null) {
            vArray = new short[1];
        } else {
            vArray = new short[existing.length + 1];
            System.arraycopy(existing, 0, vArray, 0, existing.length);
            vArray[vArray.length - 1] = val;
        }
        this.setValue(vArray);
    }

    public final Iterator getValueIterator() {
        return this.iterator.toFirst();
    }

    @Override
    protected final String toString(short[] val) {
        return Arrays.toString(val);
    }

    public final class Iterator
    implements XShortIterator {
        int current = 0;

        public short[] array() {
            return (short[])XbufShortArrayField.this.getValue();
        }

        public final boolean hasNext() {
            short[] value = (short[])XbufShortArrayField.this.getValue();
            return value != null && this.current < value.length;
        }

        public short next() {
            short[] val = (short[])XbufShortArrayField.this.getValue();
            if (val == null) {
                throw new NoSuchElementException();
            }
            return ((short[])XbufShortArrayField.this.getValue())[this.current++];
        }

        public final void remove() {
            throw new UnsupportedOperationException("remove is not supported for xbuf field iterators.");
        }

        public final Iterator toFirst() {
            this.current = 0;
            return this;
        }
    }
}

