/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.neeve.pkt.PktBuffer;
import com.neeve.xbuf.XbufField;

public final class XbufFloatField
extends XbufField {
    private final Value value = new Value();

    private XbufFloatField(short id, String name, boolean pinned) {
        super(XbufField.Type.FLOAT, id, name, pinned);
    }

    public static final XbufFloatField create(short id, String name, boolean pinned) {
        return new XbufFloatField(id, name, pinned);
    }

    final int serializedLength(float val) {
        return 4;
    }

    final int serialize(PktBuffer buffer, int offset, float val) {
        buffer.putFloat(offset, val);
        return 4;
    }

    final float deserialize(PktBuffer buffer, int offset) {
        return buffer.getFloat(offset);
    }

    final String toString(float val) {
        return String.valueOf(val);
    }

    @Override
    protected final int contentSync(PktBuffer buffer, int offset) {
        return this.serialize(buffer, offset, this.getValue());
    }

    @Override
    protected final int contentDesync(PktBuffer buffer, int offset, int length) {
        if (length != 4) {
            throw new InternalError("request to deserialize float with length != 4 (length=" + length + ")");
        }
        this.value.val = this.deserialize(buffer, offset);
        this.container.setValue(this, this.value);
        return 4;
    }

    @Override
    protected final int contentLength() {
        return 4;
    }

    @Override
    protected final String contentAsString() {
        return this.toString(this.getValue());
    }

    @Override
    protected final boolean contentClear() {
        if (this.pinned) {
            this.serialize(this.buffer, this.contentOffset, 0.0f);
            return true;
        }
        this.value.val = 0.0f;
        return this.container.clearValue(this);
    }

    public final void setValue(float val) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        if (this.pinned) {
            this.serialize(this.buffer, this.contentOffset, val);
        } else {
            this.value.val = val;
            this.container.setValue(this, this.value);
        }
    }

    public final void setValueFrom(XbufFloatField field) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        if (field == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
        throw new UnsupportedOperationException();
    }

    public final float getValue() {
        if (this.container == null) {
            throw new IllegalStateException("cannot get value for a field not in a container");
        }
        if (this.pinned || this.container.framed[this.index]) {
            return this.deserialize(this.buffer, this.contentOffset);
        }
        Value value = (Value)this.container.fieldValues[this.index];
        return value != null ? value.val : 0.0f;
    }

    static final int serializeField(PktBuffer buffer, int offset, short id, float v) {
        int headerLength = XbufFloatField.syncHeader(buffer, offset, id, XbufField.Type.FLOAT, 4);
        buffer.putFloat(offset + headerLength, v);
        return headerLength + 4;
    }

    public static int serializedFieldLength(short id, float v) {
        return 8 + XbufFloatField.headerLength(id, XbufField.Type.FLOAT, 4);
    }

    static final float deserializeValue(PktBuffer buffer, int offset, XbufField.VarintDesyncLength varintDesyncLength) {
        varintDesyncLength.value = 4;
        return buffer.getFloat(offset);
    }

    static final float deserializeField(PktBuffer buffer, int offset, short id, XbufField.VarintDesyncLength varintDesyncLength) {
        int tag = XbufFloatField.desyncVarint32(buffer, offset, varintDesyncLength);
        int tagLength = varintDesyncLength.value;
        if (id != XbufFloatField.fieldId(tag)) {
            throw new IllegalArgumentException("attempt to desync a field using a different field on the wire!");
        }
        float value = XbufFloatField.deserializeValue(buffer, offset + tagLength, varintDesyncLength);
        varintDesyncLength.value += tagLength;
        return value;
    }

    private final class Value {
        float val;

        private Value() {
        }
    }
}

