/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.lang.XBooleanIterator;
import com.neeve.quark.QuarkBooleanArrayDeserializer;
import com.neeve.quark.QuarkBuffer;
import java.util.NoSuchElementException;

public final class XBooleanSequence
implements XBooleanIterator {
    private static final byte FLG_INITIALIZED = 1;
    private static final byte FLG_OWNED = 2;
    private byte _flags;
    private long _addr;
    private int _offset;
    private int _nelem;
    private int _index;

    private XBooleanSequence() {
    }

    public static final XBooleanSequence create() {
        return new XBooleanSequence();
    }

    private final XBooleanSequence setInitialized(boolean val) {
        this._flags = val ? (byte)(this._flags | 1) : (byte)(this._flags & 0xFFFFFFFE);
        return this;
    }

    public final boolean isInitialized() {
        return (this._flags & 1) != 0;
    }

    private final XBooleanSequence setOwned(boolean val) {
        this._flags = val ? (byte)(this._flags | 2) : (byte)(this._flags & 0xFFFFFFFD);
        return this;
    }

    public final boolean isOwned() {
        return (this._flags & 2) != 0;
    }

    public XBooleanIterator toFirst() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        this._index = 0;
        return this;
    }

    public final boolean hasNext() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        return this._index < this._nelem;
    }

    public final boolean next() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        if (this._index == this._nelem) {
            throw new NoSuchElementException("no more elements");
        }
        return QuarkBuffer.getByte((long)this._addr, (int)(this._offset + this._index++ * 1)) == 1;
    }

    public final void remove() {
        throw new UnsupportedOperationException();
    }

    public final XBooleanSequence wrap(long addr, int offset, int len) {
        this.reset();
        this._addr = addr;
        this._offset = offset;
        this._nelem = len;
        this._index = 0;
        this.setInitialized(true).setOwned(false);
        return this;
    }

    public final XBooleanSequence wrap(QuarkBuffer buffer, int offset, int len) {
        return this.wrap(buffer.getNativeAddress(), offset, len);
    }

    public final XBooleanSequence setFrom(long addr, int offset, int len) {
        this.reset();
        this._addr = QuarkBuffer.allocateMemoryBlock((long)len, (boolean)false);
        QuarkBuffer.copy((long)addr, (int)offset, (long)this._addr, (int)0, (int)len);
        this._nelem = len;
        this._offset = 0;
        this._index = 0;
        this.setInitialized(true).setOwned(true);
        return this;
    }

    public final XBooleanSequence setFrom(QuarkBuffer buffer, int offset, int len) {
        this.reset();
        this._addr = QuarkBuffer.allocateMemoryBlock((long)len, (boolean)false);
        QuarkBuffer.copy((long)buffer.getNativeAddress(), (int)offset, (long)this._addr, (int)0, (int)len);
        this._nelem = len;
        this._offset = 0;
        this._index = 0;
        this.setInitialized(true).setOwned(true);
        return this;
    }

    public final XBooleanSequence setFrom(XBooleanSequence sequence) {
        this.reset();
        if (sequence.isInitialized()) {
            int serializedLength = sequence.serializedLength();
            this._addr = QuarkBuffer.allocateMemoryBlock((long)serializedLength, (boolean)false);
            QuarkBuffer.copy((long)sequence._addr, (int)0, (long)this._addr, (int)0, (int)serializedLength);
            this._nelem = sequence.numElements();
            this._offset = 0;
            this._index = 0;
            this.setInitialized(true).setOwned(true);
        }
        return this;
    }

    public final XBooleanSequence setFrom(XBooleanIterator iterator) {
        this.reset();
        if (iterator instanceof XBooleanSequence) {
            return this.setFrom((XBooleanSequence)iterator);
        }
        if (!(iterator instanceof QuarkBooleanArrayDeserializer)) {
            throw new IllegalArgumentException("iterator implementations other than XBooleanSequence and QuarkBooleanArrayDeserializer are not currently supported");
        }
        QuarkBooleanArrayDeserializer deserializer = (QuarkBooleanArrayDeserializer)iterator;
        this._addr = QuarkBuffer.allocateMemoryBlock((long)deserializer.serializedLength(), (boolean)false);
        deserializer.getTo(this._addr, 0);
        this._nelem = deserializer.numElements();
        this._offset = 0;
        this._index = 0;
        this.setInitialized(true).setOwned(true);
        return this;
    }

    public final int numElements() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        return this._nelem;
    }

    public final int serializedLength() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        return this._nelem * 1;
    }

    public final int getTo(boolean[] val, int offset) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        XBooleanIterator iterator = this.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            val[offset + i] = iterator.next();
            ++i;
        }
        return this.serializedLength();
    }

    public final int getTo(byte[] val, int offset) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        int serializedLength = this.serializedLength();
        QuarkBuffer.getTo((long)this._addr, (int)this._offset, (byte[])val, (int)offset, (int)serializedLength);
        return serializedLength;
    }

    public final int getTo(long addr, int offset) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        int serializedLength = this.serializedLength();
        QuarkBuffer.copy((long)this._addr, (int)this._offset, (long)addr, (int)offset, (int)serializedLength);
        return serializedLength;
    }

    public final int getTo(QuarkBuffer val, int offset) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        int serializedLength = this.serializedLength();
        val.putFrom(offset, this._addr, this._offset, serializedLength);
        return serializedLength;
    }

    public final XBooleanIterator iterator() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        return this.toFirst();
    }

    public final XBooleanSequence reset() {
        if (this.isInitialized()) {
            if (this.isOwned() && this._addr != 0L) {
                QuarkBuffer.freeMemoryBlock((long)this._addr, (long)this.serializedLength());
            }
            this.setInitialized(false);
        }
        return this;
    }
}

