/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm;

import com.neeve.adm.AdmCollection;
import com.neeve.adm.AdmDocumentedType;
import com.neeve.adm.AdmEncodingType;
import com.neeve.adm.AdmEntity;
import com.neeve.adm.AdmFactoryType;
import com.neeve.adm.AdmGenerator;
import com.neeve.adm.AdmMessage;
import com.neeve.adm.AdmModel;
import com.neeve.adm.AdmScopedType;
import com.neeve.adm.AdmSourceCodeBuilder;
import com.neeve.adm.EAdmException;
import com.neeve.build.codegen.CgSourceCodeErrorAggregator;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;

public final class AdmFactory
extends AdmDocumentedType {
    private final AdmModel model;
    private final String namespace;
    private final String name;
    private final int id;
    private final HashMap<String, AdmFactoryType> types;
    private boolean containsMessage;
    private boolean containsType;
    static final int MAX_TYPES_PER_FACTORY = Short.MAX_VALUE;
    static final int MAX_FACTORY_ID = 65538;
    static final int FIRST_DYNAMIC_PLATFORM_FACTORY_ID = 32;
    static final int FIRST_VALID_MODEL_PLATFORM_FACTORY_ID = 0;
    static final int LAST_VALID_MODEL_PLATFORM_FACTORY_ID = -65506;
    static final int FIRST_VALID_MODEL_USER_FACTORY_ID = 1;
    static final int LAST_VALID_MODEL_USER_FACTORY_ID = 65538;

    public AdmFactory(AdmModel model, String namespace, String name, int id) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("namespace cannot be null");
        }
        this.name = name;
        this.model = model;
        this.namespace = namespace;
        this.id = id;
        this.types = new HashMap();
    }

    private final String protobufName(AdmScopedType type) {
        return type.getModel().getProtobufOuterClassName() + "." + type.getName();
    }

    private final AdmFactoryType getTypeById(int id) {
        for (AdmFactoryType type : this.types.values()) {
            if (type.getId() != id) continue;
            return type;
        }
        return null;
    }

    private final boolean isPlatformFactory() {
        return this.getId() <= 0;
    }

    private final int calcPacketId(int id) throws EAdmException {
        if (id < 0 || id > Short.MAX_VALUE) {
            throw new EAdmException("a type's id must be between 0 and 32767 both inclusive", this.getCodeSource());
        }
        if (this.isPlatformFactory()) {
            return this.calcFactoryId() * Short.MAX_VALUE + id + 4096;
        }
        return this.calcFactoryId() * Short.MAX_VALUE - id;
    }

    private final void writeClassDeclaration(AdmSourceCodeBuilder codeBuilder, AdmEncodingType encodingType) {
        AdmGenerator.writeJavadocTypeComment("", this, codeBuilder);
        AdmGenerator.writeAdmGeneratedAnnotations(((Object)((Object)this)).getClass(), encodingType, this.model, codeBuilder);
        codeBuilder.last().appendln("final public class " + this.getName() + " implements %{com.neeve.ods.IStoreObjectFactory}, %{com.neeve.sma.MessageViewFactory} {");
    }

    private final void writeIds(AdmSourceCodeBuilder codeBuilder, AdmEncodingType encodingType) throws EAdmException {
        AdmFactoryType type;
        codeBuilder.last().appendln("    /*");
        codeBuilder.last().appendln("     * IDs of the various factories implemented by this class");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    /**");
        codeBuilder.last().appendln("     * This factory's {@link %{com.neeve.ods.IStoreObjectFactory}} id.");
        codeBuilder.last().appendln("     * <p>");
        codeBuilder.last().appendln("     * The store factory ID is used to register the object in the {@link com.neeve.ods.StoreObjectFactoryRegistry}}");
        codeBuilder.last().appendln("     * used by ODS stores for deserializing objects.");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    final public static short OFID = " + this.calcFactoryId() + ";");
        if (this.containsMessage) {
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * This factory's {@link %{com.neeve.sma.MessageViewFactory}} id.");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * The message factory ID is used to register the object in the {@link com.neeve.sma.MessageViewFactoryRegistry}}");
            codeBuilder.last().appendln("     * used by SMA binding for deserializing received messages.");
            codeBuilder.last().appendln("     */");
            codeBuilder.last().appendln("    final public static short VFID = " + this.calcFactoryId() + ";");
        } else {
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * Not used for this factory as it contains no message types.");
            codeBuilder.last().appendln("     */");
            codeBuilder.last().appendln("    final public static short VFID = 0;");
        }
        if (this.containsType) {
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * This factory's type factory id.");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This id is reserved for platform internal use.");
            codeBuilder.last().appendln("     */");
            codeBuilder.last().appendln("    final public static short TFID = " + this.calcFactoryId() + ";");
        } else {
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * This factory's type factory id.");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This id is reserved for platform internal use.");
            codeBuilder.last().appendln("     */");
            codeBuilder.last().appendln("    final public static short TFID = 0;");
        }
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("    /*");
        codeBuilder.last().appendln("     * Object ids (unique within the factory) ");
        codeBuilder.last().appendln("     */");
        Iterator<AdmFactoryType> iterator = this.typeIterator();
        while (iterator.hasNext()) {
            type = iterator.next();
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * Defines the {@link " + type.getName() + "} type id.");
            codeBuilder.last().appendln("     */");
            codeBuilder.last().appendln("    final public static short ID_" + type.getName() + " = (short)" + type.getId() + ";");
        }
        if (encodingType == AdmEncodingType.Xbuf || encodingType == AdmEncodingType.Xbuf2) {
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /*");
            codeBuilder.last().appendln("     * Object packet ids (unique within the system) ");
            codeBuilder.last().appendln("     */");
            iterator = this.typeIterator();
            while (iterator.hasNext()) {
                type = iterator.next();
                if (type instanceof AdmCollection) continue;
                codeBuilder.last().appendln("    /**");
                codeBuilder.last().appendln("     * Defines the {@link " + type.getName() + "} backing packet id type.");
                codeBuilder.last().appendln("     * <p>");
                codeBuilder.last().appendln("     * {@link " + type.getName() + "} are backet by a packet which is used for");
                codeBuilder.last().appendln("     * efficient transport, serialization and pooling. This constants defines");
                codeBuilder.last().appendln("     * the unique packet type id.");
                codeBuilder.last().appendln("     */");
                codeBuilder.last().appendln("    final public static int PKTID_" + type.getName() + " = " + this.calcPacketId(type.getId()) + ";");
            }
        }
    }

    private final void writeConstructors(AdmSourceCodeBuilder codeBuilder, AdmEncodingType encodingType) {
        codeBuilder.last().appendln("    /*");
        codeBuilder.last().appendln("     * Static constructor.");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    final static %{com.fasterxml.jackson.databind.ObjectMapper} mapper;");
        codeBuilder.last().appendln("    static {");
        codeBuilder.last().appendln("        mapper = new %{com.fasterxml.jackson.databind.ObjectMapper}();");
        codeBuilder.last().appendln("        mapper.configure(%{com.fasterxml.jackson.databind.MapperFeature}.USE_ANNOTATIONS, true).");
        codeBuilder.last().appendln("               configure(%{com.fasterxml.jackson.databind.MapperFeature}.AUTO_DETECT_GETTERS, false).");
        codeBuilder.last().appendln("               configure(%{com.fasterxml.jackson.databind.MapperFeature}.AUTO_DETECT_IS_GETTERS, false).");
        codeBuilder.last().appendln("               configure(%{com.fasterxml.jackson.databind.MapperFeature}.AUTO_DETECT_FIELDS, false).");
        codeBuilder.last().appendln("               configure(%{com.fasterxml.jackson.databind.MapperFeature}.AUTO_DETECT_SETTERS, false).");
        codeBuilder.last().appendln("               configure(%{com.fasterxml.jackson.databind.MapperFeature}.AUTO_DETECT_CREATORS, false).");
        codeBuilder.last().appendln("               configure(%{com.fasterxml.jackson.databind.MapperFeature}.USE_GETTERS_AS_SETTERS, true).");
        codeBuilder.last().appendln("               configure(%{com.fasterxml.jackson.databind.DeserializationFeature}.FAIL_ON_UNKNOWN_PROPERTIES, false).");
        codeBuilder.last().appendln("               configure(%{com.fasterxml.jackson.databind.DeserializationFeature}.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true).");
        codeBuilder.last().appendln("               configure(%{com.fasterxml.jackson.databind.SerializationFeature}.FAIL_ON_EMPTY_BEANS, false).");
        codeBuilder.last().appendln("               configure(%{com.fasterxml.jackson.databind.SerializationFeature}.INDENT_OUTPUT, %{com.neeve.ci.XRuntime}.getValue(\"nv.indent.json\", false));");
        if (encodingType == AdmEncodingType.Xbuf || encodingType == AdmEncodingType.Xbuf2) {
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("        /*");
            codeBuilder.last().appendln("         * Register packet types");
            codeBuilder.last().appendln("         */");
            Iterator<AdmFactoryType> iterator = this.typeIterator();
            while (iterator.hasNext()) {
                AdmFactoryType type = iterator.next();
                if (type instanceof AdmCollection) continue;
                codeBuilder.last().appendln("         %{com.neeve.pkt.PktFactory}.getInstance().registerPacketType(%{com.neeve.pkt.PktFactory}.PktType.create(PKTID_" + type.getName() + ",");
                codeBuilder.last().appendln("                                                                               \"" + type.getName() + encodingType.toString() + "Packet." + this.getId() + "." + type.getId() + "\",");
                codeBuilder.last().appendln("                                                                               \"" + type.getFullName() + "$PacketBody\",");
                codeBuilder.last().appendln("                                                                               %{com.neeve.pkt.PktConstants}.SERIALIZE_POLICY_DEFAULT,");
                codeBuilder.last().appendln("                                                                               %{com.neeve.pkt.PktConstants}.DESERIALIZE_POLICY_DEFAULT,");
                if (encodingType == AdmEncodingType.Xbuf) {
                    codeBuilder.last().appendln("                                                                               %{com.neeve.xbuf.XbufHeuristics}.getProperty(" + type.getName() + ".class, \"pool.shouldpool\", true),");
                    codeBuilder.last().appendln("                                                                               %{com.neeve.xbuf.XbufHeuristics}.configurePoolParams(" + type.getName() + ".class, %{com.neeve.util.UtlPool}.Params.create()),");
                } else if (encodingType == AdmEncodingType.Xbuf2) {
                    codeBuilder.last().appendln("                                                                               %{com.neeve.xbuf2.XbufHeuristics}.getProperty(" + type.getName() + ".class, \"pool.shouldpool\", true),");
                    codeBuilder.last().appendln("                                                                               %{com.neeve.xbuf2.XbufHeuristics}.configurePoolParams(" + type.getName() + ".class, %{com.neeve.util.UtlPool}.Params.create()),");
                }
                codeBuilder.last().appendln("                                                                               null));");
            }
        }
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("    /**");
        codeBuilder.last().appendln("     * Constructor for when loading factory from configuration repository.");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    final public static " + this.getName() + " create(final %{java.util.Properties} props) {");
        codeBuilder.last().appendln("        return new " + this.getName() + "();");
        codeBuilder.last().appendln("    }");
    }

    private final void writeJsonSchemaGenerator(AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    /**");
        codeBuilder.last().appendln("     * Json schema generation method.");
        codeBuilder.last().appendln("     * ");
        codeBuilder.last().appendln("     * <p>");
        codeBuilder.last().appendln("     * This method generates schemas for all entities managed by this factory.");
        codeBuilder.last().appendln("     * </p>");
        codeBuilder.last().appendln("     */");
        if (this.getDeprecatedTypeCount(false) > 0) {
            codeBuilder.last().appendln("    @SuppressWarnings(\"deprecation\")");
        }
        codeBuilder.last().appendln("    final public static String generateJsonSchemas() throws Exception {");
        codeBuilder.last().appendln("       final boolean indentOutputEnabled = mapper.isEnabled(%{com.fasterxml.jackson.databind.SerializationFeature}.INDENT_OUTPUT);");
        codeBuilder.last().appendln("       try {");
        codeBuilder.last().appendln("           mapper.configure(%{com.fasterxml.jackson.databind.SerializationFeature}.INDENT_OUTPUT, true);");
        codeBuilder.last().appendln("           StringBuilder sb = new StringBuilder();");
        Iterator<AdmFactoryType> iterator = this.typeIterator();
        boolean first = true;
        while (iterator.hasNext()) {
            AdmFactoryType type = iterator.next();
            if (!(type instanceof AdmEntity) && !(type instanceof AdmCollection) || type instanceof AdmEntity && ((AdmEntity)type).isEmbedded()) continue;
            if (first) {
                codeBuilder.last().appendln("           java.io.StringWriter sw = new java.io.StringWriter();");
                first = false;
            } else {
                codeBuilder.last().appendln("           sw = new java.io.StringWriter();");
            }
            codeBuilder.last().appendln("           sb.append(\"" + type.getName() + " \");");
            codeBuilder.last().appendln("           mapper.writeValue(sw, mapper.generateJsonSchema(" + type.getJavaTypeName() + ".class));");
            codeBuilder.last().appendln("           sb.append(sw.toString()).append(\"\\n\\n\");");
        }
        codeBuilder.last().appendln("           return sb.toString();");
        codeBuilder.last().appendln("       }");
        codeBuilder.last().appendln("       finally {");
        codeBuilder.last().appendln("           mapper.configure(%{com.fasterxml.jackson.databind.SerializationFeature}.INDENT_OUTPUT, indentOutputEnabled);");
        codeBuilder.last().appendln("       }");
        codeBuilder.last().appendln("    }");
    }

    final int getDeprecatedTypeCount(boolean onlyMessages) {
        int deprecatedTypes = 0;
        Iterator<AdmFactoryType> iterator = this.typeIterator();
        while (iterator.hasNext()) {
            AdmFactoryType type = iterator.next();
            if (!type.isDeprecated() || onlyMessages && !(type instanceof AdmMessage)) continue;
            ++deprecatedTypes;
        }
        return deprecatedTypes;
    }

    public static final short decodeObjectFactoryIdFromPacketId(int packetId) {
        if (packetId > 0) {
            return (short)((packetId - 4096) / Short.MAX_VALUE);
        }
        return (short)(-packetId / Short.MAX_VALUE * -1);
    }

    public static final short decodeObjectTypeFormPacketId(int packetId) {
        if (packetId > 0) {
            return (short)(packetId - AdmFactory.decodeObjectFactoryIdFromPacketId(packetId) * Short.MAX_VALUE - 4096);
        }
        return (short)(-packetId - AdmFactory.decodeObjectFactoryIdFromPacketId(packetId) * Short.MAX_VALUE * -1);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final String getFullName() {
        return AdmScopedType.constructFullName(this.getNamespace(), this.getName());
    }

    public final String getNamespace() {
        return this.namespace;
    }

    public final int getId() {
        return this.id;
    }

    public final short calcFactoryId() {
        if (this.isPlatformFactory()) {
            return (short)(this.getId() * -1 + 32);
        }
        return (short)(this.getId() * -1);
    }

    public final AdmFactory addType(AdmFactoryType type) throws EAdmException {
        AdmFactoryType dupType;
        String message;
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        if (type.getFactory() != this) {
            message = "attempt to add a type to a factory different from the type's factory " + type.getName();
            if (this.model.getModelBuildErrorAggregator() != null) {
                this.model.getModelBuildErrorAggregator().add(message, CgSourceCodeErrorAggregator.Severity.ERROR, this.getCodeSource(), null);
            } else {
                throw new EAdmException(message, this.getCodeSource());
            }
        }
        if (!type.getNamespace().equals(this.getNamespace())) {
            message = "a factory type's namespace (" + type.getNamespace() + ") must be the same as it's factory's namespace (" + this.getNamespace() + ")";
            if (this.model.getModelBuildErrorAggregator() != null) {
                this.model.getModelBuildErrorAggregator().add(message, CgSourceCodeErrorAggregator.Severity.ERROR, this.getCodeSource(), null);
            } else {
                throw new EAdmException(message, this.getCodeSource());
            }
        }
        if ((dupType = this.getTypeById(type.getId())) != null && dupType != type) {
            String message2 = type.getJavaTypeName() + " and " + dupType.getJavaTypeName() + " have the same type id [id=" + type.getId() + ", factory='" + this.getName() + "']";
            if (this.model.getModelBuildErrorAggregator() != null) {
                if (type.getCodeSource() != null && dupType.getCodeSource() != null) {
                    this.model.getModelBuildErrorAggregator().add(message2, CgSourceCodeErrorAggregator.Severity.ERROR, dupType.getCodeSource(), null);
                    this.model.getModelBuildErrorAggregator().add(message2, CgSourceCodeErrorAggregator.Severity.ERROR, type.getCodeSource(), null);
                } else {
                    this.model.getModelBuildErrorAggregator().add(message2, CgSourceCodeErrorAggregator.Severity.ERROR, this.getCodeSource(), null);
                }
            } else {
                throw new EAdmException(message2, this.getCodeSource());
            }
        }
        this.types.put(type.getName(), type);
        this.containsMessage |= type instanceof AdmMessage;
        this.containsType |= type instanceof AdmEntity && ((AdmEntity)type).isEmbedded();
        return this;
    }

    public final boolean handlesType(AdmFactoryType type) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        return this.types.get(type.getName()) != null;
    }

    public final Iterator<AdmFactoryType> typeIterator() {
        return this.types.values().iterator();
    }

    public final int getMessageCount() {
        int numMessages = 0;
        Iterator<AdmFactoryType> iterator = this.typeIterator();
        while (iterator.hasNext()) {
            AdmFactoryType type = iterator.next();
            if (!(type instanceof AdmMessage)) continue;
            ++numMessages;
        }
        return numMessages;
    }

    private final void writeObjectFactoryMethodsXbuf2(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        if (type instanceof AdmEntity) {
            AdmEntity entity = (AdmEntity)type;
            codeBuilder.last().appendln("    final private static ThreadLocal<" + type.getJavaTypeName() + "." + entity.getName() + "PoolFactoryItemCreateArgument> _" + AdmGenerator.toFirstLetterLowercase(entity.getName()) + "PoolGetArgument = new ThreadLocal<" + type.getJavaTypeName() + "." + entity.getName() + "PoolFactoryItemCreateArgument>() {");
            codeBuilder.last().appendln("        @Override");
            codeBuilder.last().appendln("        final protected " + type.getJavaTypeName() + "." + entity.getName() + "PoolFactoryItemCreateArgument initialValue() {");
            codeBuilder.last().appendln("            return new " + type.getJavaTypeName() + "." + entity.getName() + "PoolFactoryItemCreateArgument();");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    };");
        }
        if (type instanceof AdmEntity && ((AdmEntity)type).isRoot()) {
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects initialized with a given store id.");
            codeBuilder.last().appendln("     * It is equivalent to using '" + type.getName() + ".create(int, id)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "(final int grid, final %{com.eaio.uuid.UUID} id) {");
            codeBuilder.last().appendln("        final " + type.getJavaTypeName() + "." + type.getName() + "PoolFactoryItemCreateArgument arg = _" + AdmGenerator.toFirstLetterLowercase(type.getName()) + "PoolGetArgument.get();");
            codeBuilder.last().appendln("        final " + type.getJavaTypeName() + " val = " + type.getName() + "._entityPool.get(arg.init(id));");
            codeBuilder.last().appendln("        if (!arg.wasCreated) val.undispose(id);");
            codeBuilder.last().appendln("        if (grid >= 0) {");
            codeBuilder.last().appendln("            val.setGraphId(grid);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        return val;");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects.");
            codeBuilder.last().appendln("     * It is equivalent to using '" + type.getName() + ".create(int)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "(final int grid) {");
            if (type instanceof AdmMessage) {
                codeBuilder.last().appendln("        return create" + type.getName() + "(grid, null);");
            } else {
                codeBuilder.last().appendln("        final " + type.getJavaTypeName() + " val = create" + type.getName() + "(grid, null);");
                codeBuilder.last().appendln("        val.ensureId();");
                codeBuilder.last().appendln("        return val;");
            }
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects");
            codeBuilder.last().appendln("     * from a serialized content object. It is equivalent to using '" + type.getName());
            codeBuilder.last().appendln("     * .createFromJson(int, String)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromJson(final int grid, final String json) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "(grid).deserializeFromJson(json);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects");
            codeBuilder.last().appendln("     * from a serialized content object. It is equivalent to using '" + type.getName());
            codeBuilder.last().appendln("     * .createFromRawJson(int, String)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromRawJson(final int grid, final String json) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "(grid).deserializeFromRawJson(json);");
            codeBuilder.last().appendln("    }");
        } else if (type instanceof AdmCollection) {
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects initialized with a given store id.");
            codeBuilder.last().appendln("     * It is equivalent to using '" + type.getName() + ".create(id)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "(final %{com.eaio.uuid.UUID} id) {");
            codeBuilder.last().appendln("        return new " + type.getName() + "(id);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects.");
            codeBuilder.last().appendln("     * It is equivalent to using '" + type.getName() + ".create()'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "() {");
            codeBuilder.last().appendln("        return create" + type.getName() + "(new %{com.eaio.uuid.UUID}());");
            codeBuilder.last().appendln("    }");
        } else {
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects initialized with a given store id.");
            codeBuilder.last().appendln("     * It is equivalent to using '" + type.getName() + ".create(id)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "(final %{com.eaio.uuid.UUID} id) {");
            codeBuilder.last().appendln("        final " + type.getJavaTypeName() + "." + type.getName() + "PoolFactoryItemCreateArgument arg = _" + AdmGenerator.toFirstLetterLowercase(type.getName()) + "PoolGetArgument.get();");
            codeBuilder.last().appendln("        final " + type.getJavaTypeName() + " val = " + type.getName() + "._entityPool.get(arg.init(id));");
            codeBuilder.last().appendln("        if (!arg.wasCreated) val.undispose(id);");
            codeBuilder.last().appendln("        return val;");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects.");
            codeBuilder.last().appendln("     * It is equivalent to using '" + type.getName() + ".create()'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "() {");
            if (type instanceof AdmMessage) {
                codeBuilder.last().appendln("        return create" + type.getName() + "(null);");
            } else {
                codeBuilder.last().appendln("        final " + type.getJavaTypeName() + " val = create" + type.getName() + "(null);");
                codeBuilder.last().appendln("        val.ensureId();");
                codeBuilder.last().appendln("        return val;");
            }
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects");
            codeBuilder.last().appendln("     * from a serialized content object. It is equivalent to using '" + type.getName());
            codeBuilder.last().appendln("     * .createFromJson(String)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromJson(final String json) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "().deserializeFromJson(json);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects");
            codeBuilder.last().appendln("     * from a serialized content object. It is equivalent to using '" + type.getName());
            codeBuilder.last().appendln("     * .createFromRawJson(String)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromRawJson(final String json) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "().deserializeFromRawJson(json);");
            codeBuilder.last().appendln("    }");
        }
    }

    private final void writeObjectFactoryMethodsXbuf(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        if (type instanceof AdmEntity && ((AdmEntity)type).isRoot()) {
            codeBuilder.last().appendln("    /*");
            codeBuilder.last().appendln("     * Core " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final private static " + type.getJavaTypeName() + " create" + type.getName() + "FromXbufContainerPacket(final int grid, final %{com.eaio.uuid.UUID} id, final %{com.neeve.pkt.PktPacket} packet) {");
            codeBuilder.last().appendln("        try {");
            codeBuilder.last().appendln("            final " + type.getJavaTypeName() + " object = (" + type.getName() + ")packet.getTag(%{com.neeve.pkt.PktTags}.TAG_ROG_ENVELOPE);");
            codeBuilder.last().appendln("            if (object != null) {");
            codeBuilder.last().appendln("                object.undispose(id);");
            codeBuilder.last().appendln("                return object;");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("            else {");
            codeBuilder.last().appendln("                return new " + type.getJavaTypeName() + "(grid, id, packet);");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        finally {");
            codeBuilder.last().appendln("            packet.dispose();");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /*");
            codeBuilder.last().appendln("     * Core " + type.getName() + " factory method for creation from serialized xbuf container packets in byte buffers");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final private static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedXbufContainerPacket(final int grid, final %{com.eaio.uuid.UUID} id, final %{java.nio.ByteBuffer} serializedPacket) {");
            codeBuilder.last().appendln("        try {");
            codeBuilder.last().appendln("            return create" + type.getJavaTypeName() + "FromXbufContainerPacket(grid, id, %{com.neeve.pkt.PktSerializer}.create().deserialize(serializedPacket, null));");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        catch (Exception e) {");
            codeBuilder.last().appendln("            if (e instanceof RuntimeException) {");
            codeBuilder.last().appendln("                throw (RuntimeException)e;");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("            else {");
            codeBuilder.last().appendln("                throw new RuntimeException(e);");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /*");
            codeBuilder.last().appendln("     * Core " + type.getName() + " factory method for creation from serialized xbuf container packets in byte arrays");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final private static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedXbufContainerPacket(final int grid, final %{com.eaio.uuid.UUID} id, final byte[] serializedPacket) {");
            codeBuilder.last().appendln("        return create" + type.getJavaTypeName() + "FromSerializedXbufContainerPacket(grid, id, %{java.nio.ByteBuffer}.wrap(serializedPacket));");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /*");
            codeBuilder.last().appendln("     * Core " + type.getName() + " factory method for creation from serialized xbuf containers in byte buffers");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final private static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedXbufContainer(final int grid, final %{com.eaio.uuid.UUID} id, final %{java.nio.ByteBuffer} serializedContainer) {");
            codeBuilder.last().appendln("        try {");
            codeBuilder.last().appendln("            final %{com.neeve.sma.MessageView} view = create" + type.getName() + "(grid);");
            codeBuilder.last().appendln("            final %{com.neeve.pkt.PktPacket} packet = (%{com.neeve.pkt.PktPacket})view.getMessage();");
            codeBuilder.last().appendln("            packet.acquire();");
            codeBuilder.last().appendln("            view.dispose();");
            codeBuilder.last().appendln("            packet.getBody().deserialize(serializedContainer, serializedContainer.remaining());");
            codeBuilder.last().appendln("            return create" + type.getName() + "FromXbufContainerPacket(grid, id, packet);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        catch (Exception e) {");
            codeBuilder.last().appendln("            if (e instanceof RuntimeException) {");
            codeBuilder.last().appendln("                throw (RuntimeException)e;");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("            else {");
            codeBuilder.last().appendln("                throw new RuntimeException(e);");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /*");
            codeBuilder.last().appendln("     * Core " + type.getName() + " factory method for creation from serialized xbuf containers in byte arrays");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final private static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedXbufContainer(final int grid, final %{com.eaio.uuid.UUID} id, final byte[] serializedContainer) {");
            codeBuilder.last().appendln("        try {");
            codeBuilder.last().appendln("            final %{com.neeve.sma.MessageView} view = create" + type.getName() + "(grid);");
            codeBuilder.last().appendln("            final %{com.neeve.pkt.PktPacket} packet = (%{com.neeve.pkt.PktPacket})view.getMessage();");
            codeBuilder.last().appendln("            packet.acquire();");
            codeBuilder.last().appendln("            view.dispose();");
            codeBuilder.last().appendln("            packet.getBody().deserialize(serializedContainer, 0, serializedContainer.length);");
            codeBuilder.last().appendln("            return create" + type.getName() + "FromXbufContainerPacket(grid, id, packet);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        catch (Exception e) {");
            codeBuilder.last().appendln("            if (e instanceof RuntimeException) {");
            codeBuilder.last().appendln("                throw (RuntimeException)e;");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("            else {");
            codeBuilder.last().appendln("                throw new RuntimeException(e);");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects.");
            codeBuilder.last().appendln("     * It is equivalent to using '" + type.getName() + ".create(int)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "(final int grid) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromXbufContainerPacket(grid, " + (type instanceof AdmMessage ? "null" : "new %{com.eaio.uuid.UUID}()") + ", %{com.neeve.pkt.PktFactory}.getInstance().createPacket(PKTID_" + type.getName() + "));");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects initialized with a given store id.");
            codeBuilder.last().appendln("     * It is equivalent to using '" + type.getName() + ".create(int, id)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "(final int grid, final %{com.eaio.uuid.UUID} id) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromXbufContainerPacket(grid, id, %{com.neeve.pkt.PktFactory}.getInstance().createPacket(PKTID_" + type.getName() + "));");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects");
            codeBuilder.last().appendln("     * from a serialized content object. It is equivalent to using '" + type.getName());
            codeBuilder.last().appendln("     * .createFromXbufContainerPacket(int, %{com.neeve.pkt.PktPacket})'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     *");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * <i>Note: This method takes ownership of the supplied packet and, therefore,");
            codeBuilder.last().appendln("     * must be released by the caller once this method returns. Taking ownership");
            codeBuilder.last().appendln("     * implies that this method inherits the caller's reference to the packet.");
            codeBuilder.last().appendln("     * Therefore, the caller should not release its reference to the packet </i>");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromXbufContainerPacket(final int grid, final %{com.neeve.pkt.PktPacket} packet) {");
            codeBuilder.last().appendln("        if (packet.getBody().getType() == PKTID_" + type.getName() + ") {");
            codeBuilder.last().appendln("            return create" + type.getName() + "FromXbufContainerPacket(grid, " + (type instanceof AdmMessage ? "null" : "new %{com.eaio.uuid.UUID}()") + ", packet);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        else {");
            codeBuilder.last().appendln("            throw new IllegalArgumentException(\"invalid packet type [exp=PKTID_" + type.getName() + ", actual=packet.getBody().getType()]\");");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects");
            codeBuilder.last().appendln("     * from a serialized content object. It is equivalent to using '" + type.getName());
            codeBuilder.last().appendln("     * .createFromSerializedXbufContainerPacket(int, %{java.nio.ByteBuffer})'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedXbufContainerPacket(final int grid, final %{java.nio.ByteBuffer} serializedPacket) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromSerializedXbufContainerPacket(grid, " + (type instanceof AdmMessage ? "null" : "new %{com.eaio.uuid.UUID}()") + ", serializedPacket);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects");
            codeBuilder.last().appendln("     * from a serialized content object. It is equivalent to using '" + type.getName());
            codeBuilder.last().appendln("     * .createFromSerializedXbufContainerPacket(int, byte[])'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedXbufContainerPacket(final int grid, final byte[] serializedPacket) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromSerializedXbufContainerPacket(grid, " + (type instanceof AdmMessage ? "null" : "new %{com.eaio.uuid.UUID}()") + ", serializedPacket);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects");
            codeBuilder.last().appendln("     * from a serialized content object. It is equivalent to using '" + type.getName());
            codeBuilder.last().appendln("     * .createFromSerializedXbufContainer(int, %{java.nio.ByteBuffer})'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedXbufContainer(final int grid, final %{java.nio.ByteBuffer} serializedContainer) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromSerializedXbufContainer(grid, " + (type instanceof AdmMessage ? "null" : "new %{com.eaio.uuid.UUID}()") + ", serializedContainer);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects");
            codeBuilder.last().appendln("     * from a serialized content object. It is equivalent to using '" + type.getName());
            codeBuilder.last().appendln("     * .createFromSerializedXbufContainer(int, byte[])'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedXbufContainer(final int grid, final byte[] serializedContainer) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromSerializedXbufContainer(grid, " + (type instanceof AdmMessage ? "null" : "new %{com.eaio.uuid.UUID}()") + ", serializedContainer);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects");
            codeBuilder.last().appendln("     * from a serialized content object. It is equivalent to using '" + type.getName());
            codeBuilder.last().appendln("     * .createFromJson(int, String)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromJson(final int grid, final String json) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "(grid).deserializeFromJson(json);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects");
            codeBuilder.last().appendln("     * from a serialized content object. It is equivalent to using '" + type.getName());
            codeBuilder.last().appendln("     * .createFromRawJson(int, String)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromRawJson(final int grid, final String json) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "(grid).deserializeFromRawJson(json);");
            codeBuilder.last().appendln("    }");
        } else if (type instanceof AdmCollection) {
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects.");
            codeBuilder.last().appendln("     * It is equivalent to using '" + type.getName() + ".create()'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "() {");
            codeBuilder.last().appendln("        return new " + type.getName() + "(new %{com.eaio.uuid.UUID}());");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects initialized with a given store id.");
            codeBuilder.last().appendln("     * It is equivalent to using '" + type.getName() + ".create(id)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "(final %{com.eaio.uuid.UUID} id) {");
            codeBuilder.last().appendln("        return new " + type.getName() + "(id);");
            codeBuilder.last().appendln("    }");
        } else {
            codeBuilder.last().appendln("    /*");
            codeBuilder.last().appendln("     * Core " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final private static " + type.getJavaTypeName() + " create" + type.getName() + "FromXbufContainerPacket(final %{com.eaio.uuid.UUID} id, final %{com.neeve.pkt.PktPacket} packet) {");
            codeBuilder.last().appendln("        try {");
            codeBuilder.last().appendln("            final " + type.getName() + " object = (" + type.getName() + ")packet.getTag(%{com.neeve.pkt.PktTags}.TAG_ROG_ENVELOPE);");
            codeBuilder.last().appendln("            if (object != null) {");
            codeBuilder.last().appendln("                object.undispose(id);");
            codeBuilder.last().appendln("                return object;");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("            else {");
            codeBuilder.last().appendln("                return new " + type.getName() + "(id, packet);");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        finally {");
            codeBuilder.last().appendln("            packet.dispose();");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /*");
            codeBuilder.last().appendln("     * Core " + type.getName() + " factory method for creation from serialized xbuf container packets in byte buffers.");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final private static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedXbufContainerPacket(final %{com.eaio.uuid.UUID} id, final %{java.nio.ByteBuffer} serializedPacket) {");
            codeBuilder.last().appendln("        try {");
            codeBuilder.last().appendln("            return create" + type.getName() + "FromXbufContainerPacket(id, %{com.neeve.pkt.PktSerializer}.create().deserialize(serializedPacket, null));");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        catch (Exception e) {");
            codeBuilder.last().appendln("            if (e instanceof RuntimeException) {");
            codeBuilder.last().appendln("                throw (RuntimeException)e;");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("            else {");
            codeBuilder.last().appendln("                throw new RuntimeException(e);");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /*");
            codeBuilder.last().appendln("     * Core " + type.getName() + " factory method for creation from serialized xbuf container packets in byte arrays.");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final private static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedXbufContainerPacket(final %{com.eaio.uuid.UUID} id, final byte[] serializedPacket) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromSerializedXbufContainerPacket(id, %{java.nio.ByteBuffer}.wrap(serializedPacket));");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /*");
            codeBuilder.last().appendln("     * Core " + type.getName() + " factory method for creation from serialized xbuf containers in byte buffers.");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final private static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedXbufContainer(final %{com.eaio.uuid.UUID} id, final %{java.nio.ByteBuffer} serializedContainer) {");
            codeBuilder.last().appendln("        try {");
            codeBuilder.last().appendln("            final %{com.neeve.sma.MessageView} view = create" + type.getName() + "();");
            codeBuilder.last().appendln("            final %{com.neeve.pkt.PktPacket} packet = (%{com.neeve.pkt.PktPacket})view.getMessage();");
            codeBuilder.last().appendln("            packet.acquire();");
            codeBuilder.last().appendln("            view.dispose();");
            codeBuilder.last().appendln("            packet.getBody().deserialize(serializedContainer, serializedContainer.remaining());");
            codeBuilder.last().appendln("            return create" + type.getName() + "FromXbufContainerPacket(id, packet);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        catch (Exception e) {");
            codeBuilder.last().appendln("            if (e instanceof RuntimeException) {");
            codeBuilder.last().appendln("                throw (RuntimeException)e;");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("            else {");
            codeBuilder.last().appendln("                throw new RuntimeException(e);");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /*");
            codeBuilder.last().appendln("     * Core " + type.getName() + " factory method for creation from serialized xbuf containers in byte arrays.");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final private static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedXbufContainer(final %{com.eaio.uuid.UUID} id, final byte[] serializedContainer) {");
            codeBuilder.last().appendln("        try {");
            codeBuilder.last().appendln("            final %{com.neeve.sma.MessageView} view = create" + type.getName() + "();");
            codeBuilder.last().appendln("            final %{com.neeve.pkt.PktPacket} packet = (%{com.neeve.pkt.PktPacket})view.getMessage();");
            codeBuilder.last().appendln("            packet.acquire();");
            codeBuilder.last().appendln("            view.dispose();");
            codeBuilder.last().appendln("            packet.getBody().deserialize(serializedContainer, 0, serializedContainer.length);");
            codeBuilder.last().appendln("            return create" + type.getName() + "FromXbufContainerPacket(id, packet);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        catch (Exception e) {");
            codeBuilder.last().appendln("            if (e instanceof RuntimeException) {");
            codeBuilder.last().appendln("                throw (RuntimeException)e;");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("            else {");
            codeBuilder.last().appendln("                throw new RuntimeException(e);");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects.");
            codeBuilder.last().appendln("     * It is equivalent to using '" + type.getName() + ".create()'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "() {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromXbufContainerPacket(" + (type instanceof AdmMessage ? "null" : "new %{com.eaio.uuid.UUID}()") + ", %{com.neeve.pkt.PktFactory}.getInstance().createPacket(PKTID_" + type.getName() + "));");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects initialized with a given store id.");
            codeBuilder.last().appendln("     * It is equivalent to using '" + type.getName() + ".create(id)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "(final %{com.eaio.uuid.UUID} id) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromXbufContainerPacket(id, %{com.neeve.pkt.PktFactory}.getInstance().createPacket(PKTID_" + type.getName() + "));");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects");
            codeBuilder.last().appendln("     * from a serialized content object. It is equivalent to using '" + type.getName());
            codeBuilder.last().appendln("     * .createFromXbufContainerPacket(%{com.neeve.pkt.PktPacket})'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     *");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * <i>Note: This method takes ownership of the supplied packet and, therefore,");
            codeBuilder.last().appendln("     * must be released by the caller once this method returns. Taking ownership");
            codeBuilder.last().appendln("     * implies that this method inherits the caller's reference to the packet.");
            codeBuilder.last().appendln("     * Therefore, the caller should not release its reference to the packet </i>");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromXbufContainerPacket(final %{com.neeve.pkt.PktPacket} packet) {");
            codeBuilder.last().appendln("        if (packet.getBody().getType() == PKTID_" + type.getName() + ") {");
            codeBuilder.last().appendln("            return create" + type.getName() + "FromXbufContainerPacket(" + (type instanceof AdmMessage ? "null" : "new %{com.eaio.uuid.UUID}()") + ", packet);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        else {");
            codeBuilder.last().appendln("            throw new IllegalArgumentException(\"invalid packet type [exp=PKTID_" + type.getName() + ", actual=packet.getBody().getType()]\");");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects");
            codeBuilder.last().appendln("     * from a serialized content object. It is equivalent to using '" + type.getName());
            codeBuilder.last().appendln("     * .createFromSerializedXbufContainerPacket(%{java.nio.ByteBuffer})'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedXbufContainerPacket(final %{java.nio.ByteBuffer} serializedPacket) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromSerializedXbufContainerPacket(" + (type instanceof AdmMessage ? "null" : "new %{com.eaio.uuid.UUID}()") + ", serializedPacket);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects");
            codeBuilder.last().appendln("     * from a serialized content object. It is equivalent to using '" + type.getName());
            codeBuilder.last().appendln("     * .createFromSerializedXbufContainerPacket(byte[])'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedXbufContainerPacket(final byte[] serializedPacket) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromSerializedXbufContainerPacket(" + (type instanceof AdmMessage ? "null" : "new %{com.eaio.uuid.UUID}()") + ", serializedPacket);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects");
            codeBuilder.last().appendln("     * from a serialized content object. It is equivalent to using '" + type.getName());
            codeBuilder.last().appendln("     * .createFromSerializedXbufContainer(%{java.nio.ByteBuffer})'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedXbufContainer(final %{java.nio.ByteBuffer} serializedContainer) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromSerializedXbufContainer(" + (type instanceof AdmMessage ? "null" : "new %{com.eaio.uuid.UUID}()") + ", serializedContainer);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects");
            codeBuilder.last().appendln("     * from a serialized content object. It is equivalent to using '" + type.getName());
            codeBuilder.last().appendln("     * .createFromSerializedXbufContainer(byte[])'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedXbufContainer(final byte[] serializedContainer) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromSerializedXbufContainer(" + (type instanceof AdmMessage ? "null" : "new %{com.eaio.uuid.UUID}()") + ", serializedContainer);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects");
            codeBuilder.last().appendln("     * from a serialized content object. It is equivalent to using '" + type.getName());
            codeBuilder.last().appendln("     * .createFromJson(String)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromJson(final String json) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "().deserializeFromJson(json);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects");
            codeBuilder.last().appendln("     * from a serialized content object. It is equivalent to using '" + type.getName());
            codeBuilder.last().appendln("     * .createFromRawJson(String)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromRawJson(final String json) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "().deserializeFromRawJson(json);");
            codeBuilder.last().appendln("    }");
        }
    }

    private final void writeObjectFactoryMethodsProto(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        if (type instanceof AdmEntity && ((AdmEntity)type).isRoot()) {
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * Core " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final private static " + type.getJavaTypeName() + " create" + type.getName() + "FromProtoMessage(final int grid, final %{com.eaio.uuid.UUID} id, final " + this.protobufName(type) + " protoMessage) {");
            codeBuilder.last().appendln("        return new " + type.getName() + "(grid, id, protoMessage);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /*");
            codeBuilder.last().appendln("     * Core " + type.getName() + " factory method for creation from serialized proto messages in packet bodies.");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final private static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedProtoMessage(final int grid, final %{com.eaio.uuid.UUID} id, final %{com.neeve.pkt.PktPacket} serializedProtoMessage) {");
            codeBuilder.last().appendln("        try {");
            codeBuilder.last().appendln("            final %{com.neeve.pkt.PktBuffer} buffer = serializedProtoMessage.getBody().getBuffer();");
            codeBuilder.last().appendln("            final %{com.google.protobuf.CodedInputStream} cis = %{com.google.protobuf.CodedInputStream}.newInstance(buffer.inputStream(0));");
            codeBuilder.last().appendln("            cis.setSizeLimit(buffer.getLength());");
            codeBuilder.last().appendln("            return create" + type.getName() + "FromProtoMessage(grid, id, " + this.protobufName(type) + ".parseFrom(cis));");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        catch (Exception e) {");
            codeBuilder.last().appendln("            if (e instanceof RuntimeException) {");
            codeBuilder.last().appendln("                throw (RuntimeException)e;");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("            else {");
            codeBuilder.last().appendln("                throw new RuntimeException(e);");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /*");
            codeBuilder.last().appendln("     * Core " + type.getName() + " factory method for creation from serialized proto messages in byte buffers.");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final private static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedProtoMessage(final int grid, final %{com.eaio.uuid.UUID} id, final %{java.nio.ByteBuffer} serializedProtoMessage) {");
            codeBuilder.last().appendln("        try {");
            codeBuilder.last().appendln("            final %{com.google.protobuf.CodedInputStream} cis = %{com.google.protobuf.CodedInputStream}.newInstance(%{com.neeve.util.UtlBuffer}.inputStream(serializedProtoMessage));");
            codeBuilder.last().appendln("            cis.setSizeLimit(serializedProtoMessage.remaining());");
            codeBuilder.last().appendln("            return create" + type.getName() + "FromProtoMessage(grid, id, " + this.protobufName(type) + ".parseFrom(cis));");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        catch (Exception e) {");
            codeBuilder.last().appendln("            if (e instanceof RuntimeException) {");
            codeBuilder.last().appendln("                throw (RuntimeException)e;");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("            else {");
            codeBuilder.last().appendln("                throw new RuntimeException(e);");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /*");
            codeBuilder.last().appendln("     * Core " + type.getName() + " factory method for creation from serialized proto messages in byte arrays.");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final private static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedProtoMessage(final int grid, final %{com.eaio.uuid.UUID} id, final byte[] serializedProtoMessage) {");
            codeBuilder.last().appendln("        try {");
            codeBuilder.last().appendln("            return create" + type.getName() + "FromProtoMessage(grid, id, " + this.protobufName(type) + ".parseFrom(serializedProtoMessage));");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        catch (Exception e) {");
            codeBuilder.last().appendln("            if (e instanceof RuntimeException) {");
            codeBuilder.last().appendln("                throw (RuntimeException)e;");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("            else {");
            codeBuilder.last().appendln("                throw new RuntimeException(e);");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getJavaTypeName() + "' objects.");
            codeBuilder.last().appendln("     * It is equivalent to using '" + type.getJavaTypeName() + ".create(int)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "(final int grid) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromProtoMessage(grid, " + (type instanceof AdmMessage ? "null" : "new %{com.eaio.uuid.UUID}()") + ", (" + this.protobufName(type) + ")null);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getJavaTypeName() + "' objects initialized with a given store id");
            codeBuilder.last().appendln("     * It is equivalent to using '" + type.getJavaTypeName() + ".create(int, uuid)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "(final int grid, final %{com.eaio.uuid.UUID} id) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromProtoMessage(grid, id, (" + this.protobufName(type) + ")null);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getJavaTypeName() + "' objects");
            codeBuilder.last().appendln("     * from protobuf message objects. It is equivalent to using '" + type.getJavaTypeName());
            codeBuilder.last().appendln("     * .createFromProtoMessage(int, " + this.protobufName(type) + ")'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     *");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * <i>Note: This method takes ownership of the supplied protobuf message and, therefore,");
            codeBuilder.last().appendln("     * must not be manipulated by the caller once this method returns</i>");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromProtoMessage(final int grid, final " + this.protobufName(type) + " protoMessage) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromProtoMessage(grid, " + (type instanceof AdmMessage ? "null" : "new %{com.eaio.uuid.UUID}()") + ", protoMessage);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects");
            codeBuilder.last().appendln("     * from protobuf messages serialized in ByteBuffers. It is equivalent to using");
            codeBuilder.last().appendln("     * '" + type.getName() + ".createFromSerializedProtoMessage(int, %{java.nio.ByteBuffer})'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedProtoMessage(final int grid, final %{java.nio.ByteBuffer} serializedProtoMessage) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromSerializedProtoMessage(grid, " + (type instanceof AdmMessage ? "null" : "new %{com.eaio.uuid.UUID}()") + ", serializedProtoMessage);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects");
            codeBuilder.last().appendln("     * from protobuf messages serialized in byte arrays. It is equivalent to using");
            codeBuilder.last().appendln("     * '" + type.getName() + ".createFromSerializedProtoMessage(int, byte[])'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedProtoMessage(final int grid, final byte[] serializedProtoMessage) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromSerializedProtoMessage(grid, " + (type instanceof AdmMessage ? "null" : "new %{com.eaio.uuid.UUID}()") + ", serializedProtoMessage);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects");
            codeBuilder.last().appendln("     * from protobuf messages serialized in PktPacket bodies. It is equivalent to using");
            codeBuilder.last().appendln("     * '" + type.getName() + ".createFromSerializedProtoMessage(int, %{com.neeve.pkt.PktPacket})'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedProtoMessage(final int grid, final %{com.neeve.pkt.PktPacket} serializedProtoMessage) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromSerializedProtoMessage(grid, " + (type instanceof AdmMessage ? "null" : "new %{com.eaio.uuid.UUID}()") + ", serializedProtoMessage);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects");
            codeBuilder.last().appendln("     * from a serialized content object. It is equivalent to using '" + type.getName());
            codeBuilder.last().appendln("     * .createFromJson(int, String)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromJson(final int grid, final String json) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "(grid).deserializeFromJson(json);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects");
            codeBuilder.last().appendln("     * from a serialized content object. It is equivalent to using '" + type.getName());
            codeBuilder.last().appendln("     * .createFromRawJson(int, String)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromRawJson(final int grid, final String json) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "(grid).deserializeFromRawJson(json);");
            codeBuilder.last().appendln("    }");
        } else if (type instanceof AdmCollection) {
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects.");
            codeBuilder.last().appendln("     * It is equivalent to using '" + type.getName() + ".create()'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "() {");
            codeBuilder.last().appendln("        return new " + type.getName() + "(new %{com.eaio.uuid.UUID}());");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects initialized with a given store id.");
            codeBuilder.last().appendln("     * It is equivalent to using '" + type.getName() + ".create(id)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "(final %{com.eaio.uuid.UUID} id) {");
            codeBuilder.last().appendln("        return new " + type.getName() + "(id);");
            codeBuilder.last().appendln("    }");
        } else {
            codeBuilder.last().appendln("    /*");
            codeBuilder.last().appendln("     * Core " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final private static " + type.getJavaTypeName() + " create" + type.getName() + "FromProtoMessage(final %{com.eaio.uuid.UUID} id, final " + this.protobufName(type) + " protoMessage) {");
            codeBuilder.last().appendln("        return new " + type.getName() + "(id, protoMessage);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /*");
            codeBuilder.last().appendln("     * Core " + type.getName() + " factory method for creation from serialized proto messages in packet bodies");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final private static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedProtoMessage(final %{com.eaio.uuid.UUID} id, final %{com.neeve.pkt.PktPacket} serializedProtoMessage) {");
            codeBuilder.last().appendln("        try {");
            codeBuilder.last().appendln("            final %{com.neeve.pkt.PktBuffer} buffer = serializedProtoMessage.getBody().getBuffer();");
            codeBuilder.last().appendln("            final %{com.google.protobuf.CodedInputStream} cis = %{com.google.protobuf.CodedInputStream}.newInstance(buffer.inputStream(0));");
            codeBuilder.last().appendln("            cis.setSizeLimit(buffer.getLength());");
            codeBuilder.last().appendln("            return create" + type.getName() + "FromProtoMessage(id, " + this.protobufName(type) + ".parseFrom(cis));");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        catch (Exception e) {");
            codeBuilder.last().appendln("            if (e instanceof RuntimeException) {");
            codeBuilder.last().appendln("                throw (RuntimeException)e;");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("            else {");
            codeBuilder.last().appendln("                throw new RuntimeException(e);");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /*");
            codeBuilder.last().appendln("     * Core " + type.getName() + " factory method for creation from serialized proto messages in byte buffers");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final private static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedProtoMessage(final %{com.eaio.uuid.UUID} id, final %{java.nio.ByteBuffer} serializedProtoMessage) {");
            codeBuilder.last().appendln("        try {");
            codeBuilder.last().appendln("            final %{com.google.protobuf.CodedInputStream} cis = %{com.google.protobuf.CodedInputStream}.newInstance(%{com.neeve.util.UtlBuffer}.inputStream(serializedProtoMessage));");
            codeBuilder.last().appendln("            cis.setSizeLimit(serializedProtoMessage.remaining());");
            codeBuilder.last().appendln("            return create" + type.getName() + "FromProtoMessage(id, " + this.protobufName(type) + ".parseFrom(cis));");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        catch (Exception e) {");
            codeBuilder.last().appendln("            if (e instanceof RuntimeException) {");
            codeBuilder.last().appendln("                throw (RuntimeException)e;");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("            else {");
            codeBuilder.last().appendln("                throw new RuntimeException(e);");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /*");
            codeBuilder.last().appendln("     * Core " + type.getName() + " factory method for creation from serialized proto messages in byte arrays");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final private static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedProtoMessage(final %{com.eaio.uuid.UUID} id, final byte[] serializedProtoMessage) {");
            codeBuilder.last().appendln("        try {");
            codeBuilder.last().appendln("            return create" + type.getName() + "FromProtoMessage(id, " + this.protobufName(type) + ".parseFrom(serializedProtoMessage));");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        catch (Exception e) {");
            codeBuilder.last().appendln("            if (e instanceof RuntimeException) {");
            codeBuilder.last().appendln("                throw (RuntimeException)e;");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("            else {");
            codeBuilder.last().appendln("                throw new RuntimeException(e);");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getJavaTypeName() + "' objects.");
            codeBuilder.last().appendln("     * It is equivalent to using '" + type.getJavaTypeName() + ".create()'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "() {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromProtoMessage(" + (type instanceof AdmMessage ? "null" : "new %{com.eaio.uuid.UUID}()") + ", (" + this.protobufName(type) + ")null);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getJavaTypeName() + "' objects initialized with a given store id");
            codeBuilder.last().appendln("     * It is equivalent to using '" + type.getJavaTypeName() + ".create(uuid)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "(final %{com.eaio.uuid.UUID} id) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromProtoMessage(id, (" + this.protobufName(type) + ")null);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getJavaTypeName() + "' objects");
            codeBuilder.last().appendln("     * from protobuf message objects. It is equivalent to using '" + type.getJavaTypeName());
            codeBuilder.last().appendln("     * .createFromProtoMessage(" + this.protobufName(type) + ")'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     *");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * <i>Note: This method takes ownership of the supplied protobuf message and, therefore,");
            codeBuilder.last().appendln("     * must not be manipulated by the caller once this method returns</i>");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromProtoMessage(final " + this.protobufName(type) + " protoMessage) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromProtoMessage(" + (type instanceof AdmMessage ? "null" : "new %{com.eaio.uuid.UUID}()") + ", protoMessage);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects");
            codeBuilder.last().appendln("     * from protobuf messages serialized in ByteBuffers. It is equivalent to using");
            codeBuilder.last().appendln("     * '" + type.getName() + ".createFromSerializedProtoMessage(%{java.nio.ByteBuffer})'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedProtoMessage(final %{java.nio.ByteBuffer} serializedProtoMessage) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromSerializedProtoMessage(" + (type instanceof AdmMessage ? "null" : "new %{com.eaio.uuid.UUID}()") + ", serializedProtoMessage);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getJavaTypeName() + "' objects");
            codeBuilder.last().appendln("     * from protobuf messages serialized in byte arrays. It is equivalent to using");
            codeBuilder.last().appendln("     * '" + type.getJavaTypeName() + ".createFromSerializedProtoMessage(byte[])'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedProtoMessage(final byte[] serializedProtoMessage) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromSerializedProtoMessage(" + (type instanceof AdmMessage ? "null" : "new %{com.eaio.uuid.UUID}()") + ", serializedProtoMessage);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getJavaTypeName() + "' objects");
            codeBuilder.last().appendln("     * from protobuf messages serialized in PktPacket bodies. It is equivalent to using");
            codeBuilder.last().appendln("     * '" + type.getJavaTypeName() + ".createFromSerializedProtoMessage(%{com.neeve.pkt.PktPacket})'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedProtoMessage(final %{com.neeve.pkt.PktPacket} serializedProtoMessage) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromSerializedProtoMessage(" + (type instanceof AdmMessage ? "null" : "new %{com.eaio.uuid.UUID}()") + ", serializedProtoMessage);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getJavaTypeName() + "' objects");
            codeBuilder.last().appendln("     * from a serialized content object. It is equivalent to using '" + type.getJavaTypeName());
            codeBuilder.last().appendln("     * .createFromJson(String)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromJson(final String json) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "().deserializeFromJson(json);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getJavaTypeName() + "' objects");
            codeBuilder.last().appendln("     * from a serialized content object. It is equivalent to using '" + type.getJavaTypeName());
            codeBuilder.last().appendln("     * .createFromRawJson(String)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromRawJson(final String json) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "().deserializeFromRawJson(json);");
            codeBuilder.last().appendln("    }");
        }
    }

    private final void writeObjectFactoryMethodsJson(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        if (type instanceof AdmEntity && ((AdmEntity)type).isRoot()) {
            codeBuilder.last().appendln("    /*");
            codeBuilder.last().appendln("     * Core " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final private static " + type.getJavaTypeName() + " create" + type.getName() + "FromJson(final int grid, final %{com.eaio.uuid.UUID} id, final String json) {");
            codeBuilder.last().appendln("        try {");
            codeBuilder.last().appendln("            return new " + type.getJavaTypeName() + "(grid, id, json);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        catch (Exception e) {");
            codeBuilder.last().appendln("            if (e instanceof RuntimeException) {");
            codeBuilder.last().appendln("                throw (RuntimeException)e;");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("            else {");
            codeBuilder.last().appendln("                throw new RuntimeException(e);");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /*");
            codeBuilder.last().appendln("     * Core " + type.getName() + " factory method for creation from serialized json strings in byte buffers");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final private static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedJson(final int grid, final %{com.eaio.uuid.UUID} id, final %{java.nio.ByteBuffer} serializedJson) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromJson(grid, id, com.google.protobuf.ByteString.copyFrom(serializedJson).toStringUtf8());");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /*");
            codeBuilder.last().appendln("     * Core " + type.getName() + " factory method for creation from byte arrays");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final private static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedJson(final int grid, final %{com.eaio.uuid.UUID} id, final byte[] serializedJson) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromJson(grid, id, com.google.protobuf.ByteString.copyFrom(serializedJson).toStringUtf8());");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getJavaTypeName() + "' objects.");
            codeBuilder.last().appendln("     * It is equivalent to using '" + type.getJavaTypeName() + ".create(int)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "(final int grid) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromJson(grid, " + (type instanceof AdmMessage ? "null" : "new %{com.eaio.uuid.UUID}()") + ", (String)null);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getJavaTypeName() + "' objects initialized with a given store id.");
            codeBuilder.last().appendln("     * It is equivalent to using '" + type.getJavaTypeName() + ".create(int)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "(final int grid, final %{com.eaio.uuid.UUID} id) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromJson(grid, id, (String)null);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getJavaTypeName() + "' objects");
            codeBuilder.last().appendln("     * from json encoded content objects. It is equivalent to using '" + type.getJavaTypeName());
            codeBuilder.last().appendln("     * .create(int, String)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromJson(final int grid, final String json) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromJson(grid, " + (type instanceof AdmMessage ? "null" : "new %{com.eaio.uuid.UUID}()") + ", json);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getJavaTypeName() + "' objects");
            codeBuilder.last().appendln("     * from json encoded content objects. It is equivalent to using '" + type.getJavaTypeName());
            codeBuilder.last().appendln("     * .create(int, String)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromRawJson(final int grid, final String json) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromJson(grid, json);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects");
            codeBuilder.last().appendln("     * from json encoded content objects serialized as ByteBuffers. It is equivalent to");
            codeBuilder.last().appendln("     * using '" + type.getName() + ".create(int, String)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedJson(final int grid, final %{java.nio.ByteBuffer} serializedJson) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromSerializedJson(grid, " + (type instanceof AdmMessage ? "null" : "new %{com.eaio.uuid.UUID}()") + ", serializedJson);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getJavaTypeName() + "' objects");
            codeBuilder.last().appendln("     * from json encoded content objects serialized as byte arrays. It is equivalent to");
            codeBuilder.last().appendln("     * using '" + type.getJavaTypeName() + ".create(int, String)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedJson(final int grid, final byte[] serializedJson) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromSerializedJson(grid, " + (type instanceof AdmMessage ? "null" : "new %{com.eaio.uuid.UUID}()") + ", serializedJson);");
            codeBuilder.last().appendln("    }");
        } else if (type instanceof AdmCollection) {
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects.");
            codeBuilder.last().appendln("     * It is equivalent to using '" + type.getName() + ".create()'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "() {");
            codeBuilder.last().appendln("        return new " + type.getName() + "(new %{com.eaio.uuid.UUID}());");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getName() + "' objects initialized with a given store id.");
            codeBuilder.last().appendln("     * It is equivalent to using '" + type.getName() + ".create(id)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "(final %{com.eaio.uuid.UUID} id) {");
            codeBuilder.last().appendln("        return new " + type.getName() + "(id);");
            codeBuilder.last().appendln("    }");
        } else {
            codeBuilder.last().appendln("    /*");
            codeBuilder.last().appendln("     * Core " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final private static " + type.getJavaTypeName() + " create" + type.getName() + "FromJson(final %{com.eaio.uuid.UUID} id, final String json) {");
            codeBuilder.last().appendln("        try {");
            codeBuilder.last().appendln("            return new " + type.getJavaTypeName() + "(id, json);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        catch (Exception e) {");
            codeBuilder.last().appendln("            if (e instanceof RuntimeException) {");
            codeBuilder.last().appendln("                throw (RuntimeException)e;");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("            else {");
            codeBuilder.last().appendln("                throw new RuntimeException(e);");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /*");
            codeBuilder.last().appendln("     * Core " + type.getName() + " factory method for creation from byte buffers");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final private static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedJson(final %{com.eaio.uuid.UUID} id, final %{java.nio.ByteBuffer} serializedJson) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromJson(id, com.google.protobuf.ByteString.copyFrom(serializedJson).toStringUtf8());");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /*");
            codeBuilder.last().appendln("     * Core " + type.getName() + " factory method for creation from byte arrays");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final private static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedJson(final %{com.eaio.uuid.UUID} id, final byte[] serializedJson) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromJson(id, com.google.protobuf.ByteString.copyFrom(serializedJson).toStringUtf8());");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getJavaTypeName() + "' objects.");
            codeBuilder.last().appendln("     * It is equivalent to using '" + type.getJavaTypeName() + ".create(int)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "() {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromJson(" + (type instanceof AdmMessage ? "null" : "new %{com.eaio.uuid.UUID}()") + ", (String)null);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getJavaTypeName() + "' objects initialized with a given store id.");
            codeBuilder.last().appendln("     * It is equivalent to using '" + type.getJavaTypeName() + ".create(int)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "(final %{com.eaio.uuid.UUID} id) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromJson(id, (String)null);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getJavaTypeName() + "' objects");
            codeBuilder.last().appendln("     * from json encoded content objects. It is equivalent to using '" + type.getJavaTypeName());
            codeBuilder.last().appendln("     * .create(int, String)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromJson(final String json) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromJson(" + (type instanceof AdmMessage ? "null" : "new %{com.eaio.uuid.UUID}()") + ", json);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getJavaTypeName() + "' objects");
            codeBuilder.last().appendln("     * from json encoded content objects. It is equivalent to using '" + type.getJavaTypeName());
            codeBuilder.last().appendln("     * .create(int, String)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromRawJson(final String json) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromJson(json);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getJavaTypeName() + "' objects");
            codeBuilder.last().appendln("     * from json encoded content objects serialized as ByteBuffers. It is equivalent to");
            codeBuilder.last().appendln("     * using '" + type.getJavaTypeName() + ".create(int, String)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedJson(final %{java.nio.ByteBuffer} serializedJson) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromSerializedJson(" + (type instanceof AdmMessage ? "null" : "new %{com.eaio.uuid.UUID}()") + ", serializedJson);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getJavaTypeName() + "' objects");
            codeBuilder.last().appendln("     * from json encoded content objects serialized as ByteBuffers. It is equivalent to");
            codeBuilder.last().appendln("     * using '" + type.getJavaTypeName() + ".create(int, String)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedRawJson(final %{java.nio.ByteBuffer} serializedJson) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromSerializedJson(serializedJson);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getJavaTypeName() + "' objects");
            codeBuilder.last().appendln("     * from json encoded content objects serialized as byte arrays. It is equivalent to");
            codeBuilder.last().appendln("     * using '" + type.getJavaTypeName() + ".create(int, String)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedJson(final byte[] serializedJson) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromSerializedJson(" + (type instanceof AdmMessage ? "null" : "new %{com.eaio.uuid.UUID}()") + ", serializedJson);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * " + type.getName() + " factory method.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * This method is the factory method for creating '" + type.getJavaTypeName() + "' objects");
            codeBuilder.last().appendln("     * from json encoded content objects serialized as byte arrays. It is equivalent to");
            codeBuilder.last().appendln("     * using '" + type.getJavaTypeName() + ".create(int, String)'.");
            codeBuilder.last().appendln("     * </p>");
            codeBuilder.last().appendln("     */");
            if (type.isDeprecated()) {
                codeBuilder.last().appendln("    @Deprecated");
            }
            codeBuilder.last().appendln("    final public static " + type.getJavaTypeName() + " create" + type.getName() + "FromSerializedRawJson(final byte[] serializedJson) {");
            codeBuilder.last().appendln("        return create" + type.getName() + "FromSerializedJson(serializedJson);");
            codeBuilder.last().appendln("    }");
        }
    }

    private final void writeObjectFactoryMethods(AdmSourceCodeBuilder codeBuilder, AdmEncodingType encodingType) {
        Iterator<AdmFactoryType> iterator = this.typeIterator();
        while (iterator.hasNext()) {
            AdmFactoryType type = iterator.next();
            if (type instanceof AdmEntity && ((AdmEntity)type).isEmbedded()) continue;
            switch (encodingType) {
                case Xbuf2: {
                    this.writeObjectFactoryMethodsXbuf2(type, codeBuilder);
                    break;
                }
                case Xbuf: {
                    this.writeObjectFactoryMethodsXbuf(type, codeBuilder);
                    break;
                }
                case Protobuf: {
                    this.writeObjectFactoryMethodsProto(type, codeBuilder);
                    break;
                }
                case Json: {
                    this.writeObjectFactoryMethodsJson(type, codeBuilder);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown encoding type " + (Object)((Object)encodingType));
                }
            }
            if (!iterator.hasNext()) continue;
            codeBuilder.last().appendln("");
        }
    }

    private final void writeImplementedIStoreObjectFactoryMethods(AdmSourceCodeBuilder codeBuilder, AdmEncodingType encodingType) {
        codeBuilder.last().appendln("    /** ");
        codeBuilder.last().appendln("     * Implementation of {@link %{com.neeve.ods.IStoreObjectFactory}#getOfid}");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public short getOfid() {");
        codeBuilder.last().appendln("        return OFID;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("    /** ");
        codeBuilder.last().appendln("     * Implementation of {@link %{com.neeve.ods.IStoreObjectFactory}#create}");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public %{com.neeve.ods.IStoreObject} create(final short type,");
        codeBuilder.last().appendln("                                     final %{com.eaio.uuid.UUID} id,");
        codeBuilder.last().appendln("                                     final %{com.neeve.ods.IStoreObject}.EncodingType encodingType,");
        codeBuilder.last().appendln("                                     final %{com.neeve.pkt.PktPacket} packet) {");
        codeBuilder.last().appendln("        try {");
        codeBuilder.last().appendln("            switch (encodingType) {");
        if (encodingType == AdmEncodingType.Xbuf2) {
            codeBuilder.last().appendln("                case Protobuf:");
            codeBuilder.last().appendln("                case Xbuf:");
            codeBuilder.last().appendln("                case Xbuf2:");
            codeBuilder.last().appendln("                    switch (type) {");
            Iterator<AdmFactoryType> iterator = this.typeIterator();
            while (iterator.hasNext()) {
                AdmFactoryType type = iterator.next();
                if (type instanceof AdmEntity && ((AdmEntity)type).isEmbedded()) continue;
                codeBuilder.last().appendln("                        case ID_" + type.getName() + ":");
                if (type instanceof AdmEntity && ((AdmEntity)type).isRoot()) {
                    codeBuilder.last().appendln("                            return create" + type.getName() + "(-1, id).deserialize(packet);");
                } else {
                    codeBuilder.last().appendln("                            return create" + type.getName() + "(id).deserialize(packet);");
                }
                codeBuilder.last().appendln("");
            }
            codeBuilder.last().appendln("                        default:");
            codeBuilder.last().appendln("                            throw new RuntimeException(\"unknown object type: \" + type);");
            codeBuilder.last().appendln("                    }");
            codeBuilder.last().appendln("");
        } else if (encodingType == AdmEncodingType.Xbuf) {
            codeBuilder.last().appendln("                case Xbuf:");
            codeBuilder.last().appendln("                    switch (type) {");
            Iterator<AdmFactoryType> iterator = this.typeIterator();
            while (iterator.hasNext()) {
                AdmFactoryType type = iterator.next();
                if (type instanceof AdmEntity && ((AdmEntity)type).isEmbedded()) continue;
                codeBuilder.last().appendln("                        case ID_" + type.getName() + ":");
                if (type instanceof AdmCollection) {
                    codeBuilder.last().appendln("                            return create" + type.getName() + "(id).deserialize(packet);");
                } else if (type instanceof AdmEntity && ((AdmEntity)type).isRoot()) {
                    codeBuilder.last().appendln("                            return create" + type.getName() + "FromXbufContainerPacket(-1, id, packet);");
                } else {
                    codeBuilder.last().appendln("                            return create" + type.getName() + "FromXbufContainerPacket(id, packet);");
                }
                codeBuilder.last().appendln("");
            }
            codeBuilder.last().appendln("                        default:");
            codeBuilder.last().appendln("                            throw new RuntimeException(\"unknown object type: \" + type);");
            codeBuilder.last().appendln("                    }");
            codeBuilder.last().appendln("");
        } else if (encodingType == AdmEncodingType.Protobuf) {
            codeBuilder.last().appendln("                case Protobuf:");
            codeBuilder.last().appendln("                    switch (type) {");
            Iterator<AdmFactoryType> iterator = this.typeIterator();
            while (iterator.hasNext()) {
                AdmFactoryType type = iterator.next();
                if (type instanceof AdmEntity && ((AdmEntity)type).isEmbedded()) continue;
                codeBuilder.last().appendln("                        case ID_" + type.getName() + ":");
                if (type instanceof AdmCollection) {
                    codeBuilder.last().appendln("                            return create" + type.getName() + "(id).deserialize(packet);");
                } else if (type instanceof AdmEntity && ((AdmEntity)type).isRoot()) {
                    codeBuilder.last().appendln("                            return create" + type.getName() + "FromSerializedProtoMessage(-1, id, packet);");
                } else {
                    codeBuilder.last().appendln("                            return create" + type.getName() + "FromSerializedProtoMessage(id, packet);");
                }
                codeBuilder.last().appendln("");
            }
            codeBuilder.last().appendln("                        default:");
            codeBuilder.last().appendln("                            throw new RuntimeException(\"unknown object type: \" + type);");
            codeBuilder.last().appendln("                    }");
            codeBuilder.last().appendln("");
        } else if (encodingType == AdmEncodingType.Json) {
            codeBuilder.last().appendln("                case Json:");
            codeBuilder.last().appendln("                    switch (type) {");
            Iterator<AdmFactoryType> iterator = this.typeIterator();
            while (iterator.hasNext()) {
                AdmFactoryType type = iterator.next();
                if (type instanceof AdmEntity && ((AdmEntity)type).isEmbedded()) continue;
                codeBuilder.last().appendln("                       case ID_" + type.getName() + ":");
                if (type instanceof AdmCollection) {
                    codeBuilder.last().appendln("                            return create" + type.getName() + "(id).deserialize(packet);");
                } else if (type instanceof AdmEntity && ((AdmEntity)type).isRoot()) {
                    codeBuilder.last().appendln("                           return create" + type.getName() + "FromJson(-1, id, ((%{com.neeve.pkt.types.PktBodyText})packet.getBody()).getText());");
                } else {
                    codeBuilder.last().appendln("                           return create" + type.getName() + "FromJson(id, ((%{com.neeve.pkt.types.PktBodyText})packet.getBody()).getText());");
                }
                codeBuilder.last().appendln("");
            }
            codeBuilder.last().appendln("                        default:");
            codeBuilder.last().appendln("                            throw new RuntimeException(\"unknown object type: \" + type);");
            codeBuilder.last().appendln("                    }");
            codeBuilder.last().appendln("");
        } else {
            throw new IllegalArgumentException("unsupported encoding type '" + (Object)((Object)encodingType) + "'");
        }
        codeBuilder.last().appendln("                default:");
        codeBuilder.last().appendln("                    throw new RuntimeException(\"unknown encoding type: \" + encodingType);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        catch (Exception e) {");
        codeBuilder.last().appendln("            if (e instanceof RuntimeException) {");
        codeBuilder.last().appendln("                throw (RuntimeException)e;");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            else {");
        codeBuilder.last().appendln("                throw new RuntimeException(e);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
    }

    private final void writeImplementedMessageViewFactoryMethods(AdmSourceCodeBuilder codeBuilder, AdmEncodingType encodingType) {
        AdmFactoryType type;
        codeBuilder.last().appendln("    /** ");
        codeBuilder.last().appendln("     * Implementation of {@link %{com.neeve.sma.MessageViewFactory}#getVfid}");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public short getVfid() {");
        codeBuilder.last().appendln("        return VFID;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("    /** ");
        codeBuilder.last().appendln("     * Implementation of {@link %{com.neeve.sma.MessageViewFactory}#create}");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public %{com.neeve.sma.MessageView} create(final short type) {");
        codeBuilder.last().appendln("        try {");
        codeBuilder.last().appendln("            switch (type) {");
        Iterator<AdmFactoryType> iterator = this.typeIterator();
        while (iterator.hasNext()) {
            type = iterator.next();
            if (type instanceof AdmEntity && ((AdmEntity)type).isEmbedded() || !(type instanceof AdmMessage)) continue;
            codeBuilder.last().appendln("                case ID_" + type.getName() + ":");
            codeBuilder.last().appendln("                    return create" + type.getName() + "();");
            codeBuilder.last().appendln("");
        }
        codeBuilder.last().appendln("                default:");
        codeBuilder.last().appendln("                    throw new RuntimeException(\"unknown messsage type: \" + type);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        catch (Exception e) {");
        codeBuilder.last().appendln("            if (e instanceof RuntimeException) {");
        codeBuilder.last().appendln("                throw (RuntimeException)e;");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            else {");
        codeBuilder.last().appendln("                throw new RuntimeException(e);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("    /** ");
        codeBuilder.last().appendln("     * Implementation of {@link %{com.neeve.sma.MessageViewFactory}#wrap}");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    @Override");
        if (encodingType == AdmEncodingType.Protobuf && this.getDeprecatedTypeCount(true) > 0) {
            codeBuilder.last().appendln("    @SuppressWarnings(\"deprecation\")");
        }
        codeBuilder.last().appendln("    final public %{com.neeve.sma.MessageView} wrap(final short type, final int encodingType, final Object message) {");
        codeBuilder.last().appendln("        try {");
        codeBuilder.last().appendln("            switch (encodingType) {");
        if (encodingType == AdmEncodingType.Xbuf2) {
            codeBuilder.last().appendln("                case %{com.neeve.sma.MessageView}.ENCODING_TYPE_PROTOBUF:");
            codeBuilder.last().appendln("                case %{com.neeve.sma.MessageView}.ENCODING_TYPE_XBUF:");
            codeBuilder.last().appendln("                case %{com.neeve.sma.MessageView}.ENCODING_TYPE_XBUF2:");
            codeBuilder.last().appendln("                    if (message instanceof %{com.neeve.quark.QuarkPacket}) {");
            codeBuilder.last().appendln("                        switch (type) {");
            iterator = this.typeIterator();
            while (iterator.hasNext()) {
                type = iterator.next();
                if (type instanceof AdmEntity && ((AdmEntity)type).isEmbedded() || !(type instanceof AdmMessage)) continue;
                codeBuilder.last().appendln("                            case ID_" + type.getName() + ":");
                codeBuilder.last().appendln("                                return create" + type.getName() + "(null).deserializeFrom(((%{com.neeve.quark.QuarkPacket})message).buf, ((%{com.neeve.quark.QuarkPacket})message).offset, ((%{com.neeve.quark.QuarkPacket})message).length);");
                codeBuilder.last().appendln("");
            }
            codeBuilder.last().appendln("                            default:");
            codeBuilder.last().appendln("                                throw new RuntimeException(\"unknown message type: \" + type);");
            codeBuilder.last().appendln("                        }");
            codeBuilder.last().appendln("                    }");
            codeBuilder.last().appendln("                    else if (message instanceof %{com.neeve.pkt.PktPacket}) {");
            codeBuilder.last().appendln("                        switch (type) {");
            iterator = this.typeIterator();
            while (iterator.hasNext()) {
                type = iterator.next();
                if (type instanceof AdmEntity && ((AdmEntity)type).isEmbedded() || !(type instanceof AdmMessage)) continue;
                codeBuilder.last().appendln("                            case ID_" + type.getName() + ":");
                codeBuilder.last().appendln("                                return create" + type.getName() + "(null).deserializeFrom((%{com.neeve.pkt.PktPacket})message);");
                codeBuilder.last().appendln("");
            }
            codeBuilder.last().appendln("                            default:");
            codeBuilder.last().appendln("                                throw new RuntimeException(\"unknown message type: \" + type);");
            codeBuilder.last().appendln("                        }");
            codeBuilder.last().appendln("                    }");
            codeBuilder.last().appendln("                    else if (message instanceof byte[]) {");
            codeBuilder.last().appendln("                        switch (type) {");
            iterator = this.typeIterator();
            while (iterator.hasNext()) {
                type = iterator.next();
                if (type instanceof AdmEntity && ((AdmEntity)type).isEmbedded() || !(type instanceof AdmMessage)) continue;
                codeBuilder.last().appendln("                            case ID_" + type.getName() + ": {");
                codeBuilder.last().appendln("                                return create" + type.getName() + "(null).deserializeFrom((byte[])message, 0, ((byte[])message).length);");
                codeBuilder.last().appendln("                            }");
                codeBuilder.last().appendln("");
            }
            codeBuilder.last().appendln("                            default:");
            codeBuilder.last().appendln("                                throw new RuntimeException(\"unknown object type: \" + type);");
            codeBuilder.last().appendln("                        }");
            codeBuilder.last().appendln("                    }");
            codeBuilder.last().appendln("                    else if (message instanceof %{java.nio.ByteBuffer}) {");
            codeBuilder.last().appendln("                        switch (type) {");
            iterator = this.typeIterator();
            while (iterator.hasNext()) {
                type = iterator.next();
                if (type instanceof AdmEntity && ((AdmEntity)type).isEmbedded() || !(type instanceof AdmMessage)) continue;
                codeBuilder.last().appendln("                            case ID_" + type.getName() + ": {");
                codeBuilder.last().appendln("                                return create" + type.getName() + "(null).deserializeFrom((%{java.nio.ByteBuffer})message);");
                codeBuilder.last().appendln("                            }");
                codeBuilder.last().appendln("");
            }
            codeBuilder.last().appendln("                            default:");
            codeBuilder.last().appendln("                                throw new RuntimeException(\"unknown object type: \" + type);");
            codeBuilder.last().appendln("                        }");
            codeBuilder.last().appendln("                    }");
            codeBuilder.last().appendln("                    else {");
            codeBuilder.last().appendln("                        throw new RuntimeException(\"unsupported serialized form '\" + message.getClass().getName() + \"' for XBUF encoded message\");");
            codeBuilder.last().appendln("                    }");
            codeBuilder.last().appendln("");
        } else if (encodingType == AdmEncodingType.Xbuf) {
            codeBuilder.last().appendln("                case %{com.neeve.sma.MessageView}.ENCODING_TYPE_XBUF:");
            codeBuilder.last().appendln("                    if (message instanceof %{com.neeve.pkt.PktPacket}) {");
            codeBuilder.last().appendln("                        switch (type) {");
            iterator = this.typeIterator();
            while (iterator.hasNext()) {
                type = iterator.next();
                if (type instanceof AdmEntity && ((AdmEntity)type).isEmbedded() || !(type instanceof AdmMessage)) continue;
                codeBuilder.last().appendln("                            case ID_" + type.getName() + ":");
                codeBuilder.last().appendln("                                return create" + type.getName() + "FromXbufContainerPacket(null, (%{com.neeve.pkt.PktPacket})message);");
                codeBuilder.last().appendln("");
            }
            codeBuilder.last().appendln("                            default:");
            codeBuilder.last().appendln("                                throw new RuntimeException(\"unknown message type: \" + type);");
            codeBuilder.last().appendln("                        }");
            codeBuilder.last().appendln("                    }");
            codeBuilder.last().appendln("                    else if (message instanceof byte[]) {");
            codeBuilder.last().appendln("                        switch (type) {");
            iterator = this.typeIterator();
            while (iterator.hasNext()) {
                type = iterator.next();
                if (type instanceof AdmEntity && ((AdmEntity)type).isEmbedded() || !(type instanceof AdmMessage)) continue;
                codeBuilder.last().appendln("                            case ID_" + type.getName() + ": {");
                codeBuilder.last().appendln("                                return create" + type.getName() + "FromSerializedXbufContainer(null, (byte[])message);");
                codeBuilder.last().appendln("                            }");
                codeBuilder.last().appendln("");
            }
            codeBuilder.last().appendln("                            default:");
            codeBuilder.last().appendln("                                throw new RuntimeException(\"unknown object type: \" + type);");
            codeBuilder.last().appendln("                        }");
            codeBuilder.last().appendln("                    }");
            codeBuilder.last().appendln("                    else if (message instanceof %{java.nio.ByteBuffer}) {");
            codeBuilder.last().appendln("                        switch (type) {");
            iterator = this.typeIterator();
            while (iterator.hasNext()) {
                type = iterator.next();
                if (type instanceof AdmEntity && ((AdmEntity)type).isEmbedded() || !(type instanceof AdmMessage)) continue;
                codeBuilder.last().appendln("                            case ID_" + type.getName() + ": {");
                codeBuilder.last().appendln("                                return create" + type.getName() + "FromSerializedXbufContainer(null, (%{java.nio.ByteBuffer})message);");
                codeBuilder.last().appendln("                            }");
                codeBuilder.last().appendln("");
            }
            codeBuilder.last().appendln("                            default:");
            codeBuilder.last().appendln("                                throw new RuntimeException(\"unknown object type: \" + type);");
            codeBuilder.last().appendln("                        }");
            codeBuilder.last().appendln("                    }");
            codeBuilder.last().appendln("                    else {");
            codeBuilder.last().appendln("                        throw new RuntimeException(\"unsupported serialized form '\" + message.getClass().getName() + \"' for XBUF encoded message\");");
            codeBuilder.last().appendln("                    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("                case %{com.neeve.sma.MessageView}.ENCODING_TYPE_PROTOBUF:");
            codeBuilder.last().appendln("                    if (message instanceof byte[]) {");
            codeBuilder.last().appendln("                        switch (type) {");
            iterator = this.typeIterator();
            while (iterator.hasNext()) {
                type = iterator.next();
                if (type instanceof AdmEntity && ((AdmEntity)type).isEmbedded() || !(type instanceof AdmMessage)) continue;
                codeBuilder.last().appendln("                            case ID_" + type.getName() + ":");
                codeBuilder.last().appendln("                                return create" + type.getName() + "FromSerializedXbufContainer(null, (byte[])message);");
                codeBuilder.last().appendln("");
            }
            codeBuilder.last().appendln("                            default:");
            codeBuilder.last().appendln("                                throw new RuntimeException(\"unknown message type: \" + type);");
            codeBuilder.last().appendln("                        }");
            codeBuilder.last().appendln("                    }");
            codeBuilder.last().appendln("                    else if (message instanceof %{java.nio.ByteBuffer}) {");
            codeBuilder.last().appendln("                        switch (type) {");
            iterator = this.typeIterator();
            while (iterator.hasNext()) {
                type = iterator.next();
                if (type instanceof AdmEntity && ((AdmEntity)type).isEmbedded() || !(type instanceof AdmMessage)) continue;
                codeBuilder.last().appendln("                            case ID_" + type.getName() + ":");
                codeBuilder.last().appendln("                                return create" + type.getName() + "FromSerializedXbufContainer(null, (%{java.nio.ByteBuffer})message);");
                codeBuilder.last().appendln("");
            }
            codeBuilder.last().appendln("                            default:");
            codeBuilder.last().appendln("                                throw new RuntimeException(\"unknown message type: \" + type);");
            codeBuilder.last().appendln("                        }");
            codeBuilder.last().appendln("                    }");
            codeBuilder.last().appendln("                    else if (message instanceof %{com.neeve.pkt.PktPacket}) {");
            codeBuilder.last().appendln("                        switch (type) {");
            iterator = this.typeIterator();
            while (iterator.hasNext()) {
                type = iterator.next();
                if (type instanceof AdmEntity && ((AdmEntity)type).isEmbedded() || !(type instanceof AdmMessage)) continue;
                codeBuilder.last().appendln("                            case ID_" + type.getName() + ":");
                codeBuilder.last().appendln("                                return create" + type.getName() + "FromXbufContainerPacket(null, (%{com.neeve.pkt.PktPacket})message);");
                codeBuilder.last().appendln("");
            }
            codeBuilder.last().appendln("                            default:");
            codeBuilder.last().appendln("                                throw new RuntimeException(\"unknown message type: \" + type);");
            codeBuilder.last().appendln("                        }");
            codeBuilder.last().appendln("                    }");
            codeBuilder.last().appendln("                    else {");
            codeBuilder.last().appendln("                        throw new RuntimeException(\"unsupported serialized form '\" + message.getClass().getName() + \"' for PROTOBUF encoded message\");");
            codeBuilder.last().appendln("                    }");
            codeBuilder.last().appendln("");
        } else if (encodingType == AdmEncodingType.Protobuf) {
            codeBuilder.last().appendln("                case %{com.neeve.sma.MessageView}.ENCODING_TYPE_XBUF:");
            codeBuilder.last().appendln("                case %{com.neeve.sma.MessageView}.ENCODING_TYPE_PROTOBUF:");
            codeBuilder.last().appendln("                    if (message instanceof byte[]) {");
            codeBuilder.last().appendln("                        switch (type) {");
            iterator = this.typeIterator();
            while (iterator.hasNext()) {
                type = iterator.next();
                if (type instanceof AdmEntity && ((AdmEntity)type).isEmbedded() || !(type instanceof AdmMessage)) continue;
                codeBuilder.last().appendln("                            case ID_" + type.getName() + ": {");
                codeBuilder.last().appendln("                                return create" + type.getName() + "FromSerializedProtoMessage(null, (byte[])message);");
                codeBuilder.last().appendln("                            }");
                codeBuilder.last().appendln("");
            }
            codeBuilder.last().appendln("                            default:");
            codeBuilder.last().appendln("                                throw new RuntimeException(\"unknown object type: \" + type);");
            codeBuilder.last().appendln("                        }");
            codeBuilder.last().appendln("                    }");
            codeBuilder.last().appendln("                    else if (message instanceof %{java.nio.ByteBuffer}) {");
            codeBuilder.last().appendln("                        final %{java.nio.ByteBuffer} serializedProtoAsByteBuffer = (%{java.nio.ByteBuffer})message;");
            codeBuilder.last().appendln("                        serializedProtoAsByteBuffer.mark();");
            codeBuilder.last().appendln("                        switch (type) {");
            iterator = this.typeIterator();
            while (iterator.hasNext()) {
                type = iterator.next();
                if (type instanceof AdmEntity && ((AdmEntity)type).isEmbedded() || !(type instanceof AdmMessage)) continue;
                codeBuilder.last().appendln("                            case ID_" + type.getName() + ": {");
                codeBuilder.last().appendln("                                final " + type.getJavaTypeName() + " wrapped = create" + type.getName() + "FromSerializedProtoMessage(null, serializedProtoAsByteBuffer);");
                codeBuilder.last().appendln("                                serializedProtoAsByteBuffer.reset();");
                codeBuilder.last().appendln("                                return wrapped;");
                codeBuilder.last().appendln("                            }");
                codeBuilder.last().appendln("");
            }
            codeBuilder.last().appendln("                            default:");
            codeBuilder.last().appendln("                                throw new RuntimeException(\"unknown object type: \" + type);");
            codeBuilder.last().appendln("                        }");
            codeBuilder.last().appendln("                    }");
            codeBuilder.last().appendln("                    else if (message instanceof %{com.neeve.pkt.PktPacket}) {");
            codeBuilder.last().appendln("                        switch (type) {");
            iterator = this.typeIterator();
            while (iterator.hasNext()) {
                type = iterator.next();
                if (type instanceof AdmEntity && ((AdmEntity)type).isEmbedded() || !(type instanceof AdmMessage)) continue;
                codeBuilder.last().appendln("                            case ID_" + type.getName() + ":");
                codeBuilder.last().appendln("                                return create" + type.getName() + "FromSerializedProtoMessage(null, (%{com.neeve.pkt.PktPacket})message);");
                codeBuilder.last().appendln("");
            }
            codeBuilder.last().appendln("                            default:");
            codeBuilder.last().appendln("                                throw new RuntimeException(\"unknown message type: \" + type);");
            codeBuilder.last().appendln("                        }");
            codeBuilder.last().appendln("                    }");
            codeBuilder.last().appendln("                    else if (message instanceof com.google.protobuf.Message) {");
            codeBuilder.last().appendln("                        switch (type) {");
            iterator = this.typeIterator();
            while (iterator.hasNext()) {
                type = iterator.next();
                if (type instanceof AdmEntity && ((AdmEntity)type).isEmbedded() || !(type instanceof AdmMessage)) continue;
                codeBuilder.last().appendln("                            case ID_" + type.getName() + ":");
                codeBuilder.last().appendln("                                return create" + type.getName() + "FromProtoMessage(null, (" + this.protobufName(type) + ")message);");
                codeBuilder.last().appendln("");
            }
            codeBuilder.last().appendln("                            default:");
            codeBuilder.last().appendln("                                throw new RuntimeException(\"unknown message type: \" + type);");
            codeBuilder.last().appendln("                        }");
            codeBuilder.last().appendln("                    }");
            codeBuilder.last().appendln("                    else {");
            codeBuilder.last().appendln("                        throw new RuntimeException(\"unsupported serialized form '\" + message.getClass().getName() + \"' for PROTOBUF encoded message\");");
            codeBuilder.last().appendln("                    }");
            codeBuilder.last().appendln("");
        } else if (encodingType == AdmEncodingType.Json) {
            codeBuilder.last().appendln("                case %{com.neeve.sma.MessageView}.ENCODING_TYPE_JSON:");
            codeBuilder.last().appendln("                    if (message instanceof String) {");
            if (this.getMessageCount() > 0) {
                codeBuilder.last().appendln("                        final String json3 = (String)message;");
            }
            codeBuilder.last().appendln("                        switch (type) {");
            iterator = this.typeIterator();
            while (iterator.hasNext()) {
                type = iterator.next();
                if (type instanceof AdmEntity && ((AdmEntity)type).isEmbedded() || !(type instanceof AdmMessage)) continue;
                codeBuilder.last().appendln("                            case ID_" + type.getName() + ":");
                codeBuilder.last().appendln("                                return create" + type.getName() + "FromJson(null, json3);");
                codeBuilder.last().appendln("");
            }
            codeBuilder.last().appendln("                            default:");
            codeBuilder.last().appendln("                                throw new RuntimeException(\"unknown message type: \" + type);");
            codeBuilder.last().appendln("                        }");
            codeBuilder.last().appendln("                    }");
            codeBuilder.last().appendln("                    else if (message instanceof byte[]) {");
            codeBuilder.last().appendln("                        switch (type) {");
            iterator = this.typeIterator();
            while (iterator.hasNext()) {
                type = iterator.next();
                if (type instanceof AdmEntity && ((AdmEntity)type).isEmbedded() || !(type instanceof AdmMessage)) continue;
                codeBuilder.last().appendln("                            case ID_" + type.getName() + ": {");
                codeBuilder.last().appendln("                                return create" + type.getName() + "FromJson(null, com.google.protobuf.ByteString.copyFrom((byte[])message).toStringUtf8());");
                codeBuilder.last().appendln("                            }");
                codeBuilder.last().appendln("");
            }
            codeBuilder.last().appendln("                            default:");
            codeBuilder.last().appendln("                                throw new RuntimeException(\"unknown object type: \" + type);");
            codeBuilder.last().appendln("                        }");
            codeBuilder.last().appendln("                    }");
            codeBuilder.last().appendln("                    else if (message instanceof %{java.nio.ByteBuffer}) {");
            codeBuilder.last().appendln("                        switch (type) {");
            iterator = this.typeIterator();
            while (iterator.hasNext()) {
                type = iterator.next();
                if (type instanceof AdmEntity && ((AdmEntity)type).isEmbedded() || !(type instanceof AdmMessage)) continue;
                codeBuilder.last().appendln("                            case ID_" + type.getName() + ": {");
                codeBuilder.last().appendln("                                return create" + type.getName() + "FromJson(null, com.google.protobuf.ByteString.copyFrom((%{java.nio.ByteBuffer})message).toStringUtf8());");
                codeBuilder.last().appendln("                            }");
                codeBuilder.last().appendln("");
            }
            codeBuilder.last().appendln("                            default:");
            codeBuilder.last().appendln("                                throw new RuntimeException(\"unknown object type: \" + type);");
            codeBuilder.last().appendln("                        }");
            codeBuilder.last().appendln("                    }");
            codeBuilder.last().appendln("                    else {");
            codeBuilder.last().appendln("                        throw new RuntimeException(\"unsupported serialized form '\" + message.getClass().getName() + \"' for JSON encoded message\");");
            codeBuilder.last().appendln("                    }");
            codeBuilder.last().appendln("");
        } else {
            throw new IllegalArgumentException("unsupported encoding type '" + (Object)((Object)encodingType) + "'");
        }
        codeBuilder.last().appendln("                default:");
        codeBuilder.last().appendln("                    throw new RuntimeException(\"unknown encoding type: \" + encodingType);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        catch (Exception e) {");
        codeBuilder.last().appendln("            if (e instanceof RuntimeException) {");
        codeBuilder.last().appendln("                throw (RuntimeException)e;");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            else {");
        codeBuilder.last().appendln("                throw new RuntimeException(e);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
    }

    private final void writeMainMethod(AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    final private static void printUsage() {");
        codeBuilder.last().appendln("        java.lang.System.err.println(\"Usage: " + this.getName() + " <options>\");");
        codeBuilder.last().appendln("        java.lang.System.err.println(\"Options:\");");
        codeBuilder.last().appendln("        java.lang.System.err.println(\"    [{-j, --jsonSchema} generate json schemas]\");");
        codeBuilder.last().appendln("        java.lang.System.err.println(\"       Generate schemas for all elements handled by this factory to standard output. \");");
        codeBuilder.last().appendln("        java.lang.System.err.println(\"    [{-h, --help} print this help string]\");");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    final public static void main(final String args[]) throws Exception {");
        codeBuilder.last().appendln("        final jargs.gnu.CmdLineParser parser = new jargs.gnu.CmdLineParser();");
        codeBuilder.last().appendln("        final jargs.gnu.CmdLineParser.Option jsonSchemaOption = parser.addBooleanOption('j', \"jsonSchema\");");
        codeBuilder.last().appendln("        final jargs.gnu.CmdLineParser.Option helpOption = parser.addBooleanOption('h', \"help\");");
        codeBuilder.last().appendln("        try {");
        codeBuilder.last().appendln("            parser.parse(args);");
        codeBuilder.last().appendln("            if (!((Boolean)parser.getOptionValue(helpOption, false))) {");
        codeBuilder.last().appendln("                if (((Boolean)parser.getOptionValue(jsonSchemaOption, false))) {");
        codeBuilder.last().appendln("                    java.lang.System.out.println(generateJsonSchemas());");
        codeBuilder.last().appendln("                }");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            else {");
        codeBuilder.last().appendln("                printUsage();");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        catch (Exception e) {");
        codeBuilder.last().appendln("            java.lang.System.err.println(e.getMessage());");
        codeBuilder.last().appendln("            printUsage();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
    }

    public final void generateClass(AdmSourceCodeBuilder codeBuilder, AdmEncodingType encodingType) throws EAdmException {
        if (encodingType == AdmEncodingType.Xbuf || encodingType == AdmEncodingType.Xbuf2) {
            boolean error = false;
            String message = null;
            if (this.id <= 0 && this.id < -65506) {
                error = true;
                message = "platform factory ids must be between 0 and -65506 both inclusive";
            }
            if (this.id >= 1 && this.id > 65538) {
                error = true;
                message = "user factory ids must be between 1 and 65538 both inclusive";
            }
            if (this.types.size() == Short.MAX_VALUE) {
                error = true;
                message = "number of types in factory has exceeded the maximum (32767)";
            }
            if (error) {
                if (this.model.getModelBuildErrorAggregator() != null) {
                    this.model.getModelBuildErrorAggregator().add(message, CgSourceCodeErrorAggregator.Severity.ERROR, this.getCodeSource(), null);
                } else {
                    throw new EAdmException(message, this.getCodeSource());
                }
            }
        }
        codeBuilder.header().appendln("/**");
        codeBuilder.header().appendln(" * ******************************************************************");
        codeBuilder.header().appendln(" * *** THIS FILE IS GENERATED BY X PLATFORM CODE GENERATION TOOLS ***");
        codeBuilder.header().appendln(" * ******************************************************************");
        codeBuilder.header().append(" */");
        codeBuilder.packageName(this.getNamespace());
        codeBuilder.last().appendln("");
        this.writeClassDeclaration(codeBuilder, encodingType);
        this.writeIds(codeBuilder, encodingType);
        codeBuilder.last().appendln("");
        this.writeConstructors(codeBuilder, encodingType);
        if (encodingType == AdmEncodingType.Json) {
            codeBuilder.last().appendln("");
            this.writeJsonSchemaGenerator(codeBuilder);
        }
        codeBuilder.last().appendln("");
        this.writeObjectFactoryMethods(codeBuilder, encodingType);
        codeBuilder.last().appendln("");
        this.writeImplementedIStoreObjectFactoryMethods(codeBuilder, encodingType);
        codeBuilder.last().appendln("");
        this.writeImplementedMessageViewFactoryMethods(codeBuilder, encodingType);
        if (encodingType == AdmEncodingType.Json) {
            codeBuilder.last().appendln("");
            this.writeMainMethod(codeBuilder);
        }
        codeBuilder.last().appendln("}");
    }

    public final void generateClass(File baseOutDir, AdmEncodingType encodingType, boolean absolute) throws Exception {
        File file = AdmModel.resolveAbsoluteClassFile(baseOutDir, absolute ? null : this.getNamespace(), this.getName());
        File dir = file.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        try {
            AdmSourceCodeBuilder codeBuilder = new AdmSourceCodeBuilder();
            this.generateClass(codeBuilder, encodingType);
            codeBuilder.write(file);
        }
        catch (IOException e) {
            throw new EAdmException("Failed to create factory class file '" + file.getPath() + "' [" + e.toString() + "]", this.getCodeSource());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void generateClass(Filer filer, Element ... elements) throws Exception {
        JavaFileObject jfo = filer.createSourceFile(this.getName(), elements);
        try (Writer writer = jfo.openWriter();){
            AdmSourceCodeBuilder codeBuilder = new AdmSourceCodeBuilder();
            this.generateClass(codeBuilder, AdmEncodingType.Xbuf);
            codeBuilder.write(writer);
        }
        catch (IOException e) {
            throw new EAdmException("Failed to create factory class file '" + jfo.toUri() + "' [" + e.toString() + "]", this.getCodeSource());
        }
    }
}

