/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.test.unit.generated.xbuf.Message;
import com.neeve.ci.XRuntime;
import com.neeve.lang.XString;
import com.neeve.sma.MessageBusBindingFactory;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessageChannelKeyResolver;
import com.neeve.sma.MessageView;
import com.neeve.sma.SmaException;
import com.neeve.sma.impl.DefaultMessageChannelKeyResolver;
import com.neeve.util.UtlUnit;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ChannelKeyResolutionTest {
    @Test
    public void testDefaultKeyResolutionFromDefault() throws Throwable {
        Message message = Message.create();
        this.testKeyResolution((MessageView)message, null, null, "/${NonExistentField::DefaultValue}", "/DefaultValue");
    }

    @Test
    public void testNullPaddingInKeyForCString() throws SmaException {
        MessageBusDescriptor busDescriptor = MessageBusDescriptor.create((String)"testBus");
        MessageChannelDescriptor channelDescriptor = MessageChannelDescriptor.create((String)"test", (MessageBusDescriptor)busDescriptor);
        channelDescriptor.setChannelKey("${NonExistentField::DefaultValue}");
        DefaultMessageChannelKeyResolver keyResolver = DefaultMessageChannelKeyResolver.create((MessageChannelDescriptor)channelDescriptor);
        Properties krt = new Properties();
        for (int i = 1; i < 256; ++i) {
            String replacement = "";
            for (int j = 0; j < i; ++j) {
                replacement = replacement + "a";
            }
            com.neeve.aep.test.unit.generated.proto.Message message = com.neeve.aep.test.unit.generated.proto.Message.create();
            krt.setProperty("NonExistentField", replacement);
            message.resolveMessageKeyWith((MessageChannelKeyResolver)keyResolver, krt);
            XString resolvedKey = message.getMessageKeyAsRaw();
            int keyLength = resolvedKey.getSerializedLength();
            int backingBufferCapacity = resolvedKey.getBackingBuffer().getIOBuffer().getCapacity();
            Assert.assertTrue((String)"Backing buffer doesn't have extra byte of capacity as expected", (backingBufferCapacity > keyLength ? 1 : 0) != 0);
            Assert.assertEquals((String)"Wrong key", (Object)replacement, (Object)resolvedKey.getValue());
        }
        MessageChannel.RawKeyResolutionTable rawKrt = MessageBusBindingFactory.createRawKeyResolutionTable();
        for (int i = 1; i < 256; ++i) {
            String replacement = "";
            for (int j = 0; j < i; ++j) {
                replacement = replacement + "a";
            }
            com.neeve.aep.test.unit.generated.proto.Message message = com.neeve.aep.test.unit.generated.proto.Message.create();
            rawKrt.setProperty("NonExistentField", XString.create((String)replacement, (boolean)true, (boolean)true));
            message.resolveMessageKeyWith((MessageChannelKeyResolver)keyResolver, rawKrt);
            XString resolvedKey = message.getMessageKeyAsRaw();
            int keyLength = resolvedKey.getSerializedLength();
            int backingBufferCapacity = resolvedKey.getBackingBuffer().getIOBuffer().getCapacity();
            Assert.assertTrue((String)"Backing buffer doesn't have extra byte of capacity as expected", (backingBufferCapacity > keyLength ? 1 : 0) != 0);
            Assert.assertEquals((String)"Wrong key", (Object)replacement, (Object)resolvedKey.getValue());
        }
    }

    @Test
    public void testKeyResolutionFromChannelKRT() throws Throwable {
        Message message = Message.create();
        Properties krt1 = new Properties();
        krt1.setProperty("SomthingElse", "KRT1Value");
        Properties krt2 = new Properties();
        krt2.setProperty("NonExistentField", "KRT2Value");
        this.testKeyResolution((MessageView)message, krt1, krt2, "/${NonExistentField::DefaultValue}", "/KRT2Value");
    }

    @Test
    public void testKeyResolutionFromSuppliedKRT() throws Throwable {
        Message message = Message.create();
        Properties krt1 = new Properties();
        krt1.setProperty("NonExistentField", "KRT1Value");
        Properties krt2 = new Properties();
        krt2.setProperty("NonExistentField", "KRT2Value");
        this.testKeyResolution((MessageView)message, krt1, krt2, "/${NonExistentField::DefaultValue}", "/KRT1Value");
    }

    @Test
    public void testKeyResolutionFromMessage() throws Throwable {
        Message message = Message.create();
        message.setIntField(10);
        Properties krt1 = new Properties();
        krt1.setProperty("IntField", "KRT1Value");
        Properties krt2 = new Properties();
        krt2.setProperty("IntField", "KRT2Value");
        this.testKeyResolution((MessageView)message, krt1, krt2, "/${IntField::DefaultValue}", "/10");
    }

    @Test
    public void testMixedKRTAndMessageResolution() throws Throwable {
        Message message = Message.create();
        message.setStringField("A");
        Properties krt1 = new Properties();
        krt1.setProperty("KRT1Field", "1");
        Properties krt2 = new Properties();
        krt2.setProperty("KRT2Field", "2");
        this.testKeyResolution((MessageView)message, krt1, krt2, "/${StringField}/${KRT1Field::DefaultValue}/${KRT2Field}", "/A/1/2");
    }

    @Test
    public void testMissingVariablePartFails() throws Throwable {
        Message message = Message.create();
        message.setIntField(10);
        Properties krt1 = new Properties();
        krt1.setProperty("IntField", "KRT1Value");
        Properties krt2 = new Properties();
        krt2.setProperty("IntField", "KRT2Value");
        try {
            this.testKeyResolution((MessageView)message, krt1, krt2, "/${StringField}/${IntField::DefaultValue}", "Doesn'tMatter");
            Assert.fail((String)"Shouldn't be able to resolve channel key without a substitution value for StringField");
        }
        catch (SmaException smaException) {
            // empty catch block
        }
    }

    @Test
    public void testEmptyVariablePartFails() throws Throwable {
        Message message = Message.create();
        message.setIntField(10);
        message.setStringField("");
        Properties krt1 = new Properties();
        krt1.setProperty("IntField", "KRT1Value");
        krt1.setProperty("StringField", "");
        Properties krt2 = new Properties();
        krt2.setProperty("IntField", "KRT2Value");
        krt2.setProperty("StringField", "");
        try {
            this.testKeyResolution((MessageView)message, krt1, krt2, "/${StringField}/${IntField::DefaultValue}", "//10");
            if (!XRuntime.getValue((String)"nv.sma.allowemptykeyfield", (boolean)false) && !XRuntime.getValue((String)"nv.sma.treatemptykeyfieldasnull", (boolean)false)) {
                Assert.fail((String)"Shouldn't be able to resolve channel key without a substitution value for StringField");
            }
        }
        catch (SmaException smaException) {
            // empty catch block
        }
    }

    @Test
    public void testEmptyVariablePartUsesDefault() throws Throwable {
        Message message = Message.create();
        message.setIntField(10);
        message.setStringField("");
        Properties krt1 = new Properties();
        krt1.setProperty("IntField", "KRT1Value");
        krt1.setProperty("StringField", "");
        Properties krt2 = new Properties();
        krt2.setProperty("IntField", "KRT2Value");
        krt2.setProperty("StringField", "");
        if (XRuntime.getValue((String)"nv.sma.treatemptykeyfieldasnull", (boolean)false)) {
            this.testKeyResolution((MessageView)message, krt1, krt2, "/${StringField::_NONE_}/${IntField::DefaultValue}", "/_NONE_/10");
            message.setStringField(null);
            this.testKeyResolution((MessageView)message, krt1, krt2, "/${StringField::_NONE_}/${IntField::DefaultValue}", "/_NONE_/10");
            krt1.remove("StringField");
            this.testKeyResolution((MessageView)message, krt1, krt2, "/${StringField::_NONE_}/${IntField::DefaultValue}", "/_NONE_/10");
            krt2.remove("StringField");
            this.testKeyResolution((MessageView)message, krt1, krt2, "/${StringField::_NONE_}/${IntField::DefaultValue}", "/_NONE_/10");
        } else {
            try {
                this.testKeyResolution((MessageView)message, krt1, krt2, "/${StringField::_NONE_}/${IntField::DefaultValue}", "//10");
                if (!XRuntime.getValue((String)"nv.sma.allowemptykeyfield", (boolean)false)) {
                    Assert.fail((String)"Shouldn't be able to resolve channel key without a substitution value for StringField");
                }
            }
            catch (SmaException smaException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testCleanChannelKey() throws Throwable {
        Message message = Message.create();
        message.setStringField("A/B/C");
        Properties krt1 = new Properties();
        krt1.setProperty("KRT1Field", "D.E.F");
        Properties krt2 = new Properties();
        krt2.setProperty("KRT2_FIELD", "G*H#I");
        if (XRuntime.getValue((String)"nv.sma.cleanmessagekey", (boolean)false)) {
            this.testKeyResolution((MessageView)message, krt1, krt2, "/${StringField}/${KRT1Field::DefaultValue}/${KRT2_FIELD}/${Defaulted::/}", "/A_B_C/D_E_F/G_H_I/_");
        } else {
            this.testKeyResolution((MessageView)message, krt1, krt2, "/${StringField}/${KRT1Field::DefaultValue}/${KRT2_FIELD}/${Defaulted::/}", "/A/B/C/D.E.F/G*H#I//");
        }
    }

    @Test
    public void testFunctionKeyResolutionFromChannelKRT() throws Throwable {
        Message message = Message.create();
        Properties krt1 = new Properties();
        krt1.setProperty("SomethingElse", "KRT1Value");
        Properties krt2 = new Properties();
        krt2.setProperty("NonExistentField", "KRT2Value");
        this.testKeyResolution((MessageView)message, krt1, krt2, "/#[concatResult = concat(${NonExistentField::DefaultValue}, ${SomethingElse})]/${SomethingElse}", "/KRT2ValueKRT1Value/KRT1Value");
    }

    @Test
    public void testFunctionKeyResolutionFromSuppliedKRT() throws Throwable {
        Message message = Message.create();
        Properties krt1 = new Properties();
        krt1.setProperty("NonExistentField", "KRT1Value1");
        Properties krt2 = new Properties();
        krt2.setProperty("NonExistentField", "KRT2Value1");
        krt2.setProperty("NonExistentField2", "KRT2Value2");
        this.testKeyResolution((MessageView)message, krt1, krt2, "/#[concatResult = concat(${NonExistentField::DefaultValue}, ${NonExistentField2})]", "/KRT1Value1KRT2Value2");
    }

    @Test
    public void testFunctionKeyResolutionFromMessage() throws Throwable {
        Message message = Message.create();
        message.setIntField(10);
        Properties krt1 = new Properties();
        krt1.setProperty("IntField", "KRT1Value");
        Properties krt2 = new Properties();
        krt2.setProperty("IntField", "KRT2Value");
        this.testKeyResolution((MessageView)message, krt1, krt2, "/#[concatResult = concat(${IntField::DefaultValue}, PlusPlus)]", "/10PlusPlus");
    }

    private void testKeyResolution(MessageView message, Properties callSpecificKeyResolutionTable, Properties channelKeyResolutionTable, String key, String expectedValue) throws Throwable {
        MessageBusDescriptor busDescriptor = MessageBusDescriptor.create((String)"testBus");
        MessageChannelDescriptor channelDescriptor = MessageChannelDescriptor.create((String)"test", (MessageBusDescriptor)busDescriptor);
        channelDescriptor.setChannelKey(key);
        DefaultMessageChannelKeyResolver keyResolver = DefaultMessageChannelKeyResolver.create((MessageChannelDescriptor)channelDescriptor);
        keyResolver.setKeyResolutionTable(channelKeyResolutionTable);
        Assert.assertEquals((String)"Didn't resolve correct key", (Object)expectedValue, (Object)keyResolver.resolveMessageKey(message, callSpecificKeyResolutionTable));
        XString resolvedKey = XString.create((int)256, (boolean)true);
        MessageChannel.RawKeyResolutionTable callSpecificRawKeyResolutionTable = null;
        if (callSpecificKeyResolutionTable != null) {
            callSpecificRawKeyResolutionTable = MessageBusBindingFactory.createRawKeyResolutionTable();
            for (Map.Entry<Object, Object> entry : callSpecificKeyResolutionTable.entrySet()) {
                callSpecificRawKeyResolutionTable.put(entry.getKey().toString(), XString.create((String)entry.getValue().toString()));
            }
        }
        if (channelKeyResolutionTable != null) {
            MessageChannel.RawKeyResolutionTable channelRawKeyResolutionTable = null;
            channelRawKeyResolutionTable = MessageBusBindingFactory.createRawKeyResolutionTable();
            for (Map.Entry<Object, Object> entry : channelKeyResolutionTable.entrySet()) {
                channelRawKeyResolutionTable.put(entry.getKey().toString(), XString.create((String)entry.getValue().toString()));
            }
            keyResolver.setKeyResolutionTable(null);
            keyResolver.setRawKeyResolutionTable(channelRawKeyResolutionTable);
        }
        Assert.assertEquals((String)"Didn't resololve correct key", (Object)expectedValue, (Object)keyResolver.resolveMessageKey(resolvedKey, message, callSpecificRawKeyResolutionTable).getValue());
    }

    @Test
    @Ignore
    public final void testLongKeyResolutionPerformanceRaw() throws Throwable {
        Message message = Message.create();
        message.setIntField(10);
        message.setStringField("MessageValue");
        Properties krt1 = new Properties();
        krt1.setProperty("IntField", "KRT1Value");
        krt1.setProperty("StringField", "KRT1Value");
        Properties krt2 = new Properties();
        krt2.setProperty("IntField", "KRT2Value");
        krt2.setProperty("MarketSectorDescription", "KRT2Value");
        krt2.setProperty("PogPublishingSystemInstanceTopicField", "KRT2Value");
        krt2.setProperty("ClientAcronym", "KRT2Value");
        krt2.setProperty("EnteringSystemInstance", "KRT2Value");
        krt2.setProperty("ExecutingSystemInstance", "KRT2Value");
        krt2.setProperty("SchedulingSystemInstance", "KRT2Value");
        String key = "${MarketSectorDescription::_NONE_}/EVENT/ORDER/#[StringHash = hash(${StringField::_NONE_}, 5)]/${DeskID::_NONE_}/${PogPublishingSystemInstanceTopicField::_NONE_}/${ClientAcronym::_NONE_}/HIERARCHY/${EnteringSystemInstance::_NONE_}/${ExecutingSystemInstance::_NONE_}/${SchedulingSystemInstance::_NONE_}";
        ChannelKeyResolutionTest.testKeyResolutionPerformance((MessageView)message, krt1, krt2, key, true);
        ChannelKeyResolutionTest.testKeyResolutionPerformance((MessageView)message, krt1, krt2, key, false);
        ChannelKeyResolutionTest.testKeyResolutionPerformance((MessageView)message, krt1, krt2, key, true);
        ChannelKeyResolutionTest.testKeyResolutionPerformance((MessageView)message, krt1, krt2, key, false);
    }

    private static void testKeyResolutionPerformance(MessageView message, Properties callSpecificKeyResolutionTable, Properties channelKeyResolutionTable, String key, boolean raw) throws Throwable {
        MessageBusDescriptor busDescriptor = MessageBusDescriptor.create((String)"testBus");
        MessageChannelDescriptor channelDescriptor = MessageChannelDescriptor.create((String)"test", (MessageBusDescriptor)busDescriptor);
        channelDescriptor.setChannelKey(key);
        DefaultMessageChannelKeyResolver keyResolver = DefaultMessageChannelKeyResolver.create((MessageChannelDescriptor)channelDescriptor);
        keyResolver.setKeyResolutionTable(channelKeyResolutionTable);
        MessageChannel.RawKeyResolutionTable callSpecificRawKeyResolutionTable = null;
        MessageChannel.RawKeyResolutionTable channelRawKeyResolutionTable = null;
        if (raw) {
            if (callSpecificKeyResolutionTable != null) {
                callSpecificRawKeyResolutionTable = MessageBusBindingFactory.createRawKeyResolutionTable();
                for (Map.Entry<Object, Object> entry : callSpecificKeyResolutionTable.entrySet()) {
                    callSpecificRawKeyResolutionTable.put(entry.getKey().toString(), XString.create((String)entry.getValue().toString()));
                }
            }
            if (channelKeyResolutionTable != null) {
                channelRawKeyResolutionTable = MessageBusBindingFactory.createRawKeyResolutionTable();
                for (Map.Entry<Object, Object> entry : channelKeyResolutionTable.entrySet()) {
                    channelRawKeyResolutionTable.put(entry.getKey().toString(), XString.create((String)entry.getValue().toString()));
                }
            }
            keyResolver.setKeyResolutionTable(null);
            keyResolver.setRawKeyResolutionTable(channelRawKeyResolutionTable);
        } else {
            keyResolver.setRawKeyResolutionTable(null);
            keyResolver.setKeyResolutionTable(channelKeyResolutionTable);
        }
        int cycles = 5;
        int iterations = 10000000;
        System.out.println("Test raw=" + raw + ", key = " + key);
        for (int c = 1; c <= cycles; ++c) {
            System.out.println("Cycle " + c);
            long start = System.nanoTime();
            for (int i = 0; i < iterations; ++i) {
                if (!raw) {
                    message.resolveMessageKeyWith((MessageChannelKeyResolver)keyResolver, callSpecificKeyResolutionTable);
                    continue;
                }
                message.resolveMessageKeyWith((MessageChannelKeyResolver)keyResolver, callSpecificRawKeyResolutionTable);
            }
            long finish = System.nanoTime();
            long nanosPerMessage = (finish - start) / (long)iterations;
            System.out.println("Cycle " + c + " key resolution time: " + UtlUnit.formatDuration((double)nanosPerMessage, (TimeUnit)TimeUnit.NANOSECONDS));
        }
    }
}

