/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.event.AepChannelUpEvent;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.aep.test.unit.IAepEngineTestApp;
import com.neeve.aep.test.unit.generated.json.Message;
import com.neeve.rog.IRogMessage;
import com.neeve.sma.MessageChannel;
import java.util.ArrayList;

public final class AepEngineReplicationTestApp
implements IAepEngineTestApp {
    MessageChannel channel1;
    MessageChannel channel4;
    ArrayList<IRogMessage> messages = new ArrayList();
    boolean readMessages;
    boolean updateMessages;
    boolean holdMessages;
    AepEngine engine;

    private final void onMessage(IRogMessage message, AepEngineTestObject.EncodingType encoding) {
        if (this.readMessages) {
            AepEngineTestMessage.read(message);
        }
        if (this.updateMessages) {
            AepEngineTestMessage.read(message);
        }
        if (this.holdMessages) {
            message.acquire();
            this.messages.add(message);
        }
    }

    final boolean waitForExpectedMessageReceipt(int expectedMessageCount) {
        for (int i = 0; i < 10; ++i) {
            System.out.println("received " + this.messages.size() + "...");
            if (this.messages.size() < expectedMessageCount) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            return true;
        }
        return false;
    }

    @EventHandler(source="channel1@aeptest1")
    public void onChannel1UpEventHandler(AepChannelUpEvent event) {
        this.channel1 = event.getMessageChannel();
    }

    @EventHandler(source="channel4@aeptest1")
    public void onChannel4UpEventHandler(AepChannelUpEvent event) {
        this.channel4 = event.getMessageChannel();
    }

    @EventHandler
    public void onXbufMessageHandler(com.neeve.aep.test.unit.generated.xbuf.Message message) {
        this.onMessage(message, AepEngineTestObject.EncodingType.Xbuf);
    }

    @EventHandler
    public void onProtoMessageHandler(com.neeve.aep.test.unit.generated.proto.Message message) {
        this.onMessage(message, AepEngineTestObject.EncodingType.Proto);
    }

    @EventHandler
    public void onJsonMessageHandler(Message message) {
        this.onMessage(message, AepEngineTestObject.EncodingType.Json);
    }

    @Override
    public void clear() {
        this.messages.clear();
    }
}

