/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.google.protobuf.Message;
import com.neeve.aep.test.unit.AepEngineTest;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.aep.test.unit.generated.proto.Model;
import com.neeve.io.IOBuffer;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSerializer;
import com.neeve.rog.IRogMessage;
import java.nio.ByteBuffer;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class AepEngineObjectCloneAndTransformTest
extends AepEngineTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PktPacket serializeAsPacketAndClone(AepEngineTestMessage message) {
        PktPacket packet = message.getMessage().serializeToPacket();
        IOBuffer ioBuffer = IOBuffer.create((int)packet.getSerializedLength(), (boolean)false);
        packet.serialize(ioBuffer, 0);
        ByteBuffer buffer = ioBuffer.takeBuffer();
        try {
            PktPacket pktPacket = PktSerializer.create().deserialize(buffer, null);
            return pktPacket;
        }
        finally {
            ioBuffer.releaseBuffer().dispose();
        }
    }

    private final Model.Message serializeAsProtoAndClone(AepEngineTestMessage message) throws Exception {
        return Model.Message.parseFrom(message.getMessage().serializeToProtobuf().toByteArray());
    }

    private final AepEngineTestMessage createMessage(AepEngineTestObject.EncodingType encodingType) {
        return new AepEngineTestMessage(encodingType);
    }

    private final AepEngineTestMessage createMessageUsingCreateFrom(AepEngineTestObject.EncodingType encodingType, byte[] from, AepEngineTestMessage.SerializedForm serializedForm) {
        return new AepEngineTestMessage(encodingType, from, AepEngineTestMessage.CreateMechanism.CreateFrom, serializedForm);
    }

    private final AepEngineTestMessage createMessageUsingCreateFrom(AepEngineTestObject.EncodingType encodingType, ByteBuffer from, AepEngineTestMessage.SerializedForm serializedForm) {
        return new AepEngineTestMessage(encodingType, from, AepEngineTestMessage.CreateMechanism.CreateFrom, serializedForm);
    }

    private final AepEngineTestMessage createMessageUsingCreateFrom(AepEngineTestObject.EncodingType encodingType, PktPacket from) {
        return new AepEngineTestMessage(encodingType, from, AepEngineTestMessage.CreateMechanism.CreateFrom);
    }

    private final AepEngineTestMessage createMessageUsingCreateFrom(AepEngineTestObject.EncodingType encodingType, Model.Message from) {
        return new AepEngineTestMessage(encodingType, from, AepEngineTestMessage.CreateMechanism.CreateFrom);
    }

    private final AepEngineTestMessage createMessageUsingCreateFrom(AepEngineTestObject.EncodingType encodingType, String from) {
        return new AepEngineTestMessage(encodingType, from, AepEngineTestMessage.CreateMechanism.CreateFrom);
    }

    private final AepEngineTestMessage createMessageUsingObjectFactory(AepEngineTestObject.EncodingType encodingType, PktPacket from) {
        return new AepEngineTestMessage(encodingType, from, AepEngineTestMessage.CreateMechanism.ObjectFactory);
    }

    private final AepEngineTestMessage createMessageUsingViewFactory(AepEngineTestObject.EncodingType encodingType, byte[] from, AepEngineTestMessage.SerializedForm serializedForm) {
        return new AepEngineTestMessage(encodingType, from, AepEngineTestMessage.CreateMechanism.ViewFactory, serializedForm);
    }

    private final AepEngineTestMessage createMessageUsingViewFactory(AepEngineTestObject.EncodingType encodingType, ByteBuffer from, AepEngineTestMessage.SerializedForm serializedForm) {
        return new AepEngineTestMessage(encodingType, from, AepEngineTestMessage.CreateMechanism.ViewFactory, serializedForm);
    }

    private final AepEngineTestMessage createMessageUsingViewFactory(AepEngineTestObject.EncodingType encodingType, PktPacket from) {
        return new AepEngineTestMessage(encodingType, from, AepEngineTestMessage.CreateMechanism.ViewFactory);
    }

    private final AepEngineTestMessage createMessageUsingViewFactory(AepEngineTestObject.EncodingType encodingType, Model.Message from) {
        return new AepEngineTestMessage(encodingType, from, AepEngineTestMessage.CreateMechanism.ViewFactory);
    }

    private final AepEngineTestMessage createMessageUsingViewFactory(AepEngineTestObject.EncodingType encodingType, String from) {
        return new AepEngineTestMessage(encodingType, from, AepEngineTestMessage.CreateMechanism.ViewFactory);
    }

    private final void compareMessages(List<AepEngineTestMessage> expected, List<IRogMessage> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            expected.get(i).compareAgainst(actual.get(i));
        }
    }

    private final AepEngineTestMessage.SerializedForm byteArraySerializedForm(AepEngineTestObject.EncodingType encodingType) {
        switch (encodingType) {
            case Xbuf: {
                return AepEngineTestMessage.SerializedForm.SerializedXbufContainer;
            }
            case Proto: {
                return AepEngineTestMessage.SerializedForm.SerializedProtoMessage;
            }
            case Json: {
                return AepEngineTestMessage.SerializedForm.SerializedJson;
            }
        }
        throw new IllegalArgumentException("unknow encoding type '" + (Object)((Object)encodingType) + "'");
    }

    private final AepEngineTestMessage.SerializedForm byteBufferSerializedForm(AepEngineTestObject.EncodingType encodingType) {
        switch (encodingType) {
            case Xbuf: {
                return AepEngineTestMessage.SerializedForm.SerializedXbufContainer;
            }
            case Proto: {
                return AepEngineTestMessage.SerializedForm.SerializedProtoMessage;
            }
            case Json: {
                return AepEngineTestMessage.SerializedForm.SerializedJson;
            }
        }
        throw new IllegalArgumentException("unknow encoding type '" + (Object)((Object)encodingType) + "'");
    }

    private final void testClone_Message_UsingCreateFrom_ViaByteArray(AepEngineTestObject.EncodingType srcEncodingType, AepEngineTestObject.EncodingType destEncodingType, AepEngineTestMessage.SerializedForm serializedForm) {
        for (int i = 0; i < 1000; ++i) {
            AepEngineTestMessage message1 = this.createMessage(srcEncodingType);
            AepEngineTestMessage message2 = this.createMessageUsingCreateFrom(destEncodingType, message1.getMessage().serializeToByteArray(), serializedForm);
            message1.compareAgainst(message2.getMessage());
        }
    }

    private final void testClone_Message_UsingCreateFrom_ViaByteArray(AepEngineTestObject.EncodingType encodingType) {
        this.testClone_Message_UsingCreateFrom_ViaByteArray(encodingType, encodingType, this.byteArraySerializedForm(encodingType));
    }

    private final void testClone_Message_UsingCreateFrom_ViaByteArray(AepEngineTestObject.EncodingType srcEncodingType, AepEngineTestObject.EncodingType destEncodingType) {
        this.testClone_Message_UsingCreateFrom_ViaByteArray(srcEncodingType, destEncodingType, this.byteArraySerializedForm(srcEncodingType));
    }

    private final void testClone_Message_UsingCreateFrom_ViaByteBuffer(AepEngineTestObject.EncodingType srcEncodingType, AepEngineTestObject.EncodingType destEncodingType, AepEngineTestMessage.SerializedForm serializedForm) {
        for (int i = 0; i < 1000; ++i) {
            AepEngineTestMessage message1 = this.createMessage(srcEncodingType);
            AepEngineTestMessage message2 = this.createMessageUsingCreateFrom(destEncodingType, message1.getMessage().serializeToByteBuffer(), serializedForm);
            message1.compareAgainst(message2.getMessage());
        }
    }

    private final void testClone_Message_UsingCreateFrom_ViaByteBuffer(AepEngineTestObject.EncodingType encodingType) {
        this.testClone_Message_UsingCreateFrom_ViaByteBuffer(encodingType, encodingType, this.byteBufferSerializedForm(encodingType));
    }

    private final void testClone_Message_UsingCreateFrom_ViaPacket(AepEngineTestObject.EncodingType encodingType) {
        for (int i = 0; i < 1000; ++i) {
            AepEngineTestMessage message1 = this.createMessage(encodingType);
            AepEngineTestMessage message2 = this.createMessageUsingCreateFrom(encodingType, this.serializeAsPacketAndClone(message1));
            message1.compareAgainst(message2.getMessage());
        }
    }

    private final void testClone_Message_UsingCreateFrom_ViaProto(AepEngineTestObject.EncodingType encodingType) throws Exception {
        for (int i = 0; i < 1000; ++i) {
            AepEngineTestMessage message1 = this.createMessage(encodingType);
            AepEngineTestMessage message2 = this.createMessageUsingCreateFrom(encodingType, this.serializeAsProtoAndClone(message1));
            message1.compareAgainst(message2.getMessage());
        }
    }

    private final void testClone_Message_UsingCreateFrom_ViaJson(AepEngineTestObject.EncodingType encodingType) {
        for (int i = 0; i < 1000; ++i) {
            AepEngineTestMessage message1 = this.createMessage(encodingType);
            AepEngineTestMessage message2 = this.createMessageUsingCreateFrom(encodingType, message1.getMessage().serializeToJson());
            message1.compareAgainst(message2.getMessage());
        }
    }

    private final void testContinuousClone_Message_UsingCreateFrom_ViaByteArray(AepEngineTestObject.EncodingType srcEncodingType, AepEngineTestObject.EncodingType destEncodingType, AepEngineTestMessage.SerializedForm serializedForm) {
        AepEngineTestMessage message1 = this.createMessage(srcEncodingType);
        for (int i = 0; i < 1000; ++i) {
            AepEngineTestMessage message2 = this.createMessageUsingCreateFrom(destEncodingType, message1.getMessage().serializeToByteArray(), serializedForm);
            message1.compareAgainst(message2.getMessage());
            message1.update();
        }
    }

    private final void testContinuousClone_Message_UsingCreateFrom_ViaByteArray(AepEngineTestObject.EncodingType encodingType) {
        this.testContinuousClone_Message_UsingCreateFrom_ViaByteArray(encodingType, encodingType, this.byteArraySerializedForm(encodingType));
    }

    private final void testContinuousClone_Message_UsingCreateFrom_ViaByteArray(AepEngineTestObject.EncodingType srcEncodingType, AepEngineTestObject.EncodingType destEncodingType) {
        this.testContinuousClone_Message_UsingCreateFrom_ViaByteArray(srcEncodingType, destEncodingType, this.byteArraySerializedForm(srcEncodingType));
    }

    private final void testContinuousClone_Message_UsingCreateFrom_ViaByteBuffer(AepEngineTestObject.EncodingType srcEncodingType, AepEngineTestObject.EncodingType destEncodingType, AepEngineTestMessage.SerializedForm serializedForm) {
        AepEngineTestMessage message1 = this.createMessage(srcEncodingType);
        for (int i = 0; i < 1000; ++i) {
            AepEngineTestMessage message2 = this.createMessageUsingCreateFrom(destEncodingType, message1.getMessage().serializeToByteBuffer(), serializedForm);
            message1.compareAgainst(message2.getMessage());
            message1.update();
        }
    }

    private final void testContinuousClone_Message_UsingCreateFrom_ViaByteBuffer(AepEngineTestObject.EncodingType encodingType) {
        this.testContinuousClone_Message_UsingCreateFrom_ViaByteBuffer(encodingType, encodingType, this.byteBufferSerializedForm(encodingType));
    }

    private final void testContinuousClone_Message_UsingCreateFrom_ViaPacket(AepEngineTestObject.EncodingType encodingType) {
        AepEngineTestMessage message1 = this.createMessage(encodingType);
        for (int i = 0; i < 1000; ++i) {
            AepEngineTestMessage message2 = this.createMessageUsingCreateFrom(encodingType, this.serializeAsPacketAndClone(message1));
            message1.compareAgainst(message2.getMessage());
            message1.update();
        }
    }

    private final void testContinuousClone_Message_UsingCreateFrom_ViaProto(AepEngineTestObject.EncodingType encodingType) throws Exception {
        AepEngineTestMessage message1 = this.createMessage(encodingType);
        for (int i = 0; i < 1000; ++i) {
            AepEngineTestMessage message2 = this.createMessageUsingCreateFrom(encodingType, this.serializeAsProtoAndClone(message1));
            message1.compareAgainst(message2.getMessage());
            message1.update();
        }
    }

    private final void testContinuousClone_Message_UsingCreateFrom_ViaJson(AepEngineTestObject.EncodingType encodingType) {
        AepEngineTestMessage message1 = this.createMessage(encodingType);
        for (int i = 0; i < 1000; ++i) {
            AepEngineTestMessage message2 = this.createMessageUsingCreateFrom(encodingType, message1.getMessage().serializeToJson());
            message1.compareAgainst(message2.getMessage());
            message1.update();
        }
    }

    private final void testClone_Message_UsingDeserialize_ViaByteArray(AepEngineTestObject.EncodingType encodingType) {
        for (int i = 0; i < 1000; ++i) {
            AepEngineTestMessage message1 = this.createMessage(encodingType);
            AepEngineTestMessage message2 = this.createMessage(encodingType);
            message2.getMessage().deserializeFromByteArray(message1.getMessage().serializeToByteArray());
            message1.compareAgainst(message2.getMessage());
        }
    }

    private final void testClone_Message_UsingDeserialize_ViaByteBuffer(AepEngineTestObject.EncodingType encodingType) {
        for (int i = 0; i < 1000; ++i) {
            AepEngineTestMessage message1 = this.createMessage(encodingType);
            AepEngineTestMessage message2 = this.createMessage(encodingType);
            message2.getMessage().deserializeFromByteBuffer(message1.getMessage().serializeToByteBuffer());
            message1.compareAgainst(message2.getMessage());
        }
    }

    private final void testClone_Message_UsingDeserialize_ViaPacket(AepEngineTestObject.EncodingType encodingType) {
        for (int i = 0; i < 1000; ++i) {
            AepEngineTestMessage message1 = this.createMessage(encodingType);
            AepEngineTestMessage message2 = this.createMessage(encodingType);
            message2.getMessage().deserializeFromPacket(this.serializeAsPacketAndClone(message1));
            message1.compareAgainst(message2.getMessage());
        }
    }

    private final void testClone_Message_UsingDeserialize_ViaProto(AepEngineTestObject.EncodingType encodingType) throws Exception {
        for (int i = 0; i < 1000; ++i) {
            AepEngineTestMessage message1 = this.createMessage(encodingType);
            AepEngineTestMessage message2 = this.createMessage(encodingType);
            message2.getMessage().deserializeFromProtobuf((Message)this.serializeAsProtoAndClone(message1));
            message1.compareAgainst(message2.getMessage());
        }
    }

    private final void testClone_Message_UsingDeserialize_ViaJson(AepEngineTestObject.EncodingType encodingType) {
        for (int i = 0; i < 1000; ++i) {
            AepEngineTestMessage message1 = this.createMessage(encodingType);
            AepEngineTestMessage message2 = this.createMessage(encodingType);
            message2.getMessage().deserializeFromJson(message1.getMessage().serializeToJson());
            message1.compareAgainst(message2.getMessage());
        }
    }

    private final void testContinuousClone_Message_UsingDeserialize_ViaByteArray(AepEngineTestObject.EncodingType encodingType) {
        AepEngineTestMessage message1 = this.createMessage(encodingType);
        AepEngineTestMessage message2 = this.createMessage(encodingType);
        for (int i = 0; i < 1000; ++i) {
            message2.getMessage().deserializeFromByteArray(message1.getMessage().serializeToByteArray());
            message1.compareAgainst(message2.getMessage());
            message1.update();
        }
    }

    private final void testContinuousClone_Message_UsingDeserialize_ViaByteBuffer(AepEngineTestObject.EncodingType encodingType) {
        AepEngineTestMessage message1 = this.createMessage(encodingType);
        AepEngineTestMessage message2 = this.createMessage(encodingType);
        for (int i = 0; i < 1000; ++i) {
            message2.getMessage().deserializeFromByteBuffer(message1.getMessage().serializeToByteBuffer());
            message1.compareAgainst(message2.getMessage());
            message1.update();
        }
    }

    private final void testContinuousClone_Message_UsingDeserialize_ViaPacket(AepEngineTestObject.EncodingType encodingType) {
        AepEngineTestMessage message1 = this.createMessage(encodingType);
        AepEngineTestMessage message2 = this.createMessage(encodingType);
        for (int i = 0; i < 1000; ++i) {
            message2.getMessage().deserializeFromPacket(this.serializeAsPacketAndClone(message1));
            message1.compareAgainst(message2.getMessage());
            message1.update();
        }
    }

    private final void testContinuousClone_Message_UsingDeserialize_ViaProto(AepEngineTestObject.EncodingType encodingType) throws Exception {
        AepEngineTestMessage message1 = this.createMessage(encodingType);
        AepEngineTestMessage message2 = this.createMessage(encodingType);
        for (int i = 0; i < 1000; ++i) {
            message2.getMessage().deserializeFromProtobuf((Message)this.serializeAsProtoAndClone(message1));
            message1.compareAgainst(message2.getMessage());
            message1.update();
        }
    }

    private final void testContinuousClone_Message_UsingDeserialize_ViaJson(AepEngineTestObject.EncodingType encodingType) {
        AepEngineTestMessage message1 = this.createMessage(encodingType);
        AepEngineTestMessage message2 = this.createMessage(encodingType);
        for (int i = 0; i < 1000; ++i) {
            message2.getMessage().deserializeFromJson(message1.getMessage().serializeToJson());
            message1.compareAgainst(message2.getMessage());
            message1.update();
        }
    }

    private final void testClone_Message_UsingViewFactory_ViaByteArray(AepEngineTestObject.EncodingType srcEncodingType, AepEngineTestObject.EncodingType destEncodingType, AepEngineTestMessage.SerializedForm serializedForm) {
        for (int i = 0; i < 1000; ++i) {
            AepEngineTestMessage message1 = this.createMessage(srcEncodingType);
            AepEngineTestMessage message2 = this.createMessageUsingViewFactory(destEncodingType, message1.getMessage().serializeToByteArray(), serializedForm);
            message1.compareAgainst(message2.getMessage());
        }
    }

    private final void testClone_Message_UsingViewFactory_ViaByteArray(AepEngineTestObject.EncodingType encodingType) {
        this.testClone_Message_UsingViewFactory_ViaByteArray(encodingType, encodingType, this.byteArraySerializedForm(encodingType));
    }

    private final void testClone_Message_UsingViewFactory_ViaByteBuffer(AepEngineTestObject.EncodingType srcEncodingType, AepEngineTestObject.EncodingType destEncodingType, AepEngineTestMessage.SerializedForm serializedForm) {
        for (int i = 0; i < 1000; ++i) {
            AepEngineTestMessage message1 = this.createMessage(srcEncodingType);
            AepEngineTestMessage message2 = this.createMessageUsingViewFactory(destEncodingType, message1.getMessage().serializeToByteBuffer(), serializedForm);
            message1.compareAgainst(message2.getMessage());
        }
    }

    private final void testClone_Message_UsingViewFactory_ViaByteBuffer(AepEngineTestObject.EncodingType encodingType) {
        this.testClone_Message_UsingViewFactory_ViaByteBuffer(encodingType, encodingType, this.byteBufferSerializedForm(encodingType));
    }

    private final void testClone_Message_UsingViewFactory_ViaPacket(AepEngineTestObject.EncodingType encodingType) {
        for (int i = 0; i < 1000; ++i) {
            AepEngineTestMessage message1 = this.createMessage(encodingType);
            AepEngineTestMessage message2 = this.createMessageUsingViewFactory(encodingType, this.serializeAsPacketAndClone(message1));
            message1.compareAgainst(message2.getMessage());
        }
    }

    private final void testClone_Message_UsingViewFactory_ViaProto(AepEngineTestObject.EncodingType encodingType) throws Exception {
        for (int i = 0; i < 1000; ++i) {
            AepEngineTestMessage message1 = this.createMessage(encodingType);
            AepEngineTestMessage message2 = this.createMessageUsingViewFactory(encodingType, this.serializeAsProtoAndClone(message1));
            message1.compareAgainst(message2.getMessage());
        }
    }

    private final void testClone_Message_UsingViewFactory_ViaJson(AepEngineTestObject.EncodingType encodingType) {
        for (int i = 0; i < 1000; ++i) {
            AepEngineTestMessage message1 = this.createMessage(encodingType);
            AepEngineTestMessage message2 = this.createMessageUsingViewFactory(encodingType, message1.getMessage().serializeToJson());
            message1.compareAgainst(message2.getMessage());
        }
    }

    private final void testContinuousClone_Message_UsingViewFactory_ViaByteArray(AepEngineTestObject.EncodingType srcEncodingType, AepEngineTestObject.EncodingType destEncodingType, AepEngineTestMessage.SerializedForm serializedForm) {
        AepEngineTestMessage message1 = this.createMessage(srcEncodingType);
        for (int i = 0; i < 1000; ++i) {
            AepEngineTestMessage message2 = this.createMessageUsingViewFactory(destEncodingType, message1.getMessage().serializeToByteArray(), serializedForm);
            message1.compareAgainst(message2.getMessage());
            message1.update();
        }
    }

    private final void testContinuousClone_Message_UsingViewFactory_ViaByteArray(AepEngineTestObject.EncodingType encodingType) {
        this.testContinuousClone_Message_UsingViewFactory_ViaByteArray(encodingType, encodingType, this.byteArraySerializedForm(encodingType));
    }

    private final void testContinuousClone_Message_UsingViewFactory_ViaByteBuffer(AepEngineTestObject.EncodingType srcEncodingType, AepEngineTestObject.EncodingType destEncodingType, AepEngineTestMessage.SerializedForm serializedForm) {
        AepEngineTestMessage message1 = this.createMessage(srcEncodingType);
        for (int i = 0; i < 1000; ++i) {
            AepEngineTestMessage message2 = this.createMessageUsingViewFactory(destEncodingType, message1.getMessage().serializeToByteBuffer(), serializedForm);
            message1.compareAgainst(message2.getMessage());
            message1.update();
        }
    }

    private final void testContinuousClone_Message_UsingViewFactory_ViaByteBuffer(AepEngineTestObject.EncodingType encodingType) {
        this.testContinuousClone_Message_UsingViewFactory_ViaByteBuffer(encodingType, encodingType, this.byteBufferSerializedForm(encodingType));
    }

    private final void testContinuousClone_Message_UsingViewFactory_ViaPacket(AepEngineTestObject.EncodingType encodingType) {
        AepEngineTestMessage message1 = this.createMessage(encodingType);
        for (int i = 0; i < 1000; ++i) {
            AepEngineTestMessage message2 = this.createMessageUsingViewFactory(encodingType, this.serializeAsPacketAndClone(message1));
            message1.compareAgainst(message2.getMessage());
            message1.update();
        }
    }

    private final void testContinuousClone_Message_UsingViewFactory_ViaProto(AepEngineTestObject.EncodingType encodingType) throws Exception {
        AepEngineTestMessage message1 = this.createMessage(encodingType);
        for (int i = 0; i < 1000; ++i) {
            AepEngineTestMessage message2 = this.createMessageUsingViewFactory(AepEngineTestObject.EncodingType.Proto, this.serializeAsProtoAndClone(message1));
            message1.compareAgainst(message2.getMessage());
            message1.update();
        }
    }

    private final void testContinuousClone_Message_UsingViewFactory_ViaJson(AepEngineTestObject.EncodingType encodingType) {
        AepEngineTestMessage message1 = this.createMessage(encodingType);
        for (int i = 0; i < 1000; ++i) {
            AepEngineTestMessage message2 = this.createMessageUsingViewFactory(encodingType, message1.getMessage().serializeToJson());
            message1.compareAgainst(message2.getMessage());
            message1.update();
        }
    }

    private final void testClone_Message_UsingObjectFactory_ViaPacket(AepEngineTestObject.EncodingType encodingType) {
        for (int i = 0; i < 1000; ++i) {
            AepEngineTestMessage message1 = this.createMessage(encodingType);
            AepEngineTestMessage message2 = this.createMessageUsingObjectFactory(encodingType, this.serializeAsPacketAndClone(message1));
            message1.compareAgainst(message2.getMessage());
        }
    }

    private final void testContinuousClone_Message_UsingObjectFactory_ViaPacket(AepEngineTestObject.EncodingType encodingType) {
        AepEngineTestMessage message1 = this.createMessage(encodingType);
        for (int i = 0; i < 1000; ++i) {
            AepEngineTestMessage message2 = this.createMessageUsingObjectFactory(encodingType, this.serializeAsPacketAndClone(message1));
            message1.compareAgainst(message2.getMessage());
            message1.update();
        }
    }

    private final void testTransitiveClone_Message_FirstUsingViewFactory_ViaByteBuffer_SecondUsingObjectFactory_ViaPacket(AepEngineTestObject.EncodingType encodingType) {
        for (int i = 0; i < 1000; ++i) {
            AepEngineTestMessage message1 = this.createMessage(encodingType);
            AepEngineTestMessage message2 = this.createMessageUsingViewFactory(encodingType, message1.getMessage().serializeToByteBuffer(), this.byteBufferSerializedForm(encodingType));
            message1.compareAgainst(message2.getMessage());
            AepEngineTestMessage message3 = this.createMessageUsingObjectFactory(encodingType, this.serializeAsPacketAndClone(message2));
            message1.compareAgainst(message3.getMessage());
        }
    }

    private final void testTransitiveClone_Message_FirstUsingViewFactory_ViaPacket_SecondUsingObjectFactory_ViaPacket(AepEngineTestObject.EncodingType encodingType) {
        for (int i = 0; i < 1000; ++i) {
            AepEngineTestMessage message1 = this.createMessage(encodingType);
            AepEngineTestMessage message2 = this.createMessageUsingViewFactory(encodingType, this.serializeAsPacketAndClone(message1));
            message1.compareAgainst(message2.getMessage());
            AepEngineTestMessage message3 = this.createMessageUsingObjectFactory(encodingType, this.serializeAsPacketAndClone(message2));
            message1.compareAgainst(message3.getMessage());
        }
    }

    private final void testTransitiveClone_Message_FirstUsingViewFactory_ViaJson_SecondUsingObjectFactory_ViaPacket(AepEngineTestObject.EncodingType encodingType) {
        for (int i = 0; i < 1000; ++i) {
            AepEngineTestMessage message1 = this.createMessage(encodingType);
            AepEngineTestMessage message2 = this.createMessageUsingViewFactory(encodingType, message1.getMessage().serializeToJson());
            message1.compareAgainst(message2.getMessage());
            AepEngineTestMessage message3 = this.createMessageUsingObjectFactory(encodingType, this.serializeAsPacketAndClone(message2));
            message1.compareAgainst(message3.getMessage());
        }
    }

    @Test
    public void testClone_Message_UsingCreateFrom_ViaByteArray_Xbuf2Xbuf() throws Exception {
        this.testClone_Message_UsingCreateFrom_ViaByteArray(AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testClone_Message_UsingCreateFrom_ViaByteArray_Proto2Proto() throws Exception {
        this.testClone_Message_UsingCreateFrom_ViaByteArray(AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testClone_Message_UsingCreateFrom_ViaByteArray_Proto2Xbuf() throws Exception {
        this.testClone_Message_UsingCreateFrom_ViaByteArray(AepEngineTestObject.EncodingType.Proto, AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testClone_Message_UsingCreateFrom_ViaByteArray_Json2Json() throws Exception {
        this.testClone_Message_UsingCreateFrom_ViaByteArray(AepEngineTestObject.EncodingType.Json);
    }

    @Test
    public void testClone_Message_UsingCreateFrom_ViaByteBuffer_Xbuf2Xbuf() throws Exception {
        this.testClone_Message_UsingCreateFrom_ViaByteBuffer(AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testClone_Message_UsingCreateFrom_ViaByteBuffer_Proto2Proto() throws Exception {
        this.testClone_Message_UsingCreateFrom_ViaByteBuffer(AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testClone_Message_UsingCreateFrom_ViaByteBuffer_Json2Json() throws Exception {
        this.testClone_Message_UsingCreateFrom_ViaByteBuffer(AepEngineTestObject.EncodingType.Json);
    }

    @Test
    public void testClone_Message_UsingCreateFrom_ViaPacket_Xbuf2Xbuf() throws Exception {
        this.testClone_Message_UsingCreateFrom_ViaPacket(AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testClone_Message_UsingCreateFrom_ViaProto_Proto2Proto() throws Exception {
        this.testClone_Message_UsingCreateFrom_ViaProto(AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testClone_Message_UsingCreateFrom_ViaJson_Xbuf2Xbuf() throws Exception {
        this.testClone_Message_UsingCreateFrom_ViaJson(AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testClone_Message_UsingCreateFrom_ViaJson_Proto2Proto() throws Exception {
        this.testClone_Message_UsingCreateFrom_ViaJson(AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testClone_Message_UsingCreateFrom_ViaJson_Json2Json() throws Exception {
        this.testClone_Message_UsingCreateFrom_ViaJson(AepEngineTestObject.EncodingType.Json);
    }

    @Test
    public void testContinuousClone_Message_UsingCreateFrom_ViaByteArray_Xbuf2Xbuf() throws Exception {
        this.testContinuousClone_Message_UsingCreateFrom_ViaByteArray(AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testContinuousClone_Message_UsingCreateFrom_ViaByteArray_Proto2Proto() throws Exception {
        this.testContinuousClone_Message_UsingCreateFrom_ViaByteArray(AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testContinuousClone_Message_UsingCreateFrom_ViaByteArray_Proto2Xbuf() throws Exception {
        this.testContinuousClone_Message_UsingCreateFrom_ViaByteArray(AepEngineTestObject.EncodingType.Proto, AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testContinuousClone_Message_UsingCreateFrom_ViaByteArray_Json2Json() throws Exception {
        this.testContinuousClone_Message_UsingCreateFrom_ViaByteArray(AepEngineTestObject.EncodingType.Json);
    }

    @Test
    public void testContinuousClone_Message_UsingCreateFrom_ViaByteBuffer_Xbuf2Xbuf() throws Exception {
        this.testContinuousClone_Message_UsingCreateFrom_ViaByteBuffer(AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testContinuousClone_Message_UsingCreateFrom_ViaByteBuffer_Proto2Proto() throws Exception {
        this.testContinuousClone_Message_UsingCreateFrom_ViaByteBuffer(AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testContinuousClone_Message_UsingCreateFrom_ViaByteBuffer_Json2Json() throws Exception {
        this.testContinuousClone_Message_UsingCreateFrom_ViaByteBuffer(AepEngineTestObject.EncodingType.Json);
    }

    @Test
    public void testContinuousClone_Message_UsingCreateFrom_ViaPacket_Xbuf2Xbuf() throws Exception {
        this.testContinuousClone_Message_UsingCreateFrom_ViaPacket(AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testContinuousClone_Message_UsingCreateFrom_ViaProto_Proto2Proto() throws Exception {
        this.testContinuousClone_Message_UsingCreateFrom_ViaProto(AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testContinuousClone_Message_UsingCreateFrom_ViaJson_Xbuf2Xbuf() throws Exception {
        this.testContinuousClone_Message_UsingCreateFrom_ViaJson(AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testContinuousClone_Message_UsingCreateFrom_ViaJson_Proto2Proto() throws Exception {
        this.testContinuousClone_Message_UsingCreateFrom_ViaJson(AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testContinuousClone_Message_UsingCreateFrom_ViaJson_Json2Json() throws Exception {
        this.testContinuousClone_Message_UsingCreateFrom_ViaJson(AepEngineTestObject.EncodingType.Json);
    }

    @Test
    public void testClone_Message_UsingDeserialize_ViaByteArray_Xbuf2Xbuf() throws Exception {
        this.testClone_Message_UsingDeserialize_ViaByteArray(AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testClone_Message_UsingDeserialize_ViaByteArray_Proto2Proto() throws Exception {
        this.testClone_Message_UsingDeserialize_ViaByteArray(AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testClone_Message_UsingDeserialize_ViaByteArray_Json2Json() throws Exception {
        this.testClone_Message_UsingDeserialize_ViaByteArray(AepEngineTestObject.EncodingType.Json);
    }

    @Test
    public void testClone_Message_UsingDeserialize_ViaByteBuffer_Xbuf2Xbuf() throws Exception {
        this.testClone_Message_UsingDeserialize_ViaByteBuffer(AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testClone_Message_UsingDeserialize_ViaByteBuffer_Proto2Proto() throws Exception {
        this.testClone_Message_UsingDeserialize_ViaByteBuffer(AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testClone_Message_UsingDeserialize_ViaByteBuffer_Json2Json() throws Exception {
        this.testClone_Message_UsingDeserialize_ViaByteBuffer(AepEngineTestObject.EncodingType.Json);
    }

    @Test
    public void testClone_Message_UsingDeserialize_ViaPacket_Xbuf2Xbuf() throws Exception {
        this.testClone_Message_UsingDeserialize_ViaPacket(AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testClone_Message_UsingDeserialize_ViaPacket_Json2Json() throws Exception {
        this.testClone_Message_UsingDeserialize_ViaPacket(AepEngineTestObject.EncodingType.Json);
    }

    @Test
    public void testClone_Message_UsingDeserialize_ViaProto_Proto2Proto() throws Exception {
        this.testClone_Message_UsingDeserialize_ViaProto(AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testClone_Message_UsingDeserialize_ViaJson_Xbuf2Xbuf() throws Exception {
        this.testClone_Message_UsingDeserialize_ViaJson(AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testClone_Message_UsingDeserialize_ViaJson_Proto2Proto() throws Exception {
        this.testClone_Message_UsingDeserialize_ViaJson(AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testClone_Message_UsingDeserialize_ViaJson_Json2Json() throws Exception {
        this.testClone_Message_UsingDeserialize_ViaJson(AepEngineTestObject.EncodingType.Json);
    }

    @Test
    public void testContinuousClone_Message_UsingDeserialize_ViaByteArray_Xbuf2Xbuf() throws Exception {
        this.testContinuousClone_Message_UsingDeserialize_ViaByteArray(AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testContinuousClone_Message_UsingDeserialize_ViaByteArray_Proto2Proto() throws Exception {
        this.testContinuousClone_Message_UsingDeserialize_ViaByteArray(AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testContinuousClone_Message_UsingDeserialize_ViaByteArray_Json2Json() throws Exception {
        this.testContinuousClone_Message_UsingDeserialize_ViaByteArray(AepEngineTestObject.EncodingType.Json);
    }

    @Test
    public void testContinuousClone_Message_UsingDeserialize_ViaByteBuffer_Xbuf2Xbuf() throws Exception {
        this.testContinuousClone_Message_UsingDeserialize_ViaByteBuffer(AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testContinuousClone_Message_UsingDeserialize_ViaByteBuffer_Proto2Proto() throws Exception {
        this.testContinuousClone_Message_UsingDeserialize_ViaByteBuffer(AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testContinuousClone_Message_UsingDeserialize_ViaByteBuffer_Json2Json() throws Exception {
        this.testContinuousClone_Message_UsingDeserialize_ViaByteBuffer(AepEngineTestObject.EncodingType.Json);
    }

    @Test
    public void testContinuousClone_Message_UsingDeserialize_ViaPacket_Xbuf2Xbuf() throws Exception {
        this.testContinuousClone_Message_UsingDeserialize_ViaPacket(AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testContinuousClone_Message_UsingDeserialize_ViaPacket_Json2Json() throws Exception {
        this.testContinuousClone_Message_UsingDeserialize_ViaPacket(AepEngineTestObject.EncodingType.Json);
    }

    @Test
    public void testContinuousClone_Message_UsingDeserialize_ViaProto_Proto2Proto() throws Exception {
        this.testContinuousClone_Message_UsingDeserialize_ViaProto(AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testContinuousClone_Message_UsingDeserialize_ViaJson_Xbuf2Xbuf() throws Exception {
        this.testContinuousClone_Message_UsingDeserialize_ViaJson(AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testContinuousClone_Message_UsingDeserialize_ViaJson_Proto2Proto() throws Exception {
        this.testContinuousClone_Message_UsingDeserialize_ViaJson(AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testContinuousClone_Message_UsingDeserialize_ViaJson_Json2Json() throws Exception {
        this.testContinuousClone_Message_UsingDeserialize_ViaJson(AepEngineTestObject.EncodingType.Json);
    }

    @Test
    public void testClone_Message_UsingViewFactory_ViaByteArray_Xbuf2Xbuf() throws Exception {
        this.testClone_Message_UsingViewFactory_ViaByteArray(AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testClone_Message_UsingViewFactory_ViaByteArray_Proto2Proto() throws Exception {
        this.testClone_Message_UsingViewFactory_ViaByteArray(AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testClone_Message_UsingViewFactory_ViaByteArray_Json2Json() throws Exception {
        this.testClone_Message_UsingViewFactory_ViaByteArray(AepEngineTestObject.EncodingType.Json);
    }

    @Test
    public void testClone_Message_UsingViewFactory_ViaByteBuffer_Xbuf2Xbuf() throws Exception {
        this.testClone_Message_UsingViewFactory_ViaByteBuffer(AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testClone_Message_UsingViewFactory_ViaByteBuffer_Proto2Proto() throws Exception {
        this.testClone_Message_UsingViewFactory_ViaByteBuffer(AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testClone_Message_UsingViewFactory_ViaByteBuffer_Json2Json() throws Exception {
        this.testClone_Message_UsingViewFactory_ViaByteBuffer(AepEngineTestObject.EncodingType.Json);
    }

    @Test
    public void testClone_Message_UsingViewFactory_ViaPacket_Xbuf2Xbuf() throws Exception {
        this.testClone_Message_UsingViewFactory_ViaPacket(AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testClone_Message_UsingViewFactory_ViaProto_Proto2Proto() throws Exception {
        this.testClone_Message_UsingViewFactory_ViaProto(AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testClone_Message_UsingViewFactory_ViaJson_Json2Json() throws Exception {
        this.testClone_Message_UsingViewFactory_ViaJson(AepEngineTestObject.EncodingType.Json);
    }

    @Test
    public void testContinuousClone_Message_UsingViewFactory_ViaByteArray_Xbuf2Xbuf() throws Exception {
        this.testContinuousClone_Message_UsingViewFactory_ViaByteArray(AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testContinuousClone_Message_UsingViewFactory_ViaByteArray_Proto2Proto() throws Exception {
        this.testContinuousClone_Message_UsingViewFactory_ViaByteArray(AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testContinuousClone_Message_UsingViewFactory_ViaByteArray_Json2Json() throws Exception {
        this.testContinuousClone_Message_UsingViewFactory_ViaByteArray(AepEngineTestObject.EncodingType.Json);
    }

    @Test
    public void testContinuousClone_Message_UsingViewFactory_ViaByteBuffer_Xbuf2Xbuf() throws Exception {
        this.testContinuousClone_Message_UsingViewFactory_ViaByteBuffer(AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testContinuousClone_Message_UsingViewFactory_ViaByteBuffer_Proto2Proto() throws Exception {
        this.testContinuousClone_Message_UsingViewFactory_ViaByteBuffer(AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testContinuousClone_Message_UsingViewFactory_ViaByteBuffer_Json2Json() throws Exception {
        this.testContinuousClone_Message_UsingViewFactory_ViaByteBuffer(AepEngineTestObject.EncodingType.Json);
    }

    @Test
    public void testContinuousClone_Message_UsingViewFactory_ViaPacket_Xbuf2Xbuf() throws Exception {
        this.testContinuousClone_Message_UsingViewFactory_ViaPacket(AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testContinuousClone_Message_UsingViewFactory_ViaProto_Proto2Proto() throws Exception {
        this.testContinuousClone_Message_UsingViewFactory_ViaProto(AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testContinuousClone_Message_UsingViewFactory_ViaJson_Json2Json() throws Exception {
        this.testContinuousClone_Message_UsingViewFactory_ViaJson(AepEngineTestObject.EncodingType.Json);
    }

    @Test
    public void testClone_Message_UsingObjectFactory_ViaPacket_Xbuf2Xbuf() throws Exception {
        this.testClone_Message_UsingObjectFactory_ViaPacket(AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testClone_Message_UsingObjectFactory_ViaPacket_Proto2Proto() throws Exception {
        this.testClone_Message_UsingObjectFactory_ViaPacket(AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testClone_Message_UsingObjectFactory_ViaPacket_Json2Json() throws Exception {
        this.testClone_Message_UsingObjectFactory_ViaPacket(AepEngineTestObject.EncodingType.Json);
    }

    @Test
    public void testContinuousClone_Message_UsingObjectFactory_ViaPacket_Xbuf2Xbuf() throws Exception {
        this.testContinuousClone_Message_UsingObjectFactory_ViaPacket(AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testContinuousClone_Message_UsingObjectFactory_ViaPacket_Proto2Proto() throws Exception {
        this.testContinuousClone_Message_UsingObjectFactory_ViaPacket(AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testContinuousClone_Message_UsingObjectFactory_ViaPacket_Json2Json() throws Exception {
        this.testContinuousClone_Message_UsingObjectFactory_ViaPacket(AepEngineTestObject.EncodingType.Json);
    }

    @Test
    public void testTransitiveClone_Message_FirstUsingViewFactory_ViaByteBuffer_SecondUsingObjectFactory_ViaPacket_Xbuf2Xbuf() {
        this.testTransitiveClone_Message_FirstUsingViewFactory_ViaByteBuffer_SecondUsingObjectFactory_ViaPacket(AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testTransitiveClone_Message_FirstUsingViewFactory_ViaPacket_SecondUsingObjectFactory_ViaPacket_Xbuf2Xbuf() {
        this.testTransitiveClone_Message_FirstUsingViewFactory_ViaPacket_SecondUsingObjectFactory_ViaPacket(AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testTransitiveClone_Message_FirstUsingViewFactory_ViaByteBuffer_SecondUsingObjectFactory_ViaPacket_Proto2Proto() {
        this.testTransitiveClone_Message_FirstUsingViewFactory_ViaPacket_SecondUsingObjectFactory_ViaPacket(AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testTransitiveClone_Message_FirstUsingViewFactory_ViaJson_SecondUsingObjectFactory_ViaPacket_Json2Json() {
        this.testTransitiveClone_Message_FirstUsingViewFactory_ViaJson_SecondUsingObjectFactory_ViaPacket(AepEngineTestObject.EncodingType.Json);
    }

    private void testWrapMessageModificationDiscardsOrginal_FromByteArray(AepEngineTestObject.EncodingType encodingType) {
        AepEngineTestMessage testMessage = new AepEngineTestMessage(encodingType);
        testMessage.forceUpdate();
        byte[] encoded = testMessage.getMessage().serializeToByteArray();
        AepEngineTestMessage message = new AepEngineTestMessage(encodingType, encoded, AepEngineTestMessage.CreateMechanism.ViewFactory, this.byteArraySerializedForm(encodingType));
        message.forceUpdate();
        Assert.assertFalse((String)"Serialized object matches wrapped message after update", (encoded == message.getMessage().serializeToByteArray() ? 1 : 0) != 0);
    }

    private void testWrapMessageModificationDiscardsOrginal_FromByteBuffer(AepEngineTestObject.EncodingType encodingType) {
        AepEngineTestMessage testMessage = new AepEngineTestMessage(encodingType);
        testMessage.forceUpdate();
        ByteBuffer encoded = testMessage.getMessage().serializeToByteBuffer();
        AepEngineTestMessage message = new AepEngineTestMessage(encodingType, encoded, AepEngineTestMessage.CreateMechanism.ViewFactory, this.byteBufferSerializedForm(encodingType));
        message.forceUpdate();
        ByteBuffer serialized = message.getMessage().serializeToByteBuffer();
        Assert.assertFalse((String)"Serialized object matches wrapped message after update", (encoded.array() == serialized.array() ? 1 : 0) != 0);
    }

    @Test
    public void testWrapMessageModificationDiscardsOrginal_FromByteArray_Xbuf() {
        this.testWrapMessageModificationDiscardsOrginal_FromByteArray(AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testWrapMessageModificationDiscardsOrginal_FromByteArray_Json() {
        this.testWrapMessageModificationDiscardsOrginal_FromByteArray(AepEngineTestObject.EncodingType.Json);
    }

    @Test
    public void testWrapMessageModificationDiscardsOrginal_FromByteArray_Proto() {
        this.testWrapMessageModificationDiscardsOrginal_FromByteArray(AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testWrapMessageModificationDiscardsOrginal_FromByteBuffer_Xbuf() {
        this.testWrapMessageModificationDiscardsOrginal_FromByteBuffer(AepEngineTestObject.EncodingType.Xbuf);
    }

    @Test
    public void testWrapMessageModificationDiscardsOrginal_FromByteBuffer_Json() {
        this.testWrapMessageModificationDiscardsOrginal_FromByteBuffer(AepEngineTestObject.EncodingType.Json);
    }

    @Test
    public void testWrapMessageModificationDiscardsOrginal_FromByteBuffer_Proto() {
        this.testWrapMessageModificationDiscardsOrginal_FromByteBuffer(AepEngineTestObject.EncodingType.Proto);
    }
}

