/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.event.AepChannelDownEvent;
import com.neeve.aep.event.AepChannelUpEvent;
import com.neeve.aep.test.unit.AepEngineTestApp;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.aep.test.unit.generated.json.Message;
import com.neeve.aep.test.unit.generated.proto.Repository;
import com.neeve.aep.test.unit.generated.xbuf.Child4;
import com.neeve.rog.IRogCollectionNodeElement;
import com.neeve.sma.MessageView;

public final class AepEngineLogRestartTestApp
extends AepEngineTestApp {
    AepEngine engine;
    volatile int inMessageCount;
    volatile int outMessageCount;
    volatile int primaryOutMessageCount;
    volatile int primaryInMessageCount;
    volatile int numPuts;
    volatile int numUpdates;
    volatile int numRemoves;
    volatile int txnCount;
    volatile int numGaps;
    private boolean lastMessageCounted = true;

    final boolean waitForExpectedMessageReceipt(int expectedMessageCount) {
        for (int i = 0; i < 10; ++i) {
            System.out.println("received " + this.inMessageCount + "...");
            if (this.inMessageCount < expectedMessageCount) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            return true;
        }
        return false;
    }

    @EventHandler(source="channel1@aeptest1")
    public void onChannel1UpEventHandler(AepChannelUpEvent event) {
        this.channel1 = event.getMessageChannel();
    }

    @EventHandler(source="channel1@aeptest1")
    public void onChannel1DownEventHandler(AepChannelDownEvent event) {
        this.channel1 = null;
    }

    @EventHandler(source="channel2@aeptest1")
    public void onChannel2UpEventHandler(AepChannelUpEvent event) {
        this.channel2 = event.getMessageChannel();
    }

    @EventHandler(source="channel2@aeptest1")
    public void onChannel2DownEventHandler(AepChannelDownEvent event) {
        this.channel2 = null;
    }

    @EventHandler
    public void onProtoMessageHandler(com.neeve.aep.test.unit.generated.proto.Message message) {
        boolean countAsTxn = false;
        if (this.engine.getState() != AepEngine.State.Starting) {
            ++this.inMessageCount;
            if (this.engine.isPrimary()) {
                ++this.primaryInMessageCount;
            }
            countAsTxn |= this.engine.getHAPolicy() == AepEngine.HAPolicy.EventSourcing;
        }
        boolean sendMessage = false;
        Repository state = (Repository)this.engine.getApplicationState((MessageView)message);
        if (this.inMessageCount == 1) {
            System.out.println("Creating LongMap in tx " + message.getTransactionId());
            state.getLongMapField();
            sendMessage = true;
        } else if (this.inMessageCount == 2) {
            System.out.println("Doing nothing in tx " + message.getTransactionId());
        } else if (this.inMessageCount == 3) {
            System.out.println("Doing nothing in tx " + message.getTransactionId());
        } else if (this.inMessageCount == 4) {
            System.out.println("Adding child to map in tx " + message.getTransactionId());
            state.getLongMapField().put(1L, (IRogCollectionNodeElement)com.neeve.aep.test.unit.generated.proto.Child4.create());
        } else if (this.inMessageCount == 5) {
            System.out.println("Removing child and shutting down in tx " + message.getTransactionId());
            state.getLongMapField().remove(1L);
            this.engine.setAsLastTransaction(null, true);
        } else if (this.inMessageCount == 6) {
            System.out.println("Adding child to map in tx " + message.getTransactionId());
            state.getLongMapField().put(1L, (IRogCollectionNodeElement)com.neeve.aep.test.unit.generated.proto.Child4.create());
        } else if (this.inMessageCount == 7) {
            System.out.println("Removing child and shutting down in tx " + message.getTransactionId());
            com.neeve.aep.test.unit.generated.proto.Child4 child = (com.neeve.aep.test.unit.generated.proto.Child4)state.getLongMapField().remove(1L);
            System.out.println("Removed child: " + child.getId());
            if (this.engine.getState() != AepEngine.State.Starting) {
                System.out.println("Setting as last transaction for message txid: " + message.getTransactionId());
            }
            this.engine.setAsLastTransaction(null, true);
        }
        if (sendMessage) {
            AepEngineTestMessage out = new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto);
            out.getMessage().setMessageBus("aeptest1");
            out.getMessage().setMessageChannel("channel2");
            this.engine.sendMessage(this.channel2, out.getMessage());
            if (this.engine.getState() != AepEngine.State.Starting) {
                ++this.outMessageCount;
                if (this.engine.isPrimary()) {
                    ++this.primaryOutMessageCount;
                }
            }
            countAsTxn = true;
        }
        if (countAsTxn) {
            ++this.txnCount;
            this.lastMessageCounted = true;
        } else {
            if (this.lastMessageCounted) {
                ++this.numGaps;
            }
            this.lastMessageCounted = false;
        }
    }

    @EventHandler
    public void onXbufMessageHandler(com.neeve.aep.test.unit.generated.xbuf.Message message) {
        boolean countAsTxn = false;
        if (this.engine.getState() != AepEngine.State.Starting) {
            ++this.inMessageCount;
            if (this.engine.isPrimary()) {
                ++this.primaryInMessageCount;
            }
            countAsTxn |= this.engine.getHAPolicy() == AepEngine.HAPolicy.EventSourcing;
        }
        boolean sendMessage = false;
        com.neeve.aep.test.unit.generated.xbuf.Repository state = (com.neeve.aep.test.unit.generated.xbuf.Repository)this.engine.getApplicationState((MessageView)message);
        if (this.inMessageCount == 1) {
            System.out.println("Creating LongMap in tx " + message.getTransactionId());
            state.getLongMapField();
            sendMessage = true;
        } else if (this.inMessageCount == 2) {
            System.out.println("Doing nothing in tx " + message.getTransactionId());
        } else if (this.inMessageCount == 3) {
            System.out.println("Doing nothing in tx " + message.getTransactionId());
        } else if (this.inMessageCount == 4) {
            System.out.println("Adding child to map in tx " + message.getTransactionId());
            state.getLongMapField().put(1L, (IRogCollectionNodeElement)Child4.create());
        } else if (this.inMessageCount == 5) {
            System.out.println("Removing child and shutting down in tx " + message.getTransactionId());
            state.getLongMapField().remove(1L);
            this.engine.setAsLastTransaction(null, true);
        } else if (this.inMessageCount == 6) {
            System.out.println("Adding child to map in tx " + message.getTransactionId());
            state.getLongMapField().put(1L, (IRogCollectionNodeElement)Child4.create());
        } else if (this.inMessageCount == 7) {
            System.out.println("Removing child and shutting down in tx " + message.getTransactionId());
            Child4 child = (Child4)state.getLongMapField().remove(1L);
            System.out.println("Removed child: " + child.getId());
            if (this.engine.getState() != AepEngine.State.Starting) {
                System.out.println("Setting as last transaction for message txid: " + message.getTransactionId());
            }
            this.engine.setAsLastTransaction(null, true);
        }
        if (sendMessage) {
            AepEngineTestMessage out = new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto);
            out.getMessage().setMessageBus("aeptest1");
            out.getMessage().setMessageChannel("channel2");
            this.engine.sendMessage(this.channel2, out.getMessage());
            if (this.engine.getState() != AepEngine.State.Starting) {
                ++this.outMessageCount;
                if (this.engine.isPrimary()) {
                    ++this.primaryOutMessageCount;
                }
            }
            countAsTxn = true;
        }
        if (countAsTxn) {
            ++this.txnCount;
            this.lastMessageCounted = true;
        } else {
            if (this.lastMessageCounted) {
                ++this.numGaps;
            }
            this.lastMessageCounted = false;
        }
    }

    @EventHandler
    public void onJsonMessageHandler(Message message) {
        boolean countAsTxn = false;
        if (this.engine.getState() != AepEngine.State.Starting) {
            ++this.inMessageCount;
            if (this.engine.isPrimary()) {
                ++this.primaryInMessageCount;
            }
            countAsTxn |= this.engine.getHAPolicy() == AepEngine.HAPolicy.EventSourcing;
        }
        boolean sendMessage = false;
        com.neeve.aep.test.unit.generated.json.Repository state = (com.neeve.aep.test.unit.generated.json.Repository)this.engine.getApplicationState((MessageView)message);
        if (this.inMessageCount == 1) {
            System.out.println("Creating LongMap in tx " + message.getTransactionId());
            state.getLongMapField();
            sendMessage = true;
        } else if (this.inMessageCount == 2) {
            System.out.println("Doing nothing in tx " + message.getTransactionId());
        } else if (this.inMessageCount == 3) {
            System.out.println("Doing nothing in tx " + message.getTransactionId());
        } else if (this.inMessageCount == 4) {
            System.out.println("Adding child to map in tx " + message.getTransactionId());
            state.getLongMapField().put(1L, (IRogCollectionNodeElement)com.neeve.aep.test.unit.generated.json.Child4.create());
        } else if (this.inMessageCount == 5) {
            System.out.println("Removing child and shutting down in tx " + message.getTransactionId());
            state.getLongMapField().remove(1L);
            this.engine.setAsLastTransaction(null, true);
        } else if (this.inMessageCount == 6) {
            System.out.println("Adding child to map in tx " + message.getTransactionId());
            state.getLongMapField().put(1L, (IRogCollectionNodeElement)com.neeve.aep.test.unit.generated.json.Child4.create());
        } else if (this.inMessageCount == 7) {
            System.out.println("Removing child and shutting down in tx " + message.getTransactionId());
            com.neeve.aep.test.unit.generated.json.Child4 child = (com.neeve.aep.test.unit.generated.json.Child4)state.getLongMapField().remove(1L);
            System.out.println("Removed child: " + child.getId());
            if (this.engine.getState() != AepEngine.State.Starting) {
                System.out.println("Setting as last transaction for message txid: " + message.getTransactionId());
            }
            this.engine.setAsLastTransaction(null, true);
        }
        if (sendMessage) {
            AepEngineTestMessage out = new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto);
            out.getMessage().setMessageBus("aeptest1");
            out.getMessage().setMessageChannel("channel2");
            this.engine.sendMessage(this.channel2, out.getMessage());
            if (this.engine.getState() != AepEngine.State.Starting) {
                ++this.outMessageCount;
                if (this.engine.isPrimary()) {
                    ++this.primaryOutMessageCount;
                }
            }
            countAsTxn = true;
        }
        if (countAsTxn) {
            ++this.txnCount;
            this.lastMessageCounted = true;
        } else {
            if (this.lastMessageCounted) {
                ++this.numGaps;
            }
            this.lastMessageCounted = false;
        }
    }
}

