/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.AepEngineDescriptor;
import com.neeve.aep.IAepApplicationStateFactory;
import com.neeve.aep.test.unit.AepEngineLogTestApp;
import com.neeve.aep.test.unit.AepEngineTest;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.aep.test.unit.generated.json.Message;
import com.neeve.aep.test.unit.generated.proto.Repository;
import com.neeve.aep.test.unit.generated.xbuf.Factory;
import com.neeve.ods.StoreDescriptor;
import com.neeve.ods.StorePersisterDescriptor;
import com.neeve.rog.IRogMessage;
import com.neeve.rog.IRogNode;
import com.neeve.rog.impl.RogNode;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.RogLogUtil;
import com.neeve.sma.MessageView;
import com.neeve.test.util.ProcessWrapper;
import com.neeve.tools.TransactionLogTool;
import com.neeve.util.UtlFile;
import java.io.File;
import java.io.FileFilter;
import java.io.PrintStream;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class AepEngineLogArchiveTest
extends AepEngineTest {
    AepEngineLogTestApp app;
    String appName;
    AepEngine engine;
    private AepEngineTestObject.EncodingType encoding = AepEngineTestObject.EncodingType.Proto;
    private static final FileFilter LOG_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".log");
        }
    };
    private static final FileFilter JAR_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".jar");
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTLTCanOpenApiCreatedArchive() throws Exception {
        this.appName = ((Object)((Object)this)).getClass().getSimpleName() + System.currentTimeMillis();
        this.app = new AepEngineLogTestApp();
        this.engine = this.createEngine(true, true);
        RogLog log = (RogLog)this.engine.getStore().getPersister();
        this.sendMessages(1000);
        this.app.waitForExpectedMessageReceipt(1000);
        this.engine.stop();
        System.out.println("Creating executable archive...");
        File archive = RogLogUtil.createExecutableArchive((File)new File(AepEngineLogArchiveTest.getTestbedRoot(), "rdat/archives"), (String)"testBasicArchive", (PrintStream)System.out, null, (RogLog[])new RogLog[]{log});
        String archiveTimeStamp = archive.getName().substring(archive.getName().indexOf("-"));
        archiveTimeStamp = archiveTimeStamp.substring(0, archiveTimeStamp.indexOf("."));
        File extractionFolderRoot = new File(AepEngineLogArchiveTest.getTestbedRoot(), "rdat/test-archive-extraction");
        UtlFile.deleteDirectory((File)extractionFolderRoot);
        File extractionFolder = new File(extractionFolderRoot, "extracted-archives");
        boolean deleteOnExit = false;
        System.out.println("Testing archive...");
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java");
        cmd.add("-DNVROOT=" + System.getProperty("NVROOT"));
        cmd.add("-Djansi.strip=true");
        cmd.add("-Dnv.console.jline.disable=true");
        cmd.add("-jar");
        cmd.add(archive.getCanonicalPath());
        cmd.add(TransactionLogTool.class.getName());
        cmd.add("-e");
        cmd.add(extractionFolderRoot.getCanonicalPath());
        try (ProcessWrapper pw = ProcessWrapper.launch(cmd, (File)archive.getParentFile());){
            pw.setOutputEchoEnabled(true);
            pw.waitForOutputAndQuiesence(1000L, 5000L);
            Assert.assertEquals((String)"Unexpected error output", (Object)"", (Object)pw.getErrorOutput());
            pw.markOutputPosistions();
            pw.writeLn("set stacktraces on");
            pw.waitForOutputAndQuiesence(1000L, 5000L);
            pw.markOutputPosistions();
            pw.writeLn("list open");
            if (!pw.waitForOutputAndQuiesence(1000L, 20000L, "There are 1 open logs")) {
                Assert.fail((String)"The executable jar didn't open any logs");
            }
            File extractedLog = new File(extractionFolder, log.getName() + archiveTimeStamp + ".log");
            Assert.assertTrue((String)("Transaction log not in specified extraction folder, " + extractedLog + " doesn't exist."), (boolean)extractedLog.exists());
            pw.markOutputPosistions();
            pw.writeLn("set deleteExtractedArchivesDirOnExit " + (deleteOnExit ? " on" : " off"));
            pw.waitForOutputAndQuiesence(1000L, 5000L);
            pw.markOutputPosistions();
            pw.writeLn("exit");
            pw.waitForOutputAndQuiesence(1000L, 5000L);
        }
        if (deleteOnExit) {
            Assert.assertTrue((String)"Archive extraction folder not cleaned up", (!extractionFolder.exists() ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)"Archive extraction folder erroneously cleaned up", (boolean)extractionFolder.exists());
        }
    }

    @Test
    public void testArchiveInboundNoOutbound() throws Exception {
        this.testTLTCreatedArchive(true, false);
    }

    @Test
    public void testArchiveOutboundNoInbound() throws Exception {
        this.testTLTCreatedArchive(false, true);
    }

    @Test
    public void testArchiveInboundAndOutbound() throws Exception {
        this.testTLTCreatedArchive(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void testTLTCreatedArchive(boolean inbound, boolean outbound) throws Exception {
        this.appName = ((Object)((Object)this)).getClass().getSimpleName() + System.currentTimeMillis();
        this.app = new AepEngineLogTestApp();
        this.engine = this.createEngine(inbound, outbound);
        RogLog log = (RogLog)this.engine.getStore().getPersister();
        this.sendMessages(20);
        this.app.waitForExpectedMessageReceipt(20);
        this.engine.stop();
        System.out.println("Testing archive...");
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java");
        cmd.add("-DNVROOT=" + AepEngineLogArchiveTest.getTestbedRoot());
        cmd.add("-Djansi.strip=true");
        cmd.add("-Dnv.console.jline.disable=true");
        cmd.add("-classpath");
        cmd.add(System.getProperty("java.class.path"));
        cmd.add(TransactionLogTool.class.getName());
        try (ProcessWrapper pw = ProcessWrapper.launch(cmd, (File)new File(AepEngineLogArchiveTest.getTestbedRoot(), "rdat"));){
            pw.setOutputEchoEnabled(true);
            pw.waitForOutputAndQuiesence(1000L, 5000L);
            Assert.assertEquals((String)"Unexpected error output", (Object)"", (Object)pw.getErrorOutput());
            pw.markOutputPosistions();
            pw.writeLn("set stacktraces on");
            pw.waitForOutputAndQuiesence(1000L, 5000L);
            pw.markOutputPosistions();
            pw.writeLn("archive -n " + this.appName + " -m " + log.getName());
            if (!pw.waitForOutputAndQuiesence(1000L, 300000L, "Successfully created archive")) {
                Assert.fail((String)("TLT did not successfully create archive: " + pw.getErrorOutput()));
            }
            Assert.assertEquals((String)"Unexpected error output", (Object)"", (Object)pw.getErrorOutput());
        }
        System.out.println("Testing tlt created archive...");
        File archiveFolder = new File(AepEngineLogArchiveTest.getTestbedRoot(), "rdat/archives");
        File archive = null;
        for (File candidate : archiveFolder.listFiles(JAR_FILE_FILTER)) {
            if (!candidate.getName().startsWith(this.appName)) continue;
            archive = candidate;
            break;
        }
        cmd = new ArrayList();
        cmd.add(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java");
        cmd.add("-DNVROOT=" + System.getProperty("NVROOT"));
        cmd.add("-Djansi.strip=true");
        cmd.add("-Dnv.console.jline.disable=true");
        cmd.add("-jar");
        cmd.add(archive.getCanonicalPath());
        cmd.add(TransactionLogTool.class.getName());
        pw = ProcessWrapper.launch(cmd, (File)new File(AepEngineLogArchiveTest.getTestbedRoot(), "rdat"));
        try {
            pw.setOutputEchoEnabled(true);
            pw.waitForOutputAndQuiesence(1000L, 5000L);
            Assert.assertEquals((String)"Unexpected error output", (Object)"", (Object)pw.getErrorOutput());
            pw.markOutputPosistions();
            pw.writeLn("set stacktraces on");
            pw.waitForOutputAndQuiesence(1000L, 5000L);
            pw.markOutputPosistions();
            pw.writeLn("list open");
            int expectedLogCount = 1 + (inbound ? 1 : 0) + (outbound ? 1 : 0);
            if (!pw.waitForOutputAndQuiesence(1000L, 20000L, "There are " + expectedLogCount + " open logs")) {
                Assert.fail((String)"The executable jar didn't open any logs");
            }
            File extractionFolder = new File(archive.getParentFile().getParentFile(), "extracted-archives");
            File extracted = null;
            for (File candidate : extractionFolder.listFiles(LOG_FILE_FILTER)) {
                if (!candidate.getName().startsWith(this.appName + "-")) continue;
                extracted = candidate;
                break;
            }
            pw.markOutputPosistions();
            pw.writeLn("compare extracted-archives/" + extracted.getName() + " " + this.appName);
            if (!pw.waitForOutputAndQuiesence(1000L, 10000L, "Logs are not divergent")) {
                Assert.fail((String)"The archived log is divergent with the original!");
            }
            if (inbound) {
                extracted = null;
                for (File candidate : extractionFolder.listFiles(LOG_FILE_FILTER)) {
                    if (!candidate.getName().startsWith(this.appName + ".in-")) continue;
                    extracted = candidate;
                    break;
                }
                pw.markOutputPosistions();
                pw.writeLn("compare extracted-archives/" + extracted.getName() + " " + this.appName + ".in");
                if (!pw.waitForOutputAndQuiesence(1000L, 10000L, "Logs are not divergent")) {
                    Assert.fail((String)"The archived inbound log is divergent with the original!");
                }
            }
            if (outbound) {
                extracted = null;
                for (File candidate : extractionFolder.listFiles(LOG_FILE_FILTER)) {
                    if (!candidate.getName().startsWith(this.appName + ".out-")) continue;
                    extracted = candidate;
                    break;
                }
                pw.markOutputPosistions();
                pw.writeLn("compare extracted-archives/" + extracted.getName() + " " + this.appName + ".out");
                if (!pw.waitForOutputAndQuiesence(1000L, 10000L, "Logs are not divergent")) {
                    Assert.fail((String)"The archived outbound log is divergent with the original!");
                }
            }
        }
        finally {
            pw.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArchiveMultiple() throws Exception {
        this.appName = ((Object)((Object)this)).getClass().getSimpleName() + System.currentTimeMillis();
        this.app = new AepEngineLogTestApp();
        this.engine = this.createEngine(true, true);
        RogLog log = (RogLog)this.engine.getStore().getPersister();
        RogLog inbound = (RogLog)this.engine.getInboundMessageLogger();
        RogLog outbound = (RogLog)this.engine.getOutboundMessageLogger();
        this.sendMessages(1000);
        this.app.waitForExpectedMessageReceipt(1000);
        this.engine.stop();
        ArrayList<String> additionalContent = new ArrayList<String>();
        additionalContent.add("project-conf=" + AepEngineLogArchiveTest.getProjectBaseDirectory().getPath() + "/conf");
        additionalContent.add(".=" + AepEngineLogArchiveTest.getProjectBaseDirectory().getPath() + "/pom.xml");
        System.out.println("Creating executable archive...");
        File archive = RogLogUtil.createExecutableArchive((File)new File(AepEngineLogArchiveTest.getTestbedRoot(), "rdat/archives"), (String)"testArchiveMultiple", (PrintStream)System.out, null, additionalContent, (RogLog[])new RogLog[]{log, inbound, outbound});
        String archiveTimeStamp = archive.getName().substring(archive.getName().indexOf("-"));
        archiveTimeStamp = archiveTimeStamp.substring(0, archiveTimeStamp.indexOf("."));
        File extractionFolderRoot = new File(AepEngineLogArchiveTest.getTestbedRoot(), "rdat/test-archive-extraction");
        UtlFile.deleteDirectory((File)extractionFolderRoot);
        File extractionFolder = new File(extractionFolderRoot, "extracted-archives");
        boolean deleteOnExit = false;
        System.out.println("Testing archive...");
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java");
        cmd.add("-DNVROOT=" + System.getProperty("NVROOT"));
        cmd.add("-Djansi.strip=true");
        cmd.add("-Dnv.console.jline.disable=true");
        cmd.add("-jar");
        cmd.add(archive.getCanonicalPath());
        cmd.add(TransactionLogTool.class.getName());
        cmd.add("-e");
        cmd.add(extractionFolderRoot.getCanonicalPath());
        try (ProcessWrapper pw = ProcessWrapper.launch(cmd, (File)archive.getParentFile());){
            pw.setOutputEchoEnabled(true);
            pw.waitForOutputAndQuiesence(1000L, 5000L);
            Assert.assertEquals((String)"Unexpected error output", (Object)"", (Object)pw.getErrorOutput());
            pw.markOutputPosistions();
            pw.writeLn("list open");
            if (!pw.waitForOutputAndQuiesence(1000L, 20000L, "There are 3 open logs")) {
                Assert.fail((String)"The executable jar didn't open all the archived logs");
            }
            File extractedLog = new File(extractionFolder, log.getName() + archiveTimeStamp + ".log");
            Assert.assertTrue((String)("Transaction log not in specified extraction folder, " + extractedLog + " doesn't exist."), (boolean)extractedLog.exists());
            File extractedInbound = new File(extractionFolder, log.getName() + ".in" + archiveTimeStamp + ".log");
            Assert.assertTrue((String)("Inbound log not in specified extraction folder, " + extractedInbound + " doesn't exist."), (boolean)extractedInbound.exists());
            File extractedOutbound = new File(extractionFolder, log.getName() + ".out" + archiveTimeStamp + ".log");
            Assert.assertTrue((String)("Outbound log not in specified extraction folder, " + extractedOutbound + " doesn't exist."), (boolean)extractedOutbound.exists());
            File archivedPom = new File(extractionFolder, "pom.xml");
            File pom = new File(AepEngineLogArchiveTest.getProjectBaseDirectory(), "pom.xml");
            Assert.assertTrue((String)("Extra file not achived: " + archivedPom), (boolean)archivedPom.exists());
            Assert.assertEquals((String)"Mismatched archived file size", (long)pom.length(), (long)archivedPom.length());
            File archivedConf = new File(extractionFolder, "project-conf/conf");
            File conf = new File(AepEngineLogArchiveTest.getProjectBaseDirectory(), "conf");
            Assert.assertTrue((String)("Extra directory not archived: " + archivedConf), (boolean)archivedConf.exists());
            Assert.assertTrue((String)("Extra directory not extracted as directory: " + archivedConf), (boolean)archivedConf.isDirectory());
            Assert.assertEquals((String)"Extra directory has wrong number of entries: ", (long)conf.list().length, (long)archivedConf.list().length);
            pw.markOutputPosistions();
            pw.writeLn("set deleteExtractedArchivesDirOnExit " + (deleteOnExit ? " on" : " off"));
            pw.waitForOutputAndQuiesence(1000L, 5000L);
            pw.markOutputPosistions();
            pw.writeLn("exit");
            pw.waitForOutputAndQuiesence(1000L, 5000L);
        }
        if (deleteOnExit) {
            Assert.assertTrue((String)"Archive extraction folder not cleaned up", (!extractionFolder.exists() ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)"Archive extraction folder erroneously cleaned up", (boolean)extractionFolder.exists());
        }
    }

    private void sendMessages(int count) {
        block5: for (int i = 0; i < count; ++i) {
            switch (this.encoding) {
                case Json: {
                    RogNode message = Message.create();
                    message.setMessageBus("aeptest1");
                    message.setMessageChannel("channel1");
                    this.engine.sendMessage(this.app.channel1, (IRogMessage)message);
                    continue block5;
                }
                case Proto: {
                    RogNode message = com.neeve.aep.test.unit.generated.proto.Message.create();
                    message.setMessageBus("aeptest1");
                    message.setMessageChannel("channel1");
                    this.engine.sendMessage(this.app.channel1, (IRogMessage)message);
                    continue block5;
                }
                case Xbuf: {
                    RogNode message = com.neeve.aep.test.unit.generated.xbuf.Message.create();
                    message.setMessageBus("aeptest1");
                    message.setMessageChannel("channel1");
                    this.engine.sendMessage(this.app.channel1, (IRogMessage)message);
                    continue block5;
                }
                default: {
                    throw new UnsupportedOperationException((Object)((Object)this.encoding) + " encoding is not supported in this test");
                }
            }
        }
    }

    private AepEngine createEngine(boolean inbound, boolean outbound) throws Exception {
        AepEngine engine = this.createEngine(this.appName, AepEngine.HAPolicy.StateReplication, inbound ? AepEngine.InboundMessageLoggingPolicy.UseDedicated : AepEngine.InboundMessageLoggingPolicy.Off, outbound ? AepEngine.OutboundMessageLoggingPolicy.UseDedicated : AepEngine.OutboundMessageLoggingPolicy.Off, true, true, 15, 1, this.app, null, new IAepApplicationStateFactory(){

            @Override
            public IRogNode createState(MessageView message) throws Exception {
                switch (AepEngineLogArchiveTest.this.encoding) {
                    case Json: {
                        return com.neeve.aep.test.unit.generated.json.Repository.create();
                    }
                    case Proto: {
                        return Repository.create();
                    }
                    case Xbuf: {
                        return com.neeve.aep.test.unit.generated.xbuf.Repository.create();
                    }
                }
                throw new UnsupportedOperationException((Object)((Object)AepEngineLogArchiveTest.this.encoding) + " encoding is not supported in this test");
            }
        }, new AepEngineTest.BaseEngineCusomizer(){

            @Override
            public void customizeStore(StoreDescriptor descriptor) {
            }

            @Override
            public void customizePersister(StorePersisterDescriptor descriptor) {
            }

            @Override
            public void customizeEngine(AepEngineDescriptor descriptor) {
                descriptor.setAdaptiveCommitBatchCeiling(1);
            }
        });
        switch (this.encoding) {
            case Json: {
                engine.registerFactory(new com.neeve.aep.test.unit.generated.json.Factory());
                break;
            }
            case Proto: {
                engine.registerFactory(new com.neeve.aep.test.unit.generated.proto.Factory());
                break;
            }
            case Xbuf: {
                engine.registerFactory(new Factory());
                break;
            }
            default: {
                throw new UnsupportedOperationException((Object)((Object)this.encoding) + " encoding is not supported in this test");
            }
        }
        this.app.engine = engine;
        engine.start();
        engine.waitForMessagingToStart();
        return engine;
    }
}

