/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.event.AepChannelDownEvent;
import com.neeve.aep.event.AepChannelUpEvent;
import com.neeve.aep.test.unit.AepEngineTestApp;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.aep.test.unit.generated.json.Message;
import com.neeve.ods.impl.StoreMemberInitCompleteEvent;
import com.neeve.ods.impl.StoreMemberUpEvent;

public final class AepEngineInitTestApp
extends AepEngineTestApp {
    AepEngine engine;
    boolean failMessageReceipt;
    int blockAfter;
    int initCompleteEventCount;
    int memberUpEventCount;
    int memberDownEventCount;
    int members;
    int messageCount;
    Object initCompletionWaiter = new Object();
    Object membershipWaiter = new Object();
    Object messageReceiptWaiter = new Object();
    Object blocker = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onMessage(AepEngineTestObject.EncodingType encodingType) {
        if (this.failMessageReceipt) {
            throw new RuntimeException("force failed by user (message receipt)");
        }
        Object object = this.messageReceiptWaiter;
        synchronized (object) {
            ++this.messageCount;
            this.messageReceiptWaiter.notifyAll();
            if (this.engine != null) {
                AepEngineTestMessage out = new AepEngineTestMessage(encodingType);
                out.getMessage().setMessageBus("aeptest1");
                out.getMessage().setMessageChannel("channel2");
                this.engine.sendMessage(this.channel2, out.getMessage());
            }
        }
        object = this.blocker;
        synchronized (object) {
            while (this.blockAfter > 0 && this.messageCount == this.blockAfter) {
                try {
                    this.blocker.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean waitForInitToComplete(int currentCount) {
        Object object = this.initCompletionWaiter;
        synchronized (object) {
            long startTime = System.currentTimeMillis();
            long remainingTime = 1000L;
            while (this.initCompleteEventCount == currentCount && remainingTime > 0L) {
                try {
                    this.initCompletionWaiter.wait(remainingTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                remainingTime = 1000L - (System.currentTimeMillis() - startTime);
            }
            return this.initCompleteEventCount > currentCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean waitForMembershipToStabilize(int expectedCount) {
        Object object = this.membershipWaiter;
        synchronized (object) {
            long startTime = System.currentTimeMillis();
            long remainingTime = 1000L;
            while (this.members != expectedCount && remainingTime > 0L) {
                try {
                    this.membershipWaiter.wait(remainingTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                remainingTime = 1000L - (System.currentTimeMillis() - startTime);
            }
            return this.members == expectedCount;
        }
    }

    final boolean waitForExpectedMessageReceipt(int secondsToWait, int expectedMessageCount) {
        for (int i = 0; i < secondsToWait; ++i) {
            System.out.println("received " + this.messageCount + "...");
            if (this.messageCount < expectedMessageCount) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            return true;
        }
        return false;
    }

    final boolean waitForExpectedMessageReceipt(int expectedMessageCount) {
        return this.waitForExpectedMessageReceipt(10, expectedMessageCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void unblock() {
        Object object = this.blocker;
        synchronized (object) {
            this.blockAfter = 0;
            this.blocker.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    public void onInitCompleteHandler(StoreMemberInitCompleteEvent event) {
        Object object = this.initCompletionWaiter;
        synchronized (object) {
            ++this.initCompleteEventCount;
            this.initCompletionWaiter.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    public void onMemberUpHandler(StoreMemberUpEvent event) {
        Object object = this.membershipWaiter;
        synchronized (object) {
            ++this.memberUpEventCount;
            ++this.members;
            this.membershipWaiter.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    public void onMemberDownHandler(StoreMemberUpEvent event) {
        Object object = this.membershipWaiter;
        synchronized (object) {
            ++this.memberDownEventCount;
            --this.members;
            this.membershipWaiter.notifyAll();
        }
    }

    @EventHandler(source="channel1@aeptest1")
    public void onChannel1UpEventHandler(AepChannelUpEvent event) {
        this.channel1 = event.getMessageChannel();
    }

    @EventHandler(source="channel1@aeptest1")
    public void onChannel1DownEventHandler(AepChannelDownEvent event) {
        this.channel1 = null;
    }

    @EventHandler(source="channel2@aeptest1")
    public void onChannel2UpEventHandler(AepChannelUpEvent event) {
        this.channel2 = event.getMessageChannel();
    }

    @EventHandler(source="channel2@aeptest1")
    public void onChannel2DownEventHandler(AepChannelDownEvent event) {
        this.channel2 = null;
    }

    @EventHandler
    public void onProtoMessageHandler(com.neeve.aep.test.unit.generated.proto.Message message) {
        this.onMessage(AepEngineTestObject.EncodingType.Proto);
    }

    @EventHandler
    public void onXbufMessageHandler(com.neeve.aep.test.unit.generated.xbuf.Message message) {
        this.onMessage(AepEngineTestObject.EncodingType.Xbuf);
    }

    @EventHandler
    public void onJsonMessageHandler(Message message) {
        this.onMessage(AepEngineTestObject.EncodingType.Json);
    }
}

