/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep;

import cern.colt.bitvector.BitVector;
import cern.colt.function.IntObjectProcedure;
import cern.colt.map.OpenIntObjectHashMap;
import com.neeve.aep.AepBusManager;
import com.neeve.aep.AepEngine;
import com.neeve.aep.IAepBusManagerStats;
import com.neeve.aep.IAepEngineStats;
import com.neeve.event.EventFactory;
import com.neeve.event.IEventMultiplexer;
import com.neeve.event.IEventMultiplexerStats;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreBindingStats;
import com.neeve.ods.IStorePersister;
import com.neeve.ods.IStorePersisterStats;
import com.neeve.rog.IRogMessageLogger;
import com.neeve.stats.IStats;
import com.neeve.stats.IStatsAlert;
import com.neeve.stats.Stats;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

final class AepEngineStats
extends Stats
implements IAepEngineStats {
    private final AepEngine engine;
    private final NumberFormat format;
    private final MessageTypeStatsStamper msgTypeStatsStamper;
    private final MessageTypeStatsGetter msgTypeStatsGetter;
    private long startTime;
    private long deltaStartTime;
    private long numMsgsRcvdBestEffortLast;
    private long numMsgsRcvdGuaranteedLast;
    private long numMsgsSourcedLast;
    private long numMsgsFilteredLast;
    private long numMsgsSentBestEffortLast;
    private long numMsgsSentGuaranteedLast;
    private long numEventsRcvdLast;
    private long numFlowEventsRcvdLast;
    private long numTransactionsLast;
    volatile int numFlows;
    volatile long numMsgsRcvdBestEffort;
    volatile long numMsgsRcvdGuaranteed;
    volatile long numMsgsSourced;
    volatile long numMsgsFiltered;
    volatile long numDupMsgsRcvd;
    volatile long numMsgsSentBestEffort;
    volatile long numMsgsSentGuaranteed;
    volatile long numMsgsResent;
    volatile long numEventsRcvd;
    volatile long numEventsProcessed;
    volatile long numFlowEventsRcvd;
    volatile long numFlowEventsProcSuccess;
    volatile long numFlowEventsProcFail;
    volatile long numFlowEventsProcComplete;
    volatile long numTransactions;
    volatile long numCommitsStarted;
    volatile long numCommitsCompleted;
    volatile long numSendCommitsStarted;
    volatile long numSendCommitsCompleted;
    volatile int sendCommitCompletionQueueSize;
    volatile long numStoreCommitsStarted;
    volatile long numStoreCommitsCompleted;
    volatile long numRollbacks;
    volatile long numPartialRollbacks;
    volatile int backupOutboundQueueSize;
    volatile int backupOutboundLogQueueSize;
    volatile long outboundSno;
    volatile long outboundStableSno;
    final OpenIntObjectHashMap msgTypeStatsTable;
    final Stats.LatencyManager msgPreProcessingLatencies = new Stats.LatencyManager("mpproc");
    final Stats.LatencyManager msgProcessingLatencies = new Stats.LatencyManager(" mproc");
    final Stats.LatencyManager msgFilteringLatencies = new Stats.LatencyManager(" mfilt");
    final Stats.LatencyManager msgSendLatencies = new Stats.LatencyManager(" msend");
    final Stats.LatencyManager msgSendCoreLatencies = new Stats.LatencyManager("msendc");
    final Stats.LatencyManager commitStartLatencies = new Stats.LatencyManager("cstart");
    final Stats.LatencyManager commitPrologueLatencies = new Stats.LatencyManager("cprolo");
    final Stats.LatencyManager commitSendLatencies = new Stats.LatencyManager(" csend");
    final Stats.LatencyManager commitTransitionLatencies = new Stats.LatencyManager("ctrans");
    final Stats.LatencyManager commitStoreLatencies = new Stats.LatencyManager("cstore");
    final Stats.LatencyManager commitEpilogueLatencies = new Stats.LatencyManager("cepilo");
    final Stats.LatencyManager commitFullLatencies = new Stats.LatencyManager(" cfull");
    final Stats.LatencyManager txnLeg1ProcTimes = new Stats.LatencyManager(" tleg1");
    final Stats.LatencyManager txnLeg2ProcTimes = new Stats.LatencyManager(" tleg2");
    final Stats.LatencyManager txnLeg3ProcTimes = new Stats.LatencyManager(" tleg3");
    final Stats.LatencyManager inOutLatencies = new Stats.LatencyManager(" inout");
    final Stats.LatencyManager inAckLatencies = new Stats.LatencyManager(" inack");
    final Stats.LatencyManager[] eventLatencies = new Stats.LatencyManager[32768];
    final ArrayList<IStats.Series> userSeriesStats = new ArrayList();
    final ArrayList<IStats.Counter> userCounterStats = new ArrayList();
    final ArrayList<IStats.Gauge> userGaugeStats = new ArrayList();
    final boolean collectPerMessageCreateToOffer;
    final boolean collectPerMessageOfferToPoll;
    final boolean collectPerMessageMpproc;
    final boolean collectPerMessageMproc;
    final boolean collectPerMessageMfilt;
    private final Stats.LongMetric numCommitsOutstandingMetric = new Stats.LongMetric((Stats)this, "numCommitsOutstanding");

    AepEngineStats(AepEngine engine, String name, String startProp, boolean captureEvLatencyStats) {
        super("nv.aep", name, "nv.aep.engine.stats", startProp);
        this.engine = engine;
        this.format = NumberFormat.getInstance();
        this.format.setMaximumFractionDigits(2);
        this.msgTypeStatsTable = new OpenIntObjectHashMap(2048, 0.1, 0.5);
        this.msgTypeStatsStamper = new MessageTypeStatsStamper();
        this.msgTypeStatsGetter = new MessageTypeStatsGetter();
        if (captureEvLatencyStats) {
            this.initializeEventLatencyManagers();
        }
        this.addAlertListener(new AlertListener());
        String statsToCapture = engine.getDescriptor().getMessageTypeStatsLatenciesToCapture();
        if (statsToCapture != null) {
            statsToCapture.trim().toLowerCase();
        }
        if (statsToCapture == null || statsToCapture.length() == 0 || statsToCapture.equalsIgnoreCase("none")) {
            this.collectPerMessageCreateToOffer = false;
            this.collectPerMessageOfferToPoll = false;
            this.collectPerMessageMpproc = false;
            this.collectPerMessageMproc = false;
            this.collectPerMessageMfilt = false;
        } else if (statsToCapture.equalsIgnoreCase("all")) {
            this.collectPerMessageCreateToOffer = true;
            this.collectPerMessageOfferToPoll = true;
            this.collectPerMessageMpproc = true;
            this.collectPerMessageMproc = true;
            this.collectPerMessageMfilt = true;
        } else {
            HashSet<String> statsToCaptureSet = new HashSet<String>();
            for (String stat : statsToCapture.split(",")) {
                statsToCaptureSet.add(stat.trim());
            }
            if (statsToCaptureSet.size() > 1 && statsToCaptureSet.contains("all") || statsToCaptureSet.contains("none")) {
                throw new IllegalArgumentException("Invalid message type latency stats configuration (" + statsToCapture + "): 'all' and 'none' cannot be combined with other values");
            }
            this.collectPerMessageCreateToOffer = statsToCaptureSet.remove("c2o");
            this.collectPerMessageOfferToPoll = statsToCaptureSet.remove("o2p");
            this.collectPerMessageMpproc = statsToCaptureSet.remove("mpproc");
            this.collectPerMessageMproc = statsToCaptureSet.remove("mproc");
            this.collectPerMessageMfilt = statsToCaptureSet.remove("mfilt");
            if (!statsToCaptureSet.isEmpty()) {
                throw new IllegalArgumentException("Invalid message type latency stats configuration ... unrecognized latency stat value(s): " + statsToCaptureSet);
            }
        }
        this.startPeriodicOutputIfConfigured();
    }

    private final void initializeEventLatencyManagers() {
        BitVector registeredEventTypes = EventFactory.getInstance().getRegisteredEventTypes();
        for (int i = 0; i < this.eventLatencies.length; ++i) {
            if (!registeredEventTypes.get(i)) continue;
            this.eventLatencies[i] = new Stats.LatencyManager(EventFactory.getInstance().getEventType((short)i).getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stamp() {
        this.deltaStartTime = System.currentTimeMillis();
        this.numMsgsRcvdBestEffortLast = this.numMsgsRcvdBestEffort;
        this.numMsgsRcvdGuaranteedLast = this.numMsgsRcvdGuaranteed;
        this.numMsgsSourcedLast = this.numMsgsSourced;
        this.numMsgsFilteredLast = this.numMsgsFiltered;
        this.numMsgsSentBestEffortLast = this.numMsgsSentBestEffort;
        this.numMsgsSentGuaranteedLast = this.numMsgsSentGuaranteed;
        this.numEventsRcvdLast = this.numEventsRcvd;
        this.numFlowEventsRcvdLast = this.numFlowEventsRcvd;
        this.numTransactionsLast = this.numTransactions;
        if (this.msgTypeStatsTable != null) {
            OpenIntObjectHashMap openIntObjectHashMap = this.msgTypeStatsTable;
            synchronized (openIntObjectHashMap) {
                this.msgTypeStatsTable.forEachPair((IntObjectProcedure)this.msgTypeStatsStamper);
            }
        }
    }

    final MessageTypeStats newMessageTypeStats(String name, int key, short viewId, short factoryId) {
        return new MessageTypeStats(name, key, viewId, factoryId);
    }

    protected final void init() {
        this.startTime = System.currentTimeMillis();
        this.stamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void get(StringBuilder sb) {
        int i;
        long currentTime = System.currentTimeMillis();
        long deltaTime = currentTime - this.deltaStartTime;
        long deltaTotalTime = currentTime - this.startTime;
        int numFlowsCurrent = this.numFlows;
        long numMsgsRcvdBestEffortCurrent = this.numMsgsRcvdBestEffort;
        long numMsgsRcvdGuaranteedCurrent = this.numMsgsRcvdGuaranteed;
        long numMsgsSourcedCurrent = this.numMsgsSourced;
        long numMsgsFilteredCurrent = this.numMsgsFiltered;
        long numDupMsgsRcvdCurrent = this.numDupMsgsRcvd;
        long numMsgsSentBestEffortCurrent = this.numMsgsSentBestEffort;
        long numMsgsSentGuaranteedCurrent = this.numMsgsSentGuaranteed;
        long numMsgsResentCurrent = this.numMsgsResent;
        long numEventsRcvdCurrent = this.numEventsRcvd;
        long numEventsProcessedCurrent = this.numEventsProcessed;
        long numFlowEventsRcvdCurrent = this.numFlowEventsRcvd;
        long numFlowEventsProcSuccessCurrent = this.numFlowEventsProcSuccess;
        long numFlowEventsProcFailCurrent = this.numFlowEventsProcFail;
        long numFlowEventsProcCompleteCurrent = this.numFlowEventsProcComplete;
        long numTransactionsCurrent = this.numTransactions;
        long numCommitsStartedCurrent = this.numCommitsStarted;
        long numCommitsCompletedCurrent = this.numCommitsCompleted;
        long numSendCommitsStartedCurrent = this.numSendCommitsStarted;
        long numSendCommitsCompletedCurrent = this.numSendCommitsCompleted;
        long sendCommitCompletionQueueSizeCurrent = this.sendCommitCompletionQueueSize;
        long numStoreCommitsStartedCurrent = this.numStoreCommitsStarted;
        long numStoreCommitsCompletedCurrent = this.numStoreCommitsCompleted;
        long numRollbacksCurrent = this.numRollbacks;
        long numPartialRollbacksCurrent = this.numPartialRollbacks;
        this.msgPreProcessingLatencies.compute();
        this.msgProcessingLatencies.compute();
        this.msgFilteringLatencies.compute();
        this.msgSendLatencies.compute();
        this.msgSendCoreLatencies.compute();
        this.commitStartLatencies.compute();
        this.commitPrologueLatencies.compute();
        this.commitSendLatencies.compute();
        this.commitTransitionLatencies.compute();
        this.commitStoreLatencies.compute();
        this.commitEpilogueLatencies.compute();
        this.commitFullLatencies.compute();
        this.txnLeg1ProcTimes.compute();
        this.txnLeg2ProcTimes.compute();
        this.txnLeg3ProcTimes.compute();
        this.inOutLatencies.compute();
        this.inAckLatencies.compute();
        for (i = 0; i < this.eventLatencies.length; ++i) {
            if (this.eventLatencies[i] == null || this.eventLatencies[i].count() <= 0L) continue;
            this.eventLatencies[i].compute();
        }
        for (i = 0; i < this.userSeriesStats.size(); ++i) {
            IStats.Series latencies = this.userSeriesStats.get(i);
            if (latencies.sequenceNumber() <= 0L) continue;
            latencies.compute();
        }
        for (i = 0; i < this.userCounterStats.size(); ++i) {
            IStats.Counter counter = this.userCounterStats.get(i);
            if (counter.getCount() <= 0L) continue;
            counter.compute();
        }
        String numMsgsRcvdStr = this.format.format(numMsgsRcvdBestEffortCurrent + numMsgsRcvdGuaranteedCurrent);
        String msgRecvRateStr = this.format.format((numMsgsRcvdBestEffortCurrent + numMsgsRcvdGuaranteedCurrent) * 1000L / deltaTotalTime);
        String deltaMsgRecvRateStr = this.format.format((numMsgsRcvdBestEffortCurrent + numMsgsRcvdGuaranteedCurrent - (this.numMsgsRcvdBestEffortLast + this.numMsgsRcvdGuaranteedLast)) * 1000L / deltaTime);
        String numMsgsRcvdBestEffortStr = this.format.format(numMsgsRcvdBestEffortCurrent);
        String bestEffortMsgRecvRateStr = this.format.format(numMsgsRcvdBestEffortCurrent * 1000L / deltaTotalTime);
        String deltaBestEffortMsgRecvRateStr = this.format.format((numMsgsRcvdBestEffortCurrent - this.numMsgsRcvdBestEffortLast) * 1000L / deltaTime);
        String numMsgsRcvdGuaranteedStr = this.format.format(numMsgsRcvdGuaranteedCurrent);
        String guaranteedMsgRecvRateStr = this.format.format(numMsgsRcvdGuaranteedCurrent * 1000L / deltaTotalTime);
        String deltaGuaranteedMsgRecvRateStr = this.format.format((numMsgsRcvdGuaranteedCurrent - this.numMsgsRcvdGuaranteedLast) * 1000L / deltaTime);
        String numMsgsSourcedStr = this.format.format(numMsgsSourcedCurrent);
        String msgSourceRateStr = this.format.format(numMsgsSourcedCurrent * 1000L / deltaTotalTime);
        String deltaMsgSourceRateStr = this.format.format((numMsgsSourcedCurrent - this.numMsgsSourcedLast) * 1000L / deltaTime);
        String numMsgsFilteredStr = this.format.format(numMsgsFilteredCurrent);
        String msgFilteredRateStr = this.format.format(numMsgsFilteredCurrent * 1000L / deltaTotalTime);
        String deltaMsgFilteredRateStr = this.format.format((numMsgsFilteredCurrent - this.numMsgsFilteredLast) * 1000L / deltaTime);
        String numDupMsgsRcvdStr = this.format.format(numDupMsgsRcvdCurrent);
        String numMsgsSentStr = this.format.format(numMsgsSentBestEffortCurrent + numMsgsSentGuaranteedCurrent);
        String msgSendRateStr = this.format.format((numMsgsSentBestEffortCurrent + numMsgsSentGuaranteedCurrent) * 1000L / deltaTotalTime);
        String deltaMsgSendRateStr = this.format.format((numMsgsSentBestEffortCurrent + numMsgsSentGuaranteedCurrent - (this.numMsgsSentBestEffortLast + this.numMsgsSentGuaranteedLast)) * 1000L / deltaTime);
        String numMsgsSentBestEffortStr = this.format.format(numMsgsSentBestEffortCurrent);
        String bestEffortMsgSendRateStr = this.format.format(numMsgsSentBestEffortCurrent * 1000L / deltaTotalTime);
        String deltaBestEffortMsgSendRateStr = this.format.format((numMsgsSentBestEffortCurrent - this.numMsgsSentBestEffortLast) * 1000L / deltaTime);
        String numMsgsSentGuaranteedStr = this.format.format(numMsgsSentGuaranteedCurrent);
        String guaranteedMsgSendRateStr = this.format.format(numMsgsSentGuaranteedCurrent * 1000L / deltaTotalTime);
        String deltaGuaranteedMsgSendRateStr = this.format.format((numMsgsSentGuaranteedCurrent - this.numMsgsSentGuaranteedLast) * 1000L / deltaTime);
        String numMsgsResentStr = this.format.format(numMsgsResentCurrent);
        String outboundSnoStr = this.format.format(this.outboundSno);
        String outboundStableSnoStr = this.format.format(this.outboundStableSno);
        String numEventsRcvdStr = this.format.format(numEventsRcvdCurrent);
        String eventRecvRateStr = this.format.format(numEventsRcvdCurrent * 1000L / deltaTotalTime);
        String deltaEventRecvRateStr = this.format.format((numEventsRcvdCurrent - this.numEventsRcvdLast) * 1000L / deltaTime);
        String numEventsProcessedStr = this.format.format(numEventsProcessedCurrent);
        String numFlowEventsRcvdStr = this.format.format(numFlowEventsRcvdCurrent);
        String numFlowEventsProcSuccessStr = this.format.format(numFlowEventsProcSuccessCurrent);
        String numFlowEventsProcFailStr = this.format.format(numFlowEventsProcFailCurrent);
        String numFlowEventsProcCompleteStr = this.format.format(numFlowEventsProcCompleteCurrent);
        String flowEventRecvRateStr = this.format.format(numFlowEventsRcvdCurrent * 1000L / deltaTotalTime);
        String deltaFlowEventRecvRateStr = this.format.format((numFlowEventsRcvdCurrent - this.numFlowEventsRcvdLast) * 1000L / deltaTime);
        String numTransactionsStr = this.format.format(numTransactionsCurrent);
        String transactionRateStr = this.format.format(numTransactionsCurrent * 1000L / deltaTotalTime);
        String deltaTransactionRateStr = this.format.format((numTransactionsCurrent - this.numTransactionsLast) * 1000L / deltaTime);
        String numCommitsStartedCurrentStr = this.format.format(numCommitsStartedCurrent);
        String numCommitsCompletedCurrentStr = this.format.format(numCommitsCompletedCurrent);
        String numSendCommitsStartedCurrentStr = this.format.format(numSendCommitsStartedCurrent);
        String numSendCommitsCompletedCurrentStr = this.format.format(numSendCommitsCompletedCurrent);
        String sendCommitCompletionQueueSizeCurrentStr = this.format.format(sendCommitCompletionQueueSizeCurrent);
        String numStoreCommitsStartedCurrentStr = this.format.format(numStoreCommitsStartedCurrent);
        String numStoreCommitsCompletedCurrentStr = this.format.format(numStoreCommitsCompletedCurrent);
        long avgNumFlowEventsPerTransaction = numCommitsStartedCurrent == 0L ? 0L : numFlowEventsProcSuccessCurrent / numCommitsStartedCurrent;
        sb.append("Flows.{");
        sb.append(numFlowsCurrent);
        sb.append("}").append("\n");
        sb.append("Msg...{");
        sb.append("In{");
        sb.append(numMsgsRcvdStr).append("(").append(msgRecvRateStr).append(" ").append(deltaMsgRecvRateStr).append(") ");
        sb.append(numMsgsRcvdBestEffortStr).append("(").append(bestEffortMsgRecvRateStr).append(" ").append(deltaBestEffortMsgRecvRateStr).append(") ");
        sb.append(numMsgsRcvdGuaranteedStr).append("(").append(guaranteedMsgRecvRateStr).append(" ").append(deltaGuaranteedMsgRecvRateStr).append(") ");
        sb.append(numMsgsSourcedStr).append("(").append(msgSourceRateStr).append(" ").append(deltaMsgSourceRateStr).append(") ");
        sb.append(numMsgsFilteredStr).append("(").append(msgFilteredRateStr).append(" ").append(deltaMsgFilteredRateStr).append(") ");
        sb.append("(").append(numDupMsgsRcvdStr).append(")");
        sb.append("}");
        sb.append(" Out{");
        sb.append(numMsgsSentStr).append("(").append(msgSendRateStr).append(" ").append(deltaMsgSendRateStr).append(") ");
        sb.append(numMsgsSentBestEffortStr).append("(").append(bestEffortMsgSendRateStr).append(" ").append(deltaBestEffortMsgSendRateStr).append(") ");
        sb.append(numMsgsSentGuaranteedStr).append("(").append(guaranteedMsgSendRateStr).append(" ").append(deltaGuaranteedMsgSendRateStr).append(") ");
        sb.append("(").append(outboundSnoStr).append(" ").append(outboundStableSnoStr).append(" ").append(this.backupOutboundQueueSize).append(" ").append(this.backupOutboundLogQueueSize).append(") ");
        sb.append("(").append(numMsgsResentStr).append(")");
        sb.append("}");
        sb.append("}").append("\n");
        sb.append("Ev....{");
        sb.append(numEventsProcessedStr).append("/").append(numEventsRcvdStr).append("(").append(eventRecvRateStr).append(" ").append(deltaEventRecvRateStr).append(") ");
        sb.append(numFlowEventsRcvdStr).append("[").append(numFlowEventsProcSuccessStr).append(",").append(numFlowEventsProcFailStr).append(",").append(numFlowEventsProcCompleteStr).append("]").append("(").append(flowEventRecvRateStr).append(" ").append(deltaFlowEventRecvRateStr).append(")");
        sb.append("}").append("\n");
        sb.append("Txn...{");
        sb.append(numTransactionsStr).append("[(").append(numCommitsStartedCurrentStr).append(",").append(numCommitsCompletedCurrentStr).append("),(").append(numSendCommitsStartedCurrentStr).append(",").append(numSendCommitsCompletedCurrentStr).append(" (").append(sendCommitCompletionQueueSizeCurrentStr).append(")),(").append(numStoreCommitsStartedCurrentStr).append(",").append(numStoreCommitsCompletedCurrentStr).append(",").append(numRollbacksCurrent).append(",").append(numPartialRollbacksCurrent).append("]").append("(").append(transactionRateStr).append(" ").append(deltaTransactionRateStr).append(") ").append(avgNumFlowEventsPerTransaction);
        sb.append("}").append("\n");
        sb.append("[Message Type Specific]\n");
        if (!this.msgTypeStatsTable.isEmpty()) {
            OpenIntObjectHashMap openIntObjectHashMap = this.msgTypeStatsTable;
            synchronized (openIntObjectHashMap) {
                if (this.msgTypeStatsTable.size() > 0) {
                    this.msgTypeStatsTable.forEachPair((IntObjectProcedure)this.msgTypeStatsGetter.sb(sb));
                } else {
                    sb.append("...0 message types.");
                }
            }
        }
        sb.append("\n[Transaction Latencies]\n");
        this.msgPreProcessingLatencies.get(sb);
        this.msgProcessingLatencies.get(sb);
        this.msgFilteringLatencies.get(sb);
        this.msgSendLatencies.get(sb);
        this.msgSendCoreLatencies.get(sb);
        this.commitStartLatencies.get(sb);
        this.commitPrologueLatencies.get(sb);
        this.commitSendLatencies.get(sb);
        this.commitTransitionLatencies.get(sb);
        this.commitStoreLatencies.get(sb);
        this.commitEpilogueLatencies.get(sb);
        this.commitFullLatencies.get(sb);
        this.txnLeg1ProcTimes.get(sb);
        this.txnLeg2ProcTimes.get(sb);
        this.txnLeg3ProcTimes.get(sb);
        this.inOutLatencies.get(sb);
        this.inAckLatencies.get(sb);
        sb.append("[Event Latencies]\n");
        int numEventLatencies = 0;
        for (int i2 = 0; i2 < this.eventLatencies.length; ++i2) {
            if (this.eventLatencies[i2] == null || this.eventLatencies[i2].count() <= 0L) continue;
            this.eventLatencies[i2].get(sb);
            ++numEventLatencies;
        }
        if (numEventLatencies == 0) {
            sb.append("...no event latencies.").append("\n");
        }
        IEventMultiplexer mux = this.engine.getEventMultiplexerInternal();
        sb.append("\n").append("[Event Multiplexer (").append(mux.getName()).append(")]").append("\n");
        mux.getStats().get(sb);
        IStoreBinding storeBinding = this.engine.getStore();
        if (storeBinding != null) {
            sb.append("\n").append("[Store (").append(storeBinding.getDescriptor().getName()).append(")]").append("\n");
            storeBinding.getStats().get(sb);
        }
        IStorePersisterStats inboundLogStats = this.getInboundMessageLoggerStats();
        sb.append("\n").append("[Inbound Message Logger]").append("\n");
        if (inboundLogStats != null) {
            inboundLogStats.get(sb);
        } else {
            sb.append("<No Inbound Message Logger>").append("\n");
        }
        IStorePersisterStats outboundLogStats = this.getOutboundMessageLoggerStats();
        sb.append("\n").append("[Outbound Message Logger]").append("\n");
        if (outboundLogStats != null) {
            outboundLogStats.get(sb);
        } else {
            sb.append("<No Outbound Message Logger>").append("\n");
        }
        IStorePersisterStats perTransactionStats = this.getPerTransactionStatsLoggerStats();
        sb.append("\n").append("[Per Transaction Stats Logger]").append("\n");
        if (perTransactionStats != null) {
            perTransactionStats.get(sb);
        } else {
            sb.append("<No Per Transaction Stats Logger>").append("\n");
        }
        Collection<AepBusManager> busManagers = this.engine.getBusManagers();
        if (busManagers != null) {
            for (AepBusManager busManager : busManagers) {
                sb.append("\n").append("[Bus Manager (").append(busManager.getName()).append(")]").append("\n");
                busManager.getStats().get(sb);
            }
        }
        if (this.userSeriesStats.size() > 0) {
            sb.append("\n").append("[User Series Stats]");
            for (int i3 = 0; i3 < this.userSeriesStats.size(); ++i3) {
                IStats.Series series = this.userSeriesStats.get(i3);
                if (series.sample() <= 0L) continue;
                sb.append("\n");
                series.get(sb, this.format);
            }
            sb.append("\n");
        }
        if (this.userCounterStats.size() > 0) {
            sb.append("\n").append("[User Counter Stats]");
            for (int i4 = 0; i4 < this.userCounterStats.size(); ++i4) {
                IStats.Counter counter = this.userCounterStats.get(i4);
                sb.append("\n...").append((CharSequence)counter.getNameAsRaw()).append(": ");
                counter.get(sb, this.format);
            }
            sb.append("\n");
        }
        if (this.userGaugeStats.size() > 0) {
            sb.append("\n").append("[User Gauge Stats]");
            for (int i5 = 0; i5 < this.userGaugeStats.size(); ++i5) {
                IStats.Gauge gauge = this.userGaugeStats.get(i5);
                sb.append("\n...").append((CharSequence)gauge.getNameAsRaw()).append(": ");
                gauge.get(sb, this.format);
            }
            sb.append("\n");
        }
        this.numCommitsOutstandingMetric.setValue((Object)(numCommitsStartedCurrent - numCommitsCompletedCurrent));
        this.stamp();
    }

    @Override
    public final int getNumFlows() {
        return this.numFlows;
    }

    @Override
    public final long getNumMsgsRcvdBestEffort() {
        return this.numMsgsRcvdBestEffort;
    }

    @Override
    public final long getNumMsgsRcvdGuaranteed() {
        return this.numMsgsRcvdGuaranteed;
    }

    @Override
    public final long getNumMsgsSourced() {
        return this.numMsgsSourced;
    }

    @Override
    public final long getNumMsgsFiltered() {
        return this.numMsgsFiltered;
    }

    @Override
    public final long getNumDupMsgsRcvd() {
        return this.numDupMsgsRcvd;
    }

    @Override
    public final long getNumMsgsSentBestEffort() {
        return this.numMsgsSentBestEffort;
    }

    @Override
    public final long getNumMsgsSentGuaranteed() {
        return this.numMsgsSentGuaranteed;
    }

    @Override
    public final long getNumMsgsResent() {
        return this.numMsgsResent;
    }

    @Override
    public final long getNumEventsRcvd() {
        return this.numEventsRcvd;
    }

    @Override
    public final long getNumEventsProcessed() {
        return this.numEventsProcessed;
    }

    @Override
    public final long getNumFlowEventsRcvd() {
        return this.numFlowEventsRcvd;
    }

    @Override
    public final long getNumFlowEventsProcSuccess() {
        return this.numFlowEventsProcSuccess;
    }

    @Override
    public final long getNumFlowEventsProcFail() {
        return this.numFlowEventsProcFail;
    }

    @Override
    public final long getNumFlowEventsProcComplete() {
        return this.numFlowEventsProcComplete;
    }

    @Override
    public final long getNumTransactions() {
        return this.numTransactions;
    }

    @Override
    public final long getNumCommitsStarted() {
        return this.numCommitsStarted;
    }

    @Override
    public final long getNumCommitsCompleted() {
        return this.numCommitsCompleted;
    }

    @Override
    public final void setNumCommitsOutstandingAlertThreshold(long threshold) {
        this.numCommitsOutstandingMetric.setAlertThreshold((Object)threshold, true);
    }

    @Override
    public final void clearNumCommitsOutstandingAlertThreshold() {
        this.numCommitsOutstandingMetric.setAlertThreshold(null, true);
    }

    @Override
    public final long getNumSendCommitsStarted() {
        return this.numSendCommitsStarted;
    }

    @Override
    public final long getNumSendCommitsCompleted() {
        return this.numSendCommitsCompleted;
    }

    @Override
    public final int getSendCommitCompletionQueueSize() {
        return this.sendCommitCompletionQueueSize;
    }

    @Override
    public final long getNumStoreCommitsStarted() {
        return this.numStoreCommitsStarted;
    }

    @Override
    public final long getNumStoreCommitsCompleted() {
        return this.numStoreCommitsCompleted;
    }

    @Override
    @Deprecated
    public final int getStoreCommitCompletionQueueSize() {
        return 0;
    }

    @Override
    public final long getNumRollbacks() {
        return this.numRollbacks;
    }

    @Override
    public final long getNumPartialRollbacks() {
        return this.numPartialRollbacks;
    }

    @Override
    public final int getBackupOutboundQueueSize() {
        return this.backupOutboundQueueSize;
    }

    @Override
    public final int getBackupOutboundLogQueueSize() {
        return this.backupOutboundLogQueueSize;
    }

    @Override
    public final long getOutboundSequenceNumber() {
        return this.outboundSno;
    }

    @Override
    public final long getOutboundStableSequenceNumber() {
        return this.outboundStableSno;
    }

    @Override
    public final IStats.Latencies getMsgPreProcessingLatencies() {
        return this.msgPreProcessingLatencies;
    }

    @Override
    public final IStats.Latencies getMsgProcessingLatencies() {
        return this.msgProcessingLatencies;
    }

    @Override
    public final IStats.Latencies getMsgFilteringLatencies() {
        return this.msgFilteringLatencies;
    }

    @Override
    public final IStats.Latencies getMsgSendLatencies() {
        return this.msgSendLatencies;
    }

    @Override
    public final IStats.Latencies getMsgSendCoreLatencies() {
        return this.msgSendCoreLatencies;
    }

    @Override
    public final IStats.Latencies getCommitStartLatencies() {
        return this.commitStartLatencies;
    }

    @Override
    public final IStats.Latencies getCommitPrologueLatencies() {
        return this.commitPrologueLatencies;
    }

    @Override
    public final IStats.Latencies getCommitSendLatencies() {
        return this.commitSendLatencies;
    }

    @Override
    public final IStats.Latencies getCommitStoreLatencies() {
        return this.commitStoreLatencies;
    }

    @Override
    public final IStats.Latencies getCommitTransitionLatencies() {
        return this.commitTransitionLatencies;
    }

    @Override
    public final IStats.Latencies getCommitTransactionLatencies() {
        return this.commitTransitionLatencies;
    }

    @Override
    public final IStats.Latencies getCommitEpilogueLatencies() {
        return this.commitEpilogueLatencies;
    }

    @Override
    public final IStats.Latencies getCommitFullLatencies() {
        return this.commitFullLatencies;
    }

    @Override
    public final IStats.Latencies getTransactionLeg1ProcessingTimes() {
        return this.txnLeg1ProcTimes;
    }

    @Override
    public final IStats.Latencies getTransactionLeg2ProcessingTimes() {
        return this.txnLeg2ProcTimes;
    }

    @Override
    public final IStats.Latencies getTransactionLeg3ProcessingTimes() {
        return this.txnLeg3ProcTimes;
    }

    @Override
    public final IStats.Latencies getInOutLatencies() {
        return this.inOutLatencies;
    }

    @Override
    public final IStats.Latencies getInAckLatencies() {
        return this.inAckLatencies;
    }

    @Override
    public final OpenIntObjectHashMap getMessageTypeStatsTable() {
        return this.msgTypeStatsTable;
    }

    @Override
    public final List<IAepBusManagerStats> getBusManagerStats() {
        ArrayList<IAepBusManagerStats> stats = new ArrayList<IAepBusManagerStats>();
        Collection<AepBusManager> busManagers = this.engine.getBusManagers();
        if (busManagers != null) {
            for (AepBusManager busManager : busManagers) {
                stats.add(busManager.getStats());
            }
        }
        return stats;
    }

    @Override
    public final void getBusManagerStats(List<IAepBusManagerStats> busManagerStats) {
        this.engine.collectBusManagerStats(busManagerStats);
    }

    @Override
    @Deprecated
    public IStoreBindingStats getStoreStats() {
        return this.getStoreBindingStats();
    }

    @Override
    public IStoreBindingStats getStoreBindingStats() {
        return this.engine.getStore() != null ? this.engine.getStore().getStats() : null;
    }

    @Override
    public IStorePersisterStats getInboundMessageLoggerStats() {
        IRogMessageLogger log = this.engine.getInboundMessageLogger();
        if (log != null && log instanceof IStorePersister) {
            return ((IStorePersister)log).getStats();
        }
        return null;
    }

    @Override
    public IStorePersisterStats getOutboundMessageLoggerStats() {
        IRogMessageLogger log = this.engine.getOutboundMessageLogger();
        if (log != null && log instanceof IStorePersister) {
            return ((IStorePersister)log).getStats();
        }
        return null;
    }

    @Override
    public IStorePersisterStats getPerTransactionStatsLoggerStats() {
        IRogMessageLogger log = this.engine.getPerTransactionStatsLogger();
        if (log != null && log instanceof IStorePersister) {
            return ((IStorePersister)log).getStats();
        }
        return null;
    }

    @Override
    public IEventMultiplexerStats getEventMultiplexerStats() {
        return this.engine.getEventMultiplexerInternal().getStats();
    }

    @Override
    public List<IStats.Series> getUserSeriesStats() {
        return this.userSeriesStats;
    }

    final void addUserSeriesStat(IStats.Series series) {
        this.userSeriesStats.add(series);
    }

    public List<IStats.Counter> getUserCounterStats() {
        return this.userCounterStats;
    }

    final void addUserCounterStat(IStats.Counter counter) {
        this.userCounterStats.add(counter);
    }

    public List<IStats.Gauge> getUserGaugeStats() {
        return this.userGaugeStats;
    }

    public void addUserGaugeStat(IStats.Gauge gauge) {
        this.userGaugeStats.add(gauge);
    }

    final class MessageTypeStats
    implements IAepEngineStats.IMessageTypeStats {
        final String name;
        final int type;
        final short viewId;
        final short factoryId;
        private long numMsgsRcvdBestEffortLast;
        private long numMsgsRcvdGuaranteedLast;
        private long numMsgsSourcedLast;
        private long numMsgsSentBestEffortLast;
        private long numMsgsSentGuaranteedLast;
        private long numMsgsFilteredLast;
        volatile long numMsgsRcvdBestEffort;
        volatile long numMsgsRcvdGuaranteed;
        volatile long numMsgsFiltered;
        volatile long numMsgsSourced;
        volatile long numDupMsgsRcvd;
        volatile long numMsgsSentBestEffort;
        volatile long numMsgsSentGuaranteed;
        volatile long numMsgsResent;
        final Stats.LatencyManager msgCreateToOfferLatencies;
        final Stats.LatencyManager msgOfferToPollLatencies;
        final Stats.LatencyManager msgPreProcessingLatencies;
        final Stats.LatencyManager msgProcessingLatencies;
        final Stats.LatencyManager msgFilteringLatencies;

        MessageTypeStats(String name, int type, short viewId, short factoryId) {
            this.msgCreateToOfferLatencies = AepEngineStats.this.collectPerMessageCreateToOffer ? new Stats.LatencyManager("  c2o") : null;
            this.msgOfferToPollLatencies = AepEngineStats.this.collectPerMessageOfferToPoll ? new Stats.LatencyManager("  o2p") : null;
            this.msgPreProcessingLatencies = AepEngineStats.this.collectPerMessageMpproc ? new Stats.LatencyManager("mpproc") : null;
            this.msgProcessingLatencies = AepEngineStats.this.collectPerMessageMproc ? new Stats.LatencyManager(" mproc") : null;
            this.msgFilteringLatencies = AepEngineStats.this.collectPerMessageMfilt ? new Stats.LatencyManager(" mfilt") : null;
            this.name = name;
            this.type = type;
            this.viewId = viewId;
            this.factoryId = factoryId;
        }

        private void stamp() {
            this.numMsgsRcvdBestEffortLast = this.numMsgsRcvdBestEffort;
            this.numMsgsRcvdGuaranteedLast = this.numMsgsRcvdGuaranteed;
            this.numMsgsFilteredLast = this.numMsgsFiltered;
            this.numMsgsSourcedLast = this.numMsgsSourced;
            this.numMsgsSentBestEffortLast = this.numMsgsSentBestEffort;
            this.numMsgsSentGuaranteedLast = this.numMsgsSentGuaranteed;
        }

        @Override
        public final void reset() {
            this.numMsgsRcvdBestEffort = 0L;
            this.numMsgsRcvdBestEffortLast = 0L;
            this.numMsgsRcvdGuaranteed = 0L;
            this.numMsgsRcvdGuaranteedLast = 0L;
            this.numMsgsFiltered = 0L;
            this.numMsgsFilteredLast = 0L;
            this.numMsgsSentBestEffort = 0L;
            this.numMsgsSentBestEffortLast = 0L;
            this.numMsgsSentGuaranteed = 0L;
            this.numMsgsSentGuaranteedLast = 0L;
            this.numDupMsgsRcvd = 0L;
            this.numMsgsResent = 0L;
            this.numMsgsSourced = 0L;
            this.numMsgsSourcedLast = 0L;
            this.msgCreateToOfferLatencies.reset();
            this.msgOfferToPollLatencies.reset();
            this.msgPreProcessingLatencies.reset();
            this.msgProcessingLatencies.reset();
            this.msgFilteringLatencies.reset();
        }

        protected final void get(StringBuilder sb) {
            long currentTime = System.currentTimeMillis();
            long deltaTime = currentTime - AepEngineStats.this.deltaStartTime;
            long deltaTotalTime = currentTime - AepEngineStats.this.startTime;
            long numMsgsRcvdBestEffortCurrent = this.numMsgsRcvdBestEffort;
            long numMsgsRcvdGuaranteedCurrent = this.numMsgsRcvdGuaranteed;
            long numMsgsFilteredCurrent = this.numMsgsFiltered;
            long numMsgsSourcedCurrent = this.numMsgsSourced;
            long numDupMsgsRcvdCurrent = this.numDupMsgsRcvd;
            long numMsgsSentBestEffortCurrent = this.numMsgsSentBestEffort;
            long numMsgsSentGuaranteedCurrent = this.numMsgsSentGuaranteed;
            long numMsgsResentCurrent = this.numMsgsResent;
            if (this.msgCreateToOfferLatencies != null) {
                this.msgCreateToOfferLatencies.compute();
            }
            if (this.msgOfferToPollLatencies != null) {
                this.msgOfferToPollLatencies.compute();
            }
            if (this.msgPreProcessingLatencies != null) {
                this.msgPreProcessingLatencies.compute();
            }
            if (this.msgProcessingLatencies != null) {
                this.msgProcessingLatencies.compute();
            }
            if (this.msgFilteringLatencies != null) {
                this.msgFilteringLatencies.compute();
            }
            String numMsgsRcvdStr = AepEngineStats.this.format.format(numMsgsRcvdBestEffortCurrent + numMsgsRcvdGuaranteedCurrent);
            String msgRecvRateStr = AepEngineStats.this.format.format((numMsgsRcvdBestEffortCurrent + numMsgsRcvdGuaranteedCurrent) * 1000L / deltaTotalTime);
            String deltaMsgRecvRateStr = AepEngineStats.this.format.format((numMsgsRcvdBestEffortCurrent + numMsgsRcvdGuaranteedCurrent - (this.numMsgsRcvdBestEffortLast + this.numMsgsRcvdGuaranteedLast)) * 1000L / deltaTime);
            String numMsgsRcvdBestEffortStr = AepEngineStats.this.format.format(numMsgsRcvdBestEffortCurrent);
            String bestEffortMsgRecvRateStr = AepEngineStats.this.format.format(numMsgsRcvdBestEffortCurrent * 1000L / deltaTotalTime);
            String deltaBestEffortMsgRecvRateStr = AepEngineStats.this.format.format((numMsgsRcvdBestEffortCurrent - this.numMsgsRcvdBestEffortLast) * 1000L / deltaTime);
            String numMsgsRcvdGuaranteedStr = AepEngineStats.this.format.format(numMsgsRcvdGuaranteedCurrent);
            String guaranteedMsgRecvRateStr = AepEngineStats.this.format.format(numMsgsRcvdGuaranteedCurrent * 1000L / deltaTotalTime);
            String deltaGuaranteedMsgRecvRateStr = AepEngineStats.this.format.format((numMsgsRcvdGuaranteedCurrent - this.numMsgsRcvdGuaranteedLast) * 1000L / deltaTime);
            String numMsgsFilteredStr = AepEngineStats.this.format.format(numMsgsFilteredCurrent);
            String msgFilteredRateStr = AepEngineStats.this.format.format(numMsgsFilteredCurrent * 1000L / deltaTotalTime);
            String deltaMsgFilteredRateStr = AepEngineStats.this.format.format((numMsgsFilteredCurrent - this.numMsgsFilteredLast) * 1000L / deltaTime);
            String numMsgsSourcedStr = AepEngineStats.this.format.format(numMsgsSourcedCurrent);
            String msgSourceRateStr = AepEngineStats.this.format.format(numMsgsSourcedCurrent * 1000L / deltaTotalTime);
            String deltaMsgSourceRateStr = AepEngineStats.this.format.format((numMsgsSourcedCurrent - this.numMsgsSourcedLast) * 1000L / deltaTime);
            String numDupMsgsRcvdStr = AepEngineStats.this.format.format(numDupMsgsRcvdCurrent);
            String numMsgsSentStr = AepEngineStats.this.format.format(numMsgsSentBestEffortCurrent + numMsgsSentGuaranteedCurrent);
            String msgSendRateStr = AepEngineStats.this.format.format((numMsgsSentBestEffortCurrent + numMsgsSentGuaranteedCurrent) * 1000L / deltaTotalTime);
            String deltaMsgSendRateStr = AepEngineStats.this.format.format((numMsgsSentBestEffortCurrent + numMsgsSentGuaranteedCurrent - (this.numMsgsSentBestEffortLast + this.numMsgsSentGuaranteedLast)) * 1000L / deltaTime);
            String numMsgsSentBestEffortStr = AepEngineStats.this.format.format(numMsgsSentBestEffortCurrent);
            String bestEffortMsgSendRateStr = AepEngineStats.this.format.format(numMsgsSentBestEffortCurrent * 1000L / deltaTotalTime);
            String deltaBestEffortMsgSendRateStr = AepEngineStats.this.format.format((numMsgsSentBestEffortCurrent - this.numMsgsSentBestEffortLast) * 1000L / deltaTime);
            String numMsgsSentGuaranteedStr = AepEngineStats.this.format.format(numMsgsSentGuaranteedCurrent);
            String guaranteedMsgSendRateStr = AepEngineStats.this.format.format(numMsgsSentGuaranteedCurrent * 1000L / deltaTotalTime);
            String deltaGuaranteedMsgSendRateStr = AepEngineStats.this.format.format((numMsgsSentGuaranteedCurrent - this.numMsgsSentGuaranteedLast) * 1000L / deltaTime);
            String numMsgsResentStr = AepEngineStats.this.format.format(numMsgsResentCurrent);
            sb.append(String.format("%-50s", this.name));
            sb.append("In{");
            sb.append(numMsgsRcvdStr + "(" + msgRecvRateStr + " " + deltaMsgRecvRateStr + ") ");
            sb.append(numMsgsRcvdBestEffortStr + "(" + bestEffortMsgRecvRateStr + " " + deltaBestEffortMsgRecvRateStr + ") ");
            sb.append(numMsgsRcvdGuaranteedStr + "(" + guaranteedMsgRecvRateStr + " " + deltaGuaranteedMsgRecvRateStr + ") ");
            sb.append(numMsgsSourcedStr + "(" + msgSourceRateStr + " " + deltaMsgSourceRateStr + ") ");
            sb.append(numMsgsFilteredStr + "(" + msgFilteredRateStr + " " + deltaMsgFilteredRateStr + ") ");
            sb.append("(" + numDupMsgsRcvdStr + ")");
            sb.append("}");
            sb.append(" Out{");
            sb.append(numMsgsSentStr + "(" + msgSendRateStr + " " + deltaMsgSendRateStr + ") ");
            sb.append(numMsgsSentBestEffortStr + "(" + bestEffortMsgSendRateStr + " " + deltaBestEffortMsgSendRateStr + ") ");
            sb.append(numMsgsSentGuaranteedStr + "(" + guaranteedMsgSendRateStr + " " + deltaGuaranteedMsgSendRateStr + ") ");
            sb.append("(" + numMsgsResentStr + ")");
            sb.append("}");
            sb.append("\n");
            sb.append("[").append(this.name).append(" Latencies]");
            if (this.msgCreateToOfferLatencies != null) {
                this.msgCreateToOfferLatencies.get(sb);
            }
            if (this.msgOfferToPollLatencies != null) {
                this.msgOfferToPollLatencies.get(sb);
            }
            if (this.msgPreProcessingLatencies != null) {
                this.msgPreProcessingLatencies.get(sb);
            }
            if (this.msgProcessingLatencies != null) {
                this.msgProcessingLatencies.get(sb);
            }
            if (this.msgFilteringLatencies != null) {
                this.msgFilteringLatencies.get(sb);
            }
            this.stamp();
        }

        @Override
        public String getMessageTypeName() {
            return this.name;
        }

        @Override
        public short getMessageTypeId() {
            return this.viewId;
        }

        @Override
        public short getMessageFactoryId() {
            return this.factoryId;
        }

        @Override
        public final long getNumMsgsRcvdBestEffort() {
            return this.numMsgsRcvdBestEffort;
        }

        @Override
        public final long getNumMsgsRcvdGuaranteed() {
            return this.numMsgsRcvdGuaranteed;
        }

        @Override
        public final long getNumMsgsFiltered() {
            return this.numMsgsFiltered;
        }

        @Override
        public final long getNumMsgsSourced() {
            return this.numMsgsSourced;
        }

        @Override
        public final long getNumDupMsgsRcvd() {
            return this.numDupMsgsRcvd;
        }

        @Override
        public final long getNumMsgsSentBestEffort() {
            return this.numMsgsSentBestEffort;
        }

        @Override
        public final long getNumMsgsSentGuaranteed() {
            return this.numMsgsSentGuaranteed;
        }

        @Override
        public final long getNumMsgsResent() {
            return this.numMsgsResent;
        }

        @Override
        public final IStats.Latencies getMsgCreateToOfferLatencies() {
            return this.msgCreateToOfferLatencies;
        }

        @Override
        public final IStats.Latencies getMsgOfferToPollLatencies() {
            return this.msgOfferToPollLatencies;
        }

        @Override
        public final IStats.Latencies getMsgPreProcessingLatencies() {
            return this.msgPreProcessingLatencies;
        }

        @Override
        public final IStats.Latencies getMsgProcessingLatencies() {
            return this.msgProcessingLatencies;
        }

        @Override
        public final IStats.Latencies getMsgFilteringLatencies() {
            return this.msgFilteringLatencies;
        }
    }

    private final class AlertListener
    implements Stats.IAlertListener {
        private AlertListener() {
        }

        public final void onStatsAlert(IStatsAlert alert) {
            AepEngineStats.this.engine.onStatsAlert(alert);
        }
    }

    private final class MessageTypeStatsGetter
    implements IntObjectProcedure {
        StringBuilder sb;

        private MessageTypeStatsGetter() {
        }

        final MessageTypeStatsGetter sb(StringBuilder sb) {
            this.sb = sb;
            return this;
        }

        public final boolean apply(int key, Object value) {
            ((MessageTypeStats)value).get(this.sb);
            return true;
        }
    }

    private final class MessageTypeStatsStamper
    implements IntObjectProcedure {
        private MessageTypeStatsStamper() {
        }

        public final boolean apply(int key, Object value) {
            ((MessageTypeStats)value).stamp();
            return true;
        }
    }
}

