/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep;

import com.lmax.disruptor.BatchEventProcessor;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.BusySpinWaitStrategy;
import com.lmax.disruptor.ClaimStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.MultiThreadedClaimStrategy;
import com.lmax.disruptor.MultiThreadedLowContentionClaimStrategy;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.SingleThreadedClaimStrategy;
import com.lmax.disruptor.SleepingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.YieldingWaitStrategy;
import com.neeve.aep.AepBusManagerStats;
import com.neeve.aep.AepEngine;
import com.neeve.aep.AepEngineDescriptor;
import com.neeve.aep.AepSendCommitCompletionEvent;
import com.neeve.aep.AepSendEvent;
import com.neeve.aep.EAepException;
import com.neeve.aep.event.AepBusBindingDownEvent;
import com.neeve.aep.event.AepBusBindingOpenFailedEvent;
import com.neeve.aep.event.AepBusBindingOpenedEvent;
import com.neeve.aep.event.AepBusBindingOpeningEvent;
import com.neeve.aep.event.AepBusBindingUpEvent;
import com.neeve.aep.event.AepChannelDownEvent;
import com.neeve.aep.event.AepChannelUpEvent;
import com.neeve.aep.event.AepDuplicateAcknowledgementAlertEvent;
import com.neeve.aep.event.AepSendExceptionEvent;
import com.neeve.ci.XRuntime;
import com.neeve.emx.EEmxException;
import com.neeve.emx.EEmxTimeoutException;
import com.neeve.emx.EmxFactory;
import com.neeve.emx.EmxThread;
import com.neeve.emx.IEmxAlarmEvent;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.emx.IEmxDispatcherRunCompletionChecker;
import com.neeve.emx.IEmxEvent;
import com.neeve.emx.IEmxEventHandler;
import com.neeve.event.Event;
import com.neeve.event.IEventHandler;
import com.neeve.event.IEventMultiplexer;
import com.neeve.rog.IRogMessage;
import com.neeve.rog.IRogNode;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageBusBindingFactory;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessageWaypointListener;
import com.neeve.sma.MessageWaypointListenerRegistry;
import com.neeve.sma.SmaException;
import com.neeve.sma.event.MessageBatchEvent;
import com.neeve.sma.event.MessageBusBindingFailedEvent;
import com.neeve.sma.event.MessageBusBindingFlushCompletionEvent;
import com.neeve.sma.event.MessageEvent;
import com.neeve.sma.event.MessageStabilityBatchEvent;
import com.neeve.sma.event.MessageStabilityEvent;
import com.neeve.sma.event.UnhandledMessageEvent;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlList;
import com.neeve.util.UtlListElement;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThread;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlTime;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;

public final class AepBusManager
extends UtlListElement
implements IEventHandler {
    public static final String PROP_USER_NAME = "user_name";
    private final MessageBusBinding.StatsListener statsListener = new MessageBusBinding.StatsListener(){

        public final void onAck() {
            ++((AepBusManager)AepBusManager.this).stats.numAcksSent;
        }
    };
    private final int id;
    private final String name;
    private final AepEngine engine;
    private final MessageBusDescriptor busDescriptor;
    private final IEventMultiplexer multiplexer;
    private final MessageBusBinding.SequenceNumberGenerator snoGenerator;
    private final Map<String, MessageChannel> channels;
    private final OutboundQueue oq;
    private final BindingOpener bindingOpener;
    private final AepBusManagerStats stats;
    private final boolean administrative;
    private final boolean manualStart;
    private final boolean scheduleSendCommitCompletionEvents;
    private final int sendCommitCompletionEventPriority;
    private final boolean nonBlockingInboundMessageDispatch;
    private final int inboundMessageEventPriority;
    private final Tracer tracer;
    private final Tracer msgTracer;
    private final String tracePrefix;
    private final int openRetryInterval = 5;
    private final String userName;
    private MessageBusBinding binding;
    private boolean acksRequireFlush;
    private volatile State state;

    AepBusManager(AepEngine engine, int id, MessageBusDescriptor busDescriptor, IEventMultiplexer multiplexer, MessageBusBinding.SequenceNumberGenerator snoGenerator, Properties props, boolean administrative, Tracer tracer, Tracer msgTracer, String tracePrefix) throws Exception {
        this.name = engine.getDescriptor().getName() + "." + busDescriptor.getName();
        this.userName = props == null ? engine.getDescriptor().getName() : UtlProps.getValue((Properties)props, (String)PROP_USER_NAME, (String)engine.getDescriptor().getName());
        this.engine = engine;
        this.id = id;
        this.busDescriptor = busDescriptor;
        this.multiplexer = multiplexer;
        this.snoGenerator = snoGenerator;
        this.channels = new LinkedHashMap<String, MessageChannel>();
        this.administrative = administrative;
        this.manualStart = UtlProps.getValue((Properties)props, (String)"manualStart", (boolean)false);
        this.scheduleSendCommitCompletionEvents = UtlProps.getValue((Properties)props, (String)"scheduleSendCommitCompletionEvents", (boolean)false);
        this.sendCommitCompletionEventPriority = UtlProps.getValue((Properties)props, (String)"sendCommitCompletionEventPriority", (int)0);
        this.nonBlockingInboundMessageDispatch = UtlProps.getValue((Properties)props, (String)"nonBlockingInboundMessageDispatch", (boolean)false);
        this.inboundMessageEventPriority = UtlProps.getValue((Properties)props, (String)"inboundMessageEventPriority", (int)0);
        this.tracer = tracer;
        this.msgTracer = msgTracer;
        this.tracePrefix = tracePrefix;
        this.oq = new OutboundQueue(props);
        this.bindingOpener = new BindingOpener();
        this.bindingOpener.setDaemon(true);
        this.stats = new AepBusManagerStats(this, this.name, "nv.aep.busmanager." + this.name + ".stats.interval");
        this.setState(State.CREATED, null);
    }

    private final void setState(State state, Object object) {
        if (this.state != state) {
            State previousState = this.state;
            this.state = state;
            try {
                switch (state) {
                    case CREATED: {
                        break;
                    }
                    case OPENING: {
                        this.onPassThroughEvent((Event)AepBusBindingOpeningEvent.create(this.busDescriptor.getName()));
                        break;
                    }
                    case OPEN: {
                        this.onPassThroughEvent((Event)AepBusBindingOpenedEvent.create(this.busDescriptor.getName()));
                        break;
                    }
                    case STARTED: {
                        break;
                    }
                    case FAILED: {
                        Exception e = (Exception)object;
                        if (previousState != State.OPENING) break;
                        this.onPassThroughEvent((Event)AepBusBindingOpenFailedEvent.create(this.busDescriptor.getName(), e, false));
                        break;
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private final void scheduleOpen() {
        try {
            this.setState(State.OPENING, null);
            this.bindingOpener.scheduleOpen();
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + " Scheduled '" + this.busDescriptor.getName() + "' bus open.", Tracer.Level.DEBUG);
            }
        }
        catch (Exception e) {
            String error = e.getMessage() == null ? e.toString() : e.getMessage();
            this.tracer.log(this.tracePrefix + " Failed to scheduled '" + this.busDescriptor.getName() + "' bus open [" + error + "] Aborting binding open....", Tracer.Level.WARNING);
            this.setState(State.FAILED, e);
        }
    }

    private final void startCore() {
        try {
            this.binding.start();
            this.setState(State.STARTED, null);
        }
        catch (SmaException e) {
            throw new RuntimeException(e);
        }
    }

    private final Map<String, AepEngineDescriptor.ChannelConfig> prepareChannelSet() {
        Map<String, AepEngineDescriptor.ChannelConfig> busChannels;
        Map<String, AepEngineDescriptor.ChannelConfig> globalChannels;
        HashMap<String, AepEngineDescriptor.ChannelConfig> channels = new HashMap<String, AepEngineDescriptor.ChannelConfig>();
        if (!this.engine.isBusBindingInternal(this.busDescriptor.getName()) && (globalChannels = this.engine.getDescriptor().getChannels("$global$")) != null) {
            for (String channelName : globalChannels.keySet()) {
                channels.put(channelName, globalChannels.get(channelName));
            }
        }
        if ((busChannels = this.engine.getDescriptor().getChannels(this.busDescriptor.getName())) != null) {
            for (String channelName : busChannels.keySet()) {
                channels.put(channelName, busChannels.get(channelName));
            }
        }
        for (MessageChannelDescriptor busInternalChannel : this.binding.getDescriptor().getChannels()) {
            if (channels.containsKey(busInternalChannel.getName()) || busInternalChannel.getChannelId() != Short.MAX_VALUE) continue;
            channels.put(busInternalChannel.getName(), new AepEngineDescriptor.ChannelConfig());
        }
        return channels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final EAepException openCore(boolean start) {
        try {
            Map<String, AepEngineDescriptor.ChannelConfig> engineConfiguredChannels = this.engine.getDescriptor().getChannels(this.busDescriptor.getName());
            if (engineConfiguredChannels != null) {
                for (Map.Entry<String, AepEngineDescriptor.ChannelConfig> engineChannelConfig : engineConfiguredChannels.entrySet()) {
                    MessageChannelDescriptor busChannelDescriptor;
                    if (engineChannelConfig.getValue().getFilter() != null) {
                        busChannelDescriptor = this.busDescriptor.getChannel(engineChannelConfig.getKey());
                        busChannelDescriptor.setChannelFilter(engineChannelConfig.getValue().getFilter());
                    }
                    if (engineChannelConfig.getValue().getPreserveJoinsOnClose() == null) continue;
                    busChannelDescriptor = this.busDescriptor.getChannel(engineChannelConfig.getKey());
                    busChannelDescriptor.setPreserveJoinsOnClose(engineChannelConfig.getValue().getPreserveJoinsOnClose());
                }
            }
            this.binding = MessageBusBindingFactory.getInstance().createBinding(this.userName, this.busDescriptor, (IEventHandler)this);
            this.binding.setStatsListener(this.statsListener);
            this.binding.setSequenceNumberGenerator(this.snoGenerator);
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + " Opened bus '" + this.busDescriptor.getName() + "' (provider='" + this.busDescriptor.getProviderConfig().getProperty("Provider") + "')", Tracer.Level.DEBUG);
            }
            this.acksRequireFlush = this.binding.acksRequireFlush();
            this.binding.setAttachment((Object)this);
            Object object = this;
            synchronized (object) {
                Map<String, AepEngineDescriptor.ChannelConfig> busChannels = this.prepareChannelSet();
                if (busChannels.size() > 0) {
                    for (String channelName : busChannels.keySet()) {
                        boolean shouldJoin = busChannels.get(channelName).getShouldJoin();
                        String s1 = "...channel '" + channelName + "' (join=" + shouldJoin + ")...";
                        try {
                            MessageChannel channel = this.binding.getMessageChannel(channelName);
                            if (shouldJoin) {
                                try {
                                    channel.join(0);
                                }
                                catch (SmaException smae) {
                                    this.tracer.log(this.tracePrefix + " Failed to join channel '" + channelName + "' from bus '" + this.busDescriptor.getName() + "' [" + smae.getMessage() + "]", Tracer.Level.SEVERE);
                                    throw new RuntimeException(smae);
                                }
                            }
                            this.channels.put(channelName, channel);
                            s1 = s1 + "ok.";
                            if (!this.tracer.debug) continue;
                            this.tracer.log(this.tracePrefix + " " + s1, Tracer.Level.DEBUG);
                        }
                        catch (SmaException e) {
                            String error;
                            String string = error = e.getMessage() == null ? e.toString() : e.getMessage();
                            if (this.tracer.debug) {
                                s1 = s1 + "failed [" + error + "].";
                                this.tracer.log(this.tracePrefix + " " + s1, Tracer.Level.DEBUG);
                                continue;
                            }
                            this.tracer.log(this.tracePrefix + " Failed to get channel '" + channelName + "' from bus '" + this.busDescriptor.getName() + "' [" + error + "]", Tracer.Level.WARNING);
                        }
                    }
                } else if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + " ...no channels configured.", Tracer.Level.DEBUG);
                }
                this.setState(State.OPEN, null);
                if (start) {
                    try {
                        this.startCore();
                        if (this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + " Started bus '" + this.busDescriptor.getName() + "' binding.", Tracer.Level.DEBUG);
                        }
                    }
                    catch (RuntimeException e) {
                        String error = e.getMessage() == null ? e.toString() : e.getMessage();
                        this.tracer.log(this.tracePrefix + " Failed to start bus '" + this.busDescriptor.getName() + "' binding [" + error + "]", Tracer.Level.SEVERE);
                        throw e;
                    }
                }
                for (MessageChannel channel : this.channels.values()) {
                    try {
                        this.onEvent((Event)AepChannelUpEvent.create(this.binding, channel));
                    }
                    catch (Throwable e) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("Channel UP event processing faulted with error [" + e.toString() + "] with the following stack trace:\n");
                        sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                        sb.append("Ignoring...");
                        this.tracer.log(sb.toString(), Tracer.Level.WARNING);
                    }
                }
                try {
                    this.onEvent((Event)AepBusBindingUpEvent.create(this.binding));
                }
                catch (Throwable e) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Bus binding UP event processing faulted with error [" + e.toString() + "] with the following stack trace:\n");
                    sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                    sb.append("Ignoring...");
                    this.tracer.log(sb.toString(), Tracer.Level.WARNING);
                }
                return null;
            }
        }
        catch (SmaException e) {
            String error = e.getMessage() == null ? e.toString() : e.getMessage();
            this.tracer.log(this.tracePrefix + " Failed (temporary) to open bus '" + this.busDescriptor.getName() + "' (provider='" + this.busDescriptor.getProviderConfig().getProperty("Provider") + "') [" + error + "]", Tracer.Level.WARNING);
            this.onPassThroughEvent((Event)AepBusBindingOpenFailedEvent.create(this.busDescriptor.getName(), (Exception)((Object)e), true));
            return new EAepException(e);
        }
        catch (RuntimeException e) {
            this.tracer.log(this.tracePrefix + " Failed (permanent) to open bus '" + this.busDescriptor.getName() + "' (provider='" + this.busDescriptor.getProviderConfig().getProperty("Provider") + "') [" + e.toString() + "]", Tracer.Level.WARNING);
            this.setState(State.FAILED, e);
            return new EAepException(e);
        }
    }

    private final void dispatchToMultiplexer(Event event) {
        boolean nonBlockingDispatch = false;
        boolean schedule = false;
        AepEngine.State engineState = this.engine.getState();
        switch (event.getType()) {
            case 105: {
                if (engineState == AepEngine.State.Stopped || engineState == AepEngine.State.Stopping) {
                    ((MessageEvent)event).setAutoAck(false);
                    if (this.tracer.verbose) {
                        this.tracer.log(this.tracePrefix + "Dropping message event received while engine is " + (Object)((Object)engineState), Tracer.Level.VERBOSE);
                    }
                    return;
                }
                ((MessageEvent)event).getMessageView().setEnqueueTsMicros(UtlTime.nowSinceEpoch());
                nonBlockingDispatch = this.nonBlockingInboundMessageDispatch;
                event.setDelay(this.inboundMessageEventPriority);
                ++this.stats.numMsgsRcvd;
                break;
            }
            case 106: {
                nonBlockingDispatch = this.nonBlockingInboundMessageDispatch;
                event.setDelay(this.inboundMessageEventPriority);
                int size = ((MessageBatchEvent)event).getEventBatch().count();
                ++this.stats.numMsgBatchesRcvd;
                this.stats.numMsgsRcvd += (long)size;
                this.stats.numMsgsInBatchesRcvd += (long)size;
                break;
            }
            case 111: {
                nonBlockingDispatch = this.nonBlockingInboundMessageDispatch;
                event.setDelay(this.inboundMessageEventPriority);
                if (engineState != AepEngine.State.Stopped && engineState != AepEngine.State.Stopping) break;
                ((UnhandledMessageEvent)event).setAutoAck(false);
                if (this.tracer.verbose) {
                    this.tracer.log(this.tracePrefix + "Dropping unhandled message event received while engine is " + (Object)((Object)engineState), Tracer.Level.VERBOSE);
                }
                return;
            }
            case 104: {
                nonBlockingDispatch = true;
                break;
            }
            case 107: {
                nonBlockingDispatch = true;
                break;
            }
            case 103: {
                nonBlockingDispatch = true;
                break;
            }
            case 501: {
                ++this.stats.numClients;
                break;
            }
            case 502: {
                --this.stats.numClients;
                break;
            }
            case 504: {
                ++this.stats.numChannelsUp;
                break;
            }
            case 532: {
                break;
            }
            case 534: {
                break;
            }
            case 535: {
                break;
            }
            case 511: {
                break;
            }
            case 503: {
                ++this.stats.numPacketsRcvd;
                break;
            }
            case 506: {
                nonBlockingDispatch = true;
                schedule = this.scheduleSendCommitCompletionEvents;
                event.setDelay(this.sendCommitCompletionEventPriority);
                break;
            }
            case 505: {
                --this.stats.numChannelsUp;
                break;
            }
            case 512: {
                nonBlockingDispatch = true;
            }
        }
        if (schedule) {
            this.multiplexer.scheduleEvent(event);
        } else {
            if (!nonBlockingDispatch) {
                switch (engineState) {
                    case Init: {
                        break;
                    }
                    case Started: {
                        break;
                    }
                    case Starting: {
                        break;
                    }
                    case Stopped: {
                        nonBlockingDispatch = true;
                        break;
                    }
                    case Stopping: {
                        nonBlockingDispatch = true;
                        break;
                    }
                }
            }
            this.multiplexer.multiplexEvent(event, nonBlockingDispatch ? 1 : 0);
        }
    }

    private final void onBindingFailure(Exception cause) {
        String error = cause.getMessage() == null ? cause.toString() : cause.getMessage();
        this.tracer.log(this.tracePrefix + " Binding to bus '" + this.busDescriptor.getName() + "' has failed [cause=" + error + "].", Tracer.Level.SEVERE);
        try {
            this.binding.close();
        }
        catch (Exception e) {
            this.tracer.log(this.tracePrefix + " Failed to close binding in cleaning up after binding failure [" + e.toString() + "].", Tracer.Level.WARNING);
        }
        ++this.stats.numBindingFailures;
        for (MessageChannel channel : this.channels.values()) {
            try {
                this.dispatchToMultiplexer((Event)AepChannelDownEvent.create(this.binding, channel));
            }
            catch (Throwable e) {
                StringBuilder sb = new StringBuilder();
                sb.append("Channel DOWN event processing faulted with error [" + e.toString() + "] with the following stack trace:\n");
                sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                sb.append("Ignoring...");
                this.tracer.log(sb.toString(), Tracer.Level.WARNING);
            }
        }
        try {
            this.dispatchToMultiplexer((Event)AepBusBindingDownEvent.create(this.binding, cause));
        }
        catch (Throwable e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Bus binding DOWN event processing faulted with error [" + e.toString() + "] with the following stack trace:\n");
            sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
            sb.append("Ignoring...");
            this.tracer.log(sb.toString(), Tracer.Level.WARNING);
        }
        this.setState(State.FAILED, cause);
        if (this.engine.getMessageBusBindingFailPolicy() == AepEngine.MessageBusBindingFailPolicy.Reconnect) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + " Scheduling binding reopen.", Tracer.Level.DEBUG);
            }
            this.scheduleOpen();
        } else if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " Not reopening binding. Message bus binding fail policy is '" + (Object)((Object)this.engine.getMessageBusBindingFailPolicy()) + "'.", Tracer.Level.DEBUG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onPassThroughEvent(Event event) {
        if (this.state == State.OPENING) {
            AepBusManager aepBusManager = this;
            synchronized (aepBusManager) {
                this.dispatchToMultiplexer(event);
            }
        } else {
            this.dispatchToMultiplexer(event);
        }
    }

    final int id() {
        return this.id;
    }

    final boolean acksRequireFlush() {
        return this.acksRequireFlush;
    }

    final boolean manualStart() {
        return this.manualStart;
    }

    final EAepException open() {
        if (this.state == State.CREATED) {
            this.bindingOpener.start();
            this.oq.open();
            this.setState(State.OPENING, null);
            return this.openCore(false);
        }
        throw new IllegalStateException("invalid state '" + (Object)((Object)this.state) + "'");
    }

    final void start() {
        switch (this.state) {
            case OPENING: {
                this.scheduleOpen();
                break;
            }
            case OPEN: {
                this.startCore();
                break;
            }
            case FAILED: {
                break;
            }
            default: {
                throw new IllegalStateException("invalid state '" + (Object)((Object)this.state) + "'");
            }
        }
    }

    final String getName() {
        return this.name;
    }

    final State getState() {
        return this.state;
    }

    final boolean isDetachedCommit() {
        return this.oq.isDetachedCommit();
    }

    final int getDisruptorCapacity() {
        return this.oq.getDisruptorCapacity();
    }

    final int getDisruptorRemaining() {
        return this.oq.getDisruptorRemaining();
    }

    final String getDisruptorClaimStrategy() {
        return this.oq.getDisruptorClaimStrategy();
    }

    final String getDisruptorWaitStrategy() {
        return this.oq.getDisruptorWaitStrategy();
    }

    final void enque(MessageChannel channel, IRogMessage message) {
        this.oq.enque(channel, message);
        ++this.stats.numMsgsEnqueued;
    }

    final OutboundQueue.Slice complete() {
        return this.oq.complete();
    }

    final void commit(OutboundQueue.Slice slice, AepSendCommitCompletionEvent event, long sendTs) {
        this.oq.commit(slice, event, sendTs);
    }

    final void commit(AepSendCommitCompletionEvent event, long sendTs) {
        this.commit(null, event, sendTs);
    }

    final void setSavepoint(int savepoint) {
        this.oq.setCurrentSavepoint(savepoint);
    }

    final void resetSavepoint() {
        this.oq.currentSavepoint = 0;
    }

    final void rollback() {
        this.oq.rollback();
    }

    final void rollback(int savepoint) {
        this.oq.rollback(savepoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void close(Exception cause, boolean preserveChannelJoins) {
        if (this.state != State.CLOSED) {
            try {
                this.bindingOpener.shutdown();
                if (this.state != State.FAILED && (this.state == State.OPEN || this.state == State.STARTED)) {
                    try {
                        int closeFlags;
                        int n = closeFlags = preserveChannelJoins ? 1 : 0;
                        if (cause == null || !this.binding.canFail()) {
                            this.binding.close(closeFlags);
                        } else {
                            this.binding.fail(cause, false);
                        }
                        if (this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + " Closed bus '" + this.busDescriptor.getName() + "'.", Tracer.Level.DEBUG);
                        }
                    }
                    catch (SmaException e) {
                        String error = e.getMessage() == null ? e.toString() : e.getMessage();
                        this.tracer.log(this.tracePrefix + " Failed to close bus '" + this.busDescriptor.getName() + "' [" + error + "]", Tracer.Level.WARNING);
                    }
                }
                this.oq.close();
                this.stats.close();
            }
            finally {
                this.setState(State.CLOSED, null);
            }
        }
    }

    public final boolean isInternal() {
        return this.engine.isBusBindingInternal(this.busDescriptor.getName());
    }

    public final MessageBusDescriptor getBusDescriptor() {
        return this.busDescriptor;
    }

    public final AepBusManagerStats getStats() {
        return this.stats;
    }

    public final MessageBusBinding getBusBinding() {
        return this.binding;
    }

    public final MessageChannel getChannel(String channelName) {
        return this.channels.get(channelName);
    }

    public final void onEvent(Event event) {
        switch (event.getType()) {
            case 102: {
                MessageBusBindingFailedEvent bindingFailedEvent = (MessageBusBindingFailedEvent)event;
                this.onBindingFailure(bindingFailedEvent.getCause());
                break;
            }
            case 108: {
                MessageBusBindingFlushCompletionEvent flushCompletionEvent = (MessageBusBindingFlushCompletionEvent)event;
                MessageBusBinding.AsynchronousFlushContext flushContext = flushCompletionEvent.getFlushContext();
                this.oq.onFlushCompletion(flushContext);
                break;
            }
            case 104: {
                MessageStabilityEvent stabilityEvent = (MessageStabilityEvent)event;
                MessageView view = stabilityEvent.getMessageView();
                Object object = view.getTag(2);
                if (object != null && object instanceof OutboundQueue.SliceElement) {
                    ++this.stats.numStabilityRcvd;
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "message stabilized type=" + view.getClass().getSimpleName() + ", channel=" + view.getMessageChannel() + ", sno=" + view.getMessageSequenceNumber(), Tracer.Level.DEBUG);
                    }
                    OutboundQueue.SliceElement element = (OutboundQueue.SliceElement)((Object)object);
                    if (element.slice != null) {
                        element.slice.onStability(element, stabilityEvent);
                        break;
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append("\nEncountered orphan slice element on stability (duplicate ack?)").append("\n");
                    sb.append("Stack trace:\n");
                    sb.append(UtlThrowable.prepareStackTrace((Throwable)new Exception()));
                    sb.append("Logging exception and continuing...\n");
                    this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
                    try {
                        view.acquire();
                        sb.append("Acknowledged message:\n");
                        sb.append(view.toString()).append("\n");
                    }
                    catch (Throwable e) {
                        sb.append("*** Failed to acquire a reference to the message to dump its contents [" + e.toString() + "] ***").append("\n");
                    }
                    try {
                        this.onEvent((Event)AepDuplicateAcknowledgementAlertEvent.create());
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    break;
                }
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "message stabilized (no slice) type=" + view.getClass().getSimpleName() + ", channel=" + view.getMessageChannel() + ", sno=" + view.getMessageSequenceNumber(), Tracer.Level.DEBUG);
                }
                this.onPassThroughEvent(event);
                break;
            }
            case 107: {
                UtlList eventBatch = ((MessageStabilityBatchEvent)event).getEventBatch();
                int size = eventBatch.count();
                ++this.stats.numStabilityBatchesRcvd;
                this.stats.numStabilityInBatchesRcvd += (long)size;
                MessageStabilityEvent stabilityEvent = null;
                while ((stabilityEvent = (MessageStabilityEvent)eventBatch.first()) != null) {
                    stabilityEvent.unlink();
                    this.onEvent((Event)stabilityEvent);
                }
                break;
            }
            default: {
                this.onPassThroughEvent(event);
            }
        }
    }

    public final String toString() {
        return "AEPBusManager [app=" + this.engine.getDescriptor().getName() + ", bus=" + this.busDescriptor.getName() + ", state=" + (Object)((Object)this.state) + "]";
    }

    final class OutboundQueue
    implements IEmxEventHandler {
        private final UtlPool<Slice> slicePool;
        private final UtlPool<SliceElement> sliceElementPool;
        private final UtlList committed;
        private final MessageBusBinding.AsynchronousFlushContext asyncFlushContext;
        private final String claimStrategyStr;
        private final String waitStrategyStr;
        private final RingBuffer<CarrierEvent> ringBuffer;
        private final SequenceBarrier sequenceBarrier;
        private final CarrierEventProcessor processor;
        private final BatchEventProcessor<CarrierEvent> batchProcessor;
        private final boolean detachedCommit;
        private final long writerCpuAffinityMask;
        private WriterThread writerThread;
        private Slice uncommitted;
        private int currentSavepoint;
        private volatile boolean flushPendingCompletion;
        private int msgsSentSinceLastFlush;

        OutboundQueue(Properties props) {
            if (((AepBusManager)AepBusManager.this).tracer.debug) {
                AepBusManager.this.tracer.log(AepBusManager.this.tracePrefix + " Creating outbound queue for bus manager '" + AepBusManager.this.name + "...", Tracer.Level.DEBUG);
            }
            this.slicePool = UtlPool.create((String)"aep.busmgr.slice", (String)AepBusManager.this.name, (UtlPool.Factory)new SliceFactory(), (UtlPool.Params)UtlPool.Params.create().setThreaded(true));
            this.sliceElementPool = UtlPool.create((String)"aep.busmgr.sliceelement", (String)AepBusManager.this.name, (UtlPool.Factory)new SliceElementFactory(), (UtlPool.Params)UtlPool.Params.create().setThreaded(true));
            this.committed = UtlList.create();
            this.uncommitted = ((Slice)this.slicePool.get(null)).reset();
            this.asyncFlushContext = new MessageBusBinding.AsynchronousFlushContext();
            this.flushPendingCompletion = false;
            boolean bl = this.detachedCommit = UtlProps.getValue((Properties)props, (String)"detachedCommit", (String)UtlProps.getValue((Properties)props, (String)"detachedSend", null)) == null && (XRuntime.optimizeForLatency() || XRuntime.optimizeForThroughput()) && !AepBusManager.this.administrative ? true : UtlProps.getValue((Properties)props, (String)"detachedCommit", (boolean)UtlProps.getValue((Properties)props, (String)"detachedSend", (boolean)false));
            if (this.detachedCommit) {
                SingleThreadedClaimStrategy claimStrategy;
                int queueDepth = UtlProps.getValue((Properties)props, (String)"queueDepth", (int)1024);
                String string = this.claimStrategyStr = XRuntime.optimizeForLatency() || XRuntime.optimizeForThroughput() ? "SingleThreaded" : UtlProps.getValue((Properties)props, (String)"publisherClaimStrategy", (String)UtlProps.getValue((Properties)props, (String)"queueOfferStrategy", (String)"SingleThreaded"));
                if (this.claimStrategyStr.equalsIgnoreCase("SingleThreaded")) {
                    claimStrategy = new SingleThreadedClaimStrategy(queueDepth);
                } else if (this.claimStrategyStr.equalsIgnoreCase("MultiThreaded")) {
                    claimStrategy = new MultiThreadedClaimStrategy(queueDepth);
                } else if (this.claimStrategyStr.equalsIgnoreCase("MultiThreadedSufficientCores")) {
                    claimStrategy = new MultiThreadedLowContentionClaimStrategy(queueDepth);
                } else {
                    throw new IllegalArgumentException("invalid publisher claim strategy '" + this.claimStrategyStr + "'");
                }
                WaitStrategy waitStrategy = XRuntime.createWaitStrategy((String)UtlProps.getValue((Properties)props, (String)"writerWaitStrategy", (String)UtlProps.getValue((Properties)props, (String)"queueWaitStrategy", null)), (!AepBusManager.this.administrative ? 1 : 0) != 0);
                if (waitStrategy instanceof BlockingWaitStrategy) {
                    this.waitStrategyStr = "Blocking";
                } else if (waitStrategy instanceof SleepingWaitStrategy) {
                    this.waitStrategyStr = "Sleeping";
                } else if (waitStrategy instanceof YieldingWaitStrategy) {
                    this.waitStrategyStr = "Yielding";
                } else if (waitStrategy instanceof BusySpinWaitStrategy) {
                    this.waitStrategyStr = "BusySpin";
                } else {
                    throw new IllegalArgumentException("invalid writer wait strategy '" + waitStrategy + "'");
                }
                this.writerCpuAffinityMask = UtlThread.parseAffinityMask((String)UtlProps.getValue((Properties)props, (String)"cpuAffinityMask", (String)UtlProps.getValue((Properties)props, (String)"queueDrainerCpuAffinityMask", (String)"0")));
                if (((AepBusManager)AepBusManager.this).tracer.debug) {
                    AepBusManager.this.tracer.log(AepBusManager.this.tracePrefix + " ...operating in detached mode (background sends)...", Tracer.Level.DEBUG);
                    AepBusManager.this.tracer.log(AepBusManager.this.tracePrefix + " ......queue depth=" + queueDepth + ".", Tracer.Level.DEBUG);
                    AepBusManager.this.tracer.log(AepBusManager.this.tracePrefix + " ......queue offer strategy=" + this.claimStrategyStr + ".", Tracer.Level.DEBUG);
                    AepBusManager.this.tracer.log(AepBusManager.this.tracePrefix + " ......queue wait strategy=" + this.waitStrategyStr + ".", Tracer.Level.DEBUG);
                    AepBusManager.this.tracer.log(AepBusManager.this.tracePrefix + " ......queue drainer cpu affinity=" + this.writerCpuAffinityMask + ".", Tracer.Level.DEBUG);
                }
                this.processor = new CarrierEventProcessor();
                this.ringBuffer = new RingBuffer((EventFactory)new EventFactory<CarrierEvent>(){

                    public CarrierEvent newInstance() {
                        return new CarrierEvent();
                    }
                }, (ClaimStrategy)claimStrategy, waitStrategy);
                this.sequenceBarrier = UtlThread.asIntrumentedSequenceBarrier((SequenceBarrier)this.ringBuffer.newBarrier(new Sequence[0]));
                this.batchProcessor = new BatchEventProcessor(this.ringBuffer, this.sequenceBarrier, (EventHandler)this.processor);
                this.ringBuffer.setGatingSequences(new Sequence[]{this.batchProcessor.getSequence()});
            } else {
                if (((AepBusManager)AepBusManager.this).tracer.debug) {
                    AepBusManager.this.tracer.log(AepBusManager.this.tracePrefix + " ...operating in attached mode (foreground sends)...", Tracer.Level.DEBUG);
                }
                this.writerCpuAffinityMask = 0L;
                this.claimStrategyStr = "N/A";
                this.waitStrategyStr = "N/A";
                this.processor = null;
                this.ringBuffer = null;
                this.sequenceBarrier = null;
                this.batchProcessor = null;
            }
        }

        private final void sendCommitted() {
            block9: {
                if (this.committed.count() > 0) {
                    try {
                        Slice slice = null;
                        while ((slice = (Slice)this.committed.first()) != null && !(this.flushPendingCompletion = !slice.send(this.asyncFlushContext))) {
                            slice.unlink();
                            slice.checkAndDispose();
                        }
                        if (this.committed.count() != 0) break block9;
                        try {
                            MessageBusBinding.FlushContext usedFlushContext = EmxThread.dispatcher.get() != null ? this.asyncFlushContext.reset() : null;
                            AepBusManager.this.binding.flush(usedFlushContext);
                            if (usedFlushContext == null) {
                                this.asyncFlushContext.syncComplete = true;
                            }
                            if (this.asyncFlushContext.syncComplete) {
                                ++((AepBusManager)AepBusManager.this).stats.numFlushesSync;
                                ((AepBusManager)AepBusManager.this).stats.numMsgsFlushedSync += (long)this.msgsSentSinceLastFlush;
                                this.msgsSentSinceLastFlush = 0;
                            } else {
                                ++((AepBusManager)AepBusManager.this).stats.numFlushesAsync;
                                ((AepBusManager)AepBusManager.this).stats.numMsgsFlushedAsync += (long)this.msgsSentSinceLastFlush;
                                this.msgsSentSinceLastFlush = 0;
                                this.flushPendingCompletion = true;
                            }
                        }
                        catch (SmaException e) {
                            AepBusManager.this.tracer.log(AepBusManager.this.tracePrefix + " " + Thread.currentThread().getId() + ": Failed to flush binding '" + AepBusManager.this.binding.getName() + "' (sync flush failure) [" + e.toString() + "]", Tracer.Level.WARNING);
                            throw e;
                        }
                    }
                    catch (SmaException smaException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void commit(Slice completed) {
            MessageBusBinding.AsynchronousFlushContext asynchronousFlushContext = this.asyncFlushContext;
            synchronized (asynchronousFlushContext) {
                this.committed.append((UtlListElement)completed);
                if (!this.flushPendingCompletion) {
                    if (((AepBusManager)AepBusManager.this).tracer.debug) {
                        AepBusManager.this.tracer.log(AepBusManager.this.tracePrefix + " Sending committed...", Tracer.Level.DEBUG);
                    }
                    this.sendCommitted();
                } else if (((AepBusManager)AepBusManager.this).tracer.debug) {
                    AepBusManager.this.tracer.log(AepBusManager.this.tracePrefix + " Send of committed delayed since flush is pending completion.", Tracer.Level.DEBUG);
                }
            }
        }

        final void open() {
            if (this.detachedCommit) {
                this.writerThread = new WriterThread("X-AEP-BusManager-IO-" + AepBusManager.this.name, this.batchProcessor);
                this.writerThread.start();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        final void enque(MessageChannel channel, IRogMessage message) {
            if (message.getMessageBusAsRaw() == null) {
                message.setMessageBusAsRaw(channel.getMessageBusBinding().getNameAsRaw());
            }
            if (message.getMessageChannelAsRaw() == null) {
                message.setMessageChannelAsRaw(channel.getNameAsRaw());
            }
            SliceElement sliceElement = ((SliceElement)this.sliceElementPool.get(null)).init(this.uncommitted, channel, message, this.currentSavepoint);
            if (message.getIsPriority()) {
                this.uncommitted.priorityAppend(sliceElement);
            } else {
                this.uncommitted.append(sliceElement);
            }
        }

        final Slice complete() {
            Slice completed = this.uncommitted;
            this.uncommitted = ((Slice)this.slicePool.get(null)).reset();
            this.currentSavepoint = 0;
            return completed;
        }

        final void commit(Slice slice, AepSendCommitCompletionEvent event, long sendTs) {
            ++((AepBusManager)AepBusManager.this).stats.numCommits;
            Slice completed = (slice != null ? slice : this.complete()).setCommitCompletionEvent(event).setSendTs(sendTs);
            if (((AepBusManager)AepBusManager.this).tracer.debug) {
                if (slice == null) {
                    AepBusManager.this.tracer.log(AepBusManager.this.tracePrefix + " Committing uncommitted queue (size=" + completed.elements.count() + ")...", Tracer.Level.DEBUG);
                } else {
                    AepBusManager.this.tracer.log(AepBusManager.this.tracePrefix + " Committing completed queue (size=" + completed.elements.count() + ")...", Tracer.Level.DEBUG);
                }
            }
            if (this.detachedCommit) {
                long sequence = this.ringBuffer.next();
                CarrierEvent carrierEvent = (CarrierEvent)this.ringBuffer.get(sequence);
                carrierEvent.type = 1;
                carrierEvent.completed = completed;
                carrierEvent.publishTs = UtlTime.now();
                this.ringBuffer.publish(sequence);
            } else {
                this.commit(completed);
            }
        }

        final void setCurrentSavepoint(int savepoint) {
            if (savepoint < 0) {
                throw new IllegalArgumentException("Bus manager savepoints must be greater than or equal to 0");
            }
            if (savepoint < this.currentSavepoint) {
                throw new IllegalArgumentException("Bus manager savepoint cannot be set lower than current savepoint (cur=" + this.currentSavepoint + ", new=" + savepoint);
            }
            this.currentSavepoint = savepoint;
        }

        final void rollback() {
            this.rollback(-1);
        }

        final void rollback(int savepoint) {
            if (savepoint < 0) {
                ++((AepBusManager)AepBusManager.this).stats.numRollbacks;
                this.uncommitted.clear();
                this.currentSavepoint = 0;
            } else if (savepoint >= this.currentSavepoint) {
                ++((AepBusManager)AepBusManager.this).stats.numPartialRollbacks;
                this.uncommitted.rollback(savepoint);
                this.currentSavepoint = savepoint;
            } else {
                throw new IllegalArgumentException("Invalid rollback savepoint '" + savepoint + "' (current savepoint is '" + this.currentSavepoint + "')");
            }
        }

        final boolean isDetachedCommit() {
            return this.detachedCommit;
        }

        final int getDisruptorCapacity() {
            return this.detachedCommit ? this.ringBuffer.getBufferSize() : 0;
        }

        final int getDisruptorRemaining() {
            return this.detachedCommit ? (int)this.ringBuffer.remainingCapacity() : 0;
        }

        final String getDisruptorClaimStrategy() {
            return this.claimStrategyStr;
        }

        final String getDisruptorWaitStrategy() {
            return this.waitStrategyStr;
        }

        final void onFlushCompletion(MessageBusBinding.AsynchronousFlushContext flushContext) {
            ++((AepBusManager)AepBusManager.this).stats.numAsyncFlushCompletions;
            if (flushContext.status == null) {
                this.flushPendingCompletion = false;
                IEmxDispatcher dispatcher = (IEmxDispatcher)EmxThread.dispatcher.get();
                if (dispatcher != null) {
                    // empty if block
                }
                dispatcher.schedUserEv(EmxFactory.getInstance().createUserEvent(EmxFactory.EmxImpl.DEFAULT, (IEmxEventHandler)this));
            } else {
                AepBusManager.this.tracer.log(AepBusManager.this.tracePrefix + " Failed to flush binding '" + AepBusManager.this.binding.getName() + "' (async flush failure) [" + flushContext.status.toString() + "]", Tracer.Level.WARNING);
            }
        }

        final void close() {
            if (this.detachedCommit && this.writerThread != null) {
                while (this.writerThread.isAlive()) {
                    try {
                        this.batchProcessor.halt();
                        this.writerThread.join();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                UtlThread.deregister((Thread)this.writerThread);
            }
            this.slicePool.close();
            this.sliceElementPool.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
            MessageBusBinding.AsynchronousFlushContext asynchronousFlushContext = this.asyncFlushContext;
            synchronized (asynchronousFlushContext) {
                if (!this.flushPendingCompletion) {
                    this.sendCommitted();
                }
            }
            return false;
        }

        private final class WriterThread
        extends Thread {
            WriterThread(String name, BatchEventProcessor<CarrierEvent> batchProcessor) {
                super((Runnable)batchProcessor);
                this.setDaemon(true);
                this.setName(name);
            }

            @Override
            public final void run() {
                if (OutboundQueue.this.writerCpuAffinityMask != 0L) {
                    UtlThread.setCPUAffinityMask((long)OutboundQueue.this.writerCpuAffinityMask);
                } else {
                    UtlThread.setDefaultCPUAffinityMask();
                }
                try {
                    super.run();
                }
                catch (RuntimeException thrown) {
                    AepBusManager.this.tracer.log(AepBusManager.this.tracePrefix + "Uncaught bus manager writer event loop exception: " + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.SEVERE);
                    throw thrown;
                }
                catch (Error thrown) {
                    AepBusManager.this.tracer.log(AepBusManager.this.tracePrefix + "Uncaught bus manager writer event loop error: " + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.SEVERE);
                    throw thrown;
                }
            }
        }

        private final class CarrierEventProcessor
        implements EventHandler<CarrierEvent> {
            private CarrierEventProcessor() {
            }

            public final void onEvent(CarrierEvent event, long sequence, boolean endOfBatch) throws Exception {
                ((AepBusManager)AepBusManager.this).stats.o2p.add((double)(UtlTime.now() - event.publishTs));
                switch (event.type) {
                    case 1: {
                        OutboundQueue.this.commit(event.completed);
                    }
                }
            }
        }

        private final class CarrierEvent {
            static final int COMMIT = 1;
            long publishTs;
            int type;
            Slice completed;

            private CarrierEvent() {
            }
        }

        final class SliceFactory
        implements UtlPool.Factory<Slice> {
            SliceFactory() {
            }

            public final Slice createItem(Object object) {
                return new Slice();
            }

            public final Slice[] createItemArray(int size) {
                return new Slice[size];
            }
        }

        final class Slice
        extends UtlListElement
        implements UtlPool.Item<Slice> {
            private final UtlList elements = UtlList.create();
            private SliceElement priorityTail;
            private UtlPool<Slice> pool;
            private int numPendingStability;
            private long sendTs;
            private AepSendCommitCompletionEvent commitCompletionEvent;
            private AtomicBoolean disposed = new AtomicBoolean();

            Slice() {
            }

            final Slice reset() {
                this.priorityTail = null;
                this.numPendingStability = 0;
                this.commitCompletionEvent = null;
                this.disposed.set(false);
                return this;
            }

            final void append(SliceElement element) {
                this.elements.append((UtlListElement)element);
                ++this.numPendingStability;
            }

            final void priorityAppend(SliceElement element) {
                if (this.priorityTail == null) {
                    this.elements.prepend((UtlListElement)element);
                    this.priorityTail = element;
                } else {
                    this.priorityTail.insertAfter(element);
                    this.priorityTail = element;
                }
                ++this.numPendingStability;
            }

            final void rollback(int savepoint) {
                SliceElement element = (SliceElement)this.elements.last();
                while (element != null) {
                    SliceElement prev = (SliceElement)element.previous();
                    if (element.savepoint < savepoint) {
                        if (this.priorityTail == null || this.priorityTail.savepoint < savepoint) break;
                        element = this.priorityTail;
                        continue;
                    }
                    if (element == this.priorityTail) {
                        this.priorityTail = prev != null && prev.message.getIsPriority() ? prev : null;
                    }
                    if (((AepBusManager)AepBusManager.this).msgTracer.debug) {
                        AepBusManager.this.engine.msgTrace("[MSG-OUT-ROLLBACK]", (IRogNode)element.message);
                    }
                    --this.numPendingStability;
                    element.unlink();
                    element.dispose();
                    element = prev;
                }
            }

            final void prepend(SliceElement element) {
                this.elements.prepend((UtlListElement)element);
                ++this.numPendingStability;
            }

            final UtlList elements() {
                return this.elements;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            final boolean send(MessageBusBinding.AsynchronousFlushContext flushContext) throws SmaException {
                SliceElement element = null;
                while ((element = (SliceElement)this.elements.first()) != null) {
                    element.unlink();
                    if (element == this.priorityTail) {
                        this.priorityTail = null;
                    }
                    MessageChannel channel = element.channel;
                    IRogMessage message = element.message;
                    boolean stabilityEventDispatched = false;
                    try {
                        element.acquire();
                        try {
                            if (!message.getIsInternal()) {
                                if (this.sendTs > 0L) {
                                    if (message.getSendTs() == 0L) {
                                        message.setSendTs(this.sendTs);
                                    }
                                    if (message.getSendStartTs() == 0L) {
                                        message.setSendStartTs(UtlTime.now());
                                    }
                                }
                                MessageWaypointListenerRegistry.dispatch((MessageWaypointListener.Waypoint)MessageWaypointListener.Waypoint.o, (MessageWaypointListener.MessagingDirection)MessageWaypointListener.MessagingDirection.Outbound, (Object)message);
                                message.setTag(2, (Object)element);
                                MessageBusBinding.FlushContext usedFlushContext = EmxThread.dispatcher.get() != null ? flushContext.reset() : null;
                                int flags = 60;
                                if (message.getMessageReflector() != null && message.getMessageReflector().needsSync()) {
                                    flags |= 2;
                                }
                                boolean flushed = channel.sendMessage((MessageView)message, usedFlushContext, flags);
                                if (((AepBusManager)AepBusManager.this).msgTracer.debug) {
                                    AepBusManager.this.engine.msgTrace("[MSG-OUT]", (IRogNode)message);
                                }
                                if (flushed && usedFlushContext == null) {
                                    flushContext.syncComplete = true;
                                }
                                if (this.commitCompletionEvent != null) {
                                    this.commitCompletionEvent.onMessageSend(message);
                                }
                                ++((AepBusManager)AepBusManager.this).stats.numMsgsSent;
                                OutboundQueue.this.msgsSentSinceLastFlush++;
                                if (flushed) {
                                    if (flushContext.syncComplete) {
                                        ++((AepBusManager)AepBusManager.this).stats.numFlushesSync;
                                        ((AepBusManager)AepBusManager.this).stats.numMsgsFlushedSync += (long)OutboundQueue.this.msgsSentSinceLastFlush;
                                        OutboundQueue.this.msgsSentSinceLastFlush = 0;
                                    } else {
                                        ++((AepBusManager)AepBusManager.this).stats.numFlushesAsync;
                                        ((AepBusManager)AepBusManager.this).stats.numMsgsFlushedAsync += (long)OutboundQueue.this.msgsSentSinceLastFlush;
                                        OutboundQueue.this.msgsSentSinceLastFlush = 0;
                                    }
                                }
                                if (channel.getQos() == MessageChannel.Qos.BestEffort) {
                                    this.onStability(element, null);
                                    stabilityEventDispatched = true;
                                }
                                if (!flushed || flushContext.syncComplete) continue;
                                boolean bl = false;
                                return bl;
                            }
                            this.onStability(element, null);
                            stabilityEventDispatched = true;
                        }
                        finally {
                            element.dispose();
                        }
                    }
                    catch (Throwable e) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("Failed to send message through channel '" + channel.getName() + "' [" + e.toString() + "].\n");
                        sb.append("Stack trace:\n");
                        sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                        try {
                            sb.append("Message:\n");
                            sb.append(message.metadataToString()).append("\n");
                            sb.append(message.toString()).append("\n");
                            Exception status = null;
                            switch (AepBusManager.this.engine.getMessageSendExceptionHandlingPolicy()) {
                                case LogExceptionAndContinue: {
                                    sb.append("Logging exception and continuing...\n");
                                    try {
                                        Event[] inboundEvents;
                                        AepEngine.Transaction.CommitContext context;
                                        SmaException sendException = new SmaException("Send commit exception: " + e.getMessage(), e);
                                        AepSendExceptionEvent sendExceptionEvent = AepSendExceptionEvent.create(AepBusManager.this.getBusBinding(), channel, (MessageView)message, (Exception)sendException);
                                        if (this.commitCompletionEvent != null && (context = (AepEngine.Transaction.CommitContext)this.commitCompletionEvent.getAttachment()) != null && (inboundEvents = context.getInboundEvents()) != null) {
                                            for (int i = 0; i < inboundEvents.length; ++i) {
                                                Event event = inboundEvents[i];
                                                if (event instanceof MessageEvent) {
                                                    MessageView sourceMessage = ((MessageEvent)event).getMessageView();
                                                    if (!(sourceMessage instanceof IRogMessage) || ((IRogMessage)sourceMessage).getTransactionInSequenceNumber() != message.getTransactionInSequenceNumber()) continue;
                                                    sendExceptionEvent.setTriggeringMessage(sourceMessage);
                                                    continue;
                                                }
                                                if (!(event instanceof AepSendEvent) || ((AepSendEvent)event).getMessage() != message) continue;
                                                AepSendEvent.Acknowledger acknowledger = (AepSendEvent.Acknowledger)((AepSendEvent)event).getAcknowledger();
                                                acknowledger.setStatus((Exception)sendException);
                                            }
                                        }
                                        AepBusManager.this.onEvent((Event)sendExceptionEvent);
                                    }
                                    catch (Throwable throwable) {}
                                    break;
                                }
                                case TreatAsStabilityFailure: {
                                    sb.append("Converting to stability failure...\n");
                                    status = e instanceof Error ? new Exception(e) : (Exception)e;
                                    break;
                                }
                            }
                            if (stabilityEventDispatched) continue;
                            this.onStability(element, MessageStabilityEvent.create((MessageBusBinding)AepBusManager.this.getBusBinding(), (MessageChannel)channel, (MessageView)message, (Exception)status));
                        }
                        finally {
                            if (channel.getState() == MessageChannel.State.Open) {
                                AepBusManager.this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
                                continue;
                            }
                            if (!((AepBusManager)AepBusManager.this).tracer.fine) continue;
                            AepBusManager.this.tracer.log(AepBusManager.this.tracePrefix + "Failed to send message (channel '" + channel.getName() + " is in state " + channel.getState() + ")", Tracer.Level.FINE);
                        }
                    }
                }
                return true;
            }

            final Slice setSendTs(long ts) {
                this.sendTs = ts;
                return this;
            }

            final Slice setCommitCompletionEvent(AepSendCommitCompletionEvent event) {
                this.commitCompletionEvent = event;
                return this;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            final void onStability(SliceElement element, MessageStabilityEvent stabilityEvent) {
                boolean complete;
                Slice slice = this;
                synchronized (slice) {
                    if (this.commitCompletionEvent != null) {
                        this.commitCompletionEvent.onMessageStability(stabilityEvent);
                    }
                    complete = --this.numPendingStability == 0;
                }
                element.dispose();
                if (complete) {
                    this.checkAndDispose();
                }
            }

            final void clear() {
                this.elements.clear();
                this.numPendingStability = 0;
                this.priorityTail = null;
            }

            final void checkAndDispose() {
                if (!this.disposed.get() && this.numPendingStability == 0 && !this.isLinked() && this.disposed.compareAndSet(false, true)) {
                    if (this.commitCompletionEvent != null) {
                        AepBusManager.this.dispatchToMultiplexer(this.commitCompletionEvent);
                    }
                    if (this.pool != null) {
                        this.pool.put((UtlPool.Item)this);
                    }
                }
            }

            public final Slice init() {
                if (this.elements.count() != 0) {
                    throw new InternalError("slice element count is non-zero on dispose!");
                }
                return this;
            }

            public final Slice setPool(UtlPool<Slice> pool) {
                this.pool = pool;
                return this;
            }

            public final UtlPool<Slice> getPool() {
                return this.pool;
            }
        }

        final class SliceElementFactory
        implements UtlPool.Factory<SliceElement> {
            SliceElementFactory() {
            }

            public final SliceElement createItem(Object object) {
                return new SliceElement();
            }

            public final SliceElement[] createItemArray(int size) {
                return new SliceElement[size];
            }
        }

        final class SliceElement
        extends UtlListElement
        implements UtlPool.Item<SliceElement> {
            private UtlPool<SliceElement> pool;
            private int refcount;
            Slice slice;
            MessageChannel channel;
            IRogMessage message;
            int savepoint;

            SliceElement() {
            }

            final SliceElement init(Slice slice, MessageChannel channel, IRogMessage message, int savepoint) {
                this.slice = slice;
                this.channel = channel;
                this.message = message;
                if (this.message != null) {
                    message.acquire();
                }
                this.refcount = 1;
                this.savepoint = savepoint;
                return this;
            }

            final void acquire() {
                ++this.refcount;
            }

            final void dispose() {
                if (this.refcount == 0) {
                    throw new InternalError("attempt to dispose an already disposed slice element!");
                }
                if (--this.refcount == 0) {
                    if (this.message != null) {
                        this.message.dispose();
                        this.message = null;
                    }
                    if (this.pool != null) {
                        this.pool.put((UtlPool.Item)this);
                    }
                }
            }

            public final SliceElement init() {
                this.slice = null;
                this.channel = null;
                this.savepoint = 0;
                return this;
            }

            public final SliceElement setPool(UtlPool<SliceElement> pool) {
                this.pool = pool;
                return this;
            }

            public final UtlPool<SliceElement> getPool() {
                return this.pool;
            }
        }
    }

    private final class BindingOpener
    extends Thread
    implements IEmxDispatcherRunCompletionChecker {
        private final IEmxDispatcher dispatcher;
        private final OpenStartEventHandler openStartEventHandler;
        private final OpenRetryEventHandler openRetryEventHandler;
        private final ShutdownEventHandler shutdownEventHandler;
        private IEmxAlarmEvent openRetryAlarmEvent;
        private boolean done;
        private boolean ready;

        BindingOpener() throws Exception {
            this.setName("X-AEP-BusManager-BindingOpener-" + AepBusManager.this.name);
            this.shutdownEventHandler = new ShutdownEventHandler();
            this.openStartEventHandler = new OpenStartEventHandler();
            this.openRetryEventHandler = new OpenRetryEventHandler();
            this.dispatcher = EmxFactory.getInstance().createDispatcher(EmxFactory.EmxImpl.DEFAULT, this.getName(), IEmxDispatcher.Params.create((boolean)false, (boolean)true));
        }

        final void scheduleOpen() throws EEmxException {
            this.dispatcher.schedUserEv(EmxFactory.getInstance().createUserEvent(EmxFactory.EmxImpl.DEFAULT, (IEmxEventHandler)this.openStartEventHandler));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void start() {
            super.start();
            BindingOpener bindingOpener = this;
            synchronized (bindingOpener) {
                while (!this.ready) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            UtlThread.setDefaultCPUAffinityMask();
            this.dispatcher.setOwner();
            BindingOpener bindingOpener = this;
            synchronized (bindingOpener) {
                this.ready = true;
                this.notifyAll();
            }
            try {
                this.dispatcher.run(-1, (IEmxDispatcherRunCompletionChecker)this);
            }
            catch (EEmxTimeoutException e) {
                throw new InternalError("Received a timeout exception from dispatcher when timeout was specified as -1!");
            }
            catch (Exception e) {
                AepBusManager.this.tracer.log(AepBusManager.this.tracePrefix + " Failure encountered in binding opener thread dispatch loop [" + e.toString() + "]. Shutting down thread.", Tracer.Level.SEVERE);
            }
            if (this.openRetryAlarmEvent != null) {
                this.dispatcher.unschedAlarmEv(this.openRetryAlarmEvent);
            }
            try {
                this.dispatcher.close(false);
            }
            catch (EEmxException e) {
                AepBusManager.this.tracer.log(AepBusManager.this.tracePrefix + " Failure encountered while closing the binding opener dispatcher [" + e.toString() + "]. Ignoring...", Tracer.Level.WARNING);
            }
        }

        public final boolean isDone() {
            return this.done;
        }

        public final Object getCompletion() {
            return null;
        }

        final void shutdown() {
            this.done = true;
            this.dispatcher.schedUserEv(EmxFactory.getInstance().createUserEvent(EmxFactory.EmxImpl.DEFAULT, (IEmxEventHandler)this.shutdownEventHandler));
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private final class ShutdownEventHandler
        implements IEmxEventHandler {
            private ShutdownEventHandler() {
            }

            public final boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
                return false;
            }
        }

        private final class OpenRetryEventHandler
        implements IEmxEventHandler {
            private OpenRetryEventHandler() {
            }

            public final boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
                if (null == AepBusManager.this.openCore(true)) {
                    BindingOpener.this.openRetryAlarmEvent = null;
                    return false;
                }
                return true;
            }
        }

        private final class OpenStartEventHandler
        implements IEmxEventHandler {
            private OpenStartEventHandler() {
            }

            public final boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
                if (null != AepBusManager.this.openCore(true)) {
                    dispatcher.schedAlarmEv(BindingOpener.this.openRetryAlarmEvent = EmxFactory.getInstance().createAlarmEvent(EmxFactory.EmxImpl.DEFAULT, (IEmxEventHandler)BindingOpener.this.openRetryEventHandler, 5000));
                }
                return false;
            }
        }
    }

    public static enum State {
        CREATED,
        OPENING,
        OPEN,
        STARTED,
        FAILED,
        CLOSED;

    }
}

