/*
 * Decompiled with CFR 0.152.
 */
package vanilla.java.affinity;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import vanilla.java.affinity.AffinityStrategies;
import vanilla.java.affinity.AffinityStrategy;
import vanilla.java.affinity.AffinitySupport;
import vanilla.java.affinity.CpuLayout;
import vanilla.java.affinity.impl.NoCpuLayout;
import vanilla.java.affinity.impl.VanillaCpuLayout;

public class AffinityLock {
    private static final Logger LOGGER = Logger.getLogger(AffinityLock.class.getName());
    public static final String AFFINITY_RESERVED = "affinity.reserved";
    public static final int PROCESSORS = Runtime.getRuntime().availableProcessors();
    public static final long BASE_AFFINITY = AffinitySupport.getAffinity();
    public static final long RESERVED_AFFINITY = AffinityLock.getReservedAffinity0();
    private static AffinityLock[] LOCKS;
    private static NavigableMap<Integer, AffinityLock[]> CORES;
    private static final AffinityLock NONE;
    private static CpuLayout cpuLayout;
    private final int cpuId;
    private final boolean base;
    private final boolean reservable;
    boolean bound = false;
    Thread assignedThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cpuLayout(CpuLayout cpuLayout) {
        Class<AffinityLock> clazz = AffinityLock.class;
        synchronized (AffinityLock.class) {
            if (cpuLayout.equals(AffinityLock.cpuLayout)) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            AffinityLock.cpuLayout = cpuLayout;
            LOCKS = new AffinityLock[cpuLayout.cpus()];
            int threads = cpuLayout.threadsPerCore();
            CORES = new TreeMap<Integer, AffinityLock[]>();
            for (int i = 0; i < cpuLayout.cpus(); ++i) {
                boolean base1 = (BASE_AFFINITY >> i & 1L) != 0L;
                boolean reservable1 = (RESERVED_AFFINITY >> i & 1L) != 0L;
                LOGGER.log(Level.INFO, "cpu " + i + " base= " + base1 + " reservable= " + reservable1);
                AffinityLock al = AffinityLock.LOCKS[i] = new AffinityLock(i, base1, reservable1);
                int layoutId = al.cpuId;
                int logicalCpuId = AffinityLock.coreForId(layoutId);
                AffinityLock[] als = (AffinityLock[])CORES.get(logicalCpuId);
                if (als == null) {
                    als = new AffinityLock[threads];
                    CORES.put(logicalCpuId, als);
                }
                als[cpuLayout.threadId((int)layoutId)] = al;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static int coreForId(int id) {
        return cpuLayout.socketId(id) * cpuLayout.coresPerSocket() + cpuLayout.coreId(id);
    }

    public static CpuLayout cpuLayout() {
        return cpuLayout;
    }

    private static long getReservedAffinity0() {
        String reservedAffinity = System.getProperty(AFFINITY_RESERVED);
        if (reservedAffinity == null || reservedAffinity.trim().isEmpty()) {
            long reserverable = (long)((1 << PROCESSORS) - 1) ^ BASE_AFFINITY;
            if (reserverable == 0L && PROCESSORS > 1) {
                LOGGER.log(Level.INFO, "No isolated CPUs found, so assuming CPUs 1 to " + (PROCESSORS - 1) + " available.");
                return (1 << PROCESSORS) - 2;
            }
            return reserverable;
        }
        return Long.parseLong(reservedAffinity, 16);
    }

    public static AffinityLock acquireLock() {
        return AffinityLock.acquireLock(true);
    }

    public static AffinityLock acquireCore() {
        return AffinityLock.acquireCore(true);
    }

    public static AffinityLock acquireLock(boolean bind) {
        return AffinityLock.acquireLock(bind, -1, AffinityStrategies.ANY);
    }

    public static AffinityLock acquireCore(boolean bind) {
        return AffinityLock.acquireCore(bind, -1, AffinityStrategies.ANY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AffinityLock acquireLock(boolean bind, int cpuId, AffinityStrategy ... strategies) {
        Class<AffinityLock> clazz = AffinityLock.class;
        synchronized (AffinityLock.class) {
            for (AffinityStrategy strategy : strategies) {
                for (int i = PROCESSORS - 1; i > 0; --i) {
                    AffinityLock al = LOCKS[i];
                    if (!al.canReserve() || cpuId >= 0 && !strategy.matches(cpuId, al.cpuId)) continue;
                    al.assignCurrentThread(bind, false);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return al;
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("No reservable CPU for " + Thread.currentThread());
            }
            return NONE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AffinityLock acquireCore(boolean bind, int cpuId, AffinityStrategy ... strategies) {
        Class<AffinityLock> clazz = AffinityLock.class;
        synchronized (AffinityLock.class) {
            for (AffinityStrategy strategy : strategies) {
                Iterator i$ = CORES.descendingMap().values().iterator();
                block4: while (i$.hasNext()) {
                    AffinityLock[] als;
                    for (AffinityLock al : als = (AffinityLock[])i$.next()) {
                        if (!al.canReserve() || !strategy.matches(cpuId, al.cpuId)) continue block4;
                    }
                    AffinityLock al = als[0];
                    al.assignCurrentThread(bind, true);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return al;
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("No reservable Core for " + Thread.currentThread());
            }
            return AffinityLock.acquireLock(bind, cpuId, strategies);
        }
    }

    public static String dumpLocks() {
        return AffinityLock.dumpLocks0(LOCKS);
    }

    static String dumpLocks0(AffinityLock[] locks) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < locks.length; ++i) {
            AffinityLock al = locks[i];
            sb.append(i).append(": ");
            if (al.assignedThread != null) {
                sb.append(al.assignedThread).append(" alive=").append(al.assignedThread.isAlive());
            } else if (al.reservable) {
                sb.append("Reserved for this application");
            } else if (al.base) {
                sb.append("General use CPU");
            } else {
                sb.append("CPU not available");
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    AffinityLock(int cpuId, boolean base, boolean reservable) {
        this.cpuId = cpuId;
        this.base = base;
        this.reservable = reservable;
    }

    private void assignCurrentThread(boolean bind, boolean wholeCore) {
        this.assignedThread = Thread.currentThread();
        if (bind) {
            this.bind(wholeCore);
        }
    }

    public void bind() {
        this.bind(false);
    }

    public void bind(boolean wholeCore) {
        if (this.bound && this.assignedThread != null && this.assignedThread.isAlive()) {
            throw new IllegalStateException("cpu " + this.cpuId + " already bound to " + this.assignedThread);
        }
        if (wholeCore) {
            int core = AffinityLock.coreForId(this.cpuId);
            for (AffinityLock al : (AffinityLock[])CORES.get(core)) {
                if (this.bound && al.assignedThread != null && al.assignedThread.isAlive()) {
                    LOGGER.severe("cpu " + al.cpuId + " already bound to " + al.assignedThread);
                    continue;
                }
                al.bound = true;
                al.assignedThread = Thread.currentThread();
            }
            if (LOGGER.isLoggable(Level.INFO)) {
                StringBuilder sb = new StringBuilder().append("Assigning core ").append(core);
                String sep = ": cpus ";
                for (AffinityLock al : (AffinityLock[])CORES.get(core)) {
                    sb.append(sep).append(al.cpuId);
                    sep = ", ";
                }
                sb.append(" to ").append(this.assignedThread);
                LOGGER.info(sb.toString());
            }
        } else {
            this.bound = true;
            this.assignedThread = Thread.currentThread();
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Assigning cpu " + this.cpuId + " to " + this.assignedThread);
            }
        }
        if (this.cpuId >= 0) {
            AffinitySupport.setAffinity(1L << this.cpuId);
        }
    }

    private boolean canReserve() {
        if (!this.reservable) {
            return false;
        }
        if (this.assignedThread != null) {
            if (this.assignedThread.isAlive()) {
                return false;
            }
            LOGGER.severe("Lock assigned to " + this.assignedThread + " but this thread is dead.");
        }
        return true;
    }

    public AffinityLock acquireLock(AffinityStrategy ... strategies) {
        return AffinityLock.acquireLock(false, this.cpuId, strategies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Thread t = Thread.currentThread();
        Class<AffinityLock> clazz = AffinityLock.class;
        synchronized (AffinityLock.class) {
            for (AffinityLock al : LOCKS) {
                Thread at = al.assignedThread;
                if (at == t) {
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.info("Releasing cpu " + al.cpuId + " from " + t);
                    }
                    al.assignedThread = null;
                    al.bound = false;
                    continue;
                }
                if (at == null || at.isAlive()) continue;
                LOGGER.warning("Releasing cpu " + al.cpuId + " from " + t + " as it is not alive.");
                al.assignedThread = null;
                al.bound = false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            AffinitySupport.setAffinity(BASE_AFFINITY);
            return;
        }
    }

    protected void finalize() throws Throwable {
        if (this.reservable) {
            LOGGER.warning("Affinity lock for " + this.assignedThread + " was discarded rather than release()d in a controlled manner.");
            this.release();
        }
        super.finalize();
    }

    public int cpuId() {
        return this.cpuId;
    }

    static {
        NONE = new AffinityLock(-1, false, false);
        cpuLayout = new NoCpuLayout(PROCESSORS);
        try {
            if (new File("/proc/cpuinfo").exists()) {
                AffinityLock.cpuLayout(VanillaCpuLayout.fromCpuInfo());
            } else {
                LOCKS = new AffinityLock[PROCESSORS];
                for (int i = 0; i < PROCESSORS; ++i) {
                    AffinityLock.LOCKS[i] = new AffinityLock(i, (BASE_AFFINITY >> i & 1L) != 0L, (RESERVED_AFFINITY >> i & 1L) != 0L);
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Unable to load /proc/cpuinfo", e);
        }
    }
}

