/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto.test.unit;

import com.neeve.sto.StoField;
import com.neeve.sto.StoIntField;
import com.neeve.test.UnitTest;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;

public final class StoIntFieldTest
extends UnitTest {
    private final void validate(StoIntField field, String name, ByteBuffer buffer, int val) {
        if (name == null) {
            Assert.assertNull((Object)field.getName());
        } else {
            Assert.assertEquals((Object)field.getName(), (Object)name);
        }
        if (buffer == null) {
            Assert.assertNull((Object)field.getBackingBuffer());
        } else {
            Assert.assertSame((Object)field.getBackingBuffer(), (Object)buffer);
        }
        Assert.assertEquals((Object)((Object)StoField.Type.INTEGER), (Object)((Object)field.getType()));
        Assert.assertEquals((long)field.getValue(), (long)val);
    }

    private final void cloneAndValidate(StoIntField field, String name, int val) {
        StoIntField clone = (StoIntField)field.clone();
        Assert.assertNotSame((Object)clone, (Object)field);
        this.validate(clone, name, null, val);
        Assert.assertTrue((boolean)field.contentsEquals(clone));
    }

    private final void validate(ByteBuffer buffer, int pos, int limit, int capacity) {
        Assert.assertEquals((long)buffer.position(), (long)pos);
        Assert.assertEquals((long)buffer.limit(), (long)limit);
        Assert.assertEquals((long)buffer.capacity(), (long)capacity);
    }

    @Test
    public void testStaticMethods() throws Exception {
        Assert.assertEquals((long)StoIntField.getSerializedLength(null, 0), (long)4L);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        StoIntField.put(buffer, 5, 128906);
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((long)StoIntField.get(buffer, 5), (long)128906L);
        this.validate(buffer, 0, 100, 100);
        StoIntField.put(buffer, 5, 875891);
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((long)StoIntField.get(buffer, 5), (long)875891L);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullName() throws Exception {
        StoIntField field = StoIntField.create(null);
        this.validate(field, null, null, 0);
        this.cloneAndValidate(field, null, 0);
    }

    @Test
    public void testCreateWithNonNullName() throws Exception {
        StoIntField field = StoIntField.create("name");
        this.validate(field, "name", null, 0);
        this.cloneAndValidate(field, "name", 0);
    }

    @Test
    public void testIsVariableLength() throws Exception {
        Assert.assertFalse((boolean)StoIntField.create(null).isVariableLength());
    }

    @Test
    public void testCreateWithNullNameSetValue() throws Exception {
        StoIntField field = StoIntField.create(null);
        field.setValue(128906);
        this.validate(field, null, null, 128906);
        this.cloneAndValidate(field, null, 128906);
    }

    @Test
    public void testCreateWithNonNullNameSetValue() throws Exception {
        StoIntField field = StoIntField.create("name");
        field.setValue(128906);
        this.validate(field, "name", null, 128906);
        this.cloneAndValidate(field, "name", 128906);
    }

    @Test
    public void testCreateWithNullNameBackByBuffer() throws Exception {
        StoIntField field = StoIntField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 5);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, buffer, 0);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, 0);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBuffer() throws Exception {
        StoIntField field = StoIntField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 9);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", buffer, 0);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", 0);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueBackByBuffer() throws Exception {
        StoIntField field = StoIntField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(128906);
        field.setBackingBuffer(buffer, 10);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, buffer, 128906);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, 128906);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueBackByBuffer() throws Exception {
        StoIntField field = StoIntField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(128906);
        field.setBackingBuffer(buffer, 12);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", buffer, 128906);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", 128906);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueBackByThenClearBuffer() throws Exception {
        StoIntField field = StoIntField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(128906);
        field.setBackingBuffer(buffer, 10);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field.getBackingBuffer());
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, 128906);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, 128906);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueBackByThenClearBuffer() throws Exception {
        StoIntField field = StoIntField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(128906);
        field.setBackingBuffer(buffer, 12);
        Assert.assertSame((Object)buffer, (Object)field.getBackingBuffer());
        this.validate(buffer, 0, 100, 100);
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, 128906);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", 128906);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameBackByBufferSetValue() throws Exception {
        StoIntField field = StoIntField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 22);
        this.validate(buffer, 0, 100, 100);
        field.setValue(128906);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, buffer, 128906);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, 128906);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBufferSetValue() throws Exception {
        StoIntField field = StoIntField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 31);
        this.validate(buffer, 0, 100, 100);
        field.setValue(128906);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", buffer, 128906);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", 128906);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameBackByBufferSetValueClearBuffer() throws Exception {
        StoIntField field = StoIntField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 22);
        this.validate(buffer, 0, 100, 100);
        field.setValue(128906);
        this.validate(buffer, 0, 100, 100);
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, 128906);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, 128906);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBufferSetValueClearBuffer() throws Exception {
        StoIntField field = StoIntField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 31);
        this.validate(buffer, 0, 100, 100);
        field.setValue(128906);
        this.validate(buffer, 0, 100, 100);
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, 128906);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", 128906);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueSync() throws Exception {
        StoIntField field = StoIntField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(128906);
        field.sync(buffer, 45);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, 128906);
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((long)StoIntField.get(buffer, field.shiftForHeader(45)), (long)128906L);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, 128906);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueSync() throws Exception {
        StoIntField field = StoIntField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(128906);
        field.sync(buffer, 52);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, 128906);
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((long)StoIntField.get(buffer, field.shiftForHeader(52)), (long)128906L);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", 128906);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserialize() throws Exception {
        StoIntField field1 = StoIntField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue(128906);
        field1.setBackingBuffer(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        StoIntField field2 = (StoIntField)StoField.create(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, 128906);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserialize() throws Exception {
        StoIntField field1 = StoIntField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue(128906);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoIntField field2 = (StoIntField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, "name", 128906);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserializeClearBuffer() throws Exception {
        StoIntField field1 = StoIntField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue(128906);
        field1.setBackingBuffer(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        StoIntField field2 = (StoIntField)StoField.create(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        field2.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        Assert.assertNull((Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, 128906);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserializeClearBuffer() throws Exception {
        StoIntField field1 = StoIntField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue(128906);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoIntField field2 = (StoIntField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        field2.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        Assert.assertNull((Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, "name", 128906);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserializeSetBuffer() throws Exception {
        StoIntField field1 = StoIntField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setValue(12319804);
        field1.setBackingBuffer(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        StoIntField field2 = (StoIntField)StoField.create(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.setBackingBuffer(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        StoIntField field3 = (StoIntField)StoField.create(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        this.validate(field3, null, buffer2, 12319804);
        Assert.assertSame((Object)buffer2, (Object)field3.getBackingBuffer());
        Assert.assertTrue((boolean)field3.contentsEquals(field2));
        this.validate(buffer2, 0, 100, 100);
        this.cloneAndValidate(field3, null, 12319804);
        this.validate(buffer2, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserializeSetBuffer() throws Exception {
        StoIntField field1 = StoIntField.create("name");
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setValue(3217682);
        field1.setBackingBuffer(buffer1, 26);
        this.validate(buffer1, 0, 100, 100);
        StoIntField field2 = (StoIntField)StoField.create(buffer1, 26);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.setBackingBuffer(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        StoIntField field3 = (StoIntField)StoField.create(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        this.validate(field3, "name", buffer2, 3217682);
        Assert.assertSame((Object)buffer2, (Object)field3.getBackingBuffer());
        Assert.assertTrue((boolean)field2.contentsEquals(field3));
        this.validate(buffer2, 0, 100, 100);
        this.cloneAndValidate(field3, "name", 3217682);
        this.validate(buffer2, 0, 100, 100);
    }

    @Test
    public void testCreateDeserialize() throws Exception {
        StoIntField field1 = StoIntField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoIntField field2 = (StoIntField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, 0);
        this.validate(buffer, 0, 100, 100);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateSetBackingBufferSync() throws Exception {
        StoIntField field1 = StoIntField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer1, 31);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field1.sync(buffer2, 65);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateDeserializeSync() throws Exception {
        StoIntField field1 = StoIntField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer1, 31);
        this.validate(buffer1, 0, 100, 100);
        StoIntField field2 = (StoIntField)StoField.create(buffer1, 31);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.sync(buffer2, 25);
    }

    @Test
    public void testContentsEqualsWithDifferentNamesFirstNonNull() throws Exception {
        Assert.assertFalse((boolean)StoIntField.create("name").contentsEquals(StoIntField.create(null)));
    }

    @Test
    public void testContentsEqualsWithDifferentNamesSecondNonNull() throws Exception {
        Assert.assertFalse((boolean)StoIntField.create(null).contentsEquals(StoIntField.create("name")));
    }

    @Test
    public void testContentsEqualsWithDifferentNamesBothNonNull() throws Exception {
        Assert.assertFalse((boolean)StoIntField.create("name1").contentsEquals(StoIntField.create("name2")));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesFirstNonNull() throws Exception {
        StoIntField field1 = StoIntField.create(null);
        StoIntField field2 = StoIntField.create(null);
        field1.setValue(100);
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesSecondNonNull() throws Exception {
        StoIntField field1 = StoIntField.create(null);
        StoIntField field2 = StoIntField.create(null);
        field2.setValue(100);
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesBothNonNullDiffContent() throws Exception {
        StoIntField field1 = StoIntField.create(null);
        StoIntField field2 = StoIntField.create(null);
        field1.setValue(67);
        field2.setValue(178);
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNullValuesDefault() throws Exception {
        StoIntField field1 = StoIntField.create(null);
        StoIntField field2 = StoIntField.create(null);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNonNullValuesDefault() throws Exception {
        StoIntField field1 = StoIntField.create("name");
        StoIntField field2 = StoIntField.create("name");
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNullValuesNonDefault() throws Exception {
        StoIntField field1 = StoIntField.create(null);
        StoIntField field2 = StoIntField.create(null);
        field1.setValue(42);
        field2.setValue(42);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNonNullValuesNonDefault() throws Exception {
        StoIntField field1 = StoIntField.create("name");
        StoIntField field2 = StoIntField.create("name");
        field1.setValue(66);
        field2.setValue(66);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }
}

