/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.solxf.impl.jcsmp;

import com.neeve.io.IOBuffer;
import com.neeve.lang.XString;
import com.neeve.sma.MessageLatencyManager;
import com.neeve.sma.MessageWaypointListener;
import com.neeve.sma.MessageWaypointListenerRegistry;
import com.neeve.sma.SmaException;
import com.neeve.sma.SmaObject;
import com.neeve.solxf.ISolMessageListener;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlBuffer;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlTime;
import com.solacesystems.jcsmp.BytesMessage;
import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPReconnectEventHandler;
import com.solacesystems.jcsmp.JCSMPSession;
import com.solacesystems.jcsmp.SDTMap;
import com.solacesystems.jcsmp.XMLMessageListener;
import java.nio.ByteBuffer;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public abstract class SolJcsmpMessageListener
extends SmaObject
implements XMLMessageListener,
JCSMPReconnectEventHandler {
    private final ISolMessageListener _listener;
    private final boolean _readPayloadFromXmlContent;
    private static final ConcurrentHashMap<Long, BytesXMLMessage> _tempMessageStore = new ConcurrentHashMap();

    public SolJcsmpMessageListener(JCSMPSession session, ISolMessageListener listener, Properties solxfProperties) {
        super(null);
        this._listener = listener;
        this._readPayloadFromXmlContent = UtlProps.getValue((Properties)solxfProperties, (String)"read_payload_from_xml_content", (boolean)false);
    }

    public final void onException(JCSMPException e) {
        this._listener.onSessionFailed((Exception)((Object)new SmaException((Throwable)e)));
    }

    public abstract void onReceive(BytesXMLMessage var1);

    protected final void onReceive(BytesXMLMessage message, boolean isGuaranteed) {
        long postWireTs = MessageLatencyManager.captureMsgLatencyStats ? UtlTime.now() : 0L;
        MessageWaypointListenerRegistry.dispatch((MessageWaypointListener.Waypoint)MessageWaypointListener.Waypoint.r, (MessageWaypointListener.MessagingDirection)MessageWaypointListener.MessagingDirection.Inbound, (Object)message);
        if (message instanceof BytesMessage) {
            if (isGuaranteed) {
                _tempMessageStore.put(message.getMessageIdLong(), message);
            }
            if (this.tracer.debug) {
                this.tracer.log("[SolJcsmpMessageListener] Received a bytes message on topic '" + message.getDestination().getName() + "'", Tracer.Level.DEBUG);
            }
            IOBuffer serializedMessage = null;
            IOBuffer serializedMetadata = null;
            XString topic = XString.create((String)message.getDestination().getName(), (boolean)true, (boolean)false);
            try {
                byte[] timestamps;
                byte[] serializedMessageBytes = ((BytesMessage)message).getData();
                if (serializedMessageBytes == null && this._readPayloadFromXmlContent) {
                    if (this.tracer.debug) {
                        this.tracer.log("[SolJcsmpMessageListener] Content not found in binary attachment ... checking in XML content...'", Tracer.Level.DEBUG);
                    }
                    if (message.getContentLength() > 0) {
                        serializedMessageBytes = new byte[message.getContentLength()];
                        int read = message.readContentBytes(serializedMessageBytes);
                        if (read != serializedMessageBytes.length) {
                            serializedMessageBytes = null;
                            this.tracer.log("[SolJcsmpMessageListener] Unable to read all xml content bytes expected " + serializedMessageBytes + " but read" + read, Tracer.Level.SEVERE);
                        }
                    } else {
                        this.tracer.log("[SolJcsmpMessageListener] XML content is 0 length'", Tracer.Level.WARNING);
                    }
                }
                if (serializedMessageBytes != null) {
                    serializedMessage = IOBuffer.create((int)serializedMessageBytes.length, (boolean)false);
                    UtlBuffer.copy((byte[])serializedMessageBytes, (int)0, (ByteBuffer)serializedMessage.getBufferUnsafe(), (int)0, (int)serializedMessageBytes.length);
                } else {
                    serializedMessage = IOBuffer.create((int)0, (boolean)false);
                }
                SDTMap props = message.getProperties();
                if (props != null) {
                    byte[] serializedMetadataBytes = props.getBytes("x-sma-metadata");
                    if (serializedMetadataBytes != null) {
                        serializedMetadata = IOBuffer.create((int)serializedMetadataBytes.length, (boolean)false);
                        UtlBuffer.copy((byte[])serializedMetadataBytes, (int)0, (ByteBuffer)serializedMetadata.getBufferUnsafe(), (int)0, (int)serializedMetadataBytes.length);
                    }
                } else {
                    Object serializedMetadataBytes = null;
                }
                long originTs = 0L;
                long preWireTs = 0L;
                byte[] byArray = timestamps = message.hasUserData() ? message.getUserData() : null;
                if (timestamps != null) {
                    originTs = UtlBuffer.readLong((byte[])timestamps, (int)0, (boolean)true);
                    preWireTs = UtlBuffer.readLong((byte[])timestamps, (int)8, (boolean)true);
                }
                if (serializedMessage == null) {
                    String error = "[SolJcsmpMessageListener] Inbound message is corrupt [no body data in message]";
                    try {
                        this._listener.onCorruptMessage(message.getMessageIdLong(), topic, serializedMessage, serializedMetadata, new RuntimeException("[SolJcsmpMessageListener] Inbound message is corrupt [no body data in message]"));
                    }
                    catch (Throwable thrown) {
                        this.tracer.log("[SolJcsmpMessageListener] Error in onCorruptMessage handler: " + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.SEVERE);
                    }
                    return;
                }
                if (props == null) {
                    String error = "[SolJcsmpMessageListener] Inbound message is corrupt [no properties in message]";
                    try {
                        this._listener.onCorruptMessage(message.getMessageIdLong(), topic, serializedMessage, null, new RuntimeException("[SolJcsmpMessageListener] Inbound message is corrupt [no properties in message]"));
                    }
                    catch (Throwable thrown) {
                        this.tracer.log("[SolJcsmpMessageListener] Error in onCorruptMessage handler: " + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.SEVERE);
                    }
                    return;
                }
                if (serializedMetadata == null) {
                    String error = "[SolJcsmpMessageListener] Inbound message is corrupt [no SMA metadata in message]";
                    try {
                        this._listener.onCorruptMessage(message.getMessageIdLong(), topic, serializedMessage, serializedMetadata, new RuntimeException("[SolJcsmpMessageListener] Inbound message is corrupt [no SMA metadata in message]"));
                    }
                    catch (Throwable thrown) {
                        this.tracer.log("[SolJcsmpMessageListener] Error in onCorruptMessage handler: " + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.SEVERE);
                    }
                    return;
                }
                try {
                    this._listener.onMessage(message.getMessageIdLong(), serializedMessage, serializedMetadata, topic, isGuaranteed, originTs, preWireTs, postWireTs);
                }
                catch (Throwable thrown) {
                    this.tracer.log("[SolJcsmpMessageListener] Error in onMessage: " + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.SEVERE);
                }
            }
            catch (Throwable thrown) {
                String error = "[SolJcsmpMessageListener] Error unmarshalling inbound message: " + thrown.getMessage();
                try {
                    this._listener.onCorruptMessage(message.getMessageIdLong(), topic, serializedMessage, serializedMetadata, new RuntimeException(error, thrown));
                }
                catch (Throwable thrown2) {
                    this.tracer.log("[SolJcsmpMessageListener] Error in onCorruptMessage handler: " + UtlThrowable.prepareStackTrace((Throwable)thrown2), Tracer.Level.SEVERE);
                }
            }
        } else {
            if (isGuaranteed) {
                _tempMessageStore.put(message.getMessageIdLong(), message);
            }
            IOBuffer serializedMetadata = null;
            XString topic = null;
            try {
                topic = XString.create((String)message.getDestination().getName(), (boolean)true, (boolean)false);
            }
            catch (Throwable thrown) {
                this.tracer.log("[SolJcsmpMessageListener] Error getting topic from invalid message type: " + thrown.getMessage(), Tracer.Level.WARNING);
            }
            try {
                byte[] serializedMetadataBytes;
                SDTMap props = message.getProperties();
                if (props != null && (serializedMetadataBytes = props.getBytes("x-sma-metadata")) != null) {
                    serializedMetadata = IOBuffer.create((int)serializedMetadataBytes.length, (boolean)false);
                    UtlBuffer.copy((byte[])serializedMetadataBytes, (int)0, (ByteBuffer)serializedMetadata.getBufferUnsafe(), (int)0, (int)serializedMetadataBytes.length);
                }
            }
            catch (Throwable thrown) {
                this.tracer.log("[SolJcsmpMessageListener] Error getting serialized metadata from invalid message type: " + thrown.getMessage(), Tracer.Level.WARNING);
            }
            try {
                this._listener.onCorruptMessage(message.getMessageIdLong(), topic, null, serializedMetadata, new RuntimeException("Message is not of type BytesMessage '" + message.getClass() + "' [unsupported message type]"));
            }
            catch (Throwable thrown2) {
                this.tracer.log("[SolJcsmpMessageListener] Error in onCorruptMessage handler: " + UtlThrowable.prepareStackTrace((Throwable)thrown2), Tracer.Level.SEVERE);
            }
        }
    }

    public final void ackMessage(long messageId) {
        BytesXMLMessage message = _tempMessageStore.get(messageId);
        if (null != message) {
            message.ackMessage();
            _tempMessageStore.remove(messageId);
        }
    }

    public final boolean preReconnect() {
        this._listener.onSessionReconnecting();
        return true;
    }

    public final void postReconnect() {
        this._listener.onSessionReconnected();
    }

    public final BytesXMLMessage getMessage(long messageId) {
        return _tempMessageStore.get(messageId);
    }
}

