/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.neeve.lang.XLongArrayIterator;
import com.neeve.lang.XLongIterator;
import com.neeve.pkt.PktBuffer;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufVariableLengthField;
import java.util.Arrays;
import java.util.NoSuchElementException;

public final class XbufLongArrayField
extends XbufVariableLengthField<long[]> {
    private final Iterator iterator = new Iterator();

    private XbufLongArrayField(short id, String name) {
        super(XbufField.Type.LONG_ARRAY, id, name);
    }

    public static XbufLongArrayField create(short id, String name) {
        return new XbufLongArrayField(id, name);
    }

    @Override
    protected final int serializedLength(long[] val) {
        return val == null ? 0 : val.length * 8;
    }

    @Override
    protected final int serialize(PktBuffer buffer, int offset, long[] val) {
        buffer.putFrom(offset, val, 0, val.length);
        return val.length * 8;
    }

    @Override
    protected final long[] deserialize(PktBuffer buffer, int offset, int length) {
        long[] val = new long[length / 8];
        if (length > 0) {
            buffer.getTo(offset, val, 0, val.length);
        }
        return val;
    }

    public final void setValues(long[] values) {
        super.setValue(values);
    }

    public final long[] getValuesAsArray() {
        return (long[])super.getValue();
    }

    public final void setValuesFrom(XLongIterator val) {
        long[] v;
        if (val instanceof Iterator) {
            v = ((Iterator)val).array();
        } else if (val instanceof XLongArrayIterator) {
            XLongArrayIterator a = (XLongArrayIterator)val;
            v = a.array();
            if (v.length != a.length()) {
                v = new long[a.length()];
                System.arraycopy(a.array(), a.offset(), v, 0, a.length());
            }
        } else {
            int size = 0;
            val.toFirst();
            while (val.hasNext()) {
                ++size;
                val.next();
            }
            v = new long[size];
            val.toFirst();
            for (int i = 0; i < v.length; ++i) {
                v[i] = val.next();
            }
        }
        this.setValue(v);
        val.toFirst();
    }

    public final void addValue(long val) {
        long[] vArray;
        long[] existing = (long[])this.getValue();
        if (this.getValue() == null) {
            vArray = new long[1];
        } else {
            vArray = new long[existing.length + 1];
            System.arraycopy(existing, 0, vArray, 0, existing.length);
            vArray[vArray.length - 1] = val;
        }
        this.setValue(vArray);
    }

    public final Iterator getValueIterator() {
        return this.iterator.toFirst();
    }

    @Override
    protected final String toString(long[] val) {
        return Arrays.toString(val);
    }

    public final class Iterator
    implements XLongIterator {
        int current = 0;

        public long[] array() {
            return (long[])XbufLongArrayField.this.getValue();
        }

        public final boolean hasNext() {
            long[] value = (long[])XbufLongArrayField.this.getValue();
            return value != null && this.current < value.length;
        }

        public long next() {
            long[] val = (long[])XbufLongArrayField.this.getValue();
            if (val == null) {
                throw new NoSuchElementException();
            }
            return ((long[])XbufLongArrayField.this.getValue())[this.current++];
        }

        public final void remove() {
            throw new UnsupportedOperationException("remove is not supported for xbuf field iterators.");
        }

        public final Iterator toFirst() {
            this.current = 0;
            return this;
        }
    }
}

