/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.lang.XLongIterator;
import com.neeve.quark.QuarkBuffer;
import com.neeve.quark.QuarkLongArrayDeserializer;
import java.util.NoSuchElementException;

public final class XLongSequence
implements XLongIterator {
    private static final byte FLG_INITIALIZED = 1;
    private static final byte FLG_OWNED = 2;
    private byte _flags;
    private long _addr;
    private int _offset;
    private int _nelem;
    private int _index;

    private XLongSequence() {
    }

    public static final XLongSequence create() {
        return new XLongSequence();
    }

    private final XLongSequence setInitialized(boolean val) {
        this._flags = val ? (byte)(this._flags | 1) : (byte)(this._flags & 0xFFFFFFFE);
        return this;
    }

    public final boolean isInitialized() {
        return (this._flags & 1) != 0;
    }

    private final XLongSequence setOwned(boolean val) {
        this._flags = val ? (byte)(this._flags | 2) : (byte)(this._flags & 0xFFFFFFFD);
        return this;
    }

    public final boolean isOwned() {
        return (this._flags & 2) != 0;
    }

    public XLongIterator toFirst() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        this._index = 0;
        return this;
    }

    public final boolean hasNext() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        return this._index < this._nelem;
    }

    public final long next() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        if (this._index == this._nelem) {
            throw new NoSuchElementException("no more elements");
        }
        return QuarkBuffer.getLong((long)this._addr, (int)(this._offset + this._index++ * 8));
    }

    public final void remove() {
        throw new UnsupportedOperationException();
    }

    public final XLongSequence wrap(long addr, int offset, int len) {
        this.reset();
        this._addr = addr;
        this._offset = offset;
        this._nelem = len / 8;
        this._index = 0;
        this.setInitialized(true).setOwned(false);
        return this;
    }

    public final XLongSequence wrap(QuarkBuffer buffer, int offset, int len) {
        return this.wrap(buffer.getNativeAddress(), offset, len);
    }

    public final XLongSequence setFrom(long addr, int offset, int len) {
        this.reset();
        this._addr = QuarkBuffer.allocateMemoryBlock((long)len, (boolean)false);
        QuarkBuffer.copy((long)addr, (int)offset, (long)this._addr, (int)0, (int)len);
        this._nelem = len / 8;
        this._offset = 0;
        this._index = 0;
        this.setInitialized(true).setOwned(true);
        return this;
    }

    public final XLongSequence setFrom(QuarkBuffer buffer, int offset, int len) {
        this.reset();
        this._addr = QuarkBuffer.allocateMemoryBlock((long)len, (boolean)false);
        QuarkBuffer.copy((long)buffer.getNativeAddress(), (int)offset, (long)this._addr, (int)0, (int)len);
        this._nelem = len / 8;
        this._offset = 0;
        this._index = 0;
        this.setInitialized(true).setOwned(true);
        return this;
    }

    public final XLongSequence setFrom(XLongSequence sequence) {
        this.reset();
        if (sequence.isInitialized()) {
            int serializedLength = sequence.serializedLength();
            this._addr = QuarkBuffer.allocateMemoryBlock((long)serializedLength, (boolean)false);
            QuarkBuffer.copy((long)sequence._addr, (int)0, (long)this._addr, (int)0, (int)serializedLength);
            this._nelem = sequence.numElements();
            this._offset = 0;
            this._index = 0;
            this.setInitialized(true).setOwned(true);
        }
        return this;
    }

    public final XLongSequence setFrom(XLongIterator iterator) {
        this.reset();
        if (iterator instanceof XLongSequence) {
            return this.setFrom((XLongSequence)iterator);
        }
        if (!(iterator instanceof QuarkLongArrayDeserializer)) {
            throw new IllegalArgumentException("iterator implementations other than XLongSequence and QuarkLongArrayDeserializer are not currently supported");
        }
        QuarkLongArrayDeserializer deserializer = (QuarkLongArrayDeserializer)iterator;
        this._addr = QuarkBuffer.allocateMemoryBlock((long)deserializer.serializedLength(), (boolean)false);
        deserializer.getTo(this._addr, 0);
        this._nelem = deserializer.numElements();
        this._offset = 0;
        this._index = 0;
        this.setInitialized(true).setOwned(true);
        return this;
    }

    public final int numElements() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        return this._nelem;
    }

    public final int serializedLength() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        return this._nelem * 8;
    }

    public final int getTo(long[] val, int offset) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        QuarkBuffer.getTo((long)this._addr, (int)this._offset, (long[])val, (int)offset, (int)this._nelem);
        return this.serializedLength();
    }

    public final int getTo(byte[] val, int offset) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        int serializedLength = this.serializedLength();
        QuarkBuffer.getTo((long)this._addr, (int)this._offset, (byte[])val, (int)offset, (int)serializedLength);
        return serializedLength;
    }

    public final int getTo(long addr, int offset) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        int serializedLength = this.serializedLength();
        QuarkBuffer.copy((long)this._addr, (int)this._offset, (long)addr, (int)offset, (int)serializedLength);
        return serializedLength;
    }

    public final int getTo(QuarkBuffer val, int offset) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        int serializedLength = this.serializedLength();
        val.putFrom(offset, this._addr, this._offset, serializedLength);
        return serializedLength;
    }

    public final XLongIterator iterator() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        return this.toFirst();
    }

    public final XLongSequence reset() {
        if (this.isInitialized()) {
            if (this.isOwned() && this._addr != 0L) {
                QuarkBuffer.freeMemoryBlock((long)this._addr, (long)this.serializedLength());
            }
            this.setInitialized(false);
        }
        return this;
    }
}

