/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm;

import com.neeve.adm.AdmArray;
import com.neeve.adm.AdmCollection;
import com.neeve.adm.AdmDocumentation;
import com.neeve.adm.AdmEncodingType;
import com.neeve.adm.AdmEntity;
import com.neeve.adm.AdmEntityArray;
import com.neeve.adm.AdmEnumeration;
import com.neeve.adm.AdmEnumerationArray;
import com.neeve.adm.AdmFactoryType;
import com.neeve.adm.AdmField;
import com.neeve.adm.AdmGenerator;
import com.neeve.adm.AdmMessage;
import com.neeve.adm.AdmPrimitive;
import com.neeve.adm.AdmPrimitiveArray;
import com.neeve.adm.AdmScopedType;
import com.neeve.adm.AdmShort;
import com.neeve.adm.AdmSourceCodeBuilder;
import com.neeve.adm.AdmType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

final class AdmXbufGenerator
extends AdmGenerator {
    AdmXbufGenerator() {
    }

    private final int getSyncedFieldCount(AdmScopedType entity, List<AdmField> fields) {
        int syncedFieldCount = 0;
        for (AdmField field : fields) {
            if (field.getType() instanceof AdmEntity && !((AdmEntity)field.getType()).isEmbedded() || field.getType() instanceof AdmCollection) continue;
            ++syncedFieldCount;
        }
        return syncedFieldCount;
    }

    private final void writeClassDeclaration(AdmCollection collection, AdmSourceCodeBuilder codeBuilder) {
        if (collection.isDeprecated()) {
            codeBuilder.last().appendln("@Deprecated");
        }
        AdmGenerator.writeAdmGeneratedAnnotations(this.getClass(), AdmEncodingType.Xbuf, collection.getModel(), codeBuilder);
        AdmGenerator.writeFactoryTypeInfoAnnotation(collection, codeBuilder);
        codeBuilder.last().append("final public class " + collection.getName() + " extends ");
        switch (collection.getType()) {
            case List: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogList}<");
                break;
            }
            case Queue: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogQueue}<");
                break;
            }
            case CharMap: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogXCharMap}<");
                break;
            }
            case ByteMap: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogXByteMap}<");
                break;
            }
            case ShortMap: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogXShortMap}<");
                break;
            }
            case IntMap: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogXIntMap}<");
                break;
            }
            case LongMap: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogXLongMap}<");
                break;
            }
            case FloatMap: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogXFloatMap}<");
                break;
            }
            case DoubleMap: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogXDoubleMap}<");
                break;
            }
            case StringMap: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogXStringMap}<");
                break;
            }
            default: {
                throw new IllegalStateException("unknown collection type '" + (Object)((Object)collection.getType()) + "'");
            }
        }
        codeBuilder.last().append(collection.getContains().getTemplatedJavaTypeName() + "> implements " + AdmXbufGenerator.interfaceTemplatedTypeName(collection));
        codeBuilder.last().append(", %{com.neeve.rog.IRogJsonizable}");
        codeBuilder.last().appendln(" {");
    }

    private final void writeClassDeclaration(AdmEntity entity, List<AdmField> fields, AdmSourceCodeBuilder codeBuilder) {
        AdmXbufGenerator.writeJavadocTypeComment("", entity, codeBuilder);
        AdmGenerator.writeAdmGeneratedAnnotations(this.getClass(), AdmEncodingType.Xbuf, entity.getModel(), codeBuilder);
        AdmGenerator.writeFactoryTypeInfoAnnotation(entity, codeBuilder);
        AdmGenerator.writeJsonPropertyOrderAnnotation(entity, fields, codeBuilder);
        codeBuilder.newCodeSegment();
        codeBuilder.last().append(entity.isFinal() ? "final " : "").append("public class " + entity.getName());
        if (!entity.isEmbedded()) {
            if (entity.isRoot()) {
                codeBuilder.last().append(" extends %{com.neeve.rog.impl.RogRootNode}");
            } else if (entity.containsChildren()) {
                codeBuilder.last().append(" extends %{com.neeve.rog.impl.RogContainerNode}");
            } else {
                codeBuilder.last().append(" extends %{com.neeve.rog.impl.RogNode}");
            }
            codeBuilder.last().append(" implements " + AdmXbufGenerator.interfaceTemplatedTypeName(entity));
            if (entity.isMessage()) {
                codeBuilder.last().append(", %{com.neeve.link.ILnkMessage}, %{com.neeve.sma.MessageReflector}");
            }
            codeBuilder.last().append(", %{com.neeve.xbuf.IXbufDesyncer}, %{com.neeve.rog.IRogJsonizable}");
        } else {
            codeBuilder.last().append(" implements %{com.neeve.xbuf.IXbufDesyncer}, %{com.neeve.util.UtlPool}.Item<" + entity.getName() + ">");
            if (entity.getGenerateEmbeddedEntityInterfaces()) {
                codeBuilder.last().append(", ");
                codeBuilder.last().append(AdmXbufGenerator.interfaceTemplatedTypeName(entity));
            } else {
                codeBuilder.last().append(", %{com.neeve.rog.IRogValidatable}");
            }
        }
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln(" {");
        if (entity.isEmbedded()) {
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * Heuristics.");
            codeBuilder.last().appendln("     */");
            codeBuilder.last().appendln("    final private static int initialBackingBufferSize = %{com.neeve.xbuf.XbufHeuristics}.getProperty(" + entity.getName() + ".class, \"initialbackingbuffersize\", 256);");
            codeBuilder.last().appendln("");
        }
        codeBuilder.last().appendln("    /**");
        codeBuilder.last().appendln("     * A preallocated empty array used to avoid garbage when returning empty arrays of this type.");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    final public static " + entity.getName() + "[] EMPTY_ARRAY = new " + entity.getName() + "[0];");
    }

    private final void writeBackingPacketClassDeclaration(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("    /**");
        codeBuilder.last().appendln("     * The backing packet type for " + type.getTemplatedJavaTypeName() + " (used internally for serialization purposes).");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    final public static class PacketBody extends %{com.neeve.pkt.types.PktBodyXbufContainer} {");
        codeBuilder.last().appendln("        private PacketBody(final %{java.util.Properties} props, final boolean direct) {");
        codeBuilder.last().appendln("            super(" + type.getFactory().getName() + ".PKTID_" + type.getName() + ", props, direct);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("        public static %{com.neeve.pkt.PktBody} create(final %{java.util.Properties} props) {");
        codeBuilder.last().appendln("            return new PacketBody(props, true);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("        public static %{com.neeve.pkt.PktBody} create() {");
        codeBuilder.last().appendln("            return PacketBody.create(null);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
    }

    private final void writeEntityPoolFactoryClassDeclaration(AdmEntity entity, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("    /**");
        codeBuilder.last().appendln("     * The " + entity.getName() + " pool factory.");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    final private static class Factory implements %{com.neeve.util.UtlPool}.Factory<" + entity.getName() + "> {");
        codeBuilder.last().appendln("        final public " + entity.getName() + " createItem(final Object object) {");
        codeBuilder.last().appendln("            return new " + entity.getName() + "(initialBackingBufferSize);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public " + entity.getName() + "[] createItemArray(final int size) {");
        codeBuilder.last().appendln("            return new " + entity.getName() + "[size];");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
    }

    private final void writeEntityFieldClassDeclarations(AdmEntity entity, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("    /**");
        codeBuilder.last().appendln("     * The " + entity.getTemplatedJavaTypeName() + " xbuf field (used internally when this entity is used as a field of another entity).");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    final public static class Field extends %{com.neeve.xbuf.XbufVariableLengthField}<" + entity.getName() + "> {");
        codeBuilder.last().appendln("        private Field(final short id, final String name) {");
        codeBuilder.last().appendln("            super(Type.COMPOUND, id, name);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("        public static Field create(final short id, final String name) {");
        codeBuilder.last().appendln("            return new Field(id, name);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("        // ----- XbufVariableLengthField methods -----");
        codeBuilder.last().appendln("        @Override");
        codeBuilder.last().appendln("        final protected int serializedLength(final " + entity.getName() + " val) {");
        codeBuilder.last().appendln("            return val != null ? val._container.getSerializedLength() : 0;");
        codeBuilder.last().appendln("        }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("        @Override");
        codeBuilder.last().appendln("        final protected int serialize(final %{com.neeve.pkt.PktBuffer} buffer, final int offset, final " + entity.getName() + " val) {");
        codeBuilder.last().appendln("            return val != null ? val.serializeToPacketBuffer(buffer, offset) : 0;");
        codeBuilder.last().appendln("        }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("        @Override");
        codeBuilder.last().appendln("        final protected " + entity.getName() + " deserialize(final %{com.neeve.pkt.PktBuffer} buffer, final int offset, final int length) {");
        codeBuilder.last().appendln("            final " + entity.getName() + " val = " + entity.getName() + ".create();");
        codeBuilder.last().appendln("            val.deserializeFromPacketBuffer(buffer, offset, length);");
        codeBuilder.last().appendln("            return val;");
        codeBuilder.last().appendln("        }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("        @Override");
        codeBuilder.last().appendln("        final protected String toString(final " + entity.getName() + " val) {");
        codeBuilder.last().appendln("            return val.toString();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        // ----- XbufVariableLengthField methods -----");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    /**");
        codeBuilder.last().appendln("     * The " + entity.getTemplatedJavaTypeName() + " list field (used internally when this entity is used as an array field of another entity).");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    final public static class ListField extends %{com.neeve.xbuf.XbufListField}<" + entity.getName() + "> {");
        codeBuilder.last().appendln("        private ListField(final short id, final String name) {");
        codeBuilder.last().appendln("            super(Type.COMPOUND_LIST, id, name, Field.create(id, name));");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("        public static ListField create(final short id, final String name) {");
        codeBuilder.last().appendln("            return new ListField(id, name);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("        // ----- XbufListField methods -----");
        codeBuilder.last().appendln("        @Override");
        codeBuilder.last().appendln("        final protected " + entity.getName() + "[] createTypeArray(final int size) {");
        codeBuilder.last().appendln("            return new " + entity.getName() + "[size];");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        // ----- XbufListField methods -----");
        codeBuilder.last().appendln("    }");
    }

    private final void writeBackingPacketDeclaration(AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- Backing packet -----");
        codeBuilder.last().appendln("    private %{com.neeve.pkt.PktPacket} _packet;");
        codeBuilder.last().appendln("    // ----- Backing packet -----");
    }

    private final void writeEnumIntAdapters(List<AdmField> fields, AdmSourceCodeBuilder codeBuilder) {
        boolean first = true;
        for (AdmField field : fields) {
            if (!(field.getType() instanceof AdmEnumerationArray) && !(field.getType() instanceof AdmEnumeration)) continue;
            if (first) {
                codeBuilder.last().appendln("    // ----- enum int adapters -----");
                first = false;
            }
            AdmEnumeration enumType = null;
            enumType = field.getType() instanceof AdmEnumerationArray ? ((AdmEnumerationArray)field.getType()).getType() : (AdmEnumeration)field.getType();
            codeBuilder.last().appendln("    final static %{com.neeve.lang.XIntAdapter}<" + enumType.getTemplatedJavaTypeName() + "> " + AdmXbufGenerator.fieldAdapterFieldVarName(field) + " = new %{com.neeve.lang.XIntAdapter}<" + enumType.getTemplatedJavaTypeName() + "> () {");
            codeBuilder.last().appendln("        @Override");
            codeBuilder.last().appendln("        final public boolean canAdaptFrom(final int from) {");
            codeBuilder.last().appendln("            return from == " + (enumType.hasValue(0) ? "Integer.MAX_VALUE" : "0") + " ? true : (" + enumType.getTemplatedJavaTypeName() + ".hasValue(from) ? true : false);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        ");
            codeBuilder.last().appendln("        @Override");
            codeBuilder.last().appendln("        final public " + enumType.getTemplatedJavaTypeName() + " adaptFrom(final int from) {");
            codeBuilder.last().appendln("            return from == " + (enumType.hasValue(0) ? "Integer.MAX_VALUE" : "0") + " ? null : (" + enumType.getTemplatedJavaTypeName() + ".hasValue(from) ? " + enumType.getTemplatedJavaTypeName() + ".fromValue(from) : null);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        ");
            codeBuilder.last().appendln("        @Override");
            codeBuilder.last().appendln("        final public int adaptTo(final " + enumType.getTemplatedJavaTypeName() + " to) {");
            codeBuilder.last().appendln("            return to == null ? " + (enumType.hasValue(0) ? "Integer.MAX_VALUE" : "0") + " : to.val;");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        ");
            codeBuilder.last().appendln("        @Override");
            codeBuilder.last().appendln("        final public " + enumType.getTemplatedJavaTypeName() + "[] newArray(final int size) {");
            codeBuilder.last().appendln("            if (size == 0) {");
            codeBuilder.last().appendln("                return " + enumType.getTemplatedJavaTypeName() + ".EMPTY_ARRAY;");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("            else {");
            codeBuilder.last().appendln("                return new " + enumType.getTemplatedJavaTypeName() + "[size];");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    };");
        }
        if (!first) {
            codeBuilder.last().appendln("    // ----- enum int adapters -----");
            first = false;
        }
    }

    private final void writeEntityArrayIteratedValueNotificationReceivers(List<AdmField> fields, AdmSourceCodeBuilder codeBuilder) {
        boolean first = true;
        for (AdmField field : fields) {
            AdmType fieldType = field.getType();
            if (!(fieldType instanceof AdmEntityArray)) continue;
            if (first) {
                codeBuilder.last().appendln("    // ----- entity array iterated value notification receiver s -----");
                first = false;
            }
            AdmEntity entity = ((AdmEntityArray)fieldType).getType();
            codeBuilder.last().appendln("    final private static " + entity.getName() + ".ListField.IteratedValueNotificationReceiver<" + entity.getTemplatedJavaTypeName() + "> " + AdmXbufGenerator.fieldIteratedValueNotificationReceiverFieldVarName(field) + " = new " + entity.getName() + ".ListField.IteratedValueNotificationReceiver<" + entity.getTemplatedJavaTypeName() + "> () {");
            codeBuilder.last().appendln("        @Override");
            codeBuilder.last().appendln("        final public void handleIteratedValue(final " + entity.getName() + " value, final boolean wasDesyncd) {");
            codeBuilder.last().appendln("           if (wasDesyncd) value.dispose();");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    };");
        }
        if (!first) {
            codeBuilder.last().appendln("    // ----- entity array iterated value notification receiver s -----");
            first = false;
        }
    }

    private final void writeFieldContainerDeclaration(AdmScopedType type, List<AdmField> fields, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- x-buf field container -----");
        codeBuilder.last().appendln("    private %{com.neeve.xbuf.XbufFieldContainer} _container;");
        if (!(type instanceof AdmCollection)) {
            codeBuilder.last().appendln("    private int _lateSyncBoundary;");
        }
        codeBuilder.last().appendln("    // ----- x-buf field container -----");
    }

    private final String getXbufFieldType(AdmType fieldType, AdmEncodingType protoXbufGenCompatibility) {
        if (fieldType instanceof AdmPrimitive) {
            switch (((AdmPrimitive)fieldType).getType()) {
                case Byte: {
                    if (protoXbufGenCompatibility == null) {
                        return "%{com.neeve.xbuf.XbufByteField}";
                    }
                    return "%{com.neeve.xbuf.XbufVariableByteField}";
                }
                case Char: {
                    if (protoXbufGenCompatibility == null) {
                        return "%{com.neeve.xbuf.XbufCharField}";
                    }
                    return "%{com.neeve.xbuf.XbufVariableCharField}";
                }
                case Short: {
                    if (protoXbufGenCompatibility == null) {
                        return "%{com.neeve.xbuf.XbufShortField}";
                    }
                    return "%{com.neeve.xbuf.XbufVariableShortField}";
                }
                case Integer: {
                    if (protoXbufGenCompatibility == null) {
                        return "%{com.neeve.xbuf.XbufIntField}";
                    }
                    return "%{com.neeve.xbuf.XbufVariableIntField}";
                }
                case Long: {
                    if (protoXbufGenCompatibility == null) {
                        return "%{com.neeve.xbuf.XbufLongField}";
                    }
                    return "%{com.neeve.xbuf.XbufVariableLongField}";
                }
                case Float: {
                    return "%{com.neeve.xbuf.XbufFloatField}";
                }
                case Double: {
                    return "%{com.neeve.xbuf.XbufDoubleField}";
                }
                case Boolean: {
                    if (protoXbufGenCompatibility == null) {
                        return "%{com.neeve.xbuf.XbufBooleanField}";
                    }
                    return "%{com.neeve.xbuf.XbufVariableBooleanField}";
                }
                case Date: {
                    if (protoXbufGenCompatibility == null) {
                        return "%{com.neeve.xbuf.XbufDateField}";
                    }
                    return "%{com.neeve.xbuf.XbufVariableDateField}";
                }
                case String: {
                    return "%{com.neeve.xbuf.XbufStringField}";
                }
                case Currency: {
                    return "%{com.neeve.xbuf.XbufCurrencyField}";
                }
                case UUID: {
                    return "%{com.neeve.xbuf.XbufUUIDField}";
                }
            }
        } else {
            if (fieldType instanceof AdmPrimitiveArray) {
                switch (((AdmPrimitiveArray)fieldType).getType()) {
                    case Byte: {
                        if (protoXbufGenCompatibility == null || protoXbufGenCompatibility == AdmEncodingType.Xbuf) {
                            return "%{com.neeve.xbuf.XbufByteArrayField}";
                        }
                        return "%{com.neeve.xbuf.XbufVariableByteListField}";
                    }
                    case Char: {
                        if (protoXbufGenCompatibility == null || protoXbufGenCompatibility == AdmEncodingType.Xbuf) {
                            return "%{com.neeve.xbuf.XbufCharArrayField}";
                        }
                        return "%{com.neeve.xbuf.XbufVariableCharListField}";
                    }
                    case Short: {
                        if (protoXbufGenCompatibility == null || protoXbufGenCompatibility == AdmEncodingType.Xbuf) {
                            return "%{com.neeve.xbuf.XbufShortArrayField}";
                        }
                        return "%{com.neeve.xbuf.XbufVariableShortListField}";
                    }
                    case Integer: {
                        if (protoXbufGenCompatibility == null || protoXbufGenCompatibility == AdmEncodingType.Xbuf) {
                            return "%{com.neeve.xbuf.XbufIntArrayField}";
                        }
                        return "%{com.neeve.xbuf.XbufVariableIntListField}";
                    }
                    case Long: {
                        if (protoXbufGenCompatibility == null || protoXbufGenCompatibility == AdmEncodingType.Xbuf) {
                            return "%{com.neeve.xbuf.XbufLongArrayField}";
                        }
                        return "%{com.neeve.xbuf.XbufVariableLongListField}";
                    }
                    case Float: {
                        if (protoXbufGenCompatibility == null || protoXbufGenCompatibility == AdmEncodingType.Xbuf) {
                            return "%{com.neeve.xbuf.XbufFloatArrayField}";
                        }
                        return "%{com.neeve.xbuf.XbufFloatListField}";
                    }
                    case Double: {
                        if (protoXbufGenCompatibility == null || protoXbufGenCompatibility == AdmEncodingType.Xbuf) {
                            return "%{com.neeve.xbuf.XbufDoubleArrayField}";
                        }
                        return "%{com.neeve.xbuf.XbufDoubleListField}";
                    }
                    case Boolean: {
                        if (protoXbufGenCompatibility == null || protoXbufGenCompatibility == AdmEncodingType.Xbuf) {
                            return "%{com.neeve.xbuf.XbufBooleanArrayField}";
                        }
                        return "%{com.neeve.xbuf.XbufVariableBooleanListField}";
                    }
                    case String: {
                        return "%{com.neeve.xbuf.XbufStringListField}";
                    }
                    case Date: {
                        if (protoXbufGenCompatibility == null || protoXbufGenCompatibility == AdmEncodingType.Xbuf) {
                            return "%{com.neeve.xbuf.XbufDateArrayField}";
                        }
                        return "%{com.neeve.xbuf.XbufVariableDateListField}";
                    }
                    case Currency: {
                        return "%{com.neeve.xbuf.XbufCurrencyListField}";
                    }
                    case UUID: {
                        return "%{com.neeve.xbuf.XbufUUIDArrayField}";
                    }
                }
                throw new IllegalStateException("Unsupported primitive array type '" + (Object)((Object)((AdmPrimitiveArray)fieldType).getType()) + "'");
            }
            if (fieldType instanceof AdmEntity) {
                if (((AdmEntity)fieldType).isEmbedded()) {
                    return ((AdmEntity)fieldType).getTemplatedJavaTypeName() + ".Field";
                }
            } else {
                if (fieldType instanceof AdmEntityArray) {
                    return ((AdmEntityArray)fieldType).getType().getTemplatedJavaTypeName() + ".ListField";
                }
                if (fieldType instanceof AdmEnumeration) {
                    if (protoXbufGenCompatibility == null) {
                        return "%{com.neeve.xbuf.XbufIntField}";
                    }
                    return "%{com.neeve.xbuf.XbufVariableEnumField}<" + ((AdmEnumeration)fieldType).getTemplatedJavaTypeName() + ">";
                }
                if (fieldType instanceof AdmEnumerationArray) {
                    if (protoXbufGenCompatibility == null) {
                        return "%{com.neeve.xbuf.XbufIntArrayField}";
                    }
                    return "%{com.neeve.xbuf.XbufVariableEnumListField}<" + ((AdmEnumerationArray)fieldType).getType().getTemplatedJavaTypeName() + ">";
                }
            }
        }
        return null;
    }

    private final void writeFieldAndSchemaDeclarations(List<AdmField> fields, AdmEncodingType protoXbufGenCompatibility, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- x-buf fields and schema -----");
        for (AdmField field : fields) {
            AdmType fieldType = field.getType();
            String xbufFieldType = this.getXbufFieldType(fieldType, protoXbufGenCompatibility);
            if (xbufFieldType == null) continue;
            codeBuilder.last().appendln("    final private " + xbufFieldType + " " + AdmXbufGenerator.fieldFldVarName(field) + ";");
        }
        codeBuilder.last().appendln("    final private XbufSchema _schema;");
        codeBuilder.last().appendln("    // ----- x-buf fields and schema -----");
    }

    final void writeFieldInterestBitmaskDeclaration(AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    // ----- field interest bitmask -----");
        codeBuilder.last().appendln("    private static long[] _fieldInterestBitmask;");
        codeBuilder.last().appendln("    // ----- field interest bitmask -----");
    }

    final void writeObjectInstantiatedFlagDeclaration(AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    // ----- 'instance of class has been instantiated' flag -----");
        codeBuilder.last().appendln("    private static volatile boolean _objectInstantiated;");
        codeBuilder.last().appendln("    // ----- 'instance of class has been instantiated' flag -----");
    }

    private final void writeDirtyFlagDeclaration(AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    // ----- field presence dirty flag -----");
        codeBuilder.last().appendln("    private boolean _isDirty;");
        codeBuilder.last().appendln("    // ----- field presence dirty flag -----");
    }

    private final void writeOptimizationHintmaskDeclaration(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    // ----- optimization hints -----");
        codeBuilder.last().appendln("    private static int _optimizationHints = %{com.neeve.xbuf.XbufHeuristics}.getDefaultOptimizationHints(" + type.getJavaTypeName() + ".class);");
        codeBuilder.last().appendln("    // ----- optimization hints -----");
    }

    private final void writeDesyncPolicyDeclaration(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    // ----- desync policy -----");
        codeBuilder.last().appendln("    private static %{com.neeve.xbuf.XbufDesyncPolicy} _desyncPolicy = %{com.neeve.xbuf.XbufHeuristics}.getDefaultDesyncPolicy(" + type.getJavaTypeName() + ".class);");
        codeBuilder.last().appendln("    // ----- desync policy -----");
    }

    private final void writePoolingDeclarations(AdmEntity entity, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    // ----- pool and pool factory -----");
        codeBuilder.last().appendln("    final private static Factory _factory = new Factory();");
        codeBuilder.last().appendln("    final private static %{com.neeve.util.UtlPool}<" + entity.getName() + "> _entityPool = %{com.neeve.util.UtlPool}.<" + entity.getName() + ">create(\"xbuf.entity\", \"" + entity.getName() + "XbufEntity." + entity.getFactory().getId() + "." + entity.getId() + "\", _factory, %{com.neeve.xbuf.XbufHeuristics}.configurePoolParams(" + entity.getName() + ".class, %{com.neeve.util.UtlPool}.Params.create().setThreaded(true)));");
        codeBuilder.last().appendln("    final private %{com.neeve.util.UtlReferenceTracker} _refTracker;");
        codeBuilder.last().appendln("    final private java.util.concurrent.atomic.AtomicInteger _ownershipCount;");
        codeBuilder.last().appendln("    private %{com.neeve.util.UtlPool}<" + entity.getName() + "> _pool;");
        codeBuilder.last().appendln("    // ----- pool and pool factory -----");
    }

    private final void writeInitializer(List<AdmField> fields, AdmEncodingType protoXbufGenCompatibility, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- Initializer -----");
        codeBuilder.last().appendln("    {");
        codeBuilder.last().appendln("        _schema = createSchema();");
        for (AdmField field : fields) {
            AdmType fieldType = field.getType();
            String xbufFieldType = this.getXbufFieldType(fieldType, protoXbufGenCompatibility);
            if (xbufFieldType == null) continue;
            if (protoXbufGenCompatibility != null && fieldType instanceof AdmEnumeration) {
                codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldFldVarName(field) + " = _schema.variableLengthEnumField(\"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\", " + ((AdmEnumeration)fieldType).getTemplatedJavaTypeName() + ".class);");
                continue;
            }
            if (protoXbufGenCompatibility != null && protoXbufGenCompatibility != AdmEncodingType.Xbuf && fieldType instanceof AdmEnumerationArray) {
                codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldFldVarName(field) + " = _schema.variableLengthEnumListField(\"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\", " + ((AdmEnumerationArray)fieldType).getType().getTemplatedJavaTypeName() + ".class);");
                continue;
            }
            codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldFldVarName(field) + " = (" + xbufFieldType + ")_schema.field(\"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\");");
        }
        this.writeFieldBitmaskInitializer(fields, codeBuilder);
        codeBuilder.last().appendln("        _objectInstantiated = true;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    // ----- Initializer -----");
    }

    private final void writeConstructors(AdmCollection collection, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    // ----- Constructors -----");
        codeBuilder.last().appendln("    " + collection.getName() + "(final %{com.eaio.uuid.UUID} id) {");
        codeBuilder.last().appendln("        super(" + collection.getFactory().getName() + ".OFID,");
        codeBuilder.last().appendln("              " + collection.getFactory().getName() + ".VFID,");
        codeBuilder.last().appendln("              " + collection.getFactory().getName() + ".ID_" + collection.getName() + ",");
        codeBuilder.last().appendln("              id,");
        codeBuilder.last().appendln("              " + collection.isTransactional() + ");");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    public static " + collection.getName() + " create() {return " + collection.getFactory().getName() + ".create" + collection.getName() + "();}");
        codeBuilder.last().appendln("    // -----Constructors -----");
    }

    private final void writeConstructors(AdmEntity entity, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- Constructors -----");
        if (entity.isEmbedded()) {
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln("    public " + entity.getName() + "() {");
            codeBuilder.last().appendln("        this(initialBackingBufferSize);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    public " + entity.getName() + "(final int initialBackingBufferSize) {");
            codeBuilder.last().appendln("        _refTracker = %{com.neeve.util.UtlReferenceTracker}.enabled(this.getClass()) ? new %{com.neeve.util.UtlReferenceTracker}(this) : null;");
            codeBuilder.last().appendln("        _ownershipCount = new java.util.concurrent.atomic.AtomicInteger(0);");
            codeBuilder.last().appendln("        _container = %{com.neeve.xbuf.XbufFieldContainer}.create(%{com.neeve.pkt.PktBuffer}.create((%{com.neeve.io.IOElasticBuffer.Sizer})null, initialBackingBufferSize, true)).setDesyncer(this).setSchema(_schema.setFieldInterest(_fieldInterestBitmask));");
            codeBuilder.last().appendln("        _lateSyncBoundary = _container.getLateSyncBoundaryFieldNumber();");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    public static " + entity.getName() + " create() {return _entityPool.get(null).undispose();}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromSerializedXbufContainer(final byte[] serializedContainer, final %{com.neeve.xbuf.XbufDesyncPolicy} desyncPolicy) {");
            codeBuilder.last().appendln("        final " + entity.getName() + " entity = create();");
            codeBuilder.last().appendln("        entity._container.getBackingBuffer().putFrom(0, serializedContainer, 0, serializedContainer.length);");
            codeBuilder.last().appendln("        entity._container.desync(desyncPolicy);");
            codeBuilder.last().appendln("        return entity;");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromSerializedXbufContainer(final byte[] serializedContainer) {");
            codeBuilder.last().appendln("        return createFromSerializedXbufContainer(serializedContainer, %{com.neeve.xbuf.XbufDesyncPolicy}.Copy);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFrom(final byte[] serializedContainer, final %{com.neeve.xbuf.XbufDesyncPolicy} desyncPolicy) {");
            codeBuilder.last().appendln("        return createFromSerializedXbufContainer(serializedContainer, desyncPolicy);");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("     public static " + entity.getName() + " createFrom(final byte[] serializedContainer) {");
            codeBuilder.last().appendln("        return createFromSerializedXbufContainer(serializedContainer);");
            codeBuilder.last().appendln("    }");
        } else if (entity.isRoot()) {
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln("    " + entity.getName() + "() {");
            codeBuilder.last().appendln("        this(-1, null, %{com.neeve.pkt.PktFactory}.getInstance().createPacket(" + entity.getFactory().getName() + ".PKTID_" + entity.getName() + "));");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    " + entity.getName() + "(final int grid, final %{com.eaio.uuid.UUID} id, final %{com.neeve.pkt.PktPacket} packet) {");
            codeBuilder.last().appendln("        super(" + entity.getFactory().getName() + ".OFID,");
            codeBuilder.last().appendln("              " + entity.getFactory().getName() + ".VFID,");
            codeBuilder.last().appendln("              " + entity.getFactory().getName() + ".ID_" + entity.getName() + ",");
            codeBuilder.last().appendln("              id,");
            codeBuilder.last().appendln("              " + entity.isTransactional() + ",");
            codeBuilder.last().appendln("              grid);");
            codeBuilder.last().appendln("        setContentContainer(packet);");
            if (entity.isMessage()) {
                codeBuilder.last().appendln("        setMessageReflector(this);");
            }
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    public static " + entity.getName() + " create(final int grid) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "(grid);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " create(final int grid, final %{com.eaio.uuid.UUID} id) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "(grid, id);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromXbufContainerPacket(final int grid, final %{com.neeve.pkt.PktPacket} packet) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "FromXbufContainerPacket(grid, packet);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromSerializedXbufContainerPacket(final int grid, final %{java.nio.ByteBuffer} serializedPacket) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "FromSerializedXbufContainerPacket(grid, serializedPacket);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromSerializedXbufContainerPacket(final int grid, final byte[] serializedPacket) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "FromSerializedXbufContainerPacket(grid, serializedPacket);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromSerializedXbufContainer(final int grid, final %{java.nio.ByteBuffer} serializedContainer) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "FromSerializedXbufContainer(grid, serializedContainer);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromSerializedXbufContainer(final int grid, final byte[] serializedContainer) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "FromSerializedXbufContainer(grid, serializedContainer);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromRawJson(final int grid, final String json) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "FromRawJson(grid, json);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromJson(final int grid, final String json) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "FromJson(grid, json);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFrom(final int grid, final byte[] serializedContainer) {return createFromSerializedXbufContainer(grid, serializedContainer);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFrom(final int grid, final %{java.nio.ByteBuffer} serializedContainer) {return createFromSerializedXbufContainer(grid, serializedContainer);}");
        } else {
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln("    " + entity.getName() + "() {");
            codeBuilder.last().appendln("        this(null, %{com.neeve.pkt.PktFactory}.getInstance().createPacket(" + entity.getFactory().getName() + ".PKTID_" + entity.getName() + "));");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    " + entity.getName() + "(final %{com.eaio.uuid.UUID} id, final %{com.neeve.pkt.PktPacket} packet) {");
            codeBuilder.last().appendln("        super(" + entity.getFactory().getName() + ".OFID,");
            codeBuilder.last().appendln("              " + entity.getFactory().getName() + ".VFID,");
            codeBuilder.last().appendln("              " + entity.getFactory().getName() + ".ID_" + entity.getName() + ",");
            codeBuilder.last().appendln("              id,");
            codeBuilder.last().appendln("              " + entity.isTransactional() + ");");
            codeBuilder.last().appendln("        setContentContainer(packet);");
            if (entity.isMessage()) {
                codeBuilder.last().appendln("        setMessageReflector(this);");
            }
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    public static " + entity.getName() + " create() {return " + entity.getFactory().getName() + ".create" + entity.getName() + "();}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " create(final %{com.eaio.uuid.UUID} id) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "(id);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromXbufContainerPacket(final %{com.neeve.pkt.PktPacket} packet) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "FromXbufContainerPacket(packet);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromSerializedXbufContainerPacket(final %{java.nio.ByteBuffer} serializedPacket) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "FromSerializedXbufContainerPacket(serializedPacket);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromSerializedXbufContainerPacket(final byte[] serializedPacket) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "FromSerializedXbufContainerPacket(serializedPacket);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromSerializedXbufContainer(final %{java.nio.ByteBuffer} serializedContainer) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "FromSerializedXbufContainer(serializedContainer);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromSerializedXbufContainer(final byte[] serializedContainer) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "FromSerializedXbufContainer(serializedContainer);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromRawJson(final String json) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "FromRawJson(json);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFromJson(final String json) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "FromJson(json);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFrom(final %{java.nio.ByteBuffer} serializedContainer) {return createFromSerializedXbufContainer(serializedContainer);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFrom(final byte[] serializedContainer) {return createFromSerializedXbufContainer(serializedContainer);}");
        }
        codeBuilder.last().appendln("    // ----- Constructors -----");
    }

    private final void writeDesyncPolicyMethods(AdmEntity entity, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    // ----- Desync policy setter/getter method -----");
        codeBuilder.last().appendln("    final public static void setDesyncPolicy(final %{com.neeve.xbuf.XbufDesyncPolicy} val) {");
        codeBuilder.last().appendln("        _desyncPolicy = val;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    final public static %{com.neeve.xbuf.XbufDesyncPolicy} getDesyncPolicy() {");
        codeBuilder.last().appendln("        return _desyncPolicy;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    // ----- Desync policy setter/getter method -----");
    }

    private final void writeFieldInterestMethods(AdmEntity entity, List<AdmField> fields, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    // ----- Field interest setter method -----");
        codeBuilder.last().appendln("    final public static void setFieldInterest(final java.util.List<Integer> fieldIds) {");
        codeBuilder.last().appendln("        if (_objectInstantiated) throw new IllegalStateException(\"field interest must be set before the first object of this class has been instantiated\");");
        codeBuilder.last().appendln("        _fieldInterestBitmask = new long[" + (fields.size() % 64 == 0 ? fields.size() / 64 : fields.size() / 64 + 1) + "];");
        for (AdmField field : fields) {
            AdmType fieldType = field.getType();
            codeBuilder.newCodeSegment();
            if (field.getId() == 1) {
                codeBuilder.last().appendln("        _fieldInterestBitmask[" + (field.getIndex() >> 6) + "] |= (1L << " + (field.getIndex() & 0x3F) + ");");
                continue;
            }
            codeBuilder.last().appendln("        if (fieldIds.contains(" + field.getId() + ")) {");
            codeBuilder.last().appendln("            _fieldInterestBitmask[" + (field.getIndex() >> 6) + "] |= (1L << " + (field.getIndex() & 0x3F) + ");");
            if (fieldType instanceof AdmEntity && ((AdmEntity)fieldType).isEmbedded()) {
                codeBuilder.last().appendln("            " + fieldType.getTemplatedJavaTypeName() + ".setFieldInterest(fieldIds);");
            }
            if (fieldType instanceof AdmEntityArray) {
                codeBuilder.last().appendln("            " + ((AdmEntityArray)fieldType).getType().getTemplatedJavaTypeName() + ".setFieldInterest(fieldIds);");
            }
            codeBuilder.last().appendln("        }");
        }
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    // ----- Field interest setter method -----");
    }

    private final void writeSetContentContainerMethod(AdmScopedType type, AdmEncodingType protoXbufGenCompatibility, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    final private void setContentContainer(final %{com.neeve.pkt.PktPacket} packet) {");
        codeBuilder.last().appendln("        // tag this object in the packet so one can find an ROG ");
        codeBuilder.last().appendln("        // node from a packet (used in node pooling)");
        codeBuilder.last().appendln("        packet.setTag(%{com.neeve.pkt.PktTags}.TAG_ROG_ENVELOPE, this);");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("        // update the backing container");
        codeBuilder.last().appendln("        _container = ((%{com.neeve.pkt.types.PktBodyXbufContainer})packet.getBody()).getContainer();");
        codeBuilder.last().appendln("        if (_container.getSchema() == null) {");
        codeBuilder.last().appendln("            _container.setDesyncer(this).setDesyncPolicy(_desyncPolicy).setSchema(_schema.setFieldInterest(_fieldInterestBitmask));");
        if (!(type instanceof AdmCollection)) {
            codeBuilder.last().appendln("            _lateSyncBoundary = _container.getLateSyncBoundaryFieldNumber();");
        }
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("");
        if (protoXbufGenCompatibility == AdmEncodingType.Protobuf) {
            codeBuilder.last().appendln("        // set xRogType if not initialized via desync");
            codeBuilder.last().appendln("        if (!_container.getWasDesyncd()) {");
            codeBuilder.last().appendln("            setXRogType(getType());");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("");
        }
        codeBuilder.last().appendln("        // update the message object in the message view");
        codeBuilder.last().appendln("        setMessage(%{com.neeve.sma.MessageView}.ENCODING_TYPE_XBUF, packet);");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("        // store the packet and hold a reference to it (dispose the ");
        codeBuilder.last().appendln("        // reference to the backing packet being replaced if non-null)");
        codeBuilder.last().appendln("        if (_packet != null) {");
        codeBuilder.last().appendln("            _packet.setTag(%{com.neeve.pkt.PktTags}.TAG_ROG_ENVELOPE, null);");
        codeBuilder.last().appendln("            _packet.dispose();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        (_packet = packet).acquire();");
        codeBuilder.last().appendln("    }");
    }

    private final void writeClearCachedFieldValuesMethod(List<AdmField> fields, AdmEncodingType protoXbufGenCompatibility, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    final private void clearFieldReferences() {");
        for (AdmField field : fields) {
            AdmType fieldType = field.getType();
            if (fieldType instanceof AdmEntity && ((AdmEntity)fieldType).isEmbedded()) {
                codeBuilder.last().appendln("        if (" + AdmXbufGenerator.fieldGetterMethodName(field) + "() != null) {");
                codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldGetterMethodName(field) + "().dispose();");
                codeBuilder.last().appendln("        }");
                continue;
            }
            if (!(fieldType instanceof AdmArray) || !(fieldType instanceof AdmEntityArray)) continue;
            codeBuilder.last().appendln("        final %{com.neeve.lang.XIterator}<" + ((AdmEntityArray)fieldType).getType().getTemplatedJavaTypeName() + "> " + AdmXbufGenerator.fieldValueVarName(field) + "It = " + AdmXbufGenerator.fieldFldVarName(field) + ".getValueIterator(true);");
            codeBuilder.last().appendln("        if (" + AdmXbufGenerator.fieldValueVarName(field) + "It != null) {");
            codeBuilder.last().appendln("            while (" + AdmXbufGenerator.fieldValueVarName(field) + "It.hasNext()) {");
            codeBuilder.last().appendln("                final " + ((AdmEntityArray)fieldType).getType().getTemplatedJavaTypeName() + " v = " + AdmXbufGenerator.fieldValueVarName(field) + "It.next();");
            codeBuilder.last().appendln("                if (v != null) {");
            codeBuilder.last().appendln("                    v.dispose();");
            codeBuilder.last().appendln("                }");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
        }
        codeBuilder.last().appendln("    }");
    }

    final void writeClearContentMethod(List<AdmField> fields, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    final public void clearContent() {");
        for (AdmField field : fields) {
            AdmType fieldType = field.getType();
            if (fieldType instanceof AdmCollection || fieldType instanceof AdmEntity && !((AdmEntity)fieldType).isEmbedded()) continue;
            if (fieldType instanceof AdmEntity && ((AdmEntity)fieldType).isEmbedded()) {
                codeBuilder.last().appendln("        if (" + AdmXbufGenerator.fieldGetterMethodName(field) + "() != null) {");
                codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldGetterMethodName(field) + "().clearContent();");
                codeBuilder.last().appendln("        }");
            } else if (fieldType instanceof AdmEntityArray) {
                codeBuilder.last().appendln("        final %{com.neeve.lang.XIterator}<" + ((AdmEntityArray)fieldType).getType().getTemplatedJavaTypeName() + "> " + AdmXbufGenerator.fieldValueVarName(field) + "Values = " + AdmXbufGenerator.fieldFldVarName(field) + ".getValueIterator(true);");
                codeBuilder.last().appendln("        while(" + AdmXbufGenerator.fieldValueVarName(field) + "Values.hasNext()) {");
                codeBuilder.last().appendln("            final " + ((AdmEntityArray)fieldType).getType().getTemplatedJavaTypeName() + " v = " + AdmXbufGenerator.fieldValueVarName(field) + "Values.next();");
                codeBuilder.last().appendln("            if (v != null) {");
                codeBuilder.last().appendln("                v.clearContent();");
                codeBuilder.last().appendln("            }");
                codeBuilder.last().appendln("        }");
            }
            codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldClearerMethodName(field) + "();");
        }
        codeBuilder.last().appendln("    }");
    }

    private final void writeGetBackingBufferMethod(AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    // ----- backing buffer fetch method -----");
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    final public %{com.neeve.pkt.PktBuffer} getBackingBuffer() {");
        codeBuilder.last().appendln("        return _container.getBackingBuffer();");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    // ----- backing buffer fetch method -----");
    }

    private final void writeOptimizationHintMethods(AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    // ----- optimization hint methods -----");
        codeBuilder.last().appendln("    final public static void optimizeFor(final int val) {");
        codeBuilder.last().appendln("        if (_objectInstantiated) throw new IllegalStateException(\"optimizations must be set before the first object of this class has been instantiated\");");
        codeBuilder.last().appendln("        _optimizationHints = val;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    // ----- optimization hint methods -----");
    }

    private final void writeImplementedLnkMessageMethods(AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    // ----- ILnkMessage methods -----");
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    final public %{com.neeve.pkt.PktPacket} getPacket() {");
        codeBuilder.last().appendln("        return _packet;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    // ----- ILnkMessage methods -----");
    }

    private final void writeSerializeToProtobufMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public com.google.protobuf.Message serializeToProtobuf() {");
        codeBuilder.last().appendln("        throw new UnsupportedOperationException();");
        codeBuilder.last().appendln("    }");
    }

    private final void writeSerializeToRawJsonMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    final public String serializeToRawJson() {");
        codeBuilder.last().appendln("        final java.io.ByteArrayOutputStream baos = new java.io.ByteArrayOutputStream();");
        codeBuilder.last().appendln("        try {");
        codeBuilder.last().appendln("            " + type.getFactory().getName() + ".mapper.writeValue(baos, this);");
        codeBuilder.last().appendln("            return new String(baos.toByteArray(), \"utf-8\");");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        catch (Exception e) {");
        codeBuilder.last().appendln("            if (e instanceof RuntimeException) {");
        codeBuilder.last().appendln("                throw (RuntimeException)e;");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            else {");
        codeBuilder.last().appendln("                throw new RuntimeException(e);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
    }

    private final void writeSerializeToJsonMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public String serializeToJson() {");
        codeBuilder.last().appendln("        syncFieldBitmask();");
        codeBuilder.last().appendln("        return serializeToRawJson();");
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeFromProtobufMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserializeFromProtobuf(final com.google.protobuf.Message message) {");
        codeBuilder.last().appendln("        throw new UnsupportedOperationException();");
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeFromRawJsonMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserializeFromRawJson(final String json) {");
        codeBuilder.last().appendln("        try {");
        codeBuilder.last().appendln("            clearContent();");
        codeBuilder.last().appendln("            " + type.getFactory().getName() + ".mapper.reader().withValueToUpdate(this).readValue(json);");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        catch (Exception e) {");
        codeBuilder.last().appendln("            throw new RuntimeException(e);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeFromJsonMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserializeFromJson(final String json) {");
        codeBuilder.last().appendln("        deserializeFromRawJson(json);");
        codeBuilder.last().appendln("        desyncFieldBitmask();");
        codeBuilder.last().appendln("        return this;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeImplementedIRogNodeMethods(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- IRogNode methods -----");
        this.writeSerializeToProtobufMethod(type, codeBuilder);
        this.writeSerializeToRawJsonMethod(type, codeBuilder);
        this.writeSerializeToJsonMethod(type, codeBuilder);
        this.writeDeserializeFromProtobufMethod(type, codeBuilder);
        this.writeDeserializeFromRawJsonMethod(type, codeBuilder);
        this.writeDeserializeFromJsonMethod(type, codeBuilder);
        codeBuilder.last().appendln("    // ----- IRogNode methods -----");
    }

    private final void writeOverridenRogNodeMethods(AdmScopedType type, List<AdmField> fields, AdmEncodingType protoXbufGenCompatibility, AdmSourceCodeBuilder codeBuilder, String last_fid) {
        codeBuilder.last().appendln("    // ----- RogNode methods -----");
        if (last_fid != null) {
            codeBuilder.last().appendln("    @Override");
            codeBuilder.last().appendln("    final protected int getLastFid() {");
            codeBuilder.last().appendln("        return " + last_fid + ";");
            codeBuilder.last().appendln("    }");
        }
        this.writeReadOnlyGetterSetterMethods(type, fields, codeBuilder);
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    public int dispose() {");
        codeBuilder.last().appendln("        final int count = super.dispose();");
        codeBuilder.last().appendln("        if (count == 0) {");
        codeBuilder.last().appendln("            clearFieldReferences();");
        codeBuilder.last().appendln("            _packet.dispose();");
        this.writeFieldBitmaskClearer(codeBuilder, "    ");
        codeBuilder.last().appendln("            _isDirty = false;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        return count;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    public void undispose(final %{com.eaio.uuid.UUID} id) {");
        codeBuilder.last().appendln("        super.undispose(id);");
        if (protoXbufGenCompatibility == AdmEncodingType.Protobuf) {
            codeBuilder.last().appendln("        if (!_container.getWasDesyncd()) {");
            codeBuilder.last().appendln("            setXRogType(getType());");
            codeBuilder.last().appendln("        }");
        }
        codeBuilder.last().appendln("        _packet.acquire();");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    // ----- RogNode methods -----");
    }

    private final void writeUserPrimitiveFieldMethods(AdmEntity entity, AdmField field, AdmEncodingType protoXbufGenCompatibility, AdmSourceCodeBuilder codeBuilder) {
        String xbufFieldType;
        String rawType;
        AdmPrimitive fieldType = (AdmPrimitive)field.getType();
        AdmPrimitive.Type primitiveType = fieldType.getType();
        String javaPrimitive = fieldType.getTemplatedPrimitiveTypeName();
        boolean hasInterface = (!entity.isEmbedded() || entity.getGenerateEmbeddedEntityInterfaces()) && !field.getName().startsWith("xRog");
        String finalModifier = AdmXbufGenerator.fieldAccessorFinalModifier(entity);
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonSetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldSetterMethodName(field) + "(final " + javaPrimitive + " val) {");
        this.writeReadOnlyValidator(entity, codeBuilder);
        if (!entity.isEmbedded() && entity.isTransactional()) {
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln("        final " + javaPrimitive + " existing = " + AdmXbufGenerator.fieldGetterMethodName(field) + "();");
            if (!fieldType.isWrappedPrimitive()) {
                codeBuilder.last().appendln("        if ((val == null && val != existing) || (val != null && !val.equals(existing))) {");
            } else {
                codeBuilder.last().appendln("        if (val != existing) {");
            }
            codeBuilder.last().appendln("            recordFieldUpdate(" + AdmXbufGenerator.fieldIdxFieldVarName(field) + ", existing, val);");
            codeBuilder.last().appendln("        }");
        }
        switch (primitiveType) {
            case Byte: 
            case Char: 
            case Short: 
            case Integer: 
            case Long: 
            case Float: 
            case Double: 
            case Boolean: {
                codeBuilder.newCodeSegment();
                codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldFldVarName(field) + ".setValue(val);");
                break;
            }
            case Date: {
                codeBuilder.newCodeSegment();
                codeBuilder.last().appendln("        if (val != null && val.getTime() >= 0) {");
                codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldFldVarName(field) + ".setValue(val);");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        else {");
                codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldFldVarName(field) + ".clearValue();");
                codeBuilder.last().appendln("        }");
                break;
            }
            case String: 
            case Currency: 
            case UUID: {
                codeBuilder.newCodeSegment();
                codeBuilder.last().appendln("        if (val != null) {");
                codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldFldVarName(field) + ".setValue(val);");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        else {");
                codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldFldVarName(field) + ".clearValue();");
                codeBuilder.last().appendln("        }");
            }
        }
        codeBuilder.last().appendln("        _isDirty = true;");
        codeBuilder.last().appendln("    }");
        switch (primitiveType) {
            case Byte: 
            case Char: 
            case Short: 
            case Integer: 
            case Long: 
            case Float: 
            case Double: 
            case Boolean: {
                codeBuilder.newCodeSegment();
                codeBuilder.last().appendln();
                this.writeDeprecationComment("    ", field, codeBuilder);
                if (hasInterface) {
                    codeBuilder.last().appendln("    @Override");
                }
                codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
                codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldSetterMethodName(field) + "AsObject(" + primitiveType.getJavaTypeName() + " val) {");
                codeBuilder.last().appendln("        if (val == null) {");
                codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldClearerMethodName(field) + "();");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        else {");
                codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldSetterMethodName(field) + "(val);");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("    }");
                break;
            }
        }
        this.writeFieldFluentMethods(entity, field, codeBuilder);
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        switch (primitiveType) {
            case Byte: 
            case Char: 
            case Short: 
            case Integer: 
            case Long: 
            case Float: 
            case Double: 
            case Boolean: {
                codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
                break;
            }
            case Date: 
            case String: 
            case Currency: 
            case UUID: {
                this.writeJsonGetterAnnotations(field, codeBuilder);
                break;
            }
        }
        codeBuilder.last().appendln("    " + finalModifier + "public " + javaPrimitive + " " + AdmXbufGenerator.fieldGetterMethodName(field) + "() {");
        codeBuilder.last().appendln("        return " + AdmXbufGenerator.fieldFldVarName(field) + ".getValue();");
        codeBuilder.last().appendln("    }");
        switch (primitiveType) {
            case Byte: 
            case Char: 
            case Short: 
            case Integer: 
            case Long: 
            case Float: 
            case Double: 
            case Boolean: {
                codeBuilder.newCodeSegment();
                this.writeDeprecationComment("    ", field, codeBuilder);
                if (hasInterface) {
                    codeBuilder.last().appendln("    @Override");
                }
                this.writeJsonGetterAnnotations(field, codeBuilder);
                codeBuilder.last().appendln("    " + finalModifier + "public " + primitiveType.getJavaTypeName() + " " + AdmXbufGenerator.fieldGetterMethodName(field) + "AsObject() {");
                codeBuilder.last().appendln("        if (!" + AdmXbufGenerator.fieldCheckerMethodName(field) + "()) return null;");
                codeBuilder.last().appendln("        return " + AdmXbufGenerator.fieldGetterMethodName(field) + "();");
                codeBuilder.last().appendln("    }");
                break;
            }
        }
        if (primitiveType == AdmPrimitive.Type.Date) {
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldSetterAsTimestampMethodName(field) + "(final long val) {");
            this.writeReadOnlyValidator(entity, codeBuilder);
            if (!entity.isEmbedded() && entity.isTransactional()) {
                codeBuilder.last().appendln("        final long existing = " + AdmXbufGenerator.fieldGetterAsTimestampMethodName(field) + "();");
                codeBuilder.last().appendln("        if (val != existing) {");
                codeBuilder.last().appendln("            recordFieldUpdate(" + AdmXbufGenerator.fieldIdxFieldVarName(field) + ", existing >= 0l ? new Date(existing) : null, val >= 0l ? new Date(val) : null);");
                codeBuilder.last().appendln("        }");
            }
            codeBuilder.last().appendln("        if (val >= 0l) {");
            codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldFldVarName(field) + ".setValueAsTimestamp(val);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        else {");
            codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldFldVarName(field) + ".clearValue();");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        _isDirty = true;");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public long " + AdmXbufGenerator.fieldGetterAsTimestampMethodName(field) + "() {");
            codeBuilder.last().appendln("        return " + AdmXbufGenerator.fieldFldVarName(field) + ".getValueAsTimestamp();");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public Long " + AdmXbufGenerator.fieldGetterMethodName(field) + "AsTimestampObject() {");
            codeBuilder.last().appendln("        if (!" + AdmXbufGenerator.fieldCheckerMethodName(field) + "()) return null;");
            codeBuilder.last().appendln("        return " + AdmXbufGenerator.fieldGetterMethodName(field) + "AsTimestamp();");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldSetterAsInstantMethodName(field) + "(final %{java.time.Instant} val) {");
            if (!entity.isEmbedded() && entity.isTransactional()) {
                this.writeReadOnlyValidator(entity, codeBuilder);
                codeBuilder.last().appendln("        final %{java.time.Instant} existing = " + AdmXbufGenerator.fieldGetterAsInstantMethodName(field) + "();");
                codeBuilder.last().appendln("        if (val != existing) {");
                codeBuilder.last().appendln("            recordFieldUpdate(" + AdmXbufGenerator.fieldIdxFieldVarName(field) + ", " + AdmXbufGenerator.fieldGetterMethodName(field) + "(), val != null ? new Date(val.toEpochMilli()) : null);");
                codeBuilder.last().appendln("        }");
            }
            codeBuilder.last().appendln("        if (val != null) {");
            codeBuilder.last().appendln("           " + AdmXbufGenerator.fieldSetterAsTimestampMethodName(field) + "(val.toEpochMilli());");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        else {");
            codeBuilder.last().appendln("           " + AdmXbufGenerator.fieldClearerMethodName(field) + "();");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public %{java.time.Instant} " + AdmXbufGenerator.fieldGetterAsInstantMethodName(field) + "() {");
            codeBuilder.last().appendln("        if (!" + AdmXbufGenerator.fieldCheckerMethodName(field) + "()) return null;");
            codeBuilder.last().appendln("        return %{java.time.Instant}.ofEpochMilli(" + AdmXbufGenerator.fieldGetterAsTimestampMethodName(field) + "());");
            codeBuilder.last().appendln("    }");
        }
        if (primitiveType == AdmPrimitive.Type.String) {
            rawType = "%{" + primitiveType.getRawValueType() + "}";
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldLenderMethodName(field) + "(final %{com.neeve.lang.XString} val) {");
            this.writeReadOnlyValidator(entity, codeBuilder);
            codeBuilder.last().appendln("        if (val == null || !val.isInitialized() || val.isNull()) {" + AdmXbufGenerator.fieldSetterMethodName(field) + "((String)null); return;}");
            codeBuilder.last().appendln("        if (!val.isImmutable()) {throw new IllegalArgumentException(\"value is mutable\");}");
            if (!entity.isEmbedded() && entity.isTransactional()) {
                codeBuilder.last().appendln("        final " + rawType + " existing = " + AdmXbufGenerator.fieldFldVarName(field) + ".getRawValue();");
                codeBuilder.last().appendln("        if (val != existing) {");
                codeBuilder.last().appendln("            recordFieldUpdate(" + AdmXbufGenerator.fieldIdxFieldVarName(field) + ", existing != null ? existing.getValue() : null, val != null ? val.getValue() : null);");
                codeBuilder.last().appendln("        }");
            }
            codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldFldVarName(field) + ".setValue(val);");
            codeBuilder.last().appendln("        _isDirty=true;");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldSetterFromMethodName(field) + "(final long val) {");
            this.writeReadOnlyValidator(entity, codeBuilder);
            if (!entity.isEmbedded() && entity.isTransactional()) {
                codeBuilder.last().appendln("        final " + rawType + " existing = " + AdmXbufGenerator.fieldFldVarName(field) + ".getRawValue();");
                codeBuilder.last().appendln("        if (existing == null || existing.getValue() == null || val != Long.valueOf(existing.getValue())) {");
                codeBuilder.last().appendln("            recordFieldUpdate(" + AdmXbufGenerator.fieldIdxFieldVarName(field) + ", existing != null ? existing.getValue() : null, String.valueOf(val));");
                codeBuilder.last().appendln("        }");
            }
            codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldFldVarName(field) + ".setValueFrom(val);");
            codeBuilder.last().appendln("        _isDirty=true;");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            if (entity.getGenerateDeprecatedAccessors()) {
                codeBuilder.last().appendln();
                if (hasInterface) {
                    codeBuilder.last().appendln("    @Override");
                }
                codeBuilder.last().appendln("    @Deprecated");
                codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
                codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldSetterMethodName(field) + "AsLong(final long val) {");
                codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldSetterFromMethodName(field) + "(val);");
                codeBuilder.last().appendln("        }");
            }
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public <T extends %{com.neeve.lang.XString}> T " + AdmXbufGenerator.fieldGetterToMethodName(field) + "(final %{com.neeve.lang.XString}.Factory<T> factory) {");
            codeBuilder.last().appendln("        if (" + AdmXbufGenerator.fieldFldVarName(field) + ".hasValue()) {");
            codeBuilder.last().appendln("            final T to = factory.create(false);");
            codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldFldVarName(field) + ".getValueTo(to);");
            codeBuilder.last().appendln("            return to;");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        else {");
            codeBuilder.last().appendln("            return null;");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            if (entity.getGenerateDeprecatedAccessors()) {
                codeBuilder.newCodeSegment();
                codeBuilder.last().appendln();
                if (hasInterface) {
                    codeBuilder.last().appendln("    @Override");
                }
                codeBuilder.last().appendln("    @Deprecated");
                codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
                codeBuilder.last().appendln("    " + finalModifier + "public <T extends %{com.neeve.lang.XString}> T " + AdmXbufGenerator.fieldCopyFactoryMethodName(field) + "(final %{com.neeve.lang.XString}.Factory<T> factory) {");
                codeBuilder.last().appendln("        return " + AdmXbufGenerator.fieldGetterToMethodName(field) + "(factory);");
                codeBuilder.last().appendln("    }");
                codeBuilder.newCodeSegment();
                codeBuilder.last().appendln();
                if (hasInterface) {
                    codeBuilder.last().appendln("    @Override");
                }
                codeBuilder.last().appendln("    @Deprecated");
                codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
                codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldSetterMethodName(field) + "Value(final String val){");
                codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldSetterMethodName(field) + "(val);");
                codeBuilder.last().appendln("    }");
                codeBuilder.newCodeSegment();
                codeBuilder.last().appendln();
                if (hasInterface) {
                    codeBuilder.last().appendln("    @Override");
                }
                codeBuilder.last().appendln("    @Deprecated");
                codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
                codeBuilder.last().appendln("    " + finalModifier + "public String " + AdmXbufGenerator.fieldGetterMethodName(field) + "Value() {");
                codeBuilder.last().appendln("        return " + AdmXbufGenerator.fieldGetterMethodName(field) + "();");
                codeBuilder.last().appendln("    }");
            }
        }
        if (primitiveType.hasRawValue()) {
            rawType = "%{" + primitiveType.getRawValueType() + "}";
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldSetterFromMethodName(field) + "(final " + rawType + " val) {");
            this.writeReadOnlyValidator(entity, codeBuilder);
            if (!entity.isEmbedded() && entity.isTransactional()) {
                codeBuilder.last().appendln("        final " + rawType + " existing = " + AdmXbufGenerator.fieldFldVarName(field) + ".getRawValue();");
                codeBuilder.last().appendln("        if (val != existing) {");
                codeBuilder.last().appendln("            recordFieldUpdate(" + AdmXbufGenerator.fieldIdxFieldVarName(field) + ", existing != null ? existing.getValue() : null, val != null ? val.getValue() : null);");
                codeBuilder.last().appendln("        }");
            }
            if (primitiveType == AdmPrimitive.Type.String) {
                codeBuilder.last().appendln("        if (val != null && !val.isNull()) {");
            } else {
                codeBuilder.last().appendln("        if (val != null) {");
            }
            codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldFldVarName(field) + ".setValueFrom(val);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        else {");
            codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldFldVarName(field) + ".clearValue();");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        _isDirty=true;");
            codeBuilder.last().appendln("    }");
            if (entity.getGenerateDeprecatedAccessors()) {
                codeBuilder.newCodeSegment();
                codeBuilder.last().appendln();
                if (hasInterface) {
                    codeBuilder.last().appendln("    @Override");
                }
                codeBuilder.last().appendln("    @Deprecated");
                codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
                codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldSetterMethodName(field) + "AsRaw(final " + rawType + " val) {");
                codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldSetterFromMethodName(field) + "(val);");
                codeBuilder.last().appendln("    }");
            }
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldGetterToMethodName(field) + "(final " + rawType + " val) {");
            codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldFldVarName(field) + ".getValueTo(val);");
            codeBuilder.last().appendln("    }");
            if (entity.getGenerateDeprecatedAccessors()) {
                codeBuilder.newCodeSegment();
                codeBuilder.last().appendln();
                if (hasInterface) {
                    codeBuilder.last().appendln("    @Override");
                }
                codeBuilder.last().appendln("    @Deprecated");
                codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
                codeBuilder.last().appendln("    " + finalModifier + "public " + rawType + " " + AdmXbufGenerator.fieldGetterMethodName(field) + "AsRaw() {");
                codeBuilder.last().appendln("        return " + AdmXbufGenerator.fieldGetterUnsafeMethodName(field) + "();");
                codeBuilder.last().appendln("    }");
            }
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public " + rawType + " " + AdmXbufGenerator.fieldGetterUnsafeMethodName(field) + "() {");
            codeBuilder.last().appendln("        return " + AdmXbufGenerator.fieldFldVarName(field) + ".getRawValue();");
            codeBuilder.last().appendln("    }");
        }
        if ((xbufFieldType = this.getXbufFieldType(field.getType(), protoXbufGenCompatibility)) != null) {
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldSetterFromMethodName(field) + "(final " + xbufFieldType + " val) {");
            this.writeReadOnlyValidator(entity, codeBuilder);
            codeBuilder.last().appendln("        if (val == null) {");
            codeBuilder.last().appendln("            throw new IllegalArgumentException(\"val cannot be null\");");
            codeBuilder.last().appendln("        }");
            if (!entity.isEmbedded() && entity.isTransactional()) {
                codeBuilder.last().appendln("        final " + javaPrimitive + " existing = " + AdmXbufGenerator.fieldGetterMethodName(field) + "();");
                codeBuilder.last().appendln("        if (val.getValue() != existing) {");
                codeBuilder.last().appendln("            recordFieldUpdate(" + AdmXbufGenerator.fieldIdxFieldVarName(field) + ", existing, val.getValue());");
                codeBuilder.last().appendln("        }");
            }
            codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldFldVarName(field) + ".setValueFrom(val);");
            codeBuilder.last().appendln("        _isDirty=true;");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public " + xbufFieldType + " " + AdmXbufGenerator.fieldGetterMethodName(field) + "Field() {");
            codeBuilder.last().appendln("        return " + AdmXbufGenerator.fieldFldVarName(field) + ";");
            codeBuilder.last().appendln("    }");
        }
        this.writeOptionalGetterMethods(entity, field, codeBuilder);
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public boolean " + AdmXbufGenerator.fieldCheckerMethodName(field) + "() {");
        codeBuilder.last().appendln("        return " + AdmXbufGenerator.fieldFldVarName(field) + ".hasValue();");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldClearerMethodName(field) + "() {");
        if (primitiveType == AdmPrimitive.Type.String) {
            codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldFldVarName(field) + ".clearValue();");
        } else if (field.isPinned()) {
            switch (primitiveType) {
                case Byte: {
                    codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldFldVarName(field) + ".setValue((byte)0);");
                    break;
                }
                case Char: {
                    codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldFldVarName(field) + ".setValue((char)0);");
                    break;
                }
                case Short: {
                    codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldFldVarName(field) + ".setValue((short)0);");
                    break;
                }
                case Integer: {
                    codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldFldVarName(field) + ".setValue(0);");
                    break;
                }
                case Long: {
                    codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldFldVarName(field) + ".setValue(0l);");
                    break;
                }
                case Float: {
                    codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldFldVarName(field) + ".setValue((float)0.0);");
                    break;
                }
                case Double: {
                    codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldFldVarName(field) + ".setValue(0.0);");
                    break;
                }
                case Boolean: {
                    codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldFldVarName(field) + ".setValue(false);");
                    break;
                }
                case Date: 
                case Currency: 
                case UUID: {
                    codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldFldVarName(field) + ".setValue(null);");
                    break;
                }
                case String: {
                    throw new IllegalStateException("Internal Error");
                }
            }
        } else {
            codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldFldVarName(field) + ".clearValue();");
        }
        codeBuilder.last().appendln("        _isDirty = true;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeUserPrimitiveArrayFieldMethods(AdmEntity entity, AdmField field, AdmEncodingType protoXbufGenCompatibility, boolean generateArrayGetterEmptyIfNull, AdmSourceCodeBuilder codeBuilder) {
        AdmPrimitiveArray fieldType = (AdmPrimitiveArray)field.getType();
        String javaPrimitive = fieldType.getType().getTemplatedPrimitiveTypeName();
        String iteratorType = fieldType.getType().getTemplatedXIteratorType();
        String zgIteratorType = fieldType.getType().getTemplatedZGXIteratorType();
        boolean hasInterface = !entity.isEmbedded() || entity.getGenerateEmbeddedEntityInterfaces();
        String finalModifier = AdmXbufGenerator.fieldAccessorFinalModifier(entity);
        if (protoXbufGenCompatibility == AdmEncodingType.Protobuf) {
            String fieldBufferType = null;
            String xbufFieldType = null;
            switch (fieldType.getType()) {
                case Boolean: {
                    fieldBufferType = "%{com.neeve.xbuf.XbufRepeatedBooleanFieldBuffer}";
                    xbufFieldType = "%{com.neeve.xbuf.XbufVariableBooleanListField}";
                    break;
                }
                case Byte: {
                    fieldBufferType = "%{com.neeve.xbuf.XbufRepeatedByteFieldBuffer}";
                    xbufFieldType = "%{com.neeve.xbuf.XbufVariableByteListField}";
                    break;
                }
                case Char: {
                    fieldBufferType = "%{com.neeve.xbuf.XbufRepeatedCharFieldBuffer}";
                    xbufFieldType = "%{com.neeve.xbuf.XbufVariableCharListField}";
                    break;
                }
                case Currency: {
                    fieldBufferType = null;
                    break;
                }
                case Date: {
                    fieldBufferType = "%{com.neeve.xbuf.XbufRepeatedDateFieldBuffer}";
                    xbufFieldType = "%{com.neeve.xbuf.XbufVariableDateListField}";
                    break;
                }
                case Double: {
                    fieldBufferType = "%{com.neeve.xbuf.XbufRepeatedDoubleFieldBuffer}";
                    xbufFieldType = "%{com.neeve.xbuf.XbufDoubleListField}";
                    break;
                }
                case Float: {
                    fieldBufferType = "%{com.neeve.xbuf.XbufRepeatedFloatFieldBuffer}";
                    xbufFieldType = "%{com.neeve.xbuf.XbufFloatListField}";
                    break;
                }
                case Integer: {
                    fieldBufferType = "%{com.neeve.xbuf.XbufRepeatedIntFieldBuffer}";
                    xbufFieldType = "%{com.neeve.xbuf.XbufVariableIntListField}";
                    break;
                }
                case Long: {
                    fieldBufferType = "%{com.neeve.xbuf.XbufRepeatedLongFieldBuffer}";
                    xbufFieldType = "%{com.neeve.xbuf.XbufVariableLongListField}";
                    break;
                }
                case Short: {
                    fieldBufferType = "%{com.neeve.xbuf.XbufRepeatedShortFieldBuffer}";
                    xbufFieldType = "%{com.neeve.xbuf.XbufVariableShortListField}";
                    break;
                }
                case String: {
                    fieldBufferType = "%{com.neeve.xbuf.XbufRepeatedStringFieldBuffer}";
                    xbufFieldType = "%{com.neeve.xbuf.XbufStringListField}";
                    break;
                }
                case UUID: {
                    fieldBufferType = null;
                }
            }
            if (fieldBufferType != null) {
                if (field.isDeprecated()) {
                    this.writeDeprecationComment("    ", field, codeBuilder);
                } else {
                    codeBuilder.last().appendln("    /**");
                    codeBuilder.last().appendln("     * Returns a wrapped buffer that can be used for doing an efficient bulk");
                    codeBuilder.last().appendln("     * copy from an XIterator returned for this field.");
                    codeBuilder.last().appendln("     * <p>");
                    codeBuilder.last().appendln("     * For example the following would result in a bulk transfer from this message<br>");
                    codeBuilder.last().appendln("     * <pre>");
                    codeBuilder.last().appendln("     * " + fieldBufferType + " preallocated = " + entity.getTemplatedJavaTypeName() + "." + AdmXbufGenerator.fieldCreateFieldBufferMethodName(field) + "(1024, true);");
                    codeBuilder.last().appendln("     * // The following would then result in a buffer copy without any iteration:");
                    codeBuilder.last().appendln("     * preallocated.setValue(inboundMessage." + AdmXbufGenerator.fieldGetterMethodName(field) + "Iterator());");
                    codeBuilder.last().appendln("     * // The preallocated bulk copied values can then be transfered to an outbound message:");
                    codeBuilder.last().appendln("     * outboundMessage." + AdmXbufGenerator.fieldSetterMethodName(field) + ".setValueFrom(preallocated);");
                    codeBuilder.last().appendln("     * </pre>");
                    codeBuilder.last().appendln("     * <p>");
                    codeBuilder.last().appendln("     * Bulk transfer from the backing buffer may only possible between two fields");
                    codeBuilder.last().appendln("     * with the same id (protobuf tag) because the bulk transfered bytes are in protobuf wire");
                    codeBuilder.last().appendln("     * format which for most repeated fields encode the field's tag for each element.");
                    codeBuilder.last().appendln("     *");
                    codeBuilder.last().appendln("     * @param initialBufferLength the initial size of the underlying backing buffer.");
                    codeBuilder.last().appendln("     * @param isNative Whether the backing buffer should be a native or heap buffer.");
                    codeBuilder.last().appendln("     */");
                }
                codeBuilder.last().appendln("    final static public " + fieldBufferType + " " + AdmXbufGenerator.fieldCreateFieldBufferMethodName(field) + "(final int initialBufferLength, final boolean isNative) {");
                if (!fieldType.isWrappedPrimitive()) {
                    String allowNulls = protoXbufGenCompatibility == AdmEncodingType.Protobuf ? "false" : "true";
                    String nullCheckPolicy = "%{com.neeve.xbuf.XbufField}.NullValueCheckPolicy.";
                    switch (entity.getNullPrimitiveArrayElementPolicy()) {
                        case Ignore: {
                            nullCheckPolicy = nullCheckPolicy + "Ignore";
                            break;
                        }
                        case IgnoreUnlessSupported: {
                            if (protoXbufGenCompatibility == AdmEncodingType.Protobuf) {
                                nullCheckPolicy = nullCheckPolicy + "Ignore";
                                break;
                            }
                            nullCheckPolicy = nullCheckPolicy + "Unchecked";
                            break;
                        }
                        case Throw: {
                            nullCheckPolicy = nullCheckPolicy + "Throw";
                            break;
                        }
                    }
                    codeBuilder.last().appendln("        return " + xbufFieldType + ".createFieldBuffer((short)" + field.getId() + ", " + allowNulls + ", " + nullCheckPolicy + ", initialBufferLength, isNative);");
                } else {
                    codeBuilder.last().appendln("        return " + xbufFieldType + ".createFieldBuffer((short)" + field.getId() + ", initialBufferLength, isNative);");
                }
                codeBuilder.last().appendln("    }");
            }
        }
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonSetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldSetterMethodName(field) + "(final " + javaPrimitive + "[] val) {");
        this.writeReadOnlyValidator(entity, codeBuilder);
        if (!entity.isEmbedded() && entity.isTransactional()) {
            codeBuilder.last().appendln("        if (val != " + AdmXbufGenerator.fieldGetterMethodName(field) + "()) {");
            codeBuilder.last().appendln("            recordFieldUpdate(" + AdmXbufGenerator.fieldFidVarName(field) + ", " + AdmXbufGenerator.fieldGetterMethodName(field) + "());");
            codeBuilder.last().appendln("        }");
        }
        codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldFldVarName(field) + ".clearValue();");
        codeBuilder.last().appendln("        if (val != null && val.length > 0) {");
        codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldFldVarName(field) + ".setValues(val);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        _isDirty = true;");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldSetterMethodName(field) + "From(final " + iteratorType + " val) {");
        this.writeReadOnlyValidator(entity, codeBuilder);
        if (!entity.isEmbedded() && entity.isTransactional()) {
            codeBuilder.last().appendln("        recordFieldUpdate(" + AdmXbufGenerator.fieldFidVarName(field) + ", " + AdmXbufGenerator.fieldGetterMethodName(field) + "());");
        }
        codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldFldVarName(field) + ".clearValue();");
        codeBuilder.last().appendln("        if (val != null && val.toFirst().hasNext()) {");
        codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldFldVarName(field) + ".setValuesFrom(val);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        _isDirty = true;");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldAdderMethodName(field) + "(final " + javaPrimitive + " val) {");
        this.writeReadOnlyValidator(entity, codeBuilder);
        if (!entity.isEmbedded() && entity.isTransactional()) {
            codeBuilder.last().appendln("        recordFieldUpdate(" + AdmXbufGenerator.fieldFidVarName(field) + ", " + AdmXbufGenerator.fieldGetterMethodName(field) + "());");
        }
        codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldFldVarName(field) + ".addValue(val);");
        codeBuilder.last().appendln("        _isDirty = true;");
        codeBuilder.last().appendln("    }");
        this.writeFieldFluentMethods(entity, field, codeBuilder);
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonGetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public " + javaPrimitive + "[] " + AdmXbufGenerator.fieldGetterMethodName(field) + "() {");
        if (generateArrayGetterEmptyIfNull) {
            codeBuilder.last().appendln("        return " + AdmXbufGenerator.fieldGetterMethodName(field) + "EmptyIfNull();");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    final private " + javaPrimitive + "[] " + AdmXbufGenerator.fieldGetterMethodName(field) + "Core() {");
        }
        switch (fieldType.getType()) {
            case Byte: 
            case Char: 
            case Short: 
            case Integer: 
            case Long: 
            case Float: 
            case Double: 
            case Boolean: 
            case Date: {
                if (protoXbufGenCompatibility == null || protoXbufGenCompatibility == AdmEncodingType.Xbuf) {
                    codeBuilder.last().appendln("        return " + AdmXbufGenerator.fieldFldVarName(field) + ".getValue();");
                    break;
                }
                codeBuilder.last().appendln("        if (" + AdmXbufGenerator.fieldFldVarName(field) + ".getValuesOrNullIfNotSet() != null) {");
                codeBuilder.last().appendln("            return " + AdmXbufGenerator.fieldFldVarName(field) + ".getValuesAsArray();");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        return null;");
                break;
            }
            case String: 
            case Currency: {
                codeBuilder.last().appendln("        if (" + AdmXbufGenerator.fieldFldVarName(field) + ".getValuesOrNullIfNotSet() != null) {");
                codeBuilder.last().appendln("            return " + AdmXbufGenerator.fieldFldVarName(field) + ".getValuesAsArray();");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        return null;");
                break;
            }
            case UUID: {
                codeBuilder.last().appendln("        return " + AdmXbufGenerator.fieldFldVarName(field) + ".getValue();");
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported primitive array type '" + (Object)((Object)fieldType.getType()) + "'");
            }
        }
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public " + javaPrimitive + "[] " + AdmXbufGenerator.fieldGetterMethodName(field) + "EmptyIfNull() {");
        if (generateArrayGetterEmptyIfNull) {
            codeBuilder.last().appendln("        final " + javaPrimitive + "[] val = " + AdmXbufGenerator.fieldGetterMethodName(field) + "Core();");
        } else {
            codeBuilder.last().appendln("        final " + javaPrimitive + "[] val = " + AdmXbufGenerator.fieldGetterMethodName(field) + "();");
        }
        switch (fieldType.getType()) {
            case Byte: {
                codeBuilder.last().appendln("        return val != null ? val : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_BYTE_ARRAY;");
                break;
            }
            case Char: {
                codeBuilder.last().appendln("        return val != null ? val : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_CHAR_ARRAY;");
                break;
            }
            case Short: {
                codeBuilder.last().appendln("        return val != null ? val : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_SHORT_ARRAY;");
                break;
            }
            case Integer: {
                codeBuilder.last().appendln("        return val != null ? val : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_INT_ARRAY;");
                break;
            }
            case Long: {
                codeBuilder.last().appendln("        return val != null ? val : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_LONG_ARRAY;");
                break;
            }
            case Float: {
                codeBuilder.last().appendln("        return val != null ? val : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_FLOAT_ARRAY;");
                break;
            }
            case Double: {
                codeBuilder.last().appendln("        return val != null ? val : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_DOUBLE_ARRAY;");
                break;
            }
            case Boolean: {
                codeBuilder.last().appendln("        return val != null ? val : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_BOOLEAN_ARRAY;");
                break;
            }
            case UUID: {
                codeBuilder.last().appendln("        return val != null ? val : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_UUID_ARRAY;");
                break;
            }
            case Date: {
                codeBuilder.last().appendln("        return val != null ? val : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_DATE_ARRAY;");
                break;
            }
            case String: 
            case Currency: {
                codeBuilder.last().appendln("        return val != null ? val : " + AdmXbufGenerator.fieldFldVarName(field) + ".getValuesAsArray();");
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported primitive array type '" + (Object)((Object)fieldType.getType()) + "'");
            }
        }
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public " + zgIteratorType + " " + AdmXbufGenerator.fieldGetterMethodName(field) + "Iterator() {");
        codeBuilder.last().appendln("        return " + AdmXbufGenerator.fieldFldVarName(field) + ".getValueIterator();");
        codeBuilder.last().appendln("    }");
        this.writeOptionalGetterMethods(entity, field, codeBuilder);
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldClearerMethodName(field) + "() {");
        codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldFldVarName(field) + ".clearValue();");
        codeBuilder.last().appendln("        _isDirty = true;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeUserEntityArrayFieldMethods(AdmEntity entity, AdmField field, AdmEncodingType protoXbufGenCompatibility, boolean generatArrayFieldsEmptyIfNull, AdmSourceCodeBuilder codeBuilder) {
        AdmEntityArray fieldType = (AdmEntityArray)field.getType();
        boolean hasInterface = !entity.isEmbedded() || entity.getGenerateEmbeddedEntityInterfaces();
        String finalModifier = AdmXbufGenerator.fieldAccessorFinalModifier(entity);
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonSetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldSetterMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " val) {");
        this.writeReadOnlyValidator(entity, codeBuilder);
        if (entity.getNullEntityArrayElementPolicy() == AdmEntity.NullArrayElementPolicy.Throw) {
            codeBuilder.last().appendln("        if (val != null) {");
            codeBuilder.last().appendln("            for (int i = 0; i < val.length; i++) {");
            codeBuilder.last().appendln("                if (val[i] == null) {");
            codeBuilder.last().appendln("                    throw new NullPointerException(\"Can't set array field with a null value at index '\" + i + \"'\");");
            codeBuilder.last().appendln("                }");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
        }
        codeBuilder.last().appendln("        final %{com.neeve.lang.XIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + "> existing = " + AdmXbufGenerator.fieldFldVarName(field) + ".getValueIterator(true);");
        codeBuilder.last().appendln("        if (existing != null && existing.hasNext()) {");
        codeBuilder.last().appendln("            while (existing.hasNext()) {");
        codeBuilder.last().appendln("                final " + fieldType.getType().getTemplatedJavaTypeName() + " v = existing.next();");
        codeBuilder.last().appendln("                if (v != null) {");
        codeBuilder.last().appendln("                    v.dispose();");
        codeBuilder.last().appendln("                }");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        if (!entity.isEmbedded() && entity.isTransactional()) {
            codeBuilder.last().appendln("        if (val != " + AdmXbufGenerator.fieldGetterMethodName(field) + "()) {");
            codeBuilder.last().appendln("            recordFieldUpdate(" + AdmXbufGenerator.fieldFidVarName(field) + ", " + AdmXbufGenerator.fieldGetterMethodName(field) + "());");
            codeBuilder.last().appendln("        }");
        }
        if (entity.getNullEntityArrayElementPolicy() != AdmEntity.NullArrayElementPolicy.Throw && (protoXbufGenCompatibility != AdmEncodingType.Xbuf || entity.getNullEntityArrayElementPolicy() == AdmEntity.NullArrayElementPolicy.Ignore)) {
            codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldFldVarName(field) + ".clearValue();");
            codeBuilder.last().appendln("        if (val != null) {");
            codeBuilder.last().appendln("            for (int i = 0; i < val.length; i++) {");
            codeBuilder.last().appendln("                if (val[i] != null) {");
            codeBuilder.last().appendln("                    " + AdmXbufGenerator.fieldFldVarName(field) + ".addValue(val[i]);");
            codeBuilder.last().appendln("                }");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
        } else {
            codeBuilder.last().appendln("        if (val != null) {");
            codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldFldVarName(field) + ".setValues(val);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        else {");
            codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldFldVarName(field) + ".clearValue();");
            codeBuilder.last().appendln("        }");
        }
        codeBuilder.last().appendln("        _isDirty = true;");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        codeBuilder.last().appendln("    " + finalModifier + "private void " + AdmXbufGenerator.fieldSetterFromMethodName(field) + "(final %{com.neeve.lang.XIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + "> val, final boolean acquire) {");
        this.writeReadOnlyValidator(entity, codeBuilder);
        if (entity.getNullEntityArrayElementPolicy() == AdmEntity.NullArrayElementPolicy.Throw) {
            codeBuilder.last().appendln("        if (val != null && val.toFirst().hasNext()) {");
            codeBuilder.last().appendln("            int i = 0;");
            codeBuilder.last().appendln("            while (val.hasNext()) {");
            codeBuilder.last().appendln("                if (val.next() == null) {");
            codeBuilder.last().appendln("                    throw new NullPointerException(\"Can't set array field with a null value.\");");
            codeBuilder.last().appendln("                }");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
        }
        codeBuilder.last().appendln("        final %{com.neeve.lang.XIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + "> existing = " + AdmXbufGenerator.fieldFldVarName(field) + ".getValueIterator(true);");
        codeBuilder.last().appendln("        if (existing != null && existing.hasNext()) {");
        codeBuilder.last().appendln("            while (existing.hasNext()) {");
        codeBuilder.last().appendln("                final " + fieldType.getType().getTemplatedJavaTypeName() + " v = existing.next();");
        codeBuilder.last().appendln("                if (v != null) {");
        codeBuilder.last().appendln("                    v.dispose();");
        codeBuilder.last().appendln("                }");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        if (!entity.isEmbedded() && entity.isTransactional()) {
            codeBuilder.last().appendln("        recordFieldUpdate(" + AdmXbufGenerator.fieldFidVarName(field) + ", " + AdmXbufGenerator.fieldGetterMethodName(field) + "());");
        }
        codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldFldVarName(field) + ".clearValue();");
        codeBuilder.last().appendln("        if (val != null && val.toFirst().hasNext()) {");
        codeBuilder.last().appendln("            while(val.hasNext()) {");
        codeBuilder.last().appendln("                final " + fieldType.getType().getTemplatedJavaTypeName() + " v = val.next();");
        codeBuilder.last().appendln("                if (v != null) {");
        codeBuilder.last().appendln("                    if (acquire) {");
        codeBuilder.last().appendln("                        v.acquire();");
        codeBuilder.last().appendln("                    }");
        codeBuilder.last().appendln("                    " + AdmXbufGenerator.fieldFldVarName(field) + ".addValue(v);");
        codeBuilder.last().appendln("                }");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        _isDirty = true;");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldSetterFromMethodName(field) + "(final %{com.neeve.lang.XIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + "> val) {");
        codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldSetterFromMethodName(field) + "(val, false);");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldLenderMethodName(field) + "From(final %{com.neeve.lang.XIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + "> val) {");
        codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldSetterFromMethodName(field) + "(val, true);");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldLenderMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " val) {");
        codeBuilder.last().appendln("        if (val != null) {");
        codeBuilder.last().appendln("            for (int i = 0; i < val.length; i++) {");
        codeBuilder.last().appendln("                if (val[i] != null) {");
        codeBuilder.last().appendln("                    val[i].acquire();");
        codeBuilder.last().appendln("                }");
        if (entity.getNullEntityArrayElementPolicy() == AdmEntity.NullArrayElementPolicy.Throw) {
            codeBuilder.last().appendln("                else {");
            codeBuilder.last().appendln("                    for (int j = 0; j < i; j++) {");
            codeBuilder.last().appendln("                        val[j].dispose();");
            codeBuilder.last().appendln("                    }");
            codeBuilder.last().appendln("                    throw new NullPointerException(\"Can't set array field with a null value at index '\" + i + \"'\");");
            codeBuilder.last().appendln("                }");
        }
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldSetterMethodName(field) + "(val);");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonSetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldAdderMethodName(field) + "(final " + fieldType.getType().getTemplatedJavaTypeName() + " val) {");
        this.writeReadOnlyValidator(entity, codeBuilder);
        if (entity.getNullEntityArrayElementPolicy() == AdmEntity.NullArrayElementPolicy.Throw) {
            codeBuilder.last().appendln("        if (val == null) {");
            codeBuilder.last().appendln("            throw new NullPointerException(\"Can't set array field with a null value.\");");
            codeBuilder.last().appendln("        }");
        } else if (protoXbufGenCompatibility == AdmEncodingType.Protobuf || entity.getNullEntityArrayElementPolicy() == AdmEntity.NullArrayElementPolicy.Ignore) {
            codeBuilder.last().appendln("        if (val == null) {");
            codeBuilder.last().appendln("            return;");
            codeBuilder.last().appendln("        }");
        }
        if (!entity.isEmbedded() && entity.isTransactional()) {
            codeBuilder.last().appendln("            recordFieldUpdate(" + AdmXbufGenerator.fieldFidVarName(field) + ", " + AdmXbufGenerator.fieldGetterMethodName(field) + "());");
        }
        codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldFldVarName(field) + ".addValue(val);");
        codeBuilder.last().appendln("        _isDirty = true;");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonSetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldLenderMethodName(field) + "(final " + fieldType.getType().getTemplatedJavaTypeName() + " val) {");
        codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldAdderMethodName(field) + "(val);");
        codeBuilder.last().appendln("        if (val != null) val.acquire();");
        codeBuilder.last().appendln("    }");
        this.writeFieldFluentMethods(entity, field, codeBuilder);
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonGetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmXbufGenerator.fieldGetterMethodName(field) + "() {");
        if (generatArrayFieldsEmptyIfNull) {
            codeBuilder.last().appendln("        return " + AdmXbufGenerator.fieldGetterMethodName(field) + "EmptyIfNull();");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    final private " + fieldType.getTemplatedJavaTypeName() + " " + AdmXbufGenerator.fieldGetterMethodName(field) + "Core() {");
        }
        codeBuilder.last().appendln("        if (" + AdmXbufGenerator.fieldFldVarName(field) + ".getValuesOrNullIfNotSet() != null) {");
        codeBuilder.last().appendln("            return " + AdmXbufGenerator.fieldFldVarName(field) + ".getValuesAsArray();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        return null;");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmXbufGenerator.fieldGetterMethodName(field) + "EmptyIfNull() {");
        if (generatArrayFieldsEmptyIfNull) {
            codeBuilder.last().appendln("        final " + fieldType.getTemplatedJavaTypeName() + " val = " + AdmXbufGenerator.fieldGetterMethodName(field) + "Core();");
        } else {
            codeBuilder.last().appendln("        final " + fieldType.getTemplatedJavaTypeName() + " val = " + AdmXbufGenerator.fieldGetterMethodName(field) + "();");
        }
        codeBuilder.last().appendln("        return val != null ? val : " + AdmXbufGenerator.fieldFldVarName(field) + ".getValuesAsArray();");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public %{com.neeve.lang.XIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + "> " + AdmXbufGenerator.fieldGetterMethodName(field) + "Iterator() {");
        codeBuilder.last().appendln("        return " + AdmXbufGenerator.fieldFldVarName(field) + ".getValueIterator(false, " + AdmXbufGenerator.fieldIteratedValueNotificationReceiverFieldVarName(field) + ");");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmXbufGenerator.fieldTakerMethodName(field) + "() {");
        codeBuilder.last().appendln("        final " + fieldType.getTemplatedJavaTypeName() + " val = " + AdmXbufGenerator.fieldGetterMethodName(field) + "();");
        codeBuilder.last().appendln("        if (val != null) {");
        codeBuilder.last().appendln("            for (int i = 0; i < val.length; i++) {");
        codeBuilder.last().appendln("                if (val[i] != null) {");
        codeBuilder.last().appendln("                    val[i].acquire();");
        codeBuilder.last().appendln("                }");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        return val;");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        this.writeOptionalGetterMethods(entity, field, codeBuilder);
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldClearerMethodName(field) + "() {");
        codeBuilder.last().appendln("        final %{com.neeve.lang.XIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + "> iterator = " + AdmXbufGenerator.fieldFldVarName(field) + ".getValueIterator(true);");
        codeBuilder.last().appendln("        if (iterator != null && iterator.hasNext()) {");
        codeBuilder.last().appendln("            while (iterator.hasNext()) {");
        codeBuilder.last().appendln("                final " + fieldType.getType().getTemplatedJavaTypeName() + " v = iterator.next();");
        codeBuilder.last().appendln("                if (v != null) {");
        codeBuilder.last().appendln("                    v.dispose();");
        codeBuilder.last().appendln("                }");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldFldVarName(field) + ".clearValue();");
        codeBuilder.last().appendln("        _isDirty = true;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeUserEnumerationArrayFieldMethods(AdmEntity entity, AdmField field, AdmEncodingType protoXbufGenCompatibility, boolean generateArrayGetterEmptyIfNull, AdmSourceCodeBuilder codeBuilder) {
        AdmEnumerationArray fieldType = (AdmEnumerationArray)field.getType();
        boolean hasInterface = !entity.isEmbedded() || entity.getGenerateEmbeddedEntityInterfaces();
        String finalModifier = AdmXbufGenerator.fieldAccessorFinalModifier(entity);
        codeBuilder.newCodeSegment();
        if (protoXbufGenCompatibility == AdmEncodingType.Protobuf) {
            String fieldBufferType = "%{com.neeve.xbuf.XbufRepeatedEnumFieldBuffer}<" + fieldType.getComponentType().getTemplatedJavaTypeName() + ">";
            if (field.isDeprecated()) {
                this.writeDeprecationComment("    ", field, codeBuilder);
            } else {
                codeBuilder.last().appendln("    /**");
                codeBuilder.last().appendln("     * Returns a wrapped buffer that can be used for doing an efficient bulk");
                codeBuilder.last().appendln("     * copy from an XIterator returned for this field.");
                codeBuilder.last().appendln("     * <p>");
                codeBuilder.last().appendln("     * For example the following would result in a bulk transfer from this message<br>");
                codeBuilder.last().appendln("     * <code>");
                codeBuilder.last().appendln("     * " + fieldBufferType + " preallocated = " + entity.getTemplatedJavaTypeName() + "." + AdmXbufGenerator.fieldCreateFieldBufferMethodName(field) + "(1024, true);");
                codeBuilder.last().appendln("     * // The following would then result in a buffer copy without any iteration:");
                codeBuilder.last().appendln("     * preallocated.setValue(inboundMessage." + AdmXbufGenerator.fieldGetterMethodName(field) + "Iterator());");
                codeBuilder.last().appendln("     * // The preallocated bulk copied values can then be transfered to an outbound message:");
                codeBuilder.last().appendln("     * outboundMessage." + AdmXbufGenerator.fieldSetterMethodName(field) + ".setValueFrom(preallocated);");
                codeBuilder.last().appendln("     * </code>");
                codeBuilder.last().appendln("     * <p>");
                codeBuilder.last().appendln("     * Bulk transfer from the backing buffer may only possible between two fields");
                codeBuilder.last().appendln("     * with the same id (protobuf tag) because the bulk transfered bytes are in protobuf wire");
                codeBuilder.last().appendln("     * format which for most repeated fields encoding the field tag.");
                codeBuilder.last().appendln("     *");
                codeBuilder.last().appendln("     * @param initialBufferLength the initial size of the underlying backing buffer.");
                codeBuilder.last().appendln("     * @param isNative Whether the backing buffer should be a native or heap buffer.");
                codeBuilder.last().appendln("     */");
            }
            codeBuilder.last().appendln("    final static public " + fieldBufferType + " " + AdmXbufGenerator.fieldCreateFieldBufferMethodName(field) + "(final int initialBufferLength, final boolean isNative) {");
            String allowNulls = protoXbufGenCompatibility == AdmEncodingType.Protobuf ? "false" : "true";
            String nullCheckPolicy = "%{com.neeve.xbuf.XbufField}.NullValueCheckPolicy.";
            switch (entity.getNullEntityArrayElementPolicy()) {
                case Ignore: {
                    nullCheckPolicy = nullCheckPolicy + "Ignore";
                    break;
                }
                case IgnoreUnlessSupported: {
                    if (protoXbufGenCompatibility == AdmEncodingType.Protobuf) {
                        nullCheckPolicy = nullCheckPolicy + "Ignore";
                        break;
                    }
                    nullCheckPolicy = nullCheckPolicy + "Unchecked";
                    break;
                }
                case Throw: {
                    nullCheckPolicy = nullCheckPolicy + "Throw";
                    break;
                }
            }
            codeBuilder.last().appendln("        return %{com.neeve.xbuf.XbufRepeatedEnumFieldBuffer}.createFieldBuffer((short)" + field.getId() + ", " + allowNulls + ", " + nullCheckPolicy + ", initialBufferLength, isNative, " + AdmXbufGenerator.fieldAdapterFieldVarName(field) + ");");
            codeBuilder.last().appendln("    }");
        }
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonSetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldSetterMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " val) {");
        this.writeReadOnlyValidator(entity, codeBuilder);
        codeBuilder.last().appendln("        if ((val == null || val.length == 0) && " + AdmXbufGenerator.fieldFldVarName(field) + ".getValues().size() == 0) {");
        codeBuilder.last().appendln("            return;");
        codeBuilder.last().appendln("        }");
        if (!entity.isEmbedded() && entity.isTransactional()) {
            codeBuilder.last().appendln("        recordFieldUpdate(" + AdmXbufGenerator.fieldFidVarName(field) + ", " + AdmXbufGenerator.fieldGetterMethodName(field) + "());");
        }
        codeBuilder.last().appendln("        if (val != null && val.length > 0) {");
        codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldFldVarName(field) + ".setValues(val);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        else {");
        codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldFldVarName(field) + ".clearValue();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        _isDirty = true;");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldSetterFromMethodName(field) + "(final %{com.neeve.lang.XIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + "> val) {");
        this.writeReadOnlyValidator(entity, codeBuilder);
        if (!entity.isEmbedded() && entity.isTransactional()) {
            codeBuilder.last().appendln("        recordFieldUpdate(" + AdmXbufGenerator.fieldFidVarName(field) + ", " + AdmXbufGenerator.fieldGetterMethodName(field) + "());");
        }
        codeBuilder.last().appendln("        if (val != null) {");
        codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldFldVarName(field) + ".setValuesFrom(val);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        else {");
        codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldFldVarName(field) + ".clearValue();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        _isDirty = true;");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonSetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldAdderMethodName(field) + "(final " + fieldType.getType().getTemplatedJavaTypeName() + " val) {");
        this.writeReadOnlyValidator(entity, codeBuilder);
        if (!entity.isEmbedded() && entity.isTransactional()) {
            codeBuilder.last().appendln("            recordFieldUpdate(" + AdmXbufGenerator.fieldFidVarName(field) + ", " + AdmXbufGenerator.fieldGetterMethodName(field) + "());");
        }
        codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldFldVarName(field) + ".addValue(val);");
        codeBuilder.last().appendln("        _isDirty = true;");
        codeBuilder.last().appendln("    }");
        this.writeFieldFluentMethods(entity, field, codeBuilder);
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        if (field.isDeprecated()) {
            this.writeDeprecationComment("    ", field, codeBuilder);
        } else {
            codeBuilder.last().appendln("    @Deprecated");
        }
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        if (protoXbufGenCompatibility == AdmEncodingType.Protobuf) {
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldSetterMethodName(field) + "List(final %{java.util.List}<" + fieldType.getType().getTemplatedJavaTypeName() + "> val) {");
            this.writeReadOnlyValidator(entity, codeBuilder);
            codeBuilder.last().appendln("        if ((val == null || val.isEmpty()) && " + AdmXbufGenerator.fieldFldVarName(field) + ".getValues().size() == 0) return;");
            if (!entity.isEmbedded() && entity.isTransactional()) {
                codeBuilder.last().appendln("            recordFieldUpdate(" + AdmXbufGenerator.fieldFidVarName(field) + ", " + AdmXbufGenerator.fieldGetterMethodName(field) + "());");
            }
            codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldClearerMethodName(field) + "();");
            codeBuilder.last().appendln("        if (val != null && val.size() > 0) {");
            codeBuilder.last().appendln("            for(int i = 0; i < val.size(); i++) {");
            codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldFldVarName(field) + ".addValue(val.get(i));");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        _isDirty = true;");
            codeBuilder.last().appendln("    }");
        } else {
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldSetterMethodName(field) + "List(final %{java.util.List}<" + fieldType.getType().getTemplatedJavaTypeName() + "> val) {");
            this.writeReadOnlyValidator(entity, codeBuilder);
            codeBuilder.last().appendln("        throw new UnsupportedOperationException(\"" + AdmXbufGenerator.fieldSetterMethodName(field) + "List is currently only supported for xbuf classes generated with Protobuf compatibility\");");
            codeBuilder.last().appendln("    }");
        }
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonGetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmXbufGenerator.fieldGetterMethodName(field) + "() {");
        if (generateArrayGetterEmptyIfNull) {
            codeBuilder.last().appendln("        return " + AdmXbufGenerator.fieldGetterMethodName(field) + "EmptyIfNull();");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("    final private " + fieldType.getTemplatedJavaTypeName() + " " + AdmXbufGenerator.fieldGetterMethodName(field) + "Core() {");
        }
        codeBuilder.last().appendln("        if (" + AdmXbufGenerator.fieldFldVarName(field) + ".getValues().size() > 0) {");
        codeBuilder.last().appendln("            return " + AdmXbufGenerator.fieldFldVarName(field) + ".getValuesAsArray();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        return null;");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmXbufGenerator.fieldGetterMethodName(field) + "EmptyIfNull() {");
        if (generateArrayGetterEmptyIfNull) {
            codeBuilder.last().appendln("        final " + fieldType.getTemplatedJavaTypeName() + " val = " + AdmXbufGenerator.fieldGetterMethodName(field) + "Core();");
        } else {
            codeBuilder.last().appendln("        final " + fieldType.getTemplatedJavaTypeName() + " val = " + AdmXbufGenerator.fieldGetterMethodName(field) + "();");
        }
        codeBuilder.last().appendln("        return val != null ? val : " + fieldType.getType().getTemplatedJavaTypeName() + ".EMPTY_ARRAY;");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        if (protoXbufGenCompatibility == AdmEncodingType.Protobuf) {
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public %{com.neeve.lang.XIndexedList}<" + fieldType.getType().getTemplatedJavaTypeName() + "> " + AdmXbufGenerator.fieldGetterMethodName(field) + "List() {");
            codeBuilder.last().appendln("        final %{com.neeve.lang.XIndexedList}<" + fieldType.getType().getTemplatedJavaTypeName() + "> rc = new %{com.neeve.lang.XIndexedList}<" + fieldType.getType().getTemplatedJavaTypeName() + ">();");
            codeBuilder.last().appendln("        if (" + AdmXbufGenerator.fieldFldVarName(field) + ".getValues().size() > 0) {");
            codeBuilder.last().appendln("            final %{com.neeve.lang.XIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + "> it = " + AdmXbufGenerator.fieldFldVarName(field) + ".getValueIterator();");
            codeBuilder.last().appendln("            while (it.hasNext()) {");
            codeBuilder.last().appendln("                rc.add(it.next());");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        return rc;");
            codeBuilder.last().appendln("    }");
        } else {
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public %{com.neeve.lang.XIndexedList}<" + fieldType.getType().getTemplatedJavaTypeName() + "> " + AdmXbufGenerator.fieldGetterMethodName(field) + "List() {");
            codeBuilder.last().appendln("        throw new UnsupportedOperationException(\"" + AdmXbufGenerator.fieldGetterMethodName(field) + "List is currently only supported for xbuf classes generated with Protobuf compatibility\");");
            codeBuilder.last().appendln("    }");
        }
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public %{com.neeve.lang.XIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + "> " + AdmXbufGenerator.fieldGetterMethodName(field) + "Iterator() {");
        codeBuilder.last().appendln("        return " + AdmXbufGenerator.fieldFldVarName(field) + ".getValueIterator();");
        codeBuilder.last().appendln("    }");
        this.writeOptionalGetterMethods(entity, field, codeBuilder);
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldClearerMethodName(field) + "() {");
        codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldFldVarName(field) + ".clearValue();");
        codeBuilder.last().appendln("        _isDirty = true;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeUserEnumerationFieldMethods(AdmEntity entity, AdmField field, AdmEncodingType protoXbufGenCompatibility, AdmSourceCodeBuilder codeBuilder) {
        AdmEnumeration fieldType = (AdmEnumeration)field.getType();
        boolean hasInterface = !entity.isEmbedded() || entity.getGenerateEmbeddedEntityInterfaces();
        String finalModifier = AdmXbufGenerator.fieldAccessorFinalModifier(entity);
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonSetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldSetterMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " val) {");
        this.writeReadOnlyValidator(entity, codeBuilder);
        if (!entity.isEmbedded() && entity.isTransactional()) {
            codeBuilder.last().appendln("        final " + fieldType.getTemplatedJavaTypeName() + " existing = " + AdmXbufGenerator.fieldGetterMethodName(field) + "();");
            codeBuilder.last().appendln("        if (val != existing) {");
            codeBuilder.last().appendln("            recordFieldUpdate(" + AdmXbufGenerator.fieldIdxFieldVarName(field) + ", existing, val);");
            if (protoXbufGenCompatibility == null) {
                codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldFldVarName(field) + ".setValue(val == null ? " + (fieldType.hasValue(0) ? "Integer.MAX_VALUE" : "0") + " : val.val);");
            } else {
                codeBuilder.last().appendln("            if (val != null) {");
                codeBuilder.last().appendln("                " + AdmXbufGenerator.fieldFldVarName(field) + ".setValue(val);");
                codeBuilder.last().appendln("            }");
                codeBuilder.last().appendln("            else {");
                codeBuilder.last().appendln("                " + AdmXbufGenerator.fieldFldVarName(field) + ".clearValue();");
                codeBuilder.last().appendln("            }");
            }
            codeBuilder.last().appendln("        }");
        } else if (protoXbufGenCompatibility == null) {
            codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldFldVarName(field) + ".setValue(val == null ? " + (fieldType.hasValue(0) ? "Integer.MAX_VALUE" : "0") + " : val.val);");
        } else {
            codeBuilder.last().appendln("        if (val != null) {");
            codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldFldVarName(field) + ".setValue(val);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        else {");
            codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldFldVarName(field) + ".clearValue();");
            codeBuilder.last().appendln("        }");
        }
        codeBuilder.last().appendln("        _isDirty = true;");
        codeBuilder.last().appendln("    }");
        String xbufFieldType = this.getXbufFieldType(field.getType(), protoXbufGenCompatibility);
        if (xbufFieldType != null) {
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldSetterFromMethodName(field) + "(final " + xbufFieldType + " val) {");
            this.writeReadOnlyValidator(entity, codeBuilder);
            codeBuilder.last().appendln("        if (val == null) {");
            codeBuilder.last().appendln("            throw new IllegalArgumentException(\"val cannot be null\");");
            codeBuilder.last().appendln("        }");
            if (!entity.isEmbedded() && entity.isTransactional()) {
                codeBuilder.last().appendln("        final " + fieldType.getTemplatedJavaTypeName() + " existing = " + AdmXbufGenerator.fieldGetterMethodName(field) + "();");
                if (protoXbufGenCompatibility == null) {
                    codeBuilder.last().appendln("        if (val.getValue() != existing.val) {");
                    codeBuilder.last().appendln("            recordFieldUpdate(" + AdmXbufGenerator.fieldIdxFieldVarName(field) + ", existing, " + fieldType.getTemplatedJavaTypeName() + ".fromValue(val.getValue()));");
                    codeBuilder.last().appendln("        }");
                } else {
                    codeBuilder.last().appendln("        if (val.getValue() != existing) {");
                    codeBuilder.last().appendln("            recordFieldUpdate(" + AdmXbufGenerator.fieldIdxFieldVarName(field) + ", existing, val.getValue());");
                    codeBuilder.last().appendln("        }");
                }
            }
            codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldFldVarName(field) + ".setValueFrom(val);");
            codeBuilder.last().appendln("        _isDirty=true;");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public " + xbufFieldType + " " + AdmXbufGenerator.fieldGetterMethodName(field) + "Field() {");
            codeBuilder.last().appendln("        return " + AdmXbufGenerator.fieldFldVarName(field) + ";");
            codeBuilder.last().appendln("    }");
        }
        this.writeFieldFluentMethods(entity, field, codeBuilder);
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonGetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmXbufGenerator.fieldGetterMethodName(field) + "() {");
        if (protoXbufGenCompatibility == null) {
            codeBuilder.last().appendln("        final int val = " + AdmXbufGenerator.fieldFldVarName(field) + ".getValue();");
            codeBuilder.last().appendln("        return val == " + (fieldType.hasValue(0) ? "Integer.MAX_VALUE" : "0") + " ? null : " + fieldType.getTemplatedJavaTypeName() + ".fromValue(val);");
        } else {
            codeBuilder.last().appendln("        return " + AdmXbufGenerator.fieldFldVarName(field) + ".hasValue() ? " + AdmXbufGenerator.fieldFldVarName(field) + ".getValue() : null;");
        }
        codeBuilder.last().appendln("    }");
        this.writeOptionalGetterMethods(entity, field, codeBuilder);
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public boolean " + AdmXbufGenerator.fieldCheckerMethodName(field) + "() {");
        if (protoXbufGenCompatibility == null) {
            codeBuilder.last().appendln("        return " + AdmXbufGenerator.fieldFldVarName(field) + ".getValue() != " + (fieldType.hasValue(0) ? "Integer.MAX_VALUE" : "0") + ";");
        } else {
            codeBuilder.last().appendln("        return " + AdmXbufGenerator.fieldFldVarName(field) + ".hasValue();");
        }
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldClearerMethodName(field) + "() {");
        codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldFldVarName(field) + ".clearValue();");
        codeBuilder.last().appendln("        _isDirty = true;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeUserEntityFieldMethods(AdmEntity entity, AdmField field, AdmSourceCodeBuilder codeBuilder) {
        AdmEntity fieldType = (AdmEntity)field.getType();
        boolean hasInterface = !entity.isEmbedded() || entity.getGenerateEmbeddedEntityInterfaces();
        String finalModifier = AdmXbufGenerator.fieldAccessorFinalModifier(entity);
        if (entity.isEmbedded() || fieldType.isEmbedded()) {
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            this.writeJsonSetterAnnotations(field, codeBuilder);
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldSetterMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " val) {");
            this.writeReadOnlyValidator(entity, codeBuilder);
            codeBuilder.last().appendln("        final " + fieldType.getTemplatedJavaTypeName() + " existing = " + AdmXbufGenerator.fieldGetterMethodName(field) + "();");
            codeBuilder.last().appendln("        if (existing != null && val != existing) {");
            codeBuilder.last().appendln("            existing.dispose();");
            codeBuilder.last().appendln("        }");
            if (!entity.isEmbedded() && entity.isTransactional()) {
                codeBuilder.last().appendln("        if (val != existing) {");
                codeBuilder.last().appendln("            recordFieldUpdate(" + AdmXbufGenerator.fieldIdxFieldVarName(field) + ", existing, val);");
                codeBuilder.last().appendln("            if (val != null) {");
                codeBuilder.last().appendln("                " + AdmXbufGenerator.fieldFldVarName(field) + ".setValue(val);");
                codeBuilder.last().appendln("            }");
                codeBuilder.last().appendln("            else {");
                codeBuilder.last().appendln("                " + AdmXbufGenerator.fieldFldVarName(field) + ".clearValue();");
                codeBuilder.last().appendln("            }");
                codeBuilder.last().appendln("            _isDirty = true;");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("    }");
            } else {
                codeBuilder.last().appendln("        if (val != null) {");
                codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldFldVarName(field) + ".setValue(val);");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        else {");
                codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldFldVarName(field) + ".clearValue();");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        _isDirty = true;");
                codeBuilder.last().appendln("    }");
            }
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldLenderMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " val) {");
            codeBuilder.last().appendln("        if (val != null) {");
            codeBuilder.last().appendln("            val.acquire();");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldSetterMethodName(field) + "(val);");
            codeBuilder.last().appendln("    }");
            this.writeFieldFluentMethods(entity, field, codeBuilder);
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            this.writeJsonGetterAnnotations(field, codeBuilder);
            codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmXbufGenerator.fieldGetterMethodName(field) + "() {");
            codeBuilder.last().appendln("        return " + AdmXbufGenerator.fieldFldVarName(field) + ".getValue();");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldGetterToMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " to) {");
            codeBuilder.last().appendln("        if (" + AdmXbufGenerator.fieldCheckerMethodName(field) + "()) {");
            codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldGetterMethodName(field) + "().copyInto(to);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        else {");
            codeBuilder.last().appendln("            to.clearContent();");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmXbufGenerator.fieldTakerMethodName(field) + "() {");
            codeBuilder.last().appendln("        final " + fieldType.getTemplatedJavaTypeName() + " val = " + AdmXbufGenerator.fieldGetterMethodName(field) + "();");
            codeBuilder.last().appendln("        if (val != null) {");
            codeBuilder.last().appendln("            val.acquire();");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        return val;");
            codeBuilder.last().appendln("    }");
            this.writeOptionalGetterMethods(entity, field, codeBuilder);
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    " + finalModifier + "public boolean " + AdmXbufGenerator.fieldCheckerMethodName(field) + "() {");
            codeBuilder.last().appendln("        return " + AdmXbufGenerator.fieldFldVarName(field) + ".hasValue();");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldClearerMethodName(field) + "() {");
            codeBuilder.last().appendln("        final " + fieldType.getTemplatedJavaTypeName() + " existing = " + AdmXbufGenerator.fieldGetterMethodName(field) + "();");
            codeBuilder.last().appendln("        if (existing != null) {");
            codeBuilder.last().appendln("            existing.dispose();");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldFldVarName(field) + ".clearValue();");
            codeBuilder.last().appendln("        _isDirty = true;");
            codeBuilder.last().appendln("    }");
        } else {
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            this.writeJsonSetterAnnotations(field, codeBuilder);
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldSetterMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " val) {");
            this.writeReadOnlyValidator(entity, codeBuilder);
            codeBuilder.last().appendln("        if (val != " + AdmXbufGenerator.fieldGetterMethodName(field) + "()) {");
            codeBuilder.last().appendln("            setChild(" + AdmXbufGenerator.fieldFidVarName(field) + ", val);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            this.writeFieldFluentMethods(entity, field, codeBuilder);
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            this.writeJsonGetterAnnotations(field, codeBuilder);
            codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmXbufGenerator.fieldGetterMethodName(field) + "() {");
            codeBuilder.last().appendln("        return (" + fieldType.getTemplatedJavaTypeName() + ")getChild(" + AdmXbufGenerator.fieldFidVarName(field) + ");");
            codeBuilder.last().appendln("    }");
            this.writeOptionalGetterMethods(entity, field, codeBuilder);
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    " + finalModifier + "public boolean " + AdmXbufGenerator.fieldCheckerMethodName(field) + "() {");
            codeBuilder.last().appendln("        return getChild(" + AdmXbufGenerator.fieldFidVarName(field) + ") != null;");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbufGenerator.fieldClearerMethodName(field) + "() {");
            codeBuilder.last().appendln("        " + AdmXbufGenerator.fieldSetterMethodName(field) + "(null);");
            codeBuilder.last().appendln("    }");
        }
    }

    private final void writeUserCollectionFieldMethods(AdmEntity entity, AdmField field, AdmSourceCodeBuilder codeBuilder) {
        AdmCollection fieldType = (AdmCollection)field.getType();
        String finalModifier = AdmXbufGenerator.fieldAccessorFinalModifier(entity);
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmXbufGenerator.fieldGetterMethodName(field) + "() {");
        codeBuilder.last().appendln("        " + fieldType.getTemplatedJavaTypeName() + " val = (" + fieldType.getTemplatedJavaTypeName() + ")getChild(" + AdmXbufGenerator.fieldFidVarName(field) + ");");
        codeBuilder.last().appendln("        if (val == null) {");
        codeBuilder.last().appendln("            setChild(" + AdmXbufGenerator.fieldFidVarName(field) + ", val = " + fieldType.getTemplatedJavaTypeName() + ".create());");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        return val;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeSetPreserializedFieldsMethods(AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    final public void setPreserializedFields(final %{com.neeve.pkt.PktBuffer} buffer) {");
        codeBuilder.last().appendln("        final int length = buffer.getLength();");
        codeBuilder.last().appendln("        if (length > 0) {");
        codeBuilder.last().appendln("            final IOBuffer iobuf = buffer.getIOBuffer();");
        codeBuilder.last().appendln("            final ByteBuffer bytebuf = iobuf.takeBuffer();");
        codeBuilder.last().appendln("            final %{com.neeve.xbuf.XbufDesyncPolicy} desyncPolicy = _container.getDesyncPolicy();");
        codeBuilder.last().appendln("            try {");
        codeBuilder.last().appendln("                _container.setDesyncPolicy(%{com.neeve.xbuf.XbufDesyncPolicy}.FrameContainer);");
        codeBuilder.last().appendln("                try {");
        codeBuilder.last().appendln("                    bytebuf.limit(length);");
        codeBuilder.last().appendln("                    deserializeFromByteBuffer(bytebuf);");
        codeBuilder.last().appendln("                }");
        codeBuilder.last().appendln("                finally { ");
        codeBuilder.last().appendln("                    iobuf.releaseBuffer();");
        codeBuilder.last().appendln("                }");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            finally { ");
        codeBuilder.last().appendln("                _container.setDesyncPolicy(desyncPolicy);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        else {");
        codeBuilder.last().appendln("            final %{com.neeve.xbuf.XbufDesyncPolicy} desyncPolicy = _container.getDesyncPolicy();");
        codeBuilder.last().appendln("            try {");
        codeBuilder.last().appendln("                _container.setDesyncPolicy(%{com.neeve.xbuf.XbufDesyncPolicy}.FrameContainer);");
        codeBuilder.last().appendln("                deserializeFromByteArray(%{com.neeve.adm.runtime.AdmRuntime}.EMPTY_BYTE_ARRAY);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            finally {");
        codeBuilder.last().appendln("                _container.setDesyncPolicy(desyncPolicy);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            return;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
    }

    private final void writeUserFieldMethods(AdmEntity entity, AdmField field, AdmEncodingType protoXbufGenCompatibility, boolean generatArrayFieldsEmptyIfNull, AdmSourceCodeBuilder codeBuilder) {
        AdmType fieldType = field.getType();
        this.writeFieldIdMethods(entity, field, codeBuilder);
        if (fieldType instanceof AdmPrimitive) {
            this.writeUserPrimitiveFieldMethods(entity, field, protoXbufGenCompatibility, codeBuilder);
        } else if (fieldType instanceof AdmArray) {
            if (fieldType instanceof AdmPrimitiveArray) {
                this.writeUserPrimitiveArrayFieldMethods(entity, field, protoXbufGenCompatibility, generatArrayFieldsEmptyIfNull, codeBuilder);
            } else if (fieldType instanceof AdmEntityArray) {
                this.writeUserEntityArrayFieldMethods(entity, field, protoXbufGenCompatibility, generatArrayFieldsEmptyIfNull, codeBuilder);
            } else if (fieldType instanceof AdmEnumerationArray) {
                this.writeUserEnumerationArrayFieldMethods(entity, field, protoXbufGenCompatibility, generatArrayFieldsEmptyIfNull, codeBuilder);
            }
        } else if (fieldType instanceof AdmEnumeration) {
            this.writeUserEnumerationFieldMethods(entity, field, protoXbufGenCompatibility, codeBuilder);
        } else if (fieldType instanceof AdmEntity) {
            this.writeUserEntityFieldMethods(entity, field, codeBuilder);
        } else if (fieldType instanceof AdmCollection) {
            this.writeUserCollectionFieldMethods(entity, field, codeBuilder);
        } else {
            throw new IllegalArgumentException("unknown field type '" + fieldType.getTemplatedJavaTypeName() + "' (class=" + ((Object)((Object)fieldType)).getClass().getName() + ")");
        }
    }

    private final void writeFieldMethods(AdmEntity entity, List<AdmField> fields, AdmEncodingType protoXbufGenCompatibility, boolean generatArrayFieldsEmptyIfNull, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- Field getter/setter methods -----");
        this.writeSetPreserializedFieldsMethods(codeBuilder);
        this.writeContainedEntityCollectionElementMethods(entity, codeBuilder);
        Iterator<AdmField> fieldIterator = fields.iterator();
        while (fieldIterator.hasNext()) {
            this.writeUserFieldMethods(entity, fieldIterator.next(), protoXbufGenCompatibility, generatArrayFieldsEmptyIfNull, codeBuilder);
        }
        codeBuilder.last().appendln("    // ----- Field getter/setter methods -----");
    }

    private void writeIsDirtyMethod(AdmEntity entity, List<AdmField> fields, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    final public boolean isDirty() {");
        codeBuilder.last().appendln("        return _isDirty;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeSchemaCreateMethod(AdmEntity entity, List<AdmField> fields, AdmEncodingType protoXbufGenCompatibility, AdmSourceCodeBuilder codeBuilder) {
        AdmField field;
        codeBuilder.last().appendln("    // ----- x-buf schema creation method -----");
        codeBuilder.last().appendln("    final private static %{cern.colt.map.OpenIntObjectHashMap} fieldMapById = new %{cern.colt.map.OpenIntObjectHashMap}(" + fields.size() + ", 0.0, 0.5);");
        codeBuilder.last().appendln("    final private static %{java.util.Map}<String, Integer> fieldMapByName = new %{java.util.HashMap}<String, Integer>(" + fields.size() + ");");
        codeBuilder.last().appendln("    static {");
        Iterator<AdmField> fieldIterator = fields.iterator();
        int fieldIndex = 0;
        while (fieldIterator.hasNext()) {
            field = fieldIterator.next();
            if (!field.isEmbedded()) continue;
            codeBuilder.last().appendln("        fieldMapById.put(" + field.getId() + ", " + fieldIndex + ");");
            codeBuilder.last().appendln("        fieldMapByName.put(\"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\", " + fieldIndex + ");");
            ++fieldIndex;
        }
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("    final public static %{com.neeve.xbuf.XbufSchema} createSchema() {");
        codeBuilder.last().appendln("        final %{com.neeve.xbuf.XbufField}[] fields = new %{com.neeve.xbuf.XbufField} [" + fieldIndex + "];");
        fieldIterator = fields.iterator();
        fieldIndex = 0;
        while (fieldIterator.hasNext()) {
            block98: {
                String nullCheckPolicy;
                String allowNulls;
                AdmType fieldType;
                block99: {
                    block97: {
                        field = fieldIterator.next();
                        fieldType = field.getType();
                        if (!(fieldType instanceof AdmPrimitive)) break block97;
                        switch (((AdmPrimitive)fieldType).getType()) {
                            case Byte: {
                                if (protoXbufGenCompatibility == null) {
                                    codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufByteField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\", " + field.isPinned() + ");");
                                    break;
                                }
                                codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufVariableByteField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\");");
                                break;
                            }
                            case Char: {
                                if (protoXbufGenCompatibility == null) {
                                    codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufCharField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\", " + field.isPinned() + ");");
                                    break;
                                }
                                codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufVariableCharField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\");");
                                break;
                            }
                            case Short: {
                                if (protoXbufGenCompatibility == null) {
                                    codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufShortField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\", " + field.isPinned() + ");");
                                    break;
                                }
                                codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufVariableShortField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\");");
                                break;
                            }
                            case Integer: {
                                if (protoXbufGenCompatibility == null) {
                                    codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufIntField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\", " + field.isPinned() + ");");
                                    break;
                                }
                                codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufVariableIntField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\");");
                                break;
                            }
                            case Long: {
                                if (protoXbufGenCompatibility == null) {
                                    codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufLongField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\", " + field.isPinned() + ");");
                                    break;
                                }
                                codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufVariableLongField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\");");
                                break;
                            }
                            case Float: {
                                codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufFloatField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\", " + field.isPinned() + ");");
                                break;
                            }
                            case Double: {
                                codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufDoubleField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\", " + field.isPinned() + ");");
                                break;
                            }
                            case Boolean: {
                                if (protoXbufGenCompatibility == null) {
                                    codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufBooleanField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\", " + field.isPinned() + ");");
                                    break;
                                }
                                codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufVariableBooleanField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\");");
                                break;
                            }
                            case Date: {
                                if (protoXbufGenCompatibility == null) {
                                    codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufDateField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\", " + field.isPinned() + ");");
                                    break;
                                }
                                codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufVariableDateField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\");");
                                break;
                            }
                            case String: {
                                codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufStringField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\");");
                                break;
                            }
                            case Currency: {
                                codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufCurrencyField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\", " + field.isPinned() + ");");
                                break;
                            }
                            case UUID: {
                                codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufUUIDField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\", " + field.isPinned() + ");");
                            }
                        }
                        break block98;
                    }
                    if (!(fieldType instanceof AdmPrimitiveArray)) break block99;
                    switch (((AdmPrimitiveArray)fieldType).getType()) {
                        case Byte: {
                            if (protoXbufGenCompatibility == null || protoXbufGenCompatibility == AdmEncodingType.Xbuf) {
                                codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufByteArrayField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\");");
                            } else {
                                codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufVariableByteListField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\");");
                            }
                            break block98;
                        }
                        case Char: {
                            if (protoXbufGenCompatibility == null || protoXbufGenCompatibility == AdmEncodingType.Xbuf) {
                                codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufCharArrayField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\");");
                            } else {
                                codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufVariableCharListField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\");");
                            }
                            break block98;
                        }
                        case Short: {
                            if (protoXbufGenCompatibility == null || protoXbufGenCompatibility == AdmEncodingType.Xbuf) {
                                codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufShortArrayField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\");");
                            } else {
                                codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufVariableShortListField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\");");
                            }
                            break block98;
                        }
                        case Integer: {
                            if (protoXbufGenCompatibility == null || protoXbufGenCompatibility == AdmEncodingType.Xbuf) {
                                codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufIntArrayField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\");");
                            } else {
                                codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufVariableIntListField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\");");
                            }
                            break block98;
                        }
                        case Long: {
                            if (protoXbufGenCompatibility == null || protoXbufGenCompatibility == AdmEncodingType.Xbuf) {
                                codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufLongArrayField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\");");
                            } else {
                                codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufVariableLongListField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\");");
                            }
                            break block98;
                        }
                        case Float: {
                            if (protoXbufGenCompatibility == null || protoXbufGenCompatibility == AdmEncodingType.Xbuf) {
                                codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufFloatArrayField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\");");
                            } else {
                                codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufFloatListField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\");");
                            }
                            break block98;
                        }
                        case Double: {
                            if (protoXbufGenCompatibility == null || protoXbufGenCompatibility == AdmEncodingType.Xbuf) {
                                codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufDoubleArrayField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\");");
                            } else {
                                codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufDoubleListField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\");");
                            }
                            break block98;
                        }
                        case Boolean: {
                            if (protoXbufGenCompatibility == null || protoXbufGenCompatibility == AdmEncodingType.Xbuf) {
                                codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufBooleanArrayField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\");");
                            } else {
                                codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufVariableBooleanListField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\");");
                            }
                            break block98;
                        }
                        case String: {
                            allowNulls = protoXbufGenCompatibility == AdmEncodingType.Protobuf ? "false" : "true";
                            nullCheckPolicy = "%{com.neeve.xbuf.XbufField}.NullValueCheckPolicy.";
                            switch (entity.getNullPrimitiveArrayElementPolicy()) {
                                case Ignore: {
                                    nullCheckPolicy = nullCheckPolicy + "Ignore";
                                    break;
                                }
                                case IgnoreUnlessSupported: {
                                    if (protoXbufGenCompatibility == AdmEncodingType.Protobuf) {
                                        nullCheckPolicy = nullCheckPolicy + "Ignore";
                                        break;
                                    }
                                    nullCheckPolicy = nullCheckPolicy + "Unchecked";
                                    break;
                                }
                                case Throw: {
                                    nullCheckPolicy = nullCheckPolicy + "Throw";
                                    break;
                                }
                            }
                            codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufStringListField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\", " + allowNulls + ", " + nullCheckPolicy + ");");
                            break block98;
                        }
                        case Date: {
                            allowNulls = protoXbufGenCompatibility == AdmEncodingType.Protobuf ? "false" : "true";
                            nullCheckPolicy = "%{com.neeve.xbuf.XbufField}.NullValueCheckPolicy.";
                            switch (entity.getNullPrimitiveArrayElementPolicy()) {
                                case Ignore: {
                                    nullCheckPolicy = nullCheckPolicy + "Ignore";
                                    break;
                                }
                                case IgnoreUnlessSupported: {
                                    if (protoXbufGenCompatibility == AdmEncodingType.Protobuf) {
                                        nullCheckPolicy = nullCheckPolicy + "Ignore";
                                        break;
                                    }
                                    nullCheckPolicy = nullCheckPolicy + "Unchecked";
                                    break;
                                }
                                case Throw: {
                                    nullCheckPolicy = nullCheckPolicy + "Throw";
                                    break;
                                }
                            }
                            if (protoXbufGenCompatibility == null || protoXbufGenCompatibility == AdmEncodingType.Xbuf) {
                                codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufDateArrayField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\", " + allowNulls + ", " + nullCheckPolicy + ");");
                            } else {
                                codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufVariableDateListField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\", " + allowNulls + ", " + nullCheckPolicy + ");");
                            }
                            break block98;
                        }
                        case Currency: {
                            allowNulls = protoXbufGenCompatibility == AdmEncodingType.Protobuf ? "false" : "true";
                            nullCheckPolicy = "%{com.neeve.xbuf.XbufField}.NullValueCheckPolicy.";
                            switch (entity.getNullPrimitiveArrayElementPolicy()) {
                                case Ignore: {
                                    nullCheckPolicy = nullCheckPolicy + "Ignore";
                                    break;
                                }
                                case IgnoreUnlessSupported: {
                                    if (protoXbufGenCompatibility == AdmEncodingType.Protobuf) {
                                        nullCheckPolicy = nullCheckPolicy + "Ignore";
                                        break;
                                    }
                                    nullCheckPolicy = nullCheckPolicy + "Unchecked";
                                    break;
                                }
                                case Throw: {
                                    nullCheckPolicy = nullCheckPolicy + "Throw";
                                    break;
                                }
                            }
                            codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufCurrencyListField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\", " + allowNulls + ", " + nullCheckPolicy + ");");
                            break block98;
                        }
                        case UUID: {
                            allowNulls = protoXbufGenCompatibility == AdmEncodingType.Protobuf ? "false" : "true";
                            nullCheckPolicy = "%{com.neeve.xbuf.XbufField}.NullValueCheckPolicy.";
                            switch (entity.getNullPrimitiveArrayElementPolicy()) {
                                case Ignore: {
                                    nullCheckPolicy = nullCheckPolicy + "Ignore";
                                    break;
                                }
                                case IgnoreUnlessSupported: {
                                    if (protoXbufGenCompatibility == AdmEncodingType.Protobuf) {
                                        nullCheckPolicy = nullCheckPolicy + "Ignore";
                                        break;
                                    }
                                    nullCheckPolicy = nullCheckPolicy + "Unchecked";
                                    break;
                                }
                                case Throw: {
                                    nullCheckPolicy = nullCheckPolicy + "Throw";
                                    break;
                                }
                            }
                            codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufUUIDArrayField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\", " + allowNulls + ", " + nullCheckPolicy + ");");
                            break block98;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported primitive array type '" + (Object)((Object)((AdmPrimitiveArray)fieldType).getType()) + "'");
                        }
                    }
                }
                if (fieldType instanceof AdmEntity) {
                    if (!((AdmEntity)fieldType).isEmbedded()) continue;
                    codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = " + ((AdmEntity)fieldType).getTemplatedJavaTypeName() + ".Field.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\");");
                } else if (fieldType instanceof AdmEntityArray) {
                    codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = " + ((AdmEntityArray)fieldType).getType().getTemplatedJavaTypeName() + ".ListField.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\");");
                } else if (fieldType instanceof AdmEnumeration) {
                    if (protoXbufGenCompatibility == null) {
                        if (((AdmEnumeration)fieldType).hasValue(0)) {
                            codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufIntField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\", Integer.MAX_VALUE, " + field.isPinned() + ");");
                        } else {
                            codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufIntField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\", " + field.isPinned() + ");");
                        }
                    } else {
                        codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufVariableEnumField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\", " + AdmXbufGenerator.fieldAdapterFieldVarName(field) + ");");
                    }
                } else {
                    if (!(fieldType instanceof AdmEnumerationArray)) continue;
                    allowNulls = protoXbufGenCompatibility == AdmEncodingType.Protobuf ? "false" : "true";
                    nullCheckPolicy = "%{com.neeve.xbuf.XbufField}.NullValueCheckPolicy.";
                    switch (entity.getNullEntityArrayElementPolicy()) {
                        case Ignore: {
                            nullCheckPolicy = nullCheckPolicy + "Ignore";
                            break;
                        }
                        case IgnoreUnlessSupported: {
                            if (protoXbufGenCompatibility == AdmEncodingType.Protobuf) {
                                nullCheckPolicy = nullCheckPolicy + "Ignore";
                                break;
                            }
                            nullCheckPolicy = nullCheckPolicy + "Unchecked";
                            break;
                        }
                        case Throw: {
                            nullCheckPolicy = nullCheckPolicy + "Throw";
                            break;
                        }
                    }
                    if (protoXbufGenCompatibility == null || protoXbufGenCompatibility == AdmEncodingType.Xbuf) {
                        codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufIntArrayField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\");");
                    } else {
                        codeBuilder.last().appendln("        fields[" + fieldIndex + "]  = %{com.neeve.xbuf.XbufVariableEnumListField}.create((short)" + field.getId() + ", \"" + AdmXbufGenerator.toFirstLetterUppercase(field.getName()) + "\", " + AdmXbufGenerator.fieldAdapterFieldVarName(field) + ", " + allowNulls + ", " + nullCheckPolicy + ");");
                    }
                }
            }
            ++fieldIndex;
        }
        codeBuilder.last().appendln("        return %{com.neeve.xbuf.XbufSchema}.create(fields, fieldMapByName, fieldMapById);");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    // ----- x-buf schema creation method -----");
    }

    private final void writeSerializeToByteArrayMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public byte[] serializeToByteArray() {");
        codeBuilder.last().appendln("        sync();");
        codeBuilder.last().appendln("        final %{com.neeve.pkt.PktBuffer} bodyBuffer = _packet.getBody().getBuffer();");
        codeBuilder.last().appendln("        final byte[] array = new byte[bodyBuffer.getLength()];");
        codeBuilder.last().appendln("        bodyBuffer.getTo(0, array, 0, array.length);");
        codeBuilder.last().appendln("        return array;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeSerializeToByteBufferMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public %{java.nio.ByteBuffer} serializeToByteBuffer() {");
        codeBuilder.last().appendln("        sync();");
        codeBuilder.last().appendln("        final %{com.neeve.pkt.PktBuffer} bodyBuffer = _packet.getBody().getBuffer();");
        codeBuilder.last().appendln("        final %{java.nio.ByteBuffer} buffer = %{java.nio.ByteBuffer}.allocate(bodyBuffer.getLength());");
        codeBuilder.last().appendln("        bodyBuffer.getTo(0, buffer, buffer.capacity());");
        codeBuilder.last().appendln("        return buffer;");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public %{com.neeve.io.IOBuffer} serializeToIOBuffer(final boolean useNative) {");
        codeBuilder.last().appendln("        sync();");
        codeBuilder.last().appendln("        final %{com.neeve.pkt.PktBuffer} bodyBuffer = _packet.getBody().getBuffer();");
        codeBuilder.last().appendln("        final %{com.neeve.io.IOBuffer} ioBuffer = %{com.neeve.io.IOBuffer}.create(bodyBuffer.getLength(), useNative);");
        codeBuilder.last().appendln("        bodyBuffer.getTo(0, ioBuffer.getBufferUnsafe(), bodyBuffer.getLength());");
        codeBuilder.last().appendln("        return ioBuffer;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeSerializeToPacketMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public %{com.neeve.pkt.PktPacket} serializeToPacket() {");
        codeBuilder.last().appendln("        sync();");
        codeBuilder.last().appendln("        _packet.acquire();");
        codeBuilder.last().appendln("        return _packet;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeFromByteArrayMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserializeFromByteArray(final byte[] array) {");
        codeBuilder.last().appendln("        try {");
        codeBuilder.last().appendln("            clearFieldReferences();");
        codeBuilder.last().appendln("            _container.reset();");
        codeBuilder.last().appendln("            _packet.getBody().deserialize(array, 0, array.length);");
        codeBuilder.last().appendln("            _isDirty = false;");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        catch (Exception e) {");
        codeBuilder.last().appendln("            throw new RuntimeException(e);");
        codeBuilder.last().appendln("       }");
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeFromByteBufferMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserializeFromByteBuffer(final %{java.nio.ByteBuffer} buffer) {");
        codeBuilder.last().appendln("        buffer.mark();");
        codeBuilder.last().appendln("        try {");
        codeBuilder.last().appendln("            clearFieldReferences();");
        codeBuilder.last().appendln("            _container.reset();");
        codeBuilder.last().appendln("            _packet.getBody().deserialize(buffer, buffer.remaining());");
        codeBuilder.last().appendln("            _isDirty = false;");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        catch (Exception e) {");
        codeBuilder.last().appendln("            throw new RuntimeException(e);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        finally {");
        codeBuilder.last().appendln("            buffer.reset();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeFromPacketMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserializeFromPacket(final %{com.neeve.pkt.PktPacket} packet) {");
        codeBuilder.last().appendln("        try {");
        codeBuilder.last().appendln("            clearFieldReferences();");
        codeBuilder.last().appendln("            _container.reset();");
        codeBuilder.last().appendln("            _packet.getBody().deserialize(packet.getBody().getBuffer(), 0, packet.getBody().getBuffer().getLength());");
        codeBuilder.last().appendln("            _isDirty = false;");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        catch (Exception e) {");
        codeBuilder.last().appendln("            throw new RuntimeException(e);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        finally {");
        codeBuilder.last().appendln("            packet.dispose();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
    }

    private final void writeSyncMethod(AdmScopedType type, List<AdmField> fields, AdmSourceCodeBuilder codeBuilder) {
        if (type instanceof AdmCollection || !((AdmEntity)type).isEmbedded()) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    final public void sync() {");
        codeBuilder.last().appendln("        if ((_optimizationHints & %{com.neeve.xbuf.XbufOptimizations}.SPARSE_CONTENT) == %{com.neeve.xbuf.XbufOptimizations}.SPARSE_CONTENT) {_container.sync(); return;}");
        codeBuilder.last().appendln("        if (!_isDirty) {return;}");
        if (this.getSyncedFieldCount(type, fields) > 0) {
            codeBuilder.last().appendln("        final %{com.neeve.pkt.PktBuffer} buffer = _container.getBackingBuffer();");
            codeBuilder.last().appendln("        int pos = _container.syncPrepare();");
            codeBuilder.last().appendln("        try {");
            codeBuilder.last().appendln("            if (_lateSyncBoundary == Integer.MAX_VALUE) {return;}");
            boolean first = true;
            for (AdmField field : fields) {
                if (field.getType() instanceof AdmEntity && !((AdmEntity)field.getType()).isEmbedded() || field.getType() instanceof AdmCollection) continue;
                if (first) {
                    codeBuilder.last().appendln("            final boolean[] hasValues = _container.getHasValues();");
                    first = false;
                }
                codeBuilder.last().appendln("            if (" + field.getIndex() + " >= _lateSyncBoundary && hasValues[" + AdmXbufGenerator.fieldFldVarName(field) + ".index]) {");
                codeBuilder.last().appendln("                pos += " + AdmXbufGenerator.fieldFldVarName(field) + ".sync(buffer, pos);");
                codeBuilder.last().appendln("            }");
            }
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        finally {");
            codeBuilder.last().appendln("            _container.syncDone();");
            codeBuilder.last().appendln("            _isDirty = false;");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
        } else {
            codeBuilder.last().appendln("        _container.syncPrepare();");
            codeBuilder.last().appendln("        _container.syncDone();");
            codeBuilder.last().appendln("        _isDirty = false;");
            codeBuilder.last().appendln("    }");
        }
    }

    private final void writeIsPooledMethod(AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final protected boolean isPooled() {");
        codeBuilder.last().appendln("        return _packet != null && _packet.getPool() != null;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeCopyMethods(AdmEntity type, AdmSourceCodeBuilder codeBuilder) {
        if (type.isEmbedded()) {
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * Creates a copy of this " + type.getTemplatedJavaTypeName() + ".");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * The copy copies primitive, enum and embedded entity fields into");
            codeBuilder.last().appendln("     * the returned copy. Each embedded entity field is cloned so that modifications made");
            codeBuilder.last().appendln("     * to the copy's embedded entity fields do not affect this " + type.getTemplatedJavaTypeName() + "'s embedded entity fields.");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * The returned copy will be writeable even if this " + type.getTemplatedJavaTypeName() + " is read only.");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <h2> Xbuf Pass-through Fields</h2>");
            codeBuilder.last().appendln("     * When backed by a buffer, this operation copies the underlying buffer which means that if");
            codeBuilder.last().appendln("     * the message was deserialized from with unrecognized fields, such fields will be");
            codeBuilder.last().appendln("     * preserved in the copy as well.");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * @return The copied entity.");
            codeBuilder.last().appendln("     */");
            codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " copy() {");
            codeBuilder.last().appendln("        final " + type.getTemplatedJavaTypeName() + " copy = " + type.getTemplatedJavaTypeName() + ".create();");
            codeBuilder.last().appendln("        copyInto(copy);");
            codeBuilder.last().appendln("        return copy;");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * Copies the contents of this " + type.getTemplatedJavaTypeName() + " into the target.");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * The copy clears the target's contents and copies primitive, enum and embedded entity fields into");
            codeBuilder.last().appendln("     * the provided copy. Each embedded entity field is cloned so that modifications made");
            codeBuilder.last().appendln("     * to the copy's embedded entity fields do not affect this " + type.getTemplatedJavaTypeName() + "'s embedded entity fields.");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * The returned copy will be writeable even if this " + type.getTemplatedJavaTypeName() + " is read only.");
            codeBuilder.last().appendln("     * <h2>Xbuf Pass-through Fields</h2>");
            codeBuilder.last().appendln("     * When backed by a buffer, this operation copies the underlying buffer which means that if");
            codeBuilder.last().appendln("     * the message was deserialized from with unrecognized fields, such fields will be");
            codeBuilder.last().appendln("     * preserved in the copy as well.");
            codeBuilder.last().appendln("     * <p>");
            codeBuilder.last().appendln("     * @param copy The target into which to copy.");
            codeBuilder.last().appendln("     */");
            codeBuilder.last().appendln("    final public void copyInto(final " + type.getTemplatedJavaTypeName() + " copy) {");
            codeBuilder.last().appendln("        if (copy.readOnly) {throw new IllegalStateException(\"target is read only\");}");
            codeBuilder.last().appendln("        sync();");
            codeBuilder.last().appendln("        copy.deserializeFromIOElasticBuffer(getBackingBuffer(), 0, getBackingBuffer().getLength());");
            codeBuilder.last().appendln("    }");
        } else if (type instanceof AdmMessage) {
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * {@inheritDoc}");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <h2> Xbuf Pass-through Fields</h2>");
            codeBuilder.last().appendln("     * When backed by a buffer, this operation copies the underlying buffer which means that if");
            codeBuilder.last().appendln("     * the message was deserialized from with unrecognized fields, such fields will be");
            codeBuilder.last().appendln("     * preserved in the copy as well.");
            codeBuilder.last().appendln("     */ ");
            codeBuilder.last().appendln("    @Override");
            codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " copy() {");
            codeBuilder.last().appendln("        final " + type.getTemplatedJavaTypeName() + " copy = " + type.getTemplatedJavaTypeName() + ".create();");
            codeBuilder.last().appendln("        copyInto(copy);");
            codeBuilder.last().appendln("        return copy;");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * {@inheritDoc}");
            codeBuilder.last().appendln("     * ");
            codeBuilder.last().appendln("     * <h2>Xbuf Pass-through Fields</h2>");
            codeBuilder.last().appendln("     * When backed by a buffer, this operation copies the underlying buffer which means that if");
            codeBuilder.last().appendln("     * the message was deserialized from with unrecognized fields, such fields will be");
            codeBuilder.last().appendln("     * preserved in the copy as well.");
            codeBuilder.last().appendln("     */ ");
            codeBuilder.last().appendln("    @Override");
            codeBuilder.last().appendln("    final public void copyInto(final " + type.getTemplatedJavaTypeName() + " copy) {");
            codeBuilder.last().appendln("        if (copy.readOnly) {throw new IllegalStateException(\"copy target is read only\");}");
            codeBuilder.last().appendln("        final %{com.neeve.io.IOBuffer} buffer = serializeToIOBuffer(true);");
            codeBuilder.last().appendln("        copy.deserializeFromByteBuffer(buffer.takeBuffer());");
            codeBuilder.last().appendln("        buffer.releaseBuffer().dispose();");
            codeBuilder.last().appendln("        copyCopyableFieldsToCopy(copy);");
            codeBuilder.last().appendln("    }");
        }
    }

    private final void writeMessageViewSerializerMethods(AdmScopedType type, List<AdmField> fields, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- MessageView methods -----");
        this.writeSerializeToByteArrayMethod(type, codeBuilder);
        this.writeSerializeToByteBufferMethod(type, codeBuilder);
        this.writeSerializeToPacketMethod(type, codeBuilder);
        this.writeDeserializeFromByteArrayMethod(type, codeBuilder);
        this.writeDeserializeFromByteBufferMethod(type, codeBuilder);
        this.writeDeserializeFromPacketMethod(type, codeBuilder);
        this.writeSyncMethod(type, fields, codeBuilder);
        this.writeIsPooledMethod(codeBuilder);
        if (type instanceof AdmMessage) {
            this.writeCopyMethods((AdmMessage)type, codeBuilder);
        }
        codeBuilder.last().appendln("    // ----- MessageView methods -----");
    }

    private final void writeEmbeddedEntityIsBufferBacked(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    final public boolean isBufferBacked() {");
        codeBuilder.last().appendln("        return true;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeEmbeddedEntitySerializeToPacketBufferMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    final private int serializeToPacketBuffer(final %{com.neeve.pkt.PktBuffer} buffer, final int offset) {");
        codeBuilder.last().appendln("        sync();");
        codeBuilder.last().appendln("        final %{com.neeve.pkt.PktBuffer} containerBuffer = _container.getBackingBuffer();");
        codeBuilder.last().appendln("        final int length = containerBuffer.getLength();");
        codeBuilder.last().appendln("        buffer.putFrom(offset, containerBuffer, 0, length);");
        codeBuilder.last().appendln("        return length;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeEmbeddedEntitySerializeToByteArrayMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    final public byte[] serializeToByteArray() {");
        codeBuilder.last().appendln("        sync();");
        codeBuilder.last().appendln("        final %{com.neeve.pkt.PktBuffer} containerBuffer = _container.getBackingBuffer();");
        codeBuilder.last().appendln("        final byte[] array = new byte[containerBuffer.getLength()];");
        codeBuilder.last().appendln("        containerBuffer.getTo(0, array, 0, array.length);");
        codeBuilder.last().appendln("        return array;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeEmbeddedEntitySerializeToByteBufferMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    final public %{java.nio.ByteBuffer} serializeToByteBuffer() {");
        codeBuilder.last().appendln("        sync();");
        codeBuilder.last().appendln("        final %{com.neeve.pkt.PktBuffer} containerBuffer = _container.getBackingBuffer();");
        codeBuilder.last().appendln("        final %{java.nio.ByteBuffer} buffer = %{java.nio.ByteBuffer}.allocate(containerBuffer.getLength());");
        codeBuilder.last().appendln("        containerBuffer.getTo(0, buffer, buffer.capacity());");
        codeBuilder.last().appendln("        return buffer;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    ");
        codeBuilder.last().appendln("    final public %{com.neeve.io.IOBuffer} serializeToIOBuffer(final boolean useNative) {");
        codeBuilder.last().appendln("        sync();");
        codeBuilder.last().appendln("        final %{com.neeve.pkt.PktBuffer} containerBuffer = _container.getBackingBuffer();");
        codeBuilder.last().appendln("        final %{com.neeve.io.IOBuffer} ioBuffer = %{com.neeve.io.IOBuffer}.create(containerBuffer.getLength(), useNative);");
        codeBuilder.last().appendln("        containerBuffer.getTo(0, ioBuffer.getBufferUnsafe(), containerBuffer.getLength());");
        codeBuilder.last().appendln("        return ioBuffer;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeEmbeddedEntityGetSerializeToNativeLength(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    final public int getSerializeToNativeLength() {");
        codeBuilder.last().appendln("        sync();");
        codeBuilder.last().appendln("        return _container.getBackingBuffer().getLength();");
        codeBuilder.last().appendln("    }");
    }

    private final void writeEmbeddedEntitySerializeToNativeMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    final public int serializeToNative(final long address, final int addressOffset) {");
        codeBuilder.last().appendln("        sync();");
        codeBuilder.last().appendln("        final %{com.neeve.pkt.PktBuffer} containerBuffer = _container.getBackingBuffer();");
        codeBuilder.last().appendln("        final int length = containerBuffer.getLength();");
        codeBuilder.last().appendln("        containerBuffer.getToNative(0, address, addressOffset, length);");
        codeBuilder.last().appendln("        return length;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeEmbeddedEntityDeserializeFromByteArrayMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    final public " + type.getName() + " deserializeFromByteArray(final byte[] array, final %{com.neeve.xbuf.XbufDesyncPolicy} desyncPolicy) {");
        codeBuilder.last().appendln("        clearFieldReferences();");
        codeBuilder.last().appendln("        _container.reset();");
        codeBuilder.last().appendln("        _container.getBackingBuffer().putFrom(0, array, 0, array.length);");
        codeBuilder.last().appendln("        _container.desync(desyncPolicy);");
        codeBuilder.last().appendln("        _isDirty = false;");
        codeBuilder.last().appendln("        return this;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    final public " + type.getName() + " deserializeFromByteArray(final byte[] array) {");
        codeBuilder.last().appendln("        return deserializeFromByteArray(array, %{com.neeve.xbuf.XbufDesyncPolicy}.Copy);");
        codeBuilder.last().appendln("    }");
    }

    private final void writeEmbeddedEntityDeserializeFromPacketBufferMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    final private " + type.getName() + " deserializeFromPacketBuffer(final %{com.neeve.pkt.PktBuffer} buffer, final int offset, final int length, final %{com.neeve.xbuf.XbufDesyncPolicy} desyncPolicy) {");
        codeBuilder.last().appendln("        clearFieldReferences();");
        codeBuilder.last().appendln("        _container.reset();");
        codeBuilder.last().appendln("        _container.getBackingBuffer().putFrom(0, buffer, offset, length);");
        codeBuilder.last().appendln("        _container.desync(desyncPolicy);");
        codeBuilder.last().appendln("        _isDirty = false;");
        codeBuilder.last().appendln("        return this;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    final private " + type.getName() + " deserializeFromPacketBuffer(final %{com.neeve.pkt.PktBuffer} buffer, final int offset, final int length) {");
        codeBuilder.last().appendln("        return deserializeFromPacketBuffer(buffer, offset, length, %{com.neeve.xbuf.XbufDesyncPolicy}.Copy);");
        codeBuilder.last().appendln("    }");
    }

    private final void writeEmbeddedEntityDeserializeFromIOElasticBufferMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    final public " + type.getName() + " deserializeFromIOElasticBuffer(final %{com.neeve.io.IOElasticBuffer} buffer, final int offset, final int length, final %{com.neeve.xbuf.XbufDesyncPolicy} desyncPolicy) {");
        codeBuilder.last().appendln("        clearFieldReferences();");
        codeBuilder.last().appendln("        _container.reset();");
        codeBuilder.last().appendln("        _container.getBackingBuffer().putFrom(0, buffer, offset, length);");
        codeBuilder.last().appendln("        _container.desync(desyncPolicy);");
        codeBuilder.last().appendln("        _isDirty = false;");
        codeBuilder.last().appendln("        return this;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    final public " + type.getName() + " deserializeFromIOElasticBuffer(final %{com.neeve.io.IOElasticBuffer} buffer, final int offset, final int length) {");
        codeBuilder.last().appendln("        return deserializeFromIOElasticBuffer(buffer, offset, length, %{com.neeve.xbuf.XbufDesyncPolicy}.Copy);");
        codeBuilder.last().appendln("    }");
    }

    private final void writeEmbeddedEntityDeserializeFromByteBufferMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    final public " + type.getName() + " deserializeFromByteBuffer(final %{java.nio.ByteBuffer} buffer, final %{com.neeve.xbuf.XbufDesyncPolicy} desyncPolicy) {");
        codeBuilder.last().appendln("        clearFieldReferences();");
        codeBuilder.last().appendln("        _container.reset();");
        codeBuilder.last().appendln("        _container.getBackingBuffer().putFrom(0, buffer, buffer.remaining());");
        codeBuilder.last().appendln("        _container.desync(desyncPolicy);");
        codeBuilder.last().appendln("        _isDirty = false;");
        codeBuilder.last().appendln("        return this;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    final public " + type.getName() + " deserializeFromByteBuffer(final %{java.nio.ByteBuffer} buffer) {");
        codeBuilder.last().appendln("        return deserializeFromByteBuffer(buffer, %{com.neeve.xbuf.XbufDesyncPolicy}.Copy);");
        codeBuilder.last().appendln("    }");
    }

    private final void writeEmbeddedEntityDeserializeFromNativeMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    final public " + type.getName() + " deserializeFromNative(final long address, final int offset, final int length, final %{com.neeve.xbuf.XbufDesyncPolicy} desyncPolicy) {");
        codeBuilder.last().appendln("        clearFieldReferences();");
        codeBuilder.last().appendln("        _container.reset();");
        codeBuilder.last().appendln("        _container.getBackingBuffer().putFromNative(0, address, offset, length);");
        codeBuilder.last().appendln("        _container.desync(desyncPolicy);");
        codeBuilder.last().appendln("        _isDirty = false;");
        codeBuilder.last().appendln("        return this;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    final public " + type.getName() + " deserializeFromNative(final long address, final int offset, final int length) {");
        codeBuilder.last().appendln("        return deserializeFromNative(address, offset, length, %{com.neeve.xbuf.XbufDesyncPolicy}.Copy);");
        codeBuilder.last().appendln("    }");
    }

    private final void writeEmbeddedEntitySerializerMethods(AdmEntity entity, List<AdmField> fields, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- Serializer/Deserializer methods -----");
        this.writeEmbeddedEntitySerializeToPacketBufferMethod(entity, codeBuilder);
        this.writeEmbeddedEntitySerializeToByteArrayMethod(entity, codeBuilder);
        this.writeEmbeddedEntitySerializeToByteBufferMethod(entity, codeBuilder);
        this.writeEmbeddedEntityIsBufferBacked(entity, codeBuilder);
        this.writeEmbeddedEntityGetSerializeToNativeLength(entity, codeBuilder);
        this.writeEmbeddedEntitySerializeToNativeMethod(entity, codeBuilder);
        this.writeEmbeddedEntityDeserializeFromPacketBufferMethod(entity, codeBuilder);
        this.writeEmbeddedEntityDeserializeFromIOElasticBufferMethod(entity, codeBuilder);
        this.writeEmbeddedEntityDeserializeFromByteArrayMethod(entity, codeBuilder);
        this.writeEmbeddedEntityDeserializeFromByteBufferMethod(entity, codeBuilder);
        this.writeEmbeddedEntityDeserializeFromNativeMethod(entity, codeBuilder);
        this.writeSyncMethod(entity, fields, codeBuilder);
        codeBuilder.last().appendln("    // ----- Serializer/Deserializer methods -----");
    }

    private final void writeImplementedIXbufDesyncerMethods(AdmScopedType type, List<AdmField> fields, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    final private %{com.neeve.xbuf.XbufField}.VarintDesyncLength varintDesyncLength = new %{com.neeve.xbuf.XbufField}.VarintDesyncLength();");
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public int desync(final %{com.neeve.pkt.PktBuffer} buffer, final int pos, final boolean frameOnly) {");
        codeBuilder.last().appendln("        if ((_optimizationHints & %{com.neeve.xbuf.XbufOptimizations}.SPARSE_CONTENT) == %{com.neeve.xbuf.XbufOptimizations}.SPARSE_CONTENT) {return 0;}");
        codeBuilder.last().appendln("        if ((_optimizationHints & %{com.neeve.xbuf.XbufOptimizations}.SPARSE_INTEREST) == %{com.neeve.xbuf.XbufOptimizations}.SPARSE_INTEREST) {return 0;}");
        codeBuilder.last().appendln("        final int limit = buffer.getLength();");
        codeBuilder.last().appendln("        int len = 0;");
        codeBuilder.last().appendln("        if ((pos + len) >= limit) {return len;}");
        if (this.getSyncedFieldCount(type, fields) > 0) {
            codeBuilder.last().appendln("        short id = %{com.neeve.xbuf.XbufField}.fieldId(buffer, pos + len, varintDesyncLength);");
            for (AdmField field : fields) {
                if (field.getType() instanceof AdmEntity && !((AdmEntity)field.getType()).isEmbedded() || field.getType() instanceof AdmCollection) continue;
                codeBuilder.last().appendln("        if (id == " + field.getId() + ") {");
                codeBuilder.last().appendln("            len += (_fieldInterestBitmask == null || (_fieldInterestBitmask[" + (field.getIndex() >> 6) + "] & (1L << " + (field.getIndex() & 0x3F) + ")) != 0) ? " + AdmXbufGenerator.fieldFldVarName(field) + ".desync(buffer, pos + len, frameOnly) : %{com.neeve.xbuf.XbufField}.skip(buffer, pos + len, varintDesyncLength);");
                codeBuilder.last().appendln("            if ((pos + len) >= limit) {return len;}");
                codeBuilder.last().appendln("            id = %{com.neeve.xbuf.XbufField}.fieldId(buffer, pos + len, varintDesyncLength);");
                codeBuilder.last().appendln("        }");
            }
        } else {
            codeBuilder.last().appendln("        %{com.neeve.xbuf.XbufField}.fieldId(buffer, pos + len, varintDesyncLength);");
        }
        codeBuilder.last().appendln("        return len;");
        codeBuilder.last().appendln("    }");
    }

    private final void writePoolingMethods(AdmEntity entity, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    // ----- Pooling related methods -----");
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public " + entity.getName() + " init() {");
        codeBuilder.last().appendln("        clearFieldReferences();");
        codeBuilder.last().appendln("        _container.reset();");
        this.writeFieldBitmaskClearer(codeBuilder, "");
        codeBuilder.last().appendln("        readOnly = false;");
        codeBuilder.last().appendln("        _isDirty = false;");
        codeBuilder.last().appendln("        return this;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public " + entity.getName() + " setPool(final %{com.neeve.util.UtlPool}<" + entity.getName() + "> pool) {");
        codeBuilder.last().appendln("        _pool = pool;");
        codeBuilder.last().appendln("        return this;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public %{com.neeve.util.UtlPool}<" + entity.getName() + "> getPool() {");
        codeBuilder.last().appendln("        return _pool;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    final public boolean isReferenceCounted() {");
        codeBuilder.last().appendln("        return true;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    final public " + entity.getName() + " acquire() {");
        codeBuilder.last().appendln("        final int val = _ownershipCount.incrementAndGet();");
        codeBuilder.last().appendln("        if (%{com.neeve.util.UtlReferenceTracker}.TYPE_TRACKING_ENABLED && _refTracker != null) {");
        codeBuilder.last().appendln("            _refTracker.onAcquire(val);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        if (val <= 1 && _pool != null) {");
        codeBuilder.last().appendln("            throw new IllegalStateException(\"attempt to acquire an already disposed entity\");");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        return this;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    final public int getOwnerCount() {");
        codeBuilder.last().appendln("        return _ownershipCount.get();");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    final public void dispose() {");
        codeBuilder.last().appendln("        final int val = _ownershipCount.decrementAndGet();");
        codeBuilder.last().appendln("        if (%{com.neeve.util.UtlReferenceTracker}.TYPE_TRACKING_ENABLED && _refTracker != null) {");
        codeBuilder.last().appendln("            _refTracker.onDispose(val);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        if (val < 0 && _pool != null) {");
        codeBuilder.last().appendln("            throw new IllegalStateException(\"attempt to dispose an already disposed entity\");");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        if (val == 0 && _pool != null) {");
        codeBuilder.last().appendln("            _pool.put(this);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    final private " + entity.getName() + " undispose() {");
        codeBuilder.last().appendln("        final int val = _ownershipCount.getAndSet(1);");
        codeBuilder.last().appendln("        if (%{com.neeve.util.UtlReferenceTracker}.TYPE_TRACKING_ENABLED && _refTracker != null) {");
        codeBuilder.last().appendln("            _refTracker.onInit(1);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        if (val != 0 && _pool != null) {");
        codeBuilder.last().appendln("            throw new IllegalStateException(\"attempt to undispose an entity that's not disposed\");");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        return this;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    // ----- Pooling related methods -----");
    }

    private final void writeGetContentEncodingMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public EncodingType getContentEncodingType() {");
        codeBuilder.last().appendln("        return EncodingType.Xbuf;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeSerializeMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public %{com.neeve.pkt.PktPacket} serialize() {");
        if (type instanceof AdmCollection) {
            codeBuilder.last().appendln("        return serializeForStoreCommit();");
        } else {
            codeBuilder.last().appendln("        return serializeToPacket();");
        }
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserialize(final %{com.neeve.pkt.PktPacket} packet) {");
        if (type instanceof AdmCollection) {
            codeBuilder.last().appendln("        deserializeFromStoreReplicationOrInit(packet);");
            codeBuilder.last().appendln("        return this;");
        } else {
            codeBuilder.last().appendln("        return deserializeFromPacket(packet);");
        }
        codeBuilder.last().appendln("    }");
    }

    private final void writeSetFieldValueMethod(AdmType type, List<AdmField> fields, boolean transactional, AdmEncodingType protoXbufGenCompatibility, AdmSourceCodeBuilder codeBuilder) {
        if (!type.isDeprecated() && transactional && this.getDeprecatedFieldCount(type, fields, false, false) > 0) {
            codeBuilder.last().appendln("    @SuppressWarnings(\"deprecation\")");
        }
        codeBuilder.last().appendln("    final public %{com.neeve.ods.IStoreObject} setFieldValue(final int id, final Object val) {");
        if (transactional) {
            codeBuilder.last().appendln("        boolean processed = false;");
            for (AdmField field : fields) {
                AdmType fieldType = field.getType();
                if (fieldType instanceof AdmPrimitive) {
                    codeBuilder.last().appendln("        if (!processed && id == " + AdmXbufGenerator.fieldFidVarName(field) + ") {");
                    codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldFldVarName(field) + ".setValue((" + fieldType.getTemplatedJavaTypeName() + ")val);");
                    codeBuilder.last().appendln("            processed = true;");
                    codeBuilder.last().appendln("        }");
                    continue;
                }
                if (fieldType instanceof AdmPrimitiveArray) {
                    codeBuilder.last().appendln("        if (!processed && id == " + AdmXbufGenerator.fieldFidVarName(field) + ") {");
                    switch (((AdmPrimitiveArray)fieldType).getType()) {
                        case Byte: 
                        case Char: 
                        case Short: 
                        case Integer: 
                        case Long: 
                        case Float: 
                        case Double: 
                        case Boolean: {
                            if (protoXbufGenCompatibility == null || protoXbufGenCompatibility == AdmEncodingType.Xbuf) {
                                codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldFldVarName(field) + ".setValue((" + fieldType.getTemplatedPrimitiveTypeName() + ")val);");
                                break;
                            }
                            codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldFldVarName(field) + ".setValues((" + fieldType.getTemplatedPrimitiveTypeName() + ")val);");
                            break;
                        }
                        case Date: 
                        case String: 
                        case Currency: {
                            codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldFldVarName(field) + ".setValues((" + fieldType.getTemplatedPrimitiveTypeName() + ")val);");
                            break;
                        }
                        case UUID: {
                            codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldFldVarName(field) + ".setValue((" + fieldType.getTemplatedPrimitiveTypeName() + ")val);");
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported primitive array type '" + (Object)((Object)((AdmPrimitiveArray)fieldType).getType()) + "'");
                        }
                    }
                    codeBuilder.last().appendln("            processed = true;");
                    codeBuilder.last().appendln("        }");
                    continue;
                }
                if (fieldType instanceof AdmEntity && ((AdmEntity)fieldType).isEmbedded()) {
                    codeBuilder.last().appendln("        if (!processed && id == " + AdmXbufGenerator.fieldFidVarName(field) + ") {");
                    codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldFldVarName(field) + ".setValue((" + fieldType.getTemplatedJavaTypeName() + ")val);");
                    codeBuilder.last().appendln("            processed = true;");
                    codeBuilder.last().appendln("        }");
                    continue;
                }
                if (fieldType instanceof AdmEntityArray) {
                    codeBuilder.last().appendln("        if (!processed && id == " + AdmXbufGenerator.fieldFidVarName(field) + ") {");
                    codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldFldVarName(field) + ".setValues((" + fieldType.getTemplatedJavaTypeName() + ")val);");
                    codeBuilder.last().appendln("            processed = true;");
                    codeBuilder.last().appendln("        }");
                    continue;
                }
                if (fieldType instanceof AdmEnumeration) {
                    codeBuilder.last().appendln("        if (!processed && id == " + AdmXbufGenerator.fieldFidVarName(field) + ") {");
                    if (protoXbufGenCompatibility == null) {
                        codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldFldVarName(field) + ".setValue(((" + fieldType.getTemplatedJavaTypeName() + ")val).val);");
                    } else {
                        codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldFldVarName(field) + ".setValue((" + fieldType.getTemplatedJavaTypeName() + ")val);");
                    }
                    codeBuilder.last().appendln("            processed = true;");
                    codeBuilder.last().appendln("        }");
                    continue;
                }
                if (!(fieldType instanceof AdmEnumerationArray)) continue;
                codeBuilder.last().appendln("        if (!processed && id == " + AdmXbufGenerator.fieldFidVarName(field) + ") {");
                codeBuilder.last().appendln("            " + AdmXbufGenerator.fieldFldVarName(field) + ".setValues((" + fieldType.getTemplatedJavaTypeName() + ")val);");
                codeBuilder.last().appendln("            processed = true;");
                codeBuilder.last().appendln("        }");
            }
            codeBuilder.last().appendln("        if (!processed) {");
            codeBuilder.last().appendln("            super.setFieldValue(id, val);");
            codeBuilder.last().appendln("        }");
        } else {
            codeBuilder.last().appendln("        // this method will never be called since this class was generated as a non-transactional entity");
        }
        codeBuilder.last().appendln("        return this;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeImplementedIStoreObjectMethods(AdmFactoryType type, List<AdmField> fields, boolean transactional, AdmEncodingType protoXbufGenCompatibility, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- IStoreObject methods -----");
        this.writeGetContentEncodingMethod(type, codeBuilder);
        this.writeSerializeMethod(type, codeBuilder);
        this.writeDeserializeMethod(type, codeBuilder);
        if (!(type instanceof AdmCollection)) {
            this.writeSetFieldValueMethod(type, fields, transactional, protoXbufGenCompatibility, codeBuilder);
        }
        codeBuilder.last().appendln("    // ----- IStoreObject methods -----");
    }

    private final void writeImplementedCollectionMethods(AdmCollection collection, AdmSourceCodeBuilder codeBuilder) {
        switch (collection.getType()) {
            case List: 
            case Queue: {
                break;
            }
            case CharMap: 
            case ByteMap: 
            case ShortMap: 
            case IntMap: 
            case LongMap: 
            case FloatMap: 
            case DoubleMap: 
            case StringMap: {
                AdmType keyType = collection.getKeyType();
                AdmEntity valueType = collection.getContains();
                AdmField keyField = this.keyFieldFor(collection);
                if (keyField == null) {
                    throw new IllegalStateException("No key field of type '" + keyType.getName() + "' in entity '" + valueType.getQualifiedName(collection.getModel()) + "' which is declared as value of " + (Object)((Object)collection.getType()) + " collection '" + collection.getName() + "'");
                }
                String keyJavaType = "%{" + keyType.getJavaTypeName() + "}";
                AdmPrimitive primitiveKeyType = null;
                if (keyType instanceof AdmPrimitive) {
                    primitiveKeyType = (AdmPrimitive)keyType;
                    switch (primitiveKeyType.getType()) {
                        case Long: {
                            keyJavaType = "long";
                            break;
                        }
                        case Boolean: {
                            keyJavaType = "boolean";
                            break;
                        }
                        case Byte: {
                            keyJavaType = "byte";
                            break;
                        }
                        case Char: {
                            keyJavaType = "char";
                            break;
                        }
                        case Double: {
                            keyJavaType = "double";
                            break;
                        }
                        case Float: {
                            keyJavaType = "float";
                            break;
                        }
                        case Integer: {
                            keyJavaType = "int";
                            break;
                        }
                        case Short: {
                            keyJavaType = "short";
                            break;
                        }
                        case String: {
                            keyJavaType = "%{com.neeve.lang.XString}";
                            break;
                        }
                        case Date: 
                        case Currency: 
                        case UUID: {
                            keyJavaType = "%{" + keyType.getJavaTypeName() + "}";
                        }
                    }
                }
                codeBuilder.last().appendln("    // ----- Rog Map methods -----");
                if (primitiveKeyType != null && primitiveKeyType.getType() == AdmPrimitive.Type.String) {
                    codeBuilder.last().appendln("    @Override");
                    codeBuilder.last().appendln("    final protected " + keyJavaType + " getMapElementKey(final %{" + valueType.getFullName() + "} value) {");
                    codeBuilder.last().appendln("        return value." + AdmXbufGenerator.fieldGetterUnsafeMethodName(keyField) + "();");
                    codeBuilder.last().appendln("    }");
                    codeBuilder.last().appendln("");
                    codeBuilder.last().appendln("    @Override");
                    codeBuilder.last().appendln("    final protected void setMapElementKey(final %{" + valueType.getFullName() + "} value, final " + keyJavaType + " key) {");
                    codeBuilder.last().appendln("        value." + AdmXbufGenerator.fieldSetterFromMethodName(keyField) + "(key);");
                    codeBuilder.last().appendln("    }");
                    codeBuilder.last().appendln("    @Override");
                    codeBuilder.last().appendln("    final protected void setMapElementKey(final %{" + valueType.getFullName() + "} value, final %{java.lang.CharSequence} key) {");
                    codeBuilder.last().appendln("        value." + AdmXbufGenerator.fieldSetterMethodName(keyField) + "(key == null ? null : key.toString());");
                    codeBuilder.last().appendln("    }");
                    codeBuilder.last().appendln("    @Override");
                    codeBuilder.last().appendln("    final protected void setMapElementKey(final %{" + valueType.getFullName() + "} value, final String key) {");
                    codeBuilder.last().appendln("        value." + AdmXbufGenerator.fieldSetterMethodName(keyField) + "(key);");
                    codeBuilder.last().appendln("    }");
                } else {
                    codeBuilder.last().appendln("    @Override");
                    codeBuilder.last().appendln("    final protected " + keyJavaType + " getMapElementKey(final %{" + valueType.getFullName() + "} value) {");
                    codeBuilder.last().appendln("        return value." + AdmXbufGenerator.fieldGetterMethodName(keyField) + "();");
                    codeBuilder.last().appendln("    }");
                    codeBuilder.last().appendln("");
                    codeBuilder.last().appendln("    @Override");
                    codeBuilder.last().appendln("    final protected void setMapElementKey(final %{" + valueType.getFullName() + "} value, final " + keyJavaType + " key) {");
                    codeBuilder.last().appendln("        value." + AdmXbufGenerator.fieldSetterMethodName(keyField) + "(key);");
                    codeBuilder.last().appendln("    }");
                }
                codeBuilder.last().appendln("    // ----- Rog Map methods -----");
                break;
            }
        }
    }

    final void generateClass(AdmEntity entity, AdmEncodingType protoXbufGenCompatibility, boolean generateArrayGetterEmptyIfNull, AdmSourceCodeBuilder codeBuilder) throws Exception {
        List<AdmField> fields = this.prepareFieldList(entity);
        if (protoXbufGenCompatibility == AdmEncodingType.Protobuf) {
            AdmField typeField = new AdmField(entity.getModel(), "xRogType", 1, new AdmShort());
            AdmDocumentation doc = new AdmDocumentation("Field");
            doc.setBrief("the X Platform internal field used to identify the object type.");
            doc.setFull("xRogType field is an internal field used to identify the object type to allow it to be deserialized.\nThis value <b>must not</b> be changed by user code");
            typeField.setDocumentation(doc);
            fields.add(0, typeField);
            for (AdmField field : fields) {
                if (field == typeField) continue;
                field.setId(this.protobufFieldId(field.getId()));
                field.setIndex(field.getIndex() + 1);
            }
        }
        codeBuilder.last().appendln("");
        this.writeClassDeclaration(entity, fields, codeBuilder);
        if (!entity.isEmbedded()) {
            this.writeBackingPacketClassDeclaration(entity, codeBuilder);
        }
        if (entity.isEmbedded()) {
            this.writeEntityPoolFactoryClassDeclaration(entity, codeBuilder);
            this.writeEntityFieldClassDeclarations(entity, codeBuilder);
        }
        if (entity.isMessage()) {
            codeBuilder.last().appendln("");
            this.writeRogMessageReflectorFieldDeclarations(entity, fields, AdmEncodingType.Xbuf.toString(), codeBuilder);
        }
        codeBuilder.last().appendln("");
        this.writeEnumIntAdapters(fields, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeEntityArrayIteratedValueNotificationReceivers(fields, codeBuilder);
        String last_fid = null;
        if (!entity.isEmbedded() && (entity.containsChildren() || !entity.containedInSet().isEmpty() || entity.isTransactional())) {
            codeBuilder.last().appendln("");
            last_fid = this.writeFieldFidDeclarations(entity, fields, codeBuilder);
            codeBuilder.last().appendln("");
            this.writeIndexFieldDeclarations(entity, fields, codeBuilder);
        }
        if (!entity.isEmbedded()) {
            codeBuilder.last().appendln("");
            this.writeBackingPacketDeclaration(codeBuilder);
        }
        codeBuilder.last().appendln("");
        this.writeFieldContainerDeclaration(entity, fields, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeFieldAndSchemaDeclarations(fields, protoXbufGenCompatibility, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeFieldBitmaskDeclaration(codeBuilder);
        codeBuilder.last().appendln("");
        this.writeFieldInterestBitmaskDeclaration(codeBuilder);
        codeBuilder.last().appendln("");
        this.writeObjectInstantiatedFlagDeclaration(codeBuilder);
        codeBuilder.last().appendln("");
        this.writeDirtyFlagDeclaration(codeBuilder);
        codeBuilder.last().appendln("");
        this.writeOptimizationHintmaskDeclaration(entity, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeDesyncPolicyDeclaration(entity, codeBuilder);
        if (entity.isEmbedded()) {
            codeBuilder.last().appendln("");
            this.writePoolingDeclarations(entity, codeBuilder);
        }
        if (entity.isEmbedded()) {
            codeBuilder.last().appendln("");
            this.writeReadOnlyFieldDeclaration(entity, codeBuilder);
        }
        codeBuilder.last().appendln("");
        this.writeInitializer(fields, protoXbufGenCompatibility, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeConstructors(entity, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeDesyncPolicyMethods(entity, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeFieldInterestMethods(entity, fields, codeBuilder);
        if (!entity.isEmbedded()) {
            codeBuilder.last().appendln("");
            this.writeSetContentContainerMethod(entity, protoXbufGenCompatibility, codeBuilder);
        }
        codeBuilder.last().appendln("");
        this.writeClearCachedFieldValuesMethod(fields, protoXbufGenCompatibility, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeClearContentMethod(fields, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeJsonSerializeBitmaskSyncMethod(entity, fields, codeBuilder);
        this.writeJsonDeserializeBitmaskDesyncMethod(entity, fields, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeGetBackingBufferMethod(codeBuilder);
        codeBuilder.last().appendln("");
        this.writeOptimizationHintMethods(codeBuilder);
        if (!entity.isEmbedded()) {
            if (entity.isMessage()) {
                codeBuilder.last().appendln("");
                this.writeImplementedLnkMessageMethods(codeBuilder);
            }
            codeBuilder.last().appendln("");
            this.writeImplementedIRogNodeMethods(entity, codeBuilder);
            codeBuilder.last().appendln("");
            this.writeOverridenRogNodeMethods(entity, fields, protoXbufGenCompatibility, codeBuilder, last_fid);
            if (entity.isRoot() || entity.containsChildren()) {
                codeBuilder.last().appendln("");
                this.writeOverridenRogContainerNodeMethods(entity, fields, codeBuilder);
            }
        } else {
            codeBuilder.last().appendln("");
            this.writeReadOnlyGetterSetterMethods(entity, fields, codeBuilder);
        }
        if (entity.isPojoShadow()) {
            codeBuilder.last().appendln("");
            this.writeImplementedIRogPojoShadowNodeMethods(entity, codeBuilder);
        }
        codeBuilder.last().appendln("");
        this.writeFieldMethods(entity, fields, protoXbufGenCompatibility, generateArrayGetterEmptyIfNull, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeIsDirtyMethod(entity, fields, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeSchemaCreateMethod(entity, fields, protoXbufGenCompatibility, codeBuilder);
        codeBuilder.last().appendln("");
        if (!entity.isEmbedded()) {
            this.writeMessageViewSerializerMethods(entity, fields, codeBuilder);
        } else {
            this.writeEmbeddedEntitySerializerMethods(entity, fields, codeBuilder);
        }
        codeBuilder.last().appendln("");
        this.writeImplementedIXbufDesyncerMethods(entity, fields, codeBuilder);
        if (this.isMessageReflectorImpl(entity, fields)) {
            codeBuilder.last().appendln("");
            this.writeRogMessageReflectorMethods(entity, fields, codeBuilder);
        }
        if (!entity.isEmbedded()) {
            codeBuilder.last().appendln("");
            this.writeImplementedIStoreObjectMethods(entity, fields, entity.isTransactional(), protoXbufGenCompatibility, codeBuilder);
        }
        if (entity.isEmbedded()) {
            codeBuilder.last().appendln("");
            this.writePoolingMethods(entity, codeBuilder);
        }
        if (entity.isEmbedded()) {
            codeBuilder.last().appendln("");
            this.writeCloneMethod(entity, fields, codeBuilder);
            this.writeCopyMethods(entity, codeBuilder);
        }
        if (!entity.isEmbedded()) {
            codeBuilder.last().appendln("");
            this.writeToJsonStringMethod(codeBuilder);
        }
        if (!entity.isEmbedded()) {
            codeBuilder.last().appendln("");
            this.writeVisitFieldsMethod(fields, codeBuilder);
        }
        this.writeIndexFieldsGetter(entity, fields, codeBuilder);
        this.writeValidatorMethods(entity, fields, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeToStringMethod(fields, !entity.isEmbedded(), codeBuilder);
        codeBuilder.last().appendln("    }");
    }

    final void generateClass(AdmCollection collection, AdmSourceCodeBuilder codeBuilder) throws Exception {
        ArrayList<AdmField> fields = new ArrayList<AdmField>();
        codeBuilder.last().appendln("");
        this.writeClassDeclaration(collection, codeBuilder);
        this.writeConstructors(collection, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeImplementedIStoreObjectMethods(collection, fields, true, null, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeImplementedCollectionMethods(collection, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeToJsonStringMethod(codeBuilder);
        codeBuilder.last().appendln("");
        this.writeToStringMethod(fields, true, codeBuilder);
    }

    @Override
    protected String getEntityArrayFieldIteratorMethodForSyncFieldBitmask(AdmField field) {
        return AdmXbufGenerator.fieldFldVarName(field) + ".getValueIterator(true)";
    }

    @Override
    protected String getEntityArrayFieldIteratorMethodForDesyncFieldBitmask(AdmField field) {
        return AdmXbufGenerator.fieldFldVarName(field) + ".getValueIterator(true)";
    }

    @Override
    protected String getEntityArrayFieldIteratorMethodForSetAsReadOnly(AdmField field) {
        return AdmXbufGenerator.fieldFldVarName(field) + ".getValueIterator(true)";
    }
}

