/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm;

import com.neeve.adm.AdmArray;
import com.neeve.adm.AdmCollection;
import com.neeve.adm.AdmEncodingType;
import com.neeve.adm.AdmEntity;
import com.neeve.adm.AdmEntityArray;
import com.neeve.adm.AdmEnumeration;
import com.neeve.adm.AdmEnumerationArray;
import com.neeve.adm.AdmFactoryType;
import com.neeve.adm.AdmField;
import com.neeve.adm.AdmGenerator;
import com.neeve.adm.AdmMessage;
import com.neeve.adm.AdmPooledString;
import com.neeve.adm.AdmPrimitive;
import com.neeve.adm.AdmPrimitiveArray;
import com.neeve.adm.AdmScopedType;
import com.neeve.adm.AdmSourceCodeBuilder;
import com.neeve.adm.AdmString;
import com.neeve.adm.AdmStringArray;
import com.neeve.adm.AdmType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class AdmXbuf2Generator
extends AdmGenerator {
    AdmXbuf2Generator() {
    }

    private final int getSyncedFieldCount(AdmScopedType entity, List<AdmField> fields) {
        int syncedFieldCount = 0;
        for (AdmField field : fields) {
            if (field.getType() instanceof AdmEntity && !((AdmEntity)field.getType()).isEmbedded() || field.getType() instanceof AdmCollection) continue;
            ++syncedFieldCount;
        }
        return syncedFieldCount;
    }

    private final int getPrimitiveTypeSerializedLength(AdmPrimitive.Type primitiveType) {
        int len = primitiveType.getSerializedLength();
        if (len == 0) {
            throw new RuntimeException("variable length primitive type");
        }
        return len;
    }

    private final void writeClassDeclaration(AdmCollection collection, AdmSourceCodeBuilder codeBuilder) {
        if (collection.isDeprecated()) {
            codeBuilder.last().appendln("@Deprecated");
        }
        AdmGenerator.writeAdmGeneratedAnnotations(this.getClass(), AdmEncodingType.Xbuf2, collection.getModel(), codeBuilder);
        AdmGenerator.writeFactoryTypeInfoAnnotation(collection, codeBuilder);
        codeBuilder.last().append("final public class " + collection.getName() + " extends ");
        switch (collection.getType()) {
            case List: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogList}<");
                break;
            }
            case Queue: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogQueue}<");
                break;
            }
            case CharMap: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogXCharMap}<");
                break;
            }
            case ByteMap: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogXByteMap}<");
                break;
            }
            case ShortMap: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogXShortMap}<");
                break;
            }
            case IntMap: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogXIntMap}<");
                break;
            }
            case LongMap: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogXLongMap}<");
                break;
            }
            case FloatMap: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogXFloatMap}<");
                break;
            }
            case DoubleMap: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogXDoubleMap}<");
                break;
            }
            case StringMap: {
                codeBuilder.last().append("%{com.neeve.rog.impl.RogQuarkStringMap}<");
                break;
            }
            default: {
                throw new IllegalStateException("unknown collection type '" + (Object)((Object)collection.getType()) + "'");
            }
        }
        codeBuilder.last().append(collection.getContains().getTemplatedJavaTypeName() + "> implements " + AdmXbuf2Generator.interfaceTemplatedTypeName(collection));
        codeBuilder.last().append(", %{com.neeve.rog.IRogJsonizable}");
        codeBuilder.last().appendln(" {");
    }

    private final void writeClassDeclaration(AdmEntity entity, List<AdmField> fields, AdmSourceCodeBuilder codeBuilder) {
        AdmXbuf2Generator.writeJavadocTypeComment("", entity, codeBuilder);
        AdmGenerator.writeAdmGeneratedAnnotations(this.getClass(), AdmEncodingType.Xbuf2, entity.getModel(), codeBuilder);
        AdmGenerator.writeFactoryTypeInfoAnnotation(entity, codeBuilder);
        AdmGenerator.writeJsonPropertyOrderAnnotation(entity, fields, false, codeBuilder);
        codeBuilder.newCodeSegment();
        codeBuilder.last().append(entity.isFinal() ? "final " : "").append("public class " + entity.getName());
        if (!entity.isEmbedded()) {
            if (entity.isRoot()) {
                codeBuilder.last().append(" extends %{com.neeve.rog.impl.RogRootNode}");
            } else if (entity.containsChildren()) {
                codeBuilder.last().append(" extends %{com.neeve.rog.impl.RogContainerNode}");
            } else {
                codeBuilder.last().append(" extends %{com.neeve.rog.impl.RogNode}");
            }
            codeBuilder.last().append(" implements " + AdmXbuf2Generator.interfaceTemplatedTypeName(entity));
            if (entity.containedInSet().size() > 0) {
                Iterator<AdmCollection.Type> typeIterator = entity.containedInSet().iterator();
                boolean implementedCollectionNodeElement = false;
                while (typeIterator.hasNext()) {
                    AdmCollection.Type collectionType = typeIterator.next();
                    switch (collectionType) {
                        case StringMap: {
                            codeBuilder.last().append(", %{com.neeve.rog.IRogQuarkStringMapElement}");
                            break;
                        }
                    }
                }
            }
            if (entity.isMessage()) {
                codeBuilder.last().append(", %{com.neeve.sma.MessageReflector}");
            }
            if (this.useIOBufferAsBackingStorage(entity)) {
                codeBuilder.last().append(", %{com.neeve.xbuf2.IXbufMessage}");
            } else {
                codeBuilder.last().append(", %{com.neeve.io.IIONativeBackedEntity}");
            }
            codeBuilder.last().append(", %{com.neeve.rog.IRogJsonizable}");
        } else if (entity.getGenerateEmbeddedEntityInterfaces()) {
            codeBuilder.last().append(" implements " + AdmXbuf2Generator.interfaceTemplatedTypeName(entity));
        } else {
            codeBuilder.last().append(" implements %{com.neeve.rog.IRogValidatable}");
        }
        codeBuilder.last().append(", %{com.neeve.util.UtlPool}.Item<" + entity.getName() + ">");
        codeBuilder.last().append(", %{com.neeve.adm.runtime.AdmRuntime}.BufferSizer");
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln(" {");
    }

    private final void writeBackingPacketClassDeclaration(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    /**");
        codeBuilder.last().appendln("     * The backing packet type for " + type.getTemplatedJavaTypeName() + " (used internally for serialization purposes).");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    final public static class PacketBody extends %{com.neeve.pkt.types.PktBodyData} {");
        codeBuilder.last().appendln("        private PacketBody(final %{java.util.Properties} props, final boolean direct) {");
        codeBuilder.last().appendln("            super(" + type.getFactory().getName() + ".PKTID_" + type.getName() + ", props, direct);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("        public static %{com.neeve.pkt.PktBody} create(final %{java.util.Properties} props) {");
        codeBuilder.last().appendln("            return new PacketBody(props, true);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("        public static %{com.neeve.pkt.PktBody} create() {");
        codeBuilder.last().appendln("            return PacketBody.create(null);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
    }

    private final void writePoolFactoriesClassDeclarations(AdmEntity entity, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    /**");
        codeBuilder.last().appendln("     * The " + entity.getName() + " pool factory create item argument.");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    final static class " + entity.getName() + "PoolFactoryItemCreateArgument {");
        codeBuilder.last().appendln("        %{com.eaio.uuid.UUID} id;");
        codeBuilder.last().appendln("        boolean wasCreated;");
        codeBuilder.last().appendln("        " + entity.getName() + "PoolFactoryItemCreateArgument init(final %{com.eaio.uuid.UUID} id) {");
        codeBuilder.last().appendln("            this.id = id;");
        codeBuilder.last().appendln("            this.wasCreated = false;");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    /**");
        codeBuilder.last().appendln("     * The " + entity.getName() + " pool factory.");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    final private static class " + entity.getName() + "PoolFactory implements %{com.neeve.util.UtlPool}.Factory<" + entity.getName() + "> {");
        codeBuilder.last().appendln("        final public " + entity.getName() + " createItem(final Object object) {");
        if (entity.isEmbedded()) {
            codeBuilder.last().appendln("            return new " + entity.getName() + "();");
        } else {
            codeBuilder.last().appendln("            final " + entity.getName() + "PoolFactoryItemCreateArgument arg = (" + entity.getName() + "PoolFactoryItemCreateArgument)object;");
            codeBuilder.last().appendln("            arg.wasCreated = true;");
            codeBuilder.last().appendln("            return new " + entity.getName() + "(arg.id);");
        }
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public " + entity.getName() + "[] createItemArray(final int size) {");
        codeBuilder.last().appendln("            return new " + entity.getName() + "[size];");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    /**");
        codeBuilder.last().appendln("     * The " + entity.getName() + " pool evicted item receiver");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    final private static class " + entity.getName() + "PoolEvictedItemReceiver implements UtlPool.EvictedItemReceiver<" + entity.getName() + "> {");
        codeBuilder.last().appendln("        @Override");
        codeBuilder.last().appendln("        final public void process(final " + entity.getName() + " evictedItem) {");
        codeBuilder.last().appendln("            _memoryStats.onEntityLeaked(" + entity.getFullName() + ".class, MemoryStats.EntityType." + AdmXbuf2Generator.getMemoryStatsEntityType(entity) + ");");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    /**");
        codeBuilder.last().appendln("     * The " + entity.getName() + " pojo pool factory.");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    final private static class " + entity.getName() + "PojoPoolFactory implements %{com.neeve.util.UtlPool}.Factory<" + entity.getName() + ".Pojo> {");
        codeBuilder.last().appendln("        final public " + entity.getName() + ".Pojo createItem(final Object object) {");
        codeBuilder.last().appendln("            return new " + entity.getName() + ".Pojo();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public " + entity.getName() + ".Pojo[] createItemArray(final int size) {");
        codeBuilder.last().appendln("            return new " + entity.getName() + ".Pojo[size];");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    /**");
        codeBuilder.last().appendln("     * The " + entity.getName() + " pojo pool evicted item receiver");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    final private static class " + entity.getName() + "PojoPoolEvictedItemReceiver implements UtlPool.EvictedItemReceiver<" + entity.getName() + ".Pojo> {");
        codeBuilder.last().appendln("        @Override");
        codeBuilder.last().appendln("        final public void process(final " + entity.getName() + ".Pojo evictedItem) {");
        codeBuilder.last().appendln("            _memoryStats.onEntityPojoLeaked(" + entity.getFullName() + ".class, MemoryStats.EntityType." + AdmXbuf2Generator.getMemoryStatsEntityType(entity) + ");");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    /**");
        codeBuilder.last().appendln("     * The " + entity.getName() + " serializer pool factory.");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    final private static class " + entity.getName() + "SerializerPoolFactory implements %{com.neeve.util.UtlPool}.Factory<" + entity.getName() + ".Serializer> {");
        codeBuilder.last().appendln("        final public " + entity.getName() + ".Serializer createItem(final Object object) {");
        codeBuilder.last().appendln("            return new " + entity.getName() + ".Serializer();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public " + entity.getName() + ".Serializer[] createItemArray(final int size) {");
        codeBuilder.last().appendln("            return new " + entity.getName() + ".Serializer[size];");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    /**");
        codeBuilder.last().appendln("     * The " + entity.getName() + " serializer pool evicted item receiver");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    final private static class " + entity.getName() + "SerializerPoolEvictedItemReceiver implements UtlPool.EvictedItemReceiver<" + entity.getName() + ".Serializer> {");
        codeBuilder.last().appendln("        @Override");
        codeBuilder.last().appendln("        final public void process(final " + entity.getName() + ".Serializer evictedItem) {");
        codeBuilder.last().appendln("            _memoryStats.onEntitySerializerLeaked(" + entity.getFullName() + ".class, MemoryStats.EntityType." + AdmXbuf2Generator.getMemoryStatsEntityType(entity) + ");");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    /**");
        codeBuilder.last().appendln("     * The " + entity.getName() + " deserializer pool factory.");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    final private static class " + entity.getName() + "DeserializerPoolFactory implements %{com.neeve.util.UtlPool}.Factory<" + entity.getName() + ".Deserializer> {");
        codeBuilder.last().appendln("        final public " + entity.getName() + ".Deserializer createItem(final Object object) {");
        codeBuilder.last().appendln("            return new " + entity.getName() + ".Deserializer();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public " + entity.getName() + ".Deserializer[] createItemArray(final int size) {");
        codeBuilder.last().appendln("            return new " + entity.getName() + ".Deserializer[size];");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    /**");
        codeBuilder.last().appendln("     * The " + entity.getName() + " deserializer pool evicted item receiver");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    final private static class " + entity.getName() + "DeserializerPoolEvictedItemReceiver implements UtlPool.EvictedItemReceiver<" + entity.getName() + ".Deserializer> {");
        codeBuilder.last().appendln("        @Override");
        codeBuilder.last().appendln("        final public void process(final " + entity.getName() + ".Deserializer evictedItem) {");
        codeBuilder.last().appendln("            _memoryStats.onEntityDeserializerLeaked(" + entity.getFullName() + ".class, MemoryStats.EntityType." + AdmXbuf2Generator.getMemoryStatsEntityType(entity) + ");");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
    }

    private final void writeUserEntityOrEntityArrayFieldSerializerMethods(AdmField field, AdmSourceCodeBuilder codeBuilder) {
        String entityName = field.getType() instanceof AdmEntityArray ? ((AdmEntityArray)field.getType()).getType().getTemplatedJavaTypeName() : ((AdmEntity)field.getType()).getTemplatedJavaTypeName();
        codeBuilder.last().appendln("        final public Serializer " + AdmXbuf2Generator.fieldSerializerMethodName(field) + "(final " + entityName + " val) {");
        codeBuilder.last().appendln("            if (!isInitialized()) throw new IllegalStateException(\"not initialized\");");
        codeBuilder.last().appendln("            if (val == null) return this;");
        codeBuilder.last().appendln("            val.sync();");
        codeBuilder.last().appendln("            final int serializedEntityLength = val.getSerializedBufferLength();");
        codeBuilder.last().appendln("            if (hasSizer()) ensureCapacity(_len + %{com.neeve.xbuf2.XbufUtil}.varlenFieldSerializedLength(" + field.getId() + ", serializedEntityLength));");
        codeBuilder.last().appendln("            _len += %{com.neeve.quark.QuarkBuffer}.putVarint32(_addr, _len, (" + field.getId() + " << 3) | 0x02);");
        codeBuilder.last().appendln("            _len += %{com.neeve.quark.QuarkBuffer}.putVarint32(_addr, _len, serializedEntityLength);");
        codeBuilder.last().appendln("            val.serializeTo(_addr, _len);");
        codeBuilder.last().appendln("            _len += serializedEntityLength;");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public Serializer " + AdmXbuf2Generator.fieldSerializerMethodName(field) + "(final " + entityName + ".Serializer val) {");
        codeBuilder.last().appendln("            if (!isInitialized()) throw new IllegalStateException(\"not initialized\");");
        codeBuilder.last().appendln("            if (val == null) return this;");
        codeBuilder.last().appendln("            if (hasSizer()) ensureCapacity(_len + %{com.neeve.xbuf2.XbufUtil}.varlenFieldSerializedLength(" + field.getId() + ", val.getSerializedLength()));");
        codeBuilder.last().appendln("            _len += %{com.neeve.quark.QuarkBuffer}.putVarint32(_addr, _len, (" + field.getId() + " << 3) | 0x02);");
        codeBuilder.last().appendln("            _len += %{com.neeve.quark.QuarkBuffer}.putVarint32(_addr, _len, val.getSerializedLength());");
        codeBuilder.last().appendln("            _len += val.getTo(_addr, _len);");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public Serializer " + AdmXbuf2Generator.fieldSerializerMethodName(field) + "(final " + entityName + ".Deserializer val) {");
        codeBuilder.last().appendln("            if (!isInitialized()) throw new IllegalStateException(\"not initialized\");");
        codeBuilder.last().appendln("            if (val == null) return this;");
        codeBuilder.last().appendln("            if (hasSizer()) ensureCapacity(_len + %{com.neeve.xbuf2.XbufUtil}.varlenFieldSerializedLength(" + field.getId() + ", val.getSerializedLength()));");
        codeBuilder.last().appendln("            _len += %{com.neeve.quark.QuarkBuffer}.putVarint32(_addr, _len, (" + field.getId() + " << 3) | 0x02);");
        codeBuilder.last().appendln("            _len += %{com.neeve.quark.QuarkBuffer}.putVarint32(_addr, _len, val.getSerializedLength());");
        codeBuilder.last().appendln("            _len += val.getTo(_addr, _len);");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public Serializer " + AdmXbuf2Generator.fieldSerializerMethodName(field) + "(final %{com.neeve.quark.QuarkBuffer} val, final int offset, final int len) {");
        codeBuilder.last().appendln("            if (!isInitialized()) throw new IllegalStateException(\"not initialized\");");
        codeBuilder.last().appendln("            if (val == null && (offset > 0 || len > 0)) throw new IllegalArgumentException(\"null buffer can only be specified with offset=0 and len=0 (to serialize an empty entity))\");");
        codeBuilder.last().appendln("            if (hasSizer()) ensureCapacity(_len + %{com.neeve.xbuf2.XbufUtil}.varlenFieldSerializedLength(" + field.getId() + ", len));");
        codeBuilder.last().appendln("            _len += %{com.neeve.quark.QuarkBuffer}.putVarint32(_addr, _len, (" + field.getId() + " << 3) | 0x02);");
        codeBuilder.last().appendln("            _len += %{com.neeve.quark.QuarkBuffer}.putVarint32(_addr, _len, len);");
        codeBuilder.last().appendln("            if (val != null) val.getTo(offset, _addr, _len, len);");
        codeBuilder.last().appendln("            _len += len;");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
    }

    private final void writeUserPrimitiveOrPrimitiveArrayFieldSerializerMethods(AdmEntity entity, AdmField field, AdmPrimitive.Type primitiveType, AdmSourceCodeBuilder codeBuilder) {
        switch (primitiveType) {
            case Byte: 
            case Char: 
            case Short: 
            case Integer: {
                codeBuilder.last().appendln("        final public Serializer " + AdmXbuf2Generator.fieldSerializerMethodName(field) + "(final " + primitiveType.getPrimitiveTypeName() + " val) {");
                codeBuilder.last().appendln("            if (!isInitialized()) throw new IllegalStateException(\"not initialized\");");
                codeBuilder.last().appendln("            if (hasSizer()) ensureCapacity(_len + %{com.neeve.xbuf2.XbufUtil}.primitiveFieldSerializedLength(" + field.getId() + ", val));");
                codeBuilder.last().appendln("            _len += %{com.neeve.quark.QuarkBuffer}.putVarint32(_addr, _len, (" + field.getId() + " << 3) | 0x00);");
                codeBuilder.last().appendln("            _len += %{com.neeve.quark.QuarkBuffer}.putVarint32(_addr, _len, val);");
                codeBuilder.last().appendln("            return this;");
                codeBuilder.last().appendln("        }");
                break;
            }
            case Long: {
                codeBuilder.last().appendln("        final public Serializer " + AdmXbuf2Generator.fieldSerializerMethodName(field) + "(final long val) {");
                codeBuilder.last().appendln("            if (!isInitialized()) throw new IllegalStateException(\"not initialized\");");
                codeBuilder.last().appendln("            if (hasSizer()) ensureCapacity(_len + %{com.neeve.xbuf2.XbufUtil}.primitiveFieldSerializedLength(" + field.getId() + ", val));");
                codeBuilder.last().appendln("            _len += %{com.neeve.quark.QuarkBuffer}.putVarint32(_addr, _len, (" + field.getId() + " << 3) | 0x00);");
                codeBuilder.last().appendln("            _len += %{com.neeve.quark.QuarkBuffer}.putVarint64(_addr, _len, val);");
                codeBuilder.last().appendln("            return this;");
                codeBuilder.last().appendln("        }");
                break;
            }
            case Float: {
                codeBuilder.last().appendln("        final public Serializer " + AdmXbuf2Generator.fieldSerializerMethodName(field) + "(final float val) {");
                codeBuilder.last().appendln("            if (!isInitialized()) throw new IllegalStateException(\"not initialized\");");
                codeBuilder.last().appendln("            if (hasSizer()) ensureCapacity(_len + %{com.neeve.xbuf2.XbufUtil}.primitiveFieldSerializedLength(" + field.getId() + ", val));");
                codeBuilder.last().appendln("            _len += %{com.neeve.quark.QuarkBuffer}.putVarint32(_addr, _len, (" + field.getId() + " << 3) | 0x05);");
                codeBuilder.last().appendln("            %{com.neeve.quark.QuarkBuffer}.putFloat(_addr, _len, val);");
                codeBuilder.last().appendln("            _len += 4;");
                codeBuilder.last().appendln("            return this;");
                codeBuilder.last().appendln("        }");
                break;
            }
            case Double: {
                codeBuilder.last().appendln("        final public Serializer " + AdmXbuf2Generator.fieldSerializerMethodName(field) + "(final double val) {");
                codeBuilder.last().appendln("            if (!isInitialized()) throw new IllegalStateException(\"not initialized\");");
                codeBuilder.last().appendln("            if (hasSizer()) ensureCapacity(_len + %{com.neeve.xbuf2.XbufUtil}.primitiveFieldSerializedLength(" + field.getId() + ", val));");
                codeBuilder.last().appendln("            _len += %{com.neeve.quark.QuarkBuffer}.putVarint32(_addr, _len, (" + field.getId() + " << 3) | 0x01);");
                codeBuilder.last().appendln("            %{com.neeve.quark.QuarkBuffer}.putDouble(_addr, _len, val);");
                codeBuilder.last().appendln("            _len += 8;");
                codeBuilder.last().appendln("            return this;");
                codeBuilder.last().appendln("        }");
                break;
            }
            case Boolean: {
                codeBuilder.last().appendln("        final public Serializer " + AdmXbuf2Generator.fieldSerializerMethodName(field) + "(final boolean val) {");
                codeBuilder.last().appendln("            if (!isInitialized()) throw new IllegalStateException(\"not initialized\");");
                codeBuilder.last().appendln("            if (hasSizer()) ensureCapacity(_len + %{com.neeve.xbuf2.XbufUtil}.primitiveFieldSerializedLength(" + field.getId() + ", val));");
                codeBuilder.last().appendln("            _len += %{com.neeve.quark.QuarkBuffer}.putVarint32(_addr, _len, (" + field.getId() + " << 3) | 0x00);");
                codeBuilder.last().appendln("            _len += %{com.neeve.quark.QuarkBuffer}.putVarint32(_addr, _len, val ? 1 : 0);");
                codeBuilder.last().appendln("            return this;");
                codeBuilder.last().appendln("        }");
                break;
            }
            case Date: {
                codeBuilder.last().appendln("        final public Serializer " + AdmXbuf2Generator.fieldSerializerMethodName(field) + "(final long val) {");
                codeBuilder.last().appendln("            if (!isInitialized()) throw new IllegalStateException(\"not initialized\");");
                codeBuilder.last().appendln("            if (hasSizer()) ensureCapacity(_len + %{com.neeve.xbuf2.XbufUtil}.primitiveFieldSerializedLength(" + field.getId() + ", val));");
                codeBuilder.last().appendln("            _len += %{com.neeve.quark.QuarkBuffer}.putVarint32(_addr, _len, (" + field.getId() + " << 3) | 0x00);");
                codeBuilder.last().appendln("            _len += %{com.neeve.quark.QuarkBuffer}.putVarint64(_addr, _len, val);");
                codeBuilder.last().appendln("            return this;");
                codeBuilder.last().appendln("        }");
                break;
            }
            case String: {
                codeBuilder.last().appendln("        final public Serializer " + AdmXbuf2Generator.fieldSerializerMethodName(field) + "(final String val) {");
                codeBuilder.last().appendln("            if (!isInitialized()) throw new IllegalStateException(\"not initialized\");");
                codeBuilder.last().appendln("            if (val == null) return this;");
                codeBuilder.last().appendln("            if (hasSizer()) ensureCapacity(_len + %{com.neeve.xbuf2.XbufUtil}.varlenFieldSerializedLength(" + field.getId() + ", %{com.neeve.quark.QuarkBuffer}.calculateUTF8Length(val)));");
                codeBuilder.last().appendln("            _len += %{com.neeve.quark.QuarkBuffer}.putVarint32(_addr, _len, (" + field.getId() + " << 3) | 0x02);");
                codeBuilder.last().appendln("            _len += %{com.neeve.quark.QuarkBuffer}.putVarint32(_addr, _len, val.length());");
                codeBuilder.last().appendln("            _len += %{com.neeve.quark.QuarkBuffer}.putUTF8CharSequence(_addr, _len, val);");
                codeBuilder.last().appendln("            return this;");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        final public Serializer " + AdmXbuf2Generator.fieldSerializerMethodName(field) + "(final %{com.neeve.quark.QuarkString} val) {");
                codeBuilder.last().appendln("            if (!isInitialized()) throw new IllegalStateException(\"not initialized\");");
                codeBuilder.last().appendln("            if (val == null || val.isNull()) return this;");
                codeBuilder.last().appendln("            if (hasSizer()) ensureCapacity(_len + %{com.neeve.xbuf2.XbufUtil}.varlenFieldSerializedLength(" + field.getId() + ", val.length()));");
                codeBuilder.last().appendln("            _len += %{com.neeve.quark.QuarkBuffer}.putVarint32(_addr, _len, (" + field.getId() + " << 3) | 0x02);");
                codeBuilder.last().appendln("            _len += %{com.neeve.quark.QuarkBuffer}.putVarint32(_addr, _len, val.length());");
                codeBuilder.last().appendln("            _len += val.getTo(_addr, _len);");
                codeBuilder.last().appendln("            return this;");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        final public Serializer " + AdmXbuf2Generator.fieldSerializerMethodName(field) + "(final %{com.neeve.lang.XString} val) {");
                codeBuilder.last().appendln("            if (!isInitialized()) throw new IllegalStateException(\"not initialized\");");
                codeBuilder.last().appendln("            if (val == null || val.isNull()) return this;");
                codeBuilder.last().appendln("            if (hasSizer()) ensureCapacity(_len + %{com.neeve.xbuf2.XbufUtil}.varlenFieldSerializedLength(" + field.getId() + ", val.serializedLength()));");
                codeBuilder.last().appendln("            _len += %{com.neeve.quark.QuarkBuffer}.putVarint32(_addr, _len, (" + field.getId() + " << 3) | 0x02);");
                codeBuilder.last().appendln("            _len += %{com.neeve.quark.QuarkBuffer}.putVarint32(_addr, _len, val.length());");
                codeBuilder.last().appendln("            val.getBackingBuffer().getToNative(val.getBackingBufferOffset(), _addr, _len, val.serializedLength());");
                codeBuilder.last().appendln("            _len += val.serializedLength();");
                codeBuilder.last().appendln("            return this;");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        final public Serializer " + AdmXbuf2Generator.fieldSerializerMethodName(field) + "(final byte[] val, final int offset, final int len) {");
                codeBuilder.last().appendln("            if (!isInitialized()) throw new IllegalStateException(\"not initialized\");");
                codeBuilder.last().appendln("            if (val == null) return this;");
                codeBuilder.last().appendln("            if (hasSizer()) ensureCapacity(_len + %{com.neeve.xbuf2.XbufUtil}.varlenFieldSerializedLength(" + field.getId() + ", len));");
                codeBuilder.last().appendln("            _len += %{com.neeve.quark.QuarkBuffer}.putVarint32(_addr, _len, (" + field.getId() + " << 3) | 0x02);");
                codeBuilder.last().appendln("            _len += %{com.neeve.quark.QuarkBuffer}.putVarint32(_addr, _len, len);");
                codeBuilder.last().appendln("            %{com.neeve.quark.QuarkBuffer}.putFrom(_addr, _len, val, offset, len);");
                codeBuilder.last().appendln("            _len += len;");
                codeBuilder.last().appendln("            return this;");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        final public Serializer " + AdmXbuf2Generator.fieldSerializerMethodName(field) + "(final byte[] val) {");
                codeBuilder.last().appendln("            return " + AdmXbuf2Generator.fieldSerializerMethodName(field) + "(val, 0, val.length);");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        final public Serializer " + AdmXbuf2Generator.fieldSerializerMethodName(field) + "(final %{com.neeve.quark.QuarkStringDeserializer} val) {");
                codeBuilder.last().appendln("            if (!isInitialized()) throw new IllegalStateException(\"not initialized\");");
                codeBuilder.last().appendln("            if (val == null) return this;");
                codeBuilder.last().appendln("            if (hasSizer()) ensureCapacity(_len + %{com.neeve.xbuf2.XbufUtil}.varlenFieldSerializedLength(" + field.getId() + ", val.serializedLength()));");
                codeBuilder.last().appendln("            _len += %{com.neeve.quark.QuarkBuffer}.putVarint32(_addr, _len, (" + field.getId() + " << 3) | 0x02);");
                codeBuilder.last().appendln("            _len += %{com.neeve.quark.QuarkBuffer}.putVarint32(_addr, _len, val.serializedLength());");
                codeBuilder.last().appendln("            _len += val.getTo(_addr, _len);");
                codeBuilder.last().appendln("            return this;");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        final public Serializer " + AdmXbuf2Generator.fieldSerializerMethodName(field) + "(final %{com.neeve.quark.QuarkBuffer} val, final int offset, final int len) {");
                codeBuilder.last().appendln("            if (!isInitialized()) throw new IllegalStateException(\"not initialized\");");
                codeBuilder.last().appendln("            if (val == null) return this;");
                codeBuilder.last().appendln("            if (hasSizer()) ensureCapacity(_len + %{com.neeve.xbuf2.XbufUtil}.varlenFieldSerializedLength(" + field.getId() + ", len));");
                codeBuilder.last().appendln("            _len += %{com.neeve.quark.QuarkBuffer}.putVarint32(_addr, _len, (" + field.getId() + " << 3) | 0x02);");
                codeBuilder.last().appendln("            _len += %{com.neeve.quark.QuarkBuffer}.putVarint32(_addr, _len, len);");
                codeBuilder.last().appendln("            val.getTo(offset, _addr, _len, len);");
                codeBuilder.last().appendln("            _len += len;");
                codeBuilder.last().appendln("            return this;");
                codeBuilder.last().appendln("        }");
                break;
            }
            case Currency: {
                break;
            }
            case UUID: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown primitive field type ['" + (Object)((Object)primitiveType) + "]");
            }
        }
    }

    private final void writeUserEnumerationOrEnumerationArrayFieldSerializerMethods(AdmEntity entity, AdmField field, String fieldTypeTemplatedJavaTypeName, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("        final public Serializer " + AdmXbuf2Generator.fieldSerializerMethodName(field) + "(final " + fieldTypeTemplatedJavaTypeName + " val) {");
        codeBuilder.last().appendln("            if (!isInitialized()) throw new IllegalStateException(\"not initialized\");");
        codeBuilder.last().appendln("            if (val == null) return this;");
        codeBuilder.last().appendln("            if (hasSizer()) ensureCapacity(_len + %{com.neeve.xbuf2.XbufUtil}.primitiveFieldSerializedLength(" + field.getId() + ", val.val));");
        codeBuilder.last().appendln("            _len += %{com.neeve.quark.QuarkBuffer}.putVarint32(_addr, _len, (" + field.getId() + " << 3) | 0x00);");
        codeBuilder.last().appendln("            _len += %{com.neeve.quark.QuarkBuffer}.putVarint32(_addr, _len, val.val);");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
    }

    private final void writeUserPrimitiveFieldSerializerMethods(AdmEntity entity, AdmField field, AdmSourceCodeBuilder codeBuilder) {
        this.writeUserPrimitiveOrPrimitiveArrayFieldSerializerMethods(entity, field, ((AdmPrimitive)field.getType()).getType(), codeBuilder);
    }

    private final void writeUserPrimitiveArrayFieldSerializerMethods(AdmEntity entity, AdmField field, AdmSourceCodeBuilder codeBuilder) {
        AdmPrimitive.Type primitiveType = ((AdmPrimitiveArray)field.getType()).getType();
        this.writeUserPrimitiveOrPrimitiveArrayFieldSerializerMethods(entity, field, primitiveType, codeBuilder);
        switch (primitiveType) {
            case Byte: 
            case Char: 
            case Short: 
            case Integer: 
            case Long: 
            case Float: 
            case Double: 
            case Boolean: {
                codeBuilder.last().appendln("        final public Serializer " + AdmXbuf2Generator.fieldSerializerMethodName(field) + "(final " + primitiveType.getTemplatedZGXIteratorType() + " val) {");
                codeBuilder.last().appendln("            if (val == null) return this;");
                codeBuilder.last().appendln("            while (val.hasNext()) " + AdmXbuf2Generator.fieldSerializerMethodName(field) + "(val.next());");
                codeBuilder.last().appendln("            return this;");
                codeBuilder.last().appendln("        }");
                break;
            }
            case Date: {
                codeBuilder.last().appendln("        final public Serializer " + AdmXbuf2Generator.fieldSerializerMethodName(field) + "(final " + primitiveType.getTemplatedZGXIteratorType() + " val) {");
                codeBuilder.last().appendln("            if (val == null) return this;");
                codeBuilder.last().appendln("            while (val.hasNext()) " + AdmXbuf2Generator.fieldSerializerMethodName(field) + "(val.nextAsTimestamp());");
                codeBuilder.last().appendln("            return this;");
                codeBuilder.last().appendln("        }");
                break;
            }
            case String: {
                codeBuilder.last().appendln("        final public Serializer " + AdmXbuf2Generator.fieldSerializerMethodName(field) + "(final %{com.neeve.quark.QuarkStringIterator} val) {");
                codeBuilder.last().appendln("            if (!isInitialized()) throw new IllegalStateException(\"not initialized\");");
                codeBuilder.last().appendln("            if (val == null) return this;");
                codeBuilder.last().appendln("            while (val.hasNext()) {;");
                codeBuilder.last().appendln("               final int len = val.nextLength(false);");
                codeBuilder.last().appendln("               if (hasSizer()) ensureCapacity(_len + %{com.neeve.xbuf2.XbufUtil}.varlenFieldSerializedLength(" + field.getId() + ", len));");
                codeBuilder.last().appendln("               _len += %{com.neeve.quark.QuarkBuffer}.putVarint32(_addr, _len, (" + field.getId() + " << 3) | 0x02);");
                codeBuilder.last().appendln("               _len += %{com.neeve.quark.QuarkBuffer}.putVarint32(_addr, _len, len);");
                codeBuilder.last().appendln("               val.nextInto(_addr, _len);");
                codeBuilder.last().appendln("               _len += len;");
                codeBuilder.last().appendln("            };");
                codeBuilder.last().appendln("            return this;");
                codeBuilder.last().appendln("        }");
                break;
            }
            case Currency: {
                break;
            }
            case UUID: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown primitive field type ['" + (Object)((Object)primitiveType) + "]");
            }
        }
    }

    private final void writeUserEntityArrayFieldSerializerMethods(AdmEntity entity, AdmField field, AdmSourceCodeBuilder codeBuilder) {
        this.writeUserEntityOrEntityArrayFieldSerializerMethods(field, codeBuilder);
    }

    private final void writeUserEnumerationArrayFieldSerializerMethods(AdmEntity entity, AdmField field, AdmSourceCodeBuilder codeBuilder) {
        String fieldTypeTemplatedJavaTypeName = ((AdmEnumerationArray)field.getType()).getType().getTemplatedJavaTypeName();
        this.writeUserEnumerationOrEnumerationArrayFieldSerializerMethods(entity, field, fieldTypeTemplatedJavaTypeName, codeBuilder);
        codeBuilder.last().appendln("        final public Serializer " + AdmXbuf2Generator.fieldSerializerMethodName(field) + "(final %{com.neeve.lang.XIterator}<" + fieldTypeTemplatedJavaTypeName + "> val) {");
        codeBuilder.last().appendln("            if (val == null) return this;");
        codeBuilder.last().appendln("            while (val.hasNext()) " + AdmXbuf2Generator.fieldSerializerMethodName(field) + "(val.next());");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
    }

    private final void writeUserEnumerationFieldSerializerMethods(AdmEntity entity, AdmField field, AdmSourceCodeBuilder codeBuilder) {
        this.writeUserEnumerationOrEnumerationArrayFieldSerializerMethods(entity, field, ((AdmEnumeration)field.getType()).getTemplatedJavaTypeName(), codeBuilder);
    }

    private final void writeUserEntityFieldSerializerMethods(AdmEntity entity, AdmField field, AdmSourceCodeBuilder codeBuilder) {
        this.writeUserEntityOrEntityArrayFieldSerializerMethods(field, codeBuilder);
    }

    private final void writeSerializerClassDeclaration(AdmEntity entity, List<AdmField> fields, AdmSourceCodeBuilder codeBuilder) {
        AdmType fieldType;
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    /**");
        codeBuilder.last().appendln("     * The serializer");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    final public static class Serializer implements %{com.neeve.util.UtlPool}.Item<Serializer>, %{com.neeve.adm.runtime.AdmRuntime}.BufferSizer {");
        for (AdmField field : fields) {
            fieldType = field.getType();
            if ((!(fieldType instanceof AdmEntity) || !((AdmEntity)fieldType).isEmbedded()) && !(fieldType instanceof AdmEntityArray)) continue;
            String entityName = fieldType instanceof AdmEntityArray ? ((AdmEntityArray)field.getType()).getType().getTemplatedJavaTypeName() : ((AdmEntity)fieldType).getTemplatedJavaTypeName();
            codeBuilder.last().appendln("        final private " + entityName + ".Serializer " + AdmXbuf2Generator.fieldSerializerVarName(field) + " = " + entityName + ".Serializer.create(true);");
        }
        codeBuilder.last().appendln("        final private static byte FLG_CREATED = (byte)0x01;");
        codeBuilder.last().appendln("        final private static byte FLG_POOLED = (byte)0x02;");
        codeBuilder.last().appendln("        final private static byte FLG_PRIVATE = (byte)0x04;");
        codeBuilder.last().appendln("        final private static %{com.neeve.memory.MemoryStats} _memoryStats = %{com.neeve.memory.MemoryStats}.getInstance();");
        codeBuilder.last().appendln("        private " + entity.getName() + " _entity;");
        codeBuilder.last().appendln("        private int _len;");
        codeBuilder.last().appendln("        private long _addr;");
        codeBuilder.last().appendln("        private %{com.neeve.adm.runtime.AdmRuntime}.BufferSizer _sizer;");
        codeBuilder.last().appendln("        private %{com.neeve.util.UtlPool}<Serializer> _pool;");
        codeBuilder.last().appendln("        private byte _flags;");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("        Serializer() {");
        codeBuilder.last().appendln("            setCreated();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("        final public static Serializer create(final boolean pvt) {");
        codeBuilder.last().appendln("            final Serializer serializer = _entitySerializerPool.get(null);");
        codeBuilder.last().appendln("            if (pvt) {");
        codeBuilder.last().appendln("                serializer.setPrivate();");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            else {");
        codeBuilder.last().appendln("                serializer.clearPrivate();");
        codeBuilder.last().appendln("                _memoryStats.onEntitySerializerAllocated(" + entity.getFullName() + ".class, MemoryStats.EntityType." + AdmXbuf2Generator.getMemoryStatsEntityType(entity) + ", !serializer.isCreated());");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            return serializer.clearPooled();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public static Serializer create() {");
        codeBuilder.last().appendln("            return create(false);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("        final private Serializer setCreated() {");
        codeBuilder.last().appendln("            _flags |= FLG_CREATED;");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final private boolean isCreated() {");
        codeBuilder.last().appendln("            return (_flags & FLG_CREATED) != 0;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final private Serializer clearCreated() {");
        codeBuilder.last().appendln("            _flags &= ~FLG_CREATED;");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final private Serializer setPooled() {");
        codeBuilder.last().appendln("            _flags |= FLG_POOLED;");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final private boolean isPooled() {");
        codeBuilder.last().appendln("            return (_flags & FLG_POOLED) != 0;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final private Serializer clearPooled() {");
        codeBuilder.last().appendln("            _flags &= ~FLG_POOLED;");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final private Serializer setPrivate() {");
        codeBuilder.last().appendln("            _flags |= FLG_PRIVATE;");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final private boolean isPrivate() {");
        codeBuilder.last().appendln("            return (_flags & FLG_PRIVATE) != 0;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final private Serializer clearPrivate() {");
        codeBuilder.last().appendln("            _flags &= ~FLG_PRIVATE;");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final private void ensureCapacity(final int val) {");
        codeBuilder.last().appendln("            if (_sizer != null) _addr = _sizer.ensureCapacity(_addr, val);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final Serializer init(final " + entity.getName() + " entity) {");
        codeBuilder.last().appendln("            init(entity.getSerializedBuffer(), 0);");
        codeBuilder.last().appendln("            _entity = entity;");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public Serializer init(final long addr, final int len) {");
        codeBuilder.last().appendln("            _entity = null;");
        codeBuilder.last().appendln("            _len = len;");
        codeBuilder.last().appendln("            _addr = addr;");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public Serializer init(final %{com.neeve.quark.QuarkBuffer} buffer, final int len) {");
        codeBuilder.last().appendln("            return init(buffer.getNativeAddress(), len);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public Serializer init(final %{com.neeve.quark.QuarkBuffer} buffer) {");
        codeBuilder.last().appendln("            return init(buffer.getNativeAddress(), 0);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public Serializer setSizer(final %{com.neeve.adm.runtime.AdmRuntime}.BufferSizer sizer) {");
        codeBuilder.last().appendln("            _sizer = sizer;");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public boolean hasSizer() {");
        codeBuilder.last().appendln("            return (_sizer != null);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public boolean isInitialized() {");
        codeBuilder.last().appendln("            return _addr != 0;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public int getSerializedLength() {");
        codeBuilder.last().appendln("            if (!isInitialized()) throw new IllegalStateException(\"not initialized\");");
        codeBuilder.last().appendln("            return _len;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void getTo(final %{com.neeve.quark.QuarkBuffer} buffer, final int offset) {");
        codeBuilder.last().appendln("            if (!isInitialized()) throw new IllegalStateException(\"not initialized\");");
        codeBuilder.last().appendln("            if ((buffer.getCapacity() - offset) < _len) {");
        codeBuilder.last().appendln("                throw new IllegalArgumentException(\"not enough space in supplied buffer\");");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            buffer.putFrom(offset, _addr, 0, _len);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public int getTo(final long addr, final int offset) {");
        codeBuilder.last().appendln("            if (!isInitialized()) throw new IllegalStateException(\"not initialized\");");
        codeBuilder.last().appendln("            %{com.neeve.quark.QuarkBuffer}.copy(_addr, 0, addr, offset, _len);");
        codeBuilder.last().appendln("            return _len;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void putFrom(final %{com.neeve.quark.QuarkBuffer} buffer, final int offset, final int len) {");
        codeBuilder.last().appendln("            if (!isInitialized()) throw new IllegalStateException(\"not initialized\");");
        codeBuilder.last().appendln("            if (hasSizer()) ensureCapacity(_len + len);");
        codeBuilder.last().appendln("            buffer.getTo(offset, _addr, _len, len);");
        codeBuilder.last().appendln("            _len += len;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void putFrom(final long addr, final int offset, final int len) {");
        codeBuilder.last().appendln("            if (!isInitialized()) throw new IllegalStateException(\"not initialized\");");
        codeBuilder.last().appendln("            if (hasSizer()) ensureCapacity(_len + len);");
        codeBuilder.last().appendln("            %{com.neeve.quark.QuarkBuffer}.copy(addr, offset, _addr, _len, len);");
        codeBuilder.last().appendln("            _len += len;");
        codeBuilder.last().appendln("        }");
        for (AdmField field : fields) {
            fieldType = field.getType();
            if (fieldType instanceof AdmPrimitive) {
                this.writeUserPrimitiveFieldSerializerMethods(entity, field, codeBuilder);
                continue;
            }
            if (fieldType instanceof AdmArray) {
                if (fieldType instanceof AdmPrimitiveArray) {
                    this.writeUserPrimitiveArrayFieldSerializerMethods(entity, field, codeBuilder);
                    continue;
                }
                if (fieldType instanceof AdmEntityArray) {
                    this.writeUserEntityArrayFieldSerializerMethods(entity, field, codeBuilder);
                    continue;
                }
                if (!(fieldType instanceof AdmEnumerationArray)) continue;
                this.writeUserEnumerationArrayFieldSerializerMethods(entity, field, codeBuilder);
                continue;
            }
            if (fieldType instanceof AdmEnumeration) {
                this.writeUserEnumerationFieldSerializerMethods(entity, field, codeBuilder);
                continue;
            }
            if (!(fieldType instanceof AdmEntity) || !((AdmEntity)fieldType).isEmbedded()) continue;
            this.writeUserEntityFieldSerializerMethods(entity, field, codeBuilder);
        }
        codeBuilder.last().appendln("        final public int done() {");
        codeBuilder.last().appendln("            if (_entity != null) {");
        codeBuilder.last().appendln("               _entity.setSerializedBufferLength(_len);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            return _len;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        @Override");
        codeBuilder.last().appendln("        final public Serializer init() {");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        @Override");
        codeBuilder.last().appendln("        final public Serializer setPool(final %{com.neeve.util.UtlPool}<Serializer> pool) {");
        codeBuilder.last().appendln("            _pool = pool;");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        @Override");
        codeBuilder.last().appendln("        final public %{com.neeve.util.UtlPool}<Serializer> getPool() {");
        codeBuilder.last().appendln("            return _pool;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final void dispose() {");
        codeBuilder.last().appendln("            clearCreated();");
        codeBuilder.last().appendln("            if (_pool != null) {");
        codeBuilder.last().appendln("                setPooled();");
        codeBuilder.last().appendln("                _pool.put(this);");
        codeBuilder.last().appendln("                if (!isPrivate()) _memoryStats.onEntitySerializerDisposed(" + entity.getFullName() + ".class, MemoryStats.EntityType." + AdmXbuf2Generator.getMemoryStatsEntityType(entity) + ", true);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        @Override");
        codeBuilder.last().appendln("        final public long ensureCapacity(final long addr, final int capacity) {");
        codeBuilder.last().appendln("            return (_addr = _sizer.ensureCapacity(addr, capacity));");
        codeBuilder.last().appendln("        }");
        if (this.generateFinalizerMethods(entity)) {
            codeBuilder.last().appendln("        @Override");
            codeBuilder.last().appendln("        final public void finalize() {");
            codeBuilder.last().appendln("            if (!isPrivate()) {");
            codeBuilder.last().appendln("                if (isPooled()) {");
            codeBuilder.last().appendln("                    _memoryStats.onEntitySerializerLeaked(" + entity.getFullName() + ".class, MemoryStats.EntityType." + AdmXbuf2Generator.getMemoryStatsEntityType(entity) + ");");
            codeBuilder.last().appendln("                }");
            codeBuilder.last().appendln("                else {");
            codeBuilder.last().appendln("                    _memoryStats.onEntitySerializerDisposed(" + entity.getFullName() + ".class, MemoryStats.EntityType." + AdmXbuf2Generator.getMemoryStatsEntityType(entity) + ", false);");
            codeBuilder.last().appendln("                }");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
        }
        codeBuilder.last().appendln("    }");
    }

    private final void writeEnumerationArrayDeserializerClassDeclarations(AdmEntity entity, List<AdmField> fields, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        for (AdmField field : fields) {
            if (!(field.getType() instanceof AdmEnumerationArray)) continue;
            AdmType fieldComponentType = ((AdmEnumerationArray)field.getType()).getComponentType();
            codeBuilder.last().appendln("    /**");
            codeBuilder.last().appendln("     * The " + AdmXbuf2Generator.toFirstLetterUppercase(field.getName()) + " deserializer");
            codeBuilder.last().appendln("     */");
            codeBuilder.last().appendln("    final public static class " + AdmXbuf2Generator.fieldDeserializerClassName(field) + " implements %{com.neeve.lang.XIterator}<" + fieldComponentType.getTemplatedJavaTypeName() + "> {");
            codeBuilder.last().appendln("        private long _addr;");
            codeBuilder.last().appendln("        private int _offset;");
            codeBuilder.last().appendln("        private int _nelem;");
            codeBuilder.last().appendln("        private int _index;");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("        private " + AdmXbuf2Generator.fieldDeserializerClassName(field) + "() {}");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("        final public static " + AdmXbuf2Generator.fieldDeserializerClassName(field) + " create() {");
            codeBuilder.last().appendln("            return new " + AdmXbuf2Generator.fieldDeserializerClassName(field) + "();");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("        @Override");
            codeBuilder.last().appendln("        final public boolean hasNext() {");
            codeBuilder.last().appendln("            return _index < _nelem;");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("        @Override");
            codeBuilder.last().appendln("        final public " + fieldComponentType.getTemplatedJavaTypeName() + " next() {");
            codeBuilder.last().appendln("            if (_index == _nelem) {");
            codeBuilder.last().appendln("                throw new %{java.util.NoSuchElementException}(\"no more elements\");");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("            return " + fieldComponentType.getTemplatedJavaTypeName() + ".fromValue(%{com.neeve.quark.QuarkBuffer}.getInt(_addr, _offset + (_index++ * 4)));");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("        @Override");
            codeBuilder.last().appendln("        final public void remove() {");
            codeBuilder.last().appendln("            throw new UnsupportedOperationException();");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("        @Override");
            codeBuilder.last().appendln("        public %{com.neeve.lang.XIterator}<" + fieldComponentType.getTemplatedJavaTypeName() + "> toFirst() {");
            codeBuilder.last().appendln("            _index = 0;");
            codeBuilder.last().appendln("            return this;");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("        final public " + AdmXbuf2Generator.fieldDeserializerClassName(field) + " wrap(final long addr, final int offset, final int len) {");
            codeBuilder.last().appendln("            _addr = addr;");
            codeBuilder.last().appendln("            _offset = offset;");
            codeBuilder.last().appendln("            _nelem = len / 4;");
            codeBuilder.last().appendln("            _index = 0;");
            codeBuilder.last().appendln("            return this;");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("        final public " + AdmXbuf2Generator.fieldDeserializerClassName(field) + " wrap(final %{com.neeve.quark.QuarkBuffer} buffer, final int offset, final int len) {");
            codeBuilder.last().appendln("            return wrap(buffer.getNativeAddress(), offset, len);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("        final public int numElements() {");
            codeBuilder.last().appendln("            return _nelem;");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("        final public int serializedLength() {");
            codeBuilder.last().appendln("            return _nelem * 4;");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("        final public int getTo(final " + fieldComponentType.getTemplatedJavaTypeName() + "[] val, final int offset) {");
            codeBuilder.last().appendln("            final XIterator<" + fieldComponentType.getTemplatedJavaTypeName() + "> iterator = iterator();");
            codeBuilder.last().appendln("            int i = 0;");
            codeBuilder.last().appendln("            while (iterator.hasNext()) {");
            codeBuilder.last().appendln("                val[offset + i++] = iterator.next();");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("            return serializedLength();");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("        final public int getTo(final long addr, final int offset) {");
            codeBuilder.last().appendln("            final int serializedLength = serializedLength();");
            codeBuilder.last().appendln("            %{com.neeve.quark.QuarkBuffer}.copy(_addr, _offset, addr, offset, serializedLength);");
            codeBuilder.last().appendln("            return serializedLength;");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("        final public int getTo(final %{com.neeve.quark.QuarkBuffer} val, final int offset) {");
            codeBuilder.last().appendln("            val.putFrom(offset, _addr, _offset, serializedLength());");
            codeBuilder.last().appendln("            return serializedLength();");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("");
            codeBuilder.last().appendln("        final public %{com.neeve.lang.XIterator}<" + fieldComponentType.getTemplatedJavaTypeName() + "> iterator() {");
            codeBuilder.last().appendln("            return toFirst();");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
        }
    }

    private final void writeDeserializerClassDeclaration(AdmEntity entity, List<AdmField> fields, AdmSourceCodeBuilder codeBuilder) {
        AdmType fieldType;
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    /**");
        codeBuilder.last().appendln("     * The deserializer");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    final public static class Deserializer implements %{com.neeve.util.UtlPool}.Item<Deserializer> {");
        codeBuilder.last().appendln("        public interface Callback {");
        for (AdmField field : fields) {
            AdmPrimitive.Type primitiveType;
            AdmType fieldType2 = field.getType();
            if (fieldType2 instanceof AdmPrimitive) {
                primitiveType = ((AdmPrimitive)fieldType2).getType();
                switch (primitiveType) {
                    case Byte: {
                        codeBuilder.last().appendln("            public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(byte val);");
                        break;
                    }
                    case Char: {
                        codeBuilder.last().appendln("            public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(char val);");
                        break;
                    }
                    case Short: {
                        codeBuilder.last().appendln("            public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(short val);");
                        break;
                    }
                    case Integer: {
                        codeBuilder.last().appendln("            public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(int val);");
                        break;
                    }
                    case Long: {
                        codeBuilder.last().appendln("            public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(long val);");
                        break;
                    }
                    case Float: {
                        codeBuilder.last().appendln("            public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(float val);");
                        break;
                    }
                    case Double: {
                        codeBuilder.last().appendln("            public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(double val);");
                        break;
                    }
                    case Boolean: {
                        codeBuilder.last().appendln("            public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(boolean val);");
                        break;
                    }
                    case Date: {
                        codeBuilder.last().appendln("            public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(long val);");
                        break;
                    }
                    case String: {
                        codeBuilder.last().appendln("            public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(%{com.neeve.quark.QuarkStringDeserializer} val);");
                        break;
                    }
                    case Currency: {
                        break;
                    }
                    case UUID: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown primitive field type ['" + (Object)((Object)primitiveType) + "]");
                    }
                }
                continue;
            }
            if (fieldType2 instanceof AdmArray) {
                if (fieldType2 instanceof AdmPrimitiveArray) {
                    primitiveType = ((AdmPrimitiveArray)fieldType2).getType();
                    switch (primitiveType) {
                        case Byte: {
                            codeBuilder.last().appendln("            public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(byte val);");
                            break;
                        }
                        case Char: {
                            codeBuilder.last().appendln("            public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(char val);");
                            break;
                        }
                        case Short: {
                            codeBuilder.last().appendln("            public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(short val);");
                            break;
                        }
                        case Integer: {
                            codeBuilder.last().appendln("            public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(int val);");
                            break;
                        }
                        case Long: {
                            codeBuilder.last().appendln("            public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(long val);");
                            break;
                        }
                        case Float: {
                            codeBuilder.last().appendln("            public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(float val);");
                            break;
                        }
                        case Double: {
                            codeBuilder.last().appendln("            public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(double val);");
                            break;
                        }
                        case Boolean: {
                            codeBuilder.last().appendln("            public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(boolean val);");
                            break;
                        }
                        case Date: {
                            codeBuilder.last().appendln("            public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(long val);");
                            break;
                        }
                        case String: {
                            codeBuilder.last().appendln("            public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(%{com.neeve.quark.QuarkStringDeserializer} val);");
                            break;
                        }
                        case Currency: {
                            break;
                        }
                        case UUID: {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown primitive field type ['" + (Object)((Object)primitiveType) + "]");
                        }
                    }
                    continue;
                }
                if (fieldType2 instanceof AdmEntityArray) {
                    codeBuilder.last().appendln("            public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(" + ((AdmEntityArray)field.getType()).getType().getTemplatedJavaTypeName() + ".Deserializer val);");
                    continue;
                }
                if (!(fieldType2 instanceof AdmEnumerationArray)) continue;
                codeBuilder.last().appendln("            public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(" + ((AdmEnumerationArray)fieldType2).getType().getTemplatedJavaTypeName() + " val);");
                continue;
            }
            if (fieldType2 instanceof AdmEnumeration) {
                codeBuilder.last().appendln("            public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(" + fieldType2.getTemplatedJavaTypeName() + " val);");
                continue;
            }
            if (!(fieldType2 instanceof AdmEntity) || !((AdmEntity)fieldType2).isEmbedded()) continue;
            codeBuilder.last().appendln("            public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(" + ((AdmEntity)fieldType2).getTemplatedJavaTypeName() + ".Deserializer val);");
        }
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("");
        HashSet<String> declaredDeserializers = new HashSet<String>();
        for (AdmField field : fields) {
            fieldType = field.getType();
            if (fieldType instanceof AdmString || fieldType instanceof AdmStringArray || fieldType instanceof AdmPooledString) {
                if (declaredDeserializers.contains("_stringDeserializer")) continue;
                codeBuilder.last().appendln("        final private %{com.neeve.quark.QuarkStringDeserializer} _stringDeserializer = %{com.neeve.quark.QuarkStringDeserializer}.create();");
                declaredDeserializers.add("_stringDeserializer");
                continue;
            }
            if ((!(fieldType instanceof AdmEntity) || !((AdmEntity)fieldType).isEmbedded()) && !(fieldType instanceof AdmEntityArray)) continue;
            String entityName = fieldType instanceof AdmEntityArray ? ((AdmEntityArray)field.getType()).getType().getTemplatedJavaTypeName() : ((AdmEntity)fieldType).getTemplatedJavaTypeName();
            String entityDeserializerName = entityName + ".Deserializer";
            if (declaredDeserializers.contains(AdmXbuf2Generator.fieldDeserializerVarName(field))) continue;
            codeBuilder.last().appendln("        final private " + entityDeserializerName + " " + AdmXbuf2Generator.fieldDeserializerVarName(field) + " = " + entityDeserializerName + ".create(true);");
            declaredDeserializers.add(AdmXbuf2Generator.fieldDeserializerVarName(field));
        }
        codeBuilder.last().appendln("        final private static byte FLG_CREATED = (byte)0x01;");
        codeBuilder.last().appendln("        final private static byte FLG_POOLED = (byte)0x02;");
        codeBuilder.last().appendln("        final private static byte FLG_PRIVATE = (byte)0x04;");
        codeBuilder.last().appendln("        final private static %{com.neeve.memory.MemoryStats} _memoryStats = %{com.neeve.memory.MemoryStats}.getInstance();");
        codeBuilder.last().appendln("        final private %{com.neeve.quark.QuarkBuffer}.VarintDeserializeLength _varintDeserializeLength = new %{com.neeve.quark.QuarkBuffer}.VarintDeserializeLength();");
        codeBuilder.last().appendln("        private long _addr;");
        codeBuilder.last().appendln("        private int _offset;");
        codeBuilder.last().appendln("        private int _len;");
        codeBuilder.last().appendln("        private %{com.neeve.util.UtlPool}<Deserializer> _pool;");
        codeBuilder.last().appendln("        private byte _flags;");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("        Deserializer() {");
        codeBuilder.last().appendln("            setCreated();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("        final public static Deserializer create(final boolean pvt) {");
        codeBuilder.last().appendln("            final Deserializer deserializer = _entityDeserializerPool.get(null);");
        codeBuilder.last().appendln("            if (pvt) {");
        codeBuilder.last().appendln("                deserializer.setPrivate();");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            else {");
        codeBuilder.last().appendln("                deserializer.clearPrivate();");
        codeBuilder.last().appendln("                _memoryStats.onEntityDeserializerAllocated(" + entity.getFullName() + ".class, MemoryStats.EntityType." + AdmXbuf2Generator.getMemoryStatsEntityType(entity) + ", !deserializer.isCreated());");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            return deserializer.clearPooled();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public static Deserializer create() {");
        codeBuilder.last().appendln("            return create(false);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("        final private Deserializer setCreated() {");
        codeBuilder.last().appendln("            _flags |= FLG_CREATED;");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final private boolean isCreated() {");
        codeBuilder.last().appendln("            return (_flags & FLG_CREATED) != 0;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final private Deserializer clearCreated() {");
        codeBuilder.last().appendln("            _flags &= ~FLG_CREATED;");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final private Deserializer setPooled() {");
        codeBuilder.last().appendln("            _flags |= FLG_POOLED;");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final private boolean isPooled() {");
        codeBuilder.last().appendln("            return (_flags & FLG_POOLED) != 0;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final private Deserializer clearPooled() {");
        codeBuilder.last().appendln("            _flags &= ~FLG_POOLED;");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final private Deserializer setPrivate() {");
        codeBuilder.last().appendln("            _flags |= FLG_PRIVATE;");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final private boolean isPrivate() {");
        codeBuilder.last().appendln("            return (_flags & FLG_PRIVATE) != 0;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final private Deserializer clearPrivate() {");
        codeBuilder.last().appendln("            _flags &= ~FLG_PRIVATE;");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public Deserializer init(final long addr, final int offset, final int len) {");
        codeBuilder.last().appendln("            _addr = addr;");
        codeBuilder.last().appendln("            _offset = offset;");
        codeBuilder.last().appendln("            _len = len;");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public Deserializer init(final %{com.neeve.quark.QuarkBuffer} buffer, final int offset, final int len) {");
        codeBuilder.last().appendln("            _addr = buffer.getNativeAddress();");
        codeBuilder.last().appendln("            _offset = offset;");
        codeBuilder.last().appendln("            _len = len;");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public boolean isInitialized() {");
        codeBuilder.last().appendln("            return _addr != 0l;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public int getSerializedLength() {");
        codeBuilder.last().appendln("            if (!isInitialized()) throw new IllegalStateException(\"not initialized\");");
        codeBuilder.last().appendln("            return _len;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void getTo(final %{com.neeve.quark.QuarkBuffer} buffer, final int offset) {");
        codeBuilder.last().appendln("            if (!isInitialized()) throw new IllegalStateException(\"not initialized\");");
        codeBuilder.last().appendln("            if ((buffer.getCapacity() - offset) < _len) {");
        codeBuilder.last().appendln("                throw new IllegalArgumentException(\"not enough space in supplied buffer\");");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            buffer.putFrom(offset, _addr, _offset, _len);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public int getTo(final long addr, final int offset) {");
        codeBuilder.last().appendln("            if (!isInitialized()) throw new IllegalStateException(\"not initialized\");");
        codeBuilder.last().appendln("            %{com.neeve.quark.QuarkBuffer}.copy(_addr, _offset, addr, offset, _len);");
        codeBuilder.last().appendln("            return _len;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void run(final Callback cb) {");
        codeBuilder.last().appendln("            if (!isInitialized()) throw new IllegalStateException(\"not initialized\");");
        codeBuilder.last().appendln("            final long addr = _addr;");
        codeBuilder.last().appendln("            final int lim = _offset + _len;");
        codeBuilder.last().appendln("            int pos = _offset;");
        codeBuilder.last().appendln("            int tlen;");
        codeBuilder.last().appendln("            int flen;");
        codeBuilder.last().appendln("            int eval;");
        codeBuilder.last().appendln("            while (pos < lim) {");
        codeBuilder.last().appendln("                final int ftag = %{com.neeve.quark.QuarkBuffer}.getVarint32(addr, pos, _varintDeserializeLength);");
        codeBuilder.last().appendln("                final int ftype = (ftag & 0x0007);");
        codeBuilder.last().appendln("                switch (ftag >>> 3) {");
        for (AdmField field : fields) {
            fieldType = field.getType();
            codeBuilder.last().appendln("                    case " + field.getId() + " :");
            if (fieldType instanceof AdmPrimitive || fieldType instanceof AdmPrimitiveArray) {
                AdmPrimitive.Type primitiveType = fieldType instanceof AdmPrimitive ? ((AdmPrimitive)fieldType).getType() : ((AdmPrimitiveArray)fieldType).getType();
                switch (primitiveType) {
                    case Byte: {
                        codeBuilder.last().appendln("                        if (ftype != 0x00) throw new IllegalStateException(\"field type mismatch (exp=0x00, actual=\" + ftype + \") for field " + field.getId() + "\");");
                        codeBuilder.last().appendln("                        tlen = _varintDeserializeLength.value;");
                        codeBuilder.last().appendln("                        cb." + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "((byte)%{com.neeve.quark.QuarkBuffer}.getVarint32(addr, pos + tlen, _varintDeserializeLength));");
                        codeBuilder.last().appendln("                        flen = _varintDeserializeLength.value;");
                        break;
                    }
                    case Char: {
                        codeBuilder.last().appendln("                        if (ftype != 0x00) throw new IllegalStateException(\"field type mismatch (exp=0x00, actual=\" + ftype + \") for field " + field.getId() + "\");");
                        codeBuilder.last().appendln("                        tlen = _varintDeserializeLength.value;");
                        codeBuilder.last().appendln("                        cb." + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "((char)%{com.neeve.quark.QuarkBuffer}.getVarint32(addr, pos + tlen, _varintDeserializeLength));");
                        codeBuilder.last().appendln("                        flen = _varintDeserializeLength.value;");
                        break;
                    }
                    case Short: {
                        codeBuilder.last().appendln("                        if (ftype != 0x00) throw new IllegalStateException(\"field type mismatch (exp=0x00, actual=\" + ftype + \") for field " + field.getId() + "\");");
                        codeBuilder.last().appendln("                        tlen = _varintDeserializeLength.value;");
                        codeBuilder.last().appendln("                        cb." + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "((short)%{com.neeve.quark.QuarkBuffer}.getVarint32(addr, pos + tlen, _varintDeserializeLength));");
                        codeBuilder.last().appendln("                        flen = _varintDeserializeLength.value;");
                        break;
                    }
                    case Integer: {
                        codeBuilder.last().appendln("                        if (ftype != 0x00) throw new IllegalStateException(\"field type mismatch (exp=0x00, actual=\" + ftype + \") for field " + field.getId() + "\");");
                        codeBuilder.last().appendln("                        tlen = _varintDeserializeLength.value;");
                        codeBuilder.last().appendln("                        cb." + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "((int)%{com.neeve.quark.QuarkBuffer}.getVarint32(addr, pos + tlen, _varintDeserializeLength));");
                        codeBuilder.last().appendln("                        flen = _varintDeserializeLength.value;");
                        break;
                    }
                    case Long: {
                        codeBuilder.last().appendln("                        if (ftype != 0x00) throw new IllegalStateException(\"field type mismatch (exp=0x00, actual=\" + ftype + \") for field " + field.getId() + "\");");
                        codeBuilder.last().appendln("                        tlen = _varintDeserializeLength.value;");
                        codeBuilder.last().appendln("                        cb." + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "((long)%{com.neeve.quark.QuarkBuffer}.getVarint64(addr, pos + tlen, _varintDeserializeLength));");
                        codeBuilder.last().appendln("                        flen = _varintDeserializeLength.value;");
                        break;
                    }
                    case Float: {
                        codeBuilder.last().appendln("                        if (ftype != 0x05) throw new IllegalStateException(\"field type mismatch (exp=0x05, actual=\" + ftype + \") for field " + field.getId() + "\");");
                        codeBuilder.last().appendln("                        tlen = _varintDeserializeLength.value;");
                        codeBuilder.last().appendln("                        cb." + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(%{com.neeve.quark.QuarkBuffer}.getFloat(addr, pos + tlen));");
                        codeBuilder.last().appendln("                        flen = 4;");
                        break;
                    }
                    case Double: {
                        codeBuilder.last().appendln("                        if (ftype != 0x01) throw new IllegalStateException(\"field type mismatch (exp=0x01, actual=\" + ftype + \") for field " + field.getId() + "\");");
                        codeBuilder.last().appendln("                        tlen = _varintDeserializeLength.value;");
                        codeBuilder.last().appendln("                        cb." + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(%{com.neeve.quark.QuarkBuffer}.getDouble(addr, pos + tlen));");
                        codeBuilder.last().appendln("                        flen = 8;");
                        break;
                    }
                    case Boolean: {
                        codeBuilder.last().appendln("                        if (ftype != 0x00) throw new IllegalStateException(\"field type mismatch (exp=0x00, actual=\" + ftype + \") for field " + field.getId() + "\");");
                        codeBuilder.last().appendln("                        tlen = _varintDeserializeLength.value;");
                        codeBuilder.last().appendln("                        cb." + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(%{com.neeve.quark.QuarkBuffer}.getVarint32(addr, pos + tlen, _varintDeserializeLength) > 0);");
                        codeBuilder.last().appendln("                        flen = _varintDeserializeLength.value;");
                        break;
                    }
                    case Date: {
                        codeBuilder.last().appendln("                        if (ftype != 0x00) throw new IllegalStateException(\"field type mismatch (exp=0x00, actual=\" + ftype + \") for field " + field.getId() + "\");");
                        codeBuilder.last().appendln("                        tlen = _varintDeserializeLength.value;");
                        codeBuilder.last().appendln("                        cb." + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "((long)%{com.neeve.quark.QuarkBuffer}.getVarint64(addr, pos + tlen, _varintDeserializeLength));");
                        codeBuilder.last().appendln("                        flen = _varintDeserializeLength.value;");
                        break;
                    }
                    case String: {
                        codeBuilder.last().appendln("                        if (ftype != 0x02) throw new IllegalStateException(\"field type mismatch (exp=0x02, actual=\" + ftype + \") for field " + field.getId() + "\");");
                        codeBuilder.last().appendln("                        tlen = _varintDeserializeLength.value;");
                        codeBuilder.last().appendln("                        flen = %{com.neeve.quark.QuarkBuffer}.getVarint32(addr, pos + tlen, _varintDeserializeLength);");
                        codeBuilder.last().appendln("                        cb." + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(_stringDeserializer.init(addr, pos + tlen + _varintDeserializeLength.value, flen));");
                        codeBuilder.last().appendln("                        flen += _varintDeserializeLength.value;");
                        break;
                    }
                    case Currency: {
                        break;
                    }
                    case UUID: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown primitive field type ['" + (Object)((Object)primitiveType) + "]");
                    }
                }
                codeBuilder.last().appendln("                        break;");
                codeBuilder.last().appendln("");
                continue;
            }
            if (fieldType instanceof AdmEnumeration || fieldType instanceof AdmEnumerationArray) {
                codeBuilder.last().appendln("                        if (ftype != 0x00) throw new IllegalStateException(\"field type mismatch (exp=0x00, actual=\" + ftype + \") for field " + field.getId() + "\");");
                codeBuilder.last().appendln("                        tlen = _varintDeserializeLength.value;");
                codeBuilder.last().appendln("                        eval = %{com.neeve.quark.QuarkBuffer}.getVarint32(addr, pos + tlen, _varintDeserializeLength);");
                codeBuilder.last().appendln("                        if (" + (fieldType instanceof AdmEnumeration ? fieldType.getTemplatedJavaTypeName() : ((AdmEnumerationArray)fieldType).getType().getTemplatedJavaTypeName()) + ".hasValue(eval)) {");
                codeBuilder.last().appendln("                            cb." + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(" + (fieldType instanceof AdmEnumeration ? fieldType.getTemplatedJavaTypeName() : ((AdmEnumerationArray)fieldType).getType().getTemplatedJavaTypeName()) + ".fromValue(eval));");
                codeBuilder.last().appendln("                        }");
                codeBuilder.last().appendln("                        flen = _varintDeserializeLength.value;");
                codeBuilder.last().appendln("                        break;");
                codeBuilder.last().appendln("");
                continue;
            }
            if ((!(fieldType instanceof AdmEntity) || !((AdmEntity)fieldType).isEmbedded()) && !(fieldType instanceof AdmEntityArray)) continue;
            codeBuilder.last().appendln("                        if (ftype != 0x02) throw new IllegalStateException(\"field type mismatch (exp=0x02, actual=\" + ftype + \") for field " + field.getId() + "\");");
            codeBuilder.last().appendln("                        tlen = _varintDeserializeLength.value;");
            codeBuilder.last().appendln("                        flen = %{com.neeve.quark.QuarkBuffer}.getVarint32(addr, pos + tlen, _varintDeserializeLength);");
            codeBuilder.last().appendln("                        cb." + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(" + AdmXbuf2Generator.fieldDeserializerVarName(field) + ".init(addr, pos + tlen + _varintDeserializeLength.value, flen));");
            codeBuilder.last().appendln("                        flen += _varintDeserializeLength.value;");
            codeBuilder.last().appendln("                        break;");
            codeBuilder.last().appendln("");
        }
        codeBuilder.last().appendln("                    default:");
        codeBuilder.last().appendln("                        // we fetch from buffer again for unidentified field because");
        codeBuilder.last().appendln("                        // resolving the id and len code up front is slower and performance");
        codeBuilder.last().appendln("                        // of handling unknown fields can suffer a bit since its not the core");
        codeBuilder.last().appendln("                        // use case");
        codeBuilder.last().appendln("                        switch (ftype) {");
        codeBuilder.last().appendln("                            case 0:");
        codeBuilder.last().appendln("                                tlen = _varintDeserializeLength.value;");
        codeBuilder.last().appendln("                                %{com.neeve.quark.QuarkBuffer}.getVarint32(addr, pos + tlen, _varintDeserializeLength);");
        codeBuilder.last().appendln("                                flen = _varintDeserializeLength.value;");
        codeBuilder.last().appendln("                                break;");
        codeBuilder.last().appendln("                            case 1:");
        codeBuilder.last().appendln("                                tlen = _varintDeserializeLength.value;");
        codeBuilder.last().appendln("                                flen = 8;");
        codeBuilder.last().appendln("                                break;");
        codeBuilder.last().appendln("                            case 2:");
        codeBuilder.last().appendln("                                tlen = _varintDeserializeLength.value;");
        codeBuilder.last().appendln("                                flen = %{com.neeve.quark.QuarkBuffer}.getVarint32(addr, pos + tlen, _varintDeserializeLength);");
        codeBuilder.last().appendln("                                flen += _varintDeserializeLength.value;");
        codeBuilder.last().appendln("                                break;");
        codeBuilder.last().appendln("                            case 5:");
        codeBuilder.last().appendln("                                tlen = _varintDeserializeLength.value;");
        codeBuilder.last().appendln("                                flen = 4;");
        codeBuilder.last().appendln("                                break;");
        codeBuilder.last().appendln("                            default:");
        codeBuilder.last().appendln("                                throw new IllegalStateException(\"corrupt field - #\" + ((%{com.neeve.quark.QuarkBuffer}.getVarint32(addr, pos, _varintDeserializeLength)) >>> 3));");
        codeBuilder.last().appendln("                        }");
        codeBuilder.last().appendln("                        break;");
        codeBuilder.last().appendln("                }");
        codeBuilder.last().appendln("                pos += (tlen + flen);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        @Override");
        codeBuilder.last().appendln("        final public Deserializer init() {");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        @Override");
        codeBuilder.last().appendln("        final public Deserializer setPool(final %{com.neeve.util.UtlPool}<Deserializer> pool) {");
        codeBuilder.last().appendln("            _pool = pool;");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        @Override");
        codeBuilder.last().appendln("        final public %{com.neeve.util.UtlPool}<Deserializer> getPool() {");
        codeBuilder.last().appendln("            return _pool;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final void dispose() {");
        codeBuilder.last().appendln("            clearCreated();");
        codeBuilder.last().appendln("            if (_pool != null) {");
        codeBuilder.last().appendln("                setPooled();");
        codeBuilder.last().appendln("                _pool.put(this);");
        codeBuilder.last().appendln("                if (!isPrivate()) _memoryStats.onEntityDeserializerDisposed(" + entity.getFullName() + ".class, MemoryStats.EntityType." + AdmXbuf2Generator.getMemoryStatsEntityType(entity) + ", true);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        if (this.generateFinalizerMethods(entity)) {
            codeBuilder.last().appendln("        @Override");
            codeBuilder.last().appendln("        final public void finalize() {");
            codeBuilder.last().appendln("            if (!isPrivate()) {");
            codeBuilder.last().appendln("                if (isPooled()) {");
            codeBuilder.last().appendln("                    _memoryStats.onEntityDeserializerLeaked(" + entity.getFullName() + ".class, MemoryStats.EntityType." + AdmXbuf2Generator.getMemoryStatsEntityType(entity) + ");");
            codeBuilder.last().appendln("                }");
            codeBuilder.last().appendln("                else {");
            codeBuilder.last().appendln("                    _memoryStats.onEntityDeserializerDisposed(" + entity.getFullName() + ".class, MemoryStats.EntityType." + AdmXbuf2Generator.getMemoryStatsEntityType(entity) + ", false);");
            codeBuilder.last().appendln("                }");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
        }
        codeBuilder.last().appendln("    }");
    }

    private final void writeUserPrimitiveFieldPojoMethods(AdmEntity entity, AdmField field, AdmSourceCodeBuilder codeBuilder) {
        AdmPrimitive fieldType = (AdmPrimitive)field.getType();
        AdmPrimitive.Type primitiveType = fieldType.getType();
        switch (primitiveType) {
            case Byte: 
            case Char: 
            case Short: 
            case Integer: 
            case Long: 
            case Float: 
            case Double: 
            case Boolean: 
            case Date: {
                String primitiveTypeName = primitiveType == AdmPrimitive.Type.Date ? AdmPrimitive.Type.Long.getPrimitiveTypeName() : primitiveType.getPrimitiveTypeName();
                codeBuilder.last().appendln("");
                codeBuilder.last().appendln("        private " + primitiveTypeName + " " + AdmXbuf2Generator.fieldValueVarName(field) + ";");
                codeBuilder.last().appendln("        final public boolean " + AdmXbuf2Generator.fieldCheckerMethodName(field) + "() {");
                codeBuilder.last().appendln("            return ((_fieldBitmask[" + (field.getIndex() >> 6) + "] & (1L << " + (field.getIndex() & 0x3F) + ")) != 0);");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        final public " + primitiveTypeName + " " + AdmXbuf2Generator.fieldGetterMethodName(field) + "() {");
                codeBuilder.last().appendln("            return " + AdmXbuf2Generator.fieldValueVarName(field) + ";");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldSetterMethodName(field) + "(final " + primitiveTypeName + " val) {");
                codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
                codeBuilder.last().appendln("            _fieldBitmask[" + (field.getIndex() >> 6) + "] |= (1L << " + (field.getIndex() & 0x3F) + ");");
                codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + " = val;");
                codeBuilder.last().appendln("            _dirty = true;");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldClearerMethodName(field) + "() {");
                codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
                codeBuilder.last().appendln("            if (!" + AdmXbuf2Generator.fieldCheckerMethodName(field) + "()) {return;}");
                if (primitiveType == AdmPrimitive.Type.Date) {
                    codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + " = 0;");
                } else {
                    codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + " = " + fieldType.getDefaultValueLiteral() + ";");
                }
                codeBuilder.last().appendln("            _fieldBitmask[" + (field.getIndex() >> 6) + "] &= ~(1L << " + (field.getIndex() & 0x3F) + ");");
                codeBuilder.last().appendln("            _dirty = true;");
                codeBuilder.last().appendln("        }");
                break;
            }
            case String: {
                codeBuilder.last().appendln("");
                codeBuilder.last().appendln("        private %{com.neeve.lang.XString} " + AdmXbuf2Generator.fieldValueVarName(field) + " = %{com.neeve.lang.XString}.create(0, true, true);");
                codeBuilder.last().appendln("        final public boolean " + AdmXbuf2Generator.fieldCheckerMethodName(field) + "() {");
                codeBuilder.last().appendln("            return ((_fieldBitmask[" + (field.getIndex() >> 6) + "] & (1L << " + (field.getIndex() & 0x3F) + ")) != 0);");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        final public %{com.neeve.lang.XString} " + AdmXbuf2Generator.fieldGetterMethodName(field) + "() {");
                codeBuilder.last().appendln("            if (!" + AdmXbuf2Generator.fieldCheckerMethodName(field) + "() || " + AdmXbuf2Generator.fieldValueVarName(field) + ".isNull()) return null;");
                codeBuilder.last().appendln("            return " + AdmXbuf2Generator.fieldValueVarName(field) + ";");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldGetterToMethodName(field) + "(final %{com.neeve.lang.XString} val) {");
                codeBuilder.last().appendln("            if (!" + AdmXbuf2Generator.fieldCheckerMethodName(field) + "() || " + AdmXbuf2Generator.fieldValueVarName(field) + ".isNull()) {");
                codeBuilder.last().appendln("                val.clear();");
                codeBuilder.last().appendln("                return;");
                codeBuilder.last().appendln("            }");
                codeBuilder.last().appendln("            val.setValue(" + AdmXbuf2Generator.fieldValueVarName(field) + ");");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(final String val) {");
                codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
                codeBuilder.last().appendln("            if (val == null) {" + AdmXbuf2Generator.fieldClearerMethodName(field) + "(); return;}");
                codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + ".setValue(val);");
                codeBuilder.last().appendln("            if (!" + AdmXbuf2Generator.fieldCheckerMethodName(field) + "()) {");
                codeBuilder.last().appendln("                _fieldBitmask[" + (field.getIndex() >> 6) + "] |= (1L << " + (field.getIndex() & 0x3F) + ");");
                codeBuilder.last().appendln("            }");
                codeBuilder.last().appendln("            _dirty = true;");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(final %{com.neeve.lang.XString} val) {");
                codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
                codeBuilder.last().appendln("            if (val == null || val.isNull()) {" + AdmXbuf2Generator.fieldClearerMethodName(field) + "(); return;}");
                codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + ".setValue(val);");
                codeBuilder.last().appendln("            if (!" + AdmXbuf2Generator.fieldCheckerMethodName(field) + "()) {");
                codeBuilder.last().appendln("                _fieldBitmask[" + (field.getIndex() >> 6) + "] |= (1L << " + (field.getIndex() & 0x3F) + ");");
                codeBuilder.last().appendln("            }");
                codeBuilder.last().appendln("            _dirty = true;");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(final CharSequence val) {");
                codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
                codeBuilder.last().appendln("            if (val == null) {" + AdmXbuf2Generator.fieldClearerMethodName(field) + "(); return;}");
                codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + ".setValue(val);");
                codeBuilder.last().appendln("            if (!" + AdmXbuf2Generator.fieldCheckerMethodName(field) + "()) {");
                codeBuilder.last().appendln("                _fieldBitmask[" + (field.getIndex() >> 6) + "] |= (1L << " + (field.getIndex() & 0x3F) + ");");
                codeBuilder.last().appendln("            }");
                codeBuilder.last().appendln("            _dirty = true;");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(final long val) {");
                codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
                codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + ".setValue(val);");
                codeBuilder.last().appendln("            if (!" + AdmXbuf2Generator.fieldCheckerMethodName(field) + "()) {");
                codeBuilder.last().appendln("                _fieldBitmask[" + (field.getIndex() >> 6) + "] |= (1L << " + (field.getIndex() & 0x3F) + ");");
                codeBuilder.last().appendln("            }");
                codeBuilder.last().appendln("            _dirty = true;");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(final byte[] val, final int offset, final int len) {");
                codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
                codeBuilder.last().appendln("            if (val == null) {" + AdmXbuf2Generator.fieldClearerMethodName(field) + "(); return;}");
                codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + ".setValue(val, offset, len);");
                codeBuilder.last().appendln("            if (!" + AdmXbuf2Generator.fieldCheckerMethodName(field) + "()) {");
                codeBuilder.last().appendln("                _fieldBitmask[" + (field.getIndex() >> 6) + "] |= (1L << " + (field.getIndex() & 0x3F) + ");");
                codeBuilder.last().appendln("            }");
                codeBuilder.last().appendln("            _dirty = true;");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(final %{com.neeve.quark.QuarkString} val) {");
                codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
                codeBuilder.last().appendln("            if (val == null || val.isNull()) {" + AdmXbuf2Generator.fieldClearerMethodName(field) + "(); return;}");
                codeBuilder.last().appendln("            val.getTo(" + AdmXbuf2Generator.fieldValueVarName(field) + ");");
                codeBuilder.last().appendln("            if (!" + AdmXbuf2Generator.fieldCheckerMethodName(field) + "()) {");
                codeBuilder.last().appendln("                _fieldBitmask[" + (field.getIndex() >> 6) + "] |= (1L << " + (field.getIndex() & 0x3F) + ");");
                codeBuilder.last().appendln("            }");
                codeBuilder.last().appendln("            _dirty = true;");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(final %{com.neeve.quark.QuarkStringDeserializer} val) {");
                codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
                codeBuilder.last().appendln("            if (val == null) {" + AdmXbuf2Generator.fieldClearerMethodName(field) + "(); return;}");
                codeBuilder.last().appendln("            val.getTo(" + AdmXbuf2Generator.fieldValueVarName(field) + ");");
                codeBuilder.last().appendln("            if (!" + AdmXbuf2Generator.fieldCheckerMethodName(field) + "()) {");
                codeBuilder.last().appendln("                _fieldBitmask[" + (field.getIndex() >> 6) + "] |= (1L << " + (field.getIndex() & 0x3F) + ");");
                codeBuilder.last().appendln("            }");
                codeBuilder.last().appendln("            _dirty = true;");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldClearerMethodName(field) + "() {");
                codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
                codeBuilder.last().appendln("            if (!" + AdmXbuf2Generator.fieldCheckerMethodName(field) + "()) {return;}");
                codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + ".reset();");
                codeBuilder.last().appendln("            _fieldBitmask[" + (field.getIndex() >> 6) + "] &= ~(1L << " + (field.getIndex() & 0x3F) + ");");
                codeBuilder.last().appendln("            _dirty = true;");
                codeBuilder.last().appendln("        }");
                break;
            }
            case Currency: {
                break;
            }
            case UUID: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown primitive field type ['" + (Object)((Object)primitiveType) + "]");
            }
        }
    }

    private final void writeBulkCopyUserPrimitiveArrayFieldPojoMethods(AdmEntity entity, AdmField field, String templatedDeserializerClassName, int serializedSize, AdmSourceCodeBuilder codeBuilder) {
        AdmPrimitive.Type primitiveType = ((AdmPrimitiveArray)field.getType()).getType();
        String javaPrimitive = primitiveType.getPrimitiveTypeName();
        String templatedIteratorClassName = primitiveType.getTemplatedXIteratorType();
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("        final private " + templatedDeserializerClassName + " " + AdmXbuf2Generator.fieldDeserializerVarName(field) + " = " + templatedDeserializerClassName + ".create();");
        codeBuilder.last().appendln("        private %{com.neeve.quark.QuarkBuffer} " + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized;");
        codeBuilder.last().appendln("        private int " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen;");
        codeBuilder.last().appendln("        final public int " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Count() {");
        codeBuilder.last().appendln("            return " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen / " + serializedSize + ";");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public " + templatedDeserializerClassName + " " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Deserializer() {");
        codeBuilder.last().appendln("            if (" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized != null) {");
        codeBuilder.last().appendln("                " + AdmXbuf2Generator.fieldDeserializerVarName(field) + ".wrap(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized, 0, " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            else {");
        codeBuilder.last().appendln("                " + AdmXbuf2Generator.fieldDeserializerVarName(field) + ".wrap(0l, 0, 0);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            return " + AdmXbuf2Generator.fieldDeserializerVarName(field) + ";");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public " + templatedIteratorClassName + " " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Iterator() {");
        codeBuilder.last().appendln("            if (" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized != null) {");
        codeBuilder.last().appendln("                " + AdmXbuf2Generator.fieldDeserializerVarName(field) + ".wrap(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized, 0, " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            else {");
        codeBuilder.last().appendln("                " + AdmXbuf2Generator.fieldDeserializerVarName(field) + ".wrap(0l, 0, 0);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            return " + AdmXbuf2Generator.fieldDeserializerVarName(field) + ".iterator();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public int " + AdmXbuf2Generator.fieldGetterMethodName(field) + "To(final " + javaPrimitive + "[] val, final int offset) {");
        codeBuilder.last().appendln("            final int nelem = " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Count();");
        codeBuilder.last().appendln("            if (nelem > val.length - offset) {");
        codeBuilder.last().appendln("                throw new IllegalArgumentException(\"array too small\");");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            if (" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized != null) {");
        codeBuilder.last().appendln("                " + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized.getTo(0, val, offset, nelem);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            return nelem;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "(final " + javaPrimitive + " val) {");
        codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized = %{com.neeve.quark.QuarkBuffer}.ensureCapacity(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized, " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen + " + serializedSize + ", true);");
        codeBuilder.last().appendln("            %{com.neeve.quark.QuarkBuffer}.put" + AdmXbuf2Generator.toFirstLetterUppercase(javaPrimitive) + "(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized.getNativeAddress(), " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen, val);");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen += " + serializedSize + ";");
        codeBuilder.last().appendln("            _dirty = true;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From(final " + templatedDeserializerClassName + " sequence) {");
        codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
        codeBuilder.last().appendln("            if (sequence == null) {return;}");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized = %{com.neeve.quark.QuarkBuffer}.ensureCapacity(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized, " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen + sequence.serializedLength(), true);");
        codeBuilder.last().appendln("            final int len = sequence.getTo(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized, " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen);");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen += len;");
        codeBuilder.last().appendln("            _dirty = true;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(final " + templatedDeserializerClassName + " sequence) {");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldClearerMethodName(field) + "();");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From(sequence);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From(final " + templatedIteratorClassName + " iterator) {");
        codeBuilder.last().appendln("            if (iterator == null) {return;}");
        codeBuilder.last().appendln("            if (iterator instanceof " + templatedDeserializerClassName + ") {");
        codeBuilder.last().appendln("                " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From((" + templatedDeserializerClassName + ")iterator);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            else {");
        codeBuilder.last().appendln("                iterator.toFirst();");
        codeBuilder.last().appendln("                while (iterator.hasNext()) {");
        codeBuilder.last().appendln("                    " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "(iterator.next());");
        codeBuilder.last().appendln("                }");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(final " + templatedIteratorClassName + " iterator) {");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldClearerMethodName(field) + "();");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From(iterator);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From(final " + javaPrimitive + "[] val, final int offset, final int len) {");
        codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
        codeBuilder.last().appendln("            if (val == null || val.length == 0) {return;}");
        codeBuilder.last().appendln("            final int nbytes = (len * " + serializedSize + ");");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized = %{com.neeve.quark.QuarkBuffer}.ensureCapacity(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized, " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen + nbytes, true);");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized.putFrom(" + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen, val, offset, len);");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen += nbytes;");
        codeBuilder.last().appendln("            _dirty = true;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(final " + javaPrimitive + "[] val, final int offset, final int len) {");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldClearerMethodName(field) + "();");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From(val, offset, len);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldClearerMethodName(field) + "() {");
        codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
        codeBuilder.last().appendln("            if (" + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen == 0) {return;}");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen = 0;");
        codeBuilder.last().appendln("            _dirty = true;");
        codeBuilder.last().appendln("        }");
    }

    private final void writeBooleanArrayFieldPojoMethods(AdmEntity entity, AdmField field, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("        final private %{com.neeve.lang.XBooleanSequence} " + AdmXbuf2Generator.fieldDeserializerVarName(field) + " = %{com.neeve.lang.XBooleanSequence}.create();");
        codeBuilder.last().appendln("        private %{com.neeve.quark.QuarkBuffer} " + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized;");
        codeBuilder.last().appendln("        private int " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen;");
        codeBuilder.last().appendln("        final public int " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Count() {");
        codeBuilder.last().appendln("            return " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen / 1;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public %{com.neeve.lang.XBooleanSequence} " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Deserializer() {");
        codeBuilder.last().appendln("            if (" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized != null) {");
        codeBuilder.last().appendln("                " + AdmXbuf2Generator.fieldDeserializerVarName(field) + ".wrap(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized, 0, " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            else {");
        codeBuilder.last().appendln("                " + AdmXbuf2Generator.fieldDeserializerVarName(field) + ".wrap(0l, 0, 0);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            return " + AdmXbuf2Generator.fieldDeserializerVarName(field) + ";");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public %{com.neeve.lang.XBooleanIterator} " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Iterator() {");
        codeBuilder.last().appendln("            if (" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized != null) {");
        codeBuilder.last().appendln("                " + AdmXbuf2Generator.fieldDeserializerVarName(field) + ".wrap(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized, 0, " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            else {");
        codeBuilder.last().appendln("                " + AdmXbuf2Generator.fieldDeserializerVarName(field) + ".wrap(0l, 0, 0);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            return " + AdmXbuf2Generator.fieldDeserializerVarName(field) + ".iterator();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public int " + AdmXbuf2Generator.fieldGetterMethodName(field) + "To(final boolean[] val, final int offset) {");
        codeBuilder.last().appendln("            final int nelem = " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Count();");
        codeBuilder.last().appendln("            if (nelem > val.length - offset) {");
        codeBuilder.last().appendln("                throw new IllegalArgumentException(\"array too small\");");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            final %{com.neeve.lang.XBooleanIterator} iterator = " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Iterator();");
        codeBuilder.last().appendln("            for (int i = 0 ; i < nelem ; i++) {");
        codeBuilder.last().appendln("                val[offset + i] = iterator.next();");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            return nelem;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "(final boolean val) {");
        codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized = %{com.neeve.quark.QuarkBuffer}.ensureCapacity(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized, " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen + 1, true);");
        codeBuilder.last().appendln("            %{com.neeve.quark.QuarkBuffer}.putByte(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized.getNativeAddress(), " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen, (byte)(val ? 1 : 0));");
        codeBuilder.last().appendln("            _dirty = true;");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen += 1;");
        codeBuilder.last().appendln("            return;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From(final %{com.neeve.lang.XBooleanSequence} sequence) {");
        codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
        codeBuilder.last().appendln("            if (sequence == null) {return;}");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized = %{com.neeve.quark.QuarkBuffer}.ensureCapacity(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized, " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen + sequence.serializedLength(), true);");
        codeBuilder.last().appendln("            final int len = sequence.getTo(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized, " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen);");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen += len;");
        codeBuilder.last().appendln("            _dirty = true;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(final %{com.neeve.lang.XBooleanSequence} sequence) {");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldClearerMethodName(field) + "();");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From(sequence);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From(final %{com.neeve.lang.XBooleanIterator} iterator) {");
        codeBuilder.last().appendln("            if (iterator == null) {return;}");
        codeBuilder.last().appendln("            if (iterator instanceof %{com.neeve.lang.XBooleanSequence}) {");
        codeBuilder.last().appendln("                " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From((%{com.neeve.lang.XBooleanSequence})iterator);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            else {");
        codeBuilder.last().appendln("                iterator.toFirst();");
        codeBuilder.last().appendln("                while (iterator.hasNext()) {");
        codeBuilder.last().appendln("                    " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "(iterator.next());");
        codeBuilder.last().appendln("                }");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(final %{com.neeve.lang.XBooleanIterator} iterator) {");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldClearerMethodName(field) + "();");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From(iterator);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From(final boolean[] val, final int offset, final int len) {");
        codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
        codeBuilder.last().appendln("            if (val == null || val.length == 0) {return;}");
        codeBuilder.last().appendln("            final int nbytes = (len * 1);");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized = %{com.neeve.quark.QuarkBuffer}.ensureCapacity(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized, " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen + nbytes, true);");
        codeBuilder.last().appendln("            for (int i = offset ; i < (offset + len) ; i++) {");
        codeBuilder.last().appendln("                %{com.neeve.quark.QuarkBuffer}.putByte(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized.getNativeAddress(), " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen + (i - offset), (byte)(val[i] ? 1 : 0));");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen += nbytes;");
        codeBuilder.last().appendln("            _dirty = true;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(final boolean[] val, final int offset, final int len) {");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldClearerMethodName(field) + "();");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From(val, offset, len);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldClearerMethodName(field) + "() {");
        codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
        codeBuilder.last().appendln("            if (" + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen == 0) {return;}");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen = 0;");
        codeBuilder.last().appendln("            _dirty = true;");
        codeBuilder.last().appendln("        }");
    }

    private final void writeDateArrayFieldPojoMethods(AdmEntity entity, AdmField field, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("        final private %{com.neeve.lang.XDateSequence} " + AdmXbuf2Generator.fieldDeserializerVarName(field) + " = %{com.neeve.lang.XDateSequence}.create();");
        codeBuilder.last().appendln("        private %{com.neeve.quark.QuarkBuffer} " + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized;");
        codeBuilder.last().appendln("        private int " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen;");
        codeBuilder.last().appendln("        final public int " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Count() {");
        codeBuilder.last().appendln("            return " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen / 8;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public %{com.neeve.lang.XDateSequence} " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Deserializer() {");
        codeBuilder.last().appendln("            if (" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized != null) {");
        codeBuilder.last().appendln("                " + AdmXbuf2Generator.fieldDeserializerVarName(field) + ".wrap(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized, 0, " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            else {");
        codeBuilder.last().appendln("                " + AdmXbuf2Generator.fieldDeserializerVarName(field) + ".wrap(0l, 0, 0);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            return " + AdmXbuf2Generator.fieldDeserializerVarName(field) + ";");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public %{com.neeve.lang.XDateIterator} " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Iterator() {");
        codeBuilder.last().appendln("            if (" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized != null) {");
        codeBuilder.last().appendln("                " + AdmXbuf2Generator.fieldDeserializerVarName(field) + ".wrap(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized, 0, " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            else {");
        codeBuilder.last().appendln("                " + AdmXbuf2Generator.fieldDeserializerVarName(field) + ".wrap(0l, 0, 0);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            return " + AdmXbuf2Generator.fieldDeserializerVarName(field) + ".iterator();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public int " + AdmXbuf2Generator.fieldGetterMethodName(field) + "To(final long[] val, final int offset) {");
        codeBuilder.last().appendln("            final int nelem = " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Count();");
        codeBuilder.last().appendln("            if (nelem > val.length - offset) {");
        codeBuilder.last().appendln("                throw new IllegalArgumentException(\"array too small\");");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            if (" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized != null) {");
        codeBuilder.last().appendln("                " + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized.getTo(0, val, offset, nelem);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            return nelem;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public int " + AdmXbuf2Generator.fieldGetterMethodName(field) + "To(final %{java.util.Date}[] val, final int offset) {");
        codeBuilder.last().appendln("            final int nelem = " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Count();");
        codeBuilder.last().appendln("            if (nelem > val.length - offset) {");
        codeBuilder.last().appendln("                throw new IllegalArgumentException(\"array too small\");");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Deserializer().getTo(val, offset);");
        codeBuilder.last().appendln("            return nelem;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "(final long val) {");
        codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized = %{com.neeve.quark.QuarkBuffer}.ensureCapacity(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized, " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen + 8, true);");
        codeBuilder.last().appendln("            %{com.neeve.quark.QuarkBuffer}.putLong(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized.getNativeAddress(), " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen, val);");
        codeBuilder.last().appendln("            _dirty = true;");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen += 8;");
        codeBuilder.last().appendln("            return;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "(final Date val) {");
        codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
        codeBuilder.last().appendln("            if (val == null) {return;}");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "(val.getTime());");
        codeBuilder.last().appendln("            return;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From(final %{com.neeve.lang.XDateSequence} sequence) {");
        codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
        codeBuilder.last().appendln("            if (sequence == null) {return;}");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized = %{com.neeve.quark.QuarkBuffer}.ensureCapacity(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized, " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen + sequence.serializedLength(), true);");
        codeBuilder.last().appendln("            final int len = sequence.getTo(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized, " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen);");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen += len;");
        codeBuilder.last().appendln("            _dirty = true;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(final %{com.neeve.lang.XDateSequence} sequence) {");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldClearerMethodName(field) + "();");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From(sequence);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From(final %{com.neeve.lang.XDateIterator} iterator) {");
        codeBuilder.last().appendln("            if (iterator == null) {return;}");
        codeBuilder.last().appendln("            if (iterator instanceof %{com.neeve.lang.XDateSequence}) {");
        codeBuilder.last().appendln("                " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From((%{com.neeve.lang.XDateSequence})iterator);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            else {");
        codeBuilder.last().appendln("                iterator.toFirst();");
        codeBuilder.last().appendln("                while (iterator.hasNext()) {");
        codeBuilder.last().appendln("                    " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "(iterator.nextAsTimestamp());");
        codeBuilder.last().appendln("                }");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(final %{com.neeve.lang.XDateIterator} iterator) {");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldClearerMethodName(field) + "();");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From(iterator);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From(final long[] val, final int offset, final int len) {");
        codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
        codeBuilder.last().appendln("            if (val == null || val.length == 0) {return;}");
        codeBuilder.last().appendln("            final int nbytes = (len * 8);");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized = %{com.neeve.quark.QuarkBuffer}.ensureCapacity(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized, " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen + nbytes, true);");
        codeBuilder.last().appendln("            for (int i = offset ; i < (offset + len) ; i++) {");
        codeBuilder.last().appendln("                %{com.neeve.quark.QuarkBuffer}.putLong(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized.getNativeAddress(), " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen + (i - offset), val[i]);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen += nbytes;");
        codeBuilder.last().appendln("            _dirty = true;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(final long[] val, final int offset, final int len) {");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldClearerMethodName(field) + "();");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From(val, offset, len);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldClearerMethodName(field) + "() {");
        codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
        codeBuilder.last().appendln("            if (" + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen == 0) {return;}");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen = 0;");
        codeBuilder.last().appendln("            _dirty = true;");
        codeBuilder.last().appendln("        }");
    }

    private final void writeStringArrayFieldPojoMethods(AdmEntity entity, AdmField field, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("        final private %{com.neeve.lang.XStringSequence} " + AdmXbuf2Generator.fieldDeserializerVarName(field) + " = %{com.neeve.lang.XStringSequence}.create();");
        codeBuilder.last().appendln("        private %{com.neeve.quark.QuarkBuffer} " + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized;");
        codeBuilder.last().appendln("        private int " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen;");
        codeBuilder.last().appendln("        final public %{com.neeve.lang.XStringSequence} " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Deserializer() {");
        codeBuilder.last().appendln("            if (" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized != null) {");
        codeBuilder.last().appendln("                " + AdmXbuf2Generator.fieldDeserializerVarName(field) + ".wrap(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized, 0, " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            else {");
        codeBuilder.last().appendln("                " + AdmXbuf2Generator.fieldDeserializerVarName(field) + ".wrap(0l, 0, 0);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            return " + AdmXbuf2Generator.fieldDeserializerVarName(field) + ";");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public %{com.neeve.quark.QuarkStringIterator} " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Iterator() {");
        codeBuilder.last().appendln("            if (" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized != null) {");
        codeBuilder.last().appendln("                " + AdmXbuf2Generator.fieldDeserializerVarName(field) + ".wrap(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized, 0, " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            else {");
        codeBuilder.last().appendln("                " + AdmXbuf2Generator.fieldDeserializerVarName(field) + ".wrap(0l, 0, 0);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            return " + AdmXbuf2Generator.fieldDeserializerVarName(field) + ".iterator();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "(final %{com.neeve.quark.QuarkString} val) {");
        codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
        codeBuilder.last().appendln("            if (val == null || val.isNull()) {return;}");
        codeBuilder.last().appendln("            final int serializedLength = (2 + val.length());");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized = %{com.neeve.quark.QuarkBuffer}.ensureCapacity(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized, " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen + serializedLength, true);");
        codeBuilder.last().appendln("            %{com.neeve.quark.QuarkBuffer}.putShort(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized.getNativeAddress(), " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen, (short)val.length());");
        codeBuilder.last().appendln("            val.getTo(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized.getNativeAddress(),  " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen + 2);");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen += serializedLength;");
        codeBuilder.last().appendln("            _dirty = true;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "(final %{com.neeve.lang.XString} val) {");
        codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
        codeBuilder.last().appendln("            if (val == null || val.isNull()) {return;}");
        codeBuilder.last().appendln("            final int serializedLength = (2 + val.length());");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized = %{com.neeve.quark.QuarkBuffer}.ensureCapacity(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized, " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen + serializedLength, true);");
        codeBuilder.last().appendln("            %{com.neeve.quark.QuarkBuffer}.putShort(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized.getNativeAddress(), " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen, (short)val.length());");
        codeBuilder.last().appendln("            val.getBackingBuffer().getToNative(val.getBackingBufferOffset(), " + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized.getNativeAddress(),  " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen + 2, val.length());");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen += serializedLength;");
        codeBuilder.last().appendln("            _dirty = true;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "(final String val) {");
        codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
        codeBuilder.last().appendln("            if (val == null) {return;}");
        codeBuilder.last().appendln("            final int serializedLength = (2 + %{com.neeve.quark.QuarkBuffer}.calculateUTF8Length(val));");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized = %{com.neeve.quark.QuarkBuffer}.ensureCapacity(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized, " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen + serializedLength, true);");
        codeBuilder.last().appendln("            %{com.neeve.quark.QuarkBuffer}.putShort(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized.getNativeAddress(), " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen, (short)val.length());");
        codeBuilder.last().appendln("            %{com.neeve.quark.QuarkBuffer}.putUTF8CharSequence(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized.getNativeAddress(),  " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen + 2, val, 0, serializedLength - 2);");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen += serializedLength;");
        codeBuilder.last().appendln("            _dirty = true;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From(final %{com.neeve.quark.QuarkStringDeserializer} deserializer) {");
        codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
        codeBuilder.last().appendln("            if (deserializer == null) {return;}");
        codeBuilder.last().appendln("            final int serializedLength = (2 + deserializer.serializedLength());");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized = %{com.neeve.quark.QuarkBuffer}.ensureCapacity(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized, " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen + serializedLength, true);");
        codeBuilder.last().appendln("            %{com.neeve.quark.QuarkBuffer}.putShort(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized.getNativeAddress(), " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen, (short)deserializer.serializedLength());");
        codeBuilder.last().appendln("            final int len = deserializer.getTo(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized, " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen + 2);");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen += serializedLength;");
        codeBuilder.last().appendln("            _dirty = true;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From(final %{com.neeve.lang.XStringSequence} sequence) {");
        codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
        codeBuilder.last().appendln("            if (sequence == null) {return;}");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized = %{com.neeve.quark.QuarkBuffer}.ensureCapacity(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized, " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen + sequence.serializedLength(), true);");
        codeBuilder.last().appendln("            final int len = sequence.getTo(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized, " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen);");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen += len;");
        codeBuilder.last().appendln("            _dirty = true;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(final %{com.neeve.lang.XStringSequence} sequence) {");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldClearerMethodName(field) + "();");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From(sequence);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From(final %{com.neeve.quark.QuarkStringIterator} iterator) {");
        codeBuilder.last().appendln("            if (iterator == null) {return;}");
        codeBuilder.last().appendln("            if (iterator instanceof %{com.neeve.lang.XStringSequence}) {");
        codeBuilder.last().appendln("                " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From((%{com.neeve.lang.XStringSequence})iterator);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            else {");
        codeBuilder.last().appendln("                iterator.toFirst();");
        codeBuilder.last().appendln("                while (iterator.hasNext()) {");
        codeBuilder.last().appendln("                    " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "(iterator.next());");
        codeBuilder.last().appendln("                }");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(final %{com.neeve.quark.QuarkStringIterator} iterator) {");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldClearerMethodName(field) + "();");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From(iterator);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From(final %{com.neeve.quark.QuarkString}[] val, final int offset, final int len) {");
        codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
        codeBuilder.last().appendln("            if (val == null || val.length == 0) {return;}");
        codeBuilder.last().appendln("            for (int i = offset ; i < (offset + len) ; i++) {");
        codeBuilder.last().appendln("                " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "(val[i]);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(final %{com.neeve.quark.QuarkString}[] val, final int offset, final int len) {");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldClearerMethodName(field) + "();");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From(val, offset, len);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From(final String[] val, final int offset, final int len) {");
        codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
        codeBuilder.last().appendln("            if (val == null || val.length == 0) {return;}");
        codeBuilder.last().appendln("            for (int i = offset ; i < (offset + len) ; i++) {");
        codeBuilder.last().appendln("                " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "(val[i]);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(final String[] val, final int offset, final int len) {");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldClearerMethodName(field) + "();");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From(val, offset, len);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldClearerMethodName(field) + "() {");
        codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
        codeBuilder.last().appendln("            if (" + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen == 0) {return;}");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen = 0;");
        codeBuilder.last().appendln("            _dirty = true;");
        codeBuilder.last().appendln("        }");
    }

    private final void writeUserPrimitiveArrayFieldPojoMethods(AdmEntity entity, AdmField field, AdmSourceCodeBuilder codeBuilder) {
        AdmType fieldType = field.getType();
        AdmPrimitive.Type primitiveType = ((AdmPrimitiveArray)fieldType).getType();
        switch (primitiveType) {
            case Byte: {
                this.writeBulkCopyUserPrimitiveArrayFieldPojoMethods(entity, field, "%{com.neeve.lang.XByteSequence}", 1, codeBuilder);
                break;
            }
            case Char: {
                this.writeBulkCopyUserPrimitiveArrayFieldPojoMethods(entity, field, "%{com.neeve.lang.XCharSequence}", 2, codeBuilder);
                break;
            }
            case Short: {
                this.writeBulkCopyUserPrimitiveArrayFieldPojoMethods(entity, field, "%{com.neeve.lang.XShortSequence}", 2, codeBuilder);
                break;
            }
            case Integer: {
                this.writeBulkCopyUserPrimitiveArrayFieldPojoMethods(entity, field, "%{com.neeve.lang.XIntSequence}", 4, codeBuilder);
                break;
            }
            case Long: {
                this.writeBulkCopyUserPrimitiveArrayFieldPojoMethods(entity, field, "%{com.neeve.lang.XLongSequence}", 8, codeBuilder);
                break;
            }
            case Float: {
                this.writeBulkCopyUserPrimitiveArrayFieldPojoMethods(entity, field, "%{com.neeve.lang.XFloatSequence}", 4, codeBuilder);
                break;
            }
            case Double: {
                this.writeBulkCopyUserPrimitiveArrayFieldPojoMethods(entity, field, "%{com.neeve.lang.XDoubleSequence}", 8, codeBuilder);
                break;
            }
            case Boolean: {
                this.writeBooleanArrayFieldPojoMethods(entity, field, codeBuilder);
                break;
            }
            case Date: {
                this.writeDateArrayFieldPojoMethods(entity, field, codeBuilder);
                break;
            }
            case String: {
                this.writeStringArrayFieldPojoMethods(entity, field, codeBuilder);
                break;
            }
            case Currency: {
                break;
            }
            case UUID: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown primitive field type ['" + (Object)((Object)primitiveType) + "]");
            }
        }
    }

    private final void writeUserEntityArrayFieldPojoMethods(AdmEntity entity, AdmField field, AdmSourceCodeBuilder codeBuilder) {
        AdmEntityArray fieldType = (AdmEntityArray)field.getType();
        String entityName = fieldType.getType().getTemplatedJavaTypeName();
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("        final private %{com.neeve.lang.XLinkedList}<" + entityName + "> " + AdmXbuf2Generator.fieldValueVarName(field) + " = new %{com.neeve.lang.XLinkedList}<" + entityName + ">();");
        codeBuilder.last().appendln("        final public int " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Count() {");
        codeBuilder.last().appendln("            return " + AdmXbuf2Generator.fieldValueVarName(field) + ".size();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public %{com.neeve.lang.XIterator}<" + entityName + "> " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Iterator() {");
        codeBuilder.last().appendln("            return " + AdmXbuf2Generator.fieldValueVarName(field) + ".reusableIterator();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "(final " + entityName + " val) {");
        codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
        codeBuilder.last().appendln("            if (val == null) {return;}");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + ".add(val);");
        codeBuilder.last().appendln("            _dirty = true;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From(final " + entityName + ".Deserializer deserializer) {");
        codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
        codeBuilder.last().appendln("            if (deserializer == null) {return;}");
        codeBuilder.last().appendln("            final " + entityName + " val = " + entityName + ".create();");
        codeBuilder.last().appendln("            if (deserializer.getSerializedLength() > 0) val.deserializeFrom(deserializer);");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + ".add(val);");
        codeBuilder.last().appendln("            _dirty = true;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldLenderToMethodName(field) + "(final " + entityName + " val) {");
        codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
        codeBuilder.last().appendln("            if (val == null) {return;}");
        codeBuilder.last().appendln("            val.acquire();");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + ".add(val);");
        codeBuilder.last().appendln("            _dirty = true;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldClearerMethodName(field) + "() {");
        codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
        codeBuilder.last().appendln("            if (" + AdmXbuf2Generator.fieldValueVarName(field) + ".size() == 0) {return;}");
        codeBuilder.last().appendln("            final %{com.neeve.lang.XIterator}<" + entityName + "> iterator = " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Iterator();");
        codeBuilder.last().appendln("            while (iterator.hasNext()) {");
        codeBuilder.last().appendln("                final " + entityName + " val = iterator.next();");
        codeBuilder.last().appendln("                iterator.remove();");
        codeBuilder.last().appendln("                val.dispose();");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            _dirty = true;");
        codeBuilder.last().appendln("        }");
    }

    private final void writeUserEnumerationArrayFieldPojoMethods(AdmEntity entity, AdmField field, AdmSourceCodeBuilder codeBuilder) {
        AdmEnumerationArray fieldType = (AdmEnumerationArray)field.getType();
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("        final private " + AdmXbuf2Generator.fieldDeserializerClassName(field) + " " + AdmXbuf2Generator.fieldDeserializerVarName(field) + " = " + AdmXbuf2Generator.fieldDeserializerClassName(field) + ".create();");
        codeBuilder.last().appendln("        private %{com.neeve.quark.QuarkBuffer} " + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized;");
        codeBuilder.last().appendln("        private int " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen;");
        codeBuilder.last().appendln("        final public int " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Count() {");
        codeBuilder.last().appendln("            return " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen / 4;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public " + AdmXbuf2Generator.fieldDeserializerClassName(field) + " " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Deserializer() {");
        codeBuilder.last().appendln("            if (" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized != null) {");
        codeBuilder.last().appendln("                " + AdmXbuf2Generator.fieldDeserializerVarName(field) + ".wrap(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized, 0, " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            else {");
        codeBuilder.last().appendln("                " + AdmXbuf2Generator.fieldDeserializerVarName(field) + ".wrap(0l, 0, 0);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            return " + AdmXbuf2Generator.fieldDeserializerVarName(field) + ";");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public XIterator<" + fieldType.getComponentType().getTemplatedJavaTypeName() + "> " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Iterator() {");
        codeBuilder.last().appendln("            if (" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized != null) {");
        codeBuilder.last().appendln("                " + AdmXbuf2Generator.fieldDeserializerVarName(field) + ".wrap(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized, 0, " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            else {");
        codeBuilder.last().appendln("                " + AdmXbuf2Generator.fieldDeserializerVarName(field) + ".wrap(0l, 0, 0);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            return " + AdmXbuf2Generator.fieldDeserializerVarName(field) + ".iterator();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public int " + AdmXbuf2Generator.fieldGetterMethodName(field) + "To(final " + fieldType.getComponentType().getTemplatedJavaTypeName() + "[] val, final int offset) {");
        codeBuilder.last().appendln("            final int nelem = " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Count();");
        codeBuilder.last().appendln("            if (nelem > val.length - offset) {");
        codeBuilder.last().appendln("                throw new IllegalArgumentException(\"array too small\");");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            final XIterator<" + fieldType.getComponentType().getTemplatedJavaTypeName() + "> iterator = " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Iterator();");
        codeBuilder.last().appendln("            for (int i = 0 ; i < nelem ; i++) {");
        codeBuilder.last().appendln("                val[offset + i] = iterator.next();");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            return nelem;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "(final " + fieldType.getComponentType().getTemplatedJavaTypeName() + " val) {");
        codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
        if (entity.getNullEntityArrayElementPolicy() == AdmEntity.NullArrayElementPolicy.Throw) {
            codeBuilder.last().appendln("            if (val == null) {");
            codeBuilder.last().appendln("                throw new NullPointerException(\"Can't set array field with a null value.\");");
            codeBuilder.last().appendln("            }");
        } else {
            codeBuilder.last().appendln("            if (val == null) {return;}");
        }
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized = %{com.neeve.quark.QuarkBuffer}.ensureCapacity(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized, " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen + 4, true);");
        codeBuilder.last().appendln("            %{com.neeve.quark.QuarkBuffer}.putInt(" + AdmXbuf2Generator.fieldValueVarName(field) + "Serialized.getNativeAddress(), " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen, val.val);");
        codeBuilder.last().appendln("            _dirty = true;");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen += 4;");
        codeBuilder.last().appendln("            return;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From(final XIterator<" + fieldType.getComponentType().getTemplatedJavaTypeName() + "> iterator) {");
        codeBuilder.last().appendln("            if (iterator == null) {return;}");
        if (entity.getNullEntityArrayElementPolicy() == AdmEntity.NullArrayElementPolicy.Throw) {
            codeBuilder.last().appendln("            if (iterator.toFirst().hasNext()) {");
            codeBuilder.last().appendln("                while (iterator.hasNext()) {");
            codeBuilder.last().appendln("                    if (iterator.next() == null) {");
            codeBuilder.last().appendln("                        throw new NullPointerException(\"can't set array field with a null iteratorue.\");");
            codeBuilder.last().appendln("                    }");
            codeBuilder.last().appendln("                }");
            codeBuilder.last().appendln("            }");
        }
        codeBuilder.last().appendln("            if (iterator instanceof " + AdmXbuf2Generator.fieldDeserializerClassName(field) + ") {");
        codeBuilder.last().appendln("                " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From((" + AdmXbuf2Generator.fieldDeserializerClassName(field) + ")iterator);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            else {");
        codeBuilder.last().appendln("                iterator.toFirst();");
        codeBuilder.last().appendln("                while (iterator.hasNext()) {");
        codeBuilder.last().appendln("                    final " + fieldType.getComponentType().getTemplatedJavaTypeName() + " val = iterator.next();");
        codeBuilder.last().appendln("                    if (val != null) {");
        codeBuilder.last().appendln("                        " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "(val);");
        codeBuilder.last().appendln("                    }");
        codeBuilder.last().appendln("                }");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(final XIterator<" + fieldType.getComponentType().getTemplatedJavaTypeName() + "> iterator) {");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldClearerMethodName(field) + "();");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From(iterator);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From(final " + fieldType.getComponentType().getTemplatedJavaTypeName() + "[] val, final int offset, final int len) {");
        codeBuilder.last().appendln("            if (val == null) {return;}");
        if (entity.getNullEntityArrayElementPolicy() == AdmEntity.NullArrayElementPolicy.Throw) {
            codeBuilder.last().appendln("            for (int i = 0; i < val.length; i++) {");
            codeBuilder.last().appendln("                if (val[i] == null) {");
            codeBuilder.last().appendln("                    throw new NullPointerException(\"Can't set array field with a null value at index '\" + i + \"'\");");
            codeBuilder.last().appendln("                }");
            codeBuilder.last().appendln("            }");
        }
        codeBuilder.last().appendln("            for (int i = 0 ; i < len ; i++) {");
        codeBuilder.last().appendln("                final " + fieldType.getComponentType().getTemplatedJavaTypeName() + " v = val[offset + i];");
        codeBuilder.last().appendln("                if (v != null) {");
        codeBuilder.last().appendln("                   " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "(v);");
        codeBuilder.last().appendln("                }");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(final " + fieldType.getComponentType().getTemplatedJavaTypeName() + "[] val, final int offset, final int len) {");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldClearerMethodName(field) + "();");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From(val, offset, len);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldClearerMethodName(field) + "() {");
        codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
        codeBuilder.last().appendln("            if (" + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen == 0) {return;}");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen = 0;");
        codeBuilder.last().appendln("            _dirty = true;");
        codeBuilder.last().appendln("        }");
    }

    private final void writeUserEnumerationFieldPojoMethods(AdmEntity entity, AdmField field, AdmSourceCodeBuilder codeBuilder) {
        AdmType fieldType = field.getType();
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("        private " + fieldType.getTemplatedJavaTypeName() + " " + AdmXbuf2Generator.fieldValueVarName(field) + ";");
        codeBuilder.last().appendln("        final public boolean " + AdmXbuf2Generator.fieldCheckerMethodName(field) + "() {");
        codeBuilder.last().appendln("            return ((_fieldBitmask[" + (field.getIndex() >> 6) + "] & (1L << " + (field.getIndex() & 0x3F) + ")) != 0);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public " + fieldType.getTemplatedJavaTypeName() + " " + AdmXbuf2Generator.fieldGetterMethodName(field) + "() {");
        codeBuilder.last().appendln("            return " + AdmXbuf2Generator.fieldValueVarName(field) + ";");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldSetterMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " val) {");
        codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
        codeBuilder.last().appendln("            if (val == null) {" + AdmXbuf2Generator.fieldClearerMethodName(field) + "(); return;}");
        codeBuilder.last().appendln("            _fieldBitmask[" + (field.getIndex() >> 6) + "] |= (1L << " + (field.getIndex() & 0x3F) + ");");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + " = val;");
        codeBuilder.last().appendln("            _dirty = true;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldClearerMethodName(field) + "() {");
        codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
        codeBuilder.last().appendln("            if (!" + AdmXbuf2Generator.fieldCheckerMethodName(field) + "()) {return;}");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + " = null;");
        codeBuilder.last().appendln("            _fieldBitmask[" + (field.getIndex() >> 6) + "] &= ~(1L << " + (field.getIndex() & 0x3F) + ");");
        codeBuilder.last().appendln("            _dirty = true;");
        codeBuilder.last().appendln("        }");
    }

    private final void writeUserEntityFieldPojoMethods(AdmEntity entity, AdmField field, AdmSourceCodeBuilder codeBuilder) {
        AdmType fieldType = field.getType();
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("        private " + fieldType.getTemplatedJavaTypeName() + " " + AdmXbuf2Generator.fieldValueVarName(field) + ";");
        codeBuilder.last().appendln("        final public boolean " + AdmXbuf2Generator.fieldCheckerMethodName(field) + "() {");
        codeBuilder.last().appendln("            return ((_fieldBitmask[" + (field.getIndex() >> 6) + "] & (1L << " + (field.getIndex() & 0x3F) + ")) != 0);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public " + fieldType.getTemplatedJavaTypeName() + " " + AdmXbuf2Generator.fieldGetterMethodName(field) + "() {");
        codeBuilder.last().appendln("            return " + AdmXbuf2Generator.fieldCheckerMethodName(field) + "() ? " + AdmXbuf2Generator.fieldValueVarName(field) + " : null;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldGetterToMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " to) {");
        codeBuilder.last().appendln("            to.clear();");
        codeBuilder.last().appendln("            if (!" + AdmXbuf2Generator.fieldCheckerMethodName(field) + "()) {return;}");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + ".sync();");
        codeBuilder.last().appendln("            to.deserializeFrom(" + AdmXbuf2Generator.fieldValueVarName(field) + ".getSerializedBuffer(), 0, " + AdmXbuf2Generator.fieldValueVarName(field) + ".getSerializedBufferLength());");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public " + fieldType.getTemplatedJavaTypeName() + " " + AdmXbuf2Generator.fieldTakerMethodName(field) + "() {");
        codeBuilder.last().appendln("            if (" + AdmXbuf2Generator.fieldValueVarName(field) + " != null) {" + AdmXbuf2Generator.fieldValueVarName(field) + ".acquire();}");
        codeBuilder.last().appendln("            return " + AdmXbuf2Generator.fieldValueVarName(field) + ";");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldSetterMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " val) {");
        codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
        codeBuilder.last().appendln("            if (" + AdmXbuf2Generator.fieldValueVarName(field) + " == val) {return;}");
        codeBuilder.last().appendln("            if (val == null) {" + AdmXbuf2Generator.fieldClearerMethodName(field) + "();return;}");
        codeBuilder.last().appendln("            if (" + AdmXbuf2Generator.fieldValueVarName(field) + " != null) {" + AdmXbuf2Generator.fieldValueVarName(field) + ".clear();}");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + " = val;");
        codeBuilder.last().appendln("            _fieldBitmask[" + (field.getIndex() >> 6) + "] |= (1L << " + (field.getIndex() & 0x3F) + ");");
        codeBuilder.last().appendln("            _dirty = true;");
        codeBuilder.last().appendln("            return;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + ".Deserializer deserializer) {");
        codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
        codeBuilder.last().appendln("            if (deserializer == null) {" + AdmXbuf2Generator.fieldClearerMethodName(field) + "();return;}");
        codeBuilder.last().appendln("            if (" + AdmXbuf2Generator.fieldValueVarName(field) + " != null) {" + AdmXbuf2Generator.fieldValueVarName(field) + ".clear();}");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + " = " + fieldType.getTemplatedJavaTypeName() + ".create();");
        codeBuilder.last().appendln("            if (deserializer.getSerializedLength() > 0) {");
        codeBuilder.last().appendln("                " + AdmXbuf2Generator.fieldValueVarName(field) + ".deserializeFrom(deserializer);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            _fieldBitmask[" + (field.getIndex() >> 6) + "] |= (1L << " + (field.getIndex() & 0x3F) + ");");
        codeBuilder.last().appendln("            _dirty = true;");
        codeBuilder.last().appendln("            return;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldLenderMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " val) {");
        codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
        codeBuilder.last().appendln("            if (" + AdmXbuf2Generator.fieldValueVarName(field) + " == val) {return;}");
        codeBuilder.last().appendln("            if (val == null) {" + AdmXbuf2Generator.fieldClearerMethodName(field) + "();return;}");
        codeBuilder.last().appendln("            if (" + AdmXbuf2Generator.fieldValueVarName(field) + " != null) {" + AdmXbuf2Generator.fieldValueVarName(field) + ".clear();}");
        codeBuilder.last().appendln("            val.acquire();");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + " = val;");
        codeBuilder.last().appendln("            _fieldBitmask[" + (field.getIndex() >> 6) + "] |= (1L << " + (field.getIndex() & 0x3F) + ");");
        codeBuilder.last().appendln("            _dirty = true;");
        codeBuilder.last().appendln("            return;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void " + AdmXbuf2Generator.fieldClearerMethodName(field) + "() {");
        codeBuilder.last().appendln("            if (_readonly) {throw new IllegalStateException(\"node is read only\");}");
        codeBuilder.last().appendln("            if (!" + AdmXbuf2Generator.fieldCheckerMethodName(field) + "()) {return;}");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + ".dispose();");
        codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + " = null;");
        codeBuilder.last().appendln("            _fieldBitmask[" + (field.getIndex() >> 6) + "] &= ~(1L << " + (field.getIndex() & 0x3F) + ");");
        codeBuilder.last().appendln("            _dirty = true;");
        codeBuilder.last().appendln("        }");
    }

    private final void writePojoClassDeclaration(AdmEntity entity, List<AdmField> allfields, List<AdmField> fields, AdmSourceCodeBuilder codeBuilder) {
        String entityIteratorVarName;
        String entityName;
        AdmPrimitive.Type primitiveType;
        AdmType fieldType;
        AdmType fieldType2;
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    /**");
        codeBuilder.last().appendln("     * The POJO");
        codeBuilder.last().appendln("     */");
        codeBuilder.last().appendln("    final public static class Pojo implements %{com.neeve.util.UtlPool}.Item<Pojo> {");
        codeBuilder.last().appendln("        final private class DeserializationCallback implements Deserializer.Callback {");
        for (AdmField field : fields) {
            AdmPrimitive.Type primitiveType2;
            fieldType2 = field.getType();
            if (fieldType2 instanceof AdmCollection || fieldType2 instanceof AdmEntity && !((AdmEntity)fieldType2).isEmbedded()) continue;
            codeBuilder.last().appendln("            @Override");
            if (fieldType2 instanceof AdmPrimitive) {
                primitiveType2 = ((AdmPrimitive)fieldType2).getType();
                switch (primitiveType2) {
                    case Byte: {
                        codeBuilder.last().appendln("            final public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(final byte val) {");
                        codeBuilder.last().appendln("               " + AdmXbuf2Generator.fieldSetterMethodName(field) + "(val);");
                        codeBuilder.last().appendln("            }");
                        break;
                    }
                    case Char: {
                        codeBuilder.last().appendln("            final public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(final char val) {");
                        codeBuilder.last().appendln("               " + AdmXbuf2Generator.fieldSetterMethodName(field) + "(val);");
                        codeBuilder.last().appendln("            }");
                        break;
                    }
                    case Short: {
                        codeBuilder.last().appendln("            final public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(final short val) {");
                        codeBuilder.last().appendln("               " + AdmXbuf2Generator.fieldSetterMethodName(field) + "(val);");
                        codeBuilder.last().appendln("            }");
                        break;
                    }
                    case Integer: {
                        codeBuilder.last().appendln("            final public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(final int val) {");
                        codeBuilder.last().appendln("               " + AdmXbuf2Generator.fieldSetterMethodName(field) + "(val);");
                        codeBuilder.last().appendln("            }");
                        break;
                    }
                    case Long: {
                        codeBuilder.last().appendln("            final public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(final long val) {");
                        codeBuilder.last().appendln("               " + AdmXbuf2Generator.fieldSetterMethodName(field) + "(val);");
                        codeBuilder.last().appendln("            }");
                        break;
                    }
                    case Float: {
                        codeBuilder.last().appendln("            final public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(final float val) {");
                        codeBuilder.last().appendln("               " + AdmXbuf2Generator.fieldSetterMethodName(field) + "(val);");
                        codeBuilder.last().appendln("            }");
                        break;
                    }
                    case Double: {
                        codeBuilder.last().appendln("            final public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(final double val) {");
                        codeBuilder.last().appendln("               " + AdmXbuf2Generator.fieldSetterMethodName(field) + "(val);");
                        codeBuilder.last().appendln("            }");
                        break;
                    }
                    case Boolean: {
                        codeBuilder.last().appendln("            final public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(final boolean val) {");
                        codeBuilder.last().appendln("               " + AdmXbuf2Generator.fieldSetterMethodName(field) + "(val);");
                        codeBuilder.last().appendln("            }");
                        break;
                    }
                    case Date: {
                        codeBuilder.last().appendln("            final public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(final long val) {");
                        codeBuilder.last().appendln("               " + AdmXbuf2Generator.fieldSetterMethodName(field) + "(val);");
                        codeBuilder.last().appendln("            }");
                        break;
                    }
                    case String: {
                        codeBuilder.last().appendln("            final public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(final %{com.neeve.quark.QuarkStringDeserializer} val) {");
                        codeBuilder.last().appendln("               " + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(val);");
                        codeBuilder.last().appendln("            }");
                        break;
                    }
                    case Currency: {
                        break;
                    }
                    case UUID: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown primitive field type ['" + (Object)((Object)primitiveType2) + "]");
                    }
                }
                continue;
            }
            if (fieldType2 instanceof AdmArray) {
                if (fieldType2 instanceof AdmPrimitiveArray) {
                    primitiveType2 = ((AdmPrimitiveArray)fieldType2).getType();
                    switch (primitiveType2) {
                        case Byte: 
                        case Char: 
                        case Short: 
                        case Integer: 
                        case Long: 
                        case Float: 
                        case Double: 
                        case Boolean: {
                            codeBuilder.last().appendln("            final public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(final " + primitiveType2.getPrimitiveTypeName() + " val) {");
                            codeBuilder.last().appendln("               " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "(val);");
                            codeBuilder.last().appendln("            }");
                            break;
                        }
                        case Date: {
                            codeBuilder.last().appendln("            final public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(final long val) {");
                            codeBuilder.last().appendln("               " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "(val);");
                            codeBuilder.last().appendln("            }");
                            break;
                        }
                        case String: {
                            codeBuilder.last().appendln("            final public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(final %{com.neeve.quark.QuarkStringDeserializer} val) {");
                            codeBuilder.last().appendln("               " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From(val);");
                            codeBuilder.last().appendln("            }");
                            break;
                        }
                        case Currency: {
                            break;
                        }
                        case UUID: {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown primitive field type ['" + (Object)((Object)primitiveType2) + "]");
                        }
                    }
                    continue;
                }
                if (fieldType2 instanceof AdmEntityArray) {
                    codeBuilder.last().appendln("            final public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(final " + ((AdmEntityArray)fieldType2).getType().getTemplatedJavaTypeName() + ".Deserializer val) {");
                    codeBuilder.last().appendln("               " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "From(val);");
                    codeBuilder.last().appendln("            }");
                    continue;
                }
                if (!(fieldType2 instanceof AdmEnumerationArray)) continue;
                codeBuilder.last().appendln("            final public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(final " + ((AdmEnumerationArray)fieldType2).getType().getTemplatedJavaTypeName() + " val) {");
                codeBuilder.last().appendln("               " + AdmXbuf2Generator.fieldAdderToMethodName(field) + "(val);");
                codeBuilder.last().appendln("            }");
                continue;
            }
            if (fieldType2 instanceof AdmEnumeration) {
                codeBuilder.last().appendln("            final public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(final " + fieldType2.getTemplatedJavaTypeName() + " val) {");
                codeBuilder.last().appendln("               " + AdmXbuf2Generator.fieldSetterMethodName(field) + "(val);");
                codeBuilder.last().appendln("            }");
                continue;
            }
            if (!(fieldType2 instanceof AdmEntity)) continue;
            codeBuilder.last().appendln("            final public void " + AdmXbuf2Generator.fieldDeserializerCallbackMethodName(field) + "(final " + ((AdmEntity)fieldType2).getTemplatedJavaTypeName() + ".Deserializer val) {");
            codeBuilder.last().appendln("               " + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(val);");
            codeBuilder.last().appendln("            }");
        }
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("        final private static byte FLG_CREATED = (byte)0x01;");
        codeBuilder.last().appendln("        final private static byte FLG_POOLED = (byte)0x02;");
        codeBuilder.last().appendln("        final private static byte FLG_PRIVATE = (byte)0x04;");
        codeBuilder.last().appendln("        final private static %{com.neeve.memory.MemoryStats} _memoryStats = %{com.neeve.memory.MemoryStats}.getInstance();");
        codeBuilder.last().appendln("        final private long[] _fieldBitmask = new long[" + (allfields.size() % 64 == 0 ? allfields.size() / 64 : allfields.size() / 64 + 1) + "];");
        codeBuilder.last().appendln("        final private DeserializationCallback _deserializationCallback = new DeserializationCallback();");
        codeBuilder.last().appendln("        private %{com.neeve.util.UtlPool}<Pojo> _pool;");
        codeBuilder.last().appendln("        private boolean _initialized;");
        codeBuilder.last().appendln("        private boolean _readonly;");
        codeBuilder.last().appendln("        private boolean _dirty;");
        codeBuilder.last().appendln("        private byte _flags;");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("        Pojo() {");
        codeBuilder.last().appendln("            setCreated();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("        final public static Pojo create(final boolean pvt) {");
        codeBuilder.last().appendln("            final Pojo pojo = _entityPojoPool.get(null);");
        codeBuilder.last().appendln("            if (pvt) {");
        codeBuilder.last().appendln("                pojo.setPrivate();");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            else {");
        codeBuilder.last().appendln("                pojo.clearPrivate();");
        codeBuilder.last().appendln("                _memoryStats.onEntityPojoAllocated(" + entity.getFullName() + ".class, MemoryStats.EntityType." + AdmXbuf2Generator.getMemoryStatsEntityType(entity) + ", !pojo.isCreated());");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            return pojo.clearPooled();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public static Pojo create() {");
        codeBuilder.last().appendln("            return create(false);");
        codeBuilder.last().appendln("        }");
        for (AdmField field : fields) {
            fieldType2 = field.getType();
            if (fieldType2 instanceof AdmPrimitive) {
                this.writeUserPrimitiveFieldPojoMethods(entity, field, codeBuilder);
                continue;
            }
            if (fieldType2 instanceof AdmArray) {
                if (fieldType2 instanceof AdmPrimitiveArray) {
                    this.writeUserPrimitiveArrayFieldPojoMethods(entity, field, codeBuilder);
                    continue;
                }
                if (fieldType2 instanceof AdmEntityArray) {
                    this.writeUserEntityArrayFieldPojoMethods(entity, field, codeBuilder);
                    continue;
                }
                if (!(fieldType2 instanceof AdmEnumerationArray)) continue;
                this.writeUserEnumerationArrayFieldPojoMethods(entity, field, codeBuilder);
                continue;
            }
            if (fieldType2 instanceof AdmEnumeration) {
                this.writeUserEnumerationFieldPojoMethods(entity, field, codeBuilder);
                continue;
            }
            if (!(fieldType2 instanceof AdmEntity) || !((AdmEntity)fieldType2).isEmbedded()) continue;
            this.writeUserEntityFieldPojoMethods(entity, field, codeBuilder);
        }
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("        final public void clear() {");
        codeBuilder.last().appendln("            _readonly = false;");
        for (AdmField field : fields) {
            fieldType2 = field.getType();
            if (fieldType2 instanceof AdmCollection || fieldType2 instanceof AdmEntity && !((AdmEntity)fieldType2).isEmbedded()) continue;
            if (fieldType2 instanceof AdmEntity) {
                codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldClearerMethodName(field) + "();");
                continue;
            }
            if (fieldType2 instanceof AdmArray) {
                if (fieldType2 instanceof AdmPrimitiveArray) {
                    codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen = 0;");
                    continue;
                }
                if (fieldType2 instanceof AdmEntityArray) {
                    codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldClearerMethodName(field) + "();");
                    continue;
                }
                if (!(fieldType2 instanceof AdmEnumerationArray)) continue;
                codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen = 0;");
                continue;
            }
            if (fieldType2 instanceof AdmPrimitive) {
                if (((AdmPrimitive)fieldType2).getType() == AdmPrimitive.Type.Date) {
                    codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + " = 0;");
                    continue;
                }
                if (((AdmPrimitive)fieldType2).getType() == AdmPrimitive.Type.String) continue;
                codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + " = " + ((AdmPrimitive)fieldType2).getDefaultValueLiteral() + ";");
                continue;
            }
            if (fieldType2 instanceof AdmEnumeration) {
                codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldValueVarName(field) + " = null;");
                continue;
            }
            codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldClearerMethodName(field) + "();");
        }
        int bitMaskCount = allfields.size() % 64 == 0 ? allfields.size() / 64 : allfields.size() / 64 + 1;
        for (int i = 0; i < bitMaskCount; ++i) {
            codeBuilder.last().appendln("            _fieldBitmask[" + i + "] = 0;");
        }
        codeBuilder.last().appendln("            _dirty = true;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("        final private Pojo setCreated() {");
        codeBuilder.last().appendln("            _flags |= FLG_CREATED;");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final private boolean isCreated() {");
        codeBuilder.last().appendln("            return (_flags & FLG_CREATED) != 0;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final private Pojo clearCreated() {");
        codeBuilder.last().appendln("            _flags &= ~FLG_CREATED;");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final private Pojo setPooled() {");
        codeBuilder.last().appendln("            _flags |= FLG_POOLED;");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final private boolean isPooled() {");
        codeBuilder.last().appendln("            return (_flags & FLG_POOLED) != 0;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final private Pojo clearPooled() {");
        codeBuilder.last().appendln("            _flags &= ~FLG_POOLED;");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final private Pojo setPrivate() {");
        codeBuilder.last().appendln("            _flags |= FLG_PRIVATE;");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final private boolean isPrivate() {");
        codeBuilder.last().appendln("            return (_flags & FLG_PRIVATE) != 0;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final private Pojo clearPrivate() {");
        codeBuilder.last().appendln("            _flags &= ~FLG_PRIVATE;");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void setAsReadOnly() {");
        codeBuilder.last().appendln("            _readonly = true;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public boolean isInitialized() {");
        codeBuilder.last().appendln("            return _initialized;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void setInitialized() {");
        codeBuilder.last().appendln("            _initialized = true;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void clearDirty() {");
        codeBuilder.last().appendln("            _dirty = false;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void forceDirty() {");
        codeBuilder.last().appendln("            _dirty = true;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public boolean isDirty() {");
        codeBuilder.last().appendln("            return _dirty;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("");
        codeBuilder.last().appendln("        final public int getSerializedLength() {");
        codeBuilder.last().appendln("            int len = 0;");
        for (AdmField field : fields) {
            fieldType = field.getType();
            if (fieldType instanceof AdmCollection || fieldType instanceof AdmEntity && !((AdmEntity)fieldType).isEmbedded()) continue;
            if (fieldType instanceof AdmPrimitive) {
                primitiveType = ((AdmPrimitive)fieldType).getType();
                switch (primitiveType) {
                    case Byte: 
                    case Char: 
                    case Short: 
                    case Integer: 
                    case Long: 
                    case Float: 
                    case Double: 
                    case Boolean: 
                    case Date: {
                        codeBuilder.last().appendln("            if (" + AdmXbuf2Generator.fieldCheckerMethodName(field) + "()) {");
                        codeBuilder.last().appendln("                len += %{com.neeve.xbuf2.XbufUtil}.primitiveFieldSerializedLength(" + field.getId() + ", " + AdmXbuf2Generator.fieldValueVarName(field) + ");");
                        codeBuilder.last().appendln("            }");
                        break;
                    }
                    case String: {
                        codeBuilder.last().appendln("            if (" + AdmXbuf2Generator.fieldCheckerMethodName(field) + "()) {");
                        codeBuilder.last().appendln("                len += %{com.neeve.xbuf2.XbufUtil}.varlenFieldSerializedLength(" + field.getId() + ", " + AdmXbuf2Generator.fieldValueVarName(field) + ".length());");
                        codeBuilder.last().appendln("            }");
                        break;
                    }
                    case Currency: {
                        break;
                    }
                    case UUID: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown primitive field type ['" + (Object)((Object)primitiveType) + "]");
                    }
                }
                continue;
            }
            if (fieldType instanceof AdmArray) {
                String iteratorVarName;
                if (fieldType instanceof AdmPrimitiveArray) {
                    primitiveType = ((AdmPrimitiveArray)fieldType).getType();
                    iteratorVarName = AdmXbuf2Generator.toFirstLetterLowercase(field.getName()) + "Iterator";
                    switch (primitiveType) {
                        case Byte: 
                        case Char: 
                        case Short: 
                        case Integer: 
                        case Long: 
                        case Float: 
                        case Double: 
                        case Boolean: {
                            codeBuilder.last().appendln("            final " + primitiveType.getTemplatedZGXIteratorType() + " " + iteratorVarName + " = " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Iterator();");
                            codeBuilder.last().appendln("            while (" + iteratorVarName + ".hasNext()) len += %{com.neeve.xbuf2.XbufUtil}.primitiveFieldSerializedLength(" + field.getId() + ", " + iteratorVarName + ".next());");
                            break;
                        }
                        case Date: {
                            codeBuilder.last().appendln("            final " + primitiveType.getTemplatedZGXIteratorType() + " " + iteratorVarName + " = " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Iterator();");
                            codeBuilder.last().appendln("            while (" + iteratorVarName + ".hasNext()) len += %{com.neeve.xbuf2.XbufUtil}.primitiveFieldSerializedLength(" + field.getId() + ", " + iteratorVarName + ".nextAsTimestamp());");
                            break;
                        }
                        case String: {
                            codeBuilder.last().appendln("            final %{com.neeve.quark.QuarkStringIterator} " + iteratorVarName + " = " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Iterator();");
                            codeBuilder.last().appendln("            while (" + iteratorVarName + ".hasNext()) len += %{com.neeve.xbuf2.XbufUtil}.varlenFieldSerializedLength(" + field.getId() + ", " + iteratorVarName + ".nextLength());");
                            break;
                        }
                        case Currency: {
                            break;
                        }
                        case UUID: {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown primitive field type ['" + (Object)((Object)primitiveType) + "]");
                        }
                    }
                    continue;
                }
                if (fieldType instanceof AdmEntityArray) {
                    entityName = ((AdmEntityArray)fieldType).getType().getTemplatedJavaTypeName();
                    entityIteratorVarName = AdmXbuf2Generator.toFirstLetterLowercase(field.getName()) + "Iterator";
                    codeBuilder.last().appendln("            final %{com.neeve.lang.XIterator}<" + entityName + "> " + entityIteratorVarName + " = " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Iterator();");
                    codeBuilder.last().appendln("            while (" + entityIteratorVarName + ".hasNext()) {");
                    codeBuilder.last().appendln("                final " + entityName + " val = " + entityIteratorVarName + ".next();");
                    codeBuilder.last().appendln("                len += val.hasDirtyPojo() ? %{com.neeve.xbuf2.XbufUtil}.varlenFieldSerializedLength(" + field.getId() + ", val.pojo().getSerializedLength()) : %{com.neeve.xbuf2.XbufUtil}.varlenFieldSerializedLength(" + field.getId() + ", val.getSerializedBufferLength());");
                    codeBuilder.last().appendln("            }");
                    continue;
                }
                if (!(fieldType instanceof AdmEnumerationArray)) continue;
                String enumerationName = ((AdmEnumerationArray)field.getType()).getType().getTemplatedJavaTypeName();
                iteratorVarName = AdmXbuf2Generator.toFirstLetterLowercase(field.getName()) + "Iterator";
                codeBuilder.last().appendln("            final %{com.neeve.lang.XIterator}<" + enumerationName + "> " + iteratorVarName + " = " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Iterator();");
                codeBuilder.last().appendln("            while (" + iteratorVarName + ".hasNext()) len += %{com.neeve.xbuf2.XbufUtil}.primitiveFieldSerializedLength(" + field.getId() + ", " + iteratorVarName + ".next().val);");
                continue;
            }
            if (fieldType instanceof AdmEnumeration) {
                codeBuilder.last().appendln("            if (" + AdmXbuf2Generator.fieldCheckerMethodName(field) + "()) {");
                codeBuilder.last().appendln("                len += %{com.neeve.xbuf2.XbufUtil}.primitiveFieldSerializedLength(" + field.getId() + ", " + AdmXbuf2Generator.fieldValueVarName(field) + ".val);");
                codeBuilder.last().appendln("            }");
                continue;
            }
            if (!(fieldType instanceof AdmEntity)) continue;
            codeBuilder.last().appendln("            if (" + AdmXbuf2Generator.fieldCheckerMethodName(field) + "()) {");
            codeBuilder.last().appendln("                len += (" + AdmXbuf2Generator.fieldValueVarName(field) + ".hasDirtyPojo() ? %{com.neeve.xbuf2.XbufUtil}.varlenFieldSerializedLength(" + field.getId() + ", " + AdmXbuf2Generator.fieldValueVarName(field) + ".pojo().getSerializedLength()) : %{com.neeve.xbuf2.XbufUtil}.varlenFieldSerializedLength(" + field.getId() + ", " + AdmXbuf2Generator.fieldValueVarName(field) + ".getSerializedBufferLength()));");
            codeBuilder.last().appendln("            }");
        }
        codeBuilder.last().appendln("            return len;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public int serialize(final Serializer serializer) {");
        codeBuilder.last().appendln("            if (!serializer.isInitialized()) {");
        codeBuilder.last().appendln("                throw new IllegalArgumentException(\"serializer not initialized\");");
        codeBuilder.last().appendln("            }");
        for (AdmField field : fields) {
            fieldType = field.getType();
            if (fieldType instanceof AdmCollection || fieldType instanceof AdmEntity && !((AdmEntity)fieldType).isEmbedded()) continue;
            if (fieldType instanceof AdmPrimitive) {
                primitiveType = ((AdmPrimitive)fieldType).getType();
                switch (primitiveType) {
                    case Byte: 
                    case Char: 
                    case Short: 
                    case Integer: 
                    case Long: 
                    case Float: 
                    case Double: 
                    case Boolean: 
                    case Date: 
                    case String: {
                        codeBuilder.last().appendln("            if (" + AdmXbuf2Generator.fieldCheckerMethodName(field) + "()) {");
                        codeBuilder.last().appendln("                serializer." + AdmXbuf2Generator.fieldSerializerMethodName(field) + "(" + AdmXbuf2Generator.fieldValueVarName(field) + ");");
                        codeBuilder.last().appendln("            }");
                        break;
                    }
                    case Currency: {
                        break;
                    }
                    case UUID: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown primitive field type ['" + (Object)((Object)primitiveType) + "]");
                    }
                }
                continue;
            }
            if (fieldType instanceof AdmArray) {
                if (fieldType instanceof AdmPrimitiveArray) {
                    primitiveType = ((AdmPrimitiveArray)fieldType).getType();
                    switch (primitiveType) {
                        case Byte: 
                        case Char: 
                        case Short: 
                        case Integer: 
                        case Long: 
                        case Float: 
                        case Double: 
                        case Boolean: 
                        case Date: 
                        case String: {
                            codeBuilder.last().appendln("            if (" + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen > 0) {");
                            codeBuilder.last().appendln("                serializer." + AdmXbuf2Generator.fieldSerializerMethodName(field) + "(" + AdmXbuf2Generator.fieldGetterMethodName(field) + "Iterator());");
                            codeBuilder.last().appendln("            }");
                            break;
                        }
                        case Currency: {
                            break;
                        }
                        case UUID: {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown primitive field type ['" + (Object)((Object)primitiveType) + "]");
                        }
                    }
                    continue;
                }
                if (fieldType instanceof AdmEntityArray) {
                    entityName = ((AdmEntityArray)fieldType).getType().getTemplatedJavaTypeName();
                    entityIteratorVarName = AdmXbuf2Generator.toFirstLetterLowercase(field.getName()) + "Iterator";
                    codeBuilder.last().appendln("            final %{com.neeve.lang.XIterator}<" + entityName + "> " + entityIteratorVarName + " = " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Iterator();");
                    codeBuilder.last().appendln("            while (" + entityIteratorVarName + ".hasNext()) {");
                    codeBuilder.last().appendln("                final " + entityName + " val = " + entityIteratorVarName + ".next();");
                    codeBuilder.last().appendln("                serializer." + AdmXbuf2Generator.fieldSerializerMethodName(field) + "(val);");
                    codeBuilder.last().appendln("            }");
                    continue;
                }
                if (!(fieldType instanceof AdmEnumerationArray)) continue;
                codeBuilder.last().appendln("            if (" + AdmXbuf2Generator.fieldValueVarName(field) + "SerializedLen > 0) {");
                codeBuilder.last().appendln("                serializer." + AdmXbuf2Generator.fieldSerializerMethodName(field) + "(" + AdmXbuf2Generator.fieldGetterMethodName(field) + "Iterator());");
                codeBuilder.last().appendln("            }");
                continue;
            }
            if (fieldType instanceof AdmEnumeration) {
                codeBuilder.last().appendln("            if (" + AdmXbuf2Generator.fieldCheckerMethodName(field) + "()) {");
                codeBuilder.last().appendln("                serializer." + AdmXbuf2Generator.fieldSerializerMethodName(field) + "(" + AdmXbuf2Generator.fieldValueVarName(field) + ");");
                codeBuilder.last().appendln("            }");
                continue;
            }
            if (!(fieldType instanceof AdmEntity)) continue;
            codeBuilder.last().appendln("            if (" + AdmXbuf2Generator.fieldCheckerMethodName(field) + "()) {");
            codeBuilder.last().appendln("                serializer." + AdmXbuf2Generator.fieldSerializerMethodName(field) + "(" + AdmXbuf2Generator.fieldValueVarName(field) + ");");
            codeBuilder.last().appendln("            }");
        }
        codeBuilder.last().appendln("            return serializer.done();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public void deserialize(final Deserializer deserializer) {");
        codeBuilder.last().appendln("            if (!deserializer.isInitialized()) {");
        codeBuilder.last().appendln("                throw new IllegalArgumentException(\"deserializer not initialized\");");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            clear();");
        codeBuilder.last().appendln("            deserializer.run(_deserializationCallback);");
        codeBuilder.last().appendln("            _initialized = true;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final public Pojo reset() {");
        codeBuilder.last().appendln("            clear();");
        codeBuilder.last().appendln("            _initialized = _dirty = false;");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        @Override");
        codeBuilder.last().appendln("        final public Pojo init() {");
        codeBuilder.last().appendln("            return reset();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        @Override");
        codeBuilder.last().appendln("        final public Pojo setPool(final %{com.neeve.util.UtlPool}<Pojo> pool) {");
        codeBuilder.last().appendln("            _pool = pool;");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        @Override");
        codeBuilder.last().appendln("        final public %{com.neeve.util.UtlPool}<Pojo> getPool() {");
        codeBuilder.last().appendln("            return _pool;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        final void dispose() {");
        codeBuilder.last().appendln("            clearCreated();");
        codeBuilder.last().appendln("            if (_pool != null) {");
        codeBuilder.last().appendln("                setPooled();");
        codeBuilder.last().appendln("                _pool.put(this);");
        codeBuilder.last().appendln("                if (!isPrivate()) _memoryStats.onEntityPojoDisposed(" + entity.getFullName() + ".class, MemoryStats.EntityType." + AdmXbuf2Generator.getMemoryStatsEntityType(entity) + ", true);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        if (this.generateFinalizerMethods(entity)) {
            codeBuilder.last().appendln("        @Override");
            codeBuilder.last().appendln("        final public void finalize() {");
            codeBuilder.last().appendln("            if (!isPrivate()) {");
            codeBuilder.last().appendln("                if (isPooled()) {");
            codeBuilder.last().appendln("                    _memoryStats.onEntityPojoLeaked(" + entity.getFullName() + ".class, MemoryStats.EntityType." + AdmXbuf2Generator.getMemoryStatsEntityType(entity) + ");");
            codeBuilder.last().appendln("                }");
            codeBuilder.last().appendln("                else {");
            codeBuilder.last().appendln("                    _memoryStats.onEntityPojoDisposed(" + entity.getFullName() + ".class, MemoryStats.EntityType." + AdmXbuf2Generator.getMemoryStatsEntityType(entity) + ", false);");
            codeBuilder.last().appendln("                }");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
        }
        codeBuilder.last().appendln("    }");
    }

    private final void writeMemoryStatsVariableDeclarations(AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    // ----- memory stats variable -----");
        codeBuilder.last().appendln("    final private static %{com.neeve.memory.MemoryStats} _memoryStats = %{com.neeve.memory.MemoryStats}.getInstance();");
        codeBuilder.last().appendln("    // ----- memory stats variable -----");
    }

    private final void writePoolingDeclarations(AdmEntity entity, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    // ----- pool and pool factories -----");
        codeBuilder.last().appendln("    final private static " + entity.getName() + "PoolFactory _" + AdmXbuf2Generator.toFirstLetterLowercase(entity.getName()) + "Factory = new " + entity.getName() + "PoolFactory();");
        codeBuilder.last().appendln("    final private static " + entity.getName() + "PojoPoolFactory _" + AdmXbuf2Generator.toFirstLetterLowercase(entity.getName()) + "PojoFactory = new " + entity.getName() + "PojoPoolFactory();");
        codeBuilder.last().appendln("    final private static " + entity.getName() + "SerializerPoolFactory _" + AdmXbuf2Generator.toFirstLetterLowercase(entity.getName()) + "SerializerFactory = new " + entity.getName() + "SerializerPoolFactory();");
        codeBuilder.last().appendln("    final private static " + entity.getName() + "DeserializerPoolFactory _" + AdmXbuf2Generator.toFirstLetterLowercase(entity.getName()) + "DeserializerFactory = new " + entity.getName() + "DeserializerPoolFactory();");
        codeBuilder.last().appendln("    final static %{com.neeve.util.UtlPool}<" + entity.getName() + "> _entityPool = %{com.neeve.util.UtlPool}.<" + entity.getName() + ">create(\"quark.entity\", \"" + entity.getName() + "QuarkEntity." + entity.getFactory().getId() + "." + entity.getId() + "\", _" + AdmXbuf2Generator.toFirstLetterLowercase(entity.getName()) + "Factory, %{com.neeve.quark.QuarkHeuristics}.configurePoolParams(" + entity.getName() + ".class, %{com.neeve.util.UtlPool}.Params.create().setThreaded(true))).setEvictedItemReceiver(new " + entity.getName() + "PoolEvictedItemReceiver());");
        codeBuilder.last().appendln("    final static %{com.neeve.util.UtlPool}<" + entity.getName() + ".Pojo> _entityPojoPool = %{com.neeve.util.UtlPool}.<" + entity.getName() + ".Pojo>create(\"quark.entity.pojo\", \"" + entity.getName() + "QuarkEntityPojo." + entity.getFactory().getId() + "." + entity.getId() + "\", _" + AdmXbuf2Generator.toFirstLetterLowercase(entity.getName()) + "PojoFactory, %{com.neeve.quark.QuarkHeuristics}.configurePoolParams(" + entity.getName() + ".Pojo.class, %{com.neeve.util.UtlPool}.Params.create().setThreaded(true))).setEvictedItemReceiver(new " + entity.getName() + "PojoPoolEvictedItemReceiver());");
        codeBuilder.last().appendln("    final static %{com.neeve.util.UtlPool}<" + entity.getName() + ".Serializer> _entitySerializerPool = %{com.neeve.util.UtlPool}.<" + entity.getName() + ".Serializer>create(\"quark.entity.serializer\", \"" + entity.getName() + "QuarkEntitySerializer." + entity.getFactory().getId() + "." + entity.getId() + "\", _" + AdmXbuf2Generator.toFirstLetterLowercase(entity.getName()) + "SerializerFactory, %{com.neeve.quark.QuarkHeuristics}.configurePoolParams(" + entity.getName() + ".Serializer.class, %{com.neeve.util.UtlPool}.Params.create().setThreaded(true))).setEvictedItemReceiver(new " + entity.getName() + "SerializerPoolEvictedItemReceiver());");
        codeBuilder.last().appendln("    final static %{com.neeve.util.UtlPool}<" + entity.getName() + ".Deserializer> _entityDeserializerPool = %{com.neeve.util.UtlPool}.<" + entity.getName() + ".Deserializer>create(\"quark.entity.deserializer\", \"" + entity.getName() + "QuarkEntityDeserializer." + entity.getFactory().getId() + "." + entity.getId() + "\", _" + AdmXbuf2Generator.toFirstLetterLowercase(entity.getName()) + "DeserializerFactory, %{com.neeve.quark.QuarkHeuristics}.configurePoolParams(" + entity.getName() + ".Deserializer.class, %{com.neeve.util.UtlPool}.Params.create().setThreaded(true))).setEvictedItemReceiver(new " + entity.getName() + "DeserializerPoolEvictedItemReceiver());");
        if (entity.isEmbedded()) {
            codeBuilder.last().appendln("    final private %{java.util.concurrent.atomic.AtomicInteger} _ownershipCount = new %{java.util.concurrent.atomic.AtomicInteger}(1);");
        }
        codeBuilder.last().appendln("    private %{com.neeve.util.UtlPool}<" + entity.getName() + "> _pool;");
        codeBuilder.last().appendln("    // ----- pool and pool factories -----");
    }

    private final void writeBackingBufferDeclaration(AdmEntity entity, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- Backing buffer -----");
        if (this.useIOBufferAsBackingStorage(entity)) {
            codeBuilder.last().appendln("    private %{com.neeve.quark.QuarkBuffer} _serializedBuffer;");
            codeBuilder.last().appendln("    private int _serializedBufferLength;");
        } else {
            codeBuilder.last().appendln("    private long _serializedBuffer;");
            codeBuilder.last().appendln("    private int _serializedBufferLength;");
            codeBuilder.last().appendln("    private int _serializedBufferCapacity;");
        }
        codeBuilder.last().appendln("    // ----- Backing buffer -----");
    }

    private final void writeSerializerDeserializerPojoDeclaration(AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- Serializer/Deserializer, POJO -----");
        codeBuilder.last().appendln("    private Serializer _serializer;");
        codeBuilder.last().appendln("    private Deserializer _deserializer;");
        codeBuilder.last().appendln("    private Pojo _pojo;");
        codeBuilder.last().appendln("    // ----- Serializer/Deserializer, POJO -----");
    }

    protected final void writeCreatedFieldDeclaration(AdmEntity entity, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- created field -----");
        codeBuilder.last().appendln("    private boolean created;");
        codeBuilder.last().appendln("    // ----- created field -----");
    }

    private final void writeEmptyEntityArrayDeclaration(AdmEntity entity, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- empty entity array -----");
        codeBuilder.last().appendln("    final public static " + entity.getName() + "[] EMPTY_ARRAY = new " + entity.getName() + "[0];");
        codeBuilder.last().appendln("    // ----- empty entity array -----");
    }

    private final void writeConstructors(AdmCollection collection, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    // ----- Constructors -----");
        codeBuilder.last().appendln("    " + collection.getName() + "(final %{com.eaio.uuid.UUID} id) {");
        codeBuilder.last().appendln("        super(" + collection.getFactory().getName() + ".OFID,");
        codeBuilder.last().appendln("              " + collection.getFactory().getName() + ".VFID,");
        codeBuilder.last().appendln("              " + collection.getFactory().getName() + ".ID_" + collection.getName() + ",");
        codeBuilder.last().appendln("              id,");
        codeBuilder.last().appendln("              " + collection.isTransactional() + ");");
        codeBuilder.last().appendln("        _memoryStats.onEntityAllocated(" + collection.getFullName() + ".class, MemoryStats.EntityType.Collection, false);");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    public static " + collection.getName() + " create() {return " + collection.getFactory().getName() + ".create" + collection.getName() + "();}");
        codeBuilder.last().appendln("    // -----Constructors -----");
    }

    private final void writeConstructors(AdmEntity entity, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- Constructors -----");
        if (entity.isEmbedded()) {
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln("    " + entity.getName() + "() {");
            codeBuilder.last().appendln("        created = true;");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    public static " + entity.getName() + " create() {");
            codeBuilder.last().appendln("        final " + entity.getName() + " entity = _entityPool.get(null);");
            codeBuilder.last().appendln("        _memoryStats.onEntityAllocated(" + entity.getFullName() + ".class, MemoryStats.EntityType.EmbeddedEntity, !entity.created);");
            codeBuilder.last().appendln("        return entity;");
            codeBuilder.last().appendln("    }");
        } else if (entity.isRoot()) {
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln("    " + entity.getName() + "(final %{com.eaio.uuid.UUID} id) {");
            codeBuilder.last().appendln("        super(" + entity.getFactory().getName() + ".OFID,");
            codeBuilder.last().appendln("              " + entity.getFactory().getName() + ".VFID,");
            codeBuilder.last().appendln("              " + entity.getFactory().getName() + ".ID_" + entity.getName() + ",");
            codeBuilder.last().appendln("              id,");
            codeBuilder.last().appendln("              " + entity.isTransactional() + ",");
            codeBuilder.last().appendln("              -1);");
            if (entity.isMessage()) {
                codeBuilder.last().appendln("        setMessageReflector(this);");
                codeBuilder.last().appendln("        setMessage(ENCODING_TYPE_XBUF2, this);");
                codeBuilder.last().appendln("        _memoryStats.onEntityAllocated(" + entity.getFullName() + ".class, MemoryStats.EntityType.Entity, false);");
            }
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    public static " + entity.getName() + " create(final int grid) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "(grid);}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " create(final int grid, final %{com.eaio.uuid.UUID} id) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "(grid, id);}");
        } else {
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln("    " + entity.getName() + "(final %{com.eaio.uuid.UUID} id) {");
            codeBuilder.last().appendln("        super(" + entity.getFactory().getName() + ".OFID,");
            codeBuilder.last().appendln("              " + entity.getFactory().getName() + ".VFID,");
            codeBuilder.last().appendln("              " + entity.getFactory().getName() + ".ID_" + entity.getName() + ",");
            codeBuilder.last().appendln("              id,");
            codeBuilder.last().appendln("              " + entity.isTransactional() + ");");
            if (entity.isMessage()) {
                codeBuilder.last().appendln("        setMessageReflector(this);");
                codeBuilder.last().appendln("        setMessage(ENCODING_TYPE_XBUF2, this);");
                codeBuilder.last().appendln("        _memoryStats.onEntityAllocated(" + entity.getFullName() + ".class, MemoryStats.EntityType.Message, false);");
            } else {
                codeBuilder.last().appendln("        _memoryStats.onEntityAllocated(" + entity.getFullName() + ".class, MemoryStats.EntityType.Entity, false);");
            }
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    public static " + entity.getName() + " create() {return " + entity.getFactory().getName() + ".create" + entity.getName() + "();}");
            codeBuilder.last().appendln("    public static " + entity.getName() + " create(final %{com.eaio.uuid.UUID} id) {return " + entity.getFactory().getName() + ".create" + entity.getName() + "(id);}");
            codeBuilder.last().appendln("    @Deprecated");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFrom(%{java.nio.ByteBuffer} val) {return create().deserializeFrom(val);}");
            codeBuilder.last().appendln("    @Deprecated");
            codeBuilder.last().appendln("    public static " + entity.getName() + " createFrom(byte[] val) {return create().deserializeFromByteArray(val);}");
        }
        codeBuilder.last().appendln("    // ----- Constructors -----");
    }

    private final void writeBufferAccessorMethods(AdmEntity entity, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        if (this.useIOBufferAsBackingStorage(entity)) {
            codeBuilder.last().appendln("    final private QuarkBuffer serializedBuffer(final int len) {");
            codeBuilder.last().appendln("        final QuarkBuffer oldBuffer = _serializedBuffer;");
            codeBuilder.last().appendln("        final int oldCapacity = oldBuffer != null ? oldBuffer.getCapacity() : 0;");
            codeBuilder.last().appendln("        _serializedBuffer = %{com.neeve.quark.QuarkBuffer}.ensureCapacity(_serializedBuffer, len, false);");
            codeBuilder.last().appendln("        final int newCapacity = _serializedBuffer.getCapacity();");
            codeBuilder.last().appendln("        if (newCapacity > oldCapacity) {");
            codeBuilder.last().appendln("            if (oldBuffer != null) _memoryStats.onEntityDataDisposed(" + entity.getFullName() + ".class, MemoryStats.EntityType." + AdmXbuf2Generator.getMemoryStatsEntityType(entity) + ", oldCapacity, true);");
            codeBuilder.last().appendln("            _memoryStats.onEntityDataAllocated(" + entity.getFullName() + ".class, MemoryStats.EntityType." + AdmXbuf2Generator.getMemoryStatsEntityType(entity) + ", newCapacity);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        return _serializedBuffer;");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    final public boolean hasSerializedBuffer() {");
            codeBuilder.last().appendln("        return _serializedBuffer != null;");
            codeBuilder.last().appendln("    }");
            if (!entity.isEmbedded()) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    final public %{com.neeve.quark.QuarkBuffer} getSerializedBuffer() {");
            codeBuilder.last().appendln("        return _serializedBuffer;");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    @Deprecated");
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    final public %{com.neeve.quark.QuarkBuffer} getBackingBuffer() {");
            codeBuilder.last().appendln("        return getSerializedBuffer();");
            codeBuilder.last().appendln("    }");
        } else {
            codeBuilder.last().appendln("    final private long serializedBuffer(final int len) {");
            codeBuilder.last().appendln("        final long oldBuffer = _serializedBuffer;");
            codeBuilder.last().appendln("        final int oldCapacity = _serializedBufferCapacity;");
            codeBuilder.last().appendln("        final int newCapacity = Math.max(len, 4);");
            codeBuilder.last().appendln("        _serializedBuffer = %{com.neeve.quark.QuarkBuffer}.ensureMemoryBlockCapacity(_serializedBuffer, _serializedBufferCapacity, newCapacity, false);");
            codeBuilder.last().appendln("        if (newCapacity > oldCapacity) {");
            codeBuilder.last().appendln("            if (oldBuffer != 0l) _memoryStats.onEntityDataDisposed(" + entity.getFullName() + ".class, MemoryStats.EntityType." + AdmXbuf2Generator.getMemoryStatsEntityType(entity) + ", oldCapacity, true);");
            codeBuilder.last().appendln("            _memoryStats.onEntityDataAllocated(" + entity.getFullName() + ".class, MemoryStats.EntityType." + AdmXbuf2Generator.getMemoryStatsEntityType(entity) + ", newCapacity);");
            codeBuilder.last().appendln("            _serializedBufferCapacity = newCapacity;");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        return _serializedBuffer;");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    final public boolean hasSerializedBuffer() {");
            codeBuilder.last().appendln("        return _serializedBuffer != 0l;");
            codeBuilder.last().appendln("    }");
            if (!entity.isEmbedded()) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    final public long getSerializedBuffer() {");
            codeBuilder.last().appendln("        return _serializedBuffer;");
            codeBuilder.last().appendln("    }");
            if (!entity.isEmbedded()) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    final public int getSerializedBufferCapacity() {");
            codeBuilder.last().appendln("        return _serializedBufferCapacity;");
            codeBuilder.last().appendln("    }");
        }
        codeBuilder.last().appendln("    final void setSerializedBufferLength(final int val) {");
        codeBuilder.last().appendln("        _serializedBufferLength = val;");
        codeBuilder.last().appendln("    }");
        if (!entity.isEmbedded()) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    final public int getSerializedBufferLength() {");
        codeBuilder.last().appendln("        return _serializedBufferLength;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    @Deprecated");
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    final public int getSerializeToNativeLength() {");
        codeBuilder.last().appendln("        return getSerializedBufferLength();");
        codeBuilder.last().appendln("    }");
    }

    private final void writeSerializerAccessorMethod(AdmEntity entity, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    final public Serializer serializer(final int length, final boolean autoResizeTargetBuffer) {");
        codeBuilder.last().appendln("        if (_serializer == null) {");
        codeBuilder.last().appendln("            _serializer = Serializer.create();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        serializedBuffer(length);");
        codeBuilder.last().appendln("        if (autoResizeTargetBuffer) _serializer.setSizer(this);");
        codeBuilder.last().appendln("        return _serializer.init(this);");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    final public Serializer serializer(final int minimumLength) {");
        codeBuilder.last().appendln("        return serializer(minimumLength, true);");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    final public Serializer serializer() {");
        codeBuilder.last().appendln("        return serializer(1024, true);");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public long ensureCapacity(final long addr, final int capacity) {");
        if (this.useIOBufferAsBackingStorage(entity)) {
            codeBuilder.last().appendln("        if (capacity <= _serializedBufferLength) return addr;");
            codeBuilder.last().appendln("        final int newLength = capacity <= _serializedBuffer.getCapacity() ? capacity : Math.max(capacity, _serializedBuffer.getCapacity() * 2);");
            codeBuilder.last().appendln("        return (_serializedBuffer = %{com.neeve.quark.QuarkBuffer}.ensureCapacity(_serializedBuffer, newLength, true)).getNativeAddress();");
        } else {
            codeBuilder.last().appendln("        if (capacity <= _serializedBufferLength) return addr;");
            codeBuilder.last().appendln("        final int newLength = capacity <= _serializedBufferCapacity ? capacity : Math.max(capacity, _serializedBufferCapacity * 2);");
            codeBuilder.last().appendln("        _serializedBuffer = %{com.neeve.quark.QuarkBuffer}.ensureMemoryBlockCapacity(_serializedBuffer, _serializedBufferLength, newLength, false);");
            codeBuilder.last().appendln("        _serializedBufferCapacity = newLength;");
            codeBuilder.last().appendln("        return _serializedBuffer;");
        }
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializerAccessorMethods(AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    final public Deserializer deserializer(final boolean createBuffer) {");
        codeBuilder.last().appendln("        if (!hasSerializedBuffer() && createBuffer) {");
        codeBuilder.last().appendln("            serializedBuffer(0);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        if (!hasSerializedBuffer()) {");
        codeBuilder.last().appendln("            throw new IllegalStateException(\"no backing serialized buffer\");");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        if (_deserializer == null) {");
        codeBuilder.last().appendln("            _deserializer = Deserializer.create();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        return _deserializer.init(_serializedBuffer, 0, _serializedBufferLength);");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    final public Deserializer deserializer() {");
        codeBuilder.last().appendln("        return deserializer(false);");
        codeBuilder.last().appendln("    }");
    }

    private final void writePojoAccessorMethods(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    final public boolean hasPojo() {");
        codeBuilder.last().appendln("        return _pojo != null && _pojo.isInitialized();");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    final public boolean hasDirtyPojo() {");
        codeBuilder.last().appendln("        return hasPojo() && _pojo.isDirty();");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    final public Pojo pojo() {");
        codeBuilder.last().appendln("        if (_pojo == null) {");
        if (!((AdmEntity)type).isEmbedded()) {
            codeBuilder.last().appendln("            if (%{com.neeve.ci.XRuntime}.optimizeMemoryUsage()) {");
            codeBuilder.last().appendln("                recordAsDirty();");
            codeBuilder.last().appendln("            }");
        }
        codeBuilder.last().appendln("            _pojo = Pojo.create();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        if (!_pojo.isInitialized()) {");
        codeBuilder.last().appendln("            if (hasSerializedBuffer()) {");
        codeBuilder.last().appendln("                _pojo.deserialize(deserializer());");
        codeBuilder.last().appendln("                _pojo.clearDirty();");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            else {");
        codeBuilder.last().appendln("                _pojo.setInitialized();");
        codeBuilder.last().appendln("            }");
        if (((AdmEntity)type).isEmbedded()) {
            codeBuilder.last().appendln("            if (readOnly) {");
        } else {
            codeBuilder.last().appendln("            if (super.readOnly) {");
        }
        codeBuilder.last().appendln("                _pojo.setAsReadOnly();");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        return _pojo;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeBufferSerializerDeserializerPojoAccessorMethods(AdmEntity entity, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- Buffer, serializer, deserializer, Pojo accessor methods -----");
        this.writeBufferAccessorMethods(entity, codeBuilder);
        this.writeSerializerAccessorMethod(entity, codeBuilder);
        this.writeDeserializerAccessorMethods(codeBuilder);
        this.writePojoAccessorMethods(entity, codeBuilder);
        codeBuilder.last().appendln("    // ----- Buffer, serializer, deserializer, Pojo accessor methods -----");
    }

    private final void writeBufferDisposerMethod(AdmEntity entity, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        if (this.useIOBufferAsBackingStorage(entity)) {
            codeBuilder.last().appendln("    final public void disposeSerializedBuffer() {");
            codeBuilder.last().appendln("        if (_serializedBuffer != null) {");
            codeBuilder.last().appendln("            final int capacity = _serializedBuffer.getCapacity();");
            codeBuilder.last().appendln("            _serializedBuffer.dispose();");
            codeBuilder.last().appendln("            _memoryStats.onEntityDataDisposed(" + entity.getFullName() + ".class, MemoryStats.EntityType." + AdmXbuf2Generator.getMemoryStatsEntityType(entity) + ", capacity, true);");
            codeBuilder.last().appendln("            _serializedBuffer = null;");
            codeBuilder.last().appendln("            _serializedBufferLength = 0;");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
        } else {
            codeBuilder.last().appendln("    final public void disposeSerializedBuffer(final boolean gcDisposed) {");
            codeBuilder.last().appendln("        if (hasSerializedBuffer()) {");
            codeBuilder.last().appendln("            %{com.neeve.quark.QuarkBuffer}.freeMemoryBlock(_serializedBuffer, _serializedBufferCapacity);");
            codeBuilder.last().appendln("            _memoryStats.onEntityDataDisposed(" + entity.getFullName() + ".class, MemoryStats.EntityType." + AdmXbuf2Generator.getMemoryStatsEntityType(entity) + ", _serializedBufferCapacity, !gcDisposed);");
            codeBuilder.last().appendln("            _serializedBuffer = 0l;");
            codeBuilder.last().appendln("            _serializedBufferLength = 0;");
            codeBuilder.last().appendln("            _serializedBufferCapacity = 0;");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    final public void disposeSerializedBuffer() {");
            codeBuilder.last().appendln("        disposeSerializedBuffer(false);");
            codeBuilder.last().appendln("    }");
        }
    }

    private final void writeSerializerDisposerMethod(AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    final public void disposeSerializer() {");
        codeBuilder.last().appendln("        if (_serializer != null) {");
        codeBuilder.last().appendln("            _serializer.dispose();");
        codeBuilder.last().appendln("            _serializer = null;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializerDisposerMethod(AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    final public void disposeDeserializer() {");
        codeBuilder.last().appendln("        if (_deserializer != null) {");
        codeBuilder.last().appendln("            _deserializer.dispose();");
        codeBuilder.last().appendln("            _deserializer = null;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
    }

    private final void writePojoDisposerMethods(AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    final public void disposePojo(final boolean sync) {");
        codeBuilder.last().appendln("        if (sync) sync();");
        codeBuilder.last().appendln("        if (_pojo != null) {");
        codeBuilder.last().appendln("            _pojo.dispose();");
        codeBuilder.last().appendln("            _pojo = null;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    final public void disposePojo() {");
        codeBuilder.last().appendln("        disposePojo(false);");
        codeBuilder.last().appendln("    }");
    }

    private final void writeConserveMemoryMethod(AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    final private void conserveMemory() {");
        codeBuilder.last().appendln("        sync();");
        codeBuilder.last().appendln("        disposeSerializer();");
        codeBuilder.last().appendln("        disposeDeserializer();");
        codeBuilder.last().appendln("        disposePojo(false);");
        codeBuilder.last().appendln("    }");
    }

    private final void writeClearerMethods(AdmEntity entity, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    final public void clear(final boolean disposeMembers) {");
        codeBuilder.last().appendln("        if (_pojo != null) {");
        codeBuilder.last().appendln("            if (disposeMembers) {");
        codeBuilder.last().appendln("                disposePojo(false);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            else {");
        codeBuilder.last().appendln("                _pojo.reset();");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        if (disposeMembers) {");
        codeBuilder.last().appendln("            disposeSerializedBuffer();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        else {");
        codeBuilder.last().appendln("            _serializedBufferLength = 0;");
        codeBuilder.last().appendln("        }");
        Iterator<AdmCollection.Type> typeIterator = entity.containedInSet().iterator();
        block3: while (typeIterator.hasNext()) {
            switch (typeIterator.next()) {
                case StringMap: {
                    codeBuilder.last().appendln("        clearQuarkStringMapKey();");
                    continue block3;
                }
            }
        }
        codeBuilder.last().appendln("        readOnly = false;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    final public void clear() {");
        codeBuilder.last().appendln("        clear(false);");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    @Deprecated");
        codeBuilder.last().appendln("    final public void clearContent() {");
        codeBuilder.last().appendln("        clear();");
        codeBuilder.last().appendln("    }");
    }

    private final void writeResetMethods(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    final public void reset(final boolean disposeMembers) {");
        codeBuilder.last().appendln("        clear(disposeMembers);");
        codeBuilder.last().appendln("        if (disposeMembers) {");
        codeBuilder.last().appendln("            disposeSerializer();");
        codeBuilder.last().appendln("            disposeDeserializer();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    final public void reset() {");
        codeBuilder.last().appendln("        reset(%{com.neeve.ci.XRuntime}.optimizeMemoryUsage());");
        codeBuilder.last().appendln("    }");
    }

    private final void writeContentClearerAndMemoryConservationMethods(AdmEntity entity, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- Content clearer and memory conservation methods -----");
        this.writeBufferDisposerMethod(entity, codeBuilder);
        this.writeSerializerDisposerMethod(codeBuilder);
        this.writeDeserializerDisposerMethod(codeBuilder);
        this.writePojoDisposerMethods(codeBuilder);
        this.writeConserveMemoryMethod(codeBuilder);
        this.writeClearerMethods(entity, codeBuilder);
        this.writeResetMethods(entity, codeBuilder);
        codeBuilder.last().appendln("    // ----- Content clearer and memory convervation methods -----");
    }

    private final void writeSerializeToRawJsonMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    final public String serializeToRawJson() {");
        codeBuilder.last().appendln("        final java.io.ByteArrayOutputStream baos = new java.io.ByteArrayOutputStream();");
        codeBuilder.last().appendln("        try {");
        codeBuilder.last().appendln("            " + type.getFactory().getName() + ".mapper.writeValue(baos, this);");
        codeBuilder.last().appendln("            return new String(baos.toByteArray(), \"utf-8\");");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        catch (Exception e) {");
        codeBuilder.last().appendln("            if (e instanceof RuntimeException) {");
        codeBuilder.last().appendln("                throw (RuntimeException)e;");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            else {");
        codeBuilder.last().appendln("                throw new RuntimeException(e);");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
    }

    private final void writeSerializeToSerializerMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    final public int serializeTo(final Serializer serializer) {");
        codeBuilder.last().appendln("        sync();");
        codeBuilder.last().appendln("        if (hasSerializedBuffer()) {");
        if (this.useIOBufferAsBackingStorage((AdmEntity)type)) {
            codeBuilder.last().appendln("            serializer.putFrom(_serializedBuffer, 0, _serializedBufferLength);");
        } else {
            codeBuilder.last().appendln("            serializer.putFrom(_serializedBuffer, 0, _serializedBufferLength);");
        }
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        return _serializedBufferLength;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeSerializeToQuarkBufferMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    final public int serializeTo(final %{com.neeve.quark.QuarkBuffer} buffer, final int offset) {");
        codeBuilder.last().appendln("        sync();");
        codeBuilder.last().appendln("        if (_serializedBufferLength > (buffer.getLength() - offset)) throw new IllegalArgumentException(\"buffer too small\");");
        codeBuilder.last().appendln("        if (hasSerializedBuffer()) {");
        if (this.useIOBufferAsBackingStorage((AdmEntity)type)) {
            codeBuilder.last().appendln("            _serializedBuffer.getTo(0, buffer, offset, _serializedBufferLength);");
        } else {
            codeBuilder.last().appendln("            %{com.neeve.quark.QuarkBuffer}.copy(_serializedBuffer, 0, buffer.getNativeAddress(), offset, _serializedBufferLength);");
        }
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        return _serializedBufferLength;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeSyncMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        if (!((AdmEntity)type).isEmbedded()) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    final public void sync() {");
        codeBuilder.last().appendln("        if (!hasDirtyPojo()) {return;}");
        codeBuilder.last().appendln("            _serializedBufferLength = _pojo.serialize(serializer(_pojo.getSerializedLength(), false));");
        codeBuilder.last().appendln("            _pojo.clearDirty();");
        codeBuilder.last().appendln("        }");
    }

    private final void writeSerializeToByteArrayMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        if (!((AdmEntity)type).isEmbedded()) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    final public byte[] serializeToByteArray() {");
        codeBuilder.last().appendln("        sync();");
        codeBuilder.last().appendln("        final byte[] array = new byte[_serializedBufferLength];");
        codeBuilder.last().appendln("        serializeTo(array, 0);");
        codeBuilder.last().appendln("        return array;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeSerializeToByteArrayMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        if (!((AdmEntity)type).isEmbedded()) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    final public int serializeTo(final byte[] array, final int offset) {");
        codeBuilder.last().appendln("        sync();");
        codeBuilder.last().appendln("        if (_serializedBufferLength > (array.length - offset)) throw new IllegalArgumentException(\"array too small\");");
        codeBuilder.last().appendln("        if (hasSerializedBuffer()) {");
        if (this.useIOBufferAsBackingStorage((AdmEntity)type)) {
            codeBuilder.last().appendln("            _serializedBuffer.getTo(0, array, offset, _serializedBufferLength);");
        } else {
            codeBuilder.last().appendln("            %{com.neeve.quark.QuarkBuffer}.getTo(_serializedBuffer, 0, array, offset, _serializedBufferLength);");
        }
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        return _serializedBufferLength;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeSerializeToByteBufferMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        if (!((AdmEntity)type).isEmbedded()) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    final public %{java.nio.ByteBuffer} serializeToByteBuffer() {");
        codeBuilder.last().appendln("        sync();");
        codeBuilder.last().appendln("        final %{java.nio.ByteBuffer} buffer = %{java.nio.ByteBuffer}.allocate(_serializedBufferLength);");
        codeBuilder.last().appendln("        serializeTo(buffer);");
        codeBuilder.last().appendln("        return buffer;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeSerializeToByteBufferMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        if (!((AdmEntity)type).isEmbedded()) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    final public int serializeTo(final %{java.nio.ByteBuffer} buffer) {");
        codeBuilder.last().appendln("        sync();");
        codeBuilder.last().appendln("        if (_serializedBufferLength > (buffer.capacity() - buffer.position())) throw new IllegalArgumentException(\"buffer too small\");");
        codeBuilder.last().appendln("        buffer.limit(buffer.position() + _serializedBufferLength);");
        codeBuilder.last().appendln("        if (hasSerializedBuffer()) {");
        if (this.useIOBufferAsBackingStorage((AdmEntity)type)) {
            codeBuilder.last().appendln("            _serializedBuffer.getTo(0, buffer, _serializedBufferLength);");
        } else {
            codeBuilder.last().appendln("            %{com.neeve.quark.QuarkBuffer}.getTo(_serializedBuffer, 0, buffer, _serializedBufferLength);");
        }
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        return _serializedBufferLength;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeSerializeToIOBufferMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        if (!((AdmEntity)type).isEmbedded()) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    final public %{com.neeve.io.IOBuffer} serializeToIOBuffer(final boolean useNative) {");
        codeBuilder.last().appendln("        sync();");
        codeBuilder.last().appendln("        final %{com.neeve.io.IOBuffer} buffer = %{com.neeve.io.IOBuffer}.create(_serializedBufferLength, useNative);");
        codeBuilder.last().appendln("        serializeTo(buffer, 0);");
        codeBuilder.last().appendln("        return buffer;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeSerializeToIOBufferMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        if (!((AdmEntity)type).isEmbedded()) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    final public int serializeTo(final %{com.neeve.io.IOBuffer} buffer, final int offset) {");
        codeBuilder.last().appendln("        sync();");
        codeBuilder.last().appendln("        final %{java.nio.ByteBuffer} bytebuf = buffer.takeBuffer();");
        codeBuilder.last().appendln("        try {");
        codeBuilder.last().appendln("            bytebuf.limit(bytebuf.capacity());");
        codeBuilder.last().appendln("            bytebuf.position(offset);");
        codeBuilder.last().appendln("            return serializeTo(bytebuf);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        finally {");
        codeBuilder.last().appendln("            buffer.releaseBuffer();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        }");
    }

    private final void writeSerializeToIOElasticBufferMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        if (!((AdmEntity)type).isEmbedded()) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    final public int serializeTo(final %{com.neeve.io.IOElasticBuffer} buffer, final int offset) {");
        codeBuilder.last().appendln("        sync();");
        codeBuilder.last().appendln("        buffer.setLength(offset + _serializedBufferLength);");
        codeBuilder.last().appendln("        return serializeTo(buffer.getIOBuffer(), buffer.getOffset() + offset);");
        codeBuilder.last().appendln("    }");
    }

    private final void writeSerializeToPacketMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        if (!((AdmEntity)type).isEmbedded()) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    final public %{com.neeve.pkt.PktPacket} serializeToPacket() {");
        if (type.getModel().getBooleanDirective("serializeToDataPacket")) {
            codeBuilder.last().appendln("        final PktPacket packet = %{com.neeve.pkt.PktFactory}.getInstance().createPacket(%{com.neeve.pkt.types.PktBodyTypesBase}.DATA);");
        } else {
            codeBuilder.last().appendln("        final PktPacket packet = %{com.neeve.pkt.PktFactory}.getInstance().createPacket(" + ((AdmEntity)type).getFactory().getName() + ".PKTID_" + type.getName() + ");");
        }
        codeBuilder.last().appendln("        serializeTo(packet);");
        codeBuilder.last().appendln("        return packet;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeSerializeToPacketMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        if (!((AdmEntity)type).isEmbedded()) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    final public int serializeTo(final %{com.neeve.pkt.PktPacket} packet) {");
        codeBuilder.last().appendln("        sync();");
        codeBuilder.last().appendln("        if (hasSerializedBuffer()) {");
        if (this.useIOBufferAsBackingStorage((AdmEntity)type)) {
            codeBuilder.last().appendln("            packet.getBody().deserialize(_serializedBuffer, 0, _serializedBufferLength);");
        } else {
            codeBuilder.last().appendln("            packet.getBody().deserialize(_serializedBuffer, 0, _serializedBufferLength);");
        }
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        return _serializedBufferLength;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeSerializeToNativeMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        if (!((AdmEntity)type).isEmbedded()) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    final public int serializeTo(final long addr, final int offset) {");
        codeBuilder.last().appendln("        sync();");
        codeBuilder.last().appendln("        if (hasSerializedBuffer()) {");
        if (this.useIOBufferAsBackingStorage((AdmEntity)type)) {
            codeBuilder.last().appendln("            _serializedBuffer.getTo(0, addr, offset, _serializedBufferLength);");
        } else {
            codeBuilder.last().appendln("            %{com.neeve.quark.QuarkBuffer}.copy(_serializedBuffer, 0, addr, offset, _serializedBufferLength);");
        }
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        return _serializedBufferLength;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    @Deprecated");
        codeBuilder.last().appendln("    final public int serializeToNative(final long addr, final int offset) {");
        codeBuilder.last().appendln("        return serializeTo(addr, offset);");
        codeBuilder.last().appendln("    }");
    }

    private final void writeSerializeToJsonMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        if (!((AdmEntity)type).isEmbedded()) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    final public String serializeToJson() {");
        codeBuilder.last().appendln("        return serializeToRawJson();");
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeFromRawJsonMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserializeFromRawJson(final String json) {");
        codeBuilder.last().appendln("        try {");
        codeBuilder.last().appendln("            " + type.getFactory().getName() + ".mapper.reader().withValueToUpdate(this).readValue(json);");
        codeBuilder.last().appendln("            return this;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        catch (Exception e) {");
        codeBuilder.last().appendln("            throw new RuntimeException(e);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeFromDeserializerMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserializeFrom(final Deserializer deserializer) {");
        codeBuilder.last().appendln("        if (!deserializer.isInitialized()) {");
        codeBuilder.last().appendln("            throw new IllegalArgumentException(\"can only deserialize from an initialized deserializer\");");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        if (_pojo != null) {");
        codeBuilder.last().appendln("            _pojo.reset();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        _serializedBufferLength = 0;");
        codeBuilder.last().appendln("        if (deserializer != null) deserializer.getTo(serializedBuffer(_serializedBufferLength = deserializer.getSerializedLength()), 0);");
        codeBuilder.last().appendln("        return this;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeFromEntityMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserializeFrom(final " + type.getTemplatedJavaTypeName() + " val) {");
        codeBuilder.last().appendln("        return deserializeFrom(val.getSerializedBuffer(), 0, val.getSerializedBufferLength());");
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeFromQuarkBufferMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserializeFrom(final %{com.neeve.quark.QuarkBuffer} buffer, final int offset, final int len) {");
        codeBuilder.last().appendln("        if (_pojo != null) {");
        codeBuilder.last().appendln("            _pojo.reset();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        _serializedBufferLength = buffer != null ? len : 0;");
        codeBuilder.last().appendln("        if (buffer != null) {");
        if (this.useIOBufferAsBackingStorage((AdmEntity)type)) {
            codeBuilder.last().appendln("            serializedBuffer(len).putFrom(0, buffer, offset, len);");
        } else {
            codeBuilder.last().appendln("            %{com.neeve.quark.QuarkBuffer}.copy(buffer.getNativeAddress(), offset, serializedBuffer(len), 0, len);");
        }
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        return this;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeWrapMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " wrap(final %{com.neeve.quark.QuarkBuffer} buffer, final int len) {");
        codeBuilder.last().appendln("        if (_pojo != null) {");
        codeBuilder.last().appendln("            _pojo.reset();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        disposeSerializedBuffer();");
        if (this.useIOBufferAsBackingStorage((AdmEntity)type)) {
            codeBuilder.last().appendln("        _serializedBuffer = buffer;");
        } else {
            codeBuilder.last().appendln("        _serializedBuffer = buffer.getNativeAddress();");
        }
        codeBuilder.last().appendln("        _serializedBufferLength = len;");
        codeBuilder.last().appendln("        return this;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeFromByteArrayMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        if (!((AdmEntity)type).isEmbedded()) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserializeFromByteArray(final byte[] array) {");
        codeBuilder.last().appendln("        return deserializeFrom(array, 0, array.length);");
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeFromByteArrayMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        if (!((AdmEntity)type).isEmbedded()) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserializeFrom(final byte[] array, final int offset, final int len) {");
        codeBuilder.last().appendln("        if (_pojo != null) {");
        codeBuilder.last().appendln("            _pojo.reset();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        _serializedBufferLength = array != null ? len : 0;");
        codeBuilder.last().appendln("        if (array != null) {");
        if (this.useIOBufferAsBackingStorage((AdmEntity)type)) {
            codeBuilder.last().appendln("            serializedBuffer(len).putFrom(0, array, offset, len);");
        } else {
            codeBuilder.last().appendln("            %{com.neeve.quark.QuarkBuffer}.putFrom(serializedBuffer(len), 0, array, offset, len);");
        }
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        return this;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeFromByteBufferMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        if (!((AdmEntity)type).isEmbedded()) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserializeFromByteBuffer(final %{java.nio.ByteBuffer} buffer) {");
        codeBuilder.last().appendln("        return deserializeFrom(buffer);");
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeFromByteBufferMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        if (!((AdmEntity)type).isEmbedded()) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserializeFrom(final %{java.nio.ByteBuffer} buffer) {");
        codeBuilder.last().appendln("        if (_pojo != null) {");
        codeBuilder.last().appendln("            _pojo.reset();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        _serializedBufferLength = buffer != null ? buffer.remaining() : 0;");
        codeBuilder.last().appendln("        if (buffer != null) {");
        if (this.useIOBufferAsBackingStorage((AdmEntity)type)) {
            codeBuilder.last().appendln("            serializedBuffer(_serializedBufferLength).putFrom(0, buffer);");
        } else {
            codeBuilder.last().appendln("            %{com.neeve.quark.QuarkBuffer}.putFrom(serializedBuffer(_serializedBufferLength), 0, buffer);");
        }
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        return this;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeFromIOBufferMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        if (!((AdmEntity)type).isEmbedded()) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserializeFrom(final %{com.neeve.io.IOBuffer} buffer, final int offset, final int len) {");
        codeBuilder.last().appendln("        if (buffer == null) return deserializeFrom((ByteBuffer)null);");
        codeBuilder.last().appendln("        final %{java.nio.ByteBuffer} bytebuf = buffer.takeBuffer();");
        codeBuilder.last().appendln("        try {");
        codeBuilder.last().appendln("            bytebuf.limit(offset + len).position(offset);");
        codeBuilder.last().appendln("            return deserializeFrom(bytebuf);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        finally {");
        codeBuilder.last().appendln("            buffer.releaseBuffer();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeFromIOElasticBufferMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        if (!((AdmEntity)type).isEmbedded()) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserializeFrom(final %{com.neeve.io.IOElasticBuffer} buffer, final int offset, final int len) {");
        codeBuilder.last().appendln("        return deserializeFrom(buffer.getIOBuffer(), buffer.getOffset() + offset, len);");
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeFromPacketMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        if (!((AdmEntity)type).isEmbedded()) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserializeFromPacket(final %{com.neeve.pkt.PktPacket} packet) {");
        codeBuilder.last().appendln("        return deserializeFrom(packet);");
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeFromPacketMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        if (!((AdmEntity)type).isEmbedded()) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserializeFrom(final %{com.neeve.pkt.PktPacket} packet) {");
        codeBuilder.last().appendln("        try {");
        codeBuilder.last().appendln("            final %{com.neeve.io.IOElasticBuffer} buffer = packet.getBody().getBuffer();");
        codeBuilder.last().appendln("            return deserializeFrom(buffer, 0, buffer.getLength());");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        catch (Exception e) {");
        codeBuilder.last().appendln("            throw new RuntimeException(e);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        finally {");
        codeBuilder.last().appendln("            packet.dispose();");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeFromNativeMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        if (!((AdmEntity)type).isEmbedded()) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserializeFrom(final long addr, final int offset, final int len) {");
        codeBuilder.last().appendln("        if (_pojo != null) {");
        codeBuilder.last().appendln("            _pojo.reset();");
        codeBuilder.last().appendln("        }");
        if (this.useIOBufferAsBackingStorage((AdmEntity)type)) {
            codeBuilder.last().appendln("        serializedBuffer(_serializedBufferLength = len).putFrom(0, addr, offset, len);");
        } else {
            codeBuilder.last().appendln("        _serializedBufferLength = len;");
            codeBuilder.last().appendln("        %{com.neeve.quark.QuarkBuffer}.copy(addr, offset, serializedBuffer(len), 0, len);");
        }
        codeBuilder.last().appendln("        return this;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    @Deprecated");
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserializeFromNative(final long addr, final int offset, final int len) {");
        codeBuilder.last().appendln("        return deserializeFrom(addr, offset, len);");
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeFromJsonMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        if (!((AdmEntity)type).isEmbedded()) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserializeFromJson(final String json) {");
        codeBuilder.last().appendln("        deserializeFromRawJson(json);");
        codeBuilder.last().appendln("        return this;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeCopyIntoMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    final public void copyInto(final " + type.getTemplatedJavaTypeName() + " copy) {");
        codeBuilder.last().appendln("        copy.clear();");
        codeBuilder.last().appendln("        sync();");
        codeBuilder.last().appendln("        copy.deserializeFrom(_serializedBuffer, 0, _serializedBufferLength);");
        codeBuilder.last().appendln("    }");
    }

    private final void writeCopyMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        if (type instanceof AdmMessage) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " copy() {");
        codeBuilder.last().appendln("        final " + type.getTemplatedJavaTypeName() + " copy = " + type.getTemplatedJavaTypeName() + ".create();");
        codeBuilder.last().appendln("        copyInto(copy);");
        codeBuilder.last().appendln("        return copy;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeCoreSerializationDeserializationMethods(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- Core serialization/deserialization methods -----");
        this.writeSerializeToRawJsonMethod(type, codeBuilder);
        this.writeSerializeToSerializerMethod(type, codeBuilder);
        this.writeSerializeToQuarkBufferMethod(type, codeBuilder);
        if (((AdmEntity)type).isEmbedded()) {
            this.writeSyncMethod(type, codeBuilder);
            this.writeSerializeToByteArrayMethod((AdmScopedType)type, codeBuilder);
            this.writeSerializeToByteArrayMethod(type, codeBuilder);
            this.writeSerializeToByteBufferMethod((AdmScopedType)type, codeBuilder);
            this.writeSerializeToByteBufferMethod(type, codeBuilder);
            this.writeSerializeToIOBufferMethod((AdmScopedType)type, codeBuilder);
            this.writeSerializeToIOBufferMethod(type, codeBuilder);
            this.writeSerializeToIOElasticBufferMethod(type, codeBuilder);
            this.writeSerializeToPacketMethod((AdmScopedType)type, codeBuilder);
            this.writeSerializeToPacketMethod(type, codeBuilder);
            this.writeSerializeToNativeMethod(type, codeBuilder);
            this.writeSerializeToJsonMethod(type, codeBuilder);
        }
        this.writeDeserializeFromRawJsonMethod(type, codeBuilder);
        this.writeDeserializeFromDeserializerMethod(type, codeBuilder);
        this.writeDeserializeFromEntityMethod(type, codeBuilder);
        this.writeDeserializeFromQuarkBufferMethod(type, codeBuilder);
        this.writeWrapMethod(type, codeBuilder);
        if (((AdmEntity)type).isEmbedded()) {
            this.writeDeserializeFromByteArrayMethod((AdmScopedType)type, codeBuilder);
            this.writeDeserializeFromByteArrayMethod(type, codeBuilder);
            this.writeDeserializeFromByteBufferMethod((AdmScopedType)type, codeBuilder);
            this.writeDeserializeFromByteBufferMethod(type, codeBuilder);
            this.writeDeserializeFromIOBufferMethod(type, codeBuilder);
            this.writeDeserializeFromIOElasticBufferMethod(type, codeBuilder);
            this.writeDeserializeFromPacketMethod((AdmScopedType)type, codeBuilder);
            this.writeDeserializeFromPacketMethod(type, codeBuilder);
            this.writeDeserializeFromNativeMethod(type, codeBuilder);
            this.writeDeserializeFromJsonMethod(type, codeBuilder);
        }
        this.writeCopyIntoMethod(type, codeBuilder);
        if (((AdmEntity)type).isEmbedded()) {
            this.writeCopyMethod(type, codeBuilder);
        }
        codeBuilder.last().appendln("    // ----- Core serialization/deserialization methods -----");
    }

    private final void writeIsPooledMethod(AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final protected boolean isPooled() {");
        codeBuilder.last().appendln("        return false;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeMessageViewSerializerMethods(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- MessageView methods -----");
        this.writeSyncMethod(type, codeBuilder);
        this.writeSerializeToByteArrayMethod((AdmScopedType)type, codeBuilder);
        this.writeSerializeToByteArrayMethod(type, codeBuilder);
        this.writeSerializeToByteBufferMethod((AdmScopedType)type, codeBuilder);
        this.writeSerializeToByteBufferMethod(type, codeBuilder);
        this.writeSerializeToIOBufferMethod((AdmScopedType)type, codeBuilder);
        this.writeSerializeToIOBufferMethod(type, codeBuilder);
        this.writeSerializeToIOElasticBufferMethod(type, codeBuilder);
        this.writeSerializeToPacketMethod((AdmScopedType)type, codeBuilder);
        this.writeSerializeToPacketMethod(type, codeBuilder);
        this.writeSerializeToNativeMethod(type, codeBuilder);
        this.writeSerializeToJsonMethod(type, codeBuilder);
        this.writeDeserializeFromByteArrayMethod((AdmScopedType)type, codeBuilder);
        this.writeDeserializeFromByteArrayMethod(type, codeBuilder);
        this.writeDeserializeFromByteBufferMethod((AdmScopedType)type, codeBuilder);
        this.writeDeserializeFromByteBufferMethod(type, codeBuilder);
        this.writeDeserializeFromIOBufferMethod(type, codeBuilder);
        this.writeDeserializeFromIOElasticBufferMethod(type, codeBuilder);
        this.writeDeserializeFromPacketMethod((AdmScopedType)type, codeBuilder);
        this.writeDeserializeFromPacketMethod(type, codeBuilder);
        this.writeDeserializeFromNativeMethod(type, codeBuilder);
        this.writeDeserializeFromJsonMethod(type, codeBuilder);
        this.writeIsPooledMethod(codeBuilder);
        if (type instanceof AdmMessage) {
            this.writeCopyMethod((AdmMessage)type, codeBuilder);
        }
        codeBuilder.last().appendln("    // ----- MessageView methods -----");
    }

    private final void writeDelegatedKeyAccessorMethods(AdmCollection collection, AdmSourceCodeBuilder codeBuilder) {
        switch (collection.getType()) {
            case List: 
            case Queue: {
                break;
            }
            case CharMap: 
            case ByteMap: 
            case ShortMap: 
            case IntMap: 
            case LongMap: 
            case FloatMap: 
            case DoubleMap: 
            case StringMap: {
                AdmType keyType = collection.getKeyType();
                AdmEntity valueType = collection.getContains();
                AdmField keyField = this.keyFieldFor(collection);
                if (keyField == null) {
                    throw new IllegalStateException("No key field of type '" + keyType.getName() + "' in entity '" + valueType.getQualifiedName(collection.getModel()) + "' which is declared as value of " + (Object)((Object)collection.getType()) + " collection '" + collection.getName() + "'");
                }
                String keyJavaType = "%{" + keyType.getJavaTypeName() + "}";
                AdmPrimitive primitiveKeyType = null;
                if (keyType instanceof AdmPrimitive) {
                    primitiveKeyType = (AdmPrimitive)keyType;
                    switch (primitiveKeyType.getType()) {
                        case Long: {
                            keyJavaType = "long";
                            break;
                        }
                        case Boolean: {
                            keyJavaType = "boolean";
                            break;
                        }
                        case Byte: {
                            keyJavaType = "byte";
                            break;
                        }
                        case Char: {
                            keyJavaType = "char";
                            break;
                        }
                        case Double: {
                            keyJavaType = "double";
                            break;
                        }
                        case Float: {
                            keyJavaType = "float";
                            break;
                        }
                        case Integer: {
                            keyJavaType = "int";
                            break;
                        }
                        case Short: {
                            keyJavaType = "short";
                            break;
                        }
                        case Date: 
                        case Currency: 
                        case UUID: {
                            keyJavaType = "%{" + keyType.getJavaTypeName() + "}";
                        }
                    }
                }
                codeBuilder.last().appendln("    // ----- Delegated Key Accessor Methods -----");
                if (primitiveKeyType == null || primitiveKeyType.getType() != AdmPrimitive.Type.String) {
                    codeBuilder.last().appendln("    @Override");
                    codeBuilder.last().appendln("    final protected " + keyJavaType + " getMapElementKey(final %{" + valueType.getFullName() + "} value) {");
                    codeBuilder.last().appendln("        return value." + AdmXbuf2Generator.fieldGetterMethodName(keyField) + "();");
                    codeBuilder.last().appendln("    }");
                    codeBuilder.last().appendln("");
                    codeBuilder.last().appendln("    @Override");
                    codeBuilder.last().appendln("    final protected void setMapElementKey(final %{" + valueType.getFullName() + "} value, final " + keyJavaType + " key) {");
                    codeBuilder.last().appendln("        value." + AdmXbuf2Generator.fieldSetterMethodName(keyField) + "(key);");
                    codeBuilder.last().appendln("    }");
                }
                codeBuilder.last().appendln("    // ----- Delegated Key Accessor Methods -----");
                break;
            }
        }
    }

    private final void writeGetContentEncodingMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public EncodingType getContentEncodingType() {");
        codeBuilder.last().appendln("        return EncodingType.Xbuf2;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeSerializeMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public %{com.neeve.pkt.PktPacket} serialize() {");
        if (type instanceof AdmCollection) {
            codeBuilder.last().appendln("        return serializeForStoreCommit();");
        } else {
            codeBuilder.last().appendln("        return serializeToPacket();");
        }
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserialize(final %{com.neeve.pkt.PktPacket} packet) {");
        if (type instanceof AdmCollection) {
            codeBuilder.last().appendln("        deserializeFromStoreReplicationOrInit(packet);");
            codeBuilder.last().appendln("        return this;");
        } else {
            codeBuilder.last().appendln("        return deserializeFromPacket(packet);");
        }
        codeBuilder.last().appendln("    }");
    }

    private final void writeSetFieldValueMethod(AdmType type, List<AdmField> fields, boolean transactional, AdmSourceCodeBuilder codeBuilder) {
        if (!type.isDeprecated() && transactional && this.getDeprecatedFieldCount(type, fields, false, false) > 0) {
            codeBuilder.last().appendln("    @SuppressWarnings(\"deprecation\")");
        }
        codeBuilder.last().appendln("    final public %{com.neeve.ods.IStoreObject} setFieldValue(final int id, final Object val) {");
        if (transactional) {
            codeBuilder.last().appendln("        boolean processed = false;");
            for (AdmField field : fields) {
                AdmType fieldType = field.getType();
                if (fieldType instanceof AdmPrimitive) {
                    codeBuilder.last().appendln("        if (!processed && id == " + AdmXbuf2Generator.fieldFidVarName(field) + ") {");
                    codeBuilder.last().appendln("            processed = true;");
                    codeBuilder.last().appendln("        }");
                    continue;
                }
                if (fieldType instanceof AdmPrimitiveArray) {
                    codeBuilder.last().appendln("        if (!processed && id == " + AdmXbuf2Generator.fieldFidVarName(field) + ") {");
                    switch (((AdmPrimitiveArray)fieldType).getType()) {
                        case Byte: 
                        case Char: 
                        case Short: 
                        case Integer: 
                        case Long: 
                        case Float: 
                        case Double: 
                        case Boolean: {
                            break;
                        }
                        case Date: 
                        case String: 
                        case Currency: {
                            break;
                        }
                        case UUID: {
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported primitive array type '" + (Object)((Object)((AdmPrimitiveArray)fieldType).getType()) + "'");
                        }
                    }
                    codeBuilder.last().appendln("            processed = true;");
                    codeBuilder.last().appendln("        }");
                    continue;
                }
                if (fieldType instanceof AdmEntity && ((AdmEntity)fieldType).isEmbedded()) {
                    codeBuilder.last().appendln("        if (!processed && id == " + AdmXbuf2Generator.fieldFidVarName(field) + ") {");
                    codeBuilder.last().appendln("            processed = true;");
                    codeBuilder.last().appendln("        }");
                    continue;
                }
                if (fieldType instanceof AdmEntityArray) {
                    codeBuilder.last().appendln("        if (!processed && id == " + AdmXbuf2Generator.fieldFidVarName(field) + ") {");
                    codeBuilder.last().appendln("            processed = true;");
                    codeBuilder.last().appendln("        }");
                    continue;
                }
                if (fieldType instanceof AdmEnumeration) {
                    codeBuilder.last().appendln("        if (!processed && id == " + AdmXbuf2Generator.fieldFidVarName(field) + ") {");
                    codeBuilder.last().appendln("            processed = true;");
                    codeBuilder.last().appendln("        }");
                    continue;
                }
                if (!(fieldType instanceof AdmEnumerationArray)) continue;
                codeBuilder.last().appendln("        if (!processed && id == " + AdmXbuf2Generator.fieldFidVarName(field) + ") {");
                codeBuilder.last().appendln("            processed = true;");
                codeBuilder.last().appendln("        }");
            }
            codeBuilder.last().appendln("        if (!processed) {");
            codeBuilder.last().appendln("            super.setFieldValue(id, val);");
            codeBuilder.last().appendln("        }");
        } else {
            codeBuilder.last().appendln("        // this method will never be called since this class was generated as a non-transactional entity");
        }
        codeBuilder.last().appendln("        return this;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeImplementedIStoreObjectMethods(AdmFactoryType type, List<AdmField> fields, boolean transactional, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- IStoreObject methods -----");
        this.writeGetContentEncodingMethod(type, codeBuilder);
        this.writeSerializeMethod(type, codeBuilder);
        this.writeDeserializeMethod(type, codeBuilder);
        if (!(type instanceof AdmCollection)) {
            this.writeSetFieldValueMethod(type, fields, transactional, codeBuilder);
        }
        codeBuilder.last().appendln("    // ----- IStoreObject methods -----");
    }

    private final void writeSerializeToProtobufMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public com.google.protobuf.Message serializeToProtobuf() {");
        codeBuilder.last().appendln("        throw new UnsupportedOperationException();");
        codeBuilder.last().appendln("    }");
    }

    private final void writeDeserializeFromProtobufMethod(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public " + type.getTemplatedJavaTypeName() + " deserializeFromProtobuf(final com.google.protobuf.Message message) {");
        codeBuilder.last().appendln("        throw new UnsupportedOperationException();");
        codeBuilder.last().appendln("    }");
    }

    private final void writeImplementedIRogNodeMethods(AdmFactoryType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- IRogNode methods -----");
        this.writeSerializeToProtobufMethod(type, codeBuilder);
        this.writeDeserializeFromProtobufMethod(type, codeBuilder);
        codeBuilder.last().appendln("    // ----- IRogNode methods -----");
    }

    private final void writeGetLastFidMethod(AdmSourceCodeBuilder codeBuilder, String last_fid) {
        if (last_fid != null) {
            codeBuilder.last().appendln("    @Override");
            codeBuilder.last().appendln("    final protected int getLastFid() {");
            codeBuilder.last().appendln("        return " + last_fid + ";");
            codeBuilder.last().appendln("    }");
        }
    }

    private final void writeSetAsReadOnlyMethod(AdmScopedType type, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        if (!((AdmEntity)type).isEmbedded()) {
            codeBuilder.last().appendln("    @Override");
        } else {
            codeBuilder.last().appendln("    // ----- Read only method -----");
        }
        codeBuilder.last().appendln("    final public void setAsReadOnly() {");
        if (!((AdmEntity)type).isEmbedded()) {
            codeBuilder.last().appendln("        super.setAsReadOnly();");
        } else {
            codeBuilder.last().appendln("        readOnly = true;");
        }
        codeBuilder.last().appendln("        if (_pojo != null) {");
        codeBuilder.last().appendln("            _pojo.setAsReadOnly();");
        codeBuilder.last().appendln("        }");
        if (((AdmEntity)type).isEmbedded()) {
            codeBuilder.last().appendln("    // ----- Read only method -----");
        }
        codeBuilder.last().appendln("    }");
    }

    private final void writeSaveMemoryMethod(AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public void saveMemory() {");
        codeBuilder.last().appendln("        conserveMemory();");
        codeBuilder.last().appendln("    }");
    }

    private final void writeDisposeMethod(AdmEntity entity, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    public int dispose() {");
        codeBuilder.last().appendln("        final int count = super.dispose();");
        codeBuilder.last().appendln("        if (count < 0 && _pool != null) {");
        codeBuilder.last().appendln("            throw new IllegalStateException(\"attempt to dispose an already disposed entity\");");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        if (count == 0 && _pool != null) {");
        codeBuilder.last().appendln("            _pool.put(this);");
        codeBuilder.last().appendln("            _memoryStats.onEntityDisposed(" + entity.getFullName() + ".class, MemoryStats.EntityType." + AdmXbuf2Generator.getMemoryStatsEntityType(entity) + ", true);");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        return count;");
        codeBuilder.last().appendln("    }");
    }

    private final void writeUndisposeMethod(AdmEntity entity, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    public void undispose(final %{com.eaio.uuid.UUID} id) {");
        codeBuilder.last().appendln("        super.undispose(id);");
        codeBuilder.last().appendln("        _memoryStats.onEntityAllocated(" + entity.getFullName() + ".class, MemoryStats.EntityType." + AdmXbuf2Generator.getMemoryStatsEntityType(entity) + ", true);");
        codeBuilder.last().appendln("    }");
    }

    private final void writeOverridenRogNodeMethods(AdmEntity type, AdmSourceCodeBuilder codeBuilder, String last_fid) {
        codeBuilder.last().appendln("    // ----- RogNode methods -----");
        this.writeGetLastFidMethod(codeBuilder, last_fid);
        this.writeSetAsReadOnlyMethod(type, codeBuilder);
        this.writeSaveMemoryMethod(codeBuilder);
        this.writeDisposeMethod(type, codeBuilder);
        this.writeUndisposeMethod(type, codeBuilder);
        codeBuilder.last().appendln("    // ----- RogNode methods -----");
    }

    private final void writeUserPrimitiveFieldMethods(AdmEntity entity, AdmField field, AdmSourceCodeBuilder codeBuilder) {
        String rawType;
        AdmPrimitive fieldType = (AdmPrimitive)field.getType();
        AdmPrimitive.Type primitiveType = fieldType.getType();
        String javaPrimitive = fieldType.getTemplatedPrimitiveTypeName();
        boolean hasInterface = (!entity.isEmbedded() || entity.getGenerateEmbeddedEntityInterfaces()) && !field.getName().startsWith("xRog");
        String finalModifier = AdmXbuf2Generator.fieldAccessorFinalModifier(entity);
        codeBuilder.newCodeSegment();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonSetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbuf2Generator.fieldSetterMethodName(field) + "(final " + javaPrimitive + " val) {");
        if (!entity.isEmbedded() && entity.isTransactional()) {
            this.writeReadOnlyValidator(entity, codeBuilder);
            codeBuilder.last().appendln("        recordFieldUpdate(" + AdmXbuf2Generator.fieldIdxFieldVarName(field) + ", " + AdmXbuf2Generator.fieldGetterMethodName(field) + "(), val);");
        }
        switch (primitiveType) {
            case Byte: 
            case Char: 
            case Short: 
            case Integer: 
            case Long: 
            case Float: 
            case Double: 
            case Boolean: {
                codeBuilder.last().appendln("        pojo()." + AdmXbuf2Generator.fieldSetterMethodName(field) + "(val);");
                break;
            }
            case Date: {
                codeBuilder.last().appendln("        if (val != null) {");
                codeBuilder.last().appendln("           pojo()." + AdmXbuf2Generator.fieldSetterMethodName(field) + "(val.getTime());");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        else {");
                codeBuilder.last().appendln("           pojo()." + AdmXbuf2Generator.fieldClearerMethodName(field) + "();");
                codeBuilder.last().appendln("        }");
                break;
            }
            case String: 
            case Currency: 
            case UUID: {
                codeBuilder.last().appendln("        pojo()." + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(val);");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown primitive field type ['" + (Object)((Object)primitiveType) + "]");
            }
        }
        codeBuilder.last().appendln("    }");
        switch (primitiveType) {
            case Byte: 
            case Char: 
            case Short: 
            case Integer: 
            case Long: 
            case Float: 
            case Double: 
            case Boolean: {
                codeBuilder.newCodeSegment();
                codeBuilder.last().appendln();
                this.writeDeprecationComment("    ", field, codeBuilder);
                if (hasInterface) {
                    codeBuilder.last().appendln("    @Override");
                }
                codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
                codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbuf2Generator.fieldSetterMethodName(field) + "AsObject(" + primitiveType.getJavaTypeName() + " val) {");
                codeBuilder.last().appendln("        if (val == null) {");
                codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldClearerMethodName(field) + "();");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        else {");
                codeBuilder.last().appendln("            " + AdmXbuf2Generator.fieldSetterMethodName(field) + "(val);");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("    }");
                break;
            }
        }
        this.writeFieldFluentMethods(entity, field, codeBuilder);
        codeBuilder.newCodeSegment();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        switch (primitiveType) {
            case Byte: 
            case Char: 
            case Short: 
            case Integer: 
            case Long: 
            case Float: 
            case Double: 
            case Boolean: {
                codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
                break;
            }
            case Date: 
            case String: 
            case Currency: 
            case UUID: {
                this.writeJsonGetterAnnotations(field, codeBuilder);
                break;
            }
        }
        codeBuilder.last().appendln("    " + finalModifier + "public " + javaPrimitive + " " + AdmXbuf2Generator.fieldGetterMethodName(field) + "() {");
        switch (primitiveType) {
            case Byte: 
            case Char: 
            case Short: 
            case Integer: 
            case Long: 
            case Float: 
            case Double: 
            case Boolean: {
                codeBuilder.last().appendln("        return pojo()." + AdmXbuf2Generator.fieldGetterMethodName(field) + "();");
                break;
            }
            case Date: {
                codeBuilder.last().appendln("        return pojo()." + AdmXbuf2Generator.fieldCheckerMethodName(field) + "() ? new Date(pojo()." + AdmXbuf2Generator.fieldGetterMethodName(field) + "()) : null;");
                break;
            }
            case String: {
                codeBuilder.last().appendln("        if (!" + AdmXbuf2Generator.fieldCheckerMethodName(field) + "()) {");
                codeBuilder.last().appendln("            return null;");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        return pojo()." + AdmXbuf2Generator.fieldValueVarName(field) + ".getValue();");
                break;
            }
            case Currency: 
            case UUID: {
                codeBuilder.last().appendln("        return null;");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown primitive field type ['" + (Object)((Object)primitiveType) + "]");
            }
        }
        codeBuilder.last().appendln("    }");
        switch (primitiveType) {
            case Byte: 
            case Char: 
            case Short: 
            case Integer: 
            case Long: 
            case Float: 
            case Double: 
            case Boolean: {
                codeBuilder.newCodeSegment();
                this.writeDeprecationComment("    ", field, codeBuilder);
                if (hasInterface) {
                    codeBuilder.last().appendln("    @Override");
                }
                this.writeJsonGetterAnnotations(field, codeBuilder);
                codeBuilder.last().appendln("    " + finalModifier + "public " + primitiveType.getJavaTypeName() + " " + AdmXbuf2Generator.fieldGetterMethodName(field) + "AsObject() {");
                codeBuilder.last().appendln("        if (!" + AdmXbuf2Generator.fieldCheckerMethodName(field) + "()) return null;");
                codeBuilder.last().appendln("        return " + AdmXbuf2Generator.fieldGetterMethodName(field) + "();");
                codeBuilder.last().appendln("    }");
                break;
            }
        }
        if (primitiveType == AdmPrimitive.Type.Date) {
            codeBuilder.newCodeSegment();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbuf2Generator.fieldSetterAsTimestampMethodName(field) + "(final long val) {");
            if (!entity.isEmbedded() && entity.isTransactional()) {
                this.writeReadOnlyValidator(entity, codeBuilder);
                codeBuilder.last().appendln("        final long existing = " + AdmXbuf2Generator.fieldGetterAsTimestampMethodName(field) + "();");
                codeBuilder.last().appendln("        if (val != existing) {");
                codeBuilder.last().appendln("            recordFieldUpdate(" + AdmXbuf2Generator.fieldIdxFieldVarName(field) + ", " + AdmXbuf2Generator.fieldGetterMethodName(field) + "(), val >= 0l ? new Date(val) : null);");
                codeBuilder.last().appendln("        }");
            }
            codeBuilder.last().appendln("        pojo()." + AdmXbuf2Generator.fieldSetterMethodName(field) + "(val);");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public long " + AdmXbuf2Generator.fieldGetterAsTimestampMethodName(field) + "() {");
            codeBuilder.last().appendln("        return pojo()." + AdmXbuf2Generator.fieldGetterMethodName(field) + "();");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public Long " + AdmXbuf2Generator.fieldGetterMethodName(field) + "AsTimestampObject() {");
            codeBuilder.last().appendln("        if (!" + AdmXbuf2Generator.fieldCheckerMethodName(field) + "()) return null;");
            codeBuilder.last().appendln("        return " + AdmXbuf2Generator.fieldGetterMethodName(field) + "AsTimestamp();");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbuf2Generator.fieldSetterAsInstantMethodName(field) + "(final %{java.time.Instant} val) {");
            if (!entity.isEmbedded() && entity.isTransactional()) {
                this.writeReadOnlyValidator(entity, codeBuilder);
                codeBuilder.last().appendln("        final %{java.time.Instant} existing = " + AdmXbuf2Generator.fieldGetterAsInstantMethodName(field) + "();");
                codeBuilder.last().appendln("        if (val != existing) {");
                codeBuilder.last().appendln("            recordFieldUpdate(" + AdmXbuf2Generator.fieldIdxFieldVarName(field) + ", " + AdmXbuf2Generator.fieldGetterMethodName(field) + "(), val != null ? new Date(val.toEpochMilli()) : null);");
                codeBuilder.last().appendln("        }");
            }
            codeBuilder.last().appendln("        if (val != null) {");
            codeBuilder.last().appendln("           " + AdmXbuf2Generator.fieldSetterAsTimestampMethodName(field) + "(val.toEpochMilli());");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        else {");
            codeBuilder.last().appendln("           " + AdmXbuf2Generator.fieldClearerMethodName(field) + "();");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public %{java.time.Instant} " + AdmXbuf2Generator.fieldGetterAsInstantMethodName(field) + "() {");
            codeBuilder.last().appendln("        if (!" + AdmXbuf2Generator.fieldCheckerMethodName(field) + "()) return null;");
            codeBuilder.last().appendln("        return %{java.time.Instant}.ofEpochMilli(" + AdmXbuf2Generator.fieldGetterAsTimestampMethodName(field) + "());");
            codeBuilder.last().appendln("    }");
        }
        if (primitiveType == AdmPrimitive.Type.String) {
            rawType = "%{" + primitiveType.getRawValueType() + "}";
            codeBuilder.newCodeSegment();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbuf2Generator.fieldLenderMethodName(field) + "(final %{com.neeve.lang.XString} val) {");
            codeBuilder.last().appendln("        if (val == null || !val.isInitialized() || val.isNull()) {" + AdmXbuf2Generator.fieldSetterMethodName(field) + "((String)null); return;}");
            codeBuilder.last().appendln("        if (!val.isImmutable()) {throw new IllegalArgumentException(\"value is mutable\");}");
            if (!entity.isEmbedded() && entity.isTransactional()) {
                this.writeReadOnlyValidator(entity, codeBuilder);
                codeBuilder.last().appendln("        recordFieldUpdate(" + AdmXbuf2Generator.fieldIdxFieldVarName(field) + ", " + AdmXbuf2Generator.fieldGetterMethodName(field) + "(), val != null ? val.getValue() : null);");
            }
            codeBuilder.last().appendln("        pojo()." + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(val);");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(final long val) {");
            if (!entity.isEmbedded() && entity.isTransactional()) {
                this.writeReadOnlyValidator(entity, codeBuilder);
                codeBuilder.last().appendln("        recordFieldUpdate(" + AdmXbuf2Generator.fieldIdxFieldVarName(field) + ", " + AdmXbuf2Generator.fieldGetterMethodName(field) + "(), String.valueOf(val));");
            }
            codeBuilder.last().appendln("        pojo()." + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(val);");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public <T extends %{com.neeve.lang.XString}> T " + AdmXbuf2Generator.fieldGetterToMethodName(field) + "(final %{com.neeve.lang.XString}.Factory<T> factory) {");
            codeBuilder.last().appendln("        final T to = factory.create(false);");
            codeBuilder.last().appendln("        pojo()." + AdmXbuf2Generator.fieldGetterToMethodName(field) + "(to);");
            codeBuilder.last().appendln("        return to;");
            codeBuilder.last().appendln("    }");
        }
        if (primitiveType.hasRawValue()) {
            rawType = "%{" + primitiveType.getRawValueType() + "}";
            codeBuilder.newCodeSegment();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(final " + rawType + " val) {");
            if (!entity.isEmbedded() && entity.isTransactional()) {
                this.writeReadOnlyValidator(entity, codeBuilder);
                codeBuilder.last().appendln("        recordFieldUpdate(" + AdmXbuf2Generator.fieldIdxFieldVarName(field) + ", " + AdmXbuf2Generator.fieldGetterMethodName(field) + "(), val != null ? val.getValue() : null);");
            }
            codeBuilder.last().appendln("        pojo()." + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(val);");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbuf2Generator.fieldGetterToMethodName(field) + "(final " + rawType + " val) {");
            codeBuilder.last().appendln("        pojo()." + AdmXbuf2Generator.fieldGetterToMethodName(field) + "(val);");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public " + rawType + " " + AdmXbuf2Generator.fieldGetterUnsafeMethodName(field) + "() {");
            if (primitiveType == AdmPrimitive.Type.String) {
                codeBuilder.last().appendln("        return pojo()." + AdmXbuf2Generator.fieldGetterMethodName(field) + "();");
            } else {
                codeBuilder.last().appendln("        return null;");
            }
            codeBuilder.last().appendln("    }");
        }
        this.writeOptionalGetterMethods(entity, field, codeBuilder);
        codeBuilder.newCodeSegment();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public boolean " + AdmXbuf2Generator.fieldCheckerMethodName(field) + "() {");
        switch (primitiveType) {
            case Byte: 
            case Char: 
            case Short: 
            case Integer: 
            case Long: 
            case Float: 
            case Double: 
            case Boolean: 
            case Date: 
            case String: 
            case Currency: 
            case UUID: {
                codeBuilder.last().appendln("        return pojo()." + AdmXbuf2Generator.fieldCheckerMethodName(field) + "();");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown primitive field type ['" + (Object)((Object)primitiveType) + "]");
            }
        }
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbuf2Generator.fieldClearerMethodName(field) + "() {");
        switch (primitiveType) {
            case Byte: 
            case Char: 
            case Short: 
            case Integer: 
            case Long: 
            case Float: 
            case Double: 
            case Boolean: 
            case Date: 
            case String: 
            case Currency: 
            case UUID: {
                codeBuilder.last().appendln("        pojo()." + AdmXbuf2Generator.fieldClearerMethodName(field) + "();");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown primitive field type ['" + (Object)((Object)primitiveType) + "]");
            }
        }
        codeBuilder.last().appendln("    }");
    }

    private final void writeUserPrimitiveArrayFieldMethods(AdmEntity entity, AdmField field, boolean generateArrayGetterEmptyIfNull, AdmSourceCodeBuilder codeBuilder) {
        AdmPrimitiveArray fieldType = (AdmPrimitiveArray)field.getType();
        String javaPrimitive = fieldType.getType().getTemplatedPrimitiveTypeName();
        String iteratorType = fieldType.getType().getTemplatedXIteratorType();
        String zgIteratorType = fieldType.getType().getTemplatedZGXIteratorType();
        boolean hasInterface = !entity.isEmbedded() || entity.getGenerateEmbeddedEntityInterfaces();
        boolean componentTypeIsNullable = ((AdmPrimitive)fieldType.getComponentType()).isNullable();
        String finalModifier = AdmXbuf2Generator.fieldAccessorFinalModifier(entity);
        codeBuilder.newCodeSegment();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonSetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbuf2Generator.fieldSetterMethodName(field) + "(final " + javaPrimitive + "[] val) {");
        if (!entity.isEmbedded() && entity.isTransactional()) {
            this.writeReadOnlyValidator(entity, codeBuilder);
            codeBuilder.last().appendln("        recordFieldUpdate(" + AdmXbuf2Generator.fieldFidVarName(field) + ", " + AdmXbuf2Generator.fieldGetterMethodName(field) + "());");
        }
        if (componentTypeIsNullable) {
            codeBuilder.last().appendln("        pojo()." + AdmXbuf2Generator.fieldClearerMethodName(field) + "();");
            codeBuilder.last().appendln("        if (val != null) {");
            codeBuilder.last().appendln("            for (int i = 0; i < val.length; i++) {");
            codeBuilder.last().appendln("                if (val[i] != null) {");
            codeBuilder.last().appendln("                    pojo()." + AdmXbuf2Generator.fieldAdderToMethodName(field) + "(val[i]);");
            codeBuilder.last().appendln("                }");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
        } else {
            codeBuilder.last().appendln("        pojo()." + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(val, 0, val == null ? 0 : val.length);");
        }
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbuf2Generator.fieldSetterMethodName(field) + "From(final " + iteratorType + " val) {");
        if (!entity.isEmbedded() && entity.isTransactional()) {
            this.writeReadOnlyValidator(entity, codeBuilder);
            codeBuilder.last().appendln("        recordFieldUpdate(" + AdmXbuf2Generator.fieldFidVarName(field) + ", " + AdmXbuf2Generator.fieldGetterMethodName(field) + "());");
        }
        if (componentTypeIsNullable) {
            codeBuilder.last().appendln("        pojo()." + AdmXbuf2Generator.fieldClearerMethodName(field) + "();");
            codeBuilder.last().appendln("        if (val != null && val.toFirst().hasNext()) {");
            codeBuilder.last().appendln("            while(val.hasNext()) {");
            codeBuilder.last().appendln("                final " + javaPrimitive + " v = val.next();");
            codeBuilder.last().appendln("                if (v != null) {");
            codeBuilder.last().appendln("                    pojo()." + AdmXbuf2Generator.fieldAdderToMethodName(field) + "(v);");
            codeBuilder.last().appendln("                }");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
        } else {
            codeBuilder.last().appendln("        pojo()." + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(val);");
        }
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbuf2Generator.fieldAdderMethodName(field) + "(final " + javaPrimitive + " val) {");
        if (componentTypeIsNullable && entity.getNullEntityArrayElementPolicy() == AdmEntity.NullArrayElementPolicy.Throw) {
            codeBuilder.last().appendln("        if (val == null) {");
            codeBuilder.last().appendln("            throw new NullPointerException(\"Can't set array field with a null value.\");");
            codeBuilder.last().appendln("        }");
        }
        if (!entity.isEmbedded() && entity.isTransactional()) {
            this.writeReadOnlyValidator(entity, codeBuilder);
            codeBuilder.last().appendln("        recordFieldUpdate(" + AdmXbuf2Generator.fieldFidVarName(field) + ", " + AdmXbuf2Generator.fieldGetterMethodName(field) + "());");
        }
        codeBuilder.last().appendln("        pojo()." + AdmXbuf2Generator.fieldAdderToMethodName(field) + "(val);");
        codeBuilder.last().appendln("    }");
        this.writeFieldFluentMethods(entity, field, codeBuilder);
        codeBuilder.newCodeSegment();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonGetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public " + javaPrimitive + "[] " + AdmXbuf2Generator.fieldGetterMethodName(field) + "() {");
        if (generateArrayGetterEmptyIfNull) {
            codeBuilder.last().appendln("        return " + AdmXbuf2Generator.fieldGetterMethodName(field) + "EmptyIfNull();");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    final private " + javaPrimitive + "[] " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Core() {");
        }
        switch (fieldType.getType()) {
            case Byte: 
            case Char: 
            case Short: 
            case Integer: 
            case Long: 
            case Float: 
            case Double: 
            case Boolean: 
            case Date: {
                codeBuilder.last().appendln("        final int count = pojo()." + AdmXbuf2Generator.fieldGetterMethodName(field) + "Count();");
                codeBuilder.last().appendln("        if (count > 0) {");
                codeBuilder.last().appendln("            final " + javaPrimitive + "[] val = new " + javaPrimitive + "[count];");
                codeBuilder.last().appendln("            pojo()." + AdmXbuf2Generator.fieldGetterToMethodName(field) + "(val, 0);");
                codeBuilder.last().appendln("            return val;");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        else {");
                codeBuilder.last().appendln("            return null;");
                codeBuilder.last().appendln("        }");
                break;
            }
            case String: {
                codeBuilder.last().appendln("        final %{com.neeve.quark.QuarkStringIterator} iterator = pojo()." + AdmXbuf2Generator.fieldGetterMethodName(field) + "Iterator();");
                codeBuilder.last().appendln("        final %{java.util.ArrayList}<String> list = new ArrayList<String>();");
                codeBuilder.last().appendln("        while (iterator.hasNext()) {");
                codeBuilder.last().appendln("            list.add(iterator.next());");
                codeBuilder.last().appendln("        }");
                codeBuilder.last().appendln("        return list.size() > 0 ? list.<String>toArray(new String[list.size()]) : null;");
                break;
            }
            case Currency: {
                codeBuilder.last().appendln("        return null;");
                break;
            }
            case UUID: {
                codeBuilder.last().appendln("        return null;");
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported primitive array type '" + (Object)((Object)fieldType.getType()) + "'");
            }
        }
        codeBuilder.last().appendln("    }");
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public " + javaPrimitive + "[] " + AdmXbuf2Generator.fieldGetterMethodName(field) + "EmptyIfNull() {");
        if (generateArrayGetterEmptyIfNull) {
            codeBuilder.last().appendln("        final " + javaPrimitive + "[] val = " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Core();");
        } else {
            codeBuilder.last().appendln("        final " + javaPrimitive + "[] val = " + AdmXbuf2Generator.fieldGetterMethodName(field) + "();");
        }
        switch (fieldType.getType()) {
            case Byte: {
                codeBuilder.last().appendln("        return val != null ? val : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_BYTE_ARRAY;");
                break;
            }
            case Char: {
                codeBuilder.last().appendln("        return val != null ? val : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_CHAR_ARRAY;");
                break;
            }
            case Short: {
                codeBuilder.last().appendln("        return val != null ? val : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_SHORT_ARRAY;");
                break;
            }
            case Integer: {
                codeBuilder.last().appendln("        return val != null ? val : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_INT_ARRAY;");
                break;
            }
            case Long: {
                codeBuilder.last().appendln("        return val != null ? val : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_LONG_ARRAY;");
                break;
            }
            case Float: {
                codeBuilder.last().appendln("        return val != null ? val : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_FLOAT_ARRAY;");
                break;
            }
            case Double: {
                codeBuilder.last().appendln("        return val != null ? val : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_DOUBLE_ARRAY;");
                break;
            }
            case Boolean: {
                codeBuilder.last().appendln("        return val != null ? val : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_BOOLEAN_ARRAY;");
                break;
            }
            case Date: {
                codeBuilder.last().appendln("        return val != null ? val : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_DATE_ARRAY;");
                break;
            }
            case String: {
                codeBuilder.last().appendln("        return val != null ? val : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_STRING_ARRAY;");
                break;
            }
            case Currency: {
                codeBuilder.last().appendln("        return val != null ? val : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_CURRENCY_ARRAY;");
                break;
            }
            case UUID: {
                codeBuilder.last().appendln("        return val != null ? val : %{com.neeve.adm.runtime.AdmRuntime}.EMPTY_UUID_ARRAY;");
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported primitive array type '" + (Object)((Object)fieldType.getType()) + "'");
            }
        }
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public " + zgIteratorType + " " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Iterator() {");
        codeBuilder.last().appendln("        return pojo()." + AdmXbuf2Generator.fieldGetterMethodName(field) + "Iterator();");
        codeBuilder.last().appendln("    }");
        this.writeOptionalGetterMethods(entity, field, codeBuilder);
        codeBuilder.newCodeSegment();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbuf2Generator.fieldClearerMethodName(field) + "() {");
        codeBuilder.last().appendln("        pojo()." + AdmXbuf2Generator.fieldClearerMethodName(field) + "();");
        codeBuilder.last().appendln("    }");
    }

    private final void writeUserEntityArrayFieldMethods(AdmEntity entity, AdmField field, boolean generatArrayFieldsEmptyIfNull, AdmSourceCodeBuilder codeBuilder) {
        AdmEntityArray fieldType = (AdmEntityArray)field.getType();
        boolean hasInterface = !entity.isEmbedded() || entity.getGenerateEmbeddedEntityInterfaces();
        String finalModifier = AdmXbuf2Generator.fieldAccessorFinalModifier(entity);
        codeBuilder.newCodeSegment();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonSetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbuf2Generator.fieldSetterMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " val) {");
        if (entity.getNullEntityArrayElementPolicy() == AdmEntity.NullArrayElementPolicy.Throw) {
            codeBuilder.last().appendln("        if (val != null) {");
            codeBuilder.last().appendln("            for (int i = 0; i < val.length; i++) {");
            codeBuilder.last().appendln("                if (val[i] == null) {");
            codeBuilder.last().appendln("                    throw new NullPointerException(\"Can't set array field with a null value at index '\" + i + \"'\");");
            codeBuilder.last().appendln("                }");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
        }
        if (!entity.isEmbedded() && entity.isTransactional()) {
            this.writeReadOnlyValidator(entity, codeBuilder);
            codeBuilder.last().appendln("        recordFieldUpdate(" + AdmXbuf2Generator.fieldFidVarName(field) + ", " + AdmXbuf2Generator.fieldGetterMethodName(field) + "());");
        }
        codeBuilder.last().appendln("        pojo()." + AdmXbuf2Generator.fieldClearerMethodName(field) + "();");
        codeBuilder.last().appendln("        if (val != null) {");
        codeBuilder.last().appendln("            for (int i = 0; i < val.length; i++) {");
        codeBuilder.last().appendln("                if (val[i] != null) {");
        codeBuilder.last().appendln("                    pojo()." + AdmXbuf2Generator.fieldAdderToMethodName(field) + "(val[i]);");
        codeBuilder.last().appendln("                }");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbuf2Generator.fieldLenderMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " val) {");
        if (entity.getNullEntityArrayElementPolicy() == AdmEntity.NullArrayElementPolicy.Throw) {
            codeBuilder.last().appendln("        if (val != null) {");
            codeBuilder.last().appendln("            for (int i = 0; i < val.length; i++) {");
            codeBuilder.last().appendln("                if (val[i] == null) {");
            codeBuilder.last().appendln("                    throw new NullPointerException(\"Can't set array field with a null value at index '\" + i + \"'\");");
            codeBuilder.last().appendln("                }");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
        }
        if (!entity.isEmbedded() && entity.isTransactional()) {
            this.writeReadOnlyValidator(entity, codeBuilder);
            codeBuilder.last().appendln("        recordFieldUpdate(" + AdmXbuf2Generator.fieldFidVarName(field) + ", " + AdmXbuf2Generator.fieldGetterMethodName(field) + "());");
        }
        codeBuilder.last().appendln("        pojo()." + AdmXbuf2Generator.fieldClearerMethodName(field) + "();");
        codeBuilder.last().appendln("        if (val != null) {");
        codeBuilder.last().appendln("            for (int i = 0; i < val.length; i++) {");
        codeBuilder.last().appendln("                if (val[i] != null) {");
        codeBuilder.last().appendln("                    pojo()." + AdmXbuf2Generator.fieldLenderToMethodName(field) + "(val[i]);");
        codeBuilder.last().appendln("                }");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(final %{com.neeve.lang.XIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + "> val) {");
        if (entity.getNullEntityArrayElementPolicy() == AdmEntity.NullArrayElementPolicy.Throw) {
            codeBuilder.last().appendln("        if (val != null && val.toFirst().hasNext()) {");
            codeBuilder.last().appendln("            int i = 0;");
            codeBuilder.last().appendln("            while (val.hasNext()) {");
            codeBuilder.last().appendln("                if (val.next() == null) {");
            codeBuilder.last().appendln("                    throw new NullPointerException(\"Can't set array field with a null value.\");");
            codeBuilder.last().appendln("                }");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
        }
        if (!entity.isEmbedded() && entity.isTransactional()) {
            this.writeReadOnlyValidator(entity, codeBuilder);
            codeBuilder.last().appendln("        recordFieldUpdate(" + AdmXbuf2Generator.fieldFidVarName(field) + ", " + AdmXbuf2Generator.fieldGetterMethodName(field) + "());");
        }
        codeBuilder.last().appendln("        pojo()." + AdmXbuf2Generator.fieldClearerMethodName(field) + "();");
        codeBuilder.last().appendln("        if (val != null && val.toFirst().hasNext()) {");
        codeBuilder.last().appendln("            while (val.hasNext()) {");
        codeBuilder.last().appendln("                final " + fieldType.getType().getTemplatedJavaTypeName() + " v = val.next();");
        codeBuilder.last().appendln("                if (v != null) {");
        codeBuilder.last().appendln("                    pojo()." + AdmXbuf2Generator.fieldAdderToMethodName(field) + "(v);");
        codeBuilder.last().appendln("                }");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbuf2Generator.fieldLenderMethodName(field) + "From(final %{com.neeve.lang.XIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + "> val) {");
        if (entity.getNullEntityArrayElementPolicy() == AdmEntity.NullArrayElementPolicy.Throw) {
            codeBuilder.last().appendln("        if (val != null && val.toFirst().hasNext()) {");
            codeBuilder.last().appendln("            int i = 0;");
            codeBuilder.last().appendln("            while (val.hasNext()) {");
            codeBuilder.last().appendln("                if (val.next() == null) {");
            codeBuilder.last().appendln("                    throw new NullPointerException(\"Can't set array field with a null value.\");");
            codeBuilder.last().appendln("                }");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("        }");
        }
        if (!entity.isEmbedded() && entity.isTransactional()) {
            this.writeReadOnlyValidator(entity, codeBuilder);
            codeBuilder.last().appendln("        recordFieldUpdate(" + AdmXbuf2Generator.fieldFidVarName(field) + ", " + AdmXbuf2Generator.fieldGetterMethodName(field) + "());");
        }
        codeBuilder.last().appendln("        pojo()." + AdmXbuf2Generator.fieldClearerMethodName(field) + "();");
        codeBuilder.last().appendln("        if (val != null && val.toFirst().hasNext()) {");
        codeBuilder.last().appendln("            while(val.hasNext()) {");
        codeBuilder.last().appendln("                final " + fieldType.getType().getTemplatedJavaTypeName() + " v = val.next();");
        codeBuilder.last().appendln("                if (v != null) {");
        codeBuilder.last().appendln("                    pojo()." + AdmXbuf2Generator.fieldLenderToMethodName(field) + "(v);");
        codeBuilder.last().appendln("                }");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonSetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbuf2Generator.fieldAdderMethodName(field) + "(final " + fieldType.getType().getTemplatedJavaTypeName() + " val) {");
        if (entity.getNullEntityArrayElementPolicy() == AdmEntity.NullArrayElementPolicy.Throw) {
            codeBuilder.last().appendln("        if (val == null) {");
            codeBuilder.last().appendln("            throw new NullPointerException(\"Can't set array field with a null value.\");");
            codeBuilder.last().appendln("        }");
        }
        if (!entity.isEmbedded() && entity.isTransactional()) {
            this.writeReadOnlyValidator(entity, codeBuilder);
            codeBuilder.last().appendln("        recordFieldUpdate(" + AdmXbuf2Generator.fieldFidVarName(field) + ", " + AdmXbuf2Generator.fieldGetterMethodName(field) + "());");
        }
        codeBuilder.last().appendln("        pojo()." + AdmXbuf2Generator.fieldAdderToMethodName(field) + "(val);");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonSetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbuf2Generator.fieldLenderMethodName(field) + "(final " + fieldType.getType().getTemplatedJavaTypeName() + " val) {");
        if (entity.getNullEntityArrayElementPolicy() == AdmEntity.NullArrayElementPolicy.Throw) {
            codeBuilder.last().appendln("        if (val == null) {");
            codeBuilder.last().appendln("            throw new NullPointerException(\"Can't set array field with a null value.\");");
            codeBuilder.last().appendln("        }");
        }
        if (!entity.isEmbedded() && entity.isTransactional()) {
            this.writeReadOnlyValidator(entity, codeBuilder);
            codeBuilder.last().appendln("        recordFieldUpdate(" + AdmXbuf2Generator.fieldFidVarName(field) + ", " + AdmXbuf2Generator.fieldGetterMethodName(field) + "());");
        }
        codeBuilder.last().appendln("        pojo()." + AdmXbuf2Generator.fieldLenderToMethodName(field) + "(val);");
        codeBuilder.last().appendln("    }");
        this.writeFieldFluentMethods(entity, field, codeBuilder);
        codeBuilder.newCodeSegment();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonGetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmXbuf2Generator.fieldGetterMethodName(field) + "() {");
        if (generatArrayFieldsEmptyIfNull) {
            codeBuilder.last().appendln("        return " + AdmXbuf2Generator.fieldGetterMethodName(field) + "EmptyIfNull();");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    final private " + fieldType.getTemplatedJavaTypeName() + " " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Core() {");
        }
        codeBuilder.last().appendln("        final int count = pojo()." + AdmXbuf2Generator.fieldGetterMethodName(field) + "Count();");
        codeBuilder.last().appendln("        if (count > 0) {");
        codeBuilder.last().appendln("            final " + fieldType.getTemplatedJavaTypeName() + " val = new " + fieldType.getType().getTemplatedJavaTypeName() + "[count];");
        codeBuilder.last().appendln("            final %{com.neeve.lang.XIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + "> iterator = pojo()." + AdmXbuf2Generator.fieldGetterMethodName(field) + "Iterator();");
        codeBuilder.last().appendln("            for (int i = 0 ; i < count ; i++) {");
        codeBuilder.last().appendln("                val[i] = iterator.next();");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            return val;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        else {");
        codeBuilder.last().appendln("            return null;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmXbuf2Generator.fieldGetterMethodName(field) + "EmptyIfNull() {");
        if (generatArrayFieldsEmptyIfNull) {
            codeBuilder.last().appendln("        final " + fieldType.getTemplatedJavaTypeName() + " val = " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Core();");
        } else {
            codeBuilder.last().appendln("        final " + fieldType.getTemplatedJavaTypeName() + " val = " + AdmXbuf2Generator.fieldGetterMethodName(field) + "();");
        }
        codeBuilder.last().appendln("        return val != null ? val : " + fieldType.getType().getTemplatedJavaTypeName() + ".EMPTY_ARRAY;");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public %{com.neeve.lang.XIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + "> " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Iterator() {");
        codeBuilder.last().appendln("        return pojo()." + AdmXbuf2Generator.fieldGetterMethodName(field) + "Iterator();");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmXbuf2Generator.fieldTakerMethodName(field) + "() {");
        codeBuilder.last().appendln("        final int count = pojo()." + AdmXbuf2Generator.fieldGetterMethodName(field) + "Count();");
        codeBuilder.last().appendln("        if (count > 0) {");
        codeBuilder.last().appendln("            final " + fieldType.getTemplatedJavaTypeName() + " val = new " + fieldType.getType().getTemplatedJavaTypeName() + "[count];");
        codeBuilder.last().appendln("            final %{com.neeve.lang.XIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + "> iterator = pojo()." + AdmXbuf2Generator.fieldGetterMethodName(field) + "Iterator();");
        codeBuilder.last().appendln("            for (int i = 0 ; i < count ; i++) {");
        codeBuilder.last().appendln("                (val[i] = iterator.next()).acquire();");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("            return val;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        else {");
        codeBuilder.last().appendln("            return null;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        this.writeOptionalGetterMethods(entity, field, codeBuilder);
        codeBuilder.newCodeSegment();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbuf2Generator.fieldClearerMethodName(field) + "() {");
        codeBuilder.last().appendln("        pojo()." + AdmXbuf2Generator.fieldClearerMethodName(field) + "();");
        codeBuilder.last().appendln("    }");
    }

    private final void writeUserEnumerationArrayFieldMethods(AdmEntity entity, AdmField field, boolean generateArrayGetterEmptyIfNull, AdmSourceCodeBuilder codeBuilder) {
        AdmEnumerationArray fieldType = (AdmEnumerationArray)field.getType();
        boolean hasInterface = !entity.isEmbedded() || entity.getGenerateEmbeddedEntityInterfaces();
        String finalModifier = AdmXbuf2Generator.fieldAccessorFinalModifier(entity);
        codeBuilder.newCodeSegment();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonSetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbuf2Generator.fieldSetterMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " val) {");
        if (!entity.isEmbedded() && entity.isTransactional()) {
            this.writeReadOnlyValidator(entity, codeBuilder);
            codeBuilder.last().appendln("        recordFieldUpdate(" + AdmXbuf2Generator.fieldFidVarName(field) + ", " + AdmXbuf2Generator.fieldGetterMethodName(field) + "());");
        }
        codeBuilder.last().appendln("        pojo()." + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(val, 0, val == null ? 0 : val.length);");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(final %{com.neeve.lang.XIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + "> val) {");
        if (!entity.isEmbedded() && entity.isTransactional()) {
            this.writeReadOnlyValidator(entity, codeBuilder);
            codeBuilder.last().appendln("        recordFieldUpdate(" + AdmXbuf2Generator.fieldFidVarName(field) + ", " + AdmXbuf2Generator.fieldGetterMethodName(field) + "());");
        }
        codeBuilder.last().appendln("        pojo()." + AdmXbuf2Generator.fieldSetterFromMethodName(field) + "(val);");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonSetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbuf2Generator.fieldAdderMethodName(field) + "(final " + fieldType.getType().getTemplatedJavaTypeName() + " val) {");
        if (!entity.isEmbedded() && entity.isTransactional()) {
            this.writeReadOnlyValidator(entity, codeBuilder);
            codeBuilder.last().appendln("        recordFieldUpdate(" + AdmXbuf2Generator.fieldFidVarName(field) + ", " + AdmXbuf2Generator.fieldGetterMethodName(field) + "());");
        }
        codeBuilder.last().appendln("        pojo()." + AdmXbuf2Generator.fieldAdderToMethodName(field) + "(val);");
        codeBuilder.last().appendln("    }");
        this.writeFieldFluentMethods(entity, field, codeBuilder);
        codeBuilder.newCodeSegment();
        if (field.isDeprecated()) {
            this.writeDeprecationComment("    ", field, codeBuilder);
        } else {
            codeBuilder.last().appendln("    @Deprecated");
        }
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbuf2Generator.fieldSetterMethodName(field) + "List(final %{java.util.List}<" + fieldType.getType().getTemplatedJavaTypeName() + "> val) {");
        if (!entity.isEmbedded() && entity.isTransactional()) {
            this.writeReadOnlyValidator(entity, codeBuilder);
            codeBuilder.last().appendln("        recordFieldUpdate(" + AdmXbuf2Generator.fieldFidVarName(field) + ", " + AdmXbuf2Generator.fieldGetterMethodName(field) + "());");
        }
        codeBuilder.last().appendln("        " + AdmXbuf2Generator.fieldClearerMethodName(field) + "();");
        codeBuilder.last().appendln("        if (val != null && val.size() > 0) {");
        codeBuilder.last().appendln("            for (int i = 0; i < val.size(); i++) {");
        codeBuilder.last().appendln("                pojo()." + AdmXbuf2Generator.fieldAdderToMethodName(field) + "(val.get(i));");
        codeBuilder.last().appendln("            }");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonGetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmXbuf2Generator.fieldGetterMethodName(field) + "() {");
        if (generateArrayGetterEmptyIfNull) {
            codeBuilder.last().appendln("        return " + AdmXbuf2Generator.fieldGetterMethodName(field) + "EmptyIfNull();");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    final private " + fieldType.getTemplatedJavaTypeName() + " " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Core() {");
        }
        codeBuilder.last().appendln("        final int count = pojo()." + AdmXbuf2Generator.fieldGetterMethodName(field) + "Count();");
        codeBuilder.last().appendln("        if (count > 0) {");
        codeBuilder.last().appendln("            final " + fieldType.getType().getTemplatedJavaTypeName() + "[] val = new " + fieldType.getType().getTemplatedJavaTypeName() + "[count];");
        codeBuilder.last().appendln("            pojo()." + AdmXbuf2Generator.fieldGetterToMethodName(field) + "(val, 0);");
        codeBuilder.last().appendln("            return val;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        else {");
        codeBuilder.last().appendln("            return null;");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmXbuf2Generator.fieldGetterMethodName(field) + "EmptyIfNull() {");
        if (generateArrayGetterEmptyIfNull) {
            codeBuilder.last().appendln("        final " + fieldType.getTemplatedJavaTypeName() + " val = " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Core();");
        } else {
            codeBuilder.last().appendln("        final " + fieldType.getTemplatedJavaTypeName() + " val = " + AdmXbuf2Generator.fieldGetterMethodName(field) + "();");
        }
        codeBuilder.last().appendln("        return val != null ? val : " + fieldType.getType().getTemplatedJavaTypeName() + ".EMPTY_ARRAY;");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public %{com.neeve.lang.XIndexedList}<" + fieldType.getType().getTemplatedJavaTypeName() + "> " + AdmXbuf2Generator.fieldGetterMethodName(field) + "List() {");
        codeBuilder.last().appendln("        final %{com.neeve.lang.XIndexedList}<" + fieldType.getType().getTemplatedJavaTypeName() + "> rc = new %{com.neeve.lang.XIndexedList}<" + fieldType.getType().getTemplatedJavaTypeName() + ">();");
        codeBuilder.last().appendln("        final %{com.neeve.lang.XIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + "> it = pojo()." + AdmXbuf2Generator.fieldGetterMethodName(field) + "Iterator();");
        codeBuilder.last().appendln("        while (it.hasNext()) {");
        codeBuilder.last().appendln("           rc.add(it.next());");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        return rc;");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
        codeBuilder.last().appendln("    " + finalModifier + "public %{com.neeve.lang.XIterator}<" + fieldType.getType().getTemplatedJavaTypeName() + "> " + AdmXbuf2Generator.fieldGetterMethodName(field) + "Iterator() {");
        codeBuilder.last().appendln("        return pojo()." + AdmXbuf2Generator.fieldGetterMethodName(field) + "Iterator();");
        codeBuilder.last().appendln("    }");
        this.writeOptionalGetterMethods(entity, field, codeBuilder);
        codeBuilder.newCodeSegment();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbuf2Generator.fieldClearerMethodName(field) + "() {");
        codeBuilder.last().appendln("        pojo()." + AdmXbuf2Generator.fieldClearerMethodName(field) + "();");
        codeBuilder.last().appendln("    }");
    }

    private final void writeUserEnumerationFieldMethods(AdmEntity entity, AdmField field, AdmSourceCodeBuilder codeBuilder) {
        AdmEnumeration fieldType = (AdmEnumeration)field.getType();
        boolean hasInterface = !entity.isEmbedded() || entity.getGenerateEmbeddedEntityInterfaces();
        String finalModifier = AdmXbuf2Generator.fieldAccessorFinalModifier(entity);
        codeBuilder.newCodeSegment();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonSetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbuf2Generator.fieldSetterMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " val) {");
        if (!entity.isEmbedded() && entity.isTransactional()) {
            this.writeReadOnlyValidator(entity, codeBuilder);
            codeBuilder.last().appendln("        recordFieldUpdate(" + AdmXbuf2Generator.fieldIdxFieldVarName(field) + ", " + AdmXbuf2Generator.fieldGetterMethodName(field) + "(), val);");
        }
        codeBuilder.last().appendln("        pojo()." + AdmXbuf2Generator.fieldSetterMethodName(field) + "(val);");
        codeBuilder.last().appendln("    }");
        this.writeFieldFluentMethods(entity, field, codeBuilder);
        codeBuilder.newCodeSegment();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        this.writeJsonGetterAnnotations(field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmXbuf2Generator.fieldGetterMethodName(field) + "() {");
        codeBuilder.last().appendln("        return pojo()." + AdmXbuf2Generator.fieldGetterMethodName(field) + "();");
        codeBuilder.last().appendln("    }");
        this.writeOptionalGetterMethods(entity, field, codeBuilder);
        codeBuilder.newCodeSegment();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public boolean " + AdmXbuf2Generator.fieldCheckerMethodName(field) + "() {");
        codeBuilder.last().appendln("        return pojo()." + AdmXbuf2Generator.fieldCheckerMethodName(field) + "();");
        codeBuilder.last().appendln("    }");
        codeBuilder.newCodeSegment();
        this.writeDeprecationComment("    ", field, codeBuilder);
        if (hasInterface) {
            codeBuilder.last().appendln("    @Override");
        }
        codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbuf2Generator.fieldClearerMethodName(field) + "() {");
        codeBuilder.last().appendln("        pojo()." + AdmXbuf2Generator.fieldClearerMethodName(field) + "();");
        codeBuilder.last().appendln("    }");
    }

    private final void writeUserEntityFieldMethods(AdmEntity entity, AdmField field, AdmSourceCodeBuilder codeBuilder) {
        AdmEntity fieldType = (AdmEntity)field.getType();
        boolean hasInterface = !entity.isEmbedded() || entity.getGenerateEmbeddedEntityInterfaces();
        String finalModifier = AdmXbuf2Generator.fieldAccessorFinalModifier(entity);
        if (entity.isEmbedded() || fieldType.isEmbedded()) {
            codeBuilder.newCodeSegment();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            this.writeJsonSetterAnnotations(field, codeBuilder);
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbuf2Generator.fieldSetterMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " val) {");
            if (!entity.isEmbedded() && entity.isTransactional()) {
                this.writeReadOnlyValidator(entity, codeBuilder);
                codeBuilder.last().appendln("        recordFieldUpdate(" + AdmXbuf2Generator.fieldIdxFieldVarName(field) + ", " + AdmXbuf2Generator.fieldGetterMethodName(field) + "(), val);");
            }
            codeBuilder.last().appendln("        pojo()." + AdmXbuf2Generator.fieldSetterMethodName(field) + "(val);");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbuf2Generator.fieldLenderMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " val) {");
            if (!entity.isEmbedded() && entity.isTransactional()) {
                this.writeReadOnlyValidator(entity, codeBuilder);
                codeBuilder.last().appendln("        recordFieldUpdate(" + AdmXbuf2Generator.fieldIdxFieldVarName(field) + ", " + AdmXbuf2Generator.fieldGetterMethodName(field) + "(), val);");
            }
            codeBuilder.last().appendln("        pojo()." + AdmXbuf2Generator.fieldLenderMethodName(field) + "(val);");
            codeBuilder.last().appendln("    }");
            this.writeFieldFluentMethods(entity, field, codeBuilder);
            codeBuilder.newCodeSegment();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            this.writeJsonGetterAnnotations(field, codeBuilder);
            codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmXbuf2Generator.fieldGetterMethodName(field) + "() {");
            codeBuilder.last().appendln("        return pojo()." + AdmXbuf2Generator.fieldGetterMethodName(field) + "();");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    @%{com.fasterxml.jackson.annotation.JsonIgnore}");
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbuf2Generator.fieldGetterToMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " to) {");
            codeBuilder.last().appendln("        pojo()." + AdmXbuf2Generator.fieldGetterToMethodName(field) + "(to);");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmXbuf2Generator.fieldTakerMethodName(field) + "() {");
            codeBuilder.last().appendln("        return pojo()." + AdmXbuf2Generator.fieldTakerMethodName(field) + "();");
            codeBuilder.last().appendln("    }");
            this.writeOptionalGetterMethods(entity, field, codeBuilder);
            codeBuilder.newCodeSegment();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    " + finalModifier + "public boolean " + AdmXbuf2Generator.fieldCheckerMethodName(field) + "() {");
            codeBuilder.last().appendln("        return pojo()." + AdmXbuf2Generator.fieldCheckerMethodName(field) + "();");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbuf2Generator.fieldClearerMethodName(field) + "() {");
            codeBuilder.last().appendln("        pojo()." + AdmXbuf2Generator.fieldClearerMethodName(field) + "();");
            codeBuilder.last().appendln("    }");
        } else {
            codeBuilder.newCodeSegment();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            this.writeJsonSetterAnnotations(field, codeBuilder);
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbuf2Generator.fieldSetterMethodName(field) + "(final " + fieldType.getTemplatedJavaTypeName() + " val) {");
            this.writeReadOnlyValidator(entity, codeBuilder);
            codeBuilder.last().appendln("        if (val != " + AdmXbuf2Generator.fieldGetterMethodName(field) + "()) {");
            codeBuilder.last().appendln("            setChild(" + AdmXbuf2Generator.fieldFidVarName(field) + ", val);");
            codeBuilder.last().appendln("            }");
            codeBuilder.last().appendln("    }");
            this.writeFieldFluentMethods(entity, field, codeBuilder);
            codeBuilder.newCodeSegment();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            this.writeJsonGetterAnnotations(field, codeBuilder);
            codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmXbuf2Generator.fieldGetterMethodName(field) + "() {");
            codeBuilder.last().appendln("        return (" + fieldType.getTemplatedJavaTypeName() + ")getChild(" + AdmXbuf2Generator.fieldFidVarName(field) + ");");
            codeBuilder.last().appendln("    }");
            this.writeOptionalGetterMethods(entity, field, codeBuilder);
            codeBuilder.newCodeSegment();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    " + finalModifier + "public boolean " + AdmXbuf2Generator.fieldCheckerMethodName(field) + "() {");
            codeBuilder.last().appendln("        return getChild(" + AdmXbuf2Generator.fieldFidVarName(field) + ") != null;");
            codeBuilder.last().appendln("    }");
            codeBuilder.newCodeSegment();
            this.writeDeprecationComment("    ", field, codeBuilder);
            if (hasInterface) {
                codeBuilder.last().appendln("    @Override");
            }
            codeBuilder.last().appendln("    " + finalModifier + "public void " + AdmXbuf2Generator.fieldClearerMethodName(field) + "() {");
            codeBuilder.last().appendln("        " + AdmXbuf2Generator.fieldSetterMethodName(field) + "(null);");
            codeBuilder.last().appendln("    }");
        }
    }

    private final void writeUserCollectionFieldMethods(AdmEntity entity, AdmField field, AdmSourceCodeBuilder codeBuilder) {
        AdmCollection fieldType = (AdmCollection)field.getType();
        String finalModifier = AdmXbuf2Generator.fieldAccessorFinalModifier(entity);
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln();
        this.writeDeprecationComment("    ", field, codeBuilder);
        codeBuilder.last().appendln("    " + finalModifier + "public " + fieldType.getTemplatedJavaTypeName() + " " + AdmXbuf2Generator.fieldGetterMethodName(field) + "() {");
        codeBuilder.last().appendln("        " + fieldType.getTemplatedJavaTypeName() + " val = (" + fieldType.getTemplatedJavaTypeName() + ")getChild(" + AdmXbuf2Generator.fieldFidVarName(field) + ");");
        codeBuilder.last().appendln("        if (val == null) {");
        codeBuilder.last().appendln("            setChild(" + AdmXbuf2Generator.fieldFidVarName(field) + ", val = " + fieldType.getTemplatedJavaTypeName() + ".create());");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        return val;");
        codeBuilder.last().appendln("        }");
    }

    private final void writeUserFieldMethods(AdmEntity entity, AdmField field, boolean generatArrayFieldsEmptyIfNull, AdmSourceCodeBuilder codeBuilder) {
        AdmType fieldType = field.getType();
        codeBuilder.last().appendln();
        codeBuilder.last().appendln("    // -----'" + field.getName() + "' -----");
        this.writeFieldIdMethods(entity, field, codeBuilder);
        if (fieldType instanceof AdmPrimitive) {
            this.writeUserPrimitiveFieldMethods(entity, field, codeBuilder);
        } else if (fieldType instanceof AdmArray) {
            if (fieldType instanceof AdmPrimitiveArray) {
                this.writeUserPrimitiveArrayFieldMethods(entity, field, generatArrayFieldsEmptyIfNull, codeBuilder);
            } else if (fieldType instanceof AdmEntityArray) {
                this.writeUserEntityArrayFieldMethods(entity, field, generatArrayFieldsEmptyIfNull, codeBuilder);
            } else if (fieldType instanceof AdmEnumerationArray) {
                this.writeUserEnumerationArrayFieldMethods(entity, field, generatArrayFieldsEmptyIfNull, codeBuilder);
            }
        } else if (fieldType instanceof AdmEnumeration) {
            this.writeUserEnumerationFieldMethods(entity, field, codeBuilder);
        } else if (fieldType instanceof AdmEntity) {
            this.writeUserEntityFieldMethods(entity, field, codeBuilder);
        } else if (fieldType instanceof AdmCollection) {
            this.writeUserCollectionFieldMethods(entity, field, codeBuilder);
        } else {
            throw new IllegalArgumentException("unknown field type '" + fieldType.getTemplatedJavaTypeName() + "' (class=" + ((Object)((Object)fieldType)).getClass().getName() + ")");
        }
        codeBuilder.last().appendln("    // -----'" + field.getName() + "' -----");
    }

    private final void writeFieldMethods(AdmEntity entity, List<AdmField> fields, boolean generatArrayFieldsEmptyIfNull, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.last().appendln("    // ----- Field getter/setter methods -----");
        this.writeContainedEntityCollectionElementMethods(entity, codeBuilder);
        Iterator<AdmField> fieldIterator = fields.iterator();
        while (fieldIterator.hasNext()) {
            this.writeUserFieldMethods(entity, fieldIterator.next(), generatArrayFieldsEmptyIfNull, codeBuilder);
        }
        codeBuilder.last().appendln("    // ----- Field getter/setter methods -----");
    }

    private final void writePoolingMethods(AdmEntity entity, AdmSourceCodeBuilder codeBuilder) {
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    // ----- Pooling related methods -----");
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public " + entity.getName() + " init() {");
        codeBuilder.last().appendln("        reset();");
        if (entity.isEmbedded()) {
            codeBuilder.last().appendln("        _ownershipCount.set(1);");
        } else if (entity.containedInSet().size() > 0) {
            codeBuilder.last().appendln("        fid = 0l;");
        }
        codeBuilder.last().appendln("        return this;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public " + entity.getName() + " setPool(final %{com.neeve.util.UtlPool}<" + entity.getName() + "> pool) {");
        codeBuilder.last().appendln("        _pool = pool;");
        codeBuilder.last().appendln("        return this;");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public %{com.neeve.util.UtlPool}<" + entity.getName() + "> getPool() {");
        codeBuilder.last().appendln("        return _pool;");
        codeBuilder.last().appendln("    }");
        if (entity.isEmbedded()) {
            codeBuilder.last().appendln("    final public " + entity.getName() + " acquire() {");
            codeBuilder.last().appendln("        final int val = _ownershipCount.incrementAndGet();");
            codeBuilder.last().appendln("        if (val <= 1 && _pool != null) {");
            codeBuilder.last().appendln("            throw new IllegalStateException(\"attempt to acquire an already disposed entity\");");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        return this;");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    final public int getOwnershipCount() {");
            codeBuilder.last().appendln("        return _ownershipCount.get();");
            codeBuilder.last().appendln("    }");
            codeBuilder.last().appendln("    final public void dispose() {");
            codeBuilder.last().appendln("        final int val = _ownershipCount.decrementAndGet();");
            codeBuilder.last().appendln("        if (val < 0 && _pool != null) {");
            codeBuilder.last().appendln("            throw new IllegalStateException(\"attempt to dispose an already disposed entity\");");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        if (val == 0 && _pool != null) {");
            codeBuilder.last().appendln("            created = false;");
            codeBuilder.last().appendln("            _pool.put(this);");
            codeBuilder.last().appendln("            _memoryStats.onEntityDisposed(" + entity.getFullName() + ".class, MemoryStats.EntityType." + AdmXbuf2Generator.getMemoryStatsEntityType(entity) + ", true);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
        }
        codeBuilder.last().appendln("    // ----- Pooling related methods -----");
    }

    private final void writeFinalizeMethod(AdmEntity entity, AdmSourceCodeBuilder codeBuilder) {
        if (this.generateFinalizerMethods(entity)) {
            codeBuilder.newCodeSegment();
            codeBuilder.last().appendln("    @Override");
            codeBuilder.last().appendln("    final public void finalize() {");
            if (this.useIOBufferAsBackingStorage(entity)) {
                codeBuilder.last().appendln("        if (hasSerializedBuffer()) {");
                codeBuilder.last().appendln("            _memoryStats.onEntityDataDisposed(" + entity.getFullName() + ".class, MemoryStats.EntityType." + AdmXbuf2Generator.getMemoryStatsEntityType(entity) + ", _serializedBuffer.getCapacity(), false);");
                codeBuilder.last().appendln("        }");
            } else {
                codeBuilder.last().appendln("        disposeSerializedBuffer(true);");
            }
            codeBuilder.last().appendln("        if (getOwnershipCount() == 0) {");
            codeBuilder.last().appendln("            _memoryStats.onEntityLeaked(" + entity.getFullName() + ".class, MemoryStats.EntityType." + AdmXbuf2Generator.getMemoryStatsEntityType(entity) + ");");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("        else {");
            codeBuilder.last().appendln("            _memoryStats.onEntityDisposed(" + entity.getFullName() + ".class, MemoryStats.EntityType." + AdmXbuf2Generator.getMemoryStatsEntityType(entity) + ", false);");
            codeBuilder.last().appendln("        }");
            codeBuilder.last().appendln("    }");
        }
    }

    final void generateClass(AdmEntity entity, boolean generateArrayGetterEmptyIfNull, AdmSourceCodeBuilder codeBuilder) throws Exception {
        List<AdmField> allfields = this.prepareFieldList(entity);
        for (AdmField field : allfields) {
            field.setId(this.protobufFieldId(field.getId()));
        }
        ArrayList<AdmField> fields = new ArrayList<AdmField>();
        fields.addAll(allfields);
        codeBuilder.last().appendln("");
        this.writeClassDeclaration(entity, fields, codeBuilder);
        this.writeBackingPacketClassDeclaration(entity, codeBuilder);
        codeBuilder.last().appendln("");
        this.writePoolFactoriesClassDeclarations(entity, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeSerializerClassDeclaration(entity, fields, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeEnumerationArrayDeserializerClassDeclarations(entity, fields, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeDeserializerClassDeclaration(entity, fields, codeBuilder);
        codeBuilder.last().appendln("");
        this.writePojoClassDeclaration(entity, allfields, fields, codeBuilder);
        if (entity.isMessage()) {
            codeBuilder.last().appendln("");
            this.writeRogMessageReflectorFieldDeclarations(entity, allfields, AdmEncodingType.Xbuf2.toString(), codeBuilder);
        }
        String last_fid = null;
        if (!entity.isEmbedded() && (entity.containsChildren() || !entity.containedInSet().isEmpty() || entity.isTransactional())) {
            codeBuilder.last().appendln("");
            last_fid = this.writeFieldFidDeclarations(entity, allfields, codeBuilder);
            codeBuilder.last().appendln("");
            this.writeIndexFieldDeclarations(entity, allfields, codeBuilder);
        }
        codeBuilder.last().appendln("");
        this.writeMemoryStatsVariableDeclarations(codeBuilder);
        codeBuilder.last().appendln("");
        this.writePoolingDeclarations(entity, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeBackingBufferDeclaration(entity, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeSerializerDeserializerPojoDeclaration(codeBuilder);
        if (entity.isEmbedded()) {
            codeBuilder.last().appendln("");
            this.writeReadOnlyFieldDeclaration(entity, codeBuilder);
            codeBuilder.last().appendln("");
            this.writeCreatedFieldDeclaration(entity, codeBuilder);
        }
        codeBuilder.last().appendln("");
        this.writeEmptyEntityArrayDeclaration(entity, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeConstructors(entity, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeBufferSerializerDeserializerPojoAccessorMethods(entity, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeContentClearerAndMemoryConservationMethods(entity, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeCoreSerializationDeserializationMethods(entity, codeBuilder);
        codeBuilder.last().appendln("");
        if (!entity.isEmbedded()) {
            this.writeMessageViewSerializerMethods(entity, codeBuilder);
        }
        if (this.isMessageReflectorImpl(entity, fields)) {
            codeBuilder.last().appendln("");
            this.writeRogMessageReflectorMethods(entity, allfields, codeBuilder);
        }
        if (!entity.isEmbedded()) {
            codeBuilder.last().appendln("");
            this.writeImplementedIStoreObjectMethods(entity, fields, entity.isTransactional(), codeBuilder);
        }
        if (!entity.isEmbedded()) {
            codeBuilder.last().appendln("");
            this.writeImplementedIRogNodeMethods(entity, codeBuilder);
            codeBuilder.last().appendln("");
            this.writeOverridenRogNodeMethods(entity, codeBuilder, last_fid);
            if (entity.isRoot() || entity.containsChildren()) {
                codeBuilder.last().appendln("");
                this.writeOverridenRogContainerNodeMethods(entity, fields, codeBuilder);
            }
        } else {
            this.writeSetAsReadOnlyMethod(entity, codeBuilder);
        }
        if (entity.isPojoShadow()) {
            codeBuilder.last().appendln("");
            this.writeImplementedIRogPojoShadowNodeMethods(entity, codeBuilder);
        }
        codeBuilder.last().appendln("");
        this.writeFieldMethods(entity, fields, generateArrayGetterEmptyIfNull, codeBuilder);
        codeBuilder.last().appendln("");
        this.writePoolingMethods(entity, codeBuilder);
        if (entity.isEmbedded()) {
            codeBuilder.last().appendln("");
            this.writeCloneMethod(entity, fields, codeBuilder);
        }
        if (!entity.isEmbedded()) {
            codeBuilder.last().appendln("");
            this.writeToJsonStringMethod(codeBuilder);
        }
        if (!entity.isEmbedded()) {
            codeBuilder.last().appendln("");
            this.writeVisitFieldsMethod(fields, codeBuilder);
        }
        this.writeIndexFieldsGetter(entity, fields, codeBuilder);
        this.writeValidatorMethods(entity, fields, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeToStringMethod(fields, !entity.isEmbedded(), codeBuilder);
        codeBuilder.last().appendln("");
        this.writeFinalizeMethod(entity, codeBuilder);
        codeBuilder.last().appendln("}");
    }

    final void generateClass(AdmCollection collection, AdmSourceCodeBuilder codeBuilder) throws Exception {
        ArrayList<AdmField> fields = new ArrayList<AdmField>();
        codeBuilder.last().appendln("");
        this.writeClassDeclaration(collection, codeBuilder);
        this.writeMemoryStatsVariableDeclarations(codeBuilder);
        codeBuilder.last().appendln("");
        this.writeConstructors(collection, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeDelegatedKeyAccessorMethods(collection, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeImplementedIStoreObjectMethods(collection, fields, true, codeBuilder);
        codeBuilder.last().appendln("");
        this.writeToJsonStringMethod(codeBuilder);
        codeBuilder.last().appendln("");
        this.writeToStringMethod(fields, true, codeBuilder);
    }

    @Override
    protected final void writeIRogStringMapElementMethods(AdmEntity entity, AdmSourceCodeBuilder codeBuilder) {
        super.writeIRogStringMapElementMethods(entity, codeBuilder);
        AdmField keyField = entity.findKey(AdmString.class);
        String keyFieldName = keyField != null ? keyField.getName() : "xRogStrKey";
        String keyFieldVariableName = AdmXbuf2Generator.fieldCollectionKeyVarName(keyFieldName);
        codeBuilder.newCodeSegment();
        codeBuilder.last().appendln("    final private %{com.neeve.lang.XString} " + keyFieldVariableName + " = %{com.neeve.lang.XString}.create();");
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public void setQuarkStringMapKey(final %{com.neeve.lang.XString} key) {");
        codeBuilder.last().appendln("        " + keyFieldVariableName + ".clear();");
        codeBuilder.last().appendln("        pojo()." + AdmXbuf2Generator.fieldSetterFromMethodName(keyFieldName) + "(key);");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public void setQuarkStringMapKey(final %{java.lang.CharSequence} key) {");
        codeBuilder.last().appendln("        " + keyFieldVariableName + ".clear();");
        codeBuilder.last().appendln("        pojo()." + AdmXbuf2Generator.fieldSetterFromMethodName(keyFieldName) + "(key);");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public void setQuarkStringMapKey(final String key) {");
        codeBuilder.last().appendln("        " + keyFieldVariableName + ".clear();");
        codeBuilder.last().appendln("        pojo()." + AdmXbuf2Generator.fieldSetterFromMethodName(keyFieldName) + "(key);");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public %{com.neeve.lang.XString} getQuarkStringMapKey() {");
        codeBuilder.last().appendln("        if (!" + keyFieldVariableName + ".isInitialized()) {");
        codeBuilder.last().appendln("           " + keyFieldVariableName + ".setValue(pojo()." + AdmXbuf2Generator.fieldGetterMethodName(keyFieldName) + "());");
        codeBuilder.last().appendln("        }");
        codeBuilder.last().appendln("        return " + keyFieldVariableName + ";");
        codeBuilder.last().appendln("    }");
        codeBuilder.last().appendln("    @Override");
        codeBuilder.last().appendln("    final public void clearQuarkStringMapKey() {");
        codeBuilder.last().appendln("        " + keyFieldVariableName + ".clear();");
        codeBuilder.last().appendln("    }");
    }
}

