/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.compression;

import com.jcraft.jzlib.Inflater;
import com.solacesystems.jcsmp.impl.compression.BufferUtil;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SolZlibInflater {
    private Inflater inflater = null;
    private byte[] decompressedOutput = null;
    private static final Log Trace = LogFactory.getLog(SolZlibInflater.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long inflate(byte[] compressedInput, int decompressedOutputLen) throws IOException, IllegalArgumentException {
        if (decompressedOutputLen <= 0) {
            throw new IllegalArgumentException("the size of the decompressed byte array must be greater than zero");
        }
        if (this.inflater == null) {
            this.inflater = new Inflater();
        } else {
            this.inflater.init();
        }
        this.inflater.setInput(compressedInput);
        this.decompressedOutput = new byte[decompressedOutputLen];
        this.inflater.setOutput(this.decompressedOutput);
        int result = this.inflater.inflate(4);
        if (result == 1) {
            result = this.inflater.end();
            if (result == 0) return this.inflater.total_out;
            throw new IOException("JZlib inflater.end() error, message: " + this.inflater.getMessage());
        }
        if (result != 0 && result != -5) throw new IOException("JZlib inflater.inflate() error, result: " + result);
        int numBufferGrows = 1;
        while (result == 0 || result == -5) {
            if (Trace.isDebugEnabled()) {
                Trace.debug((Object)("SolZlibInflater - Growing output buffer since more space is required for decompression. Growth " + numBufferGrows + ". Growing from " + this.decompressedOutput.length + " to " + this.decompressedOutput.length * 2));
            }
            this.decompressedOutput = BufferUtil.growBuffer(this.decompressedOutput, this.decompressedOutput.length, this.decompressedOutput.length * 2);
            this.inflater.setNextOut(this.decompressedOutput);
            this.inflater.setAvailOut(this.decompressedOutput.length - this.inflater.getNextOutIndex());
            result = this.inflater.inflate(4);
            ++numBufferGrows;
        }
        if (result != 1) throw new IOException("JZlib inflater.inflate() error, result: " + result + " numBufferGrows: " + numBufferGrows);
        result = this.inflater.end();
        if (result == 0) return this.inflater.total_out;
        throw new IOException("JZlib inflater.end() error, message: " + this.inflater.getMessage());
    }

    public byte[] getDecompressedOutput() {
        return this.decompressedOutput != null ? this.decompressedOutput : null;
    }
}

