/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma.impl.executor;

import com.neeve.event.IEventHandler;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessageLatencyManager;
import com.neeve.sma.MessageView;
import com.neeve.sma.SmaException;
import com.neeve.sma.SmaPermanentException;
import com.neeve.sma.impl.MessageBusBindingBase;
import com.neeve.sma.impl.executor.ExecutorBusChannel;
import com.neeve.sma.spi.executor.AbstractExecutorBusProcessorFactory;
import com.neeve.sma.spi.executor.ExecutorBusProcessor;
import com.neeve.sma.spi.executor.LifecycleAwareExecutorBusProcessor;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlTime;
import java.util.Properties;

public final class ExecutorBusBinding
extends MessageBusBindingBase {
    private final NoOpExecutionAcknowledger bestEffortAcknowledger = new NoOpExecutionAcknowledger();
    private ExecutorBusProcessor processor;
    private UtlPool<ExecutionAcknowledger> acknowledgerPool;

    ExecutorBusBinding(String userName, MessageBusDescriptor descriptor, IEventHandler eventHandler) throws SmaException {
        super(null, userName, descriptor, eventHandler);
    }

    private final ExecutorBusProcessor.Acknowledger createAcknowledger(ExecutorBusChannel channel, MessageView view) {
        if (this.acknowledgerPool == null) {
            throw new IllegalStateException("Unable to create execution Acknowledger prior to executor bus open");
        }
        if (channel.getQos() == MessageChannel.Qos.Guaranteed) {
            return ((ExecutionAcknowledger)this.acknowledgerPool.get(null)).init(channel, view);
        }
        return this.bestEffortAcknowledger;
    }

    final void processMessage(ExecutorBusChannel channel, MessageView view) throws SmaException {
        try {
            if (MessageLatencyManager.captureMsgLatencyStats) {
                view.setPreWireTs(UtlTime.now());
            }
            if (this.tracer.debug) {
                this.tracer.log("Processing executor bus message: " + view.toString(), Tracer.Level.DEBUG);
            }
            this.processor.process(view, this.createAcknowledger(channel, view), 0);
            if (MessageLatencyManager.captureMsgLatencyStats) {
                view.setPostWireTs(UtlTime.now());
            }
        }
        catch (Exception e) {
            throw new SmaException(this.tracePrefix + "Execution failure for '" + view.getClass().getSimpleName() + "' [" + e.getMessage() + "]", e);
        }
    }

    final boolean markFlushAsComplete(MessageBusBinding.FlushContext flushContext) {
        if (flushContext != null) {
            switch (flushContext.flushMode) {
                case SYNC_BLOCKING: {
                    MessageBusBinding.SynchronousBlockingFlushContext syncBlockingFlushContext = (MessageBusBinding.SynchronousBlockingFlushContext)flushContext;
                    syncBlockingFlushContext.complete = true;
                    break;
                }
                case SYNC_NON_BLOCKING: {
                    MessageBusBinding.SynchronousNonBlockingFlushContext syncNonBlockingFlushContext = (MessageBusBinding.SynchronousNonBlockingFlushContext)flushContext;
                    syncNonBlockingFlushContext.complete = true;
                    break;
                }
                case ASYNC: {
                    MessageBusBinding.AsynchronousFlushContext asyncFlushContext = (MessageBusBinding.AsynchronousFlushContext)flushContext;
                    asyncFlushContext.inProgress = false;
                    asyncFlushContext.syncComplete = true;
                    asyncFlushContext.status = null;
                    break;
                }
                default: {
                    throw new IllegalStateException("unsupported flush mode '" + (Object)((Object)flushContext.flushMode) + "'");
                }
            }
        }
        return true;
    }

    @Override
    protected void doOpen() throws SmaException {
        String processorFactoryName;
        Properties providerConfig = this.descriptor.getProviderConfig();
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Opening binding (props=" + providerConfig + ")...", Tracer.Level.DEBUG);
        }
        if ((processorFactoryName = UtlProps.getValue((Properties)providerConfig, (String)"processor_factory_classname", null)) == null) {
            throw new SmaPermanentException(this.tracePrefix + "'" + "processor_factory_classname" + "' must be set as an executor bus property!");
        }
        AbstractExecutorBusProcessorFactory factory = null;
        try {
            factory = (AbstractExecutorBusProcessorFactory)Class.forName(processorFactoryName).newInstance();
        }
        catch (Throwable t) {
            throw new SmaPermanentException(this.tracePrefix + "'" + "processor_factory_classname" + "' must be set as an executor bus property!", t);
        }
        this.processor = factory.createExecutorBusProcessor(this);
        if (this.processor == null) {
            throw new SmaPermanentException(this.tracePrefix + "null processor returned for executor bus by '" + factory.getClass().getName() + "'");
        }
        if (this.processor instanceof LifecycleAwareExecutorBusProcessor) {
            try {
                ((LifecycleAwareExecutorBusProcessor)this.processor).onExecutorBusOpen(this);
            }
            catch (SmaException smae) {
                throw smae;
            }
            catch (SmaPermanentException smae) {
                throw smae;
            }
            catch (Exception e) {
                throw new SmaException(this.tracePrefix + "Error in executor bus processor open [" + e.getMessage() + "]", e);
            }
        }
        this.acknowledgerPool = UtlPool.create((String)"execution-acknowledger", (String)(this.getUserName() + "." + this.getName()), (UtlPool.Factory)new AcknowledgerFactory(), (UtlPool.Params)UtlPool.Params.create().setThreaded(true));
    }

    @Override
    protected void doStart() throws SmaException {
        if (this.processor instanceof LifecycleAwareExecutorBusProcessor) {
            try {
                ((LifecycleAwareExecutorBusProcessor)this.processor).onExecutorBusStart(this);
            }
            catch (SmaException smae) {
                throw smae;
            }
            catch (SmaPermanentException smae) {
                throw smae;
            }
            catch (Exception e) {
                throw new SmaException(this.tracePrefix + "Error in executor bus processor open [" + e.getMessage() + "]", e);
            }
        }
    }

    @Override
    protected void doClose() throws SmaException {
        if (this.processor instanceof LifecycleAwareExecutorBusProcessor) {
            try {
                ((LifecycleAwareExecutorBusProcessor)this.processor).onExecutorBusClose(this);
            }
            catch (SmaPermanentException smae) {
                throw smae;
            }
            catch (Exception e) {
                throw new SmaException(this.tracePrefix + "Error in executor bus processor close [" + e.getMessage() + "]", e);
            }
        }
        this.acknowledgerPool.close();
    }

    @Override
    protected MessageChannel doGetMessageChannel(MessageChannelDescriptor descriptor) throws SmaException {
        return new ExecutorBusChannel(descriptor, this);
    }

    @Override
    protected void doFlush(MessageBusBinding.FlushContext flushContext) throws SmaException {
        this.markFlushAsComplete(flushContext);
    }

    @Override
    protected boolean doCanFail() {
        return true;
    }

    @Override
    protected boolean doAcksRequireFlush() {
        return false;
    }

    private final class NoOpExecutionAcknowledger
    implements ExecutorBusProcessor.Acknowledger {
        private NoOpExecutionAcknowledger() {
        }

        @Override
        public void acknowledge() {
            this.acknowledge(null);
        }

        @Override
        public void acknowledge(Exception status) {
            if (status != null) {
                ExecutorBusBinding.this.tracer.log("Execution acknowledgement with exeception ... ignoring for BestEffort message: " + UtlThrowable.prepareStackTrace((Throwable)status), Tracer.Level.SEVERE);
            }
        }
    }

    private final class AcknowledgerFactory
    implements UtlPool.Factory<ExecutionAcknowledger> {
        private AcknowledgerFactory() {
        }

        public final ExecutionAcknowledger createItem(Object object) {
            return new ExecutionAcknowledger();
        }

        public final ExecutionAcknowledger[] createItemArray(int size) {
            return new ExecutionAcknowledger[size];
        }
    }

    protected class ExecutionAcknowledger
    implements ExecutorBusProcessor.Acknowledger,
    UtlPool.Item<ExecutionAcknowledger> {
        private UtlPool<ExecutionAcknowledger> pool;
        private ExecutorBusChannel channel;
        private MessageView view;

        protected ExecutionAcknowledger() {
        }

        public ExecutionAcknowledger init(ExecutorBusChannel channel, MessageView view) {
            this.channel = channel;
            this.view = view;
            return this;
        }

        @Override
        public final void acknowledge() {
            this.acknowledge(null);
        }

        @Override
        public final void acknowledge(Exception status) {
            if (this.view == null || this.channel == null) {
                throw new IllegalStateException("Acknowledge called on unititialized Acknowledger ... duplicate call to acknowledge?");
            }
            if (((ExecutorBusBinding)ExecutorBusBinding.this).tracer.debug) {
                ExecutorBusBinding.this.tracer.log("Execution acknowledged for " + this.view.toString(), Tracer.Level.DEBUG);
            }
            this.channel.ack(this.view, status);
            this.dispose();
        }

        public final void dispose() {
            if (this.pool != null) {
                this.pool.put((UtlPool.Item)this);
            }
        }

        public final ExecutionAcknowledger init() {
            this.view = null;
            this.channel = null;
            return this;
        }

        public final ExecutionAcknowledger setPool(UtlPool<ExecutionAcknowledger> pool) {
            this.pool = pool;
            return this;
        }

        public final UtlPool<ExecutionAcknowledger> getPool() {
            return this.pool;
        }
    }
}

