/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools;

import com.neeve.adm.runtime.annotations.AdmGenerated;
import com.neeve.aep.mon.txnstats.AepMonInboundMessageTimings;
import com.neeve.aep.mon.txnstats.AepMonOutboundMessageTimings;
import com.neeve.aep.mon.txnstats.AepMonTransactionStatsMessage;
import com.neeve.aep.mon.txnstats.IAepMonInboundMessageTimings;
import com.neeve.aep.mon.txnstats.IAepMonOutboundMessageTimings;
import com.neeve.aep.mon.txnstats.IAepMonTransactionStatsMessage;
import com.neeve.lang.XIterator;
import com.neeve.query.QueryEngine;
import com.neeve.query.index.IdxField;
import com.neeve.query.index.IdxUniqueIndex;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.RogLogFactory;
import com.neeve.rog.log.RogLogQueryEngine;
import com.neeve.rog.log.RogLogRepository;
import com.neeve.rog.log.RogLogResultSet;
import com.neeve.tools.interactive.commands.AnnotatedCommand;
import com.neeve.util.UtlReflection;
import com.neeve.util.UtlTableFormatter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@AnnotatedCommand.Command(keywords={"TransactionStatsLogTool"}, description="This tool dump stats from tlog to a text format.\nThis tool expects outbound (.out), inbound (.in) and transaction stats (.txnstats)in the same folder as the main recovery transaction log.")
public final class TransactionStatsLogTool
extends AnnotatedCommand {
    @AnnotatedCommand.Argument(position=1, name="mainTransactionLog", required=true, description="Path of transaction log from which to query.")
    File recoveryTransactionLog;
    @AnnotatedCommand.Argument(position=2, name="selectionCriteria", required=true, description="The query to execute e.g: \"SELECT simpleClassName, customerId FROM logs WHERE timestamp BETWEEN 'today at 3pm' and 'today at 3:05pm'\"")
    String selectionCriteria;
    @AnnotatedCommand.Argument(position=3, name="outputFile", defaultValue="txnstats.csv", required=false, description="Name of output file name. Default file name is 'txnstats.csv")
    File outFile;
    @AnnotatedCommand.Option(shortForm=109, longForm="includeMessageLogs", defaultValue="true", required=false, description="flag indicating that corresponding inbound and outbound message logs should also be queried")
    private boolean includeMessageLogs;
    private RogLogQueryEngine txnStatsQueryEngine;
    private RogLogQueryEngine tlogsQueryEngine;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() throws Exception {
        this.console().info(">>>WARNING This tool is an experimental tool that is still in incubation<<<");
        this.outFile.getCanonicalFile().getParentFile().mkdirs();
        BufferedWriter outWriter = new BufferedWriter(new FileWriter(this.outFile));
        try {
            this.tlogsQueryEngine = RogLogFactory.createQueryEngine();
            this.tlogsQueryEngine.setAutoIndexing(false);
            this.tlogsQueryEngine.setDefaultIndexing(false);
            RogLogRepository recoveryRepo = this.tlogsQueryEngine.addTransactionLogForQuery(this.recoveryTransactionLog, "recovery");
            String mainLogName = recoveryRepo.getLog().getName();
            if (this.includeMessageLogs) {
                if (new File(this.recoveryTransactionLog.getParent(), mainLogName + ".in.metadata").exists()) {
                    this.console().info("Opening inbound message log for query...");
                    this.tlogsQueryEngine.addTransactionLogForQuery(new File(this.recoveryTransactionLog.getParent(), mainLogName + ".in.log"), "inbound");
                }
                if (new File(this.recoveryTransactionLog.getParent(), mainLogName + ".out.metadata").exists()) {
                    this.console().info("Opening outbound message log for query...");
                    this.tlogsQueryEngine.addTransactionLogForQuery(new File(this.recoveryTransactionLog.getParent(), mainLogName + ".out.log"), "outbound");
                }
            }
            this.txnStatsQueryEngine = RogLogFactory.createQueryEngine();
            RogLogRepository txnStatsRepo = this.txnStatsQueryEngine.addTransactionLogForQuery(new File(this.recoveryTransactionLog.getParent(), mainLogName + ".txnstats.log"), "txnstats");
            this.console().info("Indexing transaction stats log...");
            this.txnStatsQueryEngine.setBackgroundIndexingPolicy(QueryEngine.BackgroundIndexingPolicy.FLUSH_ON_CREATE);
            RogLogQueryEngine.RogLogField transactionIdField = this.txnStatsQueryEngine.getField("transactionId");
            this.txnStatsQueryEngine.createIndex((IdxField)transactionIdField, true);
            txnStatsRepo.flushIndexing();
            this.console().info("...transaction stats log indexed.");
            IdxUniqueIndex txnStatsIndex = txnStatsRepo.getUniqueIndex((IdxField)transactionIdField);
            RogLogResultSet queryResults = this.tlogsQueryEngine.execute(this.selectionCriteria);
            UtlTableFormatter tableFormatter = new UtlTableFormatter(false);
            List selectedFieldNames = queryResults.getSelectedFieldNames();
            for (int i = 0; i < selectedFieldNames.size(); ++i) {
                if (i > 0) {
                    outWriter.append(",");
                }
                outWriter.append((CharSequence)selectedFieldNames.get(i));
            }
            Set<String> mainTxnStats = this.getStatsFields(IAepMonTransactionStatsMessage.class);
            for (String string : mainTxnStats) {
                outWriter.append(",").append(string);
            }
            Set<String> inboundMessageTxnStats = this.getStatsFields(IAepMonInboundMessageTimings.class);
            for (String string : inboundMessageTxnStats) {
                outWriter.append(",").append(string);
            }
            Set<String> set = this.getStatsFields(IAepMonOutboundMessageTimings.class);
            for (String stat : set) {
                outWriter.append(",").append(stat);
            }
            outWriter.newLine();
            queryResults.beforeFirst();
            while (queryResults.next()) {
                RogLog.Entry entry = queryResults.getLogEntry();
                AepMonTransactionStatsMessage txnStats = null;
                Long txnStatsEntryPos = (Long)txnStatsIndex.getId((Object)entry.getTransactionId());
                if (txnStatsEntryPos != null) {
                    RogLog.Entry txnStatsEntry = (RogLog.Entry)txnStatsRepo.retrieve((Object)txnStatsEntryPos);
                    if (txnStatsEntry.getObject() instanceof AepMonTransactionStatsMessage) {
                        txnStats = (AepMonTransactionStatsMessage)txnStatsEntry.getObject();
                    } else {
                        this.console().error("Transaction stats log contained unexpected entry: " + txnStatsEntry.getObject().getClass().getName());
                    }
                }
                for (int i = 1; i <= selectedFieldNames.size(); ++i) {
                    if (i > 1) {
                        outWriter.append(",");
                    }
                    IdxField field = (IdxField)queryResults.getSelectedFields().get(i - 1);
                    String fieldName = (String)selectedFieldNames.get(i - 1);
                    outWriter.append(String.valueOf(tableFormatter.formatColumn(fieldName, field.getFieldType(), queryResults.getObject(i), UtlTableFormatter.Format.CSV)));
                }
                for (String stat : mainTxnStats) {
                    outWriter.append(",");
                    if (txnStats == null) continue;
                    Class type = UtlReflection.getUnwrappedReturnType(IAepMonTransactionStatsMessage.class, (String)stat);
                    Object value = UtlReflection.getProperty((Object)txnStats, (String)stat);
                    if (value == null) continue;
                    outWriter.append(String.valueOf(tableFormatter.formatColumn(stat, type, value, UtlTableFormatter.Format.CSV)));
                }
                for (String stat : inboundMessageTxnStats) {
                    outWriter.append(",");
                    if (txnStats == null || !entry.getMetadata().getIsInboundMessage()) continue;
                    long inseqno = entry.getMetadata().getTransactionInSequenceNumber();
                    XIterator<AepMonInboundMessageTimings> it = txnStats.getInboundMessageTimingsIterator();
                    AepMonInboundMessageTimings timings = null;
                    while (it.hasNext() && (long)(timings = (AepMonInboundMessageTimings)it.next()).getTransactionInSequenceNumber() != inseqno) {
                    }
                    if (timings != null) {
                        Class type = UtlReflection.getUnwrappedReturnType(IAepMonInboundMessageTimings.class, (String)stat);
                        Object value = UtlReflection.getProperty((Object)timings, (String)stat);
                        if (value == null) continue;
                        outWriter.append(String.valueOf(tableFormatter.formatColumn(stat, type, value, UtlTableFormatter.Format.CSV)));
                        continue;
                    }
                    this.console().error("Inbound timings not found for txn #" + entry.getTransactionId() + " with in seqno " + inseqno);
                }
                for (String stat : set) {
                    outWriter.append(",");
                    if (txnStats == null || !entry.getMetadata().getIsOutboundMessage()) continue;
                    long inseqno = entry.getMetadata().getTransactionInSequenceNumber();
                    long outseqno = entry.getMetadata().getTransactionOutSequenceNumber();
                    XIterator<AepMonOutboundMessageTimings> it = txnStats.getOutboundMessageTimingsIterator();
                    AepMonOutboundMessageTimings timings = null;
                    while (it.hasNext() && ((long)(timings = (AepMonOutboundMessageTimings)it.next()).getTransactionInSequenceNumber() != inseqno || (long)timings.getTransactionOutSequenceNumber() != outseqno)) {
                    }
                    if (timings != null) {
                        Class type = UtlReflection.getUnwrappedReturnType(IAepMonOutboundMessageTimings.class, (String)stat);
                        Object value = UtlReflection.getProperty((Object)timings, (String)stat);
                        if (value == null) continue;
                        outWriter.append(String.valueOf(tableFormatter.formatColumn(stat, type, value, UtlTableFormatter.Format.CSV)));
                        continue;
                    }
                    this.console().error("Outbound timings not found for txn #" + entry.getTransactionId() + " with in seqno " + inseqno + " and outseno " + outseqno);
                }
                outWriter.newLine();
            }
        }
        finally {
            outWriter.close();
            if (this.txnStatsQueryEngine != null) {
                this.txnStatsQueryEngine.close();
            }
            if (this.tlogsQueryEngine != null) {
                this.tlogsQueryEngine.close();
            }
        }
    }

    private final Set<String> getStatsFields(Class<?> type) {
        HashSet<String> fieldNames = new HashSet<String>();
        for (String fieldName : UtlReflection.getDeclaredProperties(type)) {
            Class fieldType = UtlReflection.getUnwrappedReturnType(type, (String)fieldName);
            if (fieldType == null || fieldType.isArray() || !fieldType.isPrimitive() && (!Serializable.class.isAssignableFrom(fieldType) || !Comparable.class.isAssignableFrom(fieldType)) || type.isAnnotationPresent(AdmGenerated.class) && fieldName.endsWith("FieldId")) continue;
            fieldNames.add(fieldName);
        }
        return fieldNames;
    }

    public static void main(String[] args) {
        try {
            TransactionStatsLogTool statsDumpTool = new TransactionStatsLogTool();
            statsDumpTool.run(args);
            System.exit(0);
        }
        catch (Exception e) {
            System.out.println("Exception in running TransactionStatsLogTool : " + e.getMessage());
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

