/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.log.test.unit.messages.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.protobuf.ByteString;
import com.neeve.adm.runtime.annotations.AdmFactoryInfo;
import com.neeve.adm.runtime.annotations.AdmGenerated;
import com.neeve.io.IOBuffer;
import com.neeve.lang.XString;
import com.neeve.rog.log.test.unit.messages.json.Factory;
import com.neeve.rog.log.test.unit.messages.json.IAddress;
import com.neeve.util.UtlBuffer;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.TimeZone;

@AdmGenerated(encoding="Json", compatLevel="4.1.0", admVersion="Unknown Version", date="12/5/25 9:28 AM", buildInfo="${build.version.string}")
@AdmFactoryInfo(factoryClass=Factory.class, vfid=-1000, ofid=-1000, typeId=3)
@JsonPropertyOrder(value={"Zipcode", "Company", "Street", "City", "State", "Country"})
public final class Address
implements IAddress {
    public static final Address[] EMPTY_ARRAY = new Address[0];
    @JsonProperty(value="_xFieldBitmask_")
    private final long[] _fieldBitmask = new long[1];
    private boolean readOnly;
    private short _usrZipcode;
    private String _usrCompany;
    private String _usrStreet;
    private String _usrCity;
    private String _usrState;
    private String _usrCountry;

    public Address() {
    }

    Address(String json) throws Exception {
        if (json != null) {
            Factory.mapper.reader().withValueToUpdate((Object)this).readValue(json);
        }
    }

    @JsonCreator
    public static Address create() {
        return new Address();
    }

    public static Address createFromJson(String json) {
        try {
            return new Address(json);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static Address createFromSerializedJson(ByteBuffer serializedJson) {
        try {
            return new Address(ByteString.copyFrom((ByteBuffer)serializedJson).toStringUtf8());
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static Address createFromSerializedJson(byte[] serializedJson) {
        try {
            return new Address(ByteString.copyFrom((byte[])serializedJson).toStringUtf8());
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static Address createFrom(byte[] serializedJson) {
        return Address.createFromSerializedJson(serializedJson);
    }

    public final void clearContent() {
        this.clearZipcode();
        this.clearCompany();
        this.clearStreet();
        this.clearCity();
        this.clearState();
        this.clearCountry();
    }

    public final void setAsReadOnly() {
        this.readOnly = true;
    }

    public final boolean getIsReadOnly() {
        return this.readOnly;
    }

    public static final int getZipcodeFieldId() {
        return 32733;
    }

    @Override
    @JsonProperty(value="Zipcode")
    public final void setZipcode(short val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        this._usrZipcode = val;
        this._fieldBitmask[0] = this._fieldBitmask[0] | 1L;
    }

    @Override
    @JsonIgnore
    public final void setZipcodeAsObject(Short val) {
        if (val == null) {
            this.clearZipcode();
        } else {
            this.setZipcode(val);
        }
    }

    @Override
    @JsonIgnore
    public final short getZipcode() {
        return this._usrZipcode;
    }

    @Override
    @JsonProperty(value="Zipcode")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Short getZipcodeAsObject() {
        if (!this.hasZipcode()) {
            return null;
        }
        return this.getZipcode();
    }

    @Override
    public final void clearZipcode() {
        this._usrZipcode = 0;
        this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFEL;
    }

    @Override
    public final boolean hasZipcode() {
        return (this._fieldBitmask[0] & 1L) == 1L;
    }

    public static final int getCompanyFieldId() {
        return 32737;
    }

    @Override
    @JsonProperty(value="Company")
    public final void setCompany(String val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        this._usrCompany = val;
        this._fieldBitmask[0] = val != null ? this._fieldBitmask[0] | 2L : this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFDL;
    }

    @Override
    @JsonProperty(value="Company")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final String getCompany() {
        return this._usrCompany;
    }

    @Override
    @JsonIgnore
    public final void lendCompany(XString val) {
        if (val == null || !val.isInitialized() || val.isNull()) {
            this.setCompany(null);
            return;
        }
        if (!val.isImmutable()) {
            throw new IllegalArgumentException("value is mutable");
        }
        this.setCompany(val.getValue());
    }

    @Override
    @JsonIgnore
    public final void setCompanyFrom(long val) {
        this.setCompany(String.valueOf(val));
    }

    @Override
    @JsonIgnore
    public final <T extends XString> T getCompanyTo(XString.Factory<T> factory) {
        String val = this.getCompany();
        if (val != null) {
            return (T)factory.create(val, false);
        }
        return null;
    }

    @Override
    @JsonIgnore
    public final void setCompanyFrom(XString val) {
        this.setCompany(val != null ? val.getValue() : null);
    }

    @Override
    @JsonIgnore
    public final void getCompanyTo(XString val) {
        val.setValue(this.getCompany());
    }

    @Override
    @JsonIgnore
    public final XString getCompanyUnsafe() {
        return XString.create((String)this.getCompany());
    }

    @Override
    public final void clearCompany() {
        this._usrCompany = null;
        this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFDL;
    }

    @Override
    public final boolean hasCompany() {
        return (this._fieldBitmask[0] & 2L) == 2L;
    }

    public static final int getStreetFieldId() {
        return 32736;
    }

    @Override
    @JsonProperty(value="Street")
    public final void setStreet(String val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        this._usrStreet = val;
        this._fieldBitmask[0] = val != null ? this._fieldBitmask[0] | 4L : this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFBL;
    }

    @Override
    @JsonProperty(value="Street")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final String getStreet() {
        return this._usrStreet;
    }

    @Override
    @JsonIgnore
    public final void lendStreet(XString val) {
        if (val == null || !val.isInitialized() || val.isNull()) {
            this.setStreet(null);
            return;
        }
        if (!val.isImmutable()) {
            throw new IllegalArgumentException("value is mutable");
        }
        this.setStreet(val.getValue());
    }

    @Override
    @JsonIgnore
    public final void setStreetFrom(long val) {
        this.setStreet(String.valueOf(val));
    }

    @Override
    @JsonIgnore
    public final <T extends XString> T getStreetTo(XString.Factory<T> factory) {
        String val = this.getStreet();
        if (val != null) {
            return (T)factory.create(val, false);
        }
        return null;
    }

    @Override
    @JsonIgnore
    public final void setStreetFrom(XString val) {
        this.setStreet(val != null ? val.getValue() : null);
    }

    @Override
    @JsonIgnore
    public final void getStreetTo(XString val) {
        val.setValue(this.getStreet());
    }

    @Override
    @JsonIgnore
    public final XString getStreetUnsafe() {
        return XString.create((String)this.getStreet());
    }

    @Override
    public final void clearStreet() {
        this._usrStreet = null;
        this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFBL;
    }

    @Override
    public final boolean hasStreet() {
        return (this._fieldBitmask[0] & 4L) == 4L;
    }

    public static final int getCityFieldId() {
        return 32735;
    }

    @Override
    @JsonProperty(value="City")
    public final void setCity(String val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        this._usrCity = val;
        this._fieldBitmask[0] = val != null ? this._fieldBitmask[0] | 8L : this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFF7L;
    }

    @Override
    @JsonProperty(value="City")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final String getCity() {
        return this._usrCity;
    }

    @Override
    @JsonIgnore
    public final void lendCity(XString val) {
        if (val == null || !val.isInitialized() || val.isNull()) {
            this.setCity(null);
            return;
        }
        if (!val.isImmutable()) {
            throw new IllegalArgumentException("value is mutable");
        }
        this.setCity(val.getValue());
    }

    @Override
    @JsonIgnore
    public final void setCityFrom(long val) {
        this.setCity(String.valueOf(val));
    }

    @Override
    @JsonIgnore
    public final <T extends XString> T getCityTo(XString.Factory<T> factory) {
        String val = this.getCity();
        if (val != null) {
            return (T)factory.create(val, false);
        }
        return null;
    }

    @Override
    @JsonIgnore
    public final void setCityFrom(XString val) {
        this.setCity(val != null ? val.getValue() : null);
    }

    @Override
    @JsonIgnore
    public final void getCityTo(XString val) {
        val.setValue(this.getCity());
    }

    @Override
    @JsonIgnore
    public final XString getCityUnsafe() {
        return XString.create((String)this.getCity());
    }

    @Override
    public final void clearCity() {
        this._usrCity = null;
        this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFF7L;
    }

    @Override
    public final boolean hasCity() {
        return (this._fieldBitmask[0] & 8L) == 8L;
    }

    public static final int getStateFieldId() {
        return 32734;
    }

    @Override
    @JsonProperty(value="State")
    public final void setState(String val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        this._usrState = val;
        this._fieldBitmask[0] = val != null ? this._fieldBitmask[0] | 0x10L : this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFEFL;
    }

    @Override
    @JsonProperty(value="State")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final String getState() {
        return this._usrState;
    }

    @Override
    @JsonIgnore
    public final void lendState(XString val) {
        if (val == null || !val.isInitialized() || val.isNull()) {
            this.setState(null);
            return;
        }
        if (!val.isImmutable()) {
            throw new IllegalArgumentException("value is mutable");
        }
        this.setState(val.getValue());
    }

    @Override
    @JsonIgnore
    public final void setStateFrom(long val) {
        this.setState(String.valueOf(val));
    }

    @Override
    @JsonIgnore
    public final <T extends XString> T getStateTo(XString.Factory<T> factory) {
        String val = this.getState();
        if (val != null) {
            return (T)factory.create(val, false);
        }
        return null;
    }

    @Override
    @JsonIgnore
    public final void setStateFrom(XString val) {
        this.setState(val != null ? val.getValue() : null);
    }

    @Override
    @JsonIgnore
    public final void getStateTo(XString val) {
        val.setValue(this.getState());
    }

    @Override
    @JsonIgnore
    public final XString getStateUnsafe() {
        return XString.create((String)this.getState());
    }

    @Override
    public final void clearState() {
        this._usrState = null;
        this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFEFL;
    }

    @Override
    public final boolean hasState() {
        return (this._fieldBitmask[0] & 0x10L) == 16L;
    }

    public static final int getCountryFieldId() {
        return 32732;
    }

    @Override
    @JsonProperty(value="Country")
    public final void setCountry(String val) {
        if (this.readOnly) {
            throw new IllegalStateException("node is read only");
        }
        this._usrCountry = val;
        this._fieldBitmask[0] = val != null ? this._fieldBitmask[0] | 0x20L : this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFDFL;
    }

    @Override
    @JsonProperty(value="Country")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final String getCountry() {
        return this._usrCountry;
    }

    @Override
    @JsonIgnore
    public final void lendCountry(XString val) {
        if (val == null || !val.isInitialized() || val.isNull()) {
            this.setCountry(null);
            return;
        }
        if (!val.isImmutable()) {
            throw new IllegalArgumentException("value is mutable");
        }
        this.setCountry(val.getValue());
    }

    @Override
    @JsonIgnore
    public final void setCountryFrom(long val) {
        this.setCountry(String.valueOf(val));
    }

    @Override
    @JsonIgnore
    public final <T extends XString> T getCountryTo(XString.Factory<T> factory) {
        String val = this.getCountry();
        if (val != null) {
            return (T)factory.create(val, false);
        }
        return null;
    }

    @Override
    @JsonIgnore
    public final void setCountryFrom(XString val) {
        this.setCountry(val != null ? val.getValue() : null);
    }

    @Override
    @JsonIgnore
    public final void getCountryTo(XString val) {
        val.setValue(this.getCountry());
    }

    @Override
    @JsonIgnore
    public final XString getCountryUnsafe() {
        return XString.create((String)this.getCountry());
    }

    @Override
    public final void clearCountry() {
        this._usrCountry = null;
        this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFDFL;
    }

    @Override
    public final boolean hasCountry() {
        return (this._fieldBitmask[0] & 0x20L) == 32L;
    }

    public final byte[] serializeToByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            Factory.mapper.writeValue((OutputStream)baos, (Object)this);
            return baos.toByteArray();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public final ByteBuffer serializeToByteBuffer() {
        return ByteBuffer.wrap(this.serializeToByteArray());
    }

    public final boolean isBufferBacked() {
        return false;
    }

    @JsonIgnore
    public final int getSerializeToNativeLength() {
        return this.serializeToByteArray().length;
    }

    public final int serializeToNative(long address, int addressOffset) {
        byte[] bytes = this.serializeToByteArray();
        IOBuffer buf = IOBuffer.create((int)bytes.length, (boolean)true);
        buf.getBufferUnsafe().put(bytes, 0, bytes.length);
        UtlBuffer.copyToNative((ByteBuffer)buf.getBufferUnsafe(), (int)0, (long)address, (int)addressOffset, (int)bytes.length);
        buf.dispose();
        return bytes.length;
    }

    public final Address deserializeFromByteArray(byte[] array) {
        try {
            String val = ByteString.copyFrom((byte[])array).toStringUtf8();
            this.clearContent();
            Factory.mapper.reader().withValueToUpdate((Object)this).readValue(val);
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final Address deserializeFromByteBuffer(ByteBuffer buffer) {
        buffer.mark();
        try {
            String val = ByteString.copyFrom((ByteBuffer)buffer, (int)buffer.remaining()).toStringUtf8();
            this.clearContent();
            Factory.mapper.reader().withValueToUpdate((Object)this).readValue(val);
            Address address = this;
            return address;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            buffer.reset();
        }
    }

    public final Address deserializeFromNative(long address, int addressOffset, int length) {
        IOBuffer buf = IOBuffer.create((int)length, (boolean)true);
        UtlBuffer.copyFromNative((long)address, (int)addressOffset, (ByteBuffer)buf.getBufferUnsafe(), (int)0, (int)length);
        this.deserializeFromByteBuffer(buf.takeBuffer());
        buf.releaseBuffer().dispose();
        return this;
    }

    public final boolean isReferenceCounted() {
        return false;
    }

    public final Address acquire() {
        return this;
    }

    public final int getOwnerCount() {
        return Integer.MAX_VALUE;
    }

    public final void dispose() {
    }

    public final Object clone() {
        Address clonee = Address.create();
        if (this.hasZipcode()) {
            clonee.setZipcode(this.getZipcode());
        }
        if (this.hasCompany()) {
            clonee.setCompany(this.getCompany());
        }
        if (this.hasStreet()) {
            clonee.setStreet(this.getStreet());
        }
        if (this.hasCity()) {
            clonee.setCity(this.getCity());
        }
        if (this.hasState()) {
            clonee.setState(this.getState());
        }
        if (this.hasCountry()) {
            clonee.setCountry(this.getCountry());
        }
        return clonee;
    }

    public final Address copy() {
        Address copy = Address.create();
        this.copyInto(copy);
        return copy;
    }

    public final void copyInto(Address copy) {
        if (copy.readOnly) {
            throw new IllegalStateException("copy target is read only");
        }
        if (this.hasZipcode()) {
            copy.setZipcode(this.getZipcode());
        } else {
            copy.clearZipcode();
        }
        if (this.hasCompany()) {
            copy.setCompany(this.getCompany());
        } else {
            copy.clearCompany();
        }
        if (this.hasStreet()) {
            copy.setStreet(this.getStreet());
        } else {
            copy.clearStreet();
        }
        if (this.hasCity()) {
            copy.setCity(this.getCity());
        } else {
            copy.clearCity();
        }
        if (this.hasState()) {
            copy.setState(this.getState());
        } else {
            copy.clearState();
        }
        if (this.hasCountry()) {
            copy.setCountry(this.getCountry());
        } else {
            copy.clearCountry();
        }
    }

    @Override
    public final boolean isValid() {
        return true;
    }

    @Override
    public final void getValidationErrors(List<XString> results, String errorPrefix) {
    }

    public final String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HH:mm:ss.SSS");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        int c = 0;
        if (this.hasZipcode()) {
            builder.append(0 == c++ ? "" : ",").append("Zipcode=").append(this.getZipcode());
        }
        if (this.hasCompany()) {
            builder.append(0 == c++ ? "" : ",").append("Company=").append(this.getCompany());
        }
        if (this.hasStreet()) {
            builder.append(0 == c++ ? "" : ",").append("Street=").append(this.getStreet());
        }
        if (this.hasCity()) {
            builder.append(0 == c++ ? "" : ",").append("City=").append(this.getCity());
        }
        if (this.hasState()) {
            builder.append(0 == c++ ? "" : ",").append("State=").append(this.getState());
        }
        if (this.hasCountry()) {
            builder.append(0 == c++ ? "" : ",").append("Country=").append(this.getCountry());
        }
        builder.append("}");
        return builder.toString();
    }
}

