/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.test.unit;

import com.google.common.collect.Sets;
import com.neeve.query.Query;
import com.neeve.query.QueryException;
import com.neeve.query.QueryResultSet;
import com.neeve.query.impl.mem.MemQuerySetRepository;
import com.neeve.query.impl.mock.MockQueryEngine;
import com.neeve.query.impl.mock.MockRecord;
import com.neeve.query.impl.mock.domain.Address;
import com.neeve.query.impl.mock.domain.Customer;
import com.neeve.query.impl.mock.domain.DataTypePayload;
import com.neeve.query.impl.mock.domain.SalesOrder;
import com.neeve.query.index.IdxField;
import com.neeve.query.index.IdxIndex;
import java.util.HashSet;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class QueryEngineSqlTest {
    private static MockQueryEngine engine;
    private static MemQuerySetRepository<Integer, MockRecord> repo;
    private static boolean createIndexes;

    @BeforeClass
    public static void init() throws Exception {
        engine = new MockQueryEngine();
        repo = new MemQuerySetRepository<Integer, MockRecord>("mock", MockRecord.keyMapper);
        repo.open();
        engine.addRepository(repo, "mock");
        Package pkg = Customer.class.getPackage();
        engine.setDefaultPackage(pkg);
        createIndexes = false;
        if (createIndexes) {
            repo.createIndex(MockRecord.customerId, true);
            repo.createIndex(MockRecord.customerZipcode, false);
        }
        int recordId = 0;
        for (int i = 1; i <= 25; ++i) {
            Customer cust = new Customer(i, "John Doe #" + i);
            Address address = new Address(i % 2 == 0 ? "12345" : "22222");
            if (i % 3 == 0) {
                address.setCity("Boston");
            } else if (i % 3 == 1) {
                address.setCity("Chicago");
            }
            cust.setAddress(address);
            MockRecord custRec = new MockRecord(++recordId, cust);
            repo.add(custRec);
            SalesOrder order = new SalesOrder(i, cust, "apple");
            MockRecord orderRec = new MockRecord(++recordId, order);
            repo.add(orderRec);
        }
        repo.add(new MockRecord(++recordId, new DataTypePayload.InnerClassExample()));
        Object anonInnerClassInstance = new DataTypePayload(1).getAnonInnerClassData();
        repo.add(new MockRecord(++recordId, anonInnerClassInstance));
    }

    @AfterClass
    public static void teardown() throws Exception {
        if (createIndexes) {
            repo.dropIndex(MockRecord.customerId);
            repo.dropIndex(MockRecord.customerZipcode);
        }
        engine.close();
    }

    @Test
    public void testWithoutWhereClause() {
        String sql = "select Customer.name from mock";
        Query query = engine.createQuery(sql);
        QueryResultSet rs = engine.execute(query);
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
            String customerName = rs.getString(1);
            Assert.assertNotNull((String)"found name", (Object)customerName);
        }
        Assert.assertEquals((String)"25 rows", (long)25L, (long)numRows);
    }

    @Test
    public void testMultipleColumns() {
        String sql = "select Customer.id,  Customer.name,  Customer.address.zipcode  from mock  where Customer.address.zipcode = '12345' and Customer.name between 'John' and 'June'";
        Query query = engine.createQuery(sql);
        QueryResultSet rs = engine.execute(query);
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
            long custId = rs.getLong(1);
            String custName = rs.getString(2);
            String zip = rs.getString(3);
            Assert.assertTrue((String)"id is even", (custId % 2L == 0L ? 1 : 0) != 0);
            Assert.assertNotNull((String)"name is not null", (Object)custName);
            Assert.assertEquals((String)"zipcode 12345", (Object)"12345", (Object)zip);
        }
        rs.close();
        Assert.assertEquals((String)"12 rows", (long)12L, (long)numRows);
    }

    @Test
    public void testColumnsWithoutWhitespace() {
        String sql = "select Customer.id,Customer.name,Customer.address.zipcode  from mock  where Customer.address.zipcode = '12345' and Customer.name between 'John' and 'June'";
        Query query = engine.createQuery(sql);
        QueryResultSet rs = engine.execute(query);
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
            long custId = rs.getLong(1);
            String custName = rs.getString(2);
            String zip = rs.getString(3);
            Assert.assertTrue((String)"id is even", (custId % 2L == 0L ? 1 : 0) != 0);
            Assert.assertNotNull((String)"name is not null", (Object)custName);
            Assert.assertEquals((String)"zipcode 12345", (Object)"12345", (Object)zip);
        }
        rs.close();
        Assert.assertEquals((String)"12 rows", (long)12L, (long)numRows);
    }

    @Test
    public void testNumeric() {
        String sql = "select Customer.id,  Customer.name,  Customer.address.zipcode  from mock  where Customer.id = 4";
        Query query = engine.createQuery(sql);
        QueryResultSet rs = engine.execute(query);
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
            long custId = rs.getLong(1);
            Assert.assertEquals((String)"cust id is 4", (long)4L, (long)custId);
        }
        rs.close();
        Assert.assertEquals((String)"1 rows", (long)1L, (long)numRows);
    }

    @Test
    public void testSelectAll() {
        String sql = "select *  from mock  where Customer.id = 4";
        Query query = engine.createQuery(sql);
        QueryResultSet rs = engine.execute(query);
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
            MockRecord rec = (MockRecord)rs.getObject(1);
            Customer cust = (Customer)rec.getObject();
            Assert.assertEquals((String)"cust id is 4", (long)4L, (long)cust.getId());
        }
        rs.close();
        Assert.assertEquals((String)"1 rows", (long)1L, (long)numRows);
    }

    @Test
    public void testSelectEntity() {
        String sql = "select Customer  from mock  where Customer.id = 4";
        Query query = engine.createQuery(sql);
        QueryResultSet rs = engine.execute(query);
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
            Customer cust = (Customer)rs.getObject(1);
            Assert.assertEquals((String)"cust id is 4", (long)4L, (long)cust.getId());
        }
        rs.close();
        Assert.assertEquals((String)"1 rows", (long)1L, (long)numRows);
    }

    @Test
    public void testNotEquals() {
        String sql = "select Customer  from mock  where Customer.id != 4 and Customer.id <> 5";
        Query query = engine.createQuery(sql);
        QueryResultSet rs = engine.execute(query);
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
            Customer cust = (Customer)rs.getObject(1);
            Assert.assertTrue((String)"cust id is not 4", (cust.getId() != 4L && cust.getId() != 5L ? 1 : 0) != 0);
        }
        rs.close();
        Assert.assertEquals((String)"23 rows", (long)23L, (long)numRows);
    }

    @Test
    public void testIsNull() {
        String sql = "select Customer  from mock  where Customer.id = 4 and SalesOrder.id is null";
        Query query = engine.createQuery(sql);
        QueryResultSet rs = engine.execute(query);
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
            Customer cust = (Customer)rs.getObject(1);
            Assert.assertEquals((String)"cust id is 4", (long)4L, (long)cust.getId());
        }
        rs.close();
        Assert.assertEquals((String)"1 rows", (long)1L, (long)numRows);
    }

    @Test
    public void testIsNotNull() {
        String sql = "select Customer  from mock  where Customer.id = 4 and Customer.id is not null";
        Query query = engine.createQuery(sql);
        QueryResultSet rs = engine.execute(query);
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
            Customer cust = (Customer)rs.getObject(1);
            Assert.assertEquals((String)"cust id is 4", (long)4L, (long)cust.getId());
        }
        rs.close();
        Assert.assertEquals((String)"1 rows", (long)1L, (long)numRows);
    }

    @Test
    public void testLike() {
        QueryResultSet rs = engine.execute("select Customer from mock where Customer.name like '%Doe%'");
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
            Customer cust = (Customer)rs.getObject(1);
            Assert.assertTrue((String)"expected name to contain Doe", (boolean)cust.getName().contains("Doe"));
        }
        rs.close();
        Assert.assertEquals((String)"expected all customers", (long)25L, (long)numRows);
    }

    @Test
    public void testRegexLike() {
        QueryResultSet rs = engine.execute("select Customer from mock where Customer.name regex_like '.*Doe.*'");
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
            Customer cust = (Customer)rs.getObject(1);
            Assert.assertTrue((String)"expected name to contain Doe", (boolean)cust.getName().contains("Doe"));
        }
        rs.close();
        Assert.assertEquals((String)"expected all customers", (long)25L, (long)numRows);
    }

    @Test
    public void testBetween() {
        String sql = "select Customer  from mock  where Customer.id between 4 and 6";
        Query query = engine.createQuery(sql);
        QueryResultSet rs = engine.execute(query);
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
            Customer cust = (Customer)rs.getObject(1);
            Assert.assertTrue((String)"cust id is in [4,6]", (cust.getId() >= 4L && cust.getId() <= 6L ? 1 : 0) != 0);
        }
        rs.close();
        Assert.assertEquals((String)"3 rows", (long)3L, (long)numRows);
    }

    @Test
    public void testNotBetween() {
        String sql = "select Customer  from mock  where Customer.id not between 4 and 6";
        Query query = engine.createQuery(sql);
        QueryResultSet rs = engine.execute(query);
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
            Customer cust = (Customer)rs.getObject(1);
            Assert.assertTrue((String)"cust id is outside [4,6]", (cust.getId() < 4L || cust.getId() > 6L ? 1 : 0) != 0);
        }
        rs.close();
        Assert.assertEquals((String)"22 rows", (long)22L, (long)numRows);
    }

    @Test
    public void testIn() {
        String sql = "select Customer  from mock  where Customer.id in (2,4,6,8)";
        Query query = engine.createQuery(sql);
        QueryResultSet rs = engine.execute(query);
        HashSet expectedValues = Sets.newHashSet((Object[])new Long[]{2L, 4L, 6L, 8L});
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
            Customer cust = (Customer)rs.getObject(1);
            Long custId = cust.getId();
            Assert.assertTrue((String)"cust id is in {2,4,6,8}", (boolean)expectedValues.contains(custId));
        }
        rs.close();
        Assert.assertEquals((String)"4 rows", (long)4L, (long)numRows);
    }

    @Test
    public void testNotIn() {
        String sql = "select Customer  from mock  where Customer.id not in (2,4,6,8)";
        Query query = engine.createQuery(sql);
        QueryResultSet rs = engine.execute(query);
        HashSet expectedValues = Sets.newHashSet((Object[])new Long[]{2L, 4L, 6L, 8L});
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
            Customer cust = (Customer)rs.getObject(1);
            Long custId = cust.getId();
            Assert.assertFalse((String)"cust id is not in {2,4,6,8}", (boolean)expectedValues.contains(custId));
        }
        rs.close();
        Assert.assertEquals((String)"21 rows", (long)21L, (long)numRows);
    }

    @Test
    public void testNot() {
        String sql = "select Customer  from mock  where not Customer.id not in (2,4,6,8)";
        Query query = engine.createQuery(sql);
        QueryResultSet rs = engine.execute(query);
        HashSet expectedValues = Sets.newHashSet((Object[])new Long[]{2L, 4L, 6L, 8L});
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
            Customer cust = (Customer)rs.getObject(1);
            Long custId = cust.getId();
            Assert.assertTrue((String)"cust id is in {2,4,6,8}", (boolean)expectedValues.contains(custId));
        }
        rs.close();
        Assert.assertEquals((String)"4 rows", (long)4L, (long)numRows);
    }

    @Test
    public void testRepoName() {
        String sql = "select Customer, x_repository_name from mock  where Customer.id = 4 and Customer.id is not null";
        Query query = engine.createQuery(sql);
        QueryResultSet rs = engine.execute(query);
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
            Customer cust = (Customer)rs.getObject(1);
            String repoName = rs.getString(2);
            Assert.assertEquals((String)"cust id is 4", (long)4L, (long)cust.getId());
            Assert.assertEquals((String)"repo is mock", (Object)"mock", (Object)repoName);
        }
        rs.close();
        Assert.assertEquals((String)"1 rows", (long)1L, (long)numRows);
    }

    @Test(expected=QueryException.class)
    public void testUntypedColumn() {
        String sql = "select Object.id from mock where Object.id = 4";
        Query query = engine.createQuery(sql);
        QueryResultSet rs = engine.execute(query);
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
            Customer cust = (Customer)rs.getObject(1);
            Assert.assertEquals((String)"id is 4", (long)4L, (long)cust.getId());
        }
        Assert.assertEquals((String)"1 rows", (long)1L, (long)numRows);
    }

    @Test
    public void testCreateIndex() {
        engine.executeStatement("create unique index customer_id on mock(Customer.id)");
        engine.executeStatement("drop index customer_id");
    }

    @Test
    public void testGroupBy() {
        String sql = "select Customer.address.zipcode, count(Customer.address.zipcode), min(Customer.id), max(Customer.id), sum(Customer.id), avg(Customer.id) from mock where Customer.id < 15 group by Customer.address.zipcode";
        Query query = engine.createQuery(sql);
        QueryResultSet rs = engine.execute(query);
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
            String zipcode = rs.getString(1);
            int cnt = rs.getInteger(2);
            long minId = rs.getLong(3);
            long maxId = rs.getLong(4);
            double idSum = rs.getLong(5);
            double idAverage = rs.getDouble(6);
            Assert.assertEquals((String)"7 even, 7 odd", (long)7L, (long)cnt);
            if (zipcode.equals("12345")) {
                Assert.assertEquals((String)"lowest even id is 2", (long)2L, (long)minId);
                Assert.assertEquals((String)"greatest even id is 14", (long)14L, (long)maxId);
                Assert.assertEquals((String)"sum of even ids is 56", (double)56.0, (double)idSum, (double)0.0);
                Assert.assertEquals((String)"average of even ids is 8", (double)8.0, (double)idAverage, (double)0.0);
                continue;
            }
            if (!zipcode.equals("22222")) continue;
            Assert.assertEquals((String)"lowest odd id is 1", (long)1L, (long)minId);
            Assert.assertEquals((String)"greatest odd id is 13", (long)13L, (long)maxId);
            Assert.assertEquals((String)"sum of odd ids is 49", (double)49.0, (double)idSum, (double)0.0);
            Assert.assertEquals((String)"average of odd ids is 7", (double)7.0, (double)idAverage, (double)0.0);
        }
        rs.close();
        Assert.assertEquals((String)"expected 2 rows", (long)2L, (long)numRows);
    }

    @Test
    public void testHaving() {
        String sql = "select Customer.address.zipcode, sum(Customer.id) from mock where Customer.id < 15 group by Customer.address.zipcode having sum(Customer.id) > 50";
        QueryResultSet rs = engine.execute(sql);
        Assert.assertTrue((String)"first row", (boolean)rs.next());
        Assert.assertEquals((String)"even row zipcode is 12345", (Object)"12345", (Object)rs.getString(1));
        Assert.assertEquals((String)"ids add to 56", (long)56L, (long)rs.getLong(2));
        Assert.assertFalse((String)"only one row", (boolean)rs.next());
        rs.close();
        sql = "select Customer.address.zipcode, sum(Customer.id) from mock where Customer.id < 15 group by Customer.address.zipcode having sum(Customer.id) > 50 and (  sum(Customer.id) > 50     or sum(Customer.id) > 50 ) and not sum(Customer.id) <= 50";
        rs = engine.execute(sql);
        Assert.assertTrue((String)"first row", (boolean)rs.next());
        Assert.assertEquals((String)"even row zipcode is 12345", (Object)"12345", (Object)rs.getString(1));
        Assert.assertEquals((String)"ids add to 56", (long)56L, (long)rs.getLong(2));
        Assert.assertFalse((String)"only one row", (boolean)rs.next());
        rs.close();
    }

    @Test
    public void testOrderBy() {
        long custId;
        String sql = "select Customer.address.zipcode, Customer.id, Customer.name from mock where Customer.id < 15 order by Customer.address.zipcode, Customer.id";
        Query query = engine.createQuery(sql);
        QueryResultSet rs = engine.execute(query);
        int numRows = 0;
        long expectedCustomerId = 2L;
        while (rs.next()) {
            custId = rs.getLong(2);
            Assert.assertEquals((String)"expect even, then odd customer ids", (long)expectedCustomerId, (long)custId);
            ++numRows;
            expectedCustomerId = expectedCustomerId == 14L ? 1L : expectedCustomerId + 2L;
        }
        Assert.assertEquals((String)"expected 14 rows", (long)14L, (long)numRows);
        sql = "select Customer.address.zipcode, Customer.id, Customer.name from mock where Customer.id < 15 order by Customer.address.zipcode, Customer.id desc";
        query = engine.createQuery(sql);
        rs = engine.execute(query);
        numRows = 0;
        expectedCustomerId = 14L;
        while (rs.next()) {
            custId = rs.getLong(2);
            Assert.assertEquals((String)"expect descending even, then odd customer ids", (long)expectedCustomerId, (long)custId);
            ++numRows;
            expectedCustomerId = expectedCustomerId == 2L ? 13L : expectedCustomerId - 2L;
        }
        Assert.assertEquals((String)"expected 14 rows", (long)14L, (long)numRows);
    }

    @Test
    public void testLimit() {
        String sql = "select Customer from mock where Customer.id < 15 order by Customer.address.zipcode, Customer.id limit 5, 2";
        Query query = engine.createQuery(sql);
        QueryResultSet rs = engine.execute(query);
        int numRows = 0;
        long expectedCustomerId = 12L;
        while (rs.next()) {
            Customer cust = (Customer)rs.getObject(1);
            long custId = cust.getId();
            Assert.assertEquals((String)"expect even, then odd customer ids", (long)expectedCustomerId, (long)custId);
            ++numRows;
            expectedCustomerId = expectedCustomerId == 14L ? 1L : expectedCustomerId + 2L;
        }
        Assert.assertEquals((String)"expected 2 rows", (long)2L, (long)numRows);
    }

    @Test
    public void testInvalidFunction() {
        String sql = "select upper(Customer.id) from mock";
        try {
            engine.execute(sql);
            Assert.fail((String)"unsupported sql function");
        }
        catch (QueryException qe) {
            Assert.assertEquals((String)"wrong error", (Object)"Only classes or class fields may be used as query expressions", (Object)qe.getMessage());
        }
        sql = "select foo(Customer.id) from mock";
        try {
            engine.execute(sql);
            Assert.fail((String)"invalid sql function");
        }
        catch (QueryException qe) {
            Assert.assertEquals((String)"wrong error", (Object)"Only classes or class fields may be used as query expressions", (Object)qe.getMessage());
        }
    }

    @Test
    public void testComparatorBasedIndexing() {
        engine.executeStatement("create index type_n1 on mock(object.class)");
        String sql = "select * from mock where object.class = 'com.neeve.query.impl.mock.domain.Customer'";
        QueryResultSet rs = engine.execute(sql);
        while (rs.next()) {
            MockRecord rec = (MockRecord)rs.getObject(1);
            Customer cust = (Customer)rec.getObject();
            Assert.assertNotNull((String)"Customer should not be null", (Object)cust);
        }
        engine.executeStatement("drop index type_n1");
    }

    @Test
    public void testDropIndexByFieldName() {
        IdxField customerName = engine.getField("Customer.name");
        engine.executeStatement("create index cust_name_n1 on mock(Customer.name)");
        IdxIndex index = repo.getIndex(customerName);
        Assert.assertNotNull((String)"Index should have been created", index);
        engine.executeStatement("drop index Customer.name");
        index = repo.getIndex(customerName);
        Assert.assertNull((String)"Index should have been dropped", index);
    }

    @Test
    public void testClassLiterals() {
        Query query = engine.createQuery("select * from mock where object.class = 'com.neeve.query.impl.mock.domain.Customer'");
        QueryResultSet rs = engine.execute(query);
        int cnt = 0;
        while (rs.next()) {
            ++cnt;
        }
        Assert.assertEquals((String)"expect 25 customers", (long)25L, (long)cnt);
        query = engine.createQuery("select * from mock where object.class = 'com.neeve.query.impl.mock.domain.DataTypePayload$InnerClassExample'");
        rs = engine.execute(query);
        cnt = 0;
        while (rs.next()) {
            ++cnt;
        }
        Assert.assertEquals((String)"expect 1 inner class", (long)1L, (long)cnt);
        query = engine.createQuery("select * from mock where object.class = 'com.neeve.query.impl.mock.domain.DataTypePayload$1'");
        rs = engine.execute(query);
        cnt = 0;
        while (rs.next()) {
            ++cnt;
        }
        Assert.assertEquals((String)"expect 1 anon inner class", (long)1L, (long)cnt);
    }

    @Test
    public void testDistinct() {
        Query query = engine.createQuery("select Customer.address.city, Customer.address.zipcode from mock");
        QueryResultSet rs = engine.execute(query);
        int cnt = 0;
        while (rs.next()) {
            ++cnt;
        }
        Assert.assertEquals((String)"expect 25 rows", (long)25L, (long)cnt);
        query = engine.createQuery("select distinct Customer.address.city from mock");
        rs = engine.execute(query);
        cnt = 0;
        while (rs.next()) {
            ++cnt;
        }
        Assert.assertEquals((String)"expect 3 distinct cities", (long)3L, (long)cnt);
        query = engine.createQuery("select distinct Customer.address.zipcode from mock");
        rs = engine.execute(query);
        cnt = 0;
        while (rs.next()) {
            ++cnt;
        }
        Assert.assertEquals((String)"expect 2 distinct zipcode", (long)2L, (long)cnt);
        query = engine.createQuery("select distinct Customer.address.city, Customer.address.zipcode from mock");
        rs = engine.execute(query);
        cnt = 0;
        while (rs.next()) {
            ++cnt;
        }
        Assert.assertEquals((String)"expect 6 distinct city/zipcode combos", (long)6L, (long)cnt);
    }

    static {
        createIndexes = false;
    }
}

