/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods;

import cern.colt.function.IntObjectProcedure;
import cern.colt.map.OpenIntObjectHashMap;
import com.neeve.adm.runtime.AdmCompatibility;
import com.neeve.ods.IStoreObjectFactory;
import com.neeve.ods.OdsConfig;
import com.neeve.ods.OdsException;
import com.neeve.ods.OdsFactoryIdConflictException;
import com.neeve.ods.OdsObject;
import com.neeve.ods.StoreObjectFactoryDescriptor;
import com.neeve.root.RootConfig;
import com.neeve.trace.Tracer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class StoreObjectFactoryRegistry
extends OdsObject {
    public static final String ADM_COMPATIBILITY_LEVEL = "4.1.0";
    private static final StoreObjectFactoryRegistry instance;
    private static final OpenIntObjectHashMap objectFactories;

    private StoreObjectFactoryRegistry() {
        super(null);
    }

    public static final StoreObjectFactoryRegistry getInstance() {
        return instance;
    }

    public static final IStoreObjectFactory loadObjectFactory(String className) throws Exception {
        if (className != null) {
            Class<?> factoryClass = null;
            try {
                factoryClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new Exception("object factory class [" + className + "] could not be found");
            }
            catch (UnsupportedClassVersionError e) {
                throw new Exception("object factory class [" + className + "] is not supported by this VM <version=" + System.getProperty("java.vm.version") + ">");
            }
            Method factoryCreateMethod = null;
            try {
                Class[] parameterTypes = new Class[]{Class.forName("java.util.Properties")};
                factoryCreateMethod = factoryClass.getMethod("create", parameterTypes);
            }
            catch (ClassNotFoundException e) {
                throw new InternalError("Failed to load java.util.Properties during instantiation of ODS object factory class [" + className + "]");
            }
            catch (SecurityException e) {
                throw new Exception("Access to instantiation method in object factory class [" + className + "] is denied");
            }
            catch (NoSuchMethodException e) {
                throw new Exception("Instantiation method in object factory class [" + className + "] could not be found");
            }
            IStoreObjectFactory factory = null;
            try {
                try {
                    Object[] parameters = new Object[]{new Properties()};
                    factory = (IStoreObjectFactory)factoryCreateMethod.invoke(null, parameters);
                    if (factory == null) {
                        throw new Exception("Instantiation method in object factory class [" + className + "] returned a null object");
                    }
                }
                catch (ClassCastException e) {
                    throw new Exception("Instantiation method in object factory class [" + className + "] returned object of incorrect type");
                }
            }
            catch (IllegalAccessException e) {
                throw new Exception("Access to instantiation method in object factory class [" + className + "] is denied");
            }
            catch (InvocationTargetException e) {
                throw new Exception(e.getCause());
            }
            return factory;
        }
        return null;
    }

    public final void registerObjectFactory(String factoryClassName) throws Exception {
        this.registerObjectFactory(StoreObjectFactoryRegistry.loadObjectFactory(factoryClassName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerObjectFactory(IStoreObjectFactory factory) {
        OpenIntObjectHashMap openIntObjectHashMap = objectFactories;
        synchronized (openIntObjectHashMap) {
            StringBuilder builder = new StringBuilder();
            AdmCompatibility.getAdmGenerationDetails(factory.getClass(), (StringBuilder)builder);
            this.tracer.log("Registering ODS object factory (id=" + factory.getOfid() + ")..." + factory.getClass().getName() + " [" + builder.toString() + "]", Tracer.Level.VERBOSE);
            AdmCompatibility.assertRuntimeCompatibility((String)ADM_COMPATIBILITY_LEVEL, (Object)factory);
            objectFactories.put((int)factory.getOfid(), (Object)factory);
        }
    }

    public final boolean registerIfNoConflict(String factoryClassName) throws OdsFactoryIdConflictException, Exception {
        return this.registerIfNoConflict(StoreObjectFactoryRegistry.loadObjectFactory(factoryClassName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean registerIfNoConflict(IStoreObjectFactory factory) throws OdsFactoryIdConflictException {
        OpenIntObjectHashMap openIntObjectHashMap = objectFactories;
        synchronized (openIntObjectHashMap) {
            IStoreObjectFactory existing = (IStoreObjectFactory)objectFactories.get((int)factory.getOfid());
            if (existing != null) {
                if (existing.getClass() != factory.getClass()) {
                    throw new OdsFactoryIdConflictException("Factory conflicts with an already registered factory (" + existing.getClass().getName() + ").", existing, factory);
                }
                return false;
            }
            this.registerObjectFactory(factory);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IStoreObjectFactory getObjectFactory(short factoryId) {
        OpenIntObjectHashMap openIntObjectHashMap = objectFactories;
        synchronized (openIntObjectHashMap) {
            return (IStoreObjectFactory)objectFactories.get((int)factoryId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<String> getStoreObjectFactoryNames(final Set<String> factories) {
        if (factories == null) {
            throw new IllegalArgumentException("factories cannot be null");
        }
        OpenIntObjectHashMap openIntObjectHashMap = objectFactories;
        synchronized (openIntObjectHashMap) {
            objectFactories.forEachPair(new IntObjectProcedure(){

                public final boolean apply(int first, Object second) {
                    factories.add(((IStoreObjectFactory)second).getClass().getName());
                    return true;
                }
            });
        }
        return factories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dumpFactoryVersionInfo(final StringBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("appendable cannot be null");
        }
        OpenIntObjectHashMap openIntObjectHashMap = objectFactories;
        synchronized (openIntObjectHashMap) {
            objectFactories.forEachPair(new IntObjectProcedure(){

                public final boolean apply(int first, Object second) {
                    String className = second.getClass().getCanonicalName();
                    builder.append(className).append("(id=").append(((IStoreObjectFactory)second).getOfid()).append(")...");
                    AdmCompatibility.getAdmGenerationDetails(second.getClass(), (StringBuilder)builder);
                    builder.append("\n");
                    return true;
                }
            });
        }
    }

    static {
        block6: {
            instance = new StoreObjectFactoryRegistry();
            Tracer tracer = RootConfig.ObjectConfig.createTracer((RootConfig.ObjectConfig)OdsConfig.getConfig());
            tracer.log("Loading ODS object factories...", Tracer.Level.VERBOSE);
            objectFactories = new OpenIntObjectHashMap();
            try {
                Map<Short, StoreObjectFactoryDescriptor> objectFactoryDescriptors = StoreObjectFactoryDescriptor.loadAll();
                if (objectFactoryDescriptors.size() > 0) {
                    Set<Map.Entry<Short, StoreObjectFactoryDescriptor>> objectFactoryEntries = objectFactoryDescriptors.entrySet();
                    for (Map.Entry<Short, StoreObjectFactoryDescriptor> entry : objectFactoryEntries) {
                        StoreObjectFactoryDescriptor descriptor = entry.getValue();
                        String s = "..." + descriptor.getName();
                        try {
                            instance.registerObjectFactory(StoreObjectFactoryRegistry.loadObjectFactory(descriptor.getClassName()));
                            s = s + " - success";
                        }
                        catch (Exception e) {
                            s = s + " - failed [" + e.toString() + "]";
                        }
                        tracer.log(s, Tracer.Level.VERBOSE);
                    }
                    break block6;
                }
                tracer.log("...<No configured object factories>", Tracer.Level.VERBOSE);
            }
            catch (OdsException e) {
                tracer.log("Failure encountered while loading ODS object factories [" + e.toString() + "]", Tracer.Level.SEVERE);
            }
        }
    }
}

