/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm.test.unit.evo.v2.json;

import com.eaio.uuid.UUID;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.protobuf.ByteString;
import com.neeve.adm.runtime.annotations.AdmGenerated;
import com.neeve.adm.test.unit.evo.v2.json.EvoMessage;
import com.neeve.ci.XRuntime;
import com.neeve.ods.IStoreObject;
import com.neeve.ods.IStoreObjectFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.types.PktBodyText;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessageViewFactory;
import jargs.gnu.CmdLineParser;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.Properties;

@AdmGenerated(encoding="Json", compatLevel="4.1.0", admVersion="Unknown Version", date="12/5/25 9:27 AM", buildInfo="${build.version.string}")
public final class Factory
implements IStoreObjectFactory,
MessageViewFactory {
    public static final short OFID = -100;
    public static final short VFID = -100;
    public static final short TFID = -100;
    public static final short ID_EvoEntity = 200;
    public static final short ID_EvoMessage = 2;
    static final ObjectMapper mapper = new ObjectMapper();

    public static final Factory create(Properties props) {
        return new Factory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String generateJsonSchemas() throws Exception {
        boolean indentOutputEnabled = mapper.isEnabled(SerializationFeature.INDENT_OUTPUT);
        try {
            mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
            StringBuilder sb = new StringBuilder();
            StringWriter sw = new StringWriter();
            sb.append("EvoMessage ");
            mapper.writeValue((Writer)sw, (Object)mapper.generateJsonSchema(EvoMessage.class));
            sb.append(sw.toString()).append("\n\n");
            String string = sb.toString();
            return string;
        }
        finally {
            mapper.configure(SerializationFeature.INDENT_OUTPUT, indentOutputEnabled);
        }
    }

    private static final EvoMessage createEvoMessageFromJson(UUID id, String json) {
        try {
            return new EvoMessage(id, json);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static final EvoMessage createEvoMessageFromSerializedJson(UUID id, ByteBuffer serializedJson) {
        return Factory.createEvoMessageFromJson(id, ByteString.copyFrom((ByteBuffer)serializedJson).toStringUtf8());
    }

    private static final EvoMessage createEvoMessageFromSerializedJson(UUID id, byte[] serializedJson) {
        return Factory.createEvoMessageFromJson(id, ByteString.copyFrom((byte[])serializedJson).toStringUtf8());
    }

    public static final EvoMessage createEvoMessage() {
        return Factory.createEvoMessageFromJson(null, null);
    }

    public static final EvoMessage createEvoMessage(UUID id) {
        return Factory.createEvoMessageFromJson(id, null);
    }

    public static final EvoMessage createEvoMessageFromJson(String json) {
        return Factory.createEvoMessageFromJson(null, json);
    }

    public static final EvoMessage createEvoMessageFromRawJson(String json) {
        return Factory.createEvoMessageFromJson(json);
    }

    public static final EvoMessage createEvoMessageFromSerializedJson(ByteBuffer serializedJson) {
        return Factory.createEvoMessageFromSerializedJson(null, serializedJson);
    }

    public static final EvoMessage createEvoMessageFromSerializedRawJson(ByteBuffer serializedJson) {
        return Factory.createEvoMessageFromSerializedJson(serializedJson);
    }

    public static final EvoMessage createEvoMessageFromSerializedJson(byte[] serializedJson) {
        return Factory.createEvoMessageFromSerializedJson(null, serializedJson);
    }

    public static final EvoMessage createEvoMessageFromSerializedRawJson(byte[] serializedJson) {
        return Factory.createEvoMessageFromSerializedJson(serializedJson);
    }

    @Override
    public final short getOfid() {
        return -100;
    }

    @Override
    public final IStoreObject create(short type, UUID id, IStoreObject.EncodingType encodingType, PktPacket packet) {
        try {
            switch (encodingType) {
                case Json: {
                    switch (type) {
                        case 2: {
                            return Factory.createEvoMessageFromJson(id, ((PktBodyText)packet.getBody()).getText());
                        }
                    }
                    throw new RuntimeException("unknown object type: " + type);
                }
            }
            throw new RuntimeException("unknown encoding type: " + (Object)((Object)encodingType));
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public final short getVfid() {
        return -100;
    }

    public final MessageView create(short type) {
        try {
            switch (type) {
                case 2: {
                    return Factory.createEvoMessage();
                }
            }
            throw new RuntimeException("unknown messsage type: " + type);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public final MessageView wrap(short type, int encodingType, Object message) {
        try {
            switch (encodingType) {
                case 5: {
                    if (message instanceof String) {
                        String json3 = (String)message;
                        switch (type) {
                            case 2: {
                                return Factory.createEvoMessageFromJson(null, json3);
                            }
                        }
                        throw new RuntimeException("unknown message type: " + type);
                    }
                    if (message instanceof byte[]) {
                        switch (type) {
                            case 2: {
                                return Factory.createEvoMessageFromJson(null, ByteString.copyFrom((byte[])((byte[])message)).toStringUtf8());
                            }
                        }
                        throw new RuntimeException("unknown object type: " + type);
                    }
                    if (message instanceof ByteBuffer) {
                        switch (type) {
                            case 2: {
                                return Factory.createEvoMessageFromJson(null, ByteString.copyFrom((ByteBuffer)((ByteBuffer)message)).toStringUtf8());
                            }
                        }
                        throw new RuntimeException("unknown object type: " + type);
                    }
                    throw new RuntimeException("unsupported serialized form '" + message.getClass().getName() + "' for JSON encoded message");
                }
            }
            throw new RuntimeException("unknown encoding type: " + encodingType);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static final void printUsage() {
        System.err.println("Usage: Factory <options>");
        System.err.println("Options:");
        System.err.println("    [{-j, --jsonSchema} generate json schemas]");
        System.err.println("       Generate schemas for all elements handled by this factory to standard output. ");
        System.err.println("    [{-h, --help} print this help string]");
    }

    public static final void main(String[] args) throws Exception {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option jsonSchemaOption = parser.addBooleanOption('j', "jsonSchema");
        CmdLineParser.Option helpOption = parser.addBooleanOption('h', "help");
        try {
            parser.parse(args);
            if (!((Boolean)parser.getOptionValue(helpOption, (Object)false)).booleanValue()) {
                if (((Boolean)parser.getOptionValue(jsonSchemaOption, (Object)false)).booleanValue()) {
                    System.out.println(Factory.generateJsonSchemas());
                }
            } else {
                Factory.printUsage();
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            Factory.printUsage();
        }
    }

    static {
        mapper.configure(MapperFeature.USE_ANNOTATIONS, true).configure(MapperFeature.AUTO_DETECT_GETTERS, false).configure(MapperFeature.AUTO_DETECT_IS_GETTERS, false).configure(MapperFeature.AUTO_DETECT_FIELDS, false).configure(MapperFeature.AUTO_DETECT_SETTERS, false).configure(MapperFeature.AUTO_DETECT_CREATORS, false).configure(MapperFeature.USE_GETTERS_AS_SETTERS, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(SerializationFeature.INDENT_OUTPUT, XRuntime.getValue((String)"nv.indent.json", (boolean)false));
    }
}

