/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.OrderByList;
import com.akiban.sql.parser.PartitionByList;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.WindowList;
import com.akiban.sql.parser.WindowNode;

public final class WindowDefinitionNode
extends WindowNode {
    private boolean inlined;
    private PartitionByList partitionByList;
    private OrderByList orderByList;

    @Override
    public void init(Object arg1, Object arg2, Object arg3) throws StandardException {
        String name = (String)arg1;
        this.partitionByList = (PartitionByList)arg2;
        this.orderByList = (OrderByList)arg3;
        if (name != null) {
            super.init(arg1);
            this.inlined = false;
        } else {
            super.init("IN-LINE");
            this.inlined = true;
        }
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        WindowDefinitionNode other = (WindowDefinitionNode)node;
        this.inlined = other.inlined;
        this.partitionByList = (PartitionByList)this.getNodeFactory().copyNode(other.partitionByList, this.getParserContext());
        this.orderByList = (OrderByList)this.getNodeFactory().copyNode(other.orderByList, this.getParserContext());
    }

    @Override
    public String toString() {
        return "name: " + this.getName() + "\n" + "inlined: " + this.inlined + "\n" + "()\n";
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.partitionByList != null) {
            this.printLabel(depth, "partitionByList: ");
            this.partitionByList.treePrint(depth + 1);
        }
        if (this.orderByList != null) {
            this.printLabel(depth, "orderByList: ");
            this.orderByList.treePrint(depth + 1);
        }
    }

    public WindowDefinitionNode findEquivalentWindow(WindowList wl) {
        for (int i = 0; i < wl.size(); ++i) {
            WindowDefinitionNode old = (WindowDefinitionNode)wl.get(i);
            if (!this.isEquivalent(old)) continue;
            return old;
        }
        return null;
    }

    private boolean isEquivalent(WindowDefinitionNode other) {
        if (this.orderByList == null && other.getOrderByList() == null && this.partitionByList == null && other.getPartitionByList() == null) {
            return true;
        }
        assert (false) : "FIXME: ordering in windows not implemented yet";
        return false;
    }

    public boolean isInline() {
        return this.inlined;
    }

    public OrderByList getOrderByList() {
        return this.orderByList;
    }

    public PartitionByList getPartitionByList() {
        return this.partitionByList;
    }
}

