/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.license;

import com.neeve.license.License;
import com.neeve.license.LicenseCorruptException;
import com.neeve.license.LicenseException;
import com.neeve.license.LicenseExpiredException;
import com.neeve.license.LicenseNotFoundException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.RSAPublicKeySpec;
import org.apache.commons.codec.binary.Base64;

public final class LicenseVerifier {
    private static final boolean debug = Boolean.getBoolean("nv.license.debug");
    private static final String debugPrefix = "nv.license.verifier: ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final PublicKey readKey() throws Exception {
        ObjectInputStream oin = new ObjectInputStream(new BufferedInputStream(LicenseVerifier.class.getResource("/license.verifier.key").openStream()));
        try {
            BigInteger m = (BigInteger)oin.readObject();
            BigInteger e = (BigInteger)oin.readObject();
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(m, e);
            KeyFactory fact = KeyFactory.getInstance("RSA");
            PublicKey publicKey = fact.generatePublic(keySpec);
            return publicKey;
        }
        finally {
            oin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final URL verifyUrlIsReadable(URL url) {
        InputStream is;
        block12: {
            is = null;
            try {
                is = url.openStream();
                if (is == null) break block12;
            }
            catch (Throwable thrown) {
                try {
                    LicenseVerifier.debug("...could not open '" + url + "'");
                    URL uRL = null;
                    return uRL;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable thrown2) {}
                    }
                }
            }
            try {
                is.close();
            }
            catch (Throwable thrown) {}
        }
        if (is == null) return null;
        return url;
    }

    private static final URL verifyFileAsUrl(File file) {
        try {
            if (!file.exists()) {
                if (debug) {
                    LicenseVerifier.debug("...'" + file + "' does not exist");
                }
                return null;
            }
            if (!file.isFile()) {
                if (debug) {
                    LicenseVerifier.debug("...'" + file + "' not a file");
                }
                return null;
            }
            if (!file.canRead()) {
                if (debug) {
                    LicenseVerifier.debug("...'" + file + "' not readable");
                }
                return null;
            }
            return LicenseVerifier.verifyUrlIsReadable(file.toURI().toURL());
        }
        catch (Throwable throwable) {
            if (debug) {
                System.err.println("... error handling '" + file + "':");
                throwable.printStackTrace();
            }
            return null;
        }
    }

    private static final URL resolveLicenseFileFromUserHome(String name) {
        String location;
        if (debug) {
            LicenseVerifier.debug("checking for license in user home variable");
        }
        if ((location = System.getProperties().getProperty("user.home")) != null) {
            return LicenseVerifier.verifyFileAsUrl(new File(location + File.separator + name));
        }
        if (debug) {
            LicenseVerifier.debug("...user.home not set");
        }
        return null;
    }

    private static final URL resolveLicenseFileFromEnvironmentVariable(String name, String varname) {
        String location;
        if (debug) {
            LicenseVerifier.debug("checking for license environment variable '" + varname + "'");
        }
        if ((location = System.getenv(varname)) != null) {
            return LicenseVerifier.verifyFileAsUrl(new File(location + File.separator + name));
        }
        if (debug) {
            LicenseVerifier.debug("...not specified");
        }
        return null;
    }

    private static final URL resolveLicenseFileFromSystemProperty(String name, String propname) {
        String location;
        if (debug) {
            LicenseVerifier.debug("checking for license system property '" + propname + "'");
        }
        if ((location = System.getProperty(propname)) != null) {
            return LicenseVerifier.verifyFileAsUrl(new File(location + File.separator + name));
        }
        if (debug) {
            LicenseVerifier.debug("...not specified");
        }
        return null;
    }

    private static final URL resolveLicenseFromClasspath(String path) {
        URL url;
        if (debug) {
            LicenseVerifier.debug("checking for license in classpath '" + path + "'");
        }
        if ((url = LicenseVerifier.class.getResource(path)) != null) {
            return LicenseVerifier.verifyUrlIsReadable(url);
        }
        if (debug) {
            LicenseVerifier.debug("... not found");
        }
        return null;
    }

    private static final URL resolveLicenseFile(String name) {
        URL url = LicenseVerifier.resolveLicenseFileFromEnvironmentVariable(name, "NVLICLOCATION");
        if (url != null) {
            if (debug) {
                LicenseVerifier.debug("... license found");
            }
            return url;
        }
        url = LicenseVerifier.resolveLicenseFileFromEnvironmentVariable(name, "nv.lic.location");
        if (url != null) {
            if (debug) {
                LicenseVerifier.debug("... license found");
            }
            return url;
        }
        url = LicenseVerifier.resolveLicenseFileFromEnvironmentVariable(name, "nv_lic_location");
        if (url != null) {
            if (debug) {
                LicenseVerifier.debug("... license found");
            }
            return url;
        }
        url = LicenseVerifier.resolveLicenseFileFromSystemProperty(name, "NVLICLOCATION");
        if (url != null) {
            if (debug) {
                LicenseVerifier.debug("... license found");
            }
            return url;
        }
        url = LicenseVerifier.resolveLicenseFileFromSystemProperty(name, "nv.lic.location");
        if (url != null) {
            if (debug) {
                LicenseVerifier.debug("... license found");
            }
            return url;
        }
        url = LicenseVerifier.resolveLicenseFileFromSystemProperty(name, "nv_lic_location");
        if (url != null) {
            if (debug) {
                LicenseVerifier.debug("... license found");
            }
            return url;
        }
        url = LicenseVerifier.resolveLicenseFileFromUserHome(name);
        if (url != null) {
            if (debug) {
                LicenseVerifier.debug("... license found");
            }
            return url;
        }
        url = LicenseVerifier.resolveLicenseFromClasspath("/" + name);
        if (url != null) {
            if (debug) {
                LicenseVerifier.debug("... license found");
            }
            return url;
        }
        url = LicenseVerifier.resolveLicenseFromClasspath("/META-INF/nv-bundled-license/" + name);
        if (url != null) {
            if (debug) {
                LicenseVerifier.debug("... license found");
            }
            return url;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void verify(License license) {
        block9: {
            String signatureStr = license.getProperty("Key");
            if (signatureStr != null) {
                try {
                    byte[] signature = Base64.decodeBase64((byte[])signatureStr.getBytes());
                    license.remove((Object)"Key");
                    try {
                        Signature instance = Signature.getInstance("SHA1withRSA");
                        instance.initVerify(LicenseVerifier.readKey());
                        instance.update(license.toString().getBytes("UTF-8"));
                        if (instance.verify(signature)) {
                            if (!license.isPerpetual() && System.currentTimeMillis() > license.getExpiration().getTime()) {
                                throw new LicenseExpiredException(license.getExpiration());
                            }
                            break block9;
                        }
                        throw new LicenseCorruptException();
                    }
                    finally {
                        license.setProperty("Key", signatureStr);
                    }
                }
                catch (Throwable e) {
                    if (e instanceof LicenseException) {
                        throw (LicenseException)e;
                    }
                    throw new LicenseException(e);
                }
            }
            throw new LicenseCorruptException();
        }
    }

    public static final License locateAndVerify(String name) {
        URL url = LicenseVerifier.resolveLicenseFile(name != null ? name : "xplatform.lic");
        if (url != null) {
            try {
                if (debug) {
                    LicenseVerifier.debug("loading license from '" + url + "'");
                }
                License license = new License();
                license.load(url);
                if (debug) {
                    LicenseVerifier.debug("loaded license:\n====\n" + license + "\n=====");
                }
                LicenseVerifier.verify(license);
                return license;
            }
            catch (IOException e) {
                LicenseCorruptException lce = new LicenseCorruptException();
                lce.initCause(e);
                throw lce;
            }
        }
        throw new LicenseNotFoundException();
    }

    public static final License locateAndVerify() {
        return LicenseVerifier.locateAndVerify(null);
    }

    private static final void debug(String message) {
        System.err.println(debugPrefix + message);
    }
}

