/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util.test.unit;

import com.google.common.collect.Maps;
import com.neeve.util.UtlDistinctProxy;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;

public class UtlDistinctProxyTest {
    @Test
    public void testHashCode() {
        CharSequence a1 = UtlDistinctProxy.of("aaa");
        CharSequence a2 = UtlDistinctProxy.of("aaa");
        Assert.assertEquals((String)"hashCode should match self", (long)a1.hashCode(), (long)a1.hashCode());
        Assert.assertNotEquals((String)"hashCode should not match text", (long)a1.hashCode(), (long)"aaa".hashCode());
        Assert.assertNotEquals((String)"hashCode should not match proxy", (long)a1.hashCode(), (long)a2.hashCode());
    }

    @Test
    public void testEquals() {
        CharSequence a1 = UtlDistinctProxy.of("aaa");
        CharSequence a2 = UtlDistinctProxy.of("aaa");
        Assert.assertTrue((String)"proxy equal to self", (boolean)a1.equals(a1));
        Assert.assertFalse((String)"proxy not equal to target", (boolean)a1.equals("aaa"));
        Assert.assertFalse((String)"proxy not equal to another proxy", (boolean)a1.equals(a2));
        Assert.assertFalse((String)"proxy not equal to null", (boolean)a1.equals(null));
    }

    @Test
    public void testNonProxiedMethods() {
        CharSequence alpha = UtlDistinctProxy.of("abcde");
        Assert.assertEquals((String)"five letters", (long)5L, (long)alpha.length());
        Assert.assertEquals((String)"starts with 'a'", (long)97L, (long)alpha.charAt(0));
    }

    @Test
    public void testAsHashMapKeys() {
        HashMap map = Maps.newHashMap();
        CharSequence a1 = UtlDistinctProxy.of("aaa");
        CharSequence a2 = UtlDistinctProxy.of("aaa");
        map.put(a1, 1);
        map.put(a2, 2);
        Assert.assertEquals((String)"two elements", (long)2L, (long)map.size());
        Assert.assertEquals((String)"a1:1", (Object)1, map.get(a1));
        Assert.assertEquals((String)"a2:2", (Object)2, map.get(a2));
        map.put(a2, 20);
        Assert.assertEquals((String)"two elements", (long)2L, (long)map.size());
        Assert.assertEquals((String)"a1:1", (Object)1, map.get(a1));
        Assert.assertEquals((String)"a2:20", (Object)20, map.get(a2));
        map.remove(a1);
        Assert.assertEquals((String)"one elements", (long)1L, (long)map.size());
        Assert.assertEquals((String)"a2:20", (Object)20, map.get(a2));
        map.remove(a2);
        Assert.assertTrue((String)"now empty", (boolean)map.isEmpty());
    }
}

