/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.cli;

import com.neeve.cli.CliException;
import com.neeve.cli.CliParser;
import com.neeve.cli.ValueApplier;
import com.neeve.cli.annotations.Option;
import com.neeve.util.UtlDataTypes;
import java.io.File;
import java.util.Arrays;
import java.util.Currency;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public final class OptionHandler {
    private final ValueApplier applier;
    private final CliParser parser;
    private final CliParser.Option optionParser;
    private final Class<?> targetType;
    private final HashSet<String> validOptions;
    final Option option;

    OptionHandler(ValueApplier applier, CliParser parser, Option option) throws IllegalArgumentException, CliException {
        block7: {
            block6: {
                this.validOptions = new HashSet();
                if (applier.getTargetType().isArray()) {
                    throw new CliException("Invalid command parameter type '" + applier.getTargetType() + "' arrays are not supported parameter type for command executors.");
                }
                if (!UtlDataTypes.canConvert(String.class, applier.getTargetType())) {
                    throw new CliException("Invalid command parameter type '" + applier.getTargetType() + "' is not a supported parameter type for command executors.");
                }
                this.applier = applier;
                this.parser = parser;
                this.option = option;
                this.targetType = applier.getTargetType();
                this.optionParser = this.createOption();
                if (option.validOptions().length <= 0) break block6;
                for (String validOption : Arrays.asList(option.validOptions())) {
                    try {
                        UtlDataTypes.convert(applier.getTargetType(), validOption);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("'" + validOption + "', defined as a valid option for '" + option.longForm() + "' cannot be converted to the target type of '" + this.targetType + "'!");
                    }
                    this.validOptions.add(validOption);
                }
                break block7;
            }
            if (!this.targetType.isEnum()) break block7;
            String[] enumNames = UtlDataTypes.getEnumNames(applier.getTargetType());
            for (int i = 0; i < enumNames.length; ++i) {
                this.validOptions.add(enumNames[i]);
            }
        }
    }

    final void parseOption() throws Exception {
        Object val = null;
        if (!"<null>".equals(this.option.defaultValue())) {
            val = this.parser.getOptionValue(this.optionParser);
            if (val == null) {
                val = this.option.defaultValue();
            }
        } else {
            val = this.parser.getOptionValue(this.optionParser);
        }
        if (val == null && this.option.required()) {
            throw new IllegalArgumentException("Option " + this.option.longForm() + " is a required value");
        }
        if (!this.validOptions.isEmpty() && !this.validOptions.contains(String.valueOf(val))) {
            throw new IllegalArgumentException(val + " is not a valid option for " + this.option.longForm() + ". Expected one of " + this.validOptions);
        }
        this.applier.applyParsedValue(UtlDataTypes.convert(this.applier.getTargetType(), val));
    }

    private CliParser.Option createOption() throws IllegalArgumentException {
        if (this.targetType.isAssignableFrom(Boolean.class) || this.targetType == Boolean.TYPE) {
            return this.parser.addBooleanOption(this.option.shortForm(), this.option.longForm());
        }
        if (this.targetType.isAssignableFrom(Byte.class) || this.targetType == Byte.TYPE) {
            return this.parser.addIntegerOption(this.option.shortForm(), this.option.longForm());
        }
        if (this.targetType.isAssignableFrom(Short.class) || this.targetType == Short.TYPE) {
            return this.parser.addIntegerOption(this.option.shortForm(), this.option.longForm());
        }
        if (this.targetType.isAssignableFrom(Integer.class) || this.targetType == Integer.TYPE) {
            return this.parser.addIntegerOption(this.option.shortForm(), this.option.longForm());
        }
        if (this.targetType.isAssignableFrom(Double.class) || this.targetType == Double.TYPE) {
            return this.parser.addDoubleOption(this.option.shortForm(), this.option.longForm());
        }
        if (this.targetType.isAssignableFrom(Float.class) || this.targetType == Float.TYPE) {
            return this.parser.addStringOption(this.option.shortForm(), this.option.longForm());
        }
        if (this.targetType.isAssignableFrom(Long.class) || this.targetType == Long.TYPE) {
            return this.parser.addLongOption(this.option.shortForm(), this.option.longForm());
        }
        if (this.targetType.isAssignableFrom(Character.class) || this.targetType == Character.TYPE) {
            return this.parser.addStringOption(this.option.shortForm(), this.option.longForm());
        }
        if (this.targetType.isAssignableFrom(Currency.class)) {
            return this.parser.addStringOption(this.option.shortForm(), this.option.longForm());
        }
        if (this.targetType.isAssignableFrom(Date.class)) {
            return this.parser.addStringOption(this.option.shortForm(), this.option.longForm());
        }
        if (this.targetType.isAssignableFrom(String.class)) {
            return this.parser.addStringOption(this.option.shortForm(), this.option.longForm());
        }
        if (this.targetType.isAssignableFrom(File.class)) {
            return this.parser.addStringOption(this.option.shortForm(), this.option.longForm());
        }
        if (this.targetType.isEnum()) {
            return this.parser.addStringOption(this.option.shortForm(), this.option.longForm());
        }
        throw new IllegalArgumentException("Unsupported option field type " + this.targetType.getSimpleName());
    }

    public void appendUsage(StringBuilder out) {
        if (!this.option.required()) {
            out.append("[");
        }
        out.append("<-" + this.option.shortForm() + "|--" + this.option.longForm() + "> ");
        if (!this.validOptions.isEmpty()) {
            out.append("<");
            boolean first = true;
            for (String option : this.validOptions) {
                if (!first) {
                    out.append("|");
                }
                first = false;
                out.append(option);
            }
            out.append("> ");
        }
        out.append(this.option.description());
        if (!"<null>".equals(this.option.defaultValue())) {
            out.append(" (default='" + this.option.defaultValue() + "')");
        }
        if (!this.option.required()) {
            out.append("]");
        }
    }

    public void appendHtmlUsage(StringBuilder out) {
        if (!this.option.required()) {
            out.append("[");
        }
        out.append("<-" + this.option.shortForm() + "|--" + this.option.longForm() + "> ");
        if (!this.validOptions.isEmpty()) {
            out.append("<");
            boolean first = true;
            for (String option : this.validOptions) {
                if (!first) {
                    out.append("|");
                }
                first = false;
                out.append(option);
            }
            out.append("> ");
        }
        out.append(this.option.description());
        if (!"<null>".equals(this.option.defaultValue())) {
            out.append(" (default='" + this.option.defaultValue() + "')");
        }
        if (!this.option.required()) {
            out.append("]");
        }
    }

    public char getShortForm() {
        return this.option.shortForm();
    }

    public String getLongForm() {
        return this.option.longForm();
    }

    public String getDisplayName() {
        return "<null>".equals(this.option.displayName()) ? null : this.option.displayName();
    }

    public String getDefaultValue() {
        if (!"<null>".equals(this.option.defaultValue())) {
            return this.option.defaultValue();
        }
        return null;
    }

    public boolean getRequired() {
        return this.option.required();
    }

    public String getDescription() {
        if (!"<null>".equals(this.option.description())) {
            return this.option.description();
        }
        return null;
    }

    public Set<String> getValidValues() {
        return this.validOptions.isEmpty() ? null : this.validOptions;
    }

    public Class<?> getOptionType() {
        return this.applier.getTargetType();
    }
}

