/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.event.AepTransactionStageEvent;
import com.neeve.aep.test.unit.AepEngineTest;
import com.neeve.aep.test.unit.AepEngineTransactionStageEventTestApp;
import com.neeve.aep.test.unit.generated.proto.Factory;
import com.neeve.aep.test.unit.generated.proto.UpdateStateMessage;
import com.neeve.ci.XRuntime;
import com.neeve.rog.IRogMessage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class AepEngineTransactionStageEventTest
extends AepEngineTest {
    private static final int MESSAGE_COUNT = 100;

    private final List<IRogMessage> createMessages() {
        ArrayList<IRogMessage> list = new ArrayList<IRogMessage>();
        for (int i = 0; i < 100; ++i) {
            list.add(UpdateStateMessage.create());
        }
        return list;
    }

    private final void testTransactionStageEvent_StandaloneReceiver(boolean hasStore, boolean enableTransactionStageEvents) throws Exception {
        AepEngineTransactionStageEventTestApp sender = new AepEngineTransactionStageEventTestApp();
        AepEngine engine1 = this.createEngine("engine1", null, null, null, null, null, false, false, false, false, null, 1, 0, sender, null, null, 0, false, false, null, null, null, false, false);
        engine1.start();
        engine1.waitForMessagingToStart();
        AepEngineTransactionStageEventTestApp receiver = new AepEngineTransactionStageEventTestApp();
        String receiverName = "engine-" + System.currentTimeMillis();
        AepEngine engine2 = this.createEngine(receiverName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, hasStore, hasStore, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 1, 1, receiver, null, null, 0, enableTransactionStageEvents, false, null, null, null, false, false, null);
        engine2.registerFactory(Factory.create(null));
        engine2.start();
        engine2.waitForMessagingToStart();
        for (IRogMessage message : this.createMessages()) {
            ((AepEngine)((Object)this.engines.get(0))).sendMessage(sender.channel1, message);
        }
        Assert.assertTrue((boolean)receiver.waitForMessageReceipt(100));
        Thread.sleep(100L);
        this.waitForTransactionPipelineToEmpty(engine2);
        if (enableTransactionStageEvents) {
            Assert.assertEquals((long)101L, (long)receiver.counts.get((Object)AepTransactionStageEvent.TransactionStage.Start).intValue());
            if (hasStore) {
                Assert.assertEquals((long)101L, (long)receiver.counts.get((Object)AepTransactionStageEvent.TransactionStage.StoreCommitComplete).intValue());
            } else {
                Assert.assertNull((Object)receiver.counts.get((Object)AepTransactionStageEvent.TransactionStage.StoreCommitComplete));
            }
            Assert.assertEquals((long)101L, (long)receiver.counts.get((Object)AepTransactionStageEvent.TransactionStage.SendCommitComplete).intValue());
            Assert.assertEquals((long)101L, (long)receiver.counts.get((Object)AepTransactionStageEvent.TransactionStage.Complete).intValue());
        } else {
            Assert.assertNull((Object)receiver.counts.get((Object)AepTransactionStageEvent.TransactionStage.Start));
            Assert.assertNull((Object)receiver.counts.get((Object)AepTransactionStageEvent.TransactionStage.StoreCommitComplete));
            Assert.assertNull((Object)receiver.counts.get((Object)AepTransactionStageEvent.TransactionStage.SendCommitComplete));
            Assert.assertNull((Object)receiver.counts.get((Object)AepTransactionStageEvent.TransactionStage.Complete));
        }
    }

    private final void testTransactionStageEvent_ClusteredReceiver(boolean enableTransactionStageEvents) throws Exception {
        AepEngineTransactionStageEventTestApp sender = new AepEngineTransactionStageEventTestApp();
        AepEngine engine1 = this.createEngine("engine1", null, null, null, null, null, false, false, false, false, null, 1, 0, sender, null, null, 0, false, false, null, null, null, false, false);
        engine1.start();
        engine1.waitForMessagingToStart();
        String receiverName = "engine-" + System.currentTimeMillis() + "-" + AepEngineTest.engineCounter++;
        AepEngineTransactionStageEventTestApp receiver1 = new AepEngineTransactionStageEventTestApp();
        AepEngineTransactionStageEventTestApp receiver2 = new AepEngineTransactionStageEventTestApp();
        AepEngineTransactionStageEventTestApp expected = receiver1;
        AepEngine engine2 = this.createEngine(receiverName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 1, 1, receiver1, null, null, 0, enableTransactionStageEvents, false, null, null, null, false, false, null);
        engine2.registerFactory(Factory.create(null));
        engine2.start();
        engine2.waitForMessagingToStart();
        AepEngine engine3 = this.createEngine(receiverName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 1, 1, receiver2, null, null, 0, enableTransactionStageEvents, false, null, null, null, false, false, null);
        engine3.registerFactory(Factory.create(null));
        engine3.start();
        for (IRogMessage message : this.createMessages()) {
            engine1.sendMessage(sender.channel1, message);
        }
        Assert.assertTrue((boolean)receiver1.waitForMessageReceipt(100));
        Thread.sleep(100L);
        this.waitForTransactionPipelineToEmpty(engine2);
        if (enableTransactionStageEvents) {
            Assert.assertEquals((long)101L, (long)receiver1.counts.get((Object)AepTransactionStageEvent.TransactionStage.Start).intValue());
            Assert.assertEquals((long)101L, (long)receiver1.counts.get((Object)AepTransactionStageEvent.TransactionStage.StoreCommitComplete).intValue());
            Assert.assertEquals((long)101L, (long)receiver1.counts.get((Object)AepTransactionStageEvent.TransactionStage.SendCommitComplete).intValue());
            Assert.assertEquals((long)101L, (long)receiver1.counts.get((Object)AepTransactionStageEvent.TransactionStage.Complete).intValue());
        } else {
            Assert.assertNull((Object)receiver1.counts.get((Object)AepTransactionStageEvent.TransactionStage.Start));
            Assert.assertNull((Object)receiver1.counts.get((Object)AepTransactionStageEvent.TransactionStage.StoreCommitComplete));
            Assert.assertNull((Object)receiver1.counts.get((Object)AepTransactionStageEvent.TransactionStage.SendCommitComplete));
            Assert.assertNull((Object)receiver1.counts.get((Object)AepTransactionStageEvent.TransactionStage.Complete));
        }
        Assert.assertNull((Object)receiver2.counts.get((Object)AepTransactionStageEvent.TransactionStage.Start));
        Assert.assertNull((Object)receiver2.counts.get((Object)AepTransactionStageEvent.TransactionStage.StoreCommitComplete));
        Assert.assertNull((Object)receiver2.counts.get((Object)AepTransactionStageEvent.TransactionStage.SendCommitComplete));
        Assert.assertNull((Object)receiver2.counts.get((Object)AepTransactionStageEvent.TransactionStage.Complete));
    }

    @Test
    public void testTransactionStageEvent_StandaloneNonHAReceiver_TransactionStageEventsDisabled() throws Exception {
        this.testTransactionStageEvent_StandaloneReceiver(false, false);
    }

    @Test
    public void testTransactionStageEvent_StandaloneNonHAReceiver_TransactionStageEventsEnabled() throws Exception {
        this.testTransactionStageEvent_StandaloneReceiver(false, true);
    }

    @Test
    public void testTransactionStageEvent_StandaloneHAReceiver_TransactionStageEventsDisabled() throws Exception {
        this.testTransactionStageEvent_StandaloneReceiver(true, false);
    }

    @Test
    public void testTransactionStageEvent_StandaloneHAReceiver_TransactionStageEventsEnabled() throws Exception {
        this.testTransactionStageEvent_StandaloneReceiver(true, true);
    }

    @Test
    public void testTransactionStageEvent_ClusteredReceiver_TransactionStageEventsDisabled() throws Exception {
        this.testTransactionStageEvent_ClusteredReceiver(false);
    }

    @Test
    public void testTransactionStageEvent_ClusteredReceiver_TransactionStageEventsEnabled() throws Exception {
        this.testTransactionStageEvent_ClusteredReceiver(true);
    }
}

