/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.AepEngineDescriptor;
import com.neeve.aep.event.AepStuckAlertEvent;
import com.neeve.aep.test.unit.AepEngineStuckEventAlertTestApp;
import com.neeve.aep.test.unit.AepEngineTest;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.event.Event;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageView;
import com.neeve.sma.event.MessageEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AepEngineStuckEventAlertTest
extends AepEngineTest {
    String senderName;
    AepEngineStuckEventAlertTestApp sender;
    String receiverName;
    AepEngineStuckEventAlertTestApp receiver;
    AepEngineStuckEventAlertTestApp receiver2;

    @Before
    public final void setup() {
        this.senderName = "sender-" + System.currentTimeMillis();
        this.receiverName = "receiver-" + System.currentTimeMillis();
    }

    private final void setup(AepEngine.HAPolicy haPolicy) throws Exception {
        this.sender = new AepEngineStuckEventAlertTestApp();
        this.receiver = new AepEngineStuckEventAlertTestApp();
        this.engineCustomizer = new AepEngineTest.BaseEngineCusomizer(){

            @Override
            public void customizeEngine(AepEngineDescriptor descriptor) {
                descriptor.setStuckAlertEventThreshold(5);
            }
        };
        this.startSenderStandaloneReceiverStandalone(this.sender, null, this.receiverName, this.receiver, null, 31, 16, 31, 8, haPolicy, true, true, AepEngineTestObject.EncodingType.Proto);
        this.sender.engine = (AepEngine)((Object)this.engines.get(0));
        this.sender.engine.setAsynchronousEventHandler(this.sender);
        this.receiver.engine = (AepEngine)((Object)this.engines.get(1));
        this.receiver.engine.setAsynchronousEventHandler(this.receiver);
    }

    private final void setupClustered(AepEngine.HAPolicy haPolicy) throws Exception {
        this.sender = new AepEngineStuckEventAlertTestApp();
        this.receiver = new AepEngineStuckEventAlertTestApp();
        this.receiver2 = new AepEngineStuckEventAlertTestApp();
        this.engineCustomizer = new AepEngineTest.BaseEngineCusomizer(){

            @Override
            public void customizeEngine(AepEngineDescriptor descriptor) {
                descriptor.setStuckAlertEventThreshold(5);
            }
        };
        this.startSenderStandaloneReceiverRedundant(this.sender, null, this.receiverName, this.receiver, null, this.receiver2, null, 31, 16, 31, 8, haPolicy, true, false, 1, AepEngineTestObject.EncodingType.Proto);
        this.sender.engine = (AepEngine)((Object)this.engines.get(0));
        this.sender.engine.setAsynchronousEventHandler(this.sender);
        this.receiver.engine = (AepEngine)((Object)this.engines.get(1));
        this.receiver.engine.setAsynchronousEventHandler(this.receiver);
        this.receiver2.engine = (AepEngine)((Object)this.engines.get(2));
        this.receiver2.engine.setAsynchronousEventHandler(this.receiver2);
    }

    private final void sendMessage() {
        this.sender.messageReceived = false;
        AepEngineTestMessage message = new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto);
        message.getMessage().setMessageBus("aeptest1");
        message.getMessage().setMessageChannel("channel5");
        this.sender.engine.sendMessage(this.sender.channel5, message.getMessage());
    }

    private final void multiplexReceiverMessage() {
        this.sender.messageReceived = false;
        AepEngineTestMessage message = new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto);
        message.getMessage().setMessageBus("aeptest1");
        message.getMessage().setMessageChannel("channel5");
        MessageEvent msgEvent = MessageEvent.create((MessageBusBinding)this.receiver.channel5.getMessageBusBinding(), (MessageChannel)this.receiver.channel5, (MessageView)message.getMessage(), null);
        try {
            this.receiver.engine.getEventMultiplexer().multiplexEvent((Event)msgEvent, 0);
        }
        finally {
            msgEvent.dispose();
        }
    }

    private final void testNormalCompletion(AepEngine.HAPolicy haPolicy) throws Exception {
        this.setup(haPolicy);
        for (int i = 0; i < 10; ++i) {
            this.sendMessage();
        }
        this.sender.waitForMessageReceipt(10);
        Thread.sleep(10000L);
        Assert.assertFalse((String)"Unexpected stuck alert from sender", (boolean)this.sender.waitForEngineStuckAlert(1, 100L, new AepStuckAlertEvent.Reason[0]));
        Assert.assertFalse((String)"Unexpected stuck alert from receiver", (boolean)this.receiver.waitForEngineStuckAlert(1, 100L, new AepStuckAlertEvent.Reason[0]));
    }

    @Test
    public void testNormalCompletionEventSourcing() throws Exception {
        this.testNormalCompletion(AepEngine.HAPolicy.EventSourcing);
    }

    @Test
    public void testNormalCompletionStateReplication() throws Exception {
        this.testNormalCompletion(AepEngine.HAPolicy.StateReplication);
    }

    private final void testDroppedAckHang(AepEngine.HAPolicy haPolicy) throws Exception {
        this.setup(haPolicy);
        for (int i = 0; i < 10; ++i) {
            this.sendMessage();
        }
        this.sender.waitForMessageReceipt(11);
        this.messagingController.dropNextAck("aeptest1", this.receiverName);
        this.sendMessage();
        Assert.assertTrue((String)"Didn't get expected stuck alert from receiver", (boolean)this.receiver.waitForEngineStuckAlert(1, 20000L, AepStuckAlertEvent.Reason.HungTransactionPipeline));
        Assert.assertEquals((String)"Wrong transaction pipeline reported", (long)1L, (long)this.receiver.stuckAlerts.get(0).getIncompleteCommitCount());
        Assert.assertFalse((String)"Unexpected stuck alert from sender", (boolean)this.sender.waitForEngineStuckAlert(1, 100L, new AepStuckAlertEvent.Reason[0]));
    }

    @Test
    public void testDroppedAckHangEventSourcing() throws Exception {
        this.testDroppedAckHang(AepEngine.HAPolicy.EventSourcing);
    }

    @Test
    public void testDroppedAckHangStateReplication() throws Exception {
        this.testDroppedAckHang(AepEngine.HAPolicy.StateReplication);
    }

    private final void testFirstDroppedAckHang(AepEngine.HAPolicy haPolicy) throws Exception {
        this.setup(haPolicy);
        this.messagingController.dropNextAck("aeptest1", this.receiverName);
        this.sendMessage();
        Assert.assertTrue((String)"Didn't get expected stuck alert from receiver", (boolean)this.receiver.waitForEngineStuckAlert(1, 20000L, AepStuckAlertEvent.Reason.HungTransactionPipeline));
        Assert.assertEquals((String)"Wrong transaction pipeline reported", (long)1L, (long)this.receiver.stuckAlerts.get(0).getIncompleteCommitCount());
        Assert.assertFalse((String)"Unexpected stuck alert from sender", (boolean)this.sender.waitForEngineStuckAlert(1, 100L, new AepStuckAlertEvent.Reason[0]));
    }

    @Test
    public void testFirstDroppedAckHangEventSourcing() throws Exception {
        this.testFirstDroppedAckHang(AepEngine.HAPolicy.EventSourcing);
    }

    @Test
    public void testFirstDroppedAckHangStateReplication() throws Exception {
        this.testFirstDroppedAckHang(AepEngine.HAPolicy.StateReplication);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void testHungMessageHandler(AepEngine.HAPolicy haPolicy) throws Exception {
        this.setup(haPolicy);
        boolean receiverHung = false;
        int sent = 0;
        for (int i = 0; i < 100 && !receiverHung; ++i) {
            this.sendMessage();
            ++sent;
            if (this.receiver.engine.getStats().getNumCommitsCompleted() >= this.receiver.engine.getStats().getNumCommitsStarted() || receiverHung) continue;
            System.out.println("Hanging receiver message handler");
            this.receiver.hangNextReceipt(true);
            receiverHung = true;
            break;
        }
        System.out.println("Hanging receiver message handler");
        this.receiver.hangNextReceipt(true);
        try {
            receiverHung = this.receiver.waitForCommitCompletions(10, 2000L);
            if (receiverHung) {
                System.out.println("Checking for stuck alert");
                Assert.assertTrue((String)"Didn't get expected stuck alert from receiver", (boolean)this.receiver.waitForEngineStuckAlert(1, 20000L, AepStuckAlertEvent.Reason.HungTransactionPipeline));
            } else {
                System.out.println("Didn't reach stuck state");
            }
        }
        finally {
            System.out.println("Releasing receiver message handler");
            this.receiver.unhangReceipt();
            this.receiver.waitForCommitCompletions(sent, 10000L);
        }
        Assert.assertFalse((String)"Unexpected stuck alert from sender", (boolean)this.sender.waitForEngineStuckAlert(1, 100L, new AepStuckAlertEvent.Reason[0]));
    }

    @Test
    public void testHungMessageHandlerEventSourcing() throws Exception {
        this.testHungMessageHandler(AepEngine.HAPolicy.EventSourcing);
    }

    @Test
    public void testHungMessageHandlerStateReplication() throws Exception {
        this.testHungMessageHandler(AepEngine.HAPolicy.StateReplication);
    }

    private final void testHungMessageHandlerEmptyPipeline(AepEngine.HAPolicy haPolicy) throws Exception {
        this.setup(haPolicy);
        System.out.println("Hanging receiver message handler");
        this.receiver.hangNextReceipt(false);
        this.sendMessage();
        try {
            System.out.println("Checking for stuck alert");
            Assert.assertTrue((String)"Didn't get expected stuck alert from receiver", (boolean)this.receiver.waitForEngineStuckAlert(1, 20000L, AepStuckAlertEvent.Reason.HungEventHandler));
        }
        finally {
            System.out.println("Releasing receiver message handler");
            this.receiver.unhangReceipt();
            this.receiver.waitForCommitCompletions(1, 10000L);
        }
        Assert.assertFalse((String)"Unexpected stuck alert from sender", (boolean)this.sender.waitForEngineStuckAlert(1, 100L, new AepStuckAlertEvent.Reason[0]));
    }

    @Test
    public void testHungMessageHandlerEmptyPipelineEventSourcing() throws Exception {
        this.testHungMessageHandlerEmptyPipeline(AepEngine.HAPolicy.EventSourcing);
    }

    @Test
    public void testHungMessageHandlerEmptyPipelineStateReplication() throws Exception {
        this.testHungMessageHandlerEmptyPipeline(AepEngine.HAPolicy.StateReplication);
    }

    private final void testHungMessageHandlerMultiplexedMessageEmptyPipeline(AepEngine.HAPolicy haPolicy) throws Exception {
        this.setup(haPolicy);
        System.out.println("Hanging receiver message handler");
        this.receiver.hangNextReceipt(false);
        this.multiplexReceiverMessage();
        try {
            System.out.println("Checking for stuck alert");
            Assert.assertTrue((String)"Didn't get expected stuck alert from receiver", (boolean)this.receiver.waitForEngineStuckAlert(1, 20000L, AepStuckAlertEvent.Reason.HungEventHandler));
        }
        finally {
            System.out.println("Releasing receiver message handler");
            this.receiver.unhangReceipt();
            this.receiver.waitForCommitCompletions(1, 10000L);
        }
        Assert.assertFalse((String)"Unexpected stuck alert from sender", (boolean)this.sender.waitForEngineStuckAlert(1, 100L, new AepStuckAlertEvent.Reason[0]));
    }

    @Test
    public void testHungMessageHandlerMultiplexedMessageEmptyPipelineEventSourcing() throws Exception {
        this.testHungMessageHandlerMultiplexedMessageEmptyPipeline(AepEngine.HAPolicy.EventSourcing);
    }

    @Test
    public void testHungMessageHandlerMultiplexedMessageEmptyPipelineStateReplication() throws Exception {
        this.testHungMessageHandlerMultiplexedMessageEmptyPipeline(AepEngine.HAPolicy.StateReplication);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void testMessageHandlerHangTwice(AepEngine.HAPolicy haPolicy) throws Exception {
        block19: {
            int i;
            int sent;
            boolean receiverHung;
            block17: {
                this.setup(haPolicy);
                receiverHung = false;
                sent = 0;
                for (i = 0; i < 100 && !receiverHung; ++i) {
                    this.sendMessage();
                    ++sent;
                    if (this.receiver.engine.getStats().getNumCommitsCompleted() >= this.receiver.engine.getStats().getNumCommitsStarted() || receiverHung) continue;
                    System.out.println("Hanging receiver message handler");
                    this.receiver.hangNextReceipt(true);
                    receiverHung = true;
                    break;
                }
                try {
                    receiverHung = this.receiver.engine.getStats().getNumCommitsCompleted() < this.receiver.engine.getStats().getNumCommitsStarted();
                    System.out.println("Checking for stuck alert: Receiver Commits Started: " + this.receiver.engine.getStats().getNumCommitsStarted() + ",Receiver Commits Completed: " + this.receiver.engine.getStats().getNumCommitsCompleted());
                    if (receiverHung) {
                        try {
                            Assert.assertTrue((String)"Didn't get expected stuck alert from receiver", (boolean)this.receiver.waitForEngineStuckAlert(1, 20000L, AepStuckAlertEvent.Reason.HungTransactionPipeline));
                        }
                        finally {
                            System.out.println("Checked for stuck alert: Receiver Commits Started: " + this.receiver.engine.getStats().getNumCommitsStarted() + ",Receiver Commits Completed: " + this.receiver.engine.getStats().getNumCommitsCompleted());
                        }
                        Assert.assertFalse((String)"Shouldn't get 2 stuck alerts from same hang", (boolean)this.receiver.waitForEngineStuckAlert(2, 5000L, new AepStuckAlertEvent.Reason[0]));
                        break block17;
                    }
                    System.out.println("Didn't reach stuck state");
                }
                finally {
                    System.out.println("Releasing receiver message handler");
                    this.receiver.unhangReceipt();
                    receiverHung = false;
                    this.receiver.waitForMessageReceipt(sent);
                    this.receiver.waitForCommitCompletions(sent, 10000L);
                }
            }
            try {
                Assert.assertFalse((String)"Unexpected stuck alert from sender", (boolean)this.sender.waitForEngineStuckAlert(1, 100L, new AepStuckAlertEvent.Reason[0]));
                System.out.println("Sending more messages to verify new hang detected");
                for (i = 0; i < 100 && !receiverHung; ++i) {
                    this.sendMessage();
                    ++sent;
                    if (this.receiver.engine.getStats().getNumCommitsCompleted() >= this.receiver.engine.getStats().getNumCommitsStarted() || receiverHung) continue;
                    System.out.println("Hanging receiver message handler");
                    this.receiver.hangNextReceipt(true);
                    receiverHung = true;
                    break;
                }
                receiverHung = this.receiver.engine.getStats().getNumCommitsCompleted() < this.receiver.engine.getStats().getNumCommitsStarted();
                System.out.println("Checking for stuck alert: Receiver Commits Started: " + this.receiver.engine.getStats().getNumCommitsStarted() + ",Receiver Commits Completed: " + this.receiver.engine.getStats().getNumCommitsCompleted());
                if (receiverHung) {
                    System.out.println("Checking for stuck alert");
                    try {
                        Assert.assertTrue((String)"Didn't get expected stuck alert from receiver", (boolean)this.receiver.waitForEngineStuckAlert(2, 20000L, AepStuckAlertEvent.Reason.HungTransactionPipeline, AepStuckAlertEvent.Reason.HungTransactionPipeline));
                    }
                    finally {
                        System.out.println("Checked for stuck alert: Receiver Commits Started: " + this.receiver.engine.getStats().getNumCommitsStarted() + ",Receiver Commits Completed: " + this.receiver.engine.getStats().getNumCommitsCompleted());
                    }
                    Assert.assertFalse((String)"Shouldn't get 2 stuck alerts from same hang", (boolean)this.receiver.waitForEngineStuckAlert(3, 5000L, new AepStuckAlertEvent.Reason[0]));
                    break block19;
                }
                System.out.println("Didn't reach stuck state");
            }
            finally {
                System.out.println("Releasing receiver message handler");
                this.receiver.unhangReceipt();
                receiverHung = false;
                this.receiver.waitForMessageReceipt(sent);
                this.receiver.waitForCommitCompletions(sent, 10000L);
            }
        }
        Assert.assertFalse((String)"Unexpected stuck alert from sender", (boolean)this.sender.waitForEngineStuckAlert(1, 100L, new AepStuckAlertEvent.Reason[0]));
    }

    @Test
    public void testMessageHandlerHangTwiceEventSourcing() throws Exception {
        this.testMessageHandlerHangTwice(AepEngine.HAPolicy.EventSourcing);
    }

    @Test
    public void testMessageHandlerHangTwiceStateReplication() throws Exception {
        this.testMessageHandlerHangTwice(AepEngine.HAPolicy.StateReplication);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void testHungMessageHandlerClustered(AepEngine.HAPolicy haPolicy) throws Exception {
        this.setupClustered(haPolicy);
        boolean receiverHung = false;
        System.out.println("Hanging backup receiver message handler");
        this.receiver2.hangNextReceipt(false);
        int sent = 0;
        for (int i = 0; i < 2000 && !receiverHung; ++i) {
            this.sendMessage();
            ++sent;
        }
        try {
            System.out.println("Checking for stuck alert");
            Assert.assertTrue((String)"Didn't get expected stuck alert from backup receiver", (boolean)this.receiver.waitForEngineStuckAlert(1, 20000L, AepStuckAlertEvent.Reason.HungTransactionPipeline));
            Assert.assertTrue((String)"Didn't get expected stuck alert from primary receiver", (boolean)this.receiver2.waitForEngineStuckAlert(1, 20000L, AepStuckAlertEvent.Reason.HungEventHandler));
        }
        finally {
            System.out.println("Releasing receiver message handler");
            this.receiver2.unhangReceipt();
            this.receiver.waitForCommitCompletions(sent, 10000L);
        }
        Assert.assertFalse((String)"Unexpected stuck alert from sender", (boolean)this.sender.waitForEngineStuckAlert(1, 100L, new AepStuckAlertEvent.Reason[0]));
    }

    @Test
    public void testHungMessageHandlerEventSourcingClustered() throws Exception {
        this.testHungMessageHandlerClustered(AepEngine.HAPolicy.EventSourcing);
    }
}

