/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.AepEngineDescriptor;
import com.neeve.aep.EAepException;
import com.neeve.aep.EAepExpectationNotMetException;
import com.neeve.aep.test.unit.AepEngineStartWithExpectationsTestApp;
import com.neeve.aep.test.unit.AepEngineTest;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.ci.XRuntime;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStorePersister;
import java.io.File;
import org.junit.Assert;
import org.junit.Test;

public class AepEngineStartWithExpectationsTest
extends AepEngineTest {
    @Test(expected=EAepException.class)
    public void testStartWithExpectationsStandaloneInvalidRoleExpectationType() throws Exception {
        AepEngineStartWithExpectationsTestApp app = new AepEngineStartWithExpectationsTestApp();
        this.engineCustomizer = new AepEngineTest.BaseEngineCusomizer(){

            @Override
            public void customizeEngine(AepEngineDescriptor descriptor) {
                descriptor.setStartupExpectation(AepEngine.StartupExpectation.Role, TestEnum.Value);
            }
        };
        AepEngine engine = this.createEngine("app", null, null, null, null, null, false, false, false, false, null, 0, 0, app, null, null, 0, false, false, null, null, null, false, false);
        engine.start();
    }

    @Test(expected=EAepException.class)
    public void testStartWithExpectationsClusteredInvalidRoleExpectationType() throws Exception {
        AepEngineStartWithExpectationsTestApp app = new AepEngineStartWithExpectationsTestApp();
        this.engineCustomizer = new AepEngineTest.BaseEngineCusomizer(){

            @Override
            public void customizeEngine(AepEngineDescriptor descriptor) {
                descriptor.setStartupExpectation(AepEngine.StartupExpectation.Role, TestEnum.Value);
            }
        };
        AepEngine engine = this.createEngine("app", AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, false, false, false, null, 0, 0, app, null, null, 0, false, false, null, null, null, false, false);
        try {
            engine.start();
        }
        catch (EAepException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
            throw e;
        }
    }

    @Test
    public void testStartWithExpectationsStandaloneBackupRoleExpectationMatch() throws Exception {
        AepEngineStartWithExpectationsTestApp sender = new AepEngineStartWithExpectationsTestApp();
        this.engineCustomizer = new AepEngineTest.BaseEngineCusomizer(){

            @Override
            public void customizeEngine(AepEngineDescriptor descriptor) {
                descriptor.setStartupExpectation(AepEngine.StartupExpectation.Role, (Enum<?>)IStoreBinding.Role.Primary);
            }
        };
        AepEngine engine = this.createEngine("app", null, null, null, null, null, false, false, false, false, null, 0, 0, sender, null, null, 0, false, false, null, null, null, false, false);
        engine.start();
    }

    @Test(expected=EAepExpectationNotMetException.class)
    public void testStartWithExpectationsStandaloneBackupRoleExpectationMistmatch() throws Exception {
        AepEngineStartWithExpectationsTestApp sender = new AepEngineStartWithExpectationsTestApp();
        this.engineCustomizer = new AepEngineTest.BaseEngineCusomizer(){

            @Override
            public void customizeEngine(AepEngineDescriptor descriptor) {
                descriptor.setStartupExpectation(AepEngine.StartupExpectation.Role, (Enum<?>)IStoreBinding.Role.Backup);
            }
        };
        AepEngine engine = this.createEngine("app", null, null, null, null, null, false, false, false, false, null, 0, 0, sender, null, null, 0, false, false, null, null, null, false, false);
        try {
            engine.start();
        }
        catch (EAepExpectationNotMetException e) {
            Assert.assertSame((Object)((Object)AepEngine.StartupExpectation.Role), e.getUnmetExpectationType());
            Assert.assertSame((Object)IStoreBinding.Role.Backup, e.getUnmetExpectationValue());
            throw e;
        }
    }

    @Test(expected=EAepExpectationNotMetException.class)
    public void testStartWithExpectationsClusteredPrimaryRoleExpectationMistmatch() throws Exception {
        AepEngineStartWithExpectationsTestApp app1 = new AepEngineStartWithExpectationsTestApp();
        this.engineCustomizer = new AepEngineTest.BaseEngineCusomizer(){

            @Override
            public void customizeEngine(AepEngineDescriptor descriptor) {
                descriptor.setStartupExpectation(AepEngine.StartupExpectation.Role, (Enum<?>)IStoreBinding.Role.Primary);
            }
        };
        AepEngine engine1 = this.createEngine("app", AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, false, false, false, null, 0, 0, app1, null, null, 0, false, false, null, null, null, false, false);
        try {
            engine1.start();
        }
        catch (EAepException e) {
            Assert.fail((String)"primary expectation on a primary engine failed");
        }
        AepEngineStartWithExpectationsTestApp app2 = new AepEngineStartWithExpectationsTestApp();
        this.engineCustomizer = new AepEngineTest.BaseEngineCusomizer(){

            @Override
            public void customizeEngine(AepEngineDescriptor descriptor) {
                descriptor.setStartupExpectation(AepEngine.StartupExpectation.Role, (Enum<?>)IStoreBinding.Role.Primary);
            }
        };
        AepEngine engine2 = this.createEngine("app", AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, false, false, false, null, 0, 0, app2, null, null, 0, false, false, null, null, null, false, false);
        try {
            engine2.start();
        }
        catch (EAepExpectationNotMetException e) {
            Assert.assertSame((Object)((Object)AepEngine.StartupExpectation.Role), e.getUnmetExpectationType());
            Assert.assertSame((Object)IStoreBinding.Role.Primary, e.getUnmetExpectationValue());
            throw e;
        }
    }

    @Test
    public void testStartWithExpectationsClusteredPrimaryBackupRoleExpectationMatch() throws Exception {
        AepEngineStartWithExpectationsTestApp app1 = new AepEngineStartWithExpectationsTestApp();
        this.engineCustomizer = new AepEngineTest.BaseEngineCusomizer(){

            @Override
            public void customizeEngine(AepEngineDescriptor descriptor) {
                descriptor.setStartupExpectation(AepEngine.StartupExpectation.Role, (Enum<?>)IStoreBinding.Role.Primary);
            }
        };
        AepEngine engine1 = this.createEngine("app", AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, false, false, false, null, 0, 0, app1, null, null, 0, false, false, null, null, null, false, false);
        try {
            engine1.start();
        }
        catch (EAepException e) {
            Assert.fail((String)"primary expectation on a primary engine failed");
        }
        AepEngineStartWithExpectationsTestApp app2 = new AepEngineStartWithExpectationsTestApp();
        this.engineCustomizer = new AepEngineTest.BaseEngineCusomizer(){

            @Override
            public void customizeEngine(AepEngineDescriptor descriptor) {
                descriptor.setStartupExpectation(AepEngine.StartupExpectation.Role, (Enum<?>)IStoreBinding.Role.Backup);
            }
        };
        AepEngine engine2 = this.createEngine("app", AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, false, false, false, null, 0, 0, app2, null, null, 0, false, false, null, null, null, false, false);
        try {
            engine2.start();
        }
        catch (EAepException e) {
            Assert.fail((String)"backup expectation on a backup engine failed");
        }
    }

    @Test(expected=EAepExpectationNotMetException.class)
    public void testStartWithExpectationsClusteredBackupRoleExpectationMistmatch() throws Exception {
        AepEngineStartWithExpectationsTestApp app = new AepEngineStartWithExpectationsTestApp();
        this.engineCustomizer = new AepEngineTest.BaseEngineCusomizer(){

            @Override
            public void customizeEngine(AepEngineDescriptor descriptor) {
                descriptor.setStartupExpectation(AepEngine.StartupExpectation.Role, (Enum<?>)IStoreBinding.Role.Backup);
            }
        };
        AepEngine engine = this.createEngine("app", AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, false, false, false, null, 0, 0, app, null, null, 0, false, false, null, null, null, false, false);
        try {
            engine.start();
        }
        catch (EAepExpectationNotMetException e) {
            Assert.assertSame((Object)((Object)AepEngine.StartupExpectation.Role), e.getUnmetExpectationType());
            Assert.assertSame((Object)IStoreBinding.Role.Backup, e.getUnmetExpectationValue());
            throw e;
        }
    }

    @Test(expected=EAepException.class)
    public void testStartWithExpectationsInvalidLogEmptinessExpectationType() throws Exception {
        AepEngineStartWithExpectationsTestApp app = new AepEngineStartWithExpectationsTestApp();
        this.engineCustomizer = new AepEngineTest.BaseEngineCusomizer(){

            @Override
            public void customizeEngine(AepEngineDescriptor descriptor) {
                descriptor.setStartupExpectation(AepEngine.StartupExpectation.LogEmptiness, TestEnum.Value);
            }
        };
        AepEngine engine = this.createEngine("app", AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, false, false, false, null, 0, 0, app, null, null, 0, false, false, null, null, null, false, false);
        try {
            engine.start();
        }
        catch (EAepException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
            throw e;
        }
    }

    @Test
    public void testStartWithExpectationsClusteredStandaloneLogEmptinessExpectationMatch() throws Exception {
        String appName = "app-" + System.currentTimeMillis();
        AepEngineStartWithExpectationsTestApp app1 = new AepEngineStartWithExpectationsTestApp();
        this.engineCustomizer = new AepEngineTest.BaseEngineCusomizer(){

            @Override
            public void customizeEngine(AepEngineDescriptor descriptor) {
                descriptor.setStartupExpectation(AepEngine.StartupExpectation.LogEmptiness, (Enum<?>)IStorePersister.LogEmptinessExpectation.Empty);
            }
        };
        AepEngine engine1 = this.createEngine(appName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 0, 0, app1, null, null, 0, false, false, null, null, null, false, false);
        engine1.start();
        AepEngineStartWithExpectationsTestApp app2 = new AepEngineStartWithExpectationsTestApp();
        AepEngine engine2 = this.createEngine(appName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 0, 0, app2, null, null, 0, false, false, null, null, null, false, false);
        engine2.start();
        engine1.stop();
        engine2.stop();
        engine1 = this.createEngine(appName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 0, 0, app1, null, null, 0, false, false, null, null, null, false, false);
        engine1.start();
        engine2 = this.createEngine(appName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 0, 0, app2, null, null, 0, false, false, null, null, null, false, false);
        engine2.start();
        engine1.stop();
        long timeout = System.currentTimeMillis() + 5000L;
        while (engine2.getStore().getRole() == IStoreBinding.Role.Backup && System.currentTimeMillis() <= timeout) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((String)"Backup didn't become primary", (Object)IStoreBinding.Role.Primary, (Object)engine2.getStore().getRole());
    }

    @Test(expected=EAepExpectationNotMetException.class)
    public void testStartWithExpectationsClusteredStandaloneLogEmptinessExpectationMismatch() throws Exception {
        String appName = "app-" + System.currentTimeMillis();
        AepEngineStartWithExpectationsTestApp app1 = new AepEngineStartWithExpectationsTestApp();
        this.engineCustomizer = new AepEngineTest.BaseEngineCusomizer(){

            @Override
            public void customizeEngine(AepEngineDescriptor descriptor) {
                descriptor.setStartupExpectation(AepEngine.StartupExpectation.LogEmptiness, (Enum<?>)IStorePersister.LogEmptinessExpectation.Empty);
            }
        };
        AepEngine engine1 = this.createEngine(appName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 1, 1, app1, null, null, 0, false, false, null, null, null, false, false);
        engine1.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        try {
            engine1.start();
            engine1.waitForMessagingToStart();
        }
        catch (EAepException e) {
            Assert.fail((String)"primary expectation on a primary engine failed");
        }
        AepEngineStartWithExpectationsTestApp app2 = new AepEngineStartWithExpectationsTestApp();
        AepEngine engine2 = this.createEngine(appName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 1, 1, app2, null, null, 0, false, false, null, null, null, false, false);
        engine2.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        try {
            engine2.start();
        }
        catch (EAepException e) {
            Assert.fail((String)"backup expectation on a backup engine failed");
        }
        AepEngineTestMessage message = new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto);
        message.getMessage().setMessageBus("aeptest1");
        message.getMessage().setMessageChannel("channel1");
        engine1.sendMessage(app1.channel1, message.getMessage());
        Thread.sleep(1000L);
        engine1.stop();
        engine2.stop();
        engine1 = this.createEngine(appName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 0, 0, app1, null, null, 0, false, false, null, null, null, false, false);
        engine1.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        try {
            engine1.start();
        }
        catch (EAepExpectationNotMetException e) {
            Assert.assertSame((Object)((Object)AepEngine.StartupExpectation.LogEmptiness), e.getUnmetExpectationType());
            Assert.assertSame((Object)IStorePersister.LogEmptinessExpectation.Empty, e.getUnmetExpectationValue());
            throw e;
        }
    }

    @Test
    public void testStartWithExpectationsClusteredStandaloneLogNotEmptyPrimaryExpectationMisMatch() throws Exception {
        String appName = "app-" + System.currentTimeMillis();
        AepEngineStartWithExpectationsTestApp app1 = new AepEngineStartWithExpectationsTestApp();
        this.engineCustomizer = new AepEngineTest.BaseEngineCusomizer(){

            @Override
            public void customizeEngine(AepEngineDescriptor descriptor) {
                descriptor.setStartupExpectation(AepEngine.StartupExpectation.LogEmptiness, (Enum<?>)IStorePersister.LogEmptinessExpectation.NotEmpty);
            }
        };
        AepEngine engine1 = this.createEngine(appName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 0, 0, app1, null, null, 0, false, false, null, null, null, false, false);
        try {
            engine1.start();
            Assert.fail((String)"Empty log should have caused failure on on open.");
        }
        catch (EAepExpectationNotMetException e) {
            Assert.assertEquals((Object)((Object)AepEngine.StartupExpectation.LogEmptiness), e.getUnmetExpectationType());
            Assert.assertEquals((Object)IStorePersister.LogEmptinessExpectation.NotEmpty, e.getUnmetExpectationValue());
        }
    }

    @Test
    public void testStartWithExpectationsClusteredStandaloneLogNotEmptyBackupExpectationMisMatch() throws Exception {
        String appName = "app-" + System.currentTimeMillis();
        AepEngineStartWithExpectationsTestApp app1 = new AepEngineStartWithExpectationsTestApp();
        this.engineCustomizer = new AepEngineTest.BaseEngineCusomizer(){

            @Override
            public void customizeEngine(AepEngineDescriptor descriptor) {
                descriptor.setStartupExpectation(AepEngine.StartupExpectation.LogEmptiness, (Enum<?>)IStorePersister.LogEmptinessExpectation.Empty);
            }
        };
        AepEngine engine1 = this.createEngine(appName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 0, 0, app1, null, null, 0, false, false, null, null, null, false, false);
        engine1.start();
        AepEngineStartWithExpectationsTestApp app2 = new AepEngineStartWithExpectationsTestApp();
        this.engineCustomizer = new AepEngineTest.BaseEngineCusomizer(){

            @Override
            public void customizeEngine(AepEngineDescriptor descriptor) {
                descriptor.setStartupExpectation(AepEngine.StartupExpectation.LogEmptiness, (Enum<?>)IStorePersister.LogEmptinessExpectation.NotEmpty);
            }
        };
        AepEngine engine2 = this.createEngine(appName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 0, 0, app2, null, null, 0, false, false, null, null, null, false, false);
        try {
            engine2.start();
        }
        catch (EAepExpectationNotMetException e) {
            Assert.fail((String)"Backup not expected to fail on LogEmptiness Expectation");
        }
    }

    @Test
    public void testStartWithExpectationsClusteredStandaloneLogNotEmptyExpectationMatch() throws Exception {
        String appName = "app-" + System.currentTimeMillis();
        AepEngineStartWithExpectationsTestApp app1 = new AepEngineStartWithExpectationsTestApp();
        this.engineCustomizer = new AepEngineTest.BaseEngineCusomizer(){

            @Override
            public void customizeEngine(AepEngineDescriptor descriptor) {
                System.err.println("Setting " + (Object)((Object)AepEngine.StartupExpectation.LogEmptiness) + " to " + IStorePersister.LogEmptinessExpectation.Empty + " for " + descriptor.getName());
                descriptor.setStartupExpectation(AepEngine.StartupExpectation.LogEmptiness, (Enum<?>)IStorePersister.LogEmptinessExpectation.Empty);
            }
        };
        AepEngine engine1 = this.createEngine(appName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 1, 1, app1, null, null, 0, false, false, null, null, null, false, false);
        engine1.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        try {
            engine1.start();
            engine1.waitForMessagingToStart();
        }
        catch (EAepExpectationNotMetException e) {
            Assert.fail((String)("primary expectation on a primary engine failed: " + (Object)((Object)e)));
        }
        AepEngineStartWithExpectationsTestApp app2 = new AepEngineStartWithExpectationsTestApp();
        AepEngine engine2 = this.createEngine(appName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 1, 1, app2, null, null, 0, false, false, null, null, null, false, false);
        engine2.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        try {
            engine2.start();
        }
        catch (EAepExpectationNotMetException e) {
            Assert.fail((String)("backup expectation on a backup engine failed: " + (Object)((Object)e)));
        }
        AepEngineTestMessage message = new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto);
        message.getMessage().setMessageBus("aeptest1");
        message.getMessage().setMessageChannel("channel1");
        engine1.sendMessage(app1.channel1, message.getMessage());
        Thread.sleep(1000L);
        engine1.stop();
        engine2.stop();
        this.engineCustomizer = new AepEngineTest.BaseEngineCusomizer(){

            @Override
            public void customizeEngine(AepEngineDescriptor descriptor) {
                descriptor.setStartupExpectation(AepEngine.StartupExpectation.LogEmptiness, (Enum<?>)IStorePersister.LogEmptinessExpectation.NotEmpty);
            }
        };
        engine1 = this.createEngine(appName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 0, 0, app1, null, null, 0, false, false, null, null, null, false, false);
        engine1.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine1.start();
        engine2 = this.createEngine(appName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 1, 1, app2, null, null, 0, false, false, null, null, null, false, false);
        engine2.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine2.start();
        engine1.stop();
        long timeout = System.currentTimeMillis() + 5000L;
        while (engine2.getStore().getRole() == IStoreBinding.Role.Backup && System.currentTimeMillis() <= timeout) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((String)"Backup didn't become primary", (Object)IStoreBinding.Role.Primary, (Object)engine2.getStore().getRole());
    }

    private static enum TestEnum {
        Value;

    }
}

