/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.AepScheduleEvent;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.event.AepEngineStoppedEvent;
import com.neeve.aep.event.AepMessagingPrestartEvent;
import com.neeve.aep.event.AepMessagingStartedEvent;
import com.neeve.aep.event.AepTransactionStageEvent;
import com.neeve.aep.test.unit.AepEngineScheduleTest;
import com.neeve.aep.test.unit.AepEngineTestApp;
import com.neeve.aep.test.unit.generated.proto.Message;
import com.neeve.aep.test.unit.generated.proto.MultiplexTriggerMessage;
import com.neeve.aep.test.unit.generated.proto.ScheduleAndCancelTriggerMessage;
import com.neeve.aep.test.unit.generated.proto.ScheduleCancelTriggerMessage;
import com.neeve.aep.test.unit.generated.proto.ScheduleTriggerMessage;
import com.neeve.rog.IRogMessage;
import com.neeve.sma.MessageView;
import org.junit.Assert;

public final class AepEngineScheduleTestApp
extends AepEngineTestApp {
    private Object messageReceiptWaitObject = new Object();
    private Object objectReceiptWaitObject = new Object();
    private Object cancelWaitObject = new Object();
    AepEngine engine;
    boolean scheduleObject;
    int scheduleDelay;
    AepScheduleEvent.HAPolicy scheduleHAPolicy = AepScheduleEvent.HAPolicy.Cancel;
    int receiptTimeout = 2000;
    boolean scheduleOnMessagingStarted;
    boolean cancelOnMessagingStarted;
    boolean cancelOnDispatch;
    IRogMessage firstMessage;
    IRogMessage lastMultiplexedMessage;
    IRogMessage lastScheduledMessage;
    Object lastScheduledObject;
    AepScheduleEvent lastScheduleEvent;
    IRogMessage lastMessage;
    Object lastObject;
    int messageCount;
    int objectCount;
    boolean scheduled;
    boolean engineStopped;
    long messageTs;
    long storeCommitCompleteTs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean waitForMessageReceipt() throws Exception {
        Object object = this.messageReceiptWaitObject;
        synchronized (object) {
            if (this.lastMessage == null) {
                this.messageReceiptWaitObject.wait(this.receiptTimeout > 0 ? (long)this.receiptTimeout : 1000L);
            }
            return this.lastMessage != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean waitForObjectReceipt() throws Exception {
        Object object = this.objectReceiptWaitObject;
        synchronized (object) {
            if (this.lastObject == null) {
                this.objectReceiptWaitObject.wait(this.receiptTimeout > 0 ? (long)this.receiptTimeout : 1000L);
            }
            return this.lastObject != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean waitForObjectCount(int expected) throws Exception {
        Object object = this.objectReceiptWaitObject;
        synchronized (object) {
            long now;
            long totalTime = (expected - this.objectCount) * this.receiptTimeout;
            totalTime = totalTime > 0L ? totalTime : 1000L;
            long ts = System.currentTimeMillis();
            while (this.objectCount < expected && (now = System.currentTimeMillis()) - ts < totalTime) {
                this.objectReceiptWaitObject.wait(totalTime - (now - ts));
            }
            return this.objectCount >= expected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean waitForCancel() throws Exception {
        Object object = this.cancelWaitObject;
        synchronized (object) {
            if (this.scheduled) {
                this.cancelWaitObject.wait(2000L);
            }
            return !this.scheduled;
        }
    }

    final boolean waitForEngineStopped() {
        for (int i = 0; i < 10; ++i) {
            if (!this.engineStopped) {
                System.out.println("Engine not stopped");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            return true;
        }
        return false;
    }

    @EventHandler
    public void onMessagingPrestart(AepMessagingPrestartEvent event) {
        if (this.firstMessage != null) {
            event.setFirstMessage((MessageView)this.firstMessage);
        }
    }

    @EventHandler
    public void onMessagingStarted(AepMessagingStartedEvent event) {
        if (this.scheduleOnMessagingStarted) {
            if (this.scheduleObject) {
                this.lastScheduledObject = new Object();
                this.lastScheduleEvent = this.engine.scheduleObject(this.lastScheduledObject, this.scheduleDelay);
                this.lastScheduleEvent.acquire();
            } else {
                this.lastScheduledMessage = Message.create();
                this.lastScheduleEvent = this.engine.scheduleMessage(this.lastScheduledMessage, this.scheduleDelay);
                this.lastScheduleEvent.acquire();
            }
        } else if (this.cancelOnMessagingStarted) {
            this.engine.cancelSchedule(this.lastScheduleEvent);
        }
    }

    @EventHandler
    public void onTransactionStage(AepTransactionStageEvent event) {
        if (event.getStage() == AepTransactionStageEvent.TransactionStage.StoreCommitComplete) {
            this.storeCommitCompleteTs = System.currentTimeMillis();
        }
    }

    @EventHandler
    public void onProtoMessageHandler(MultiplexTriggerMessage message) {
        this.lastMultiplexedMessage = Message.create();
        this.engine.injectMessage(this.lastMultiplexedMessage);
        this.scheduled = false;
    }

    @EventHandler
    public void onProtoMessageHandler(ScheduleTriggerMessage message) {
        if (this.scheduleObject) {
            this.lastScheduledObject = new Object();
            this.lastScheduleEvent = this.engine.scheduleObject(this.lastScheduledObject, this.scheduleDelay, this.scheduleHAPolicy);
            this.lastScheduleEvent.acquire();
            AepEngineScheduleTest.validateScheduleEvent(this.lastScheduleEvent, AepScheduleEvent.State.NotActivated, null, this.lastScheduledObject, this.scheduleDelay > 0, this.scheduleDelay);
        } else {
            this.lastScheduledMessage = Message.create();
            this.lastScheduleEvent = this.engine.scheduleMessage(this.lastScheduledMessage, this.scheduleDelay, this.scheduleHAPolicy);
            this.lastScheduleEvent.acquire();
            AepEngineScheduleTest.validateScheduleEvent(this.lastScheduleEvent, AepScheduleEvent.State.NotActivated, this.lastScheduledMessage, null, false, this.scheduleDelay);
        }
        this.scheduled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    public void onProtoMessageHandler(ScheduleCancelTriggerMessage message) {
        this.engine.cancelSchedule(this.lastScheduleEvent);
        Object object = this.cancelWaitObject;
        synchronized (object) {
            this.scheduled = false;
            this.cancelWaitObject.notifyAll();
        }
    }

    @EventHandler
    public void onProtoMessageHandler(ScheduleAndCancelTriggerMessage message) {
        if (this.scheduleObject) {
            this.lastScheduledObject = new Object();
            this.lastScheduleEvent = this.engine.scheduleObject(this.lastScheduledObject, this.scheduleDelay);
            this.lastScheduleEvent.acquire();
        } else {
            this.lastScheduledMessage = Message.create();
            this.lastScheduleEvent = this.engine.scheduleMessage(this.lastScheduledMessage, this.scheduleDelay);
            this.lastScheduleEvent.acquire();
        }
        this.engine.cancelSchedule(this.lastScheduleEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    public void onProtoMessageHandler(Message message) {
        this.messageTs = System.currentTimeMillis();
        Assert.assertNotNull((Object)message.getTag(0));
        Assert.assertNotNull((Object)message.getTag(1));
        if (this.scheduled) {
            Assert.assertNotNull((Object)message.getTag(4));
        }
        if (this.cancelOnDispatch) {
            this.engine.cancelSchedule((AepScheduleEvent)((Object)message.getTag(4)));
        }
        Object object = this.messageReceiptWaitObject;
        synchronized (object) {
            this.lastMessage = message;
            this.lastMessage.acquire();
            ++this.messageCount;
            this.messageReceiptWaitObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    public void onScheduleEvent(AepScheduleEvent event) {
        if (this.cancelOnDispatch) {
            this.engine.cancelSchedule(event);
        }
        Object object = this.objectReceiptWaitObject;
        synchronized (object) {
            this.lastObject = event.getObject();
            ++this.objectCount;
            this.objectReceiptWaitObject.notifyAll();
        }
    }

    @EventHandler
    public void onEngineStopped(AepEngineStoppedEvent event) {
        this.engineStopped = true;
    }
}

