/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.AepScheduleEvent;
import com.neeve.aep.test.unit.AepEngineScheduleTestApp;
import com.neeve.aep.test.unit.AepEngineTest;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestMultiplexTriggerMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.aep.test.unit.AepEngineTestScheduleAndCancelTriggerMessage;
import com.neeve.aep.test.unit.AepEngineTestScheduleCancelTriggerMessage;
import com.neeve.aep.test.unit.AepEngineTestScheduleTriggerMessage;
import com.neeve.ci.XRuntime;
import com.neeve.event.IEventAcknowledger;
import com.neeve.rog.IRogMessage;
import java.io.File;
import org.junit.Assert;
import org.junit.Test;

public class AepEngineScheduleTest
extends AepEngineTest {
    static final void validateScheduleEvent(AepScheduleEvent event, AepScheduleEvent.State state, IRogMessage message, Object object, boolean repeating, int delay) {
        Assert.assertEquals((Object)((Object)state), (Object)((Object)event.getState()));
        Assert.assertEquals((Object)message, (Object)event.getMessage());
        Assert.assertEquals((Object)object, (Object)event.getObject());
        Assert.assertEquals((Object)repeating, (Object)event.isRepeating());
        Assert.assertEquals((long)delay, (long)event.getDelay());
    }

    private final AepEngineTestMultiplexTriggerMessage createMultiplexTriggerMessage(AepEngineTestObject.EncodingType encodingType) {
        return new AepEngineTestMultiplexTriggerMessage(encodingType);
    }

    private final AepEngineTestScheduleTriggerMessage createScheduleTriggerMessage(AepEngineTestObject.EncodingType encodingType) {
        return new AepEngineTestScheduleTriggerMessage(encodingType);
    }

    private final AepEngineTestScheduleCancelTriggerMessage createScheduleCancelTriggerMessage(AepEngineTestObject.EncodingType encodingType) {
        return new AepEngineTestScheduleCancelTriggerMessage(encodingType);
    }

    private final AepEngineTestScheduleAndCancelTriggerMessage createScheduleAndCancelTriggerMessage(AepEngineTestObject.EncodingType encodingType) {
        return new AepEngineTestScheduleAndCancelTriggerMessage(encodingType);
    }

    private final AepEngineTestMessage createMessage(AepEngineTestObject.EncodingType encodingType) {
        return new AepEngineTestMessage(encodingType);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMultiplexNullMessage() throws Exception {
        AepEngineScheduleTestApp app = new AepEngineScheduleTestApp();
        String appName = "engine-" + System.currentTimeMillis();
        AepEngine engine = this.createEngine(appName, AepEngine.HAPolicy.StateReplication, null, null, null, null, false, false, false, false, null, 1, 1, app, null, null, 0, false, false, null, null, null, false, false);
        engine.injectMessage(null);
    }

    @Test(expected=IllegalStateException.class)
    public void testMultiplexMessageOnNonStartedEngine() throws Exception {
        AepEngineScheduleTestApp app = new AepEngineScheduleTestApp();
        String appName = "engine-" + System.currentTimeMillis();
        AepEngine engine = this.createEngine(appName, AepEngine.HAPolicy.StateReplication, null, null, null, null, false, false, false, false, null, 1, 1, app, null, null, 0, false, false, null, null, null, false, false);
        IRogMessage message = this.createMessage(AepEngineTestObject.EncodingType.Proto).getMessage();
        engine.injectMessage(message);
    }

    private void testinjectMessageFromOutsideOfHandler(AepEngine.HAPolicy haPolicy, AepEngineTestObject.EncodingType encodingType) throws Exception {
        AepEngine engine12;
        AepEngine engine11;
        AepEngineScheduleTestApp app11 = new AepEngineScheduleTestApp();
        String app1Name = "engine-" + System.currentTimeMillis();
        app11.engine = engine11 = this.createEngine(app1Name, haPolicy, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 1, 1, app11, null, null, 0, false, false, null, null, null, false, false);
        engine11.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine11.start();
        engine11.waitForMessagingToStart();
        IRogMessage message = this.createMessage(encodingType).getMessage();
        engine11.injectMessage(message);
        Assert.assertTrue((boolean)app11.waitForMessageReceipt());
        Assert.assertEquals((long)1L, (long)app11.messageCount);
        Assert.assertSame((Object)message, (Object)app11.lastMessage);
        AepEngineScheduleTestApp app12 = new AepEngineScheduleTestApp();
        app12.engine = engine12 = this.createEngine(app1Name, haPolicy, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 1, 1, app12, null, null, 0, false, false, null, null, null, false, false);
        engine12.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine12.start();
        switch (haPolicy) {
            case EventSourcing: {
                Assert.assertEquals((long)1L, (long)app12.messageCount);
                Assert.assertNotSame((Object)message, (Object)app12.lastMessage);
                Assert.assertEquals((long)message.getPreProcessingTs(), (long)app12.lastMessage.getPreProcessingTs());
                break;
            }
            case StateReplication: {
                Assert.assertNull((Object)app12.lastMessage);
            }
        }
        app12.lastMessage = null;
        app11.lastMessage = null;
        message = this.createMessage(encodingType).getMessage();
        engine11.injectMessage(message);
        Assert.assertTrue((boolean)app11.waitForMessageReceipt());
        Assert.assertEquals((long)2L, (long)app11.messageCount);
        Assert.assertSame((Object)message, (Object)app11.lastMessage);
        engine12.stop();
        app12.waitForEngineStopped();
        engine11.stop();
        app11.waitForEngineStopped();
        long preProcessingTs = haPolicy == AepEngine.HAPolicy.EventSourcing ? message.getPreProcessingTs() : 0L;
        app11 = new AepEngineScheduleTestApp();
        app11.engine = engine11 = this.createEngine(app1Name, haPolicy, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 1, 1, app11, null, null, 0, false, false, null, null, null, false, false);
        engine11.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine11.start();
        engine11.waitForMessagingToStart();
        switch (haPolicy) {
            case EventSourcing: {
                Assert.assertNotNull((Object)app11.lastMessage);
                Assert.assertEquals((long)2L, (long)app11.messageCount);
                Assert.assertNotSame((Object)message, (Object)app11.lastMessage);
                Assert.assertEquals((long)preProcessingTs, (long)app11.lastMessage.getPreProcessingTs());
                break;
            }
            case StateReplication: {
                Assert.assertNull((Object)app11.lastMessage);
            }
        }
    }

    @Test
    public void testinjectMessageFromOutsideOfHandlerEventSourcingProto() throws Exception {
        this.testinjectMessageFromOutsideOfHandler(AepEngine.HAPolicy.EventSourcing, AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testinjectMessageFromOutsideOfHandlerStateReplicationProto() throws Exception {
        this.testinjectMessageFromOutsideOfHandler(AepEngine.HAPolicy.StateReplication, AepEngineTestObject.EncodingType.Proto);
    }

    private void testinjectMessageFromInsideOfMessageHandler(AepEngine.HAPolicy haPolicy, AepEngineTestObject.EncodingType encodingType) throws Exception {
        AepEngine engine12;
        AepEngine engine11;
        AepEngineScheduleTestApp app11 = new AepEngineScheduleTestApp();
        String app1Name = "engine-" + System.currentTimeMillis();
        app11.engine = engine11 = this.createEngine(app1Name, haPolicy, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 1, 1, app11, null, null, 0, false, false, null, null, null, false, false);
        engine11.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine11.start();
        engine11.waitForMessagingToStart();
        IRogMessage message = this.createMultiplexTriggerMessage(encodingType).getMessage();
        engine11.injectMessage(message);
        Assert.assertTrue((boolean)app11.waitForMessageReceipt());
        Assert.assertEquals((long)1L, (long)app11.messageCount);
        Assert.assertSame((Object)app11.lastMultiplexedMessage, (Object)app11.lastMessage);
        AepEngineScheduleTestApp app12 = new AepEngineScheduleTestApp();
        app12.engine = engine12 = this.createEngine(app1Name, haPolicy, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 1, 1, app12, null, null, 0, false, false, null, null, null, false, false);
        engine12.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine12.start();
        switch (haPolicy) {
            case EventSourcing: {
                Assert.assertEquals((long)1L, (long)app12.messageCount);
                Assert.assertNotSame((Object)app12.lastMultiplexedMessage, (Object)app12.lastMessage);
                Assert.assertEquals((long)app11.lastMultiplexedMessage.getPreProcessingTs(), (long)app12.lastMessage.getPreProcessingTs());
                break;
            }
            case StateReplication: {
                Assert.assertNull((Object)app12.lastMessage);
            }
        }
        app12.lastMessage = null;
        app11.lastMessage = null;
        app12.lastObject = null;
        app11.lastObject = null;
        message = this.createMultiplexTriggerMessage(encodingType).getMessage();
        engine11.injectMessage(message);
        Assert.assertTrue((boolean)app11.waitForMessageReceipt());
        Assert.assertEquals((long)2L, (long)app11.messageCount);
        Assert.assertSame((Object)app11.lastMultiplexedMessage, (Object)app11.lastMessage);
        switch (haPolicy) {
            case EventSourcing: {
                Assert.assertTrue((boolean)app12.waitForMessageReceipt());
                Assert.assertEquals((long)2L, (long)app12.messageCount);
                Assert.assertNotSame((Object)app12.lastMultiplexedMessage, (Object)app12.lastMessage);
                Assert.assertEquals((long)app11.lastMultiplexedMessage.getPreProcessingTs(), (long)app12.lastMessage.getPreProcessingTs());
                break;
            }
            case StateReplication: {
                Assert.assertFalse((boolean)app12.waitForMessageReceipt());
            }
        }
        engine12.stop();
        app12.waitForEngineStopped();
        engine11.stop();
        app11.waitForEngineStopped();
        long preProcessingTs = haPolicy == AepEngine.HAPolicy.EventSourcing ? app11.lastMultiplexedMessage.getPreProcessingTs() : 0L;
        app11 = new AepEngineScheduleTestApp();
        app11.engine = engine11 = this.createEngine(app1Name, haPolicy, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 1, 1, app11, null, null, 0, false, false, null, null, null, false, false);
        engine11.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine11.start();
        engine11.waitForMessagingToStart();
        switch (haPolicy) {
            case EventSourcing: {
                Assert.assertNotNull((Object)app11.lastMessage);
                Assert.assertEquals((long)2L, (long)app11.messageCount);
                Assert.assertNotSame((Object)app11.lastMultiplexedMessage, (Object)app11.lastMessage);
                Assert.assertEquals((long)preProcessingTs, (long)app11.lastMessage.getPreProcessingTs());
                break;
            }
            case StateReplication: {
                Assert.assertNull((Object)app11.lastMessage);
            }
        }
    }

    @Test
    public void testinjectMessageFromInsideOfMessageHandlerEventSourcingProto() throws Exception {
        this.testinjectMessageFromInsideOfMessageHandler(AepEngine.HAPolicy.EventSourcing, AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testinjectMessageFromInsideOfMessageHandlerStateReplicationProto() throws Exception {
        this.testinjectMessageFromInsideOfMessageHandler(AepEngine.HAPolicy.StateReplication, AepEngineTestObject.EncodingType.Proto);
    }

    private void testinjectMessageAck(AepEngine.HAPolicy haPolicy, AepEngineTestObject.EncodingType encodingType) throws Exception {
        AepEngine engine12;
        AepEngine engine11;
        AepEngineScheduleTestApp app11 = new AepEngineScheduleTestApp();
        String app1Name = "engine-" + System.currentTimeMillis();
        app11.engine = engine11 = this.createEngine(app1Name, haPolicy, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 1, 1, app11, null, null, 0, true, false, null, null, null, false, false);
        engine11.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine11.start();
        engine11.waitForMessagingToStart();
        AepEngineScheduleTestApp app12 = new AepEngineScheduleTestApp();
        app12.engine = engine12 = this.createEngine(app1Name, haPolicy, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 1, 1, app12, null, null, 0, true, false, null, null, null, false, false);
        engine12.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine12.start();
        Acknowledger acknowledger = new Acknowledger();
        IRogMessage message = this.createMessage(encodingType).getMessage();
        engine11.injectMessage(message, false, 0, acknowledger);
        Assert.assertTrue((boolean)acknowledger.waitForAck());
        Assert.assertEquals((long)1L, (long)app11.messageCount);
        switch (haPolicy) {
            case EventSourcing: {
                Assert.assertEquals((long)1L, (long)app12.messageCount);
                break;
            }
            case StateReplication: {
                Assert.assertEquals((long)0L, (long)app12.messageCount);
            }
        }
        Assert.assertTrue((app11.storeCommitCompleteTs > 0L ? 1 : 0) != 0);
        Assert.assertTrue((app11.storeCommitCompleteTs <= acknowledger.ackTs ? 1 : 0) != 0);
    }

    @Test
    public void testinjectMessageAckEventSourcingProto() throws Exception {
        this.testinjectMessageAck(AepEngine.HAPolicy.EventSourcing, AepEngineTestObject.EncodingType.Proto);
    }

    @Test
    public void testinjectMessageAckStateReplicationProto() throws Exception {
        this.testinjectMessageAck(AepEngine.HAPolicy.StateReplication, AepEngineTestObject.EncodingType.Proto);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testScheduleNullMessage() throws Exception {
        AepEngineScheduleTestApp app = new AepEngineScheduleTestApp();
        String appName = "engine-" + System.currentTimeMillis();
        AepEngine engine = this.createEngine(appName, AepEngine.HAPolicy.StateReplication, null, null, null, null, false, false, false, false, null, 1, 1, app, null, null, 0, false, false, null, null, null, false, false);
        engine.scheduleMessage(null);
    }

    @Test(expected=IllegalStateException.class)
    public void testScheduleMessageFromOutsideOfHandler() throws Exception {
        AepEngineScheduleTestApp app = new AepEngineScheduleTestApp();
        String appName = "engine-" + System.currentTimeMillis();
        AepEngine engine = this.createEngine(appName, AepEngine.HAPolicy.StateReplication, null, null, null, null, false, false, false, false, null, 1, 1, app, null, null, 0, false, false, null, null, null, false, false);
        engine.scheduleMessage(this.createMessage(AepEngineTestObject.EncodingType.Proto).getMessage());
    }

    private void testScheduleSingleDispatchFromInsideOfMessageHandler(AepEngine.HAPolicy haPolicy, AepEngineTestObject.EncodingType encodingType, boolean scheduleObject, int scheduleDelay) throws Exception {
        AepEngine engine12;
        AepEngine engine11;
        AepEngineScheduleTestApp app11 = new AepEngineScheduleTestApp();
        String app1Name = "engine-" + System.currentTimeMillis();
        app11.engine = engine11 = this.createEngine(app1Name, haPolicy, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 1, 1, app11, null, null, 0, false, false, null, null, null, false, false);
        app11.scheduleObject = scheduleObject;
        app11.scheduleDelay = scheduleDelay;
        engine11.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine11.start();
        engine11.waitForMessagingToStart();
        IRogMessage message = this.createScheduleTriggerMessage(encodingType).getMessage();
        engine11.injectMessage(message);
        long ts = System.currentTimeMillis();
        long ts1 = 0L;
        if (scheduleObject) {
            Assert.assertTrue((boolean)app11.waitForObjectReceipt());
            Assert.assertEquals((long)1L, (long)app11.objectCount);
            Assert.assertSame((Object)app11.lastScheduledObject, (Object)app11.lastObject);
            ts1 = System.currentTimeMillis();
            if (scheduleDelay > 0) {
                AepEngineScheduleTest.validateScheduleEvent(app11.lastScheduleEvent, AepScheduleEvent.State.Activated, null, app11.lastScheduledObject, true, scheduleDelay);
                Thread.sleep(100L);
                Assert.assertEquals((long)1L, (long)engine11.getEventMultiplexer().scheduledEventCount());
                engine11.injectMessage(this.createScheduleCancelTriggerMessage(encodingType).getMessage());
                app11.waitForCancel();
                AepEngineScheduleTest.validateScheduleEvent(app11.lastScheduleEvent, AepScheduleEvent.State.Cancelling, null, app11.lastScheduledObject, true, scheduleDelay);
                Thread.sleep(2000L);
                AepEngineScheduleTest.validateScheduleEvent(app11.lastScheduleEvent, AepScheduleEvent.State.Cancelled, null, app11.lastScheduledObject, true, scheduleDelay);
                this.waitForTransactionPipelineToEmpty(engine11);
                Assert.assertEquals((long)0L, (long)engine11.getEventMultiplexer().scheduledEventCount());
            } else {
                AepEngineScheduleTest.validateScheduleEvent(app11.lastScheduleEvent, AepScheduleEvent.State.Cancelled, null, app11.lastScheduledObject, false, scheduleDelay);
                this.waitForTransactionPipelineToEmpty(engine11);
                Assert.assertEquals((long)0L, (long)engine11.getEventMultiplexer().scheduledEventCount());
            }
        } else {
            Assert.assertTrue((boolean)app11.waitForMessageReceipt());
            Assert.assertEquals((long)1L, (long)app11.messageCount);
            Assert.assertSame((Object)app11.lastScheduledMessage, (Object)app11.lastMessage);
            ts1 = System.currentTimeMillis();
            Thread.sleep(1000L);
            AepEngineScheduleTest.validateScheduleEvent(app11.lastScheduleEvent, AepScheduleEvent.State.Cancelled, app11.lastScheduledMessage, null, false, scheduleDelay);
            this.waitForTransactionPipelineToEmpty(engine11);
            Assert.assertEquals((long)0L, (long)engine11.getEventMultiplexer().scheduledEventCount());
        }
        System.out.println("*** Time for app11 to receive first multiplex/schedule message/object was " + (ts1 - ts) + "ms ***");
        app11.lastScheduleEvent.dispose();
        Assert.assertEquals((long)0L, (long)app11.lastScheduleEvent.owners());
        AepEngineScheduleTestApp app12 = new AepEngineScheduleTestApp();
        app12.engine = engine12 = this.createEngine(app1Name, haPolicy, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 1, 1, app12, null, null, 0, false, false, null, null, null, false, false);
        app12.scheduleObject = scheduleObject;
        app12.scheduleDelay = scheduleDelay;
        engine12.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine12.start();
        switch (haPolicy) {
            case EventSourcing: {
                if (scheduleObject) {
                    Assert.assertNotNull((Object)app12.lastObject);
                    Assert.assertEquals((long)1L, (long)app12.objectCount);
                    Assert.assertSame((Object)app12.lastScheduledObject, (Object)app12.lastObject);
                    AepEngineScheduleTest.validateScheduleEvent(app12.lastScheduleEvent, AepScheduleEvent.State.Cancelled, null, app12.lastScheduledObject, scheduleDelay > 0, scheduleDelay);
                } else {
                    Assert.assertNotNull((Object)app12.lastMessage);
                    Assert.assertEquals((long)1L, (long)app12.messageCount);
                    Assert.assertSame((Object)app12.lastScheduledMessage, (Object)app12.lastMessage);
                    Assert.assertEquals((long)app11.lastScheduledMessage.getPreProcessingTs(), (long)app12.lastMessage.getPreProcessingTs());
                    AepEngineScheduleTest.validateScheduleEvent(app12.lastScheduleEvent, AepScheduleEvent.State.Cancelled, app12.lastScheduledMessage, null, false, scheduleDelay);
                }
                app12.lastScheduleEvent.dispose();
                Assert.assertEquals((long)0L, (long)app11.lastScheduleEvent.owners());
                break;
            }
            case StateReplication: {
                Assert.assertNull((Object)app12.lastMessage);
                Assert.assertEquals((long)0L, (long)app12.messageCount);
            }
        }
        app12.lastMessage = null;
        app11.lastMessage = null;
        app12.lastObject = null;
        app11.lastObject = null;
        message = this.createScheduleTriggerMessage(encodingType).getMessage();
        engine11.injectMessage(message);
        ts = System.currentTimeMillis();
        ts1 = 0L;
        if (scheduleObject) {
            Assert.assertTrue((boolean)app11.waitForObjectReceipt());
            Assert.assertEquals((long)2L, (long)app11.objectCount);
            Assert.assertSame((Object)app11.lastScheduledObject, (Object)app11.lastObject);
            ts1 = System.currentTimeMillis();
            if (scheduleDelay > 0) {
                Thread.sleep(100L);
                Assert.assertEquals((long)1L, (long)engine11.getEventMultiplexer().scheduledEventCount());
                engine11.injectMessage(this.createScheduleCancelTriggerMessage(encodingType).getMessage());
                app11.waitForCancel();
                Thread.sleep(2000L);
                this.waitForTransactionPipelineToEmpty(engine11);
                Assert.assertEquals((long)0L, (long)engine11.getEventMultiplexer().scheduledEventCount());
            } else {
                this.waitForTransactionPipelineToEmpty(engine11);
                Assert.assertEquals((long)0L, (long)engine11.getEventMultiplexer().scheduledEventCount());
            }
        } else {
            Assert.assertTrue((boolean)app11.waitForMessageReceipt());
            Assert.assertEquals((long)2L, (long)app11.messageCount);
            Assert.assertSame((Object)app11.lastScheduledMessage, (Object)app11.lastMessage);
            this.waitForTransactionPipelineToEmpty(engine11);
            Assert.assertEquals((long)0L, (long)engine11.getEventMultiplexer().scheduledEventCount());
            ts1 = System.currentTimeMillis();
        }
        System.out.println("*** Time for app11 to receive second multiplex/schedule message/object was " + (ts1 - ts) + "ms ***");
        app11.lastScheduleEvent.dispose();
        Assert.assertEquals((long)0L, (long)app11.lastScheduleEvent.owners());
        switch (haPolicy) {
            case EventSourcing: {
                if (scheduleObject) {
                    Assert.assertTrue((boolean)app12.waitForObjectReceipt());
                    Assert.assertEquals((long)2L, (long)app12.objectCount);
                    Assert.assertSame((Object)app12.lastScheduledObject, (Object)app12.lastObject);
                    Thread.sleep(2000L);
                    AepEngineScheduleTest.validateScheduleEvent(app12.lastScheduleEvent, AepScheduleEvent.State.Cancelled, null, app12.lastScheduledObject, scheduleDelay > 0, scheduleDelay);
                } else {
                    Assert.assertTrue((boolean)app12.waitForMessageReceipt());
                    Assert.assertEquals((long)2L, (long)app12.messageCount);
                    Assert.assertSame((Object)app12.lastScheduledMessage, (Object)app12.lastMessage);
                    Assert.assertEquals((long)app11.lastScheduledMessage.getPreProcessingTs(), (long)app12.lastMessage.getPreProcessingTs());
                    Thread.sleep(1000L);
                    AepEngineScheduleTest.validateScheduleEvent(app12.lastScheduleEvent, AepScheduleEvent.State.Cancelled, app12.lastScheduledMessage, null, false, scheduleDelay);
                }
                app12.lastScheduleEvent.dispose();
                Assert.assertEquals((long)0L, (long)app12.lastScheduleEvent.owners());
                break;
            }
            case StateReplication: {
                if (scheduleObject) {
                    Assert.assertFalse((boolean)app12.waitForObjectReceipt());
                    break;
                }
                Assert.assertFalse((boolean)app12.waitForMessageReceipt());
            }
        }
        engine12.stop();
        app12.waitForEngineStopped();
        engine11.stop();
        app11.waitForEngineStopped();
        long preProcessingTs = haPolicy == AepEngine.HAPolicy.EventSourcing && !scheduleObject ? app11.lastScheduledMessage.getPreProcessingTs() : 0L;
        app11 = new AepEngineScheduleTestApp();
        engine11 = this.createEngine(app1Name, haPolicy, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 1, 1, app11, null, null, 0, false, false, null, null, null, false, false);
        app11.scheduleObject = scheduleObject;
        app11.scheduleDelay = scheduleDelay;
        app11.engine = engine11;
        engine11.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine11.start();
        engine11.waitForMessagingToStart();
        this.waitForTransactionPipelineToEmpty(engine11);
        Assert.assertEquals((long)0L, (long)engine11.getEventMultiplexer().scheduledEventCount());
        switch (haPolicy) {
            case EventSourcing: {
                if (scheduleObject) {
                    Assert.assertNotNull((Object)app11.lastObject);
                    Assert.assertEquals((long)2L, (long)app11.objectCount);
                    Assert.assertSame((Object)app12.lastScheduledObject, (Object)app12.lastObject);
                    AepEngineScheduleTest.validateScheduleEvent(app11.lastScheduleEvent, AepScheduleEvent.State.Cancelled, null, app11.lastScheduledObject, scheduleDelay > 0, scheduleDelay);
                    break;
                }
                Assert.assertNotNull((Object)app11.lastMessage);
                Assert.assertEquals((long)2L, (long)app11.messageCount);
                Assert.assertSame((Object)app11.lastScheduledMessage, (Object)app11.lastMessage);
                Assert.assertEquals((long)preProcessingTs, (long)app11.lastMessage.getPreProcessingTs());
                AepEngineScheduleTest.validateScheduleEvent(app11.lastScheduleEvent, AepScheduleEvent.State.Cancelled, app11.lastScheduledMessage, null, false, scheduleDelay);
                break;
            }
            case StateReplication: {
                Assert.assertEquals((long)0L, (long)app11.messageCount);
                Assert.assertNull((Object)app11.lastMessage);
            }
        }
    }

    @Test
    public void testScheduleMessageImmediateFromInsideOfMessageHandlerEventSourcingProto() throws Exception {
        this.testScheduleSingleDispatchFromInsideOfMessageHandler(AepEngine.HAPolicy.EventSourcing, AepEngineTestObject.EncodingType.Proto, false, 0);
    }

    @Test
    public void testScheduleMessageImmediateFromInsideOfMessageHandlerStateReplicationProto() throws Exception {
        this.testScheduleSingleDispatchFromInsideOfMessageHandler(AepEngine.HAPolicy.StateReplication, AepEngineTestObject.EncodingType.Proto, false, 0);
    }

    @Test
    public void testScheduleMessageDelayedFromInsideOfMessageHandlerEventSourcingProto() throws Exception {
        this.testScheduleSingleDispatchFromInsideOfMessageHandler(AepEngine.HAPolicy.EventSourcing, AepEngineTestObject.EncodingType.Proto, false, 1000);
    }

    @Test
    public void testScheduleMessageDelayedFromInsideOfMessageHandlerStateReplicationProto() throws Exception {
        this.testScheduleSingleDispatchFromInsideOfMessageHandler(AepEngine.HAPolicy.StateReplication, AepEngineTestObject.EncodingType.Proto, false, 1000);
    }

    @Test(expected=IllegalStateException.class)
    public void testScheduleObjectFromOutsideOfHandler() throws Exception {
        AepEngineScheduleTestApp app = new AepEngineScheduleTestApp();
        String appName = "engine-" + System.currentTimeMillis();
        AepEngine engine = this.createEngine(appName, AepEngine.HAPolicy.StateReplication, null, null, null, null, false, false, false, false, null, 1, 1, app, null, null, 0, false, false, null, null, null, false, false);
        engine.scheduleObject(new Object());
    }

    @Test
    public void testScheduleObjectImmediateFromInsideOfMessageHandlerEventSourcingProto() throws Exception {
        this.testScheduleSingleDispatchFromInsideOfMessageHandler(AepEngine.HAPolicy.EventSourcing, AepEngineTestObject.EncodingType.Proto, true, 0);
    }

    @Test
    public void testScheduleObjectImmediateFromInsideOfMessageHandlerStateReplicationProto() throws Exception {
        this.testScheduleSingleDispatchFromInsideOfMessageHandler(AepEngine.HAPolicy.StateReplication, AepEngineTestObject.EncodingType.Proto, true, 0);
    }

    @Test
    public void testScheduleObjectPeriodicSingleDispatchFromInsideOfMessageHandlerEventSourcingProto() throws Exception {
        this.testScheduleSingleDispatchFromInsideOfMessageHandler(AepEngine.HAPolicy.EventSourcing, AepEngineTestObject.EncodingType.Proto, true, 1000);
    }

    @Test
    public void testScheduleObjectPeriodicSingleDispatchFromInsideOfMessageHandlerStateReplicationProto() throws Exception {
        this.testScheduleSingleDispatchFromInsideOfMessageHandler(AepEngine.HAPolicy.StateReplication, AepEngineTestObject.EncodingType.Proto, true, 1000);
    }

    private void testScheduleMultiDispatchFromInsideOfMessageHandler(AepEngine.HAPolicy haPolicy, AepEngineTestObject.EncodingType encodingType, int scheduleDelay) throws Exception {
        AepEngine engine12;
        AepEngine engine11;
        AepEngineScheduleTestApp app11 = new AepEngineScheduleTestApp();
        String app1Name = "engine-" + System.currentTimeMillis();
        app11.engine = engine11 = this.createEngine(app1Name, haPolicy, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 1, 1, app11, null, null, 0, false, false, null, null, null, false, false);
        app11.scheduleObject = true;
        app11.scheduleDelay = scheduleDelay;
        engine11.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine11.start();
        engine11.waitForMessagingToStart();
        IRogMessage message = this.createScheduleTriggerMessage(encodingType).getMessage();
        engine11.injectMessage(message);
        long ts = System.currentTimeMillis();
        long ts1 = 0L;
        for (int i = 0; i < 10; ++i) {
            Assert.assertTrue((boolean)app11.waitForObjectReceipt());
            Assert.assertSame((Object)app11.lastScheduledObject, (Object)app11.lastObject);
            app11.lastObject = null;
        }
        Assert.assertEquals((long)10L, (long)app11.objectCount);
        ts1 = System.currentTimeMillis();
        System.out.println("*** Time for app11 to receive first multiplex/schedule message/object was " + (ts1 - ts) + "ms ***");
        AepEngineScheduleTest.validateScheduleEvent(app11.lastScheduleEvent, AepScheduleEvent.State.Activated, null, app11.lastScheduledObject, true, scheduleDelay);
        Thread.sleep(100L);
        Assert.assertEquals((long)1L, (long)engine11.getEventMultiplexer().scheduledEventCount());
        engine11.injectMessage(this.createScheduleCancelTriggerMessage(encodingType).getMessage());
        app11.waitForCancel();
        AepEngineScheduleTest.validateScheduleEvent(app11.lastScheduleEvent, AepScheduleEvent.State.Cancelling, null, app11.lastScheduledObject, true, scheduleDelay);
        Thread.sleep(2000L);
        AepEngineScheduleTest.validateScheduleEvent(app11.lastScheduleEvent, AepScheduleEvent.State.Cancelled, null, app11.lastScheduledObject, true, scheduleDelay);
        this.waitForTransactionPipelineToEmpty(engine11);
        Assert.assertEquals((long)0L, (long)engine11.getEventMultiplexer().scheduledEventCount());
        AepEngineScheduleTestApp app12 = new AepEngineScheduleTestApp();
        app12.engine = engine12 = this.createEngine(app1Name, haPolicy, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 1, 1, app12, null, null, 0, false, false, null, null, null, false, false);
        app12.scheduleObject = true;
        app12.scheduleDelay = scheduleDelay;
        engine12.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine12.start();
        switch (haPolicy) {
            case EventSourcing: {
                Assert.assertEquals((long)10L, (long)app12.objectCount);
                Assert.assertSame((Object)app12.lastScheduledObject, (Object)app12.lastObject);
                break;
            }
            case StateReplication: {
                Assert.assertNull((Object)app12.lastObject);
            }
        }
        app12.lastObject = null;
        app11.lastObject = null;
        message = this.createScheduleTriggerMessage(encodingType).getMessage();
        engine11.injectMessage(message);
        ts = System.currentTimeMillis();
        ts1 = 0L;
        for (int i = 0; i < 10; ++i) {
            Assert.assertTrue((boolean)app11.waitForObjectReceipt());
            Assert.assertSame((Object)app11.lastScheduledObject, (Object)app11.lastObject);
            app11.lastObject = null;
        }
        Assert.assertEquals((long)20L, (long)app11.objectCount);
        ts1 = System.currentTimeMillis();
        Thread.sleep(100L);
        Assert.assertEquals((long)1L, (long)engine11.getEventMultiplexer().scheduledEventCount());
        engine11.injectMessage(this.createScheduleCancelTriggerMessage(encodingType).getMessage());
        app11.waitForCancel();
        Thread.sleep(2000L);
        this.waitForTransactionPipelineToEmpty(engine11);
        Assert.assertEquals((long)0L, (long)engine11.getEventMultiplexer().scheduledEventCount());
        System.out.println("*** Time for app11 to receive second multiplex/schedule message/object was " + (ts1 - ts) + "ms ***");
        switch (haPolicy) {
            case EventSourcing: {
                Assert.assertTrue((boolean)app12.waitForObjectCount(20));
                Assert.assertSame((Object)app12.lastScheduledObject, (Object)app12.lastObject);
                break;
            }
            case StateReplication: {
                Assert.assertFalse((boolean)app12.waitForObjectCount(1));
            }
        }
        engine12.stop();
        app12.waitForEngineStopped();
        engine11.stop();
        app11.waitForEngineStopped();
        app11 = new AepEngineScheduleTestApp();
        engine11 = this.createEngine(app1Name, haPolicy, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 1, 1, app11, null, null, 0, false, false, null, null, null, false, false);
        app11.scheduleObject = true;
        app11.scheduleDelay = scheduleDelay;
        app11.engine = engine11;
        engine11.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine11.start();
        engine11.waitForMessagingToStart();
        Assert.assertEquals((long)0L, (long)engine11.getEventMultiplexer().scheduledEventCount());
        switch (haPolicy) {
            case EventSourcing: {
                Assert.assertNotNull((Object)app11.lastObject);
                Assert.assertEquals((long)20L, (long)app11.objectCount);
                Assert.assertSame((Object)app12.lastScheduledObject, (Object)app12.lastObject);
                break;
            }
            case StateReplication: {
                Assert.assertNull((Object)app11.lastMessage);
            }
        }
    }

    @Test
    public void testScheduleObjectPeriodicMultiDispatchFromInsideOfMessageHandlerEventSourcingProto() throws Exception {
        this.testScheduleMultiDispatchFromInsideOfMessageHandler(AepEngine.HAPolicy.EventSourcing, AepEngineTestObject.EncodingType.Proto, 1000);
    }

    @Test
    public void testScheduleObjectPeriodicMultiDispatchFromInsideOfMessageHandlerStateReplicationProto() throws Exception {
        this.testScheduleMultiDispatchFromInsideOfMessageHandler(AepEngine.HAPolicy.StateReplication, AepEngineTestObject.EncodingType.Proto, 1000);
    }

    private void testScheduleAndCancelFromInsideOfMessageHandler(AepEngine.HAPolicy haPolicy, AepEngineTestObject.EncodingType encodingType, boolean scheduleObject, int scheduleDelay) throws Exception {
        AepEngine engine12;
        AepEngine engine11;
        AepEngineScheduleTestApp app11 = new AepEngineScheduleTestApp();
        String app1Name = "engine-" + System.currentTimeMillis();
        app11.engine = engine11 = this.createEngine(app1Name, haPolicy, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 1, 1, app11, null, null, 0, false, false, null, null, null, false, false);
        app11.scheduleObject = scheduleObject;
        app11.scheduleDelay = scheduleDelay;
        engine11.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine11.start();
        engine11.waitForMessagingToStart();
        IRogMessage message = this.createScheduleAndCancelTriggerMessage(encodingType).getMessage();
        engine11.injectMessage(message);
        if (scheduleObject) {
            Assert.assertFalse((boolean)app11.waitForObjectReceipt());
            Assert.assertNull((Object)app11.lastObject);
            Assert.assertEquals((long)0L, (long)app11.objectCount);
            AepEngineScheduleTest.validateScheduleEvent(app11.lastScheduleEvent, AepScheduleEvent.State.Cancelled, null, app11.lastScheduledObject, scheduleDelay > 0, scheduleDelay);
            this.waitForTransactionPipelineToEmpty(engine11);
            Assert.assertEquals((long)0L, (long)engine11.getEventMultiplexer().scheduledEventCount());
        } else {
            Assert.assertFalse((boolean)app11.waitForMessageReceipt());
            Assert.assertNull((Object)app11.lastMessage);
            Assert.assertEquals((long)0L, (long)app11.messageCount);
            AepEngineScheduleTest.validateScheduleEvent(app11.lastScheduleEvent, AepScheduleEvent.State.Cancelled, app11.lastScheduledMessage, null, false, scheduleDelay);
            this.waitForTransactionPipelineToEmpty(engine11);
            Assert.assertEquals((long)0L, (long)engine11.getEventMultiplexer().scheduledEventCount());
        }
        AepEngineScheduleTestApp app12 = new AepEngineScheduleTestApp();
        app12.engine = engine12 = this.createEngine(app1Name, haPolicy, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 1, 1, app12, null, null, 0, false, false, null, null, null, false, false);
        app12.scheduleObject = scheduleObject;
        app12.scheduleDelay = scheduleDelay;
        engine12.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine12.start();
        if (haPolicy == AepEngine.HAPolicy.EventSourcing) {
            if (scheduleObject) {
                Assert.assertNull((Object)app12.lastObject);
                Assert.assertEquals((long)0L, (long)app12.objectCount);
                AepEngineScheduleTest.validateScheduleEvent(app12.lastScheduleEvent, AepScheduleEvent.State.Cancelled, null, app12.lastScheduledObject, scheduleDelay > 0, scheduleDelay);
            } else {
                Assert.assertNull((Object)app12.lastMessage);
                Assert.assertEquals((long)0L, (long)app12.messageCount);
                AepEngineScheduleTest.validateScheduleEvent(app12.lastScheduleEvent, AepScheduleEvent.State.Cancelled, app12.lastScheduledMessage, null, false, scheduleDelay);
            }
        } else {
            Assert.assertNull((Object)app12.lastObject);
            Assert.assertEquals((long)0L, (long)app11.objectCount);
            Assert.assertNull((Object)app12.lastMessage);
            Assert.assertEquals((long)0L, (long)app11.messageCount);
        }
        message = this.createScheduleAndCancelTriggerMessage(encodingType).getMessage();
        engine11.injectMessage(message);
        if (scheduleObject) {
            Assert.assertFalse((boolean)app11.waitForObjectReceipt());
            Assert.assertNull((Object)app11.lastObject);
            Assert.assertEquals((long)0L, (long)app11.objectCount);
            AepEngineScheduleTest.validateScheduleEvent(app11.lastScheduleEvent, AepScheduleEvent.State.Cancelled, null, app11.lastScheduledObject, scheduleDelay > 0, scheduleDelay);
            this.waitForTransactionPipelineToEmpty(engine11);
            Assert.assertEquals((long)0L, (long)engine11.getEventMultiplexer().scheduledEventCount());
        } else {
            Assert.assertFalse((boolean)app11.waitForMessageReceipt());
            Assert.assertNull((Object)app11.lastMessage);
            Assert.assertEquals((long)0L, (long)app11.messageCount);
            AepEngineScheduleTest.validateScheduleEvent(app11.lastScheduleEvent, AepScheduleEvent.State.Cancelled, app11.lastScheduledMessage, null, false, scheduleDelay);
            this.waitForTransactionPipelineToEmpty(engine11);
            Assert.assertEquals((long)0L, (long)engine11.getEventMultiplexer().scheduledEventCount());
        }
        if (haPolicy == AepEngine.HAPolicy.EventSourcing) {
            if (scheduleObject) {
                Assert.assertFalse((boolean)app12.waitForObjectReceipt());
                Assert.assertEquals((long)0L, (long)app12.objectCount);
                AepEngineScheduleTest.validateScheduleEvent(app12.lastScheduleEvent, AepScheduleEvent.State.Cancelled, null, app12.lastScheduledObject, scheduleDelay > 0, scheduleDelay);
            } else {
                Assert.assertFalse((boolean)app12.waitForMessageReceipt());
                Assert.assertEquals((long)0L, (long)app12.messageCount);
                AepEngineScheduleTest.validateScheduleEvent(app12.lastScheduleEvent, AepScheduleEvent.State.Cancelled, app12.lastScheduledMessage, null, false, scheduleDelay);
            }
        } else {
            Assert.assertNull((Object)app12.lastObject);
            Assert.assertNull((Object)app12.lastMessage);
        }
        engine12.stop();
        app12.waitForEngineStopped();
        engine11.stop();
        app11.waitForEngineStopped();
        app11 = new AepEngineScheduleTestApp();
        engine11 = this.createEngine(app1Name, haPolicy, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 1, 1, app11, null, null, 0, false, false, null, null, null, false, false);
        app11.scheduleObject = scheduleObject;
        app11.scheduleDelay = scheduleDelay;
        app11.engine = engine11;
        engine11.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine11.start();
        engine11.waitForMessagingToStart();
        this.waitForTransactionPipelineToEmpty(engine11);
        Assert.assertEquals((long)0L, (long)engine11.getEventMultiplexer().scheduledEventCount());
        if (haPolicy == AepEngine.HAPolicy.EventSourcing) {
            if (scheduleObject) {
                Assert.assertNull((Object)app12.lastObject);
                Assert.assertEquals((long)0L, (long)app12.objectCount);
                AepEngineScheduleTest.validateScheduleEvent(app12.lastScheduleEvent, AepScheduleEvent.State.Cancelled, null, app12.lastScheduledObject, scheduleDelay > 0, scheduleDelay);
            } else {
                Assert.assertNull((Object)app12.lastMessage);
                Assert.assertEquals((long)0L, (long)app12.messageCount);
                AepEngineScheduleTest.validateScheduleEvent(app12.lastScheduleEvent, AepScheduleEvent.State.Cancelled, app12.lastScheduledMessage, null, false, scheduleDelay);
            }
        } else {
            Assert.assertNull((Object)app12.lastObject);
            Assert.assertEquals((long)0L, (long)app11.objectCount);
            Assert.assertNull((Object)app12.lastMessage);
            Assert.assertEquals((long)0L, (long)app11.messageCount);
        }
    }

    @Test
    public void testScheduleAndCancelMessageImmediateDispatchFromInsideOfMessageHandlerEventSourcingProto() throws Exception {
        this.testScheduleAndCancelFromInsideOfMessageHandler(AepEngine.HAPolicy.EventSourcing, AepEngineTestObject.EncodingType.Proto, false, 0);
    }

    @Test
    public void testScheduleAndCancelMessageImmediateDispatchFromInsideOfMessageHandlerStateReplicationProto() throws Exception {
        this.testScheduleAndCancelFromInsideOfMessageHandler(AepEngine.HAPolicy.StateReplication, AepEngineTestObject.EncodingType.Proto, false, 0);
    }

    @Test
    public void testScheduleAndCancelMessageDelayedDispatchFromInsideOfMessageHandlerEventSourcingProto() throws Exception {
        this.testScheduleAndCancelFromInsideOfMessageHandler(AepEngine.HAPolicy.EventSourcing, AepEngineTestObject.EncodingType.Proto, false, 100);
    }

    @Test
    public void testScheduleAndCancelMessageDelayedDispatchFromInsideOfMessageHandlerStateReplicationProto() throws Exception {
        this.testScheduleAndCancelFromInsideOfMessageHandler(AepEngine.HAPolicy.StateReplication, AepEngineTestObject.EncodingType.Proto, false, 100);
    }

    @Test
    public void testScheduleAndCancelObjectImmediateDispatchFromInsideOfMessageHandlerEventSourcingProto() throws Exception {
        this.testScheduleAndCancelFromInsideOfMessageHandler(AepEngine.HAPolicy.EventSourcing, AepEngineTestObject.EncodingType.Proto, true, 0);
    }

    @Test
    public void testScheduleAndCancelObjectImmediateDispatchFromInsideOfMessageHandlerStateReplicationProto() throws Exception {
        this.testScheduleAndCancelFromInsideOfMessageHandler(AepEngine.HAPolicy.StateReplication, AepEngineTestObject.EncodingType.Proto, true, 0);
    }

    @Test
    public void testScheduleAndCancelObjectPeriodicDispatchFromInsideOfMessageHandlerEventSourcingProto() throws Exception {
        this.testScheduleAndCancelFromInsideOfMessageHandler(AepEngine.HAPolicy.EventSourcing, AepEngineTestObject.EncodingType.Proto, true, 100);
    }

    @Test
    public void testScheduleAndCancelObjectPeriodicDispatchFromInsideOfMessageHandlerStateReplicationProto() throws Exception {
        this.testScheduleAndCancelFromInsideOfMessageHandler(AepEngine.HAPolicy.StateReplication, AepEngineTestObject.EncodingType.Proto, true, 100);
    }

    private void testCancelHAPolicy(AepEngine.HAPolicy haPolicy, AepEngineTestObject.EncodingType encodingType, boolean scheduleObject, boolean scheduleOnMessagingStarted) throws Exception {
        int i;
        AepEngine engine12;
        AepEngine engine11;
        AepEngineScheduleTestApp app11 = new AepEngineScheduleTestApp();
        String app1Name = "engine-" + System.currentTimeMillis();
        app11.engine = engine11 = this.createEngine(app1Name, haPolicy, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 1, 1, app11, null, null, 0, false, false, null, null, null, false, false);
        app11.scheduleObject = scheduleObject;
        app11.scheduleDelay = 30000;
        engine11.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine11.start();
        engine11.waitForMessagingToStart();
        AepEngineScheduleTestApp app12 = new AepEngineScheduleTestApp();
        app12.engine = engine12 = this.createEngine(app1Name, haPolicy, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 1, 1, app12, null, null, 0, false, false, null, null, null, false, false);
        app12.scheduleObject = scheduleObject;
        app12.scheduleDelay = 30000;
        app12.scheduleOnMessagingStarted = scheduleOnMessagingStarted;
        engine12.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine12.start();
        IRogMessage message = this.createScheduleTriggerMessage(encodingType).getMessage();
        engine11.injectMessage(message);
        for (i = 0; i < 10; ++i) {
            Thread.sleep(1000L);
            if (app11.lastScheduleEvent != null && app11.lastScheduleEvent.getState() == AepScheduleEvent.State.Activated) break;
        }
        Assert.assertTrue((i < 10 ? 1 : 0) != 0);
        for (i = 0; i < 10; ++i) {
            Thread.sleep(1000L);
            if (app12.lastScheduleEvent != null && app12.lastScheduleEvent.getState() == AepScheduleEvent.State.Activated) break;
        }
        Assert.assertTrue((i < 10 ? 1 : 0) != 0);
        Thread.sleep(5000L);
        Assert.assertEquals((Object)((Object)AepScheduleEvent.State.Activated), (Object)((Object)app11.lastScheduleEvent.getState()));
        Assert.assertEquals((Object)((Object)AepScheduleEvent.State.Activated), (Object)((Object)app12.lastScheduleEvent.getState()));
        engine11.stop();
        app11.waitForEngineStopped();
        engine12.waitForMessagingToStart();
        if (scheduleOnMessagingStarted) {
            Thread.sleep(1000L);
            Assert.assertEquals((Object)((Object)AepScheduleEvent.State.Activated), (Object)((Object)app12.lastScheduleEvent.getState()));
            app12.receiptTimeout = 30000;
            if (scheduleObject) {
                Assert.assertTrue((boolean)app12.waitForObjectReceipt());
            } else {
                Assert.assertTrue((boolean)app12.waitForMessageReceipt());
            }
        } else {
            Assert.assertEquals((Object)((Object)AepScheduleEvent.State.Cancelled), (Object)((Object)app12.lastScheduleEvent.getState()));
            app12.lastScheduleEvent.dispose();
            Assert.assertEquals((long)0L, (long)app12.lastScheduleEvent.owners());
        }
        engine12.stop();
        app12.waitForEngineStopped();
        app11 = new AepEngineScheduleTestApp();
        engine11 = this.createEngine(app1Name, haPolicy, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 1, 1, app11, null, null, 0, false, false, null, null, null, false, false);
        app11.scheduleObject = scheduleObject;
        app11.scheduleDelay = 30000;
        app11.engine = engine11;
        app11.scheduleOnMessagingStarted = scheduleOnMessagingStarted;
        engine11.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine11.start();
        engine11.waitForMessagingToStart();
        if (scheduleOnMessagingStarted) {
            Thread.sleep(1000L);
            Assert.assertEquals((Object)((Object)AepScheduleEvent.State.Activated), (Object)((Object)app11.lastScheduleEvent.getState()));
            app11.receiptTimeout = 30000;
            if (scheduleObject) {
                Assert.assertTrue((boolean)app11.waitForObjectReceipt());
            } else {
                Assert.assertTrue((boolean)app11.waitForMessageReceipt());
            }
        } else {
            Assert.assertEquals((Object)((Object)AepScheduleEvent.State.Cancelled), (Object)((Object)app11.lastScheduleEvent.getState()));
            app11.lastScheduleEvent.dispose();
            Assert.assertEquals((long)0L, (long)app11.lastScheduleEvent.owners());
        }
    }

    @Test
    public void testCancelHAPolicyMessageDelayedDispatchFromInsideOfMessageHandlerEventSourcingProto() throws Exception {
        this.testCancelHAPolicy(AepEngine.HAPolicy.EventSourcing, AepEngineTestObject.EncodingType.Proto, false, false);
    }

    @Test
    public void testCancelHAPolicyObjectPeriodicDispatchFromInsideOfMessageHandlerEventSourcingProto() throws Exception {
        this.testCancelHAPolicy(AepEngine.HAPolicy.EventSourcing, AepEngineTestObject.EncodingType.Proto, true, false);
    }

    @Test
    public void testCancelHAPolicyMessageDelayedDispatchFromInsideOfMessageHandlerScheduleOnMessagingStartedEventSourcingProto() throws Exception {
        this.testCancelHAPolicy(AepEngine.HAPolicy.EventSourcing, AepEngineTestObject.EncodingType.Proto, false, true);
    }

    @Test
    public void testCancelHAPolicyObjectPeriodicDispatchFromInsideOfMessageHandlerScheduleOnMessagingStartedEventSourcingProto() throws Exception {
        this.testCancelHAPolicy(AepEngine.HAPolicy.EventSourcing, AepEngineTestObject.EncodingType.Proto, true, true);
    }

    private void testReactivateHAPolicy(AepEngine.HAPolicy haPolicy, AepEngineTestObject.EncodingType encodingType, boolean scheduleObject, boolean cancelOnMessagingStarted) throws Exception {
        int i;
        AepEngine engine12;
        AepEngine engine11;
        AepEngineScheduleTestApp app11 = new AepEngineScheduleTestApp();
        String app1Name = "engine-" + System.currentTimeMillis();
        app11.engine = engine11 = this.createEngine(app1Name, haPolicy, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 1, 1, app11, null, null, 0, false, false, null, null, null, false, false);
        app11.scheduleObject = scheduleObject;
        app11.scheduleDelay = 30000;
        app11.scheduleHAPolicy = AepScheduleEvent.HAPolicy.Reactivate;
        engine11.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine11.start();
        engine11.waitForMessagingToStart();
        AepEngineScheduleTestApp app12 = new AepEngineScheduleTestApp();
        app12.engine = engine12 = this.createEngine(app1Name, haPolicy, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 1, 1, app12, null, null, 0, false, false, null, null, null, false, false);
        app12.scheduleObject = scheduleObject;
        app12.scheduleDelay = 30000;
        app12.scheduleHAPolicy = AepScheduleEvent.HAPolicy.Reactivate;
        app12.cancelOnMessagingStarted = cancelOnMessagingStarted;
        engine12.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine12.start();
        IRogMessage message = this.createScheduleTriggerMessage(encodingType).getMessage();
        engine11.injectMessage(message);
        for (i = 0; i < 10; ++i) {
            Thread.sleep(1000L);
            if (app11.lastScheduleEvent != null && app11.lastScheduleEvent.getState() == AepScheduleEvent.State.Activated) break;
        }
        Assert.assertTrue((i < 10 ? 1 : 0) != 0);
        for (i = 0; i < 10; ++i) {
            Thread.sleep(1000L);
            if (app12.lastScheduleEvent != null && app12.lastScheduleEvent.getState() == AepScheduleEvent.State.Activated) break;
        }
        Assert.assertTrue((i < 10 ? 1 : 0) != 0);
        Thread.sleep(5000L);
        Assert.assertEquals((Object)((Object)AepScheduleEvent.State.Activated), (Object)((Object)app11.lastScheduleEvent.getState()));
        Assert.assertEquals((Object)((Object)AepScheduleEvent.State.Activated), (Object)((Object)app12.lastScheduleEvent.getState()));
        engine11.stop();
        app11.waitForEngineStopped();
        engine12.waitForMessagingToStart();
        if (cancelOnMessagingStarted) {
            Assert.assertEquals((Object)((Object)AepScheduleEvent.State.Cancelled), (Object)((Object)app12.lastScheduleEvent.getState()));
        } else {
            Thread.sleep(1000L);
            Assert.assertEquals((Object)((Object)AepScheduleEvent.State.Activated), (Object)((Object)app12.lastScheduleEvent.getState()));
            app12.receiptTimeout = 30000;
            if (scheduleObject) {
                Assert.assertTrue((boolean)app12.waitForObjectReceipt());
            } else {
                Assert.assertTrue((boolean)app12.waitForMessageReceipt());
            }
        }
        engine12.stop();
        app12.waitForEngineStopped();
        app11 = new AepEngineScheduleTestApp();
        engine11 = this.createEngine(app1Name, haPolicy, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 1, 1, app11, null, null, 0, false, false, null, null, null, false, false);
        app11.scheduleObject = scheduleObject;
        app11.scheduleDelay = 30000;
        app11.scheduleHAPolicy = AepScheduleEvent.HAPolicy.Reactivate;
        app11.cancelOnMessagingStarted = cancelOnMessagingStarted;
        app11.engine = engine11;
        engine11.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine11.start();
        engine11.waitForMessagingToStart();
        if (cancelOnMessagingStarted) {
            Assert.assertEquals((Object)((Object)AepScheduleEvent.State.Cancelled), (Object)((Object)app11.lastScheduleEvent.getState()));
        } else {
            Thread.sleep(1000L);
            Assert.assertEquals((Object)((Object)AepScheduleEvent.State.Activated), (Object)((Object)app11.lastScheduleEvent.getState()));
            app11.receiptTimeout = 30000;
            if (scheduleObject) {
                Assert.assertTrue((boolean)app11.waitForObjectReceipt());
            } else {
                Assert.assertTrue((boolean)app11.waitForMessageReceipt());
            }
        }
    }

    @Test
    public void testReactivateHAPolicyMessageDelayedDispatchFromInsideOfMessageHandlerEventSourcingProto() throws Exception {
        this.testReactivateHAPolicy(AepEngine.HAPolicy.EventSourcing, AepEngineTestObject.EncodingType.Proto, false, false);
    }

    @Test
    public void testReactivateHAPolicyObjectPeriodicDispatchFromInsideOfMessageHandlerEventSourcingProto() throws Exception {
        this.testReactivateHAPolicy(AepEngine.HAPolicy.EventSourcing, AepEngineTestObject.EncodingType.Proto, true, false);
    }

    @Test
    public void testReactivateHAPolicyMessageDelayedDispatchFromInsideOfMessageHandlerCancelFromMessagingStartedEventSourcingProto() throws Exception {
        this.testReactivateHAPolicy(AepEngine.HAPolicy.EventSourcing, AepEngineTestObject.EncodingType.Proto, false, true);
    }

    @Test
    public void testReactivateHAPolicyObjectPeriodicDispatchFromInsideOfMessageHandlerCancelFromMessagingStartedEEventSourcingProto() throws Exception {
        this.testReactivateHAPolicy(AepEngine.HAPolicy.EventSourcing, AepEngineTestObject.EncodingType.Proto, true, true);
    }

    private void testCancelFromDispatch(AepEngine.HAPolicy haPolicy, AepEngineTestObject.EncodingType encodingType, boolean scheduleObject, int scheduleDelay) throws Exception {
        AepEngine engine12;
        AepEngine engine11;
        AepEngineScheduleTestApp app11 = new AepEngineScheduleTestApp();
        String app1Name = "engine-" + System.currentTimeMillis();
        app11.engine = engine11 = this.createEngine(app1Name, haPolicy, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 1, 1, app11, null, null, 0, false, false, null, null, null, false, false);
        app11.scheduleObject = scheduleObject;
        app11.scheduleDelay = scheduleDelay;
        app11.cancelOnDispatch = true;
        app11.scheduleHAPolicy = AepScheduleEvent.HAPolicy.Reactivate;
        app11.receiptTimeout = scheduleDelay * 2;
        engine11.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine11.start();
        engine11.waitForMessagingToStart();
        AepEngineScheduleTestApp app12 = new AepEngineScheduleTestApp();
        app12.engine = engine12 = this.createEngine(app1Name, haPolicy, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 1, 1, app12, null, null, 0, false, false, null, null, null, false, false);
        app12.scheduleObject = scheduleObject;
        app12.scheduleDelay = scheduleDelay;
        app12.cancelOnDispatch = true;
        app12.scheduleHAPolicy = AepScheduleEvent.HAPolicy.Reactivate;
        app12.receiptTimeout = scheduleDelay * 2;
        engine12.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine12.start();
        IRogMessage message = this.createScheduleTriggerMessage(encodingType).getMessage();
        engine11.injectMessage(message);
        if (haPolicy == AepEngine.HAPolicy.EventSourcing) {
            if (scheduleObject) {
                Assert.assertTrue((boolean)app11.waitForObjectReceipt());
                Assert.assertTrue((boolean)app12.waitForObjectReceipt());
            } else {
                Assert.assertTrue((boolean)app11.waitForMessageReceipt());
                Assert.assertTrue((boolean)app12.waitForMessageReceipt());
            }
        } else if (scheduleObject) {
            Assert.assertTrue((boolean)app11.waitForObjectReceipt());
            Assert.assertFalse((boolean)app12.waitForObjectReceipt());
        } else {
            Assert.assertTrue((boolean)app11.waitForMessageReceipt());
            Assert.assertFalse((boolean)app12.waitForMessageReceipt());
        }
        Thread.sleep(1000L);
        if (scheduleObject) {
            AepEngineScheduleTest.validateScheduleEvent(app11.lastScheduleEvent, AepScheduleEvent.State.Cancelled, null, app11.lastScheduledObject, scheduleDelay > 0, scheduleDelay);
            if (haPolicy == AepEngine.HAPolicy.EventSourcing) {
                AepEngineScheduleTest.validateScheduleEvent(app12.lastScheduleEvent, AepScheduleEvent.State.Cancelled, null, app12.lastScheduledObject, scheduleDelay > 0, scheduleDelay);
            }
        } else {
            AepEngineScheduleTest.validateScheduleEvent(app11.lastScheduleEvent, AepScheduleEvent.State.Cancelled, app11.lastScheduledMessage, null, false, scheduleDelay);
            if (haPolicy == AepEngine.HAPolicy.EventSourcing) {
                AepEngineScheduleTest.validateScheduleEvent(app12.lastScheduleEvent, AepScheduleEvent.State.Cancelled, app12.lastScheduledMessage, null, false, scheduleDelay);
            }
        }
        engine12.stop();
        app12.waitForEngineStopped();
        engine11.stop();
        app11.waitForEngineStopped();
        app11 = new AepEngineScheduleTestApp();
        engine11 = this.createEngine(app1Name, haPolicy, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 1, 1, app11, null, null, 0, false, false, null, null, null, false, false);
        app11.scheduleObject = scheduleObject;
        app11.scheduleDelay = scheduleDelay;
        app11.engine = engine11;
        app11.cancelOnDispatch = true;
        app11.scheduleHAPolicy = AepScheduleEvent.HAPolicy.Reactivate;
        engine11.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine11.start();
        engine11.waitForMessagingToStart();
        if (haPolicy == AepEngine.HAPolicy.EventSourcing) {
            if (scheduleObject) {
                AepEngineScheduleTest.validateScheduleEvent(app11.lastScheduleEvent, AepScheduleEvent.State.Cancelled, null, app11.lastScheduledObject, scheduleDelay > 0, scheduleDelay);
            } else {
                AepEngineScheduleTest.validateScheduleEvent(app11.lastScheduleEvent, AepScheduleEvent.State.Cancelled, app11.lastScheduledMessage, null, false, scheduleDelay);
            }
        } else {
            Assert.assertFalse((boolean)app11.waitForObjectReceipt());
        }
    }

    @Test
    public void testCancelFromDispatchMessageImmediateDispatchFromInsideOfMessageHandlerEventSourcingProto() throws Exception {
        this.testCancelFromDispatch(AepEngine.HAPolicy.EventSourcing, AepEngineTestObject.EncodingType.Proto, false, 0);
    }

    @Test
    public void testCancelFromDispatchMessageImmediateDispatchFromInsideOfMessageHandlerStateReplicationProto() throws Exception {
        this.testCancelFromDispatch(AepEngine.HAPolicy.StateReplication, AepEngineTestObject.EncodingType.Proto, false, 0);
    }

    @Test
    public void testCancelFromDispatchMessageDelayedDispatchFromInsideOfMessageHandlerEventSourcingProto() throws Exception {
        this.testCancelFromDispatch(AepEngine.HAPolicy.EventSourcing, AepEngineTestObject.EncodingType.Proto, false, 5000);
    }

    @Test
    public void testCancelFromDispatchMessageDelayedDispatchFromInsideOfMessageHandlerStateReplicationProto() throws Exception {
        this.testCancelFromDispatch(AepEngine.HAPolicy.StateReplication, AepEngineTestObject.EncodingType.Proto, false, 5000);
    }

    @Test
    public void testCancelFromDispatchObjectImmediateDispatchFromInsideOfMessageHandlerEventSourcingProto() throws Exception {
        this.testCancelFromDispatch(AepEngine.HAPolicy.EventSourcing, AepEngineTestObject.EncodingType.Proto, true, 0);
    }

    @Test
    public void testCancelFromDispatchObjectImmediateDispatchFromInsideOfMessageHandlerStateReplicationProto() throws Exception {
        this.testCancelFromDispatch(AepEngine.HAPolicy.StateReplication, AepEngineTestObject.EncodingType.Proto, true, 0);
    }

    @Test
    public void testCancelFromDispatchObjectPeriodicDispatchFromInsideOfMessageHandlerEventSourcingProto() throws Exception {
        this.testCancelFromDispatch(AepEngine.HAPolicy.EventSourcing, AepEngineTestObject.EncodingType.Proto, true, 5000);
    }

    @Test
    public void testCancelFromDispatchObjectPeriodicDispatchFromInsideOfMessageHandlerStateReplicationProto() throws Exception {
        this.testCancelFromDispatch(AepEngine.HAPolicy.StateReplication, AepEngineTestObject.EncodingType.Proto, true, 5000);
    }

    private final class Acknowledger
    implements IEventAcknowledger {
        private boolean acked;
        long ackTs;

        private Acknowledger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean waitForAck() {
            Acknowledger acknowledger = this;
            synchronized (acknowledger) {
                long remaining;
                long ts = System.currentTimeMillis();
                while (!this.acked && (remaining = 5000L - (System.currentTimeMillis() - ts)) > 0L) {
                    try {
                        this.wait(remaining);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return this.acked;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void ack() {
            Acknowledger acknowledger = this;
            synchronized (acknowledger) {
                this.acked = true;
                this.ackTs = System.currentTimeMillis();
                this.notifyAll();
            }
        }
    }
}

