/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.test.unit.AepEngineInitialMessagesTestApp;
import com.neeve.aep.test.unit.AepEngineTest;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.sma.MessageView;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class AepEngineInitialMessagesTest
extends AepEngineTest {
    private final Random _random = new Random(System.currentTimeMillis());

    private final MessageView createMessage() {
        return new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto).getMessage();
    }

    private final List<MessageView> createInitialMessages(int count) {
        ArrayList<MessageView> messages = new ArrayList<MessageView>();
        for (int i = 0; i < count; ++i) {
            messages.add(this.createMessage());
        }
        return messages;
    }

    private final void testInitialMessages(MessageView firstMessage, List<MessageView> initialMessages) throws Exception {
        AepEngineInitialMessagesTestApp app = new AepEngineInitialMessagesTestApp();
        app.firstMessage = firstMessage;
        app.initialMessages = initialMessages;
        AepEngine engine = this.createEngine("engine", null, null, null, null, null, false, false, false, false, null, 1, 1, app, null, null, 0, false, false, null, null, null, false, false);
        engine.start();
        engine.waitForMessagingToStart();
        app.waitForMessageReceipt((firstMessage != null ? 1 : 0) + initialMessages.size());
        int i = 0;
        if (firstMessage != null) {
            Assert.assertSame((Object)firstMessage, (Object)app.receivedMessages.get(i++));
        }
        for (MessageView view : initialMessages) {
            Assert.assertSame((Object)view, (Object)app.receivedMessages.get(i++));
        }
    }

    @Test
    public void testInitialMessages_NoFirstNoInitial() throws Exception {
        this.testInitialMessages(null, this.createInitialMessages(0));
    }

    @Test
    public void testInitialMessages_NoFirstYesInitial() throws Exception {
        this.testInitialMessages(null, this.createInitialMessages(1 + this._random.nextInt(20)));
    }

    @Test
    public void testInitialMessages_YesFirstNoInitial() throws Exception {
        this.testInitialMessages(this.createMessage(), this.createInitialMessages(0));
    }

    @Test
    public void testInitialMessages_YesFirstYesInitial() throws Exception {
        this.testInitialMessages(this.createMessage(), this.createInitialMessages(1 + this._random.nextInt(20)));
    }
}

