/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.IAepEnvironmentProvider;
import com.neeve.aep.test.unit.AepEngineEnvironmentProviderTestApp;
import com.neeve.aep.test.unit.AepEngineTest;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.ci.XRuntime;
import com.neeve.rog.IRogMessage;
import java.io.File;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class AepEngineEnvironmentProviderTest
extends AepEngineTest {
    @Test(expected=IllegalArgumentException.class)
    public void testSetNullEnvironmentProvider() throws Exception {
        AepEngine engine = this.createEngine("app");
        engine.registerEnvironmentProvider(null);
    }

    @Test(expected=IllegalStateException.class)
    public void testMaxEnvironmentProvidersExceeded() throws Exception {
        AepEngine engine = this.createEngine("app");
        try {
            for (int i = 0; i < 256; ++i) {
                engine.registerEnvironmentProvider(new AepEngineEnvironmentProviderTestApp());
            }
        }
        catch (Exception e) {
            Assert.fail((String)"environment provider registration failed within the first 256 registrations");
        }
        engine.registerEnvironmentProvider(new AepEngineEnvironmentProviderTestApp());
    }

    @Test(expected=IllegalStateException.class)
    public void testSetEnvironmentProviderRegisterAfterEngineStart() throws Exception {
        AepEngine engine = this.createEngine("app");
        AepEngineEnvironmentProviderTestApp app = new AepEngineEnvironmentProviderTestApp();
        engine.start();
        engine.registerEnvironmentProvider(app);
        Assert.assertEquals((long)1L, (long)app.setBufferManagerCalled);
    }

    @Test
    public void testEnvironmentProviderEngineCreateRegister() throws Exception {
        AepEngine engine = this.createEngine("app");
        AepEngineEnvironmentProviderTestApp app = new AepEngineEnvironmentProviderTestApp();
        engine.registerEnvironmentProvider(app);
        Assert.assertEquals((long)1L, (long)app.setBufferManagerCalled);
        Assert.assertEquals((long)0L, (long)app.transactionStartCalled);
        Assert.assertEquals((long)0L, (long)app.transactionEndCalled);
        Assert.assertEquals((long)0L, (long)app.closeCalled);
    }

    @Test
    public void testEnvironmentProviderEngineCreateRegisterStart() throws Exception {
        AepEngineEnvironmentProviderTestApp app = new AepEngineEnvironmentProviderTestApp();
        AepEngine engine = this.createEngine("engine1", null, null, null, null, null, false, false, false, false, null, 0, 0, app, null, null, 0, false, false, null, null, null, false, false);
        engine.registerEnvironmentProvider(app);
        engine.start();
        try {
            Assert.assertTrue((boolean)app.waitForMessagingStartedEvent());
            Assert.assertEquals((long)1L, (long)app.setBufferManagerCalled);
            Assert.assertEquals((long)0L, (long)app.transactionStartCalled);
            Assert.assertEquals((long)0L, (long)app.transactionEndCalled);
            Assert.assertEquals((long)0L, (long)app.closeCalled);
        }
        finally {
            app.releaseFromMessagingStart();
        }
        Thread.sleep(1000L);
        Assert.assertEquals((long)1L, (long)app.setBufferManagerCalled);
        Assert.assertEquals((long)0L, (long)app.transactionStartCalled);
        Assert.assertEquals((long)0L, (long)app.transactionEndCalled);
        Assert.assertEquals((long)0L, (long)app.closeCalled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEnvironmentProviderEngineCreateRegisterStartProcMsgsStandalone() throws Exception {
        AepEngineEnvironmentProviderTestApp app = new AepEngineEnvironmentProviderTestApp();
        AepEngine engine = this.createEngine("engine1", null, null, null, null, null, false, false, false, false, null, 1, 1, app, null, null, 0, false, false, null, null, null, false, false);
        engine.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine.registerEnvironmentProvider(app);
        engine.start();
        try {
            Assert.assertTrue((boolean)app.waitForMessagingStartedEvent());
            Assert.assertEquals((long)1L, (long)app.setBufferManagerCalled);
            Assert.assertEquals((long)0L, (long)app.transactionStartCalled);
            Assert.assertEquals((long)0L, (long)app.transactionEndCalled);
            Assert.assertNull((Object)app.buffer);
        }
        finally {
            app.releaseFromMessagingStart();
        }
        app.messageHandlerReleased = new boolean[100];
        try {
            for (int i = 0; i < 100; ++i) {
                engine.sendMessage(app.channel1, new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto).getMessage());
                Assert.assertTrue((boolean)app.waitForMessageReceipt(i));
                try {
                    Assert.assertEquals((long)1L, (long)app.setBufferManagerCalled);
                    Assert.assertEquals((long)(i + 1), (long)app.transactionStartCalled);
                    Assert.assertEquals((long)i, (long)app.transactionEndCalled);
                    Assert.assertNotNull((Object)app.buffer);
                    Assert.assertEquals((long)254L, (long)app.buffer.remaining());
                    app.buffer.position(10 + new Random(System.currentTimeMillis()).nextInt(200));
                    Assert.assertEquals((Object)((Object)IAepEnvironmentProvider.TransactionAction.Record), (Object)((Object)app.action));
                }
                finally {
                    app.releaseFromMessageHandler();
                }
                Thread.sleep(100L);
                Assert.assertEquals((long)(i + 1), (long)app.transactionEndCalled);
            }
        }
        finally {
            app.blockInMessageHandler = false;
            app.releaseFromMessageHandler();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEnvironmentProviderEngineCreateRegisterStartProcMsgsClusteredAttachedPersistFlushOnPageFullNoDataRecorded() throws Exception {
        String appName = "app-" + System.currentTimeMillis();
        AepEngineEnvironmentProviderTestApp primary = new AepEngineEnvironmentProviderTestApp();
        primary.messageHandlerReleased = new boolean[1];
        AepEngine engine1 = this.createEngine(appName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 1, 1, primary, null, null, 0, false, false, null, null, null, false, false);
        engine1.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine1.registerEnvironmentProvider(primary);
        engine1.start();
        try {
            Assert.assertTrue((boolean)primary.waitForMessagingStartedEvent());
        }
        finally {
            primary.releaseFromMessagingStart();
        }
        AepEngineEnvironmentProviderTestApp backup = new AepEngineEnvironmentProviderTestApp();
        backup.messageHandlerReleased = new boolean[1];
        AepEngine engine2 = this.createEngine(appName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 1, 1, backup, null, null, 0, false, false, null, null, null, false, false);
        engine2.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine2.registerEnvironmentProvider(backup);
        engine2.start();
        try {
            IRogMessage message = new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto).getMessage();
            message.setMessageBus("aeptest1");
            message.setMessageChannel("channel1");
            engine1.sendMessage(primary.channel1, message);
            Assert.assertTrue((boolean)primary.waitForMessageReceipt(0));
            try {
                Assert.assertEquals((long)1L, (long)primary.setBufferManagerCalled);
                Assert.assertEquals((long)1L, (long)primary.transactionStartCalled);
                Assert.assertEquals((long)0L, (long)backup.transactionEndCalled);
                Assert.assertNotNull((Object)primary.buffer);
                Assert.assertEquals((long)254L, (long)primary.buffer.remaining());
            }
            finally {
                primary.releaseFromMessageHandler();
            }
            Thread.sleep(100L);
            Assert.assertEquals((long)1L, (long)primary.transactionEndCalled);
            Assert.assertTrue((boolean)backup.waitForMessageReceipt(0));
            try {
                Assert.assertEquals((long)1L, (long)backup.setBufferManagerCalled);
                Assert.assertEquals((long)0L, (long)backup.transactionStartCalled);
                Assert.assertEquals((long)0L, (long)backup.transactionEndCalled);
                Assert.assertEquals((long)1L, (long)primary.numMessagesReceived);
                Assert.assertNull((Object)backup.buffer);
                Assert.assertEquals(null, (Object)((Object)backup.action));
            }
            finally {
                backup.releaseFromMessageHandler();
            }
            Thread.sleep(100L);
            Assert.assertEquals((long)0L, (long)backup.transactionEndCalled);
        }
        finally {
            primary.blockInMessageHandler = false;
            primary.releaseFromMessageHandler();
            backup.releaseFromMessagingStart();
            backup.blockInMessageHandler = false;
            backup.releaseFromMessagingStart();
        }
        engine1.stop();
        primary.waitForEngineStopped();
        engine2.stop();
        backup.waitForEngineStopped();
        engine1 = this.createEngine(engine1.getDescriptor(), primary, null, null);
        engine1.registerEnvironmentProvider(primary);
        engine1.start();
        Assert.assertEquals((long)2L, (long)primary.setBufferManagerCalled);
        Assert.assertEquals((long)1L, (long)primary.transactionStartCalled);
        Assert.assertEquals((long)1L, (long)primary.transactionEndCalled);
        Assert.assertEquals((long)2L, (long)primary.numMessagesReceived);
        engine2 = this.createEngine(engine2.getDescriptor(), backup, null, null);
        engine2.registerEnvironmentProvider(backup);
        engine2.start();
        Assert.assertEquals((long)2L, (long)backup.setBufferManagerCalled);
        Assert.assertEquals((long)0L, (long)backup.transactionStartCalled);
        Assert.assertEquals((long)0L, (long)backup.transactionEndCalled);
        Assert.assertEquals((long)2L, (long)backup.numMessagesReceived);
        engine2.stop();
        backup.waitForEngineStopped();
        engine1.stop();
        primary.waitForEngineStopped();
        engine2 = this.createEngine(engine2.getDescriptor(), backup, null, null);
        engine2.registerEnvironmentProvider(backup);
        engine2.start();
        Assert.assertEquals((long)3L, (long)backup.setBufferManagerCalled);
        Assert.assertEquals((long)0L, (long)backup.transactionStartCalled);
        Assert.assertEquals((long)0L, (long)backup.transactionEndCalled);
        Assert.assertEquals((long)3L, (long)backup.numMessagesReceived);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testEnvironmentProviderEngineCreateRegisterStartProcMsgsClustered(boolean detachedPersist, boolean flushOnCommit, boolean forceBufferResize) throws Exception {
        String appName = "app-" + System.currentTimeMillis();
        AepEngineEnvironmentProviderTestApp primary = new AepEngineEnvironmentProviderTestApp();
        primary.messageHandlerReleased = new boolean[100];
        AepEngine engine1 = this.createEngine(appName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, true, detachedPersist, flushOnCommit, XRuntime.getDataDirectory() + File.separator + "m1", 1, 1, primary, null, null, 0, false, false, null, null, null, false, false);
        engine1.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine1.registerEnvironmentProvider(primary);
        engine1.start();
        try {
            Assert.assertTrue((boolean)primary.waitForMessagingStartedEvent());
            Assert.assertEquals((long)1L, (long)primary.setBufferManagerCalled);
            Assert.assertEquals((long)0L, (long)primary.transactionStartCalled);
            Assert.assertEquals((long)0L, (long)primary.transactionEndCalled);
            Assert.assertNull((Object)primary.buffer);
        }
        finally {
            primary.releaseFromMessagingStart();
        }
        AepEngineEnvironmentProviderTestApp backup = new AepEngineEnvironmentProviderTestApp();
        backup.messageHandlerReleased = new boolean[100];
        AepEngine engine2 = this.createEngine(appName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, true, detachedPersist, flushOnCommit, XRuntime.getDataDirectory() + File.separator + "m2", 1, 1, backup, null, null, 0, false, false, null, null, null, false, false);
        engine2.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine2.registerEnvironmentProvider(backup);
        engine2.start();
        try {
            int i;
            int[] sizes = new int[100];
            for (i = 0; i < 100; ++i) {
                IRogMessage message = new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto).getMessage();
                message.setMessageBus("aeptest1");
                message.setMessageChannel("channel1");
                engine1.sendMessage(primary.channel1, message);
                Assert.assertTrue((boolean)primary.waitForMessageReceipt(i));
                try {
                    Assert.assertEquals((long)1L, (long)primary.setBufferManagerCalled);
                    Assert.assertEquals((long)(i + 1), (long)primary.transactionStartCalled);
                    Assert.assertEquals((long)i, (long)primary.transactionEndCalled);
                    Assert.assertNotNull((Object)primary.buffer);
                    Assert.assertEquals((long)254L, (long)primary.buffer.remaining());
                    if (forceBufferResize) {
                        sizes[i] = 254 + new Random(System.currentTimeMillis()).nextInt(200);
                        primary.buffer = primary.bufferManager.resize(sizes[i]);
                    } else {
                        sizes[i] = 1 + new Random(System.currentTimeMillis()).nextInt(200);
                    }
                    for (int j = 0; j < sizes[i]; ++j) {
                        primary.buffer.put((byte)i);
                    }
                    Assert.assertEquals((Object)((Object)IAepEnvironmentProvider.TransactionAction.Record), (Object)((Object)primary.action));
                }
                finally {
                    primary.releaseFromMessageHandler();
                }
                Thread.sleep(100L);
                Assert.assertEquals((long)(i + 1), (long)primary.transactionEndCalled);
            }
            for (i = 0; i < 100; ++i) {
                Assert.assertTrue((boolean)backup.waitForMessageReceipt(i));
                try {
                    Assert.assertEquals((long)1L, (long)backup.setBufferManagerCalled);
                    Assert.assertEquals((long)(i + 1), (long)backup.transactionStartCalled);
                    Assert.assertEquals((long)i, (long)backup.transactionEndCalled);
                    Assert.assertNotNull((Object)backup.buffer);
                    Assert.assertEquals((long)sizes[i], (long)backup.buffer.remaining());
                    for (int j = 0; j < sizes[i]; ++j) {
                        Assert.assertEquals((long)i, (long)backup.buffer.get());
                    }
                    Assert.assertEquals((Object)((Object)IAepEnvironmentProvider.TransactionAction.Playback), (Object)((Object)backup.action));
                    continue;
                }
                finally {
                    backup.releaseFromMessageHandler();
                }
            }
        }
        finally {
            primary.blockInMessageHandler = false;
            primary.releaseFromMessageHandler();
            backup.releaseFromMessagingStart();
            backup.blockInMessageHandler = false;
            backup.releaseFromMessagingStart();
        }
        engine1.stop();
        primary.waitForEngineStopped();
        engine2.stop();
        backup.waitForEngineStopped();
        engine1 = this.createEngine(engine1.getDescriptor(), primary, null, null);
        engine1.registerEnvironmentProvider(primary);
        engine1.start();
        Assert.assertEquals((long)2L, (long)primary.setBufferManagerCalled);
        Assert.assertEquals((long)200L, (long)primary.transactionStartCalled);
        Assert.assertEquals((long)200L, (long)primary.transactionEndCalled);
        Assert.assertEquals((long)200L, (long)primary.numMessagesReceived);
        engine2 = this.createEngine(engine2.getDescriptor(), backup, null, null);
        engine2.registerEnvironmentProvider(backup);
        engine2.start();
        Assert.assertEquals((long)2L, (long)backup.setBufferManagerCalled);
        Assert.assertEquals((long)200L, (long)backup.transactionStartCalled);
        Assert.assertEquals((long)200L, (long)backup.transactionEndCalled);
        Assert.assertEquals((long)200L, (long)backup.numMessagesReceived);
        engine2.stop();
        backup.waitForEngineStopped();
        engine1.stop();
        primary.waitForEngineStopped();
        engine2 = this.createEngine(engine2.getDescriptor(), backup, null, null);
        engine2.registerEnvironmentProvider(backup);
        engine2.start();
        Assert.assertEquals((long)3L, (long)backup.setBufferManagerCalled);
        Assert.assertEquals((long)300L, (long)backup.transactionStartCalled);
        Assert.assertEquals((long)300L, (long)backup.transactionEndCalled);
        Assert.assertEquals((long)300L, (long)backup.numMessagesReceived);
        engine2.stop();
        backup.waitForEngineStopped();
    }

    @Test
    public void testEnvironmentProviderEngineCreateRegisterStartProcMsgsClusteredAttachedPersistFlushOnPageFull() throws Exception {
        this.testEnvironmentProviderEngineCreateRegisterStartProcMsgsClustered(false, false, false);
    }

    @Test
    public void testEnvironmentProviderEngineCreateRegisterStartProcMsgsClusteredAttachedPersistFlushOnCommit() throws Exception {
        this.testEnvironmentProviderEngineCreateRegisterStartProcMsgsClustered(false, true, false);
    }

    @Test
    public void testEnvironmentProviderEngineCreateRegisterStartProcMsgsClusteredDetachedPersistFlushOnPageFull() throws Exception {
        this.testEnvironmentProviderEngineCreateRegisterStartProcMsgsClustered(true, false, false);
    }

    @Test
    public void testEnvironmentProviderEngineCreateRegisterStartProcMsgsClusteredDetachedPersistFlushOnCommit() throws Exception {
        this.testEnvironmentProviderEngineCreateRegisterStartProcMsgsClustered(true, true, false);
    }

    @Test
    public void testEnvironmentProviderEngineCreateRegisterStartProcMsgsClusteredAttachedPersistFlushOnPageFullWithBufferResize() throws Exception {
        this.testEnvironmentProviderEngineCreateRegisterStartProcMsgsClustered(false, false, true);
    }

    @Test
    public void testEnvironmentProviderEngineCreateRegisterStop() throws Exception {
        AepEngine engine = this.createEngine("app");
        AepEngineEnvironmentProviderTestApp app = new AepEngineEnvironmentProviderTestApp();
        engine.registerEnvironmentProvider(app);
        engine.stop();
        Assert.assertEquals((long)1L, (long)app.setBufferManagerCalled);
        Assert.assertEquals((long)0L, (long)app.transactionStartCalled);
        Assert.assertEquals((long)0L, (long)app.transactionEndCalled);
        Assert.assertEquals((long)1L, (long)app.closeCalled);
    }

    @Test
    public void testEnvironmentProviderEngineCreateRegisterStartStop() throws Exception {
        AepEngineEnvironmentProviderTestApp app = new AepEngineEnvironmentProviderTestApp();
        AepEngine engine = this.createEngine("engine1", null, null, null, null, null, false, false, false, false, null, 0, 0, app, null, null, 0, false, false, null, null, null, false, false);
        engine.registerEnvironmentProvider(app);
        engine.start();
        app.releaseFromMessagingStart();
        engine.stop();
        Assert.assertEquals((long)1L, (long)app.closeCalled);
    }
}

