/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.AepEngineDescriptor;
import com.neeve.aep.EAepException;
import com.neeve.aep.test.unit.AepEngineDiskFailTestApp;
import com.neeve.aep.test.unit.AepEngineTest;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.ci.XRuntime;
import com.neeve.ods.IStoreBinding;
import com.neeve.rog.IRogMessage;
import com.neeve.rog.log.RogLog;
import com.neeve.sma.MessageChannel;
import java.io.File;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class AepEngineDiskFailTest
extends AepEngineTest {
    @Test
    @Ignore
    public void testStandaloneDiskFailDuringInitRead() throws Exception {
    }

    @Test
    public void testStandaloneDiskFailDuringSteadyStateWrite() throws Exception {
        this.testStandalonePersisterFailDuringSteadyStateWrite(PersisterFailure.Store, true);
    }

    @Test
    public void testStandaloneOutboundLoggerFailDuringSteadyStateWriteWithStopLoggingPolicy() throws Exception {
        this.testStandalonePersisterFailDuringSteadyStateWrite(PersisterFailure.Outbound, false);
    }

    @Test
    public void testStandaloneOutboundLoggerFailDuringSteadyStateWriteWithStopEnginePolicy() throws Exception {
        this.testStandalonePersisterFailDuringSteadyStateWrite(PersisterFailure.Outbound, true);
    }

    @Test
    public void testStandaloneInboundLoggerFailDuringSteadyStateWriteWithStopLoggingPolicy() throws Exception {
        this.testStandalonePersisterFailDuringSteadyStateWrite(PersisterFailure.Inbound, false);
    }

    @Test
    public void testStandaloneInboundLoggerFailDuringSteadyStateWriteWithStopEnginePolicy() throws Exception {
        this.testStandalonePersisterFailDuringSteadyStateWrite(PersisterFailure.Inbound, true);
    }

    private void testStandalonePersisterFailDuringSteadyStateWrite(final PersisterFailure failureType, final boolean failureShouldStopEngine) throws Exception {
        AepEngineDiskFailTestApp sender = new AepEngineDiskFailTestApp();
        String receiverName = "engine-" + System.currentTimeMillis() + "-" + AepEngineTest.engineCounter++;
        AepEngineDiskFailTestApp receiver = new AepEngineDiskFailTestApp();
        this.engineCustomizer = new AepEngineTest.BaseEngineCusomizer(){

            @Override
            public void customizeEngine(AepEngineDescriptor descriptor) {
                if (failureType == PersisterFailure.Outbound) {
                    descriptor.setOutboundMessageLoggingPolicy(AepEngine.OutboundMessageLoggingPolicy.UseDedicated);
                    descriptor.setOutboundMessageLoggingFailurePolicy(failureShouldStopEngine ? AepEngine.OutboundMessageLoggingFailurePolicy.StopEngine : AepEngine.OutboundMessageLoggingFailurePolicy.StopLogging);
                } else if (failureType == PersisterFailure.Inbound) {
                    descriptor.setInboundMessageLoggingPolicy(AepEngine.InboundMessageLoggingPolicy.UseDedicated);
                    descriptor.setInboundMessageLoggingFailurePolicy(failureShouldStopEngine ? AepEngine.InboundMessageLoggingFailurePolicy.StopEngine : AepEngine.InboundMessageLoggingFailurePolicy.StopLogging);
                }
            }
        };
        this.startSenderStandaloneReceiverStandalone(sender, null, receiverName, receiver, null, 3, 1, 3, 2, failureType == PersisterFailure.Inbound ? AepEngine.HAPolicy.StateReplication : AepEngine.HAPolicy.EventSourcing, true, true);
        receiver.engine = (AepEngine)((Object)this.engines.get(1));
        SenderThread senderThread = new SenderThread((AepEngine)((Object)this.engines.get(0)), sender.receiveChannel);
        senderThread.start();
        Thread.sleep(1000L);
        Exception failure = new Exception("Intentional test failure");
        switch (failureType) {
            case Inbound: {
                ((RogLog)((AepEngine)((Object)this.engines.get(1))).getInboundMessageLogger()).fail(failure);
                break;
            }
            case Outbound: {
                ((RogLog)((AepEngine)((Object)this.engines.get(1))).getOutboundMessageLogger()).fail(failure);
                break;
            }
            case Store: {
                ((RogLog)((AepEngine)((Object)this.engines.get(1))).getStore().getPersister()).fail(failure);
            }
        }
        Thread.sleep(2000L);
        senderThread.shutdown();
        Assert.assertNull((Object)senderThread.e);
        if (failureShouldStopEngine) {
            switch (failureType) {
                case Inbound: {
                    Assert.assertEquals((String)"Didn't get expected inbound logging exception", (long)1L, (long)receiver.waitForInboundLoggingException(5, 1));
                    break;
                }
                case Outbound: {
                    Assert.assertEquals((String)"Didn't get expected outbound logging exception", (long)1L, (long)receiver.waitForOutboundLoggingException(5, 1));
                    break;
                }
            }
            Assert.assertTrue((String)"Engine should have stopped on failure", (boolean)receiver.waitForEngineStoppedEvent());
        } else {
            switch (failureType) {
                case Inbound: {
                    Assert.assertNull((String)"Inbound message logger should be null wien configured to stop logging on failure", (Object)((AepEngine)((Object)this.engines.get(1))).getInboundMessageLogger());
                    Assert.assertEquals((String)"Didn't get expected inbound logging exception", (long)1L, (long)receiver.waitForInboundLoggingException(5, 1));
                    break;
                }
                case Outbound: {
                    Assert.assertNull((String)"Outbound message logger should be null wien configured to stop logging on failure", (Object)((AepEngine)((Object)this.engines.get(1))).getInboundMessageLogger());
                    Assert.assertEquals((String)"Didn't get expected outbound logging exception", (long)1L, (long)receiver.waitForOutboundLoggingException(5, 1));
                    break;
                }
                case Store: {
                    throw new IllegalArgumentException("Invalid test criteria. Failure of store persister will fail engine");
                }
            }
        }
    }

    @Test
    @Ignore
    public void testPrimaryDiskFailDuringInitRead() throws Exception {
    }

    @Test
    public void testPrimaryDiskFailDuringSteadyStateWrite() throws Exception {
        this.testPrimaryDiskFailDuringSteadyStateWrite(PersisterFailure.Store, true);
    }

    @Test
    public void testPrimaryOutboundLoggerFailDuringSteadyStateWriteWithStopLoggingPolicy() throws Exception {
        this.testPrimaryDiskFailDuringSteadyStateWrite(PersisterFailure.Outbound, false);
    }

    @Test
    public void testPrimaryOutboundLoggerFailDuringSteadyStateWriteWithStopEnginePolicy() throws Exception {
        this.testPrimaryDiskFailDuringSteadyStateWrite(PersisterFailure.Outbound, true);
    }

    @Test
    public void testPrimaryInboundLoggerFailDuringSteadyStateWriteWithStopLoggingPolicy() throws Exception {
        this.testPrimaryDiskFailDuringSteadyStateWrite(PersisterFailure.Inbound, false);
    }

    @Test
    public void testPrimaryInboundLoggerFailDuringSteadyStateWriteWithStopEnginePolicy() throws Exception {
        this.testPrimaryDiskFailDuringSteadyStateWrite(PersisterFailure.Inbound, true);
    }

    private void testPrimaryDiskFailDuringSteadyStateWrite(final PersisterFailure failureType, final boolean failureShouldStopEngine) throws Exception {
        AepEngineDiskFailTestApp sender = new AepEngineDiskFailTestApp();
        String receiverName = "engine-" + System.currentTimeMillis() + "-" + AepEngineTest.engineCounter++;
        AepEngineDiskFailTestApp receiver1 = new AepEngineDiskFailTestApp();
        AepEngineDiskFailTestApp receiver2 = new AepEngineDiskFailTestApp();
        this.engineCustomizer = new AepEngineTest.BaseEngineCusomizer(){

            @Override
            public void customizeEngine(AepEngineDescriptor descriptor) {
                if (failureType == PersisterFailure.Outbound) {
                    descriptor.setOutboundMessageLoggingPolicy(AepEngine.OutboundMessageLoggingPolicy.UseDedicated);
                    descriptor.setOutboundMessageLoggingFailurePolicy(failureShouldStopEngine ? AepEngine.OutboundMessageLoggingFailurePolicy.StopEngine : AepEngine.OutboundMessageLoggingFailurePolicy.StopLogging);
                } else if (failureType == PersisterFailure.Inbound) {
                    descriptor.setInboundMessageLoggingPolicy(AepEngine.InboundMessageLoggingPolicy.UseDedicated);
                    descriptor.setInboundMessageLoggingFailurePolicy(failureShouldStopEngine ? AepEngine.InboundMessageLoggingFailurePolicy.StopEngine : AepEngine.InboundMessageLoggingFailurePolicy.StopLogging);
                }
            }
        };
        this.startSenderStandaloneReceiverRedundant(sender, null, receiverName, receiver1, null, receiver2, null, 3, 1, 3, 2, failureType == PersisterFailure.Inbound ? AepEngine.HAPolicy.StateReplication : AepEngine.HAPolicy.EventSourcing, true, false, 0);
        receiver1.engine = (AepEngine)((Object)this.engines.get(1));
        receiver2.engine = (AepEngine)((Object)this.engines.get(2));
        SenderThread senderThread = new SenderThread((AepEngine)((Object)this.engines.get(0)), sender.receiveChannel);
        senderThread.start();
        receiver1.engine = (AepEngine)((Object)this.engines.get(1));
        receiver1.waitForCommitCompletions(5, 5);
        Exception failure = new Exception("Intentional test failure");
        switch (failureType) {
            case Inbound: {
                ((RogLog)((AepEngine)((Object)this.engines.get(1))).getInboundMessageLogger()).fail(failure);
                break;
            }
            case Outbound: {
                ((RogLog)((AepEngine)((Object)this.engines.get(1))).getOutboundMessageLogger()).fail(failure);
                break;
            }
            case Store: {
                ((RogLog)((AepEngine)((Object)this.engines.get(1))).getStore().getPersister()).fail(failure);
            }
        }
        Thread.sleep(2000L);
        senderThread.shutdown();
        Assert.assertNull((Object)senderThread.e);
        if (failureShouldStopEngine) {
            switch (failureType) {
                case Inbound: {
                    Assert.assertEquals((String)"Didn't get expected inbound logging exception", (long)1L, (long)receiver1.waitForInboundLoggingException(5, 1));
                    break;
                }
                case Outbound: {
                    Assert.assertEquals((String)"Didn't get expected outbound logging exception", (long)1L, (long)receiver1.waitForOutboundLoggingException(5, 1));
                    break;
                }
            }
            Assert.assertTrue((boolean)receiver1.waitForEngineStoppedEvent());
            ((AepEngine)((Object)this.engines.get(2))).waitForMessagingToStart();
            Assert.assertEquals((String)"Receiver didn't receiver member up event", (long)1L, (long)receiver2.waitForMemberUpEvents(5, 1));
            Assert.assertEquals((String)"Receiver didn't receiver member down event", (long)1L, (long)receiver2.waitForMemberDownEvents(5, 1));
            Assert.assertEquals((Object)IStoreBinding.Role.Primary, (Object)((AepEngine)((Object)this.engines.get(2))).getStore().getRole());
            Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)((AepEngine)((Object)this.engines.get(2))).getState()));
            Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Started), (Object)((Object)((AepEngine)((Object)this.engines.get(2))).getMessagingState()));
        } else {
            switch (failureType) {
                case Inbound: {
                    Assert.assertNull((String)"Inbound message logger should be null when configured to stop logging on failure", (Object)((AepEngine)((Object)this.engines.get(1))).getInboundMessageLogger());
                    Assert.assertEquals((String)"Didn't get expected inbound logging exception", (long)1L, (long)receiver1.waitForInboundLoggingException(5, 1));
                    break;
                }
                case Outbound: {
                    Assert.assertNull((String)"Outbound message logger should be null when configured to stop logging on failure", (Object)((AepEngine)((Object)this.engines.get(1))).getInboundMessageLogger());
                    Assert.assertEquals((String)"Didn't get expected outbound logging exception", (long)1L, (long)receiver1.waitForOutboundLoggingException(5, 1));
                    break;
                }
                case Store: {
                    throw new IllegalArgumentException("Invalid test criteria. Failure of store persister will fail engine");
                }
            }
        }
    }

    @Test
    public void testBackupDiskFailDuringInitWrite() throws Exception {
        AepEngine engine3;
        AepEngineDiskFailTestApp sender = new AepEngineDiskFailTestApp();
        String receiverName = "engine-" + System.currentTimeMillis() + "-" + AepEngineTest.engineCounter++;
        AepEngineDiskFailTestApp receiver1 = new AepEngineDiskFailTestApp();
        AepEngineDiskFailTestApp receiver2 = new AepEngineDiskFailTestApp();
        AepEngine engine1 = this.createEngine("engine1", null, null, null, null, null, false, false, false, false, null, 3, 2, sender, null, null, 0, false, false, null, null, null, false, false);
        engine1.start();
        engine1.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)engine1.getState()), (Object)((Object)AepEngine.State.Started));
        Assert.assertEquals((Object)((Object)engine1.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Started));
        AepEngine engine2 = this.createEngine(receiverName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 3, 1, receiver1, null, null, 0, false, false, null, null, null, false, false);
        engine2.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine2.start();
        engine2.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)engine2.getState()), (Object)((Object)AepEngine.State.Started));
        Assert.assertEquals((Object)((Object)engine2.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Started));
        receiver1.engine = engine2;
        SenderThread senderThread = new SenderThread((AepEngine)((Object)this.engines.get(0)), sender.receiveChannel);
        senderThread.start();
        Thread.sleep(5000L);
        senderThread.shutdown();
        Assert.assertNull((Object)senderThread.e);
        receiver2.engine = engine3 = this.createEngine(receiverName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 3, 1, receiver2, null, null, 0, false, false, null, null, null, false, false);
        engine3.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        receiver2.failPersisterOn(10);
        try {
            engine3.start();
            engine3.waitForMessagingToStart();
            Assert.fail((String)"messaging started on backup successfully!");
        }
        catch (EAepException e) {
            Assert.assertTrue((boolean)receiver2.waitForEngineStoppedEvent());
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)receiver2.waitForEngineStoppedEvent());
        }
        Thread.sleep(1000L);
        Assert.assertEquals((String)"Receiver didn't receiver member up event", (long)1L, (long)receiver1.waitForMemberUpEvents(5, 1));
        Assert.assertEquals((String)"Receiver didn't receiver member down event", (long)1L, (long)receiver1.waitForMemberDownEvents(5, 1));
        Assert.assertEquals((Object)IStoreBinding.Role.Primary, (Object)engine2.getStore().getRole());
        Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine2.getState()));
        Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Started), (Object)((Object)engine2.getMessagingState()));
    }

    @Test
    public void testBackupDiskFailDuringSteadyStateWrite() throws Exception {
        AepEngineDiskFailTestApp sender = new AepEngineDiskFailTestApp();
        String receiverName = "engine-" + System.currentTimeMillis() + "-" + AepEngineTest.engineCounter++;
        AepEngineDiskFailTestApp receiver1 = new AepEngineDiskFailTestApp();
        AepEngineDiskFailTestApp receiver2 = new AepEngineDiskFailTestApp();
        this.startSenderStandaloneReceiverRedundant(sender, null, receiverName, receiver1, null, receiver2, null, 3, 1, 3, 2, AepEngine.HAPolicy.EventSourcing, true, false, 0);
        receiver1.engine = (AepEngine)((Object)this.engines.get(1));
        receiver2.engine = (AepEngine)((Object)this.engines.get(2));
        SenderThread senderThread = new SenderThread((AepEngine)((Object)this.engines.get(0)), sender.receiveChannel);
        senderThread.start();
        Thread.sleep(1000L);
        ((RogLog)((AepEngine)((Object)this.engines.get(2))).getStore().getPersister()).fail();
        senderThread.shutdown();
        Assert.assertNull((Object)senderThread.e);
        Assert.assertTrue((boolean)receiver2.waitForEngineStoppedEvent());
        Thread.sleep(1000L);
        Assert.assertEquals((String)"Receiver didn't receiver member up event", (long)1L, (long)receiver1.waitForMemberUpEvents(5, 1));
        Assert.assertEquals((String)"Receiver didn't receiver member down event", (long)1L, (long)receiver1.waitForMemberDownEvents(5, 1));
        Assert.assertEquals((Object)IStoreBinding.Role.Primary, (Object)((AepEngine)((Object)this.engines.get(1))).getStore().getRole());
        Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)((AepEngine)((Object)this.engines.get(1))).getState()));
        Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Started), (Object)((Object)((AepEngine)((Object)this.engines.get(1))).getMessagingState()));
    }

    static enum PersisterFailure {
        Store,
        Inbound,
        Outbound;

    }

    private final class SenderThread
    extends Thread {
        private final AepEngine engine;
        private final MessageChannel channel;
        Throwable e;
        int messageCount;
        volatile boolean done;

        SenderThread(AepEngine engine, MessageChannel channel) {
            this.engine = engine;
            this.channel = channel;
        }

        private final void send() {
            if (!this.done) {
                IRogMessage message = new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto).getMessage();
                this.engine.sendMessage(this.channel, message);
                ++this.messageCount;
            }
        }

        final void shutdown() {
            this.done = true;
            while (true) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            System.out.println("Total Sent..." + this.messageCount);
        }

        @Override
        public final void run() {
            long last = System.currentTimeMillis();
            while (!this.done) {
                try {
                    this.send();
                    if (System.currentTimeMillis() - last < 1000L) continue;
                    System.out.println("Sent..." + this.messageCount);
                    last = System.currentTimeMillis();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    this.e = e;
                    this.done = true;
                }
            }
        }
    }
}

