/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.event.AepChannelUpEvent;
import com.neeve.aep.event.AepTransactionStageEvent;
import com.neeve.aep.test.unit.generated.proto.Message;
import com.neeve.rog.IRogMessage;
import com.neeve.sma.MessageChannel;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class AepEngineCommitSuspensionTestApp {
    AepEngine engine;
    boolean suspend;
    MessageChannel channel1;
    MessageChannel channel4;
    ArrayList<IRogMessage> messages = new ArrayList();
    int numStageEventMessages;
    ExecutorService pool = Executors.newSingleThreadExecutor();

    final boolean waitForExpectedMessageReceipt(int expectedMessageCount) {
        for (int i = 0; i < 10; ++i) {
            System.out.println("received " + this.messages.size() + "...");
            if (this.messages.size() < expectedMessageCount) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            return true;
        }
        return false;
    }

    final void shutdown() {
        this.pool.shutdown();
    }

    @EventHandler(source="channel1@aeptest1")
    public void onChannel1UpEventHandler(AepChannelUpEvent event) {
        this.channel1 = event.getMessageChannel();
    }

    @EventHandler(source="channel4@aeptest1")
    public void onChannel4UpEventHandler(AepChannelUpEvent event) {
        this.channel4 = event.getMessageChannel();
    }

    @EventHandler
    public void onTransactionStage(AepTransactionStageEvent event) {
        if (event.getStage() == AepTransactionStageEvent.TransactionStage.Start) {
            this.numStageEventMessages += event.getCommitContext().getInboundEventCount();
            event.setSuspend(this.suspend);
            if (this.suspend) {
                this.pool.execute(new CommitResumer(event.getCommitContext()));
            }
        }
    }

    @EventHandler
    public void onProtoMessageHandler(Message message) {
        this.messages.add(message);
    }

    private final class CommitResumer
    implements Runnable {
        final AepTransactionStageEvent.ICommitContext context;

        CommitResumer(AepTransactionStageEvent.ICommitContext context) {
            this.context = context;
        }

        @Override
        public final void run() {
            AepEngineCommitSuspensionTestApp.this.engine.resumeCommit(this.context);
        }
    }
}

