/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.event.AepApplicationExceptionEvent;
import com.neeve.aep.event.AepChannelDownEvent;
import com.neeve.aep.event.AepChannelUpEvent;
import com.neeve.aep.event.AepEngineStoppedEvent;
import com.neeve.aep.event.AepMessagingPrestartEvent;
import com.neeve.aep.test.unit.AepEngineTestApp;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.aep.test.unit.generated.proto.Message;
import com.neeve.rog.IRogMessage;
import com.neeve.sma.event.UnhandledMessageEvent;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class AepEngineAppExceptionTestApp
extends AepEngineTestApp {
    AepEngine engine;
    int inMessageCount;
    boolean engineStopped;
    Exception engineStoppedCause;
    Object waitOnPrestartObject = new Object();
    boolean releaseFromPrestart;
    boolean shouldFail;
    boolean throwError;
    RuntimeException appException = new RuntimeException("deliberate exception");
    Error appError = new Error("deliberate error");
    CountDownLatch sendLatch = new CountDownLatch(1);
    private Throwable eventException = null;
    private IRogMessage eventMessage = null;

    final boolean waitForExpectedMessageReceipt(int expectedMessageCount) {
        for (int i = 0; i < 10; ++i) {
            System.out.println("received " + this.inMessageCount + "... (expected=" + expectedMessageCount + ")");
            if (this.inMessageCount < expectedMessageCount) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            return true;
        }
        return false;
    }

    final boolean waitForEngineStopped() {
        for (int i = 0; i < 10; ++i) {
            if (!this.engineStopped) {
                System.out.println("Engine not stopped");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void releaseFromPrestart() {
        Object object = this.waitOnPrestartObject;
        synchronized (object) {
            this.releaseFromPrestart = true;
            this.waitOnPrestartObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    public void onMessagingPrestart(AepMessagingPrestartEvent event) {
        Object object = this.waitOnPrestartObject;
        synchronized (object) {
            while (!this.releaseFromPrestart) {
                try {
                    this.waitOnPrestartObject.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @EventHandler(source="channel5@aeptest1")
    public void onChannel5UpEventHandler(AepChannelUpEvent event) {
        this.channel5 = event.getMessageChannel();
    }

    @EventHandler(source="channel5@aeptest1")
    public void onChannel5DownEventHandler(AepChannelDownEvent event) {
        this.channel5 = null;
    }

    @EventHandler(source="channel6@aeptest1")
    public void onChannel6UpEventHandler(AepChannelUpEvent event) {
        this.channel6 = event.getMessageChannel();
    }

    @EventHandler(source="channel6@aeptest1")
    public void onChannel6DownEventHandler(AepChannelDownEvent event) {
        this.channel6 = null;
    }

    @EventHandler
    public void onProtoMessageHandler(Message message) {
        if (++this.inMessageCount == 10) {
            AepEngineTestMessage out = new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto);
            out.getMessage().setMessageBus("aeptest1");
            out.getMessage().setMessageChannel("channel6");
            this.engine.sendMessage(this.channel6, out.getMessage());
            if (this.shouldFail) {
                try {
                    this.sendLatch.await(60L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    System.err.println("Timed out waiting for messages to be sent");
                }
                if (this.throwError) {
                    throw this.appError;
                }
                throw this.appException;
            }
        }
    }

    @EventHandler
    public void onEngineStopped(AepEngineStoppedEvent event) {
        this.engineStopped = true;
        this.engineStoppedCause = event.getCause();
    }

    @EventHandler
    public void onApplicationException(AepApplicationExceptionEvent event) {
        this.setEventException(event.getException());
        this.setEventMessage(event.getActiveMessage());
        System.out.println("App Exception" + (Object)((Object)event));
    }

    @EventHandler
    public void onUnhandledMessage(UnhandledMessageEvent event) {
        if (event.getMessageMetadata() == null) {
            throw new RuntimeException("Intentional Exception");
        }
    }

    public void onMessagesSent() {
        this.sendLatch.countDown();
    }

    public Throwable getEventException() {
        return this.eventException;
    }

    public void setEventException(Throwable eventException) {
        this.eventException = eventException;
    }

    public IRogMessage getEventMessage() {
        return this.eventMessage;
    }

    public void setEventMessage(IRogMessage eventMessage) {
        this.eventMessage = eventMessage;
    }
}

