/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.EAepAppException;
import com.neeve.aep.EAepException;
import com.neeve.aep.test.unit.AepEngineAppExceptionTestApp;
import com.neeve.aep.test.unit.AepEngineTest;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.ci.XRuntime;
import com.neeve.event.Event;
import com.neeve.sma.event.UnhandledMessageEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class AepEngineAppExceptionTest
extends AepEngineTest {
    final List<AepEngineTestMessage> createMessagesToSend(AepEngineTestObject.EncodingType encodingType) {
        ArrayList<AepEngineTestMessage> list = new ArrayList<AepEngineTestMessage>();
        for (int i = 0; i < 20; ++i) {
            list.add(new AepEngineTestMessage(encodingType));
        }
        return list;
    }

    private final void testAppExceptionInvalidQuarantineChannel(AepEngine.HAPolicy haPolicy, String quarantineChannel) throws Exception {
        AepEngine engine;
        AepEngineAppExceptionTestApp app = new AepEngineAppExceptionTestApp();
        String appName = "engine-" + System.currentTimeMillis();
        app.engine = engine = this.createEngine(appName, haPolicy, null, null, null, null, false, false, false, false, null, 31, 16, app, null, null, 0, false, false, AepEngine.AppExceptionHandlingPolicy.QuarantineAndStop, quarantineChannel, null, false, false);
        engine.start();
        engine.waitForMessagingToStart();
    }

    @Test(expected=EAepException.class)
    public void testAppExceptionInvalidQuarantineChannelNoChannelEventSourcing() throws Exception {
        this.testAppExceptionInvalidQuarantineChannel(AepEngine.HAPolicy.EventSourcing, "@aeptest1");
    }

    @Test(expected=EAepException.class)
    public void testAppExceptionInvalidQuarantineChannelNoChannelStateReplication() throws Exception {
        this.testAppExceptionInvalidQuarantineChannel(AepEngine.HAPolicy.StateReplication, "@aeptest1");
    }

    @Test(expected=EAepException.class)
    public void testAppExceptionInvalidQuarantineChannelNoBusEventSourcing() throws Exception {
        this.testAppExceptionInvalidQuarantineChannel(AepEngine.HAPolicy.EventSourcing, "channel1@");
    }

    @Test(expected=EAepException.class)
    public void testAppExceptionInvalidQuarantineChannelNoBusStateReplication() throws Exception {
        this.testAppExceptionInvalidQuarantineChannel(AepEngine.HAPolicy.StateReplication, "channel1@");
    }

    @Test(expected=EAepException.class)
    public void testAppExceptionInvalidQuarantineChannelInvalidChannelEventSourcing() throws Exception {
        this.testAppExceptionInvalidQuarantineChannel(AepEngine.HAPolicy.EventSourcing, "invalidchannel@aeptest1");
    }

    @Test(expected=EAepException.class)
    public void testAppExceptionInvalidQuarantineChannelInvalidChannelStateReplication() throws Exception {
        this.testAppExceptionInvalidQuarantineChannel(AepEngine.HAPolicy.StateReplication, "invalidchannel@aeptest1");
    }

    @Test(expected=EAepException.class)
    public void testAppExceptionInvalidQuarantineChannelInvalidBusEventSourcing() throws Exception {
        this.testAppExceptionInvalidQuarantineChannel(AepEngine.HAPolicy.EventSourcing, "channel1@invalidbus");
    }

    @Test(expected=EAepException.class)
    public void testAppExceptionInvalidQuarantineChannelInvalidBusStateReplication() throws Exception {
        this.testAppExceptionInvalidQuarantineChannel(AepEngine.HAPolicy.StateReplication, "channel1@invalidbus");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void testAppExceptionLogExceptionAndContinue(AepEngine.HAPolicy haPolicy) throws Exception {
        AepEngine engine4;
        AepEngine engine3;
        AepEngine engine2;
        AepEngine engine1;
        AepEngineAppExceptionTestApp app11 = new AepEngineAppExceptionTestApp();
        String app1Name = "engine-" + System.currentTimeMillis();
        app11.engine = engine1 = this.createEngine(app1Name, haPolicy, null, null, null, AepEngine.OutboundMessageLoggingPolicy.UseDedicated, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 63, 16, app11, null, null, 0, false, false, AepEngine.AppExceptionHandlingPolicy.LogExceptionAndContinue, null, null, false, false);
        app11.shouldFail = true;
        engine1.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine1.start();
        app11.releaseFromPrestart();
        engine1.waitForMessagingToStart();
        AepEngineAppExceptionTestApp app12 = new AepEngineAppExceptionTestApp();
        app12.engine = engine2 = this.createEngine(app1Name, haPolicy, null, null, null, AepEngine.OutboundMessageLoggingPolicy.UseDedicated, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 63, 16, app12, null, null, 0, false, false, AepEngine.AppExceptionHandlingPolicy.LogExceptionAndContinue, null, null, false, false);
        app12.shouldFail = true;
        engine2.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine2.start();
        AepEngineAppExceptionTestApp app2 = new AepEngineAppExceptionTestApp();
        String app2Name = "engine-" + System.currentTimeMillis() + "-100";
        app2.engine = engine3 = this.createEngine(app2Name, AepEngine.HAPolicy.EventSourcing, null, null, AepEngine.InboundMessageLoggingPolicy.UseDedicated, AepEngine.OutboundMessageLoggingPolicy.UseDedicated, false, false, false, false, null, 47, 40, app2, null, null, 0, false, false, null, null, null, false, false);
        engine3.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine3.start();
        app2.releaseFromPrestart();
        engine3.waitForMessagingToStart();
        List<AepEngineTestMessage> messages = this.createMessagesToSend(AepEngineTestObject.EncodingType.Proto);
        for (AepEngineTestMessage message : messages) {
            message.getMessage().setMessageBus("aeptest1");
            message.getMessage().setMessageChannel("channel1");
            engine1.sendMessage(app11.channel5, message.getMessage());
        }
        app11.onMessagesSent();
        app12.onMessagesSent();
        try {
            Assert.assertTrue((boolean)app11.waitForExpectedMessageReceipt(20));
            Assert.assertNotNull((Object)app11.getEventMessage());
            Assert.assertEquals(messages.get(9).getMessage().getClass(), app11.getEventMessage().getClass());
            Assert.assertNotNull((Object)app11.getEventException());
            Assert.assertEquals((Object)app11.appException, (Object)app11.getEventException());
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            switch (haPolicy) {
                case EventSourcing: {
                    Assert.assertTrue((boolean)app12.waitForExpectedMessageReceipt(20));
                    break;
                }
                case StateReplication: {
                    Assert.assertEquals((long)0L, (long)app12.inMessageCount);
                }
            }
            Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine1.getState()));
            Assert.assertTrue((boolean)engine1.isPrimary());
            Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine2.getState()));
            Assert.assertFalse((boolean)engine2.isPrimary());
            Assert.assertEquals((long)1L, (long)app2.inMessageCount);
        }
        finally {
            app12.releaseFromPrestart();
        }
        engine2.stop();
        Assert.assertTrue((boolean)app12.waitForEngineStopped());
        engine1.stop();
        Assert.assertTrue((boolean)app11.waitForEngineStopped());
        AepEngineAppExceptionTestApp app13 = new AepEngineAppExceptionTestApp();
        app13.engine = engine4 = this.createEngine(app1Name, haPolicy, null, null, null, AepEngine.OutboundMessageLoggingPolicy.UseDedicated, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 63, 16, app13, null, null, 0, false, false, AepEngine.AppExceptionHandlingPolicy.LogExceptionAndContinue, null, null, false, false);
        app13.onMessagesSent();
        app13.shouldFail = true;
        engine4.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine4.start();
        app13.releaseFromPrestart();
        engine4.waitForMessagingToStart();
        switch (haPolicy) {
            case EventSourcing: {
                Assert.assertEquals((long)20L, (long)app13.inMessageCount);
                break;
            }
            case StateReplication: {
                Assert.assertEquals((long)0L, (long)app13.inMessageCount);
            }
        }
        Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine4.getState()));
        Assert.assertTrue((boolean)engine4.isPrimary());
    }

    @Test
    public void testAppExceptionLogExceptionAndContinueEventSourcing() throws Exception {
        this.testAppExceptionLogExceptionAndContinue(AepEngine.HAPolicy.EventSourcing);
    }

    @Test
    public void testAppExceptionLogExceptionAndContinueStateReplication() throws Exception {
        this.testAppExceptionLogExceptionAndContinue(AepEngine.HAPolicy.StateReplication);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void testAppExceptionRollbackAndStop(AepEngine.HAPolicy haPolicy) throws Exception {
        AepEngine engine3;
        AepEngine engine2;
        AepEngine engine1;
        AepEngineAppExceptionTestApp app11 = new AepEngineAppExceptionTestApp();
        String app1Name = "engine-" + System.currentTimeMillis();
        app11.engine = engine1 = this.createEngine(app1Name, haPolicy, null, null, null, AepEngine.OutboundMessageLoggingPolicy.UseDedicated, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 63, 16, app11, null, null, 0, false, false, AepEngine.AppExceptionHandlingPolicy.RollbackAndStop, null, null, false, false);
        app11.shouldFail = true;
        engine1.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine1.start();
        app11.releaseFromPrestart();
        engine1.waitForMessagingToStart();
        AepEngineAppExceptionTestApp app12 = new AepEngineAppExceptionTestApp();
        app12.engine = engine2 = this.createEngine(app1Name, haPolicy, null, null, null, AepEngine.OutboundMessageLoggingPolicy.UseDedicated, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 63, 16, app12, null, null, 0, false, false, AepEngine.AppExceptionHandlingPolicy.RollbackAndStop, null, null, false, false);
        app12.shouldFail = false;
        engine2.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine2.start();
        AepEngineAppExceptionTestApp app2 = new AepEngineAppExceptionTestApp();
        String app2Name = "engine-" + System.currentTimeMillis() + "-100";
        app2.engine = engine3 = this.createEngine(app2Name, AepEngine.HAPolicy.EventSourcing, null, null, AepEngine.InboundMessageLoggingPolicy.UseDedicated, AepEngine.OutboundMessageLoggingPolicy.UseDedicated, false, false, false, false, null, 47, 40, app2, null, null, 0, false, false, null, null, null, false, false);
        engine3.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine3.start();
        app2.releaseFromPrestart();
        engine3.waitForMessagingToStart();
        List<AepEngineTestMessage> messages = this.createMessagesToSend(AepEngineTestObject.EncodingType.Proto);
        int i = 0;
        for (AepEngineTestMessage message : messages) {
            message.getMessage().setMessageBus("aeptest1");
            message.getMessage().setMessageChannel("channel1");
            engine1.sendMessage(app11.channel5, message.getMessage());
            if (++i != 1) continue;
            Thread.sleep(100L);
        }
        app11.onMessagesSent();
        app12.onMessagesSent();
        try {
            app11.waitForEngineStopped();
            Assert.assertTrue((boolean)(app11.engineStoppedCause instanceof EAepAppException));
            Assert.assertSame((Object)app11.appException, (Object)((EAepAppException)app11.engineStoppedCause).getCause());
            Assert.assertEquals((long)10L, (long)app11.inMessageCount);
            Assert.assertNotNull((Object)app11.getEventMessage());
            Assert.assertEquals(messages.get(9).getMessage().getClass(), app11.getEventMessage().getClass());
            Assert.assertNotNull((Object)app11.getEventException());
            Assert.assertEquals((Object)app11.appException, (Object)app11.getEventException());
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine2.getState()));
            Assert.assertTrue((boolean)engine2.isPrimary());
            switch (haPolicy) {
                case EventSourcing: {
                    Assert.assertEquals((long)9L, (long)app12.inMessageCount);
                    break;
                }
                case StateReplication: {
                    Assert.assertEquals((long)0L, (long)app12.inMessageCount);
                }
            }
            app12.releaseFromPrestart();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            switch (haPolicy) {
                case EventSourcing: {
                    Assert.assertEquals((long)20L, (long)app12.inMessageCount);
                    break;
                }
                case StateReplication: {
                    Assert.assertEquals((long)11L, (long)app12.inMessageCount);
                }
            }
            Assert.assertEquals((long)1L, (long)app2.inMessageCount);
        }
        finally {
            app12.releaseFromPrestart();
        }
    }

    @Test
    public void testAppExceptionRollbackAndStopEventSourcing() throws Exception {
        this.testAppExceptionRollbackAndStop(AepEngine.HAPolicy.EventSourcing);
    }

    @Test
    public void testAppExceptionRollbackAndStopStateReplication() throws Exception {
        this.testAppExceptionRollbackAndStop(AepEngine.HAPolicy.StateReplication);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void testAppExceptionQuarantineAndStop(AepEngine.HAPolicy haPolicy, boolean hasQuarantineChannel) throws Exception {
        AepEngine engine3;
        AepEngine engine2;
        AepEngine engine1;
        AepEngineAppExceptionTestApp app11 = new AepEngineAppExceptionTestApp();
        String app1Name = "engine-" + System.currentTimeMillis();
        app11.engine = engine1 = this.createEngine(app1Name, haPolicy, null, null, null, AepEngine.OutboundMessageLoggingPolicy.UseDedicated, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 63, 16, app11, null, null, 0, false, false, AepEngine.AppExceptionHandlingPolicy.QuarantineAndStop, hasQuarantineChannel ? "channel4@aeptest1" : null, null, false, false);
        app11.shouldFail = true;
        engine1.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine1.start();
        app11.releaseFromPrestart();
        engine1.waitForMessagingToStart();
        AepEngineAppExceptionTestApp app12 = new AepEngineAppExceptionTestApp();
        app12.engine = engine2 = this.createEngine(app1Name, haPolicy, null, null, null, AepEngine.OutboundMessageLoggingPolicy.UseDedicated, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 63, 16, app12, null, null, 0, false, false, AepEngine.AppExceptionHandlingPolicy.QuarantineAndStop, hasQuarantineChannel ? "channel4@aeptest1" : null, null, false, false);
        app12.shouldFail = false;
        engine2.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine2.start();
        AepEngineAppExceptionTestApp app2 = new AepEngineAppExceptionTestApp();
        String app2Name = "engine-" + System.currentTimeMillis() + "-100";
        app2.engine = engine3 = this.createEngine(app2Name, AepEngine.HAPolicy.EventSourcing, null, null, AepEngine.InboundMessageLoggingPolicy.UseDedicated, AepEngine.OutboundMessageLoggingPolicy.UseDedicated, false, false, false, false, null, 47, 40, app2, null, null, 0, false, false, null, null, null, false, false);
        engine3.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine3.start();
        app2.releaseFromPrestart();
        engine3.waitForMessagingToStart();
        List<AepEngineTestMessage> messages = this.createMessagesToSend(AepEngineTestObject.EncodingType.Proto);
        for (AepEngineTestMessage message : messages) {
            message.getMessage().setMessageBus("aeptest1");
            message.getMessage().setMessageChannel("channel1");
            engine1.sendMessage(app11.channel5, message.getMessage());
        }
        app11.onMessagesSent();
        app12.onMessagesSent();
        try {
            app11.waitForEngineStopped();
            Assert.assertTrue((boolean)(app11.engineStoppedCause instanceof EAepAppException));
            Assert.assertSame((Object)app11.appException, (Object)((EAepAppException)app11.engineStoppedCause).getCause());
            Assert.assertEquals((long)10L, (long)app11.inMessageCount);
            Assert.assertNotNull((Object)app11.getEventMessage());
            Assert.assertEquals(messages.get(9).getMessage().getClass(), app11.getEventMessage().getClass());
            Assert.assertNotNull((Object)app11.getEventException());
            Assert.assertEquals((Object)app11.appException, (Object)app11.getEventException());
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine2.getState()));
            Assert.assertTrue((boolean)engine2.isPrimary());
            switch (haPolicy) {
                case EventSourcing: {
                    Assert.assertEquals((long)9L, (long)app12.inMessageCount);
                    break;
                }
                case StateReplication: {
                    Assert.assertEquals((long)0L, (long)app12.inMessageCount);
                }
            }
            app12.releaseFromPrestart();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            switch (haPolicy) {
                case EventSourcing: {
                    Assert.assertEquals((long)19L, (long)app12.inMessageCount);
                    break;
                }
                case StateReplication: {
                    Assert.assertEquals((long)10L, (long)app12.inMessageCount);
                }
            }
            Assert.assertEquals((long)(hasQuarantineChannel ? 2L : 1L), (long)app2.inMessageCount);
        }
        finally {
            app12.releaseFromPrestart();
        }
    }

    @Test
    public void testAppExceptionQuarantineAndStopEventSourcingNoQuarantineChannel() throws Exception {
        this.testAppExceptionQuarantineAndStop(AepEngine.HAPolicy.EventSourcing, false);
    }

    @Test
    public void testAppExceptionQuarantineAndStopEventSourcingWithQuarantineChannel() throws Exception {
        this.testAppExceptionQuarantineAndStop(AepEngine.HAPolicy.EventSourcing, true);
    }

    @Test
    public void testAppExceptionQuarantineAndStopStateReplicationNoQuarantineChannel() throws Exception {
        this.testAppExceptionQuarantineAndStop(AepEngine.HAPolicy.StateReplication, false);
    }

    @Test
    public void testAppExceptionQuarantineAndStopStateReplicationWithQuarantineChannel() throws Exception {
        this.testAppExceptionQuarantineAndStop(AepEngine.HAPolicy.StateReplication, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void testAppError(AepEngine.HAPolicy haPolicy) throws Exception {
        AepEngine engine3;
        AepEngine engine2;
        AepEngine engine1;
        AepEngineAppExceptionTestApp app11 = new AepEngineAppExceptionTestApp();
        String app1Name = "engine-" + System.currentTimeMillis();
        app11.engine = engine1 = this.createEngine(app1Name, haPolicy, null, null, null, AepEngine.OutboundMessageLoggingPolicy.UseDedicated, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 63, 16, app11, null, null, 0, false, false, AepEngine.AppExceptionHandlingPolicy.LogExceptionAndContinue, null, null, false, false);
        app11.throwError = true;
        app11.shouldFail = true;
        engine1.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine1.start();
        app11.releaseFromPrestart();
        engine1.waitForMessagingToStart();
        AepEngineAppExceptionTestApp app12 = new AepEngineAppExceptionTestApp();
        app12.engine = engine2 = this.createEngine(app1Name, haPolicy, null, null, null, AepEngine.OutboundMessageLoggingPolicy.UseDedicated, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 63, 16, app12, null, null, 0, false, false, AepEngine.AppExceptionHandlingPolicy.LogExceptionAndContinue, null, null, false, false);
        app12.shouldFail = false;
        engine2.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine2.start();
        AepEngineAppExceptionTestApp app2 = new AepEngineAppExceptionTestApp();
        String app2Name = "engine-" + System.currentTimeMillis() + "-100";
        app2.engine = engine3 = this.createEngine(app2Name, AepEngine.HAPolicy.EventSourcing, null, null, AepEngine.InboundMessageLoggingPolicy.UseDedicated, AepEngine.OutboundMessageLoggingPolicy.UseDedicated, false, false, false, false, null, 47, 40, app2, null, null, 0, false, false, null, null, null, false, false);
        engine3.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine3.start();
        app2.releaseFromPrestart();
        engine3.waitForMessagingToStart();
        List<AepEngineTestMessage> messages = this.createMessagesToSend(AepEngineTestObject.EncodingType.Proto);
        int i = 0;
        for (AepEngineTestMessage message : messages) {
            message.getMessage().setMessageBus("aeptest1");
            message.getMessage().setMessageChannel("channel1");
            engine1.sendMessage(app11.channel5, message.getMessage());
            if (++i != 1) continue;
            Thread.sleep(100L);
        }
        app11.onMessagesSent();
        app12.onMessagesSent();
        try {
            app11.waitForEngineStopped();
            Assert.assertTrue((boolean)(app11.engineStoppedCause instanceof EAepAppException));
            Assert.assertSame((Object)app11.appError, (Object)((EAepAppException)app11.engineStoppedCause).getCause());
            Assert.assertEquals((long)10L, (long)app11.inMessageCount);
            Assert.assertNotNull((Object)app11.getEventMessage());
            Assert.assertEquals(messages.get(9).getMessage().getClass(), app11.getEventMessage().getClass());
            Assert.assertNotNull((Object)app11.getEventException());
            Assert.assertEquals((Object)app11.appError, (Object)app11.getEventException());
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine2.getState()));
            Assert.assertTrue((boolean)engine2.isPrimary());
            switch (haPolicy) {
                case EventSourcing: {
                    Assert.assertEquals((long)9L, (long)app12.inMessageCount);
                    break;
                }
                case StateReplication: {
                    Assert.assertEquals((long)0L, (long)app12.inMessageCount);
                    break;
                }
            }
            app12.releaseFromPrestart();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            switch (haPolicy) {
                case EventSourcing: {
                    Assert.assertEquals((long)20L, (long)app12.inMessageCount);
                    return;
                }
                case StateReplication: {
                    Assert.assertEquals((long)11L, (long)app12.inMessageCount);
                    return;
                }
            }
            return;
        }
        finally {
            app12.releaseFromPrestart();
        }
    }

    @Test
    public void testAppErrorEventSourcing() throws Exception {
        this.testAppError(AepEngine.HAPolicy.EventSourcing);
    }

    @Test
    public void testAppErrorStateReplication() throws Exception {
        this.testAppError(AepEngine.HAPolicy.StateReplication);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void testPassThroughEventAppException(AepEngine.HAPolicy haPolicy) throws Exception {
        AepEngine engine2;
        AepEngine engine1;
        AepEngineAppExceptionTestApp app11 = new AepEngineAppExceptionTestApp();
        String app1Name = "engine-" + System.currentTimeMillis();
        app11.engine = engine1 = this.createEngine(app1Name, haPolicy, null, null, null, AepEngine.OutboundMessageLoggingPolicy.UseDedicated, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 63, 16, app11, null, null, 0, false, false, AepEngine.AppExceptionHandlingPolicy.LogExceptionAndContinue, null, null, false, false);
        app11.shouldFail = false;
        engine1.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine1.start();
        app11.releaseFromPrestart();
        engine1.waitForMessagingToStart();
        AepEngineAppExceptionTestApp app12 = new AepEngineAppExceptionTestApp();
        app12.engine = engine2 = this.createEngine(app1Name, haPolicy, null, null, null, AepEngine.OutboundMessageLoggingPolicy.UseDedicated, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 63, 16, app12, null, null, 0, false, false, AepEngine.AppExceptionHandlingPolicy.LogExceptionAndContinue, null, null, false, false);
        app12.shouldFail = false;
        engine2.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine2.start();
        try {
            UnhandledMessageEvent event = UnhandledMessageEvent.create(null, null, null, null, null, null, null, null, null, null);
            engine1.onEvent((Event)event);
            engine1.getEventMultiplexer().multiplexEvent((Event)event, 0);
            engine2.onEvent((Event)event);
            List<AepEngineTestMessage> messages = this.createMessagesToSend(AepEngineTestObject.EncodingType.Proto);
            for (AepEngineTestMessage message : messages) {
                message.getMessage().setMessageBus("aeptest1");
                message.getMessage().setMessageChannel("channel1");
                engine1.sendMessage(app11.channel5, message.getMessage());
            }
            app11.onMessagesSent();
            app12.onMessagesSent();
            Assert.assertTrue((boolean)app11.waitForExpectedMessageReceipt(20));
            Assert.assertNull((Object)app11.getEventMessage());
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            switch (haPolicy) {
                case EventSourcing: {
                    Assert.assertTrue((boolean)app12.waitForExpectedMessageReceipt(20));
                    break;
                }
                case StateReplication: {
                    Assert.assertEquals((long)0L, (long)app12.inMessageCount);
                }
            }
            Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine1.getState()));
            Assert.assertTrue((boolean)engine1.isPrimary());
            Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine2.getState()));
            Assert.assertFalse((boolean)engine2.isPrimary());
        }
        finally {
            app12.releaseFromPrestart();
        }
        engine2.stop();
        Assert.assertTrue((boolean)app12.waitForEngineStopped());
        engine1.stop();
        Assert.assertTrue((boolean)app11.waitForEngineStopped());
    }

    @Test
    public void testPassThroughEventAppExceptionStateReplication() throws Exception {
        this.testPassThroughEventAppException(AepEngine.HAPolicy.StateReplication);
    }

    @Test
    public void testPassThroughEventAppExceptionEventSourcing() throws Exception {
        this.testPassThroughEventAppException(AepEngine.HAPolicy.EventSourcing);
    }
}

