/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep;

import com.neeve.aep.AepEngine;
import com.neeve.aep.IAepSysStats;
import com.neeve.stats.Stats;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class AepSysStats
extends Stats
implements IAepSysStats {
    private final OperatingSystemMXBean osBean;
    private final MemoryMXBean memoryBean;
    private final ThreadMXBean threadBean;
    private final CompilationMXBean jitBean;
    private final NumberFormat format = NumberFormat.getInstance();
    private final Map<Long, ThreadStats> threadsStats;
    private long startTime;
    private long deltaStartTime;
    private static final long gb = 0x40000000L;
    private static final long mb = 0x100000L;
    private static final long kb = 1024L;
    private static final long micro = 1000000L;
    private static final long milli = 1000L;

    AepSysStats(AepEngine engine, String name, String startProp) {
        super("nv.aep.aep", name, "nv.aep.aep.engine.systats", startProp);
        this.format.setMaximumFractionDigits(2);
        this.osBean = ManagementFactory.getOperatingSystemMXBean();
        this.memoryBean = ManagementFactory.getMemoryMXBean();
        this.threadBean = ManagementFactory.getThreadMXBean();
        this.jitBean = ManagementFactory.getCompilationMXBean();
        this.threadsStats = new HashMap<Long, ThreadStats>();
        this.startPeriodicOutputIfConfigured();
    }

    private final String memToStr(long val) {
        if (val >= 0x40000000L) {
            return String.format("%.1f", (double)val / 1.073741824E9) + "G";
        }
        if (val >= 0x100000L) {
            return String.format("%d", val / 0x100000L) + "M";
        }
        return String.format("%d", val / 1024L) + "K";
    }

    private final String nanoTimeToStr(long val) {
        if ((val /= 1000L) == 0L) {
            return "0";
        }
        if (val < 1000L) {
            return String.format("%d", val) + "u";
        }
        if (val < 1000000L) {
            return String.format("%d", val / 1000L) + "m";
        }
        return String.format("%.1f", (double)val / 1000000.0) + "s";
    }

    private void stamp() {
        this.deltaStartTime = System.currentTimeMillis();
    }

    protected final void init() {
        this.startTime = System.currentTimeMillis();
        this.stamp();
    }

    public final synchronized void get(StringBuilder sb) {
        long currentTime = System.currentTimeMillis();
        long deltaTime = currentTime - this.deltaStartTime;
        long deltaTotalTime = currentTime - this.startTime;
        sb.append(String.format("System: %d processors load average: %.2f", this.osBean.getAvailableProcessors(), this.osBean.getSystemLoadAverage())).append("\n");
        MemoryUsage heapUsage = this.memoryBean.getHeapMemoryUsage();
        MemoryUsage nonHeapUsage = this.memoryBean.getNonHeapMemoryUsage();
        sb.append(String.format("Memory: HEAP %s init %s used %s commit %s max  NON-HEAP %s init %s used %s commit %s max", this.memToStr(heapUsage.getInit()), this.memToStr(heapUsage.getUsed()), this.memToStr(heapUsage.getCommitted()), this.memToStr(heapUsage.getMax()), this.memToStr(nonHeapUsage.getInit()), this.memToStr(nonHeapUsage.getUsed()), this.memToStr(nonHeapUsage.getCommitted()), this.memToStr(nonHeapUsage.getMax()))).append("\n");
        sb.append(String.format("JIT: %s, time: %d ms", this.jitBean.getName(), this.jitBean.isCompilationTimeMonitoringSupported() ? this.jitBean.getTotalCompilationTime() : -1L)).append("\n");
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        sb.append("GC:");
        for (GarbageCollectorMXBean gcBean : gcBeans) {
            sb.append(String.format(" [%d %d ms]", gcBean.getCollectionCount(), gcBean.getCollectionTime()));
        }
        sb.append("\n");
        sb.append(String.format("Threads: %d total (%d daemon) %d peak", this.threadBean.getThreadCount(), this.threadBean.getDaemonThreadCount(), this.threadBean.getPeakThreadCount())).append("\n");
        sb.append(String.format("  %-5s %-10s %-5s %-5s %-5s %-5s %-6s %-15s %s", "ID", "CPU", "CPU%", "USER%", "DCPU", "DCPU%", "DUSER%", "STATE", "NAME")).append("\n");
        long[] ids = this.threadBean.getAllThreadIds();
        long totalCpuTime = 0L;
        long totalDeltaCpuTime = 0L;
        for (int i = 0; i < ids.length; ++i) {
            ThreadInfo tinfo;
            ThreadStats threadStats = this.threadsStats.get(ids[i]);
            if (threadStats == null && (tinfo = this.threadBean.getThreadInfo(ids[i])) != null) {
                threadStats = new ThreadStats(ids[i], tinfo.getThreadName());
                this.threadsStats.put(ids[i], threadStats);
            }
            if (threadStats == null) continue;
            threadStats.stamp();
            totalCpuTime += threadStats.cpuTimeCurrent;
            totalDeltaCpuTime += threadStats.cpuTimeCurrent - threadStats.cpuTimeLast;
        }
        for (ThreadStats threadStats : this.threadsStats.values()) {
            long usrTimeDeltaPct;
            long cpuTimePct = totalCpuTime > 0L ? (long)Math.ceil((double)threadStats.cpuTimeCurrent * 100.0 / (double)totalCpuTime) : 0L;
            long usrTimePct = threadStats.cpuTimeCurrent > 0L ? (long)Math.ceil((double)threadStats.usrTimeCurrent * 100.0 / (double)threadStats.cpuTimeCurrent) : 0L;
            long cpuTimeDelta = threadStats.cpuTimeCurrent - threadStats.cpuTimeLast;
            long cpuTimeDeltaPct = totalDeltaCpuTime > 0L ? (long)Math.ceil((double)cpuTimeDelta * 100.0 / (double)totalDeltaCpuTime) : 0L;
            long usrTimeDelta = threadStats.usrTimeCurrent - threadStats.usrTimeLast;
            long l = usrTimeDeltaPct = cpuTimeDelta > 0L ? (long)Math.ceil((double)usrTimeDelta * 100.0 / (double)cpuTimeDelta) : 0L;
            ThreadInfo tinfo = this.threadBean.getThreadInfo(threadStats.id);
            if (tinfo == null) continue;
            sb.append(String.format("  %-5d %-10s %-5d %-5d %-5s %-5d %-6d %-15s %s", new Object[]{threadStats.id, this.nanoTimeToStr(threadStats.cpuTimeCurrent), cpuTimePct, usrTimePct, this.nanoTimeToStr(cpuTimeDelta), cpuTimeDeltaPct, usrTimeDeltaPct, tinfo.getThreadState(), threadStats.name})).append("\n");
        }
        this.stamp();
    }

    @Override
    public final OperatingSystemMXBean getOsBean() {
        return this.osBean;
    }

    @Override
    public final MemoryMXBean getMemoryBean() {
        return this.memoryBean;
    }

    @Override
    public final ThreadMXBean getThreadBean() {
        return this.threadBean;
    }

    @Override
    public final CompilationMXBean getJitBean() {
        return this.jitBean;
    }

    private final class ThreadStats {
        private final long id;
        private final String name;
        private long cpuTimeLast;
        private long usrTimeLast;
        private long cpuTimeCurrent;
        private long usrTimeCurrent;

        ThreadStats(long id, String name) {
            this.id = id;
            this.name = name;
            this.init();
        }

        private final void init() {
            this.cpuTimeCurrent = AepSysStats.this.threadBean.getThreadCpuTime(this.id);
            this.usrTimeCurrent = AepSysStats.this.threadBean.getThreadUserTime(this.id);
        }

        final void stamp() {
            this.cpuTimeLast = this.cpuTimeCurrent;
            this.cpuTimeCurrent = AepSysStats.this.threadBean.getThreadCpuTime(this.id);
            this.usrTimeLast = this.usrTimeCurrent;
            this.usrTimeCurrent = AepSysStats.this.threadBean.getThreadUserTime(this.id);
        }
    }
}

