/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep;

import com.neeve.aep.AepBusManager;
import com.neeve.aep.IAepBusManagerStats;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageLatencyManager;
import com.neeve.stats.IStats;
import com.neeve.stats.Stats;
import java.text.NumberFormat;

public final class AepBusManagerStats
extends Stats
implements IAepBusManagerStats {
    private AepBusManager busManager;
    private NumberFormat format;
    private long startTime;
    private long deltaStartTime;
    private long numMsgsRcvdLast;
    private long numMsgsInBatchesRcvdLast;
    private long numMsgBatchesRcvdLast;
    private long numAcksSentLast;
    private long numMsgsEnqueuedLast;
    private long numMsgsSentLast;
    private long numFlushesSyncLast;
    private long numMsgsFlushedSyncLast;
    private long numFlushesAsyncLast;
    private long numAsyncFlushCompletionsLast;
    private long numMsgsFlushedAsyncLast;
    private long numStabilityRcvdLast;
    private long numStabilityInBatchesRcvdLast;
    private long numStabilityBatchesRcvdLast;
    private long numPacketsRcvdLast;
    private long numCommitsLast;
    private long numRollbacksLast;
    private long numPartialRollbacksLast;
    volatile long numMsgsRcvd;
    volatile long numMsgsInBatchesRcvd;
    volatile long numMsgBatchesRcvd;
    volatile long numAcksSent;
    volatile long numMsgsEnqueued;
    volatile long numMsgsSent;
    volatile long numFlushesSync;
    volatile long numMsgsFlushedSync;
    volatile long numFlushesAsync;
    volatile long numAsyncFlushCompletions;
    volatile long numMsgsFlushedAsync;
    volatile long numStabilityRcvd;
    volatile long numStabilityInBatchesRcvd;
    volatile long numStabilityBatchesRcvd;
    volatile long numPacketsRcvd;
    volatile long numCommits;
    volatile long numRollbacks;
    volatile long numPartialRollbacks;
    volatile int numClients;
    volatile int numChannelsUp;
    volatile int numBindingFailures;
    final Stats.LatencyManager o2p = new Stats.LatencyManager("o2p");

    AepBusManagerStats(AepBusManager busManager, String name, String startProp) {
        super("nv.aep.busmanager", name, "nv.aep.busmanager.stats", startProp);
        this.busManager = busManager;
        this.format = NumberFormat.getInstance();
        this.format.setMaximumFractionDigits(2);
    }

    private void stamp() {
        this.deltaStartTime = System.currentTimeMillis();
        this.numMsgsRcvdLast = this.numMsgsRcvd;
        this.numMsgsInBatchesRcvdLast = this.numMsgsInBatchesRcvd;
        this.numMsgBatchesRcvdLast = this.numMsgBatchesRcvd;
        this.numAcksSentLast = this.numAcksSent;
        this.numMsgsEnqueuedLast = this.numMsgsEnqueued;
        this.numMsgsSentLast = this.numMsgsSent;
        this.numFlushesSyncLast = this.numFlushesSync;
        this.numMsgsFlushedSyncLast = this.numMsgsFlushedSync;
        this.numFlushesAsyncLast = this.numFlushesAsync;
        this.numAsyncFlushCompletionsLast = this.numAsyncFlushCompletions;
        this.numMsgsFlushedAsyncLast = this.numMsgsFlushedAsync;
        this.numStabilityRcvdLast = this.numStabilityRcvd;
        this.numStabilityInBatchesRcvdLast = this.numStabilityInBatchesRcvd;
        this.numStabilityBatchesRcvdLast = this.numStabilityBatchesRcvd;
        this.numPacketsRcvdLast = this.numPacketsRcvd;
        this.numCommitsLast = this.numCommits;
        this.numRollbacksLast = this.numRollbacks;
        this.numPartialRollbacksLast = this.numPartialRollbacks;
    }

    protected final void init() {
        this.startTime = System.currentTimeMillis();
        this.stamp();
    }

    public final synchronized void get(StringBuilder sb) {
        MessageBusBinding binding;
        long currentTime = System.currentTimeMillis();
        long deltaTime = currentTime - this.deltaStartTime;
        long deltaTotalTime = currentTime - this.startTime;
        long numMsgsRcvdCurrent = this.numMsgsRcvd;
        long numMsgsInBatchesRcvdCurrent = this.numMsgsInBatchesRcvd;
        long numMsgBatchesRcvdCurrent = this.numMsgBatchesRcvd;
        long numAcksSentCurrent = this.numAcksSent;
        long numMsgsEnqueuedCurrent = this.numMsgsEnqueued;
        long numMsgsSentCurrent = this.numMsgsSent;
        long numFlushesSyncCurrent = this.numFlushesSync;
        long numMsgsFlushedSyncCurrent = this.numMsgsFlushedSync;
        long numFlushesAsyncCurrent = this.numFlushesAsync;
        long numAsyncFlushCompletionsCurrent = this.numAsyncFlushCompletions;
        long numMsgsFlushedAsyncCurrent = this.numMsgsFlushedAsync;
        long numStabilityRcvdCurrent = this.numStabilityRcvd;
        long numStabilityInBatchesRcvdCurrent = this.numStabilityInBatchesRcvd;
        long numStabilityBatchesRcvdCurrent = this.numStabilityBatchesRcvd;
        long numPacketsRcvdCurrent = this.numPacketsRcvd;
        long numCommitsCurrent = this.numCommits;
        long numRollbacksCurrent = this.numRollbacks;
        long numPartialRollbacksCurrent = this.numPartialRollbacks;
        long numClientsCurrent = this.numClients;
        long numChannelsUpCurrent = this.numChannelsUp;
        int numBindingFailuresCurrent = this.numBindingFailures;
        int disruptorCapacityCurrent = this.busManager.getDisruptorCapacity();
        int disruptorRemainingCurrent = this.busManager.getDisruptorRemaining();
        int disruptorUsedCurrent = disruptorCapacityCurrent - disruptorRemainingCurrent;
        this.o2p.compute();
        String numMsgsRcvdStr = this.format.format(numMsgsRcvdCurrent);
        String deltaNumMsgsRcvdStr = this.format.format(numMsgsRcvdCurrent - this.numMsgsRcvdLast);
        String msgRecvRateStr = this.format.format(numMsgsRcvdCurrent * 1000L / deltaTotalTime);
        String deltaMsgRecvRateStr = this.format.format((numMsgsRcvdCurrent - this.numMsgsRcvdLast) * 1000L / deltaTime);
        String numMsgsInBatchesRcvdStr = this.format.format(numMsgsInBatchesRcvdCurrent);
        String deltaNumMsgsInBatchesRcvdStr = this.format.format(numMsgsInBatchesRcvdCurrent - this.numMsgsInBatchesRcvdLast);
        String msgsInBatchRecvRateStr = this.format.format(numMsgsInBatchesRcvdCurrent * 1000L / deltaTotalTime);
        String deltaMsgsInBatchRecvRateStr = this.format.format((numMsgsInBatchesRcvdCurrent - this.numMsgsInBatchesRcvdLast) * 1000L / deltaTime);
        String numMsgBatchesRcvdStr = this.format.format(numMsgBatchesRcvdCurrent);
        String deltaNumMsgBatchesRcvdStr = this.format.format(numMsgBatchesRcvdCurrent - this.numMsgBatchesRcvdLast);
        String msgBatchRecvRateStr = this.format.format(numMsgBatchesRcvdCurrent * 1000L / deltaTotalTime);
        String deltaMsgBatchRecvRateStr = this.format.format((numMsgBatchesRcvdCurrent - this.numMsgBatchesRcvdLast) * 1000L / deltaTime);
        long avgRecvBatchSize = numMsgBatchesRcvdCurrent == 0L ? 0L : numMsgsInBatchesRcvdCurrent / numMsgBatchesRcvdCurrent;
        long deltaAvgRecvBatchSize = numMsgBatchesRcvdCurrent - this.numMsgBatchesRcvdLast == 0L ? 0L : (numMsgsInBatchesRcvdCurrent - this.numMsgsInBatchesRcvdLast) / (numMsgBatchesRcvdCurrent - this.numMsgBatchesRcvdLast);
        String avgRecvBatchSizeStr = this.format.format(avgRecvBatchSize);
        String deltaAvgRecvBatchSizeStr = this.format.format(deltaAvgRecvBatchSize);
        String numAcksSentStr = this.format.format(numAcksSentCurrent);
        String deltaNumAcksSentStr = this.format.format(numAcksSentCurrent - this.numAcksSentLast);
        String acksSentRateStr = this.format.format(numAcksSentCurrent * 1000L / deltaTotalTime);
        String deltaAcksSentRateStr = this.format.format((numAcksSentCurrent - this.numAcksSentLast) * 1000L / deltaTime);
        String numMsgsEnqueuedStr = this.format.format(numMsgsEnqueuedCurrent);
        String deltaNumMsgsEnqueuedStr = this.format.format(numMsgsEnqueuedCurrent - this.numMsgsEnqueuedLast);
        String msgEnqueRateStr = this.format.format(numMsgsEnqueuedCurrent * 1000L / deltaTotalTime);
        String deltaMsgEnqueRateStr = this.format.format((numMsgsEnqueuedCurrent - this.numMsgsEnqueuedLast) * 1000L / deltaTime);
        String numMsgsSentStr = this.format.format(numMsgsSentCurrent);
        String deltaNumMsgsSentStr = this.format.format(numMsgsSentCurrent - this.numMsgsSentLast);
        String msgSendRateStr = this.format.format(numMsgsSentCurrent * 1000L / deltaTotalTime);
        String deltaMsgSendRateStr = this.format.format((numMsgsSentCurrent - this.numMsgsSentLast) * 1000L / deltaTime);
        String numFlushesSyncStr = this.format.format(numFlushesSyncCurrent);
        String deltaNumFlushesSyncStr = this.format.format(numFlushesSyncCurrent - this.numFlushesSyncLast);
        String flushSyncRateStr = this.format.format(numFlushesSyncCurrent * 1000L / deltaTotalTime);
        String deltaFlushSyncRateStr = this.format.format((numFlushesSyncCurrent - this.numFlushesSyncLast) * 1000L / deltaTime);
        String numFlushesAsyncStr = this.format.format(numFlushesAsyncCurrent);
        String deltaNumFlushesAsyncStr = this.format.format(numFlushesAsyncCurrent - this.numFlushesAsyncLast);
        String flushAsyncRateStr = this.format.format(numFlushesAsyncCurrent * 1000L / deltaTotalTime);
        String deltaFlushAsyncRateStr = this.format.format((numFlushesAsyncCurrent - this.numFlushesAsyncLast) * 1000L / deltaTime);
        String numAsyncFlushCompletionsStr = this.format.format(numAsyncFlushCompletionsCurrent);
        String deltaNumAsyncFlushCompletionsStr = this.format.format(numAsyncFlushCompletionsCurrent - this.numAsyncFlushCompletionsLast);
        String asyncFlushCompletionRateStr = this.format.format(numAsyncFlushCompletionsCurrent * 1000L / deltaTotalTime);
        String deltaAsyncFlushCompletionRateStr = this.format.format((numAsyncFlushCompletionsCurrent - this.numAsyncFlushCompletionsLast) * 1000L / deltaTime);
        long numFlushesCurrent = numFlushesSyncCurrent + numFlushesAsyncCurrent;
        long numFlushesLast = this.numFlushesSyncLast + this.numFlushesAsyncLast;
        long deltaNumFlushes = numFlushesCurrent - numFlushesLast;
        String numFlushesStr = this.format.format(numFlushesCurrent);
        String deltaNumFlushesStr = this.format.format(deltaNumFlushes);
        String flushRateStr = this.format.format(numFlushesCurrent * 1000L / deltaTotalTime);
        String deltaFlushRateStr = this.format.format(deltaNumFlushes * 1000L / deltaTime);
        int syncFlushPct = (int)(numFlushesCurrent == 0L ? 0L : numFlushesSyncCurrent * 100L / numFlushesCurrent);
        int deltaSyncFlushPct = (int)(deltaNumFlushes == 0L ? 0L : (numFlushesSyncCurrent - this.numFlushesSyncLast) * 100L / deltaNumFlushes);
        int asyncFlushPct = (int)(numFlushesCurrent == 0L ? 0L : numFlushesAsyncCurrent * 100L / numFlushesCurrent);
        int deltaAsyncFlushPct = (int)(deltaNumFlushes == 0L ? 0L : (numFlushesAsyncCurrent - this.numFlushesAsyncLast) * 100L / deltaNumFlushes);
        String numMsgsFlushedSyncStr = this.format.format(numMsgsFlushedSyncCurrent);
        String deltaNumMsgsFlushedSyncStr = this.format.format(numMsgsFlushedSyncCurrent - this.numMsgsFlushedSyncLast);
        String msgFlushSyncRateStr = this.format.format(numMsgsFlushedSyncCurrent * 1000L / deltaTotalTime);
        String deltaMsgFlushSyncRateStr = this.format.format((numMsgsFlushedSyncCurrent - this.numMsgsFlushedSyncLast) * 1000L / deltaTime);
        String numMsgsFlushedAsyncStr = this.format.format(numMsgsFlushedAsyncCurrent);
        String deltaNumMsgsFlushedAsyncStr = this.format.format(numMsgsFlushedAsyncCurrent - this.numMsgsFlushedAsyncLast);
        String msgFlushAsyncRateStr = this.format.format(numMsgsFlushedAsyncCurrent * 1000L / deltaTotalTime);
        String deltaMsgFlushAsyncRateStr = this.format.format((numMsgsFlushedAsyncCurrent - this.numMsgsFlushedAsyncLast) * 1000L / deltaTime);
        long numMsgsFlushedCurrent = numMsgsFlushedSyncCurrent + numMsgsFlushedAsyncCurrent;
        long numMsgsFlushedLast = this.numMsgsFlushedSyncLast + this.numMsgsFlushedAsyncLast;
        long deltaNumMsgsFlushed = numMsgsFlushedCurrent - numMsgsFlushedLast;
        String numMsgsFlushedStr = this.format.format(numMsgsFlushedCurrent);
        String deltaNumMsgsFlushedStr = this.format.format(deltaNumMsgsFlushed);
        String msgFlushRateStr = this.format.format(numMsgsFlushedCurrent * 1000L / deltaTotalTime);
        String deltaMsgFlushRateStr = this.format.format(deltaNumMsgsFlushed * 1000L / deltaTime);
        int syncMsgFlushPct = (int)(numMsgsFlushedCurrent == 0L ? 0L : numMsgsFlushedSyncCurrent * 100L / numMsgsFlushedCurrent);
        int deltaSyncMsgFlushPct = (int)(deltaNumMsgsFlushed == 0L ? 0L : (numMsgsFlushedSyncCurrent - this.numMsgsFlushedSyncLast) * 100L / deltaNumMsgsFlushed);
        int asyncMsgFlushPct = (int)(numMsgsFlushedCurrent == 0L ? 0L : numMsgsFlushedAsyncCurrent * 100L / numMsgsFlushedCurrent);
        int deltaAsyncMsgFlushPct = (int)(deltaNumMsgsFlushed == 0L ? 0L : (numMsgsFlushedAsyncCurrent - this.numMsgsFlushedAsyncLast) * 100L / deltaNumMsgsFlushed);
        String numStabilityRcvdStr = this.format.format(numStabilityRcvdCurrent);
        String deltaNumStabilityRcvdStr = this.format.format(numStabilityRcvdCurrent - this.numStabilityRcvdLast);
        String stabilityRateStr = this.format.format(numStabilityRcvdCurrent * 1000L / deltaTotalTime);
        String deltaStabilityRateStr = this.format.format((numStabilityRcvdCurrent - this.numStabilityRcvdLast) * 1000L / deltaTime);
        String numStabilityBatchesRcvdStr = this.format.format(numStabilityBatchesRcvdCurrent);
        String deltaNumStabilityBatchesRcvdStr = this.format.format(numStabilityBatchesRcvdCurrent - this.numStabilityBatchesRcvdLast);
        String stabilityBatchesRateStr = this.format.format(numStabilityBatchesRcvdCurrent * 1000L / deltaTotalTime);
        String deltaStabilityBatchesRateStr = this.format.format((numStabilityBatchesRcvdCurrent - this.numStabilityBatchesRcvdLast) * 1000L / deltaTime);
        long avgStabilityBatchSize = numStabilityBatchesRcvdCurrent == 0L ? 0L : numStabilityInBatchesRcvdCurrent / numStabilityBatchesRcvdCurrent;
        long deltaAvgStabilityBatchSize = numStabilityBatchesRcvdCurrent - this.numStabilityBatchesRcvdLast == 0L ? 0L : (numStabilityInBatchesRcvdCurrent - this.numStabilityInBatchesRcvdLast) / (numStabilityBatchesRcvdCurrent - this.numStabilityBatchesRcvdLast);
        String avgStabilityBatchSizeStr = this.format.format(avgStabilityBatchSize);
        String deltaAvgStabilityBatchSizeStr = this.format.format(deltaAvgStabilityBatchSize);
        String numPacketsRcvdStr = this.format.format(numPacketsRcvdCurrent);
        String deltaNumPacketsRcvdStr = this.format.format(numPacketsRcvdCurrent - this.numPacketsRcvdLast);
        String packetRecvRateStr = this.format.format(numPacketsRcvdCurrent * 1000L / deltaTotalTime);
        String deltaPacketRecvRateStr = this.format.format((numPacketsRcvdCurrent - this.numPacketsRcvdLast) * 1000L / deltaTime);
        String numCommitsStr = this.format.format(numCommitsCurrent);
        String deltaNumCommitsStr = this.format.format(numCommitsCurrent - this.numCommitsLast);
        String commitRateStr = this.format.format(numCommitsCurrent * 1000L / deltaTotalTime);
        String deltaCommitRateStr = this.format.format((numCommitsCurrent - this.numCommitsLast) * 1000L / deltaTime);
        String numRollbacksStr = this.format.format(numRollbacksCurrent);
        String deltaNumRollbacksStr = this.format.format(numRollbacksCurrent - this.numRollbacksLast);
        String rollbackRateStr = this.format.format(numRollbacksCurrent * 1000L / deltaTotalTime);
        String deltaRollbackRateStr = this.format.format((numRollbacksCurrent - this.numRollbacksLast) * 1000L / deltaTime);
        String numPartialRollbacksStr = this.format.format(numPartialRollbacksCurrent);
        String deltaNumPartialRollbacksStr = this.format.format(numPartialRollbacksCurrent - this.numPartialRollbacksLast);
        String partialRollbackRateStr = this.format.format(numPartialRollbacksCurrent * 1000L / deltaTotalTime);
        String deltaPartialRollbackRateStr = this.format.format((numRollbacksCurrent - this.numRollbacksLast) * 1000L / deltaTime);
        int disruptorUsagePctCurrent = disruptorCapacityCurrent > 0 ? (disruptorCapacityCurrent - disruptorRemainingCurrent) * 100 / disruptorCapacityCurrent : 0;
        String disruptorCapacityStr = this.format.format(disruptorCapacityCurrent);
        String disruptorUsedStr = this.format.format(disruptorUsedCurrent);
        String disruptorUsagePctStr = this.format.format(disruptorUsagePctCurrent);
        sb.append("In.........{").append("\n");
        sb.append("...Msg{");
        sb.append(numMsgsRcvdStr + "(" + deltaNumMsgsRcvdStr + ") ");
        sb.append(msgRecvRateStr + "(" + deltaMsgRecvRateStr + ") ");
        sb.append(numMsgsInBatchesRcvdStr + "(" + deltaNumMsgsInBatchesRcvdStr + ") ");
        sb.append(msgsInBatchRecvRateStr + "(" + deltaMsgsInBatchRecvRateStr + ") ");
        sb.append(numMsgBatchesRcvdStr + "(" + deltaNumMsgBatchesRcvdStr + ") ");
        sb.append(msgBatchRecvRateStr + "(" + deltaMsgBatchRecvRateStr + ") ");
        sb.append(avgRecvBatchSizeStr + "(" + deltaAvgRecvBatchSizeStr + ")");
        sb.append("}").append("\n");
        sb.append("...Ack{");
        sb.append(numAcksSentStr + "(" + deltaNumAcksSentStr + ") ");
        sb.append(acksSentRateStr + "(" + deltaAcksSentRateStr + ")");
        sb.append("}").append("\n");
        sb.append("...Pkt{");
        sb.append(numPacketsRcvdStr + "(" + deltaNumPacketsRcvdStr + ") ");
        sb.append(packetRecvRateStr + "(" + deltaPacketRecvRateStr + ")");
        sb.append("}").append("\n");
        sb.append("...Stab{");
        sb.append(numStabilityRcvdStr + "(" + deltaNumStabilityRcvdStr + ") ");
        sb.append(stabilityRateStr + "(" + deltaStabilityRateStr + ") ");
        sb.append(numStabilityBatchesRcvdStr + "(" + deltaNumStabilityBatchesRcvdStr + ") ");
        sb.append(stabilityBatchesRateStr + "(" + deltaStabilityBatchesRateStr + ") ");
        sb.append(avgStabilityBatchSizeStr + "(" + deltaAvgStabilityBatchSizeStr + ")");
        sb.append("}").append("\n");
        sb.append("}").append("\n");
        sb.append("Out........{").append("\n");
        sb.append("...Msg{");
        sb.append(numMsgsEnqueuedStr + "(" + deltaNumMsgsEnqueuedStr + ") ");
        sb.append(msgEnqueRateStr + "(" + deltaMsgEnqueRateStr + ") ");
        sb.append(numMsgsSentStr + "(" + deltaNumMsgsSentStr + ") ");
        sb.append(msgSendRateStr + "(" + deltaMsgSendRateStr + ") ");
        sb.append(numMsgsEnqueuedCurrent - numMsgsSentCurrent);
        sb.append("}").append("\n");
        sb.append("...Flush{");
        sb.append(numFlushesStr + "(" + deltaNumFlushesStr + ") ");
        sb.append(flushRateStr + "(" + deltaFlushRateStr + ") ");
        sb.append(numFlushesSyncStr + "(" + syncFlushPct + "%)(" + deltaNumFlushesSyncStr + "(" + deltaSyncFlushPct + "%)) ");
        sb.append(flushSyncRateStr + "(" + deltaFlushSyncRateStr + ") ");
        sb.append(numFlushesAsyncStr + "(" + asyncFlushPct + "%)(" + deltaNumFlushesAsyncStr + "(" + deltaAsyncFlushPct + "%)) ");
        sb.append(flushAsyncRateStr + "(" + deltaFlushAsyncRateStr + ") ");
        sb.append(numAsyncFlushCompletionsStr + "(" + deltaNumAsyncFlushCompletionsStr + ") ");
        sb.append(asyncFlushCompletionRateStr + "(" + deltaAsyncFlushCompletionRateStr + ")");
        sb.append("}").append("\n");
        sb.append("...Msg{");
        sb.append(numMsgsFlushedStr + "(" + deltaNumMsgsFlushedStr + ") ");
        sb.append(msgFlushRateStr + "(" + deltaMsgFlushRateStr + ") ");
        sb.append(numMsgsFlushedSyncStr + "(" + syncMsgFlushPct + "%)(" + deltaNumMsgsFlushedSyncStr + "(" + deltaSyncMsgFlushPct + "%)) ");
        sb.append(msgFlushSyncRateStr + "(" + deltaMsgFlushSyncRateStr + ") ");
        sb.append(numMsgsFlushedAsyncStr + "(" + asyncMsgFlushPct + "%)(" + deltaNumMsgsFlushedAsyncStr + "(" + deltaAsyncMsgFlushPct + "%)) ");
        sb.append(msgFlushAsyncRateStr + "(" + deltaMsgFlushAsyncRateStr + ")");
        sb.append("}").append("\n");
        sb.append("}").append("\n");
        sb.append("Txn........{");
        sb.append(numCommitsStr + "(" + deltaNumCommitsStr + ") ");
        sb.append(commitRateStr + "(" + deltaCommitRateStr + ") ");
        sb.append(numRollbacksStr + "(" + deltaNumRollbacksStr + ") ");
        sb.append(rollbackRateStr + "(" + deltaRollbackRateStr + ")");
        sb.append(numPartialRollbacksStr + "(" + deltaNumPartialRollbacksStr + ") ");
        sb.append(partialRollbackRateStr + "(" + deltaPartialRollbackRateStr + ")");
        sb.append("}").append("\n");
        sb.append("Disruptor..{");
        sb.append("[").append(disruptorUsedStr).append(" of ").append(disruptorCapacityStr).append("] ").append(disruptorUsagePctStr).append("%").append(" (" + this.busManager.getDisruptorClaimStrategy() + ", " + this.busManager.getDisruptorWaitStrategy() + ")");
        sb.append("}").append("\n");
        this.o2p.get(sb);
        sb.append("Clients....{");
        sb.append(numClientsCurrent);
        sb.append("}").append("\n");
        sb.append("Channels...{");
        sb.append(numChannelsUpCurrent);
        sb.append("}").append("\n");
        sb.append("Fails......{");
        sb.append(numBindingFailuresCurrent);
        sb.append("}").append("\n");
        if (MessageLatencyManager.captureMsgLatencyStats) {
            MessageLatencyManager mlm = this.getLatencyManager();
            if (mlm != null) {
                mlm.compute();
                mlm.get(sb, false);
            } else {
                sb.append("[Binding not established. No latency manager]").append("\n");
            }
        }
        if ((binding = this.busManager.getBusBinding()) != null) {
            sb.append("[Binding '" + binding.getName() + "']").append("\n");
            binding.getStats(sb);
            sb.append("\n");
        } else {
            sb.append("[Binding not established. No binding level stats]").append("\n");
        }
        this.stamp();
    }

    @Override
    public final AepBusManager getBusManager() {
        return this.busManager;
    }

    @Override
    public final long getNumMsgsRcvd() {
        return this.numMsgsRcvd;
    }

    @Override
    public final long getNumMsgsInBatchesRcvd() {
        return this.numMsgsInBatchesRcvd;
    }

    @Override
    public final long getNumMsgBatchesRcvd() {
        return this.numMsgBatchesRcvd;
    }

    @Override
    public final long getNumAcksSent() {
        return this.numAcksSent;
    }

    @Override
    public final long getNumMsgsEnqueued() {
        return this.numMsgsEnqueued;
    }

    @Override
    public final long getNumMsgsSent() {
        return this.numMsgsSent;
    }

    @Override
    public final long getNumFlushesSync() {
        return this.numFlushesSync;
    }

    @Override
    public final long getNumMsgsFlushedSync() {
        return this.numMsgsFlushedSync;
    }

    @Override
    public final long getNumFlushesAsync() {
        return this.numFlushesAsync;
    }

    @Override
    public final long getNumAsyncFlushCompletions() {
        return this.numAsyncFlushCompletions;
    }

    @Override
    public final long getNumMsgsFlushedAsync() {
        return this.numMsgsFlushedAsync;
    }

    @Override
    public final long getNumStabilityRcvd() {
        return this.numStabilityRcvd;
    }

    @Override
    public final long getNumStabilityInBatchesRcvd() {
        return this.numStabilityInBatchesRcvd;
    }

    @Override
    public final long getNumStabilityBatchesRcvd() {
        return this.numStabilityBatchesRcvd;
    }

    @Override
    public final long getNumPacketsRcvd() {
        return this.numPacketsRcvd;
    }

    @Override
    public final long getNumCommits() {
        return this.numCommits;
    }

    @Override
    public final long getNumRollbacks() {
        return this.numRollbacks;
    }

    @Override
    public final long getNumPartialRollbacks() {
        return this.numPartialRollbacks;
    }

    @Override
    public final int getNumClients() {
        return this.numClients;
    }

    @Override
    public final int getNumChannelsUp() {
        return this.numChannelsUp;
    }

    @Override
    public final int getNumBindingFailures() {
        return this.numBindingFailures;
    }

    @Override
    public final boolean isDetachedCommit() {
        return this.busManager.isDetachedCommit();
    }

    @Override
    public final int getDisruptorCapacity() {
        return this.busManager.getDisruptorCapacity();
    }

    @Override
    public final int getDisruptorRemaining() {
        return this.busManager.getDisruptorRemaining();
    }

    @Override
    public final String getDisruptorClaimStrategy() {
        return this.busManager.getDisruptorClaimStrategy();
    }

    @Override
    public final String getDisruptorWaitStrategy() {
        return this.busManager.getDisruptorWaitStrategy();
    }

    @Override
    public final IStats.Latencies getDisruptorOfferToPollLatencies() {
        return this.o2p;
    }

    @Override
    public final MessageLatencyManager getLatencyManager() {
        MessageBusBinding binding = this.busManager.getBusBinding();
        if (binding != null) {
            return binding.getLatencyManager();
        }
        return null;
    }
}

