/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.discovery;

import com.neeve.config.ConfigRepositoryFactory;
import com.neeve.config.EConfigException;
import com.neeve.config.IConfigRepository;
import com.neeve.config.IConfigSimpleEntity;
import com.neeve.config.IConfigSimpleEntityContainer;
import com.neeve.discovery.DiscoveryObject;
import com.neeve.discovery.EDiscoveryException;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class DiscoveryProviderDescriptor
extends DiscoveryObject {
    private final String name;
    private final String className;
    private final Properties props;

    private DiscoveryProviderDescriptor(String name, String className) {
        this.name = name;
        this.className = className;
        this.props = new Properties();
    }

    public final String getName() {
        return this.name;
    }

    public final String getClassName() {
        return this.className;
    }

    public final void setProperty(String name, String val) {
        if (val != null) {
            this.props.setProperty(name, val);
        } else {
            this.props.remove(name);
        }
    }

    public final void setProperties(Properties props) {
        this.props.putAll((Map<?, ?>)props);
    }

    public final Properties getProperties() {
        return this.props;
    }

    public final void save(IConfigRepository repo) throws EDiscoveryException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        try {
            IConfigSimpleEntity entity;
            IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/discovery/providers");
            if (container == null) {
                container = repo.createSimpleEntityContainer("/discovery/providers");
            }
            if ((entity = (IConfigSimpleEntity)container.getEntity(this.name)) == null) {
                entity = (IConfigSimpleEntity)container.createEntity(this.name);
            }
            entity.setProperties(null);
            entity.setProperties(this.props);
            entity.setProperty("Class", this.getClassName());
        }
        catch (EConfigException e) {
            throw new EDiscoveryException(e);
        }
    }

    public final void delete(IConfigRepository repo) throws EDiscoveryException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/discovery/providers");
        if (container != null) {
            container.removeEntity(this.name);
        }
    }

    public final String toString() {
        return "(" + this.name + ", '" + this.className + "', " + this.props + ")";
    }

    public static boolean exists(IConfigRepository repo, String name) {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("provider name cannot be null");
        }
        return repo.getSimpleEntity("/discovery/providers/" + name) != null;
    }

    public static boolean exists(String name) {
        return DiscoveryProviderDescriptor.exists(ConfigRepositoryFactory.getInstance().getLocalRepository(), name);
    }

    public static DiscoveryProviderDescriptor create(String name, String className) {
        if (name == null) {
            throw new IllegalArgumentException("provider name cannot be null");
        }
        if (className == null) {
            throw new IllegalArgumentException("provider class name cannot be null");
        }
        return new DiscoveryProviderDescriptor(name, className);
    }

    public static DiscoveryProviderDescriptor load(IConfigRepository repo, String name) throws EDiscoveryException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration repository cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        IConfigSimpleEntity entity = repo.getSimpleEntity("/discovery/providers/" + name);
        if (entity != null) {
            String className = entity.getProperty("Class", null);
            if (className == null) {
                throw new EDiscoveryException("Invalid provider configuration [Missing 'Class' property]");
            }
            DiscoveryProviderDescriptor providerDescriptor = DiscoveryProviderDescriptor.create(name, className);
            providerDescriptor.setProperties(entity.getProperties());
            providerDescriptor.getProperties().remove("Class");
            return providerDescriptor;
        }
        throw new EDiscoveryException("Provider '" + name + "' not found in repository");
    }

    public static DiscoveryProviderDescriptor load(String name) throws EDiscoveryException {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return DiscoveryProviderDescriptor.load(ConfigRepositoryFactory.getInstance().getLocalRepository(), name);
    }

    public static Set<DiscoveryProviderDescriptor> loadAll(IConfigRepository repo) throws EDiscoveryException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        LinkedHashSet<DiscoveryProviderDescriptor> providers = new LinkedHashSet<DiscoveryProviderDescriptor>();
        IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/emp/providers");
        if (container != null) {
            for (IConfigSimpleEntity entity : container) {
                try {
                    providers.add(DiscoveryProviderDescriptor.load(repo, entity.getName()));
                }
                catch (EDiscoveryException e) {
                    throw new EDiscoveryException("Failure in loading descriptor for provider '" + entity.getName() + "' [" + e.toString() + "]");
                }
            }
        }
        return providers;
    }

    public static Set<DiscoveryProviderDescriptor> loadAll() throws EDiscoveryException {
        return DiscoveryProviderDescriptor.loadAll(ConfigRepositoryFactory.getInstance().getLocalRepository());
    }
}

