/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.perf.aep.engine.messages;

import com.eaio.uuid.UUID;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.neeve.adm.runtime.AdmRuntime;
import com.neeve.adm.runtime.annotations.AdmFactoryInfo;
import com.neeve.adm.runtime.annotations.AdmGenerated;
import com.neeve.ci.XRuntime;
import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XString;
import com.neeve.memory.MemoryStats;
import com.neeve.perf.aep.engine.messages.IThroughput;
import com.neeve.perf.aep.engine.messages.MessageFactory;
import com.neeve.pkt.PktBody;
import com.neeve.pkt.PktBuffer;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.types.PktBodyData;
import com.neeve.quark.QuarkBuffer;
import com.neeve.quark.QuarkHeuristics;
import com.neeve.util.UtlPool;
import com.neeve.xbuf2.XbufUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;

@AdmGenerated(encoding="Xbuf2", compatLevel="4.1.0", admVersion="Unknown Version", date="12/6/25 6:55 PM", buildInfo="nvx-perf-aep-3.16.36 (nvx-codegen-plugin)")
@AdmFactoryInfo(factoryClass=MessageFactory.class, vfid=-3, ofid=-3, typeId=100)
@JsonPropertyOrder(value={"postWarmup"})
public final class Throughput
implements IThroughput,
UtlPool.Item<Throughput>,
AdmRuntime.BufferSizer {
    private static final MemoryStats _memoryStats = MemoryStats.getInstance();
    private static final ThroughputPoolFactory _throughputFactory = new ThroughputPoolFactory();
    private static final ThroughputPojoPoolFactory _throughputPojoFactory = new ThroughputPojoPoolFactory();
    private static final ThroughputSerializerPoolFactory _throughputSerializerFactory = new ThroughputSerializerPoolFactory();
    private static final ThroughputDeserializerPoolFactory _throughputDeserializerFactory = new ThroughputDeserializerPoolFactory();
    static final UtlPool<Throughput> _entityPool = UtlPool.create((String)"quark.entity", (String)"ThroughputQuarkEntity.3.100", (UtlPool.Factory)_throughputFactory, (UtlPool.Params)QuarkHeuristics.configurePoolParams(Throughput.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new ThroughputPoolEvictedItemReceiver());
    static final UtlPool<Pojo> _entityPojoPool = UtlPool.create((String)"quark.entity.pojo", (String)"ThroughputQuarkEntityPojo.3.100", (UtlPool.Factory)_throughputPojoFactory, (UtlPool.Params)QuarkHeuristics.configurePoolParams(Pojo.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new ThroughputPojoPoolEvictedItemReceiver());
    static final UtlPool<Serializer> _entitySerializerPool = UtlPool.create((String)"quark.entity.serializer", (String)"ThroughputQuarkEntitySerializer.3.100", (UtlPool.Factory)_throughputSerializerFactory, (UtlPool.Params)QuarkHeuristics.configurePoolParams(Serializer.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new ThroughputSerializerPoolEvictedItemReceiver());
    static final UtlPool<Deserializer> _entityDeserializerPool = UtlPool.create((String)"quark.entity.deserializer", (String)"ThroughputQuarkEntityDeserializer.3.100", (UtlPool.Factory)_throughputDeserializerFactory, (UtlPool.Params)QuarkHeuristics.configurePoolParams(Deserializer.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new ThroughputDeserializerPoolEvictedItemReceiver());
    private final AtomicInteger _ownershipCount = new AtomicInteger(1);
    private UtlPool<Throughput> _pool;
    private QuarkBuffer _serializedBuffer;
    private int _serializedBufferLength;
    private Serializer _serializer;
    private Deserializer _deserializer;
    private Pojo _pojo;
    private boolean readOnly;
    private boolean created = true;
    public static final Throughput[] EMPTY_ARRAY = new Throughput[0];

    Throughput() {
    }

    public static Throughput create() {
        Throughput entity = (Throughput)_entityPool.get(null);
        _memoryStats.onEntityAllocated(Throughput.class, MemoryStats.EntityType.EmbeddedEntity, !entity.created);
        return entity;
    }

    private final QuarkBuffer serializedBuffer(int len) {
        QuarkBuffer oldBuffer = this._serializedBuffer;
        int oldCapacity = oldBuffer != null ? oldBuffer.getCapacity() : 0;
        this._serializedBuffer = QuarkBuffer.ensureCapacity((QuarkBuffer)this._serializedBuffer, (int)len, (boolean)false);
        int newCapacity = this._serializedBuffer.getCapacity();
        if (newCapacity > oldCapacity) {
            if (oldBuffer != null) {
                _memoryStats.onEntityDataDisposed(Throughput.class, MemoryStats.EntityType.EmbeddedEntity, oldCapacity, true);
            }
            _memoryStats.onEntityDataAllocated(Throughput.class, MemoryStats.EntityType.EmbeddedEntity, newCapacity);
        }
        return this._serializedBuffer;
    }

    public final boolean hasSerializedBuffer() {
        return this._serializedBuffer != null;
    }

    @JsonIgnore
    public final QuarkBuffer getSerializedBuffer() {
        return this._serializedBuffer;
    }

    @Deprecated
    @JsonIgnore
    public final QuarkBuffer getBackingBuffer() {
        return this.getSerializedBuffer();
    }

    final void setSerializedBufferLength(int val) {
        this._serializedBufferLength = val;
    }

    @JsonIgnore
    public final int getSerializedBufferLength() {
        return this._serializedBufferLength;
    }

    @Deprecated
    @JsonIgnore
    public final int getSerializeToNativeLength() {
        return this.getSerializedBufferLength();
    }

    public final Serializer serializer(int length, boolean autoResizeTargetBuffer) {
        if (this._serializer == null) {
            this._serializer = Serializer.create();
        }
        this.serializedBuffer(length);
        if (autoResizeTargetBuffer) {
            this._serializer.setSizer(this);
        }
        return this._serializer.init(this);
    }

    public final Serializer serializer(int minimumLength) {
        return this.serializer(minimumLength, true);
    }

    public final Serializer serializer() {
        return this.serializer(1024, true);
    }

    public final long ensureCapacity(long addr, int capacity) {
        if (capacity <= this._serializedBufferLength) {
            return addr;
        }
        int newLength = capacity <= this._serializedBuffer.getCapacity() ? capacity : Math.max(capacity, this._serializedBuffer.getCapacity() * 2);
        this._serializedBuffer = QuarkBuffer.ensureCapacity((QuarkBuffer)this._serializedBuffer, (int)newLength, (boolean)true);
        return this._serializedBuffer.getNativeAddress();
    }

    public final Deserializer deserializer(boolean createBuffer) {
        if (!this.hasSerializedBuffer() && createBuffer) {
            this.serializedBuffer(0);
        }
        if (!this.hasSerializedBuffer()) {
            throw new IllegalStateException("no backing serialized buffer");
        }
        if (this._deserializer == null) {
            this._deserializer = Deserializer.create();
        }
        return this._deserializer.init(this._serializedBuffer, 0, this._serializedBufferLength);
    }

    public final Deserializer deserializer() {
        return this.deserializer(false);
    }

    public final boolean hasPojo() {
        return this._pojo != null && this._pojo.isInitialized();
    }

    public final boolean hasDirtyPojo() {
        return this.hasPojo() && this._pojo.isDirty();
    }

    public final Pojo pojo() {
        if (this._pojo == null) {
            this._pojo = Pojo.create();
        }
        if (!this._pojo.isInitialized()) {
            if (this.hasSerializedBuffer()) {
                this._pojo.deserialize(this.deserializer());
                this._pojo.clearDirty();
            } else {
                this._pojo.setInitialized();
            }
            if (this.readOnly) {
                this._pojo.setAsReadOnly();
            }
        }
        return this._pojo;
    }

    public final void disposeSerializedBuffer() {
        if (this._serializedBuffer != null) {
            int capacity = this._serializedBuffer.getCapacity();
            this._serializedBuffer.dispose();
            _memoryStats.onEntityDataDisposed(Throughput.class, MemoryStats.EntityType.EmbeddedEntity, capacity, true);
            this._serializedBuffer = null;
            this._serializedBufferLength = 0;
        }
    }

    public final void disposeSerializer() {
        if (this._serializer != null) {
            this._serializer.dispose();
            this._serializer = null;
        }
    }

    public final void disposeDeserializer() {
        if (this._deserializer != null) {
            this._deserializer.dispose();
            this._deserializer = null;
        }
    }

    public final void disposePojo(boolean sync) {
        if (sync) {
            this.sync();
        }
        if (this._pojo != null) {
            this._pojo.dispose();
            this._pojo = null;
        }
    }

    public final void disposePojo() {
        this.disposePojo(false);
    }

    private final void conserveMemory() {
        this.sync();
        this.disposeSerializer();
        this.disposeDeserializer();
        this.disposePojo(false);
    }

    public final void clear(boolean disposeMembers) {
        if (this._pojo != null) {
            if (disposeMembers) {
                this.disposePojo(false);
            } else {
                this._pojo.reset();
            }
        }
        if (disposeMembers) {
            this.disposeSerializedBuffer();
        } else {
            this._serializedBufferLength = 0;
        }
        this.readOnly = false;
    }

    public final void clear() {
        this.clear(false);
    }

    @Deprecated
    public final void clearContent() {
        this.clear();
    }

    public final void reset(boolean disposeMembers) {
        this.clear(disposeMembers);
        if (disposeMembers) {
            this.disposeSerializer();
            this.disposeDeserializer();
        }
    }

    public final void reset() {
        this.reset(XRuntime.optimizeMemoryUsage());
    }

    public final String serializeToRawJson() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            MessageFactory.mapper.writeValue((OutputStream)baos, (Object)this);
            return new String(baos.toByteArray(), "utf-8");
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public final int serializeTo(Serializer serializer) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            serializer.putFrom(this._serializedBuffer, 0, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final int serializeTo(QuarkBuffer buffer, int offset) {
        this.sync();
        if (this._serializedBufferLength > buffer.getLength() - offset) {
            throw new IllegalArgumentException("buffer too small");
        }
        if (this.hasSerializedBuffer()) {
            this._serializedBuffer.getTo(0, buffer, offset, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final void sync() {
        if (!this.hasDirtyPojo()) {
            return;
        }
        this._serializedBufferLength = this._pojo.serialize(this.serializer(this._pojo.getSerializedLength(), false));
        this._pojo.clearDirty();
    }

    public final byte[] serializeToByteArray() {
        this.sync();
        byte[] array = new byte[this._serializedBufferLength];
        this.serializeTo(array, 0);
        return array;
    }

    public final int serializeTo(byte[] array, int offset) {
        this.sync();
        if (this._serializedBufferLength > array.length - offset) {
            throw new IllegalArgumentException("array too small");
        }
        if (this.hasSerializedBuffer()) {
            this._serializedBuffer.getTo(0, array, offset, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final ByteBuffer serializeToByteBuffer() {
        this.sync();
        ByteBuffer buffer = ByteBuffer.allocate(this._serializedBufferLength);
        this.serializeTo(buffer);
        return buffer;
    }

    public final int serializeTo(ByteBuffer buffer) {
        this.sync();
        if (this._serializedBufferLength > buffer.capacity() - buffer.position()) {
            throw new IllegalArgumentException("buffer too small");
        }
        buffer.limit(buffer.position() + this._serializedBufferLength);
        if (this.hasSerializedBuffer()) {
            this._serializedBuffer.getTo(0, buffer, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final IOBuffer serializeToIOBuffer(boolean useNative) {
        this.sync();
        IOBuffer buffer = IOBuffer.create((int)this._serializedBufferLength, (boolean)useNative);
        this.serializeTo(buffer, 0);
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int serializeTo(IOBuffer buffer, int offset) {
        this.sync();
        ByteBuffer bytebuf = buffer.takeBuffer();
        try {
            bytebuf.limit(bytebuf.capacity());
            bytebuf.position(offset);
            int n = this.serializeTo(bytebuf);
            return n;
        }
        finally {
            buffer.releaseBuffer();
        }
    }

    public final int serializeTo(IOElasticBuffer buffer, int offset) {
        this.sync();
        buffer.setLength(offset + this._serializedBufferLength);
        return this.serializeTo(buffer.getIOBuffer(), buffer.getOffset() + offset);
    }

    public final PktPacket serializeToPacket() {
        PktPacket packet = PktFactory.getInstance().createPacket(-98401);
        this.serializeTo(packet);
        return packet;
    }

    public final int serializeTo(PktPacket packet) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            packet.getBody().deserialize(this._serializedBuffer, 0, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final int serializeTo(long addr, int offset) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            this._serializedBuffer.getTo(0, addr, offset, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    @Deprecated
    public final int serializeToNative(long addr, int offset) {
        return this.serializeTo(addr, offset);
    }

    public final String serializeToJson() {
        return this.serializeToRawJson();
    }

    public final Throughput deserializeFromRawJson(String json) {
        try {
            MessageFactory.mapper.reader().withValueToUpdate((Object)this).readValue(json);
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final Throughput deserializeFrom(Deserializer deserializer) {
        if (!deserializer.isInitialized()) {
            throw new IllegalArgumentException("can only deserialize from an initialized deserializer");
        }
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this._serializedBufferLength = 0;
        if (deserializer != null) {
            this._serializedBufferLength = deserializer.getSerializedLength();
            deserializer.getTo(this.serializedBuffer(this._serializedBufferLength), 0);
        }
        return this;
    }

    public final Throughput deserializeFrom(Throughput val) {
        return this.deserializeFrom(val.getSerializedBuffer(), 0, val.getSerializedBufferLength());
    }

    public final Throughput deserializeFrom(QuarkBuffer buffer, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = buffer != null ? len : 0;
        if (buffer != null) {
            this.serializedBuffer(len).putFrom(0, buffer, offset, len);
        }
        return this;
    }

    public final Throughput wrap(QuarkBuffer buffer, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this.disposeSerializedBuffer();
        this._serializedBuffer = buffer;
        this._serializedBufferLength = len;
        return this;
    }

    public final Throughput deserializeFromByteArray(byte[] array) {
        return this.deserializeFrom(array, 0, array.length);
    }

    public final Throughput deserializeFrom(byte[] array, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = array != null ? len : 0;
        if (array != null) {
            this.serializedBuffer(len).putFrom(0, array, offset, len);
        }
        return this;
    }

    public final Throughput deserializeFromByteBuffer(ByteBuffer buffer) {
        return this.deserializeFrom(buffer);
    }

    public final Throughput deserializeFrom(ByteBuffer buffer) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = buffer != null ? buffer.remaining() : 0;
        if (buffer != null) {
            this.serializedBuffer(this._serializedBufferLength).putFrom(0, buffer);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Throughput deserializeFrom(IOBuffer buffer, int offset, int len) {
        if (buffer == null) {
            return this.deserializeFrom((ByteBuffer)null);
        }
        ByteBuffer bytebuf = buffer.takeBuffer();
        try {
            bytebuf.limit(offset + len).position(offset);
            Throughput throughput = this.deserializeFrom(bytebuf);
            return throughput;
        }
        finally {
            buffer.releaseBuffer();
        }
    }

    public final Throughput deserializeFrom(IOElasticBuffer buffer, int offset, int len) {
        return this.deserializeFrom(buffer.getIOBuffer(), buffer.getOffset() + offset, len);
    }

    public final Throughput deserializeFromPacket(PktPacket packet) {
        return this.deserializeFrom(packet);
    }

    public final Throughput deserializeFrom(PktPacket packet) {
        try {
            PktBuffer buffer = packet.getBody().getBuffer();
            Throughput throughput = this.deserializeFrom((IOElasticBuffer)buffer, 0, buffer.getLength());
            return throughput;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            packet.dispose();
        }
    }

    public final Throughput deserializeFrom(long addr, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this._serializedBufferLength = len;
        this.serializedBuffer(this._serializedBufferLength).putFrom(0, addr, offset, len);
        return this;
    }

    @Deprecated
    public final Throughput deserializeFromNative(long addr, int offset, int len) {
        return this.deserializeFrom(addr, offset, len);
    }

    public final Throughput deserializeFromJson(String json) {
        this.deserializeFromRawJson(json);
        return this;
    }

    public final void copyInto(Throughput copy) {
        copy.clear();
        this.sync();
        copy.deserializeFrom(this._serializedBuffer, 0, this._serializedBufferLength);
    }

    public final Throughput copy() {
        Throughput copy = Throughput.create();
        this.copyInto(copy);
        return copy;
    }

    public final void setAsReadOnly() {
        this.readOnly = true;
        if (this._pojo != null) {
            this._pojo.setAsReadOnly();
        }
    }

    public static final int getPostWarmupFieldId() {
        return 17;
    }

    @Override
    @JsonProperty(value="postWarmup")
    public final void setPostWarmup(int val) {
        this.pojo().setPostWarmup(val);
    }

    @Override
    @JsonIgnore
    public final void setPostWarmupAsObject(Integer val) {
        if (val == null) {
            this.clearPostWarmup();
        } else {
            this.setPostWarmup(val);
        }
    }

    @Override
    @JsonIgnore
    public final int getPostWarmup() {
        return this.pojo().getPostWarmup();
    }

    @Override
    @JsonProperty(value="postWarmup")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Integer getPostWarmupAsObject() {
        if (!this.hasPostWarmup()) {
            return null;
        }
        return this.getPostWarmup();
    }

    @Override
    public final boolean hasPostWarmup() {
        return this.pojo().hasPostWarmup();
    }

    @Override
    public final void clearPostWarmup() {
        this.pojo().clearPostWarmup();
    }

    public final Throughput init() {
        this.reset();
        this._ownershipCount.set(1);
        return this;
    }

    public final Throughput setPool(UtlPool<Throughput> pool) {
        this._pool = pool;
        return this;
    }

    public final UtlPool<Throughput> getPool() {
        return this._pool;
    }

    public final Throughput acquire() {
        int val = this._ownershipCount.incrementAndGet();
        if (val <= 1 && this._pool != null) {
            throw new IllegalStateException("attempt to acquire an already disposed entity");
        }
        return this;
    }

    public final int getOwnershipCount() {
        return this._ownershipCount.get();
    }

    public final void dispose() {
        int val = this._ownershipCount.decrementAndGet();
        if (val < 0 && this._pool != null) {
            throw new IllegalStateException("attempt to dispose an already disposed entity");
        }
        if (val == 0 && this._pool != null) {
            this.created = false;
            this._pool.put((UtlPool.Item)this);
            _memoryStats.onEntityDisposed(Throughput.class, MemoryStats.EntityType.EmbeddedEntity, true);
        }
    }

    public final Object clone() {
        Throughput clonee = Throughput.create();
        if (this.hasPostWarmup()) {
            clonee.setPostWarmup(this.getPostWarmup());
        }
        return clonee;
    }

    public final boolean isValid() {
        return true;
    }

    public final void getValidationErrors(List<XString> results, String errorPrefix) {
    }

    public final String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HH:mm:ss.SSS");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        int c = 0;
        if (this.hasPostWarmup()) {
            builder.append(0 == c++ ? "" : ",").append("PostWarmup=").append(this.getPostWarmup());
        }
        builder.append("}");
        return builder.toString();
    }

    public static final class Pojo
    implements UtlPool.Item<Pojo> {
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final MemoryStats _memoryStats = MemoryStats.getInstance();
        private final long[] _fieldBitmask = new long[1];
        private final DeserializationCallback _deserializationCallback = new DeserializationCallback();
        private UtlPool<Pojo> _pool;
        private boolean _initialized;
        private boolean _readonly;
        private boolean _dirty;
        private byte _flags;
        private int _usrPostWarmup;

        Pojo() {
            this.setCreated();
        }

        public static final Pojo create(boolean pvt) {
            Pojo pojo = (Pojo)_entityPojoPool.get(null);
            if (pvt) {
                pojo.setPrivate();
            } else {
                pojo.clearPrivate();
                _memoryStats.onEntityPojoAllocated(Throughput.class, MemoryStats.EntityType.EmbeddedEntity, !pojo.isCreated());
            }
            return pojo.clearPooled();
        }

        public static final Pojo create() {
            return Pojo.create(false);
        }

        public final boolean hasPostWarmup() {
            return (this._fieldBitmask[0] & 1L) != 0L;
        }

        public final int getPostWarmup() {
            return this._usrPostWarmup;
        }

        public final void setPostWarmup(int val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            this._fieldBitmask[0] = this._fieldBitmask[0] | 1L;
            this._usrPostWarmup = val;
            this._dirty = true;
        }

        public final void clearPostWarmup() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasPostWarmup()) {
                return;
            }
            this._usrPostWarmup = 0;
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFEL;
            this._dirty = true;
        }

        public final void clear() {
            this._readonly = false;
            this._usrPostWarmup = 0;
            this._fieldBitmask[0] = 0L;
            this._dirty = true;
        }

        private final Pojo setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Pojo clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Pojo setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Pojo clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Pojo setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Pojo clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        public final void setAsReadOnly() {
            this._readonly = true;
        }

        public final boolean isInitialized() {
            return this._initialized;
        }

        public final void setInitialized() {
            this._initialized = true;
        }

        public final void clearDirty() {
            this._dirty = false;
        }

        public final void forceDirty() {
            this._dirty = true;
        }

        public final boolean isDirty() {
            return this._dirty;
        }

        public final int getSerializedLength() {
            int len = 0;
            if (this.hasPostWarmup()) {
                len += XbufUtil.primitiveFieldSerializedLength((int)17, (int)this._usrPostWarmup);
            }
            return len;
        }

        public final int serialize(Serializer serializer) {
            if (!serializer.isInitialized()) {
                throw new IllegalArgumentException("serializer not initialized");
            }
            if (this.hasPostWarmup()) {
                serializer.postWarmup(this._usrPostWarmup);
            }
            return serializer.done();
        }

        public final void deserialize(Deserializer deserializer) {
            if (!deserializer.isInitialized()) {
                throw new IllegalArgumentException("deserializer not initialized");
            }
            this.clear();
            deserializer.run(this._deserializationCallback);
            this._initialized = true;
        }

        public final Pojo reset() {
            this.clear();
            this._dirty = false;
            this._initialized = false;
            return this;
        }

        public final Pojo init() {
            return this.reset();
        }

        public final Pojo setPool(UtlPool<Pojo> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Pojo> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memoryStats.onEntityPojoDisposed(Throughput.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        private final class DeserializationCallback
        implements Deserializer.Callback {
            private DeserializationCallback() {
            }

            @Override
            public final void handlePostWarmup(int val) {
                Pojo.this.setPostWarmup(val);
            }
        }
    }

    public static final class Deserializer
    implements UtlPool.Item<Deserializer> {
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final MemoryStats _memoryStats = MemoryStats.getInstance();
        private final QuarkBuffer.VarintDeserializeLength _varintDeserializeLength = new QuarkBuffer.VarintDeserializeLength();
        private long _addr;
        private int _offset;
        private int _len;
        private UtlPool<Deserializer> _pool;
        private byte _flags;

        Deserializer() {
            this.setCreated();
        }

        public static final Deserializer create(boolean pvt) {
            Deserializer deserializer = (Deserializer)_entityDeserializerPool.get(null);
            if (pvt) {
                deserializer.setPrivate();
            } else {
                deserializer.clearPrivate();
                _memoryStats.onEntityDeserializerAllocated(Throughput.class, MemoryStats.EntityType.EmbeddedEntity, !deserializer.isCreated());
            }
            return deserializer.clearPooled();
        }

        public static final Deserializer create() {
            return Deserializer.create(false);
        }

        private final Deserializer setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Deserializer clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Deserializer setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Deserializer clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Deserializer setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Deserializer clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        public final Deserializer init(long addr, int offset, int len) {
            this._addr = addr;
            this._offset = offset;
            this._len = len;
            return this;
        }

        public final Deserializer init(QuarkBuffer buffer, int offset, int len) {
            this._addr = buffer.getNativeAddress();
            this._offset = offset;
            this._len = len;
            return this;
        }

        public final boolean isInitialized() {
            return this._addr != 0L;
        }

        public final int getSerializedLength() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            return this._len;
        }

        public final void getTo(QuarkBuffer buffer, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (buffer.getCapacity() - offset < this._len) {
                throw new IllegalArgumentException("not enough space in supplied buffer");
            }
            buffer.putFrom(offset, this._addr, this._offset, this._len);
        }

        public final int getTo(long addr, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            QuarkBuffer.copy((long)this._addr, (int)this._offset, (long)addr, (int)offset, (int)this._len);
            return this._len;
        }

        public final void run(Callback cb) {
            int flen;
            int tlen;
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            long addr = this._addr;
            int lim = this._offset + this._len;
            block9: for (int pos = this._offset; pos < lim; pos += tlen + flen) {
                int ftag = QuarkBuffer.getVarint32((long)addr, (int)pos, (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                int ftype = ftag & 7;
                switch (ftag >>> 3) {
                    case 17: {
                        if (ftype != 0) {
                            throw new IllegalStateException("field type mismatch (exp=0x00, actual=" + ftype + ") for field 17");
                        }
                        tlen = this._varintDeserializeLength.value;
                        cb.handlePostWarmup(QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength));
                        flen = this._varintDeserializeLength.value;
                        continue block9;
                    }
                    default: {
                        switch (ftype) {
                            case 0: {
                                tlen = this._varintDeserializeLength.value;
                                QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                                flen = this._varintDeserializeLength.value;
                                continue block9;
                            }
                            case 1: {
                                tlen = this._varintDeserializeLength.value;
                                flen = 8;
                                continue block9;
                            }
                            case 2: {
                                tlen = this._varintDeserializeLength.value;
                                flen = QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                                flen += this._varintDeserializeLength.value;
                                continue block9;
                            }
                            case 5: {
                                tlen = this._varintDeserializeLength.value;
                                flen = 4;
                                continue block9;
                            }
                        }
                        throw new IllegalStateException("corrupt field - #" + (QuarkBuffer.getVarint32((long)addr, (int)pos, (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength) >>> 3));
                    }
                }
            }
        }

        public final Deserializer init() {
            return this;
        }

        public final Deserializer setPool(UtlPool<Deserializer> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Deserializer> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memoryStats.onEntityDeserializerDisposed(Throughput.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        public static interface Callback {
            public void handlePostWarmup(int var1);
        }
    }

    public static final class Serializer
    implements UtlPool.Item<Serializer>,
    AdmRuntime.BufferSizer {
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final MemoryStats _memoryStats = MemoryStats.getInstance();
        private Throughput _entity;
        private int _len;
        private long _addr;
        private AdmRuntime.BufferSizer _sizer;
        private UtlPool<Serializer> _pool;
        private byte _flags;

        Serializer() {
            this.setCreated();
        }

        public static final Serializer create(boolean pvt) {
            Serializer serializer = (Serializer)_entitySerializerPool.get(null);
            if (pvt) {
                serializer.setPrivate();
            } else {
                serializer.clearPrivate();
                _memoryStats.onEntitySerializerAllocated(Throughput.class, MemoryStats.EntityType.EmbeddedEntity, !serializer.isCreated());
            }
            return serializer.clearPooled();
        }

        public static final Serializer create() {
            return Serializer.create(false);
        }

        private final Serializer setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Serializer clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Serializer setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Serializer clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Serializer setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Serializer clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        private final void ensureCapacity(int val) {
            if (this._sizer != null) {
                this._addr = this._sizer.ensureCapacity(this._addr, val);
            }
        }

        final Serializer init(Throughput entity) {
            this.init(entity.getSerializedBuffer(), 0);
            this._entity = entity;
            return this;
        }

        public final Serializer init(long addr, int len) {
            this._entity = null;
            this._len = len;
            this._addr = addr;
            return this;
        }

        public final Serializer init(QuarkBuffer buffer, int len) {
            return this.init(buffer.getNativeAddress(), len);
        }

        public final Serializer init(QuarkBuffer buffer) {
            return this.init(buffer.getNativeAddress(), 0);
        }

        public final Serializer setSizer(AdmRuntime.BufferSizer sizer) {
            this._sizer = sizer;
            return this;
        }

        public final boolean hasSizer() {
            return this._sizer != null;
        }

        public final boolean isInitialized() {
            return this._addr != 0L;
        }

        public final int getSerializedLength() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            return this._len;
        }

        public final void getTo(QuarkBuffer buffer, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (buffer.getCapacity() - offset < this._len) {
                throw new IllegalArgumentException("not enough space in supplied buffer");
            }
            buffer.putFrom(offset, this._addr, 0, this._len);
        }

        public final int getTo(long addr, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            QuarkBuffer.copy((long)this._addr, (int)0, (long)addr, (int)offset, (int)this._len);
            return this._len;
        }

        public final void putFrom(QuarkBuffer buffer, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + len);
            }
            buffer.getTo(offset, this._addr, this._len, len);
            this._len += len;
        }

        public final void putFrom(long addr, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + len);
            }
            QuarkBuffer.copy((long)addr, (int)offset, (long)this._addr, (int)this._len, (int)len);
            this._len += len;
        }

        public final Serializer postWarmup(int val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.primitiveFieldSerializedLength((int)17, (int)val));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)136);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val);
            return this;
        }

        public final int done() {
            if (this._entity != null) {
                this._entity.setSerializedBufferLength(this._len);
            }
            return this._len;
        }

        public final Serializer init() {
            return this;
        }

        public final Serializer setPool(UtlPool<Serializer> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Serializer> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memoryStats.onEntitySerializerDisposed(Throughput.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        public final long ensureCapacity(long addr, int capacity) {
            this._addr = this._sizer.ensureCapacity(addr, capacity);
            return this._addr;
        }
    }

    private static final class ThroughputDeserializerPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Deserializer> {
        private ThroughputDeserializerPoolEvictedItemReceiver() {
        }

        public final void process(Deserializer evictedItem) {
            _memoryStats.onEntityDeserializerLeaked(Throughput.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class ThroughputDeserializerPoolFactory
    implements UtlPool.Factory<Deserializer> {
        private ThroughputDeserializerPoolFactory() {
        }

        public final Deserializer createItem(Object object) {
            return new Deserializer();
        }

        public final Deserializer[] createItemArray(int size) {
            return new Deserializer[size];
        }
    }

    private static final class ThroughputSerializerPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Serializer> {
        private ThroughputSerializerPoolEvictedItemReceiver() {
        }

        public final void process(Serializer evictedItem) {
            _memoryStats.onEntitySerializerLeaked(Throughput.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class ThroughputSerializerPoolFactory
    implements UtlPool.Factory<Serializer> {
        private ThroughputSerializerPoolFactory() {
        }

        public final Serializer createItem(Object object) {
            return new Serializer();
        }

        public final Serializer[] createItemArray(int size) {
            return new Serializer[size];
        }
    }

    private static final class ThroughputPojoPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Pojo> {
        private ThroughputPojoPoolEvictedItemReceiver() {
        }

        public final void process(Pojo evictedItem) {
            _memoryStats.onEntityPojoLeaked(Throughput.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class ThroughputPojoPoolFactory
    implements UtlPool.Factory<Pojo> {
        private ThroughputPojoPoolFactory() {
        }

        public final Pojo createItem(Object object) {
            return new Pojo();
        }

        public final Pojo[] createItemArray(int size) {
            return new Pojo[size];
        }
    }

    private static final class ThroughputPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Throughput> {
        private ThroughputPoolEvictedItemReceiver() {
        }

        public final void process(Throughput evictedItem) {
            _memoryStats.onEntityLeaked(Throughput.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class ThroughputPoolFactory
    implements UtlPool.Factory<Throughput> {
        private ThroughputPoolFactory() {
        }

        public final Throughput createItem(Object object) {
            return new Throughput();
        }

        public final Throughput[] createItemArray(int size) {
            return new Throughput[size];
        }
    }

    static final class ThroughputPoolFactoryItemCreateArgument {
        UUID id;
        boolean wasCreated;

        ThroughputPoolFactoryItemCreateArgument() {
        }

        ThroughputPoolFactoryItemCreateArgument init(UUID id) {
            this.id = id;
            this.wasCreated = false;
            return this;
        }
    }

    public static final class PacketBody
    extends PktBodyData {
        private PacketBody(Properties props, boolean direct) {
            super(-98401, props, direct);
        }

        public static PktBody create(Properties props) {
            return new PacketBody(props, true);
        }

        public static PktBody create() {
            return PacketBody.create(null);
        }
    }
}

