/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools.test.unit;

import com.neeve.server.test.unit.AdminSessionTestApp;
import com.neeve.test.UnitTest;
import com.neeve.test.util.ProcessWrapper;
import com.neeve.tools.AdminTool;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class AdminToolTest
extends UnitTest {
    private static AdminSessionTestApp app;
    private static String XVM_NAME;
    private static String APP_NAME;

    @BeforeClass
    public static final void setup() throws TimeoutException, Throwable {
        app = AdminSessionTestApp.launch(XVM_NAME, APP_NAME, false, false);
        AdminToolTest.setVerbose((boolean)true);
    }

    @AfterClass
    public static final void tearDown() {
        if (app != null) {
            app.shutdown();
        }
        AdminToolTest.setVerbose((boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdminToolCommandAdminInvocation() throws IOException {
        ProcessWrapper pw = this.createAdminToolProcess(new String[0]);
        try {
            for (int i = 0; i < AdminSessionTestApp.TEST_COMMANDS.length; ++i) {
                String commandAndArgs = AdminSessionTestApp.TEST_COMMANDS[i][0] + " " + AdminSessionTestApp.TEST_COMMANDS[i][2];
                this.invokeCommand(pw, "admin " + APP_NAME + "@" + XVM_NAME + " " + commandAndArgs, "OK[" + AdminSessionTestApp.TEST_COMMANDS[i][1] + "]");
            }
        }
        finally {
            this.closeAdminTool(pw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdminToolCommandInvokeInvocation() throws IOException {
        ProcessWrapper pw = this.createAdminToolProcess(new String[0]);
        try {
            for (int i = 0; i < AdminSessionTestApp.TEST_COMMANDS.length; ++i) {
                String commandAndArgs = AdminSessionTestApp.TEST_COMMANDS[i][0] + " " + AdminSessionTestApp.TEST_COMMANDS[i][2];
                this.invokeCommand(pw, "invoke " + APP_NAME + " " + XVM_NAME + " " + commandAndArgs, "OK[" + AdminSessionTestApp.TEST_COMMANDS[i][1] + "]");
            }
        }
        finally {
            this.closeAdminTool(pw);
        }
    }

    @Test
    public void testAdminToolInvokeTooManyArguments() throws IOException {
        ProcessWrapper pw = this.createAdminToolProcess(new String[0]);
        try {
            this.invokeCommand(pw, "admin " + APP_NAME + "@" + XVM_NAME + " echoCommand String1 String2", "Too many arguments", "admin>");
            this.invokeCommand(pw, "invoke " + APP_NAME + " " + XVM_NAME + " echoCommand String1 String2", "Too many arguments", "admin>");
        }
        finally {
            this.closeAdminTool(pw);
        }
    }

    @Test
    public void testListCommands() throws IOException {
        ProcessWrapper pw = this.createAdminToolProcess(new String[0]);
        try {
            this.invokeCommand(pw, "listAppCommands -u -a " + APP_NAME + " -x " + XVM_NAME + " echo", "echoCommand", "admin>");
        }
        finally {
            this.closeAdminTool(pw);
        }
    }

    @Test
    public void testSetCommandTimeout() throws IOException {
        ProcessWrapper pw = this.createAdminToolProcess(new String[0]);
        try {
            this.invokeCommand(pw, "stacktraces=on", "admin>");
            this.invokeCommand(pw, "commandTimeout=1.5 seconds", "admin>");
            this.invokeCommand(pw, "set", new String[0]);
            this.invokeCommand(pw, 15000L, "invoke " + APP_NAME + " " + XVM_NAME + " sleep 3000", "operation timed out", "admin>");
            this.invokeCommand(pw, "commandTimeout=30", "admin>");
            this.invokeCommand(pw, "set", new String[0]);
            this.invokeCommand(pw, 10000L, "invoke " + APP_NAME + " " + XVM_NAME + " sleep 3000", "OK", "admin>");
        }
        finally {
            this.closeAdminTool(pw);
        }
    }

    public void invokeCommand(ProcessWrapper pw, long timeout, String command, String ... expectedOutputStrings) throws IOException {
        pw.markOutputPosistions();
        pw.writeLn(command);
        if (expectedOutputStrings != null && expectedOutputStrings.length > 0) {
            for (String expectedOutput : expectedOutputStrings) {
                Assert.assertTrue((String)("Didn't get expected output of '" + expectedOutput + "' running command '" + command + "'\n Process Output:\n" + pw.getOutput() + "\n Process Errors:\n" + pw.getErrorOutput()), (boolean)pw.waitForOutputAndQuiesence(50L, timeout, expectedOutput));
            }
        }
    }

    public void invokeCommand(ProcessWrapper pw, String command, String ... expectedOutputStrings) throws IOException {
        pw.markOutputPosistions();
        pw.writeLn(command);
        if (expectedOutputStrings != null && expectedOutputStrings.length > 0) {
            for (String expectedOutput : expectedOutputStrings) {
                Assert.assertTrue((String)("Didn't get expected output of '" + expectedOutput + "' running command '" + command + "'\n Process Output:\n" + pw.getOutput() + "\n Process Errors:\n" + pw.getErrorOutput()), (boolean)pw.waitForOutputAndQuiesence(50L, 15000L, expectedOutput));
            }
        }
    }

    private void closeAdminTool(ProcessWrapper pw) throws IOException {
        this.invokeCommand(pw, "exit", new String[0]);
        pw.close();
    }

    private ProcessWrapper createAdminToolProcess(String ... args) throws IOException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java");
        cmd.add("-DNVROOT=" + AdminToolTest.getTestbedRoot());
        cmd.add("-Djansi.strip=true");
        cmd.add("-Dnv.console.jline.disable=true");
        cmd.add("-Dnv.discovery.descriptor=mcast://224.0.1.200:4090&initWaitTime=1");
        cmd.add("-classpath");
        cmd.add(System.getProperty("java.class.path"));
        cmd.add(AdminTool.class.getName());
        for (String arg : args) {
            cmd.add(arg);
        }
        ProcessWrapper pw = ProcessWrapper.launch(cmd, (File)AdminToolTest.getTestbedRoot());
        pw.setOutputEchoEnabled(AdminToolTest.verbose());
        pw.waitForOutputAndQuiesence(1000L, 5000L, "admin>");
        return pw;
    }

    static {
        XVM_NAME = "admin-tool-test-xvm";
        APP_NAME = "admin-tool-test-app";
        System.setProperty("nv.discovery.descriptor", "mcast://224.0.1.200:4090&initWaitTime=0");
    }
}

