/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools;

import com.neeve.ods.IStoreObject;
import com.neeve.ods.IStoreObjectFactory;
import com.neeve.ods.StoreObjectFactoryRegistry;
import com.neeve.query.QueryRepository;
import com.neeve.rog.IRogMessage;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.RogLogFactory;
import com.neeve.rog.log.RogLogQuery;
import com.neeve.rog.log.RogLogQueryEngine;
import com.neeve.rog.log.RogLogReader;
import com.neeve.rog.log.RogLogRepository;
import com.neeve.rog.log.RogLogResultSet;
import com.neeve.server.mon.SrvMonFactory;
import com.neeve.server.mon.SrvMonHeartbeatMessage;
import com.neeve.server.mon.util.SrvMonHeartbeatTracer;
import com.neeve.tools.interactive.commands.AnnotatedCommand;
import com.neeve.util.UtlDataTypes;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;

@AnnotatedCommand.Command(keywords={"StatsDumpTool"}, description="This tool dump stats from tlog to a text format.")
public final class StatsDumpTool
extends AnnotatedCommand {
    @AnnotatedCommand.Argument(position=1, name="transactionLog", required=true, description="Path of the stats transaction log to read")
    File transactionLogFile;
    @AnnotatedCommand.Option(shortForm=111, longForm="outFile", required=false, description="Name of output file name. Default file name is 'statsdump.out")
    File outFile;
    @AnnotatedCommand.Option(shortForm=97, longForm="all", required=false, defaultValue="false", description="By default stats for admininstrative applications are not output.\nThis flag allows tracing stats for platform internal administrative application asw well.")
    boolean all;
    @AnnotatedCommand.Option(shortForm=115, longForm="startDate", required=false, description="Start date of the query e.g. \"yyyy-MM-dd hh:mm:ss[.f...] [Z]\" or \"ten minutes ago\".")
    String startDate;
    @AnnotatedCommand.Option(shortForm=101, longForm="endDate", required=false, description="End date of the query e.g.  \"yyyy-MM-dd hh:mm:ss[.f...] [Z]\" or \"five minutes ago\".")
    String endDate;
    static final String queryCriteria = "SELECT * from logs WHERE simpleClassName='SrvMonHeartbeatMessage'";
    static final String defaultOutputFile = "stats.txt";
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final SrvMonHeartbeatTracer statsReader = new SrvMonHeartbeatTracer();
    private final int warmpupLeadTime = -1;
    private RogLogQueryEngine queryEngine;
    private RogLog persister;
    private RogLogRepository repo;

    public final void execute() throws Exception {
        this.statsReader.setFilterAdminApps(!this.all);
        if (!this.transactionLogFile.isAbsolute()) {
            this.transactionLogFile = this.transactionLogFile.getAbsoluteFile();
        }
        if (null == this.outFile) {
            this.outFile = new File(this.transactionLogFile.getParent(), defaultOutputFile);
        }
        this.openTlogForReading();
        try {
            String warmupQueryString;
            String queryString = this.buildTimeCriteria();
            if (this.startDate != null && null != (warmupQueryString = this.calculateWarmupTimeWindow())) {
                warmupQueryString = queryCriteria + warmupQueryString;
                this.warmup(warmupQueryString);
            }
            queryString = queryCriteria + queryString;
            this.dumpResults(queryString);
        }
        finally {
            if (this.transactionLogFile != null) {
                if (this.queryEngine != null) {
                    this.queryEngine.close();
                }
                if (this.repo != null) {
                    this.repo.close();
                }
                if (this.persister != null) {
                    this.persister.close();
                }
            }
        }
    }

    private final String buildTimeCriteria() throws Exception {
        String queryString = "";
        if (null != this.startDate) {
            queryString = queryString + " AND timestamp > '" + this.startDate + "'";
        }
        if (null != this.endDate) {
            queryString = queryString + " AND timestamp < '" + this.endDate + "'";
        }
        if (this.startDate != null && this.endDate != null) {
            queryString = " AND timestamp BETWEEN '" + this.startDate + "' AND '" + this.endDate + "'";
        }
        return queryString;
    }

    private final String calculateWarmupTimeWindow() {
        String warmUpQueryString = null;
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(UtlDataTypes.parseAsDate((Object)this.startDate));
            cal.add(12, -1);
            warmUpQueryString = " AND timestamp BETWEEN '" + this.dateFormat.format(cal.getTime()) + "' AND '" + this.startDate + "'";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return warmUpQueryString;
    }

    private final void openTlogForReading() throws Exception {
        String name = this.transactionLogFile.getName().substring(0, this.transactionLogFile.getName().length() - 4);
        Properties props = new Properties();
        props.setProperty("detactedPersist", "false");
        props.setProperty("storeRoot", this.transactionLogFile.getParent());
        props.setProperty("autoRepair", String.valueOf(false));
        props.setProperty("logMode", "r");
        this.persister = RogLogFactory.createLog((String)name, (Properties)props);
        File factoriesFile = new File(this.transactionLogFile.getParent(), name + ".factories");
        if (factoriesFile.exists()) {
            this.readFactories(factoriesFile);
        }
        this.persister.open();
        this.queryEngine = RogLogFactory.createQueryEngine();
        this.queryEngine.setAutoIndexing(false);
        this.repo = this.persister.asRepository();
        this.repo.open();
        this.queryEngine.addRepository((QueryRepository)this.repo, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readFactories(File factoriesFile) throws Exception {
        if (factoriesFile.exists()) {
            try (BufferedReader br = new BufferedReader(new FileReader(factoriesFile));){
                String line;
                while ((line = br.readLine()) != null) {
                    this.registerFactory(line.trim());
                }
            }
        } else {
            throw new Exception("File not found: " + factoriesFile);
        }
        StoreObjectFactoryRegistry.getInstance().registerObjectFactory(SrvMonFactory.class.getName());
    }

    private final void registerFactory(String className) throws Exception {
        Class<?> clazz = Class.forName(className);
        Method createMethod = null;
        try {
            Class[] parameterTypes = new Class[]{Class.forName("java.util.Properties")};
            createMethod = clazz.getMethod("create", parameterTypes);
        }
        catch (ClassNotFoundException cne) {
            throw new Exception("Failed to load java.util.Properties during instantiation of factory class");
        }
        catch (SecurityException se) {
            throw new Exception("Invalid factory class '" + className + "' access to create method is denied");
        }
        catch (NoSuchMethodException nsme) {
            throw new Exception("Invalid factory class '" + className + "' create() not found");
        }
        IStoreObjectFactory factory = null;
        try {
            try {
                Object[] parameters = new Object[]{null};
                factory = (IStoreObjectFactory)createMethod.invoke(null, parameters);
                if (null == factory) {
                    throw new Exception("Invalid factory class '" + className + "' create() method returned a null object");
                }
                RogLogReader.registerFactory((Object)factory);
            }
            catch (ClassCastException ce) {
                throw new Exception("Invalid factory class '" + className + "' create() did not return a valid factory");
            }
        }
        catch (IllegalAccessException ile) {
            throw new Exception("Invalid factory class '" + className + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dumpResults(String queryString) throws Exception {
        RogLogQuery query = this.queryEngine.createQuery(queryString);
        RogLogResultSet results = this.queryEngine.execute(query);
        FileOutputStream fout = null;
        System.out.println("Writing " + results.getCount() + " records to " + this.outFile.getAbsoluteFile());
        try {
            fout = new FileOutputStream(this.outFile);
            StringBuilder sb = new StringBuilder();
            while (results.next()) {
                sb.setLength(0);
                IStoreObject object = results.getLogEntry().getObject();
                if (!(object instanceof IRogMessage)) continue;
                SrvMonHeartbeatMessage srvMessage = (SrvMonHeartbeatMessage)object;
                sb.append(String.format("\n[%s]<%s,%s> .....[STATS]\n", new Date(srvMessage.getCollectionStartWallTime()), srvMessage.getServerPid(), srvMessage.getServerHostName()));
                this.statsReader.printStats(srvMessage, sb);
                fout.write(sb.toString().getBytes());
            }
            fout.write(sb.toString().getBytes());
        }
        finally {
            try {
                if (null != fout) {
                    fout.close();
                }
            }
            catch (IOException iOException) {}
        }
        System.out.println("Done ...");
    }

    private final void warmup(String queryString) throws Exception {
        RogLogQuery query = this.queryEngine.createQuery(queryString);
        RogLogResultSet results = this.queryEngine.execute(query);
        StringBuilder sb = new StringBuilder();
        while (results.next()) {
            sb.setLength(0);
            IStoreObject object = results.getLogEntry().getObject();
            if (!(object instanceof IRogMessage)) continue;
            SrvMonHeartbeatMessage srvMessage = (SrvMonHeartbeatMessage)object;
            this.statsReader.printStats(srvMessage, sb);
        }
    }

    public static void main(String[] args) {
        try {
            StatsDumpTool statsDumpTool = new StatsDumpTool();
            statsDumpTool.run(args);
            System.exit(0);
        }
        catch (Exception e) {
            System.out.println("Exception in running StatsDumpTool : " + e.getMessage());
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

