/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools;

import com.neeve.config.IConfigRepository;
import com.neeve.server.config.ESrvConfigException;
import com.neeve.server.config.SrvConfigAppDescriptor;
import com.neeve.server.config.SrvConfigDescriptor;
import com.neeve.tools.interactive.InteractiveTool;
import com.neeve.tools.interactive.commands.AnnotatedCommand;
import com.neeve.tools.interactive.commands.Command;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlReflection;
import com.neeve.util.UtlThread;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class SrvConfigToolPlugin {
    private final Map<String, SrvConfigDescriptor> servers;
    private final IConfigRepository repo;
    private final Tracer tracer;

    private final void setAppProperty(String serverName, String appName, String prop, String val) {
        SrvConfigDescriptor server = this.servers.get(serverName);
        if (server != null) {
            if (SrvConfigAppDescriptor.exists(this.repo, server.getName(), appName)) {
                this.tracer.log("Setting " + prop + "=" + val + " in app '" + appName + "' in server '" + server.getName() + "'...", Tracer.Level.INFO);
                try {
                    SrvConfigAppDescriptor app = SrvConfigAppDescriptor.load(this.repo, server.getName(), appName);
                    app.setProperty(prop, val);
                    app.save(this.repo, server.getName());
                    this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    this.tracer.log("Failed to set prop '" + prop + "' to '" + val + "' for app '" + appName + " in server '" + serverName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                this.tracer.log("No app '" + appName + "' in server '" + serverName + "' cannot set prop '" + prop + "' to '" + val + "' for it.", Tracer.Level.SEVERE);
            }
        } else {
            this.tracer.log("Server '" + serverName + "' does not exist cannot set prop '" + prop + "' to '" + val + "' for app '" + appName + " in it.", Tracer.Level.SEVERE);
        }
    }

    private SrvConfigToolPlugin(InteractiveTool interactiveTool, IConfigRepository repo, Tracer tracer) throws Exception {
        this.tracer = tracer;
        this.repo = repo;
        tracer.log("Loading configured servers...", Tracer.Level.INFO);
        this.servers = new LinkedHashMap<String, SrvConfigDescriptor>();
        for (SrvConfigDescriptor server : SrvConfigDescriptor.loadAll(repo)) {
            tracer.log("...." + server.getName(), Tracer.Level.INFO);
            this.servers.put(server.getName(), server);
        }
        interactiveTool.registerCommand((Command)new CreateServer());
        interactiveTool.registerCommand((Command)new ListServers());
        interactiveTool.registerCommand((Command)new DeleteServer());
        interactiveTool.registerCommand((Command)new DumpServer());
        interactiveTool.registerCommand((Command)new SetChecked());
        interactiveTool.registerCommand((Command)new SetAppGroup());
        interactiveTool.registerCommand((Command)new SetMultiThreaded());
        interactiveTool.registerCommand((Command)new SetIOThreadCount());
        interactiveTool.registerCommand((Command)new SetIOThreadCPUAffinityMask());
        interactiveTool.registerCommand((Command)new SetMaxOnDemandThreadCount());
        interactiveTool.registerCommand((Command)new SetClientHandshakeTimeout());
        interactiveTool.registerCommand((Command)new SetServerProperty());
        interactiveTool.registerCommand((Command)new AddAcceptor());
        interactiveTool.registerCommand((Command)new RemoveAcceptor());
        interactiveTool.registerCommand((Command)new AddApp());
        interactiveTool.registerCommand((Command)new DumpApp());
        interactiveTool.registerCommand((Command)new RemoveApp());
        interactiveTool.registerCommand((Command)new SetAppAutoStart());
        interactiveTool.registerCommand((Command)new SetAppProperty());
        interactiveTool.registerCommand((Command)new ClearAppProperty());
        interactiveTool.registerAnnotatedCommands((Object)this);
    }

    public static final Object create(InteractiveTool interactiveTool, IConfigRepository repo, Tracer tracer) throws Exception {
        return new SrvConfigToolPlugin(interactiveTool, repo, tracer);
    }

    public final class ClearAppProperty
    extends Command {
        public final void doClear(String serverName, String appName, String prop) {
            SrvConfigToolPlugin.this.setAppProperty(serverName, appName, prop, null);
        }

        public final void run(String[] args) {
            if (args.length != 3) {
                System.out.println("Syntax error: server_clear_app_property <serverName> <appName> <properyName>");
            } else {
                this.doClear(args[0], args[1], args[2]);
            }
        }

        public final void help() {
            System.out.println("server_clear_app_property");
            System.out.println("  Clears (resets to default) a server app configuration property.");
        }

        public final String[] keywords() {
            return new String[]{"server_clear_app_property", "server_clear_appprop"};
        }
    }

    public final class SetAppProperty
    extends Command {
        public final void doSet(String serverName, String appName, String prop, String val) {
            SrvConfigToolPlugin.this.setAppProperty(serverName, appName, prop, val);
        }

        public final void run(String[] args) {
            if (args.length != 4) {
                System.out.println("Syntax error: server_set_app_property <serverName> <appName> <propertyName> <propertyValue>");
            } else {
                this.doSet(args[0], args[1], args[2], args[3]);
            }
        }

        public final void help() {
            System.out.println("server_set_app_property");
            System.out.println("  Sets a server app configuration property.");
        }

        public final String[] keywords() {
            return new String[]{"server_set_app_property", "server_set_appprop"};
        }
    }

    public final class SetAppAutoStart
    extends Command {
        public final void doSet(String serverName, String appName, boolean val) {
            SrvConfigDescriptor server = (SrvConfigDescriptor)SrvConfigToolPlugin.this.servers.get(serverName);
            if (server != null) {
                if (SrvConfigAppDescriptor.exists(SrvConfigToolPlugin.this.repo, server.getName(), appName)) {
                    SrvConfigToolPlugin.this.tracer.log("Setting autostart=" + val + " in app '" + appName + "' in server '" + server.getName() + "'...", Tracer.Level.INFO);
                    try {
                        SrvConfigAppDescriptor app = SrvConfigAppDescriptor.load(SrvConfigToolPlugin.this.repo, server.getName(), appName);
                        app.setAutoStart(val);
                        app.save(SrvConfigToolPlugin.this.repo, server.getName());
                        SrvConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                    }
                    catch (Exception e) {
                        SrvConfigToolPlugin.this.tracer.log("Failed to set autostart=" + val + " for app '" + appName + " in server '" + serverName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                    }
                } else {
                    SrvConfigToolPlugin.this.tracer.log("Invalid app '" + appName + "' in server '" + serverName + "', cannot set auto start.", Tracer.Level.WARNING);
                }
            } else {
                SrvConfigToolPlugin.this.tracer.log("Server '" + serverName + "' does not exist, cannot set autostart=" + val + " for app '" + appName + " in it.", Tracer.Level.SEVERE);
            }
        }

        public final void run(String[] args) {
            if (args.length != 3) {
                System.out.println("Syntax error: server_set_app_autostart <serverName> <appName> <<autoStart>");
            } else {
                this.doSet(args[0], args[1], Boolean.parseBoolean(args[2]));
            }
        }

        public final void help() {
            System.out.println("server_set_app_autostart");
            System.out.println("  Sets whether an app should be autostarted by a server.");
        }

        public final String[] keywords() {
            return new String[]{"server_set_app_autostart"};
        }
    }

    public final class RemoveApp
    extends Command {
        public final void doRemove(String serverName, String appName) {
            SrvConfigDescriptor server = (SrvConfigDescriptor)SrvConfigToolPlugin.this.servers.get(serverName);
            if (server != null) {
                SrvConfigToolPlugin.this.tracer.log("Removing app '" + appName + "' from server '" + server.getName() + "'...", Tracer.Level.INFO);
                try {
                    if (SrvConfigAppDescriptor.exists(SrvConfigToolPlugin.this.repo, server.getName(), appName)) {
                        SrvConfigAppDescriptor.load(SrvConfigToolPlugin.this.repo, server.getName(), appName).delete(SrvConfigToolPlugin.this.repo, server.getName());
                    }
                    server.removeApp(appName);
                    server.save(SrvConfigToolPlugin.this.repo);
                    SrvConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    SrvConfigToolPlugin.this.tracer.log("Failed to remove app'" + appName + "' from server '" + serverName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                SrvConfigToolPlugin.this.tracer.log("Server '" + serverName + "' does not exist, cannot remove app'" + appName + "' from it.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: server_remove_app <serverName> <appName>");
            } else {
                this.doRemove(args[0], args[1]);
            }
        }

        public final void help() {
            System.out.println("server_remove_app");
            System.out.println("  Deletes an app from the repository.");
        }

        public final String[] keywords() {
            return new String[]{"server_remove_app"};
        }
    }

    public final class DumpApp
    extends Command {
        public final void doDump(String serverName, String appName) {
            block5: {
                SrvConfigDescriptor server = (SrvConfigDescriptor)SrvConfigToolPlugin.this.servers.get(serverName);
                if (server != null) {
                    try {
                        if (SrvConfigAppDescriptor.exists(SrvConfigToolPlugin.this.repo, server.getName(), appName)) {
                            System.out.println("   " + SrvConfigAppDescriptor.load(SrvConfigToolPlugin.this.repo, server.getName(), appName).toString());
                            break block5;
                        }
                        SrvConfigToolPlugin.this.tracer.log("No app '" + appName + "' in server '" + serverName + "'.", Tracer.Level.INFO);
                    }
                    catch (Exception e) {
                        SrvConfigToolPlugin.this.tracer.log("Failed to dump app '" + appName + "' in server '" + serverName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                    }
                } else {
                    SrvConfigToolPlugin.this.tracer.log("Server '" + serverName + "' does not exist, cannot dump app '" + appName + "' in it.", Tracer.Level.SEVERE);
                }
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: server_dump_app <serverName> <appName>");
            } else {
                this.doDump(args[0], args[1]);
            }
        }

        public final void help() {
            System.out.println("server_dump_app");
            System.out.println("  Prints a server app's configuration.");
        }

        public final String[] keywords() {
            return new String[]{"server_dump_app"};
        }
    }

    public final class AddApp
    extends Command {
        public final void doAdd(String serverName, String appName, String appMainClass) {
            SrvConfigDescriptor server = (SrvConfigDescriptor)SrvConfigToolPlugin.this.servers.get(serverName);
            if (server != null) {
                SrvConfigToolPlugin.this.tracer.log("Adding app '" + appName + "' (class=" + appMainClass + "') to server '" + server.getName() + "'...", Tracer.Level.INFO);
                try {
                    SrvConfigAppDescriptor appDescriptor = SrvConfigAppDescriptor.exists(SrvConfigToolPlugin.this.repo, server.getName(), appName) ? SrvConfigAppDescriptor.load(SrvConfigToolPlugin.this.repo, server.getName(), appName) : SrvConfigAppDescriptor.create(appName);
                    appDescriptor.setMainClass(appMainClass);
                    appDescriptor.save(SrvConfigToolPlugin.this.repo, server.getName());
                    server.addApp(appDescriptor);
                    server.save(SrvConfigToolPlugin.this.repo);
                    SrvConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    SrvConfigToolPlugin.this.tracer.log("Failed to add app' " + appName + "' to server '" + serverName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                    return;
                }
            } else {
                SrvConfigToolPlugin.this.tracer.log("Server '" + serverName + "' does not exist, cannot add apps to it.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 3) {
                System.out.println("Syntax error: server_add_app <serverName> <appName> <appMainClass>");
            } else {
                this.doAdd(args[0], args[1], args[2]);
            }
        }

        public final void help() {
            System.out.println("server_add_app");
            System.out.println("  Adds an app to a server.");
        }

        public final String[] keywords() {
            return new String[]{"server_add_app"};
        }
    }

    public final class RemoveAcceptor
    extends Command {
        public final void doRemove(String serverName, String descriptor) {
            SrvConfigDescriptor server = (SrvConfigDescriptor)SrvConfigToolPlugin.this.servers.get(serverName);
            if (server != null) {
                SrvConfigToolPlugin.this.tracer.log("Removing acceptor '" + descriptor + " from server '" + server.getName() + "'...", Tracer.Level.INFO);
                try {
                    server.removeAcceptor(descriptor);
                    server.save(SrvConfigToolPlugin.this.repo);
                    SrvConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    SrvConfigToolPlugin.this.tracer.log("Failed to remove server '" + serverName + "' acceptor '" + descriptor + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                SrvConfigToolPlugin.this.tracer.log("Server '" + serverName + "' does not exist.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: server_remove_acceptor <serverName> <descriptor>");
            } else {
                this.doRemove(args[0], args[1]);
            }
        }

        public final void help() {
            System.out.println("server_remove_acceptor");
            System.out.println("  Removes an acceptor from a server.");
        }

        public final String[] keywords() {
            return new String[]{"server_remove_acceptor"};
        }
    }

    public final class AddAcceptor
    extends Command {
        public final void doAdd(String serverName, String descriptor) {
            SrvConfigDescriptor server = (SrvConfigDescriptor)SrvConfigToolPlugin.this.servers.get(serverName);
            if (server != null) {
                SrvConfigToolPlugin.this.tracer.log("Adding acceptor '" + descriptor + "' to server '" + server.getName() + "'...", Tracer.Level.INFO);
                try {
                    server.addAcceptor(descriptor);
                    server.save(SrvConfigToolPlugin.this.repo);
                    SrvConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    SrvConfigToolPlugin.this.tracer.log("Failed to add server '" + serverName + "' acceptor '" + descriptor + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                SrvConfigToolPlugin.this.tracer.log("Server '" + serverName + "' does not exist, cannot add acceptors to it.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: server_add_acceptor <serverName> <descriptor>");
            } else {
                this.doAdd(args[0], args[1]);
            }
        }

        public final void help() {
            System.out.println("server_add_acceptor");
            System.out.println("  Adds an acceptor to a server.");
        }

        public final String[] keywords() {
            return new String[]{"server_add_acceptor"};
        }
    }

    @AnnotatedCommand.Command(keywords={"server_set_admin_sma_channel_property"}, description="Sets a server admin over sma channel property.")
    public final class SetServerAdminSmaChannelProperty
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(name="serverName", position=0, required=true, description="The name of the server to be configured")
        String serverName;
        @AnnotatedCommand.Argument(name="channelName", position=0, required=true, description="The name of the admin over sma channel to be configured")
        String channelName;
        @AnnotatedCommand.Argument(name="propertyName", position=1, required=true, description="The name of the property to set")
        String propertyName;
        @AnnotatedCommand.Argument(name="propertyValue", position=1, required=true, description="The property value")
        String propertyValue;

        public final void execute() {
            SrvConfigDescriptor server = (SrvConfigDescriptor)SrvConfigToolPlugin.this.servers.get(this.serverName);
            if (server != null) {
                try {
                    SrvConfigToolPlugin.this.tracer.log("Setting '" + this.propertyName + "=" + this.propertyValue + "' as an admin over sma channel property for '" + this.channelName + "' in server '" + this.serverName + "'...", Tracer.Level.INFO);
                    SrvConfigDescriptor.Admin.Sma.Channel channelConfig = server.getAdmin().getSma().getAdminChannel(this.channelName);
                    if (channelConfig == null) {
                        throw new IllegalArgumentException("'" + this.channelName + "' is not a valid admin over sma channel type'");
                    }
                    UtlReflection.setNonNestedProperty((Object)server.getAdmin(), (String)this.propertyName, (Object)this.propertyValue);
                    server.save(SrvConfigToolPlugin.this.repo);
                    SrvConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    SrvConfigToolPlugin.this.tracer.log("Failed to set admin over sma channel property for channel '" + this.channelName + "' in server + '" + this.serverName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                SrvConfigToolPlugin.this.tracer.log("Server '" + this.serverName + "' does not exist, cannot set it admin messaging channel properties.", Tracer.Level.SEVERE);
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"server_set_admin_sma_property"}, description="Sets a server admin over sma property.")
    public final class SetServerAdminSmaProperty
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(name="serverName", position=0, required=true, description="The name of the server with admin over sma  properties to be configured")
        String serverName;
        @AnnotatedCommand.Argument(name="propertyName", position=1, required=true, description="The name of the admin over sma property to set")
        String propertyName;
        @AnnotatedCommand.Argument(name="propertyValue", position=1, required=true, description="The property value")
        String propertyValue;

        public final void execute() {
            SrvConfigDescriptor server = (SrvConfigDescriptor)SrvConfigToolPlugin.this.servers.get(this.serverName);
            if (server != null) {
                try {
                    SrvConfigToolPlugin.this.tracer.log("Setting '" + this.propertyName + "=" + this.propertyValue + "' as an admin over sma property for server '" + this.serverName + "'...", Tracer.Level.INFO);
                    UtlReflection.setNonNestedProperty((Object)server.getAdmin().getSma(), (String)this.propertyName, (Object)this.propertyValue);
                    server.save(SrvConfigToolPlugin.this.repo);
                    SrvConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    SrvConfigToolPlugin.this.tracer.log("Failed to set admin over sma  property for server + '" + this.serverName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                SrvConfigToolPlugin.this.tracer.log("Server '" + this.serverName + "' does not exist, cannot set its admin over sma properties.", Tracer.Level.SEVERE);
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"server_set_admin_property"}, description="Sets a server monitoring property.")
    public final class SetServerAdminProperty
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(name="serverName", position=0, required=true, description="The name of the server to be configured")
        String serverName;
        @AnnotatedCommand.Argument(name="propertyName", position=1, required=true, description="The name of the property to set")
        String propertyName;
        @AnnotatedCommand.Argument(name="propertyValue", position=1, required=true, description="The property value")
        String propertyValue;

        public final void execute() {
            SrvConfigDescriptor server = (SrvConfigDescriptor)SrvConfigToolPlugin.this.servers.get(this.serverName);
            if (server != null) {
                try {
                    SrvConfigToolPlugin.this.tracer.log("Setting '" + this.propertyName + "=" + this.propertyValue + "' as admin property for server '" + this.serverName + "'...", Tracer.Level.INFO);
                    UtlReflection.setNonNestedProperty((Object)server.getAdmin(), (String)this.propertyName, (Object)this.propertyValue);
                    server.save(SrvConfigToolPlugin.this.repo);
                    SrvConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    SrvConfigToolPlugin.this.tracer.log("Failed to set admin property for server + '" + this.serverName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                SrvConfigToolPlugin.this.tracer.log("Server '" + this.serverName + "' does not exist, cannot set it admin properties.", Tracer.Level.SEVERE);
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"server_set_heartbeats_property"}, description="Sets a server heartbeats property.")
    public final class SetServerHeartbeatsProperty
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(name="serverName", position=0, required=true, description="The name of the server to be configured")
        String serverName;
        @AnnotatedCommand.Argument(name="propertyName", position=1, required=true, description="The name of the property to set")
        String propertyName;
        @AnnotatedCommand.Argument(name="propertyValue", position=1, required=true, description="The property value")
        String propertyValue;

        public final void execute() {
            SrvConfigDescriptor server = (SrvConfigDescriptor)SrvConfigToolPlugin.this.servers.get(this.serverName);
            if (server != null) {
                try {
                    SrvConfigToolPlugin.this.tracer.log("Setting '" + this.propertyName + "=" + this.propertyValue + "' as heartbeats property for server '" + this.serverName + "'...", Tracer.Level.INFO);
                    UtlReflection.setNonNestedProperty((Object)server.getHeartbeats(), (String)this.propertyName, (Object)this.propertyValue);
                    server.save(SrvConfigToolPlugin.this.repo);
                    SrvConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    SrvConfigToolPlugin.this.tracer.log("Failed to set heartbeat property for server + '" + this.serverName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                SrvConfigToolPlugin.this.tracer.log("Server '" + this.serverName + "' does not exist, cannot set it heartbeat properties.", Tracer.Level.SEVERE);
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"server_set_heartbeat_tracing_property"}, description="Sets a server heartbeat tracing property.")
    public final class SetServerHeartbeatTracingProperty
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(name="serverName", position=0, required=true, description="The name of the server to be configured")
        String serverName;
        @AnnotatedCommand.Argument(name="propertyName", position=1, required=true, description="The name of the property to set")
        String propertyName;
        @AnnotatedCommand.Argument(name="propertyValue", position=1, required=true, description="The property value")
        String propertyValue;

        public final void execute() {
            SrvConfigDescriptor server = (SrvConfigDescriptor)SrvConfigToolPlugin.this.servers.get(this.serverName);
            if (server != null) {
                try {
                    SrvConfigToolPlugin.this.tracer.log("Setting '" + this.propertyName + "=" + this.propertyValue + "' as heartbeat tracing property for server '" + this.serverName + "'...", Tracer.Level.INFO);
                    SrvConfigDescriptor.HeartbeatTracing heartbeatTracing = server.getHeartbeatTracing();
                    UtlReflection.setNonNestedProperty((Object)heartbeatTracing, (String)this.propertyName, (Object)this.propertyValue);
                    server.save(SrvConfigToolPlugin.this.repo);
                    SrvConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    SrvConfigToolPlugin.this.tracer.log("Failed to set heartbeat tracing property for server + '" + this.serverName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                SrvConfigToolPlugin.this.tracer.log("Server '" + this.serverName + "' does not exist, cannot set it heartbeat tracing properties.", Tracer.Level.SEVERE);
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"server_set_heartbeat_logging_property"}, description="Sets a server heartbeat logging property property.")
    public final class SetServerHeartbeatLoggingProperty
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(name="serverName", position=0, required=true, description="The name of the server to be configured")
        String serverName;
        @AnnotatedCommand.Argument(name="propertyName", position=1, required=true, description="The name of the property to set")
        String propertyName;
        @AnnotatedCommand.Argument(name="propertyValue", position=1, required=true, description="The property value")
        String propertyValue;

        public final void execute() {
            SrvConfigDescriptor server = (SrvConfigDescriptor)SrvConfigToolPlugin.this.servers.get(this.serverName);
            if (server != null) {
                try {
                    SrvConfigToolPlugin.this.tracer.log("Setting '" + this.propertyName + "=" + this.propertyValue + "' as heartbeat logging property for server '" + this.serverName + "'...", Tracer.Level.INFO);
                    server.setHeartbeatLoggingProperty(this.propertyName, this.propertyValue);
                    server.save(SrvConfigToolPlugin.this.repo);
                    SrvConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    SrvConfigToolPlugin.this.tracer.log("Failed to set heartbeat logging property for server + '" + this.serverName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                SrvConfigToolPlugin.this.tracer.log("Server '" + this.serverName + "' does not exist, cannot set it heartbeat logging properties.", Tracer.Level.SEVERE);
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"server_set_property", "server_setprop"}, description="Sets a server property.")
    public final class SetServerProperty
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(name="serverName", position=0, required=true, description="The name of the server to be configured")
        String serverName;
        @AnnotatedCommand.Argument(name="propertyName", position=1, required=true, description="The name of the property to set")
        String propertyName;
        @AnnotatedCommand.Argument(name="propertyName", position=1, required=true, description="The property value")
        String propertyValue;

        public void execute() throws Exception {
            SrvConfigDescriptor server = (SrvConfigDescriptor)SrvConfigToolPlugin.this.servers.get(this.serverName);
            if (server != null) {
                try {
                    SrvConfigToolPlugin.this.tracer.log("Setting '" + this.propertyName + "' to '" + this.propertyValue + "' for server '" + this.serverName + "'...", Tracer.Level.INFO);
                    UtlReflection.setNonNestedProperty((Object)server, (String)this.propertyName, (Object)this.propertyValue);
                    server.save(SrvConfigToolPlugin.this.repo);
                    SrvConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    SrvConfigToolPlugin.this.tracer.log("Failed to set server descriptor property '" + this.propertyName + "' to '" + this.propertyValue + "' for server '" + this.serverName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                SrvConfigToolPlugin.this.tracer.log("Server '" + this.serverName + "' does not exist, cannot set descriptor properties.", Tracer.Level.SEVERE);
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"server_set_discoverydescriptor"}, description="Sets the server's discovery descriptor")
    public final class SetDiscoveryDescriptor
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(position=1, name="serverName", description="The name of the server")
        String serverName;
        @AnnotatedCommand.Argument(position=2, name="descriptor", description="The discovery descriptor")
        String val;

        public final void execute() {
            SrvConfigDescriptor server = (SrvConfigDescriptor)SrvConfigToolPlugin.this.servers.get(this.serverName);
            if (server != null) {
                SrvConfigToolPlugin.this.tracer.log("Setting discovery descriptor to " + this.val + " in server '" + server.getName() + "'...", Tracer.Level.INFO);
                try {
                    server.setDiscoveryDescriptor(this.val);
                    server.save(SrvConfigToolPlugin.this.repo);
                    SrvConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    SrvConfigToolPlugin.this.tracer.log("Failed to set server '" + this.serverName + "' discovery descriptor to '" + this.val + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                SrvConfigToolPlugin.this.tracer.log("Server '" + this.serverName + "' does not exist, cannot set its discovery descriptor.", Tracer.Level.WARNING);
            }
        }
    }

    public final class SetClientHandshakeTimeout
    extends Command {
        public final void doSet(String serverName, int val) {
            SrvConfigDescriptor server = (SrvConfigDescriptor)SrvConfigToolPlugin.this.servers.get(serverName);
            if (server != null) {
                SrvConfigToolPlugin.this.tracer.log("Setting client handshake timeout to " + val + " in server '" + server.getName() + "'...", Tracer.Level.INFO);
                try {
                    server.setClientHandshakeTimeout(val);
                    server.save(SrvConfigToolPlugin.this.repo);
                    SrvConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    SrvConfigToolPlugin.this.tracer.log("Failed to set server '" + serverName + "' client handshake timeout to '" + val + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                SrvConfigToolPlugin.this.tracer.log("Server '" + serverName + "' does not exist, cannot set its handshake timeout.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: server_set_clienthandshaketimeout <serverName> <timeout>");
            } else {
                this.doSet(args[0], Integer.parseInt(args[1]));
            }
        }

        public final void help() {
            System.out.println("server_set_clienthandshaketimeout");
            System.out.println("  Sets the maximum amount of time to wait for handshake with a client to complete.");
        }

        public final String[] keywords() {
            return new String[]{"server_set_clienthandshaketimeout"};
        }
    }

    public final class SetMaxOnDemandThreadCount
    extends Command {
        public final void doSet(String serverName, int val) {
            SrvConfigDescriptor server = (SrvConfigDescriptor)SrvConfigToolPlugin.this.servers.get(serverName);
            if (server != null) {
                SrvConfigToolPlugin.this.tracer.log("Setting max on demand thread count to " + val + " in server '" + server.getName() + "'...", Tracer.Level.INFO);
                try {
                    server.setMaxOnDemandThreadCount(val);
                    server.save(SrvConfigToolPlugin.this.repo);
                    SrvConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    SrvConfigToolPlugin.this.tracer.log("Failed to set server '" + serverName + "' max on demand thread count to '" + val + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                SrvConfigToolPlugin.this.tracer.log("Server '" + serverName + "' does not exist, cannot set its max on demand thread count.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: server_set_maxodthreadcount <serverName> <threadCount>");
            } else {
                this.doSet(args[0], Integer.parseInt(args[1]));
            }
        }

        public final void help() {
            System.out.println("server_set_maxodthreadcount");
            System.out.println("  Sets the maximum number of threads that can be requested for creation on demand from the server.");
        }

        public final String[] keywords() {
            return new String[]{"server_set_maxodthreadcount"};
        }
    }

    public final class SetIOThreadCPUAffinityMask
    extends Command {
        public final void doSet(String serverName, int threadId, long val) {
            SrvConfigDescriptor server = (SrvConfigDescriptor)SrvConfigToolPlugin.this.servers.get(serverName);
            if (server != null) {
                SrvConfigToolPlugin.this.tracer.log("Setting CPU affinity mask for IO thread #" + threadId + " to " + val + " in server '" + server.getName() + "'...", Tracer.Level.INFO);
                try {
                    server.setIOThreadCPUAffinityMask(threadId, val);
                    server.save(SrvConfigToolPlugin.this.repo);
                    SrvConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    SrvConfigToolPlugin.this.tracer.log("Failed to set server '" + serverName + "' io thread cpu affinity mask [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                SrvConfigToolPlugin.this.tracer.log("Server '" + serverName + "' does not exist, cannot set io thread cpu affinitiy masks.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 3) {
                System.out.println("Syntax error: server_set_iothreadcpuaffmask <serverName> <threadId> <mask>");
            } else {
                this.doSet(args[0], Integer.parseInt(args[1]), UtlThread.parseAffinityMask((String)args[2]));
            }
        }

        public final void help() {
            System.out.println("server_set_iothreadcpuaffmask");
            System.out.println("  Sets the CPU affinity mask for a server IO thread.");
        }

        public final String[] keywords() {
            return new String[]{"server_set_iothreadcpuaffmask"};
        }
    }

    public final class SetIOThreadCount
    extends Command {
        public final void doSet(String serverName, int val) {
            SrvConfigDescriptor server = (SrvConfigDescriptor)SrvConfigToolPlugin.this.servers.get(serverName);
            if (server != null) {
                SrvConfigToolPlugin.this.tracer.log("Setting IO thread count to " + val + " in server '" + server.getName() + "'...", Tracer.Level.INFO);
                try {
                    server.setIOThreadCount(val);
                    server.save(SrvConfigToolPlugin.this.repo);
                    SrvConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    SrvConfigToolPlugin.this.tracer.log("Failed to set server '" + serverName + "' io thread count to '" + val + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                SrvConfigToolPlugin.this.tracer.log("Server '" + serverName + "' does not exist, cannot set its io thread count.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: server_set_iothreadcount <serverName> <threadCount>");
            } else {
                this.doSet(args[0], Integer.parseInt(args[1]));
            }
        }

        public final void help() {
            System.out.println("server_set_iothreadcount");
            System.out.println("  Sets the number of threads to start up in the server as IO threads.");
        }

        public final String[] keywords() {
            return new String[]{"server_set_iothreadcount"};
        }
    }

    public final class SetMultiThreaded
    extends Command {
        public final void doSet(String serverName, boolean val) {
            SrvConfigDescriptor server = (SrvConfigDescriptor)SrvConfigToolPlugin.this.servers.get(serverName);
            if (server != null) {
                SrvConfigToolPlugin.this.tracer.log("Setting multithreaded=" + val + " in server '" + server.getName() + "'...", Tracer.Level.INFO);
                try {
                    server.setMultiThreaded(val);
                    server.save(SrvConfigToolPlugin.this.repo);
                    SrvConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    SrvConfigToolPlugin.this.tracer.log("Failed to set server '" + serverName + "' multithreaded to '" + val + "[" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                SrvConfigToolPlugin.this.tracer.log("Server '" + serverName + "' does not exist, cannot set its multithreaded property.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: server_set_multithreaded <serverName> <true|false>");
            } else {
                this.doSet(args[0], Boolean.parseBoolean(args[1]));
            }
        }

        public final void help() {
            System.out.println("server_set_multithreaded");
            System.out.println("  Sets a server to operate in a single or multi-threaded mode.");
        }

        public final String[] keywords() {
            return new String[]{"server_set_multithreaded"};
        }
    }

    public final class SetAppGroup
    extends Command {
        public final void doSet(String serverName, String val) {
            SrvConfigDescriptor server = (SrvConfigDescriptor)SrvConfigToolPlugin.this.servers.get(serverName);
            if (server != null) {
                SrvConfigToolPlugin.this.tracer.log("Setting application group to " + val + " in server '" + server.getName() + "'...", Tracer.Level.INFO);
                try {
                    server.setGroup(val);
                    server.save(SrvConfigToolPlugin.this.repo);
                    SrvConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    SrvConfigToolPlugin.this.tracer.log("Failed to set server '" + serverName + "' application group to '" + val + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                SrvConfigToolPlugin.this.tracer.log("Server '" + serverName + "' does not exist, cannot set its application group.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: server_set_appgroup <serverName> <groupName>");
            } else {
                this.doSet(args[0], args[1]);
            }
        }

        public final void help() {
            System.out.println("server_set_appgroup");
            System.out.println("  Sets the application group to which the server and contained apps belong.");
        }

        public final String[] keywords() {
            return new String[]{"server_set_appgroup"};
        }
    }

    public final class SetChecked
    extends Command {
        public final void doSet(String serverName, boolean val) {
            SrvConfigDescriptor server = (SrvConfigDescriptor)SrvConfigToolPlugin.this.servers.get(serverName);
            if (server != null) {
                SrvConfigToolPlugin.this.tracer.log("Setting checked=" + val + " in server '" + server.getName() + "'...", Tracer.Level.INFO);
                try {
                    server.setChecked(val);
                    server.save(SrvConfigToolPlugin.this.repo);
                    SrvConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    SrvConfigToolPlugin.this.tracer.log("Failed to set server '" + serverName + "' checked to '" + val + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                SrvConfigToolPlugin.this.tracer.log("Server '" + serverName + "' does not exist, cannot set is checked value.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: server_set_checked <serverName> <true|false>");
            } else {
                this.doSet(args[0], Boolean.parseBoolean(args[1]));
            }
        }

        public final void help() {
            System.out.println("server_set_checked");
            System.out.println("  Sets a server to operate in checked or unchecked mode.");
        }

        public final String[] keywords() {
            return new String[]{"server_set_checked"};
        }
    }

    public final class DumpServer
    extends Command {
        public final void doDump(String serverName) {
            SrvConfigDescriptor server = (SrvConfigDescriptor)SrvConfigToolPlugin.this.servers.get(serverName);
            if (server != null) {
                System.out.println("\n   '" + server.getName() + "' configuration");
                System.out.println("   {");
                System.out.print(server);
                System.out.println("   }\n");
            } else {
                SrvConfigToolPlugin.this.tracer.log("Server '" + serverName + "' does not exist.", Tracer.Level.INFO);
            }
        }

        public final void run(String[] args) {
            if (args.length != 1) {
                System.out.println("Syntax error: server_dump <serverName>");
            } else {
                this.doDump(args[0]);
            }
        }

        public final void help() {
            System.out.println("server_dump");
            System.out.println("  Prints a server's configuration.");
        }

        public final String[] keywords() {
            return new String[]{"server_dump"};
        }
    }

    public final class DeleteServer
    extends Command {
        public final void doDelete(String serverName) {
            SrvConfigDescriptor server = (SrvConfigDescriptor)SrvConfigToolPlugin.this.servers.get(serverName);
            if (server != null) {
                SrvConfigToolPlugin.this.tracer.log("Deleting server '" + server.getName() + "'...", Tracer.Level.INFO);
                try {
                    server.delete(SrvConfigToolPlugin.this.repo);
                    SrvConfigToolPlugin.this.servers.remove(serverName);
                    SrvConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    SrvConfigToolPlugin.this.tracer.log("Failed to delete server '" + server.getName() + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                SrvConfigToolPlugin.this.tracer.log("Server '" + serverName + "' does not exist so it cannot be deleted.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 1) {
                System.out.println("Syntax error: server_delete <serverName>");
            } else {
                this.doDelete(args[0]);
            }
        }

        public final void help() {
            System.out.println("server_delete");
            System.out.println("  Deletes a server from the repository.");
        }

        public final String[] keywords() {
            return new String[]{"server_delete"};
        }
    }

    public final class ListServers
    extends Command {
        public final void doList() {
            if (SrvConfigToolPlugin.this.servers.size() > 0) {
                Iterator serverIterator = SrvConfigToolPlugin.this.servers.keySet().iterator();
                int maxLength = 0;
                while (serverIterator.hasNext()) {
                    maxLength = Math.max(((String)serverIterator.next()).length(), maxLength);
                }
                serverIterator = SrvConfigToolPlugin.this.servers.keySet().iterator();
                while (serverIterator.hasNext()) {
                    SrvConfigDescriptor server = (SrvConfigDescriptor)SrvConfigToolPlugin.this.servers.get(serverIterator.next());
                    System.out.print("  " + server.getName());
                    Iterator<String> appsIterator = server.getAppNames().iterator();
                    for (int i = server.getName().length(); i < maxLength + 3; ++i) {
                        System.out.print(".");
                    }
                    System.out.print("{");
                    while (appsIterator.hasNext()) {
                        SrvConfigAppDescriptor app;
                        String appName = appsIterator.next();
                        try {
                            app = SrvConfigAppDescriptor.load(SrvConfigToolPlugin.this.repo, server.getName(), appName);
                        }
                        catch (ESrvConfigException e) {
                            SrvConfigToolPlugin.this.tracer.log("*** Repository is corrupt [Could not load an app listed in the server app list [" + e.toString() + "] ***", Tracer.Level.INFO);
                            return;
                        }
                        System.out.print(app.getName());
                        if (!appsIterator.hasNext()) continue;
                        System.out.print(", ");
                    }
                    System.out.println("}");
                }
            } else {
                SrvConfigToolPlugin.this.tracer.log("No servers in repository.", Tracer.Level.INFO);
            }
        }

        public final void run(String[] args) {
            if (args.length != 0) {
                System.out.println("Syntax error: servers");
            } else {
                this.doList();
            }
        }

        public final void help() {
            System.out.println("servers");
            System.out.println("  Lists the servers in the repository.");
        }

        public final String[] keywords() {
            return new String[]{"servers"};
        }
    }

    public final class CreateServer
    extends Command {
        public final void doCreate(String serverName) {
            if (SrvConfigToolPlugin.this.servers.get(serverName) == null) {
                SrvConfigToolPlugin.this.tracer.log("Creating new server '" + serverName + "'...", Tracer.Level.INFO);
                try {
                    SrvConfigDescriptor server = SrvConfigDescriptor.create(serverName);
                    server.save(SrvConfigToolPlugin.this.repo);
                    SrvConfigToolPlugin.this.servers.put(serverName, server);
                    SrvConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    SrvConfigToolPlugin.this.tracer.log("Failed to create server '" + serverName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                    return;
                }
                new AddApp().doAdd(serverName, "admin", "com.neeve.server.controller.SrvControllerAdminApp");
            } else {
                SrvConfigToolPlugin.this.tracer.log("Cannot create server '" + serverName + "', it already exists.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 1) {
                System.out.println("Syntax error: server_create <serverName>");
            } else {
                this.doCreate(args[0]);
            }
        }

        public final void help() {
            System.out.println("server_create");
            System.out.println("  Creates a new server in the repository");
        }

        public final String[] keywords() {
            return new String[]{"server_create"};
        }
    }
}

