/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.test.unit;

import com.neeve.adm.test.unit.xbuf.Message;
import com.neeve.aep.AepEngine;
import com.neeve.aep.AepEngineDescriptor;
import com.neeve.aep.AepScheduleEvent;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.event.AepChannelUpEvent;
import com.neeve.aep.event.AepMessagingPrestartEvent;
import com.neeve.aep.event.AepMessagingStartedEvent;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.aep.test.unit.generated.xbuf.PooledStringField;
import com.neeve.ci.XRuntime;
import com.neeve.daemon.controller.IDmnControllerEventHandler;
import com.neeve.io.IOBuffer;
import com.neeve.lang.XFactory;
import com.neeve.lang.XString;
import com.neeve.ods.StoreDescriptor;
import com.neeve.ods.StorePersisterDescriptor;
import com.neeve.ods.StoreReplicatorDescriptor;
import com.neeve.query.QueryRepository;
import com.neeve.rog.IRogMessage;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.RogLogFactory;
import com.neeve.rog.log.RogLogQueryEngine;
import com.neeve.rog.log.RogLogRepository;
import com.neeve.rog.log.RogLogResultSet;
import com.neeve.server.app.SrvAppLoader;
import com.neeve.server.app.annotations.AppInjectionPoint;
import com.neeve.server.app.annotations.AppStat;
import com.neeve.server.config.SrvConfigAppDescriptor;
import com.neeve.server.config.SrvConfigDescriptor;
import com.neeve.server.controller.SrvController;
import com.neeve.server.mon.SrvMonAppEventMultiplexerFeederQueueStats;
import com.neeve.server.mon.SrvMonAppStats;
import com.neeve.server.mon.SrvMonDisruptorStats;
import com.neeve.server.mon.SrvMonHeartbeatMessage;
import com.neeve.server.mon.SrvMonMsgTypeStats;
import com.neeve.server.mon.SrvMonPoolStats;
import com.neeve.server.mon.SrvMonUserCounterStat;
import com.neeve.server.mon.util.SrvMonHeartbeatTracer;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessageView;
import com.neeve.stats.BooleanGauge;
import com.neeve.stats.ByteGauge;
import com.neeve.stats.CharGauge;
import com.neeve.stats.DoubleGauge;
import com.neeve.stats.FloatGauge;
import com.neeve.stats.IStats;
import com.neeve.stats.IntGauge;
import com.neeve.stats.LongGauge;
import com.neeve.stats.ShortGauge;
import com.neeve.stats.StatsFactory;
import com.neeve.stats.StringGauge;
import com.neeve.test.UnitTest;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class SrvControllerHeartbeatDispatchTest
extends UnitTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeartbeatDispatch() throws Exception {
        XRuntime.getProps().setProperty("nv.msg.latency.stats", "true");
        XRuntime.getProps().setProperty("nv.msgtype.latency.stats", "true");
        SrvConfigDescriptor serverConfig = this.createTestServer(this.testcaseName.getMethodName(), HeartbeatDispatchTestApp.class);
        serverConfig.getHeartbeats().setInterval(1L);
        serverConfig.getHeartbeats().setEnabled(true);
        serverConfig.getHeartbeatTracing().setEnabled(false);
        ServerRunner runner = new ServerRunner(serverConfig);
        runner.start();
        try {
            runner.waitForServerToStart();
            HeartbeatDispatchTestApp app = (HeartbeatDispatchTestApp)runner.controller.getAppManager().getAppLoader(this.testcaseName.getMethodName() + "App").getAppMain();
            app.waitForHeartbeat(30L);
            Assert.assertTrue((String)"Didn't get server heartbeats", (boolean)app.waitForHeartbeat(10L));
            for (int i = 0; i < app.collectedCounts.length; ++i) {
                Assert.assertEquals((String)("Unexpected stat count for heartbeat " + (i + 1)), (long)i, (long)app.collectedCounts[i]);
            }
            Assert.assertEquals((String)"Wrong value for last max feeder concurrency", (long)16L, (long)app.lastMaxFeederConcurrency);
            Assert.assertEquals((String)"Wrong value for last lastDecongested", (long)0L, (long)app.lastLastDecongested);
            Assert.assertEquals((String)"Wrong value for last schedule queue size", (long)1L, (long)app.lastScheduleQueueSize);
        }
        finally {
            runner.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeartbeatLogging() throws Exception {
        XRuntime.getProps().setProperty("nv.msg.latency.stats", "true");
        XRuntime.getProps().setProperty("nv.msgtype.latency.stats", "true");
        SrvConfigDescriptor serverConfig = this.createTestServer(this.testcaseName.getMethodName(), HeartbeatDispatchTestApp.class);
        serverConfig.getHeartbeats().setEnabled(true);
        serverConfig.getHeartbeats().setInterval(1L);
        serverConfig.getHeartbeats().setIncludeMessageTypeStats(true);
        serverConfig.getHeartbeatTracing().setEnabled(true);
        serverConfig.setHeartbeatLoggingProperty("enabled", "true");
        ServerRunner runner = new ServerRunner(serverConfig);
        runner.start();
        runner.waitForServerToStart();
        HeartbeatDispatchTestApp app = (HeartbeatDispatchTestApp)runner.controller.getAppManager().getAppLoader(this.testcaseName.getMethodName() + "App").getAppMain();
        app.waitForHeartbeat(30L);
        Assert.assertTrue((String)"Didn't get server heartbeats", (boolean)app.waitForHeartbeat(10L));
        for (int i = 0; i < app.collectedCounts.length; ++i) {
            Assert.assertEquals((String)("Unexpected stat count for heartbeat " + (i + 1)), (long)i, (long)app.collectedCounts[i]);
        }
        Assert.assertEquals((String)"Wrong value for last max feeder concurrency", (long)16L, (long)app.lastMaxFeederConcurrency);
        Assert.assertEquals((String)"Wrong value for last lastDecongested", (long)0L, (long)app.lastLastDecongested);
        Assert.assertEquals((String)"Wrong value for last schedule queue size", (long)1L, (long)app.lastScheduleQueueSize);
        RogLog log = null;
        RogLogRepository repo = null;
        RogLogQueryEngine engine = null;
        try {
            log = RogLog.create((String)(this.testcaseName.getMethodName() + "Server-heartbeats"), (Properties)serverConfig.getHeartbeatLoggingProperties());
            log.open();
            repo = log.asRepository();
            repo.open();
            engine = RogLogFactory.createQueryEngine();
            engine.addRepository((QueryRepository)repo, "heartbeats");
            RogLogResultSet rc = engine.execute("SELECT * FROM logs");
            Assert.assertTrue((String)("Too few heartbeats: " + rc.getCount() + " expected at least " + app.collectedCounts.length), (rc.getCount() >= app.collectedCounts.length ? 1 : 0) != 0);
            HeartbeatDispatchTestApp app2 = new HeartbeatDispatchTestApp();
            app2.onEngineDescriptorInjected(app.engineDescriptor);
            rc.beforeFirst();
            SrvMonHeartbeatTracer reader = new SrvMonHeartbeatTracer();
            StringBuilder buffer = new StringBuilder();
            while (rc.next()) {
                app2.onHeartbeat((SrvMonHeartbeatMessage)rc.getLogEntry().getObject());
                reader.printStats((SrvMonHeartbeatMessage)rc.getLogEntry().getObject(), buffer);
            }
            if (SrvControllerHeartbeatDispatchTest.verbose()) {
                System.err.println("Read Stats:\n" + buffer);
            }
            Assert.assertTrue((String)"Didn't get server heartbeats", (boolean)app2.waitForHeartbeat(1L));
            for (int i = 0; i < app2.collectedCounts.length; ++i) {
                Assert.assertEquals((String)("Unexpected stat count for heartbeat " + (i + 1)), (long)i, (long)app2.collectedCounts[i]);
            }
            Assert.assertEquals((String)"Wrong value for last max feeder concurrency", (long)16L, (long)app.lastMaxFeederConcurrency);
            Assert.assertEquals((String)"Wrong value for last lastDecongested", (long)0L, (long)app.lastLastDecongested);
            Assert.assertEquals((String)"Wrong value for last schedule queue size", (long)1L, (long)app.lastScheduleQueueSize);
        }
        finally {
            if (engine != null) {
                engine.close();
            }
            if (repo != null) {
                repo.close();
            }
            if (log != null) {
                log.close();
            }
            runner.shutdown();
        }
    }

    private SrvConfigDescriptor createTestServer(String testName, Class<?> appClass) throws Exception {
        SrvConfigDescriptor descriptor = SrvConfigDescriptor.create(testName + "Server");
        descriptor.setHeartbeatLoggingProperty("storeRoot", SrvControllerHeartbeatDispatchTest.getTestbedRoot() + testName + "/" + testName + "Server");
        descriptor.setHeartbeatLoggingProperty("initialLogLength", ".00001");
        descriptor.save();
        SrvConfigAppDescriptor appDescriptor = SrvConfigAppDescriptor.create(testName + "App");
        appDescriptor.setMainClass(appClass.getName());
        appDescriptor.setAutoStart(true);
        appDescriptor.save(descriptor.getName());
        descriptor.addApp(appDescriptor);
        descriptor.save();
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPoolDepletionThreshold() throws Exception {
        SrvConfigDescriptor serverConfig = this.createTestServer(this.testcaseName.getMethodName(), PoolDepletionHeartbeatDispatchTestApp.class);
        serverConfig.getHeartbeats().setEnabled(true);
        serverConfig.getHeartbeats().setInterval(1L);
        serverConfig.getHeartbeats().setPoolDepletionThreshold(20.0f);
        ServerRunner runner = new ServerRunner(serverConfig);
        runner.start();
        try {
            runner.waitForServerToStart();
            PoolDepletionHeartbeatDispatchTestApp app = (PoolDepletionHeartbeatDispatchTestApp)runner.controller.getAppManager().getAppLoader(this.testcaseName.getMethodName() + "App").getAppMain();
            app.waitForHeartbeats(60L);
        }
        finally {
            runner.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeartbeatPoolDisablement() throws Exception {
        SrvConfigDescriptor serverConfig = this.createTestServer(this.testcaseName.getMethodName(), HeartbeatDispatchPoolDisablementTestApp.class);
        serverConfig.getHeartbeats().setEnabled(true);
        serverConfig.getHeartbeats().setInterval(1L);
        serverConfig.getHeartbeats().setCollectPoolStats(false);
        ServerRunner runner = new ServerRunner(serverConfig);
        runner.start();
        try {
            runner.waitForServerToStart();
            HeartbeatDispatchPoolDisablementTestApp app = (HeartbeatDispatchPoolDisablementTestApp)runner.controller.getAppManager().getAppLoader(this.testcaseName.getMethodName() + "App").getAppMain();
            for (int i = 0; i < 30 && app.heartbeatCount <= 5; ++i) {
                Thread.sleep(1000L);
            }
            Assert.assertTrue((String)"Didn't get any heartbeats", (app.heartbeatCount > 0 ? 1 : 0) != 0);
            Assert.assertFalse((String)"Pool Stats were included", (boolean)app.foundPoolStats);
        }
        finally {
            runner.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testHeartbeatMsgTypeStats(int inactivityReportFrequency) throws Exception {
        SrvConfigDescriptor serverConfig = this.createTestServer(this.testcaseName.getMethodName(), HeartbeatDispatchMsgTypeStatsTestApp.class);
        serverConfig.getHeartbeats().setEnabled(true);
        serverConfig.getHeartbeats().setInterval(1L);
        serverConfig.getHeartbeats().setCollectPoolStats(false);
        serverConfig.getHeartbeats().setIncludeMessageTypeStats(true);
        serverConfig.getHeartbeats().setInactiveMessageTypeStatsInclusionFrequency(inactivityReportFrequency);
        serverConfig.getHeartbeats().getTracing().setEnabled(SrvControllerHeartbeatDispatchTest.verbose());
        ServerRunner runner = new ServerRunner(serverConfig);
        runner.start();
        try {
            runner.waitForServerToStart();
            HeartbeatDispatchMsgTypeStatsTestApp app = (HeartbeatDispatchMsgTypeStatsTestApp)runner.controller.getAppManager().getAppLoader(this.testcaseName.getMethodName() + "App").getAppMain();
            app.testInactiveMessageTypeStatsIncluded();
        }
        finally {
            runner.shutdown();
        }
    }

    @Test
    public void testHeartbeatMsgTypeStatsInactiveAlwaysReported() throws Exception {
        this.testHeartbeatMsgTypeStats(1);
    }

    @Test
    public void testHeartbeatMsgTypeStatsInactiveReportedNever() throws Exception {
        this.testHeartbeatMsgTypeStats(0);
    }

    @Test
    public void testHeartbeatMsgTypeStatsInactivePeriodicallyReported() throws Exception {
        this.testHeartbeatMsgTypeStats(3);
    }

    public static final class HeartbeatDispatchMsgTypeStatsTestApp {
        volatile int heartbeatCount;
        private volatile AepEngine engine;
        private CountDownLatch firstHeartbeatLatch = new CountDownLatch(1);
        private CountDownLatch startLatch = new CountDownLatch(1);
        private CountDownLatch doneLatch = new CountDownLatch(1);
        private volatile boolean done;
        private boolean started = false;
        private volatile String heartbeatValidationError = null;
        private volatile int inactiveFrequency = 0;
        private volatile long heartbeatInterval = 0L;
        private volatile int heartbeatsToValidate = 0;

        @AppInjectionPoint
        public void injectEngine(SrvAppLoader config) {
            this.heartbeatInterval = config.getServerDescriptor().getHeartbeats().getInterval();
            this.inactiveFrequency = config.getServerDescriptor().getHeartbeats().getInactiveMessageTypeStatsInclusionFrequency();
            this.heartbeatsToValidate = Math.max(this.inactiveFrequency * 3, 10);
        }

        @AppInjectionPoint
        public void injectEngine(AepEngineDescriptor config) {
            config.setCaptureMessageTypeStats(true);
            config.setCaptureTransactionLatencyStats(true);
        }

        @AppInjectionPoint
        public void injectEngine(AepEngine engine) {
            this.engine = engine;
        }

        @EventHandler
        public final void onHeartbeat(SrvMonHeartbeatMessage heartbeat) throws InterruptedException {
            ++this.heartbeatCount;
            if (!this.started) {
                this.firstHeartbeatLatch.countDown();
                this.startLatch.await(20L, TimeUnit.SECONDS);
            }
            if (this.done) {
                return;
            }
            SrvMonMsgTypeStats msgTypeStats = null;
            block0: for (SrvMonAppStats appStats : heartbeat.getAppsStats()) {
                if (!appStats.getAppName().equals(this.engine.getName())) continue;
                for (SrvMonMsgTypeStats stats : appStats.getEngineStats().getMsgTypeStatsEmptyIfNull()) {
                    if (stats.getMessageFactoryId() != -1 || stats.getMessageTypeId() != 1) continue;
                    msgTypeStats = stats;
                    continue block0;
                }
            }
            System.out.println("Message type " + (msgTypeStats == null ? "NOT" : "WERE") + " reported on heartbeat: " + this.heartbeatCount);
            if (this.heartbeatCount == 1) {
                return;
            }
            if (this.heartbeatCount == 2 || this.inactiveFrequency > 0 && this.heartbeatCount % this.inactiveFrequency == 0) {
                if (msgTypeStats == null) {
                    this.heartbeatValidationError = "Heartbeat 2 should have message type stats for Message, but none found";
                    this.done = true;
                    this.doneLatch.countDown();
                }
            } else if (msgTypeStats != null) {
                this.heartbeatValidationError = "Heartbeat " + this.heartbeatCount + " should not have message type stats for Message, but got " + msgTypeStats.toString();
                this.done = true;
                this.doneLatch.countDown();
            }
            if (this.heartbeatCount > this.heartbeatsToValidate) {
                this.done = true;
                this.doneLatch.countDown();
            }
        }

        @EventHandler
        public final void onMessage(Message message) throws InterruptedException {
            this.firstHeartbeatLatch.await(20L, TimeUnit.SECONDS);
            this.startLatch.countDown();
        }

        public final void testInactiveMessageTypeStatsIncluded() throws InterruptedException {
            this.engine.injectMessage((IRogMessage)Message.create());
            this.doneLatch.await((long)this.heartbeatsToValidate * this.heartbeatInterval * 2L, TimeUnit.SECONDS);
            if (this.heartbeatValidationError != null) {
                Assert.fail((String)this.heartbeatValidationError);
            } else if (!this.done) {
                Assert.fail((String)"Didn't receive expected heartbeats (timeout?)");
            }
        }
    }

    public static final class HeartbeatDispatchPoolDisablementTestApp {
        volatile int heartbeatCount;
        public volatile boolean foundPoolStats;

        @EventHandler
        public final void onHeartbeat(SrvMonHeartbeatMessage message) {
            ++this.heartbeatCount;
            if (message.getPoolStatsEmptyIfNull().length > 0) {
                this.foundPoolStats = true;
            }
            IOBuffer buffer = message.serializeToIOBuffer(false);
            SrvMonHeartbeatMessage toSend = SrvMonHeartbeatMessage.create();
            toSend.deserializeFromByteBuffer(buffer.takeBuffer());
            SrvMonHeartbeatMessage toLog = SrvMonHeartbeatMessage.create();
            toLog.deserializeFromByteBuffer(buffer.releaseBuffer().takeBuffer());
            toSend.dispose();
            toLog.dispose();
            buffer.releaseBuffer().dispose();
        }
    }

    public static final class PoolDepletionHeartbeatDispatchTestApp {
        final PooledStringField.Factory factory;
        private volatile SrvMonPoolStats[] reportedStats = new SrvMonPoolStats[25];
        private volatile int heartbeatCount = 0;
        CountDownLatch heartbeatLatch = new CountDownLatch(1);
        private volatile String expectation = null;
        private Exception failure;

        public PoolDepletionHeartbeatDispatchTestApp() {
            this.factory = PooledStringField.newFactory((String)"testpool", (int)16, (boolean)true, (int)100, (boolean)false, (boolean)false);
        }

        @EventHandler
        public void onHeartBeat(SrvMonHeartbeatMessage message) {
            if (this.failure == null && this.heartbeatCount < this.reportedStats.length) {
                for (SrvMonPoolStats poolStats : message.getPoolStatsEmptyIfNull()) {
                    if (!poolStats.getKey().startsWith(this.factory.getPool().key())) continue;
                    this.reportedStats[this.heartbeatCount] = poolStats.acquire();
                    break;
                }
                System.out.println("RECEIVED HEARTBEAT #" + (this.heartbeatCount + 1));
                if (this.reportedStats[this.heartbeatCount] != null) {
                    if (this.expectation != null) {
                        System.out.println(" REPORTED (" + this.expectation + ") reported size " + this.reportedStats[this.heartbeatCount].getSize() + ", misses: " + this.reportedStats[this.heartbeatCount].getMisses());
                    } else {
                        System.out.println(" UNEXPECTEDLY REPORTED as size " + this.reportedStats[this.heartbeatCount].getSize() + " misses: " + this.reportedStats[this.heartbeatCount].getMisses());
                        this.failure = new Exception("HEARTBEAT #" + (this.heartbeatCount + 1) + " WAS UNEXPECTEDLY REPORTED as " + this.reportedStats[this.heartbeatCount].getSize() + " misses: " + this.reportedStats[this.heartbeatCount].getMisses());
                        this.heartbeatLatch.countDown();
                    }
                    if (this.reportedStats[this.heartbeatCount].getPreallocated() != 100) {
                        this.failure = new Exception("Preallocation count was expected to be 100");
                        this.heartbeatLatch.countDown();
                    }
                } else if (this.expectation != null) {
                    System.out.println(" UNEXPECTEDLY NOT REPORTED: " + this.expectation);
                    this.failure = new Exception("HEARTBEAT #" + (this.heartbeatCount + 1) + " UNEXPECTEDLY NOT REPORTED: " + this.expectation);
                    this.heartbeatLatch.countDown();
                } else {
                    System.out.println(" NOT REPORTED (as expected)");
                }
                if (this.heartbeatCount % 2 == 0) {
                    for (int i = 0; i < 10; ++i) {
                        this.factory.create();
                    }
                    int size = this.factory.getPool().size();
                    System.out.println(" Took 5 elements, new size: " + size + " remaining");
                    this.expectation = this.factory.getPool().stats().misses() > 0L ? "Expected pool to be reported due to miss" : (size % 20 == 0 ? "Expected pool to be reported due to threshold at " + size : null);
                } else {
                    this.expectation = null;
                }
            }
            if (++this.heartbeatCount == this.reportedStats.length) {
                this.heartbeatLatch.countDown();
            }
        }

        public void waitForHeartbeats(long seconds) throws Exception {
            if (!this.heartbeatLatch.await(seconds, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timed out waiting for hearbeats");
            } else if (this.failure != null) {
                throw this.failure;
            }
        }
    }

    public static final class HeartbeatDispatchTestApp
    extends HeartbeatDispatchTestAppBase {
        @AppStat
        IStats.Counter numHeartbeats = StatsFactory.createCounterStat((String)"Heartbeats Received");
        @AppStat
        IStats.Counter inputMxQueueDepth = StatsFactory.createCounterStat((String)"Input Queue Depth");
        @AppStat
        BooleanGauge aBooleanGauge = new BooleanGauge("An boolean Gauge"){

            public boolean getBooleanValue() {
                return true;
            }
        };
        @AppStat
        ByteGauge aByteGauge = new ByteGauge("An byte Gauge"){

            public byte getByteValue() {
                return 1;
            }
        };
        @AppStat
        ShortGauge aShortGauge = new ShortGauge("An short Gauge"){

            public short getShortValue() {
                return 2;
            }
        };
        @AppStat
        IntGauge anIntGauge = new IntGauge("An int Gauge"){

            public int getIntValue() {
                return 4;
            }
        };
        @AppStat
        LongGauge aLongGauge = new LongGauge("An long Gauge"){

            public long getLongValue() {
                return 5L;
            }
        };
        @AppStat
        FloatGauge aFloatGauge = new FloatGauge("A float Gauge"){

            public float getFloatValue() {
                return 2.345f;
            }
        };
        @AppStat
        DoubleGauge aDoubleGauge = new DoubleGauge("A double Gauge"){

            public double getDoubleValue() {
                return 2.345;
            }
        };
        @AppStat
        CharGauge aCharGauge = new CharGauge("A char Gauge"){

            public char getCharValue() {
                return 'c';
            }
        };
        @AppStat
        StringGauge aStringGauge = new StringGauge("A string Gauge"){

            public XString getStringValue() {
                return XStringFieldStat;
            }
        };
        @AppStat
        private boolean booleanFieldStat = true;
        @AppStat
        private byte byteFieldStat = 1;
        @AppStat
        private short shortFieldStat = (short)2;
        @AppStat
        private int intFieldStat = 3;
        @AppStat
        private long longFieldStat = 4L;
        @AppStat
        private float floatFieldStat = 5.123f;
        @AppStat
        private double doubleFieldStat = 6.123;
        @AppStat
        private char charFieldStat = (char)97;
        @AppStat
        private String stringFieldStat = "StringField";
        @AppStat
        private XString XStringFieldStat = XFactory.createXString((String)"XStringField");
        @AppStat(name="A Null Boolean")
        private Boolean nullBooleanFieldStat;
        @AppStat(name="A Null Byte")
        private Byte nullbyteFieldStat;
        @AppStat(name="A Null Short")
        private Short nullshortFieldStat;
        @AppStat(name="A Null Integer")
        private Integer nullintFieldStat;
        @AppStat(name="A Null Long")
        private Long nulllongFieldStat;
        @AppStat(name="A Null Boolean")
        private Float nullfloatFieldStat;
        @AppStat(name="A Null Double")
        private Double nulldoubleFieldStat;
        @AppStat(name="A Null Character")
        private Character nullcharFieldStat;
        @AppStat(name="A Null String")
        private String nullstringFieldStat;
        @AppStat(name="A Null XString")
        private XString nullXStringFieldStat;
        CountDownLatch heartbeatLatch = new CountDownLatch(1);
        int collectionIndex = 0;
        private volatile long[] collectedCounts = new long[5];
        volatile long lastScheduleQueueSize = -1L;
        volatile long lastLastDecongested = -1L;
        volatile long lastMaxFeederConcurrency = -1L;
        private AepEngineDescriptor engineDescriptor;

        @EventHandler
        public void onHeartbeat(SrvMonHeartbeatMessage message) {
            for (SrvMonAppStats appStats : message.getAppsStats()) {
                if (!appStats.getAppName().equals(this.engineDescriptor.getName())) continue;
                for (SrvMonUserCounterStat counter : appStats.getUserStats().getCounters()) {
                    if (!counter.getName().equalsIgnoreCase(this.numHeartbeats.getName())) continue;
                    if (this.collectionIndex < this.collectedCounts.length) {
                        this.collectedCounts[this.collectionIndex++] = counter.getCount();
                    }
                    this.numHeartbeats.increment();
                }
                SrvMonDisruptorStats disruptorStats = appStats.getEventMultiplexerStats().getDisruptorStats();
                this.inputMxQueueDepth.increment(disruptorStats.getCapacity() - disruptorStats.getRemaining());
                for (SrvMonAppEventMultiplexerFeederQueueStats feederStat : appStats.getEventMultiplexerStats().getFeederQueueStats()) {
                    this.inputMxQueueDepth.increment(feederStat.getSize());
                }
                this.lastScheduleQueueSize = appStats.getEventMultiplexerStats().getScheduleQueueSize();
                this.lastMaxFeederConcurrency = appStats.getEventMultiplexerStats().getMaxConcurrency();
                this.lastLastDecongested = appStats.getEventMultiplexerStats().getLastDecongested();
            }
            if (this.collectionIndex == this.collectedCounts.length) {
                this.heartbeatLatch.countDown();
            }
        }

        public boolean waitForHeartbeat(long seconds) throws InterruptedException {
            return this.heartbeatLatch.await(seconds, TimeUnit.SECONDS);
        }

        @Override
        protected void onEngineDescriptorInjected(AepEngineDescriptor descriptor) throws Exception {
            this.engineDescriptor = descriptor;
            StoreDescriptor storeDescriptor = StoreDescriptor.create((String)(descriptor.getName() + "App"));
            StoreReplicatorDescriptor replicatorDescriptor = StoreReplicatorDescriptor.create((String)(descriptor.getName() + "Replicator"));
            replicatorDescriptor.save();
            storeDescriptor.setReplicator(replicatorDescriptor.getName());
            StorePersisterDescriptor persisterDescriptor = StorePersisterDescriptor.create((String)(descriptor.getName() + "Persister"), (String)RogLog.class.getName());
            persisterDescriptor.setProperty("storeRoot", XRuntime.getDataDirectory() + "/" + descriptor.getName() + "Server");
            persisterDescriptor.setProperty("initialLogLength", ".00001");
            persisterDescriptor.save();
            storeDescriptor.setPersister(persisterDescriptor.getName());
            storeDescriptor.save();
            this.engineDescriptor.setStore(storeDescriptor.getName());
            descriptor.setCaptureEventLatencyStats(true);
            descriptor.setCaptureMessageTypeStats(true);
            descriptor.setCaptureTransactionLatencyStats(true);
            descriptor.setOutboundMessageLoggingPolicy(AepEngine.OutboundMessageLoggingPolicy.UseDedicated);
        }

        @EventHandler
        public void onMessagingStarted(AepMessagingStartedEvent event) {
            this.engine.injectMessage(AepEngineTestMessage.create((AepEngineTestObject.EncodingType)AepEngineTestObject.EncodingType.Xbuf).getMessage());
            this.engine.scheduleMessage(AepEngineTestMessage.create((AepEngineTestObject.EncodingType)AepEngineTestObject.EncodingType.Xbuf).getMessage(), 10000, AepScheduleEvent.HAPolicy.Cancel);
        }

        @AppStat(name="A Boolean Method Stat")
        private final boolean getBoolean() {
            return true;
        }

        @AppStat(name="A Byte Method Stat")
        private final byte getByte() {
            return 1;
        }

        @AppStat(name="A Short Method Stat")
        private final short getShort() {
            return 2;
        }

        @AppStat(name="A Int Method Stat")
        private final int getInt() {
            return 3;
        }

        @AppStat(name="A Long Method Stat")
        private final long getLong() {
            return 4L;
        }

        @AppStat(name="A Float Method Stat")
        private final float getFloat() {
            return 5.456f;
        }

        @AppStat(name="A Double Method Stat")
        private final double getDouble() {
            return 6.789;
        }

        @AppStat(name="A String Method Stat")
        private final String getString() {
            return "A String!";
        }

        @AppStat(name="A XString Method Stat")
        private final XString getXString() {
            return this.XStringFieldStat;
        }

        @AppStat(name="A null Boolean Method Stat")
        private final Boolean getNullBoolean() {
            return null;
        }

        @AppStat(name="A null Byte Method Stat")
        private final Byte getNullByte() {
            return null;
        }

        @AppStat(name="A null Short Method Stat")
        private final Short getNullShort() {
            return null;
        }

        @AppStat(name="A null Int Method Stat")
        private final Integer getNullInt() {
            return null;
        }

        @AppStat(name="A null Long Method Stat")
        private final Long getNullLong() {
            return null;
        }

        @AppStat(name="A null Float Method Stat")
        private final Float getNullFloat() {
            return null;
        }

        @AppStat(name="A null Double Method Stat")
        private final Double getNullDouble() {
            return null;
        }

        @AppStat(name="A null String Method Stat")
        private final String getNullString() {
            return null;
        }

        @AppStat(name="A null XString Method")
        private final XString getNullXString() {
            return null;
        }

        @AppStat(name="An unsupported Type Method")
        private final Date getUnsupportedType() {
            return new Date();
        }
    }

    public static class HeartbeatDispatchTestAppBase {
        protected AepEngine engine;
        private MessageChannel outChannel;
        @AppStat(name="Private Base Class Int Field")
        private int privateBaseClassIntField = 3;
        @AppStat(name="Protected Base Class Int Field")
        private int protectedBaseClassIntField = 3;
        @AppStat(name="Public Base Class Int Field")
        public int publicBaseClassIntField = 3;

        @AppStat(name="Private Base Class Int Method")
        private int getPrivateBaseClassField() {
            return this.privateBaseClassIntField;
        }

        @AppStat(name="Public Base Class Int Method")
        public int getPublicBaseClassField() {
            return this.publicBaseClassIntField;
        }

        @AppStat(name="Protected Base Class Int Method")
        public int getProtectedBaseClassField() {
            return this.protectedBaseClassIntField;
        }

        @AppInjectionPoint
        public final void setEngineDescriptor(AepEngineDescriptor descriptor) throws Exception {
            MessageBusDescriptor busDescriptor = MessageBusDescriptor.create((String)descriptor.getName());
            busDescriptor.setProviderConfig("loopback://" + descriptor.getName());
            MessageChannelDescriptor inChannel = MessageChannelDescriptor.create((String)"in", (MessageBusDescriptor)busDescriptor);
            busDescriptor.addChannel(inChannel);
            MessageChannelDescriptor outChannel = MessageChannelDescriptor.create((String)"out", (MessageBusDescriptor)busDescriptor);
            busDescriptor.addChannel(outChannel);
            busDescriptor.save();
            descriptor.addBus(busDescriptor.getName());
            descriptor.addChannel(descriptor.getName(), "in", AepEngineDescriptor.ChannelConfig.from((String)"join=true"));
            descriptor.addChannel(descriptor.getName(), "out", AepEngineDescriptor.ChannelConfig.from((String)"join=false"));
            this.onEngineDescriptorInjected(descriptor);
        }

        protected void onEngineDescriptorInjected(AepEngineDescriptor descriptor) throws Exception {
        }

        @AppInjectionPoint
        public final void injectEngine(AepEngine engine) throws Exception {
            this.engine = engine;
            this.onEngineInjected(engine);
        }

        protected void onEngineInjected(AepEngine descriptor) throws Exception {
        }

        @EventHandler
        public void onMessagingStarting(AepMessagingPrestartEvent starting) {
            starting.setFirstMessage((MessageView)Message.create());
        }

        @EventHandler
        public void onChannelUp(AepChannelUpEvent event) {
            if (event.getMessageChannel().getName().equals("out")) {
                this.outChannel = event.getMessageChannel();
            }
        }

        @EventHandler
        public void onMessage(Message message) {
            this.engine.sendMessage(this.outChannel, (IRogMessage)Message.create());
        }
    }

    private static final class ServerRunner
    extends Thread
    implements IDmnControllerEventHandler {
        final SrvController controller;
        private boolean startComplete;
        private Throwable startResult;

        ServerRunner(SrvConfigDescriptor descriptor) {
            this.controller = SrvController.getInstance(descriptor);
            this.controller.setEventHandler(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void waitForServerToStart() throws Exception {
            ServerRunner serverRunner = this;
            synchronized (serverRunner) {
                while (!this.startComplete) {
                    this.wait(30000L);
                }
                Assert.assertTrue((boolean)this.startComplete);
                Assert.assertNull((Object)this.startResult);
            }
        }

        final void shutdown() {
            this.controller.stop();
        }

        @Override
        public void run() {
            this.controller.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEvent(int type, Object data) {
            if (type == 4) {
                ServerRunner serverRunner = this;
                synchronized (serverRunner) {
                    this.startComplete = true;
                    this.startResult = (Throwable)data;
                    this.notifyAll();
                }
            }
        }
    }
}

