/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.test.unit;

import com.neeve.config.ConfigRepositoryFactory;
import com.neeve.server.config.ESrvConfigException;
import com.neeve.server.config.SrvConfigDescriptor;
import org.junit.Assert;
import org.junit.Test;

public class SrvConfigDescriptorTest {
    @Test
    public void testNullDiscoveryDesciptor() throws ESrvConfigException {
        SrvConfigDescriptor descriptor = SrvConfigDescriptor.create("testNullDiscoveryDesciptor");
        descriptor.setDiscoveryDescriptor(null);
        descriptor.save(ConfigRepositoryFactory.getInstance().getDefaultRepository());
        SrvConfigDescriptor descriptor2 = SrvConfigDescriptor.load(ConfigRepositoryFactory.getInstance().getDefaultRepository(), "testNullDiscoveryDesciptor");
        Assert.assertEquals((String)"discoveryDesriptor should be null", null, (Object)descriptor2.getDiscoveryDescriptor());
        descriptor.setDiscoveryDescriptor("foo://foo");
        descriptor.save();
        descriptor2 = SrvConfigDescriptor.load(ConfigRepositoryFactory.getInstance().getDefaultRepository(), "testNullDiscoveryDesciptor");
        Assert.assertEquals((String)"discoveryDesriptor should match saved value", (Object)descriptor.getDiscoveryDescriptor(), (Object)descriptor2.getDiscoveryDescriptor());
        descriptor.setDiscoveryDescriptor(null);
        descriptor.save();
        descriptor2 = SrvConfigDescriptor.load(ConfigRepositoryFactory.getInstance().getDefaultRepository(), "testNullDiscoveryDesciptor");
        Assert.assertEquals((String)"discoveryDesriptor should be null after update to null", null, (Object)descriptor2.getDiscoveryDescriptor());
    }

    @Test
    public void testHearbeatLoggingForDescriptor() throws ESrvConfigException {
        SrvConfigDescriptor descriptor = SrvConfigDescriptor.create("testHeartbeatLogging");
        descriptor.setHeartbeatLoggingProperty("enabled", "true");
        descriptor.setHeartbeatLoggingProperty("initialLogSize", ".001");
        descriptor.setHeartbeatLoggingProperty("detachedWrite", "true");
        descriptor.save(ConfigRepositoryFactory.getInstance().getDefaultRepository());
        SrvConfigDescriptor descriptor2 = SrvConfigDescriptor.load(ConfigRepositoryFactory.getInstance().getDefaultRepository(), "testHeartbeatLogging");
        for (Object key : descriptor.getHeartbeatLoggingProperties().keySet()) {
            Assert.assertEquals((String)"Wrong saved descriptor property", (Object)descriptor.getHeartbeatLoggingProperty(key.toString()), (Object)descriptor2.getHeartbeatLoggingProperty(key.toString()));
        }
        Assert.assertEquals((String)"Saved heartbeat properties has wrong number of properties", (long)descriptor.getHeartbeatLoggingProperties().size(), (long)descriptor2.getHeartbeatLoggingProperties().size());
        descriptor.setHeartbeatLoggingProperties(null);
        descriptor.save();
        descriptor2 = SrvConfigDescriptor.load(ConfigRepositoryFactory.getInstance().getDefaultRepository(), "testHeartbeatLogging");
        Assert.assertTrue((String)"HeartbeatLogging should be empty after update to null", (boolean)descriptor2.getHeartbeatLoggingProperties().isEmpty());
    }
}

